/**
 * 转换 presetTableStyles 为对象方便处理
 */

import {readFileSync, writeFileSync} from 'fs';
import prettier from 'prettier';
import {xml2json} from '../src/util/xml';
import {TableStyleDef} from '../src/excel/types/TableStyleDef';
import {parseTableStyleDef} from '../src/excel/io/excel/parseTableStyleDef';

async function convert() {
  const presetFileNode = await xml2json(
    readFileSync(
      './OfficeOpenXML-SpreadsheetMLStyles/presetTableStyles.xml',
      'utf-8'
    )
  );
  const presetTableStyles: Record<string, TableStyleDef> = {};
  for (const tableStyle of presetFileNode.children) {
    const styleName = tableStyle.tag;
    const styleDef = parseTableStyleDef(tableStyle);

    if (styleDef) {
      presetTableStyles[styleName] = styleDef;
    }
  }

  let outputFile: string[] = [
    '/** generated by tools/convertPresetTableStyle.ts, do not edit */',
    `import {TableStyleDef} from '../../../types/TableStyleDef';`
  ];
  outputFile.push(
    'export const presetTableStyles: Record<string, TableStyleDef> = ' +
      JSON.stringify(presetTableStyles, null, 2) +
      ';'
  );

  prettier.resolveConfig('../../../.prettierrc').then(options => {
    const formatted = prettier.format(outputFile.join('\n'), {
      ...options,
      parser: 'typescript'
    });
    writeFileSync(
      '../src/excel/io/excel/preset/presetTableStyles.ts',
      formatted
    );
  });
}

convert();
