/**
 * 生成图标定义，不想依赖任何打包工具，所以自己生成
 */
import {readFileSync, writeFileSync} from 'fs';
import prettier from 'prettier';

const icons = [
  'down',
  'side',
  'up',
  'downGray',
  'sideGray',
  'upGray',
  'flagRed',
  'flagYellow',
  'flagGreen',
  'diamondRed',
  'triangleYellow',
  'circleGreen',
  'crossRed',
  'exclamationYellow',
  'checkGreen',
  'crossSymbolRed',
  'exclamationSymbolYellow',
  'checkSymbolGreen',
  'circleRed',
  'circleYellow',
  'trafficLightRed',
  'trafficLightYellow',
  'trafficLightGreen',
  'downIncline',
  'upIncline',
  'downInclineGray',
  'upInclineGray',
  'oneFilledBars',
  'twoFilledBars',
  'threeFilledBars',
  'fourFilledBars',
  'circleBlack',
  'circleGray',
  'circleLightRed',
  'circleWhite',
  'circleThreeWhiteQuarters',
  'circleTwoWhiteQuarters',
  'circleOneWhiteQuarter',
  'zeroFilledBars'
];

const iconContents: Record<string, string> = {};

for (const icon of icons) {
  const content = readFileSync(
    `../src/excel/io/excel/preset/icons/${icon}.svg`,
    'utf-8'
  );
  iconContents[icon] =
    'data:image/svg+xml;base64,' +
    Buffer.from(content, 'utf8').toString('base64');
}

const outputFile = `
/** generated by genPresetIcons.ts, do not edit */

export type IconNames = ${icons.map(icon => `'${icon}'`).join(' | ')};

export const presetIcons: Record<IconNames, string> = ${JSON.stringify(
  iconContents,
  null,
  2
)};
`;

prettier.resolveConfig('../../../.prettierrc').then(options => {
  const formatted = prettier.format(outputFile, {
    ...options,
    parser: 'typescript'
  });
  writeFileSync('../src/excel/io/excel/preset/presetIcons.ts', formatted);
});
