# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [0.9.0](https://github.com/blacha/diablo2/compare/v0.8.0...v0.9.0) (2021-10-22)


### Bug Fixes

* **map:** bundle as .cjs so nodejs will load the cli while under esm mode ([09c387d](https://github.com/blacha/diablo2/commit/09c387da36e0e8affc58ad83ac55253743e1f8f9))
* **map:** correctly parse the seed as a unsigned int not a signed int ([d5efb34](https://github.com/blacha/diablo2/commit/d5efb34de3dd6bc6410bfbd04a2703e7367e46cc))
* **map:** log unsigned ints as hex ([45943ff](https://github.com/blacha/diablo2/commit/45943ff74070498bf08ad2d4ff1aec5d176bc2be))
* **map:** unload act if seed or difficulty changes ([9293907](https://github.com/blacha/diablo2/commit/9293907498bf5a73df6ca9138b7849230af1cc33))


### Features

* **map:** add den of evil as good exit ([50634e0](https://github.com/blacha/diablo2/commit/50634e065ba8fc3f80a0168d6c29b3622e94f915))
* **map:** add isGoodExit for common exits which are important ([2925ed3](https://github.com/blacha/diablo2/commit/2925ed323f0d274ef909e4f91ebf1ff65c68bd0a))
* **map:** restart map process quickly if it crashes rather than waiting for timeout ([fed0797](https://github.com/blacha/diablo2/commit/fed07970bcc178b7c36c5ee43b0d2c64079f4bf4))
* **map:** start multiple map processes if required ([a2202ff](https://github.com/blacha/diablo2/commit/a2202ff644240316c8f12bf48cd903fdb51644ce))
* **viewer:** add more doors ([5ede0bb](https://github.com/blacha/diablo2/commit/5ede0bbecdc70af990be84b1e413f8f363fdb351))
* **viewer:** honor pitch and bearing in addition to zoom ([#188](https://github.com/blacha/diablo2/issues/188)) ([fde7fee](https://github.com/blacha/diablo2/commit/fde7fee30d11bd119dcfa752e16bd1ced4b261db))
* **viewer:** include all object properties in rendering ([ccdc3f1](https://github.com/blacha/diablo2/commit/ccdc3f1d3cd12644cc3074aaa30500358ff7367f))





# [0.8.0](https://github.com/blacha/diablo2/compare/v0.7.0...v0.8.0) (2021-10-17)


### Bug Fixes

* **bintools:** log the correct name for objects ([079b5ac](https://github.com/blacha/diablo2/commit/079b5ac13d80f13f2decfba74c527c817386d5c1))
* **map:** correct command path for docker ([b86169a](https://github.com/blacha/diablo2/commit/b86169a035bfa617c58ceb871117ffacaf8f0658))
* **map:** correctly debug mapId ([369ea47](https://github.com/blacha/diablo2/commit/369ea4779222abab3fd211c7f98e3801117051d7))
* **map:** do not offset locations ([06453e9](https://github.com/blacha/diablo2/commit/06453e9baffba8a91526808008630ce975f58088))
* **map:** make the view hight slightly smaller to prevent scroll bars ([ad55299](https://github.com/blacha/diablo2/commit/ad552995f6e52c33741cd21691de5df19cf76ca7))
* **map:** only load the mpq data once ([e0c9f8c](https://github.com/blacha/diablo2/commit/e0c9f8cf6a3da1b6263a6964bf710d00918e87c6))


### Features

* **bintools:** simple mpq cli to load and explore the d2 mpqs ([1c7e86e](https://github.com/blacha/diablo2/commit/1c7e86e2f1b871d2d59b72604e791c98201ae31c))
* **map:** include waypoint names ([a6b421c](https://github.com/blacha/diablo2/commit/a6b421cd80de15ff5ec6731fc9b57b9737a67b02))
* **map:** offset super unique names slightly ([bf5b38f](https://github.com/blacha/diablo2/commit/bf5b38f306a2930551469003dc54fccc8574a1f0))
* **map:** render super uniques and names on the map ([9cb2c09](https://github.com/blacha/diablo2/commit/9cb2c09c6de9693d0ae5aa2d97a9dd8aef1f069f))
* **map:** show unknown objects on the map ([44132e2](https://github.com/blacha/diablo2/commit/44132e282546c1c3e79c1fa3dd72c911b02c71f7))
* **map:** since maps are generated by zone render more maps before restarting ([3d4b45f](https://github.com/blacha/diablo2/commit/3d4b45f21b5d9e47cc787eec15679cde3cbcae47))
* **map:** split the components so the server and viewer can be imported easier ([7a44862](https://github.com/blacha/diablo2/commit/7a44862a3670804264f267d15beed8bcf57326ce))
* **map:** support multiple command locations ([d7cff17](https://github.com/blacha/diablo2/commit/d7cff1789e386db5ac66082827a0ca5d40bd7374))
* split map into map server and map viewer ([#186](https://github.com/blacha/diablo2/issues/186)) ([b92efb9](https://github.com/blacha/diablo2/commit/b92efb9c012527fc4d9b36eb286dadcbc52f0be9))
* **viewer:** make things look a bit nicer ([a9f3414](https://github.com/blacha/diablo2/commit/a9f3414d73bca5b4a90822bcf6a04603c18cbb44))


### BREAKING CHANGES

* this splits the map viewer out into @diablo2/viewer and moves a lot of types around





# [0.7.0](https://github.com/blacha/diablo2/compare/v0.6.0...v0.7.0) (2021-10-16)


### Bug Fixes

* **data:** super unique ids are not quite right ([8b71cb0](https://github.com/blacha/diablo2/commit/8b71cb0baaf902d162fc6342761f70f97a1baa5f))


### Features

* **map:** expand cli usage examples ([1c2f8fe](https://github.com/blacha/diablo2/commit/1c2f8fe98e6275eac56746c4698a0598c72bc519))
* **map:** expose the location of super uniques ([93f1ea9](https://github.com/blacha/diablo2/commit/93f1ea96d4b8e1f312d518bc1f554d8162ef533b))
* **map:** improve map name from mpq ([ef395b5](https://github.com/blacha/diablo2/commit/ef395b5deabfb57bbbeefd29a0e53381a2ab0cbf))
* **map:** include operate code for objects ([12e6cc2](https://github.com/blacha/diablo2/commit/12e6cc2b3b22b0d337458caa8b2200a2b8497673))
* **map:** load object/exit/level names from mpq and add to map ([#185](https://github.com/blacha/diablo2/issues/185)) ([5510753](https://github.com/blacha/diablo2/commit/5510753d0f67fc78a534a4f67784c420fcd5a2a6))
* **map:** remove more unusued objects ([fd6af41](https://github.com/blacha/diablo2/commit/fd6af41c086f6ddeab1f869e6bacd476927dca79))
* **map:** render map to png using canvas ([#160](https://github.com/blacha/diablo2/issues/160)) ([90c36a1](https://github.com/blacha/diablo2/commit/90c36a1cdc328f8430921c9a42bd06f1bd64d0a0))
* **map:** start exporting doors ([997404a](https://github.com/blacha/diablo2/commit/997404abc97cd88885b32f97adf41be89e88fc11))
* **map:** use the new act endpoint ([90921c3](https://github.com/blacha/diablo2/commit/90921c368469d87f3e417c30612d88401272e0d7))
* **memory:** die after too many errors ([4d1fab2](https://github.com/blacha/diablo2/commit/4d1fab223e21f08a5f636ad3ceb0911570d3bb7a))





# [0.6.0](https://github.com/blacha/diablo2/compare/v0.5.0...v0.6.0) (2021-10-13)


### Bug Fixes

* correct broken scanner ([4ec512d](https://github.com/blacha/diablo2/commit/4ec512d094c609f91c01eca3b56d6800b4cb3ee1))
* **map:** die if offsets cannot be defined ([ab61cfd](https://github.com/blacha/diablo2/commit/ab61cfdb377a72cba06978bafe87dab55a2730c4))
* **map:** force a flush after log lines are printed ([9c9a662](https://github.com/blacha/diablo2/commit/9c9a662b5ebebeaad3b457567aaea50969d0b08f))
* **map:** increase timeout to 30seconds for map generation ([5053d46](https://github.com/blacha/diablo2/commit/5053d46a717690dbebd5af69d49fdbe876a3f18d))
* **memory:** do a full memory scan until we know of a good location ([fb46c49](https://github.com/blacha/diablo2/commit/fb46c4972b5570caf255e4110e86b1deae6f36a9))
* **memory:** do not crash if cannot read pid ([c7a6c20](https://github.com/blacha/diablo2/commit/c7a6c205e6a23a89542ecda5b65fc3a7331fbbf4))


### Features

* **data:** add more known attributes ([a7217ff](https://github.com/blacha/diablo2/commit/a7217fff703861b5c9b0867c14690c739048fdf8))
* find map seed from a player name ([#124](https://github.com/blacha/diablo2/issues/124)) ([4763715](https://github.com/blacha/diablo2/commit/476371515e874024bbab730d65dd5319157c07b6))
* **map:** add some debug timings into log generation ([3976008](https://github.com/blacha/diablo2/commit/397600879555799ebd0fd1fe277f29db57371c76))
* **map:** include git commit and hash in cli ([#159](https://github.com/blacha/diablo2/issues/159)) ([04ac188](https://github.com/blacha/diablo2/commit/04ac188a816f44ae5e45f407ec12d9249839016a))
* **map:** serve the index.html/js from the container ([0b0751c](https://github.com/blacha/diablo2/commit/0b0751cb91bcc5f20d3ed3c525b1baed72211628))
* **map:** show exits and waypoints on the map ([#157](https://github.com/blacha/diablo2/issues/157)) ([a0d335f](https://github.com/blacha/diablo2/commit/a0d335f1640c99c04222ab891c668413c50e17b9))
* **map:** support diablo2 client v1.13c ([#158](https://github.com/blacha/diablo2/issues/158)) ([2b248d9](https://github.com/blacha/diablo2/commit/2b248d93aaa867799c287bfdfc6aefbbc7245833))
* **map:** support generating just a single act's data ([24d69ba](https://github.com/blacha/diablo2/commit/24d69ba941b18e69494fa4c46d739c211a773201))
* **memory:** track player xp ([008f920](https://github.com/blacha/diablo2/commit/008f9207472bf7588c9ffc25aef5e284a8534cbc))
* **memory:** track where the last good memory addresses are ([5211f0a](https://github.com/blacha/diablo2/commit/5211f0a90c6914963d48f6d9d3dc182e6beebe1e))
* track where the last address was and start from that point ([fc1d397](https://github.com/blacha/diablo2/commit/fc1d39772c957410c1600448127a418ec06a5aa3))


### Reverts

* Revert "wip: look at near by rooms" ([150dede](https://github.com/blacha/diablo2/commit/150dede7966318f4c2ae7ea65e120236ad149c8a))





# [0.5.0](https://github.com/blacha/diablo2/compare/v0.4.0...v0.5.0) (2021-03-26)


### Bug Fixes

* **packets/pd2:** correct parsing of packet 0x56 ([459ef8a](https://github.com/blacha/diablo2/commit/459ef8a7181a08ebf0cb76ea778a4703240a3554))
* expose npc enchants out of game state ([2a933c2](https://github.com/blacha/diablo2/commit/2a933c2fae9eae13272c2e115f0a444116c88f98))
* **bintools:** parsing of tbl files where the hash count and index count differ ([77d2f85](https://github.com/blacha/diablo2/commit/77d2f8504dabf76ac73c23ac0efc380bfe2eb1a1))
* **core:** skip packet 0x2b as we cannot parse it right now ([4eb2001](https://github.com/blacha/diablo2/commit/4eb2001e291aef70a27842cd1d60c1da19268503))
* **map:** skip mapid 150 on pd2 as it doesnt seem to work yet ([a268073](https://github.com/blacha/diablo2/commit/a2680739a8615e01f7562c25a52d35155cb56393))
* **mpq:** allow extraction of uncompressed files ([25edc0c](https://github.com/blacha/diablo2/commit/25edc0c0eb05a77e86f22780cd54a1e138088675))
* **mpq:** correct exploding of implode compressed mpq ([f0e50d7](https://github.com/blacha/diablo2/commit/f0e50d7057bbb6ec77303f13ecaf0184312f87ed))
* **packets:** actually export all the packets ([bc7b6c2](https://github.com/blacha/diablo2/commit/bc7b6c22d60413b9e3d27a9b9aeada341d90011e))
* **sniffer:** force close the game if the session cuts out ([3390faa](https://github.com/blacha/diablo2/commit/3390faa4a7cf777ac3e5b111ce03d0994c4fcf42))


### Features

* **core:** basic game state from packets flowing though it ([#10](https://github.com/blacha/diablo2/issues/10)) ([c052059](https://github.com/blacha/diablo2/commit/c052059bbe2a62957cbfd877016fdabc1affe13c))
* **core:** easier debugging of packet parse failures ([3958f68](https://github.com/blacha/diablo2/commit/3958f68dda26be71163ba97054232ad9a9efe455))
* **core:** expand on game state tracking ([7e6dcc7](https://github.com/blacha/diablo2/commit/7e6dcc77d801e919ddfcd6cb6c3077a1f6dd8073))
* **core:** filter out old objects if they havent been seen in a while ([2a01ea6](https://github.com/blacha/diablo2/commit/2a01ea66eb33d785de8c4332ba690e2c29c5e5fe))
* **core:** improve xp tracking ([6a1e757](https://github.com/blacha/diablo2/commit/6a1e757f4c5e03fbce0ef658ff27813f680eb215))
* **core:** track when monsters die ([6309f29](https://github.com/blacha/diablo2/commit/6309f292446d0d5cd4ba015c7d8d91ad44356398))
* **core:** track when packets are not parsed correctly ([0ed0975](https://github.com/blacha/diablo2/commit/0ed0975b8d56be24d8db4e18942bc4692505e7f8))
* **data:** expose toHex function ([86e6dbd](https://github.com/blacha/diablo2/commit/86e6dbd7147280c25a6150c4d311c83c1199c3d4))
* **mpq:** alias exists to has ([613888f](https://github.com/blacha/diablo2/commit/613888f2e449f7ce4ccdbca6c6dbef000c09202b))
* **packets:** support unknown 0x56 packet for pd2 ([33b25de](https://github.com/blacha/diablo2/commit/33b25dea35335f046730ba5778466ed79da4a041))
* **sniffer:** change packet output location to `packets-${date)-${id}.ndjson` ([108ef99](https://github.com/blacha/diablo2/commit/108ef993efcf648aeb6027f58357da38e1087a4f))
* **sniffer:** include hour in replay filename ([0cabc6d](https://github.com/blacha/diablo2/commit/0cabc6df1e3d37c33708691b6d741f5a2cbbc94c))
* add NpcEnchants to track modifiers to Npcs ([9c602c4](https://github.com/blacha/diablo2/commit/9c602c4dbc8973a5c65dd6659b1f46c44f640da0))
* **sniffer:** expose findLocalIps function ([9c4d1d7](https://github.com/blacha/diablo2/commit/9c4d1d76341bde934b341c9a06500b9d45a5005d))





# [0.4.0](https://github.com/blacha/diablo2/compare/v0.3.0...v0.4.0) (2020-11-06)


### Features

* support both pod and pd2 ([d89f86e](https://github.com/blacha/diablo2/commit/d89f86ed5cd5ce1966ad71f8d10c55f4b09e2add))
* support project diablo2 ([f794865](https://github.com/blacha/diablo2/commit/f79486559a6e0c9a5bb37607d0361fe873500f2c))
* **map:** cache map generations in memory ([24f1bdd](https://github.com/blacha/diablo2/commit/24f1bdd0db415b9246aa9f85b4f16b0e5e045d98))
* **packets:** add missing 0xaa StateAdd packet ([c31f565](https://github.com/blacha/diablo2/commit/c31f5657f6510a8ac2f58170a7984b98a3e002dc))





# [0.3.0](https://github.com/blacha/diablo2/compare/v0.2.1...v0.3.0) (2020-09-20)


### Features

* **bintools:** load data directly from the mpq ([#6](https://github.com/blacha/diablo2/issues/6)) ([d2824f7](https://github.com/blacha/diablo2/commit/d2824f7478a21043de647b733a3cb0532c291cb5))
* **mpq:** allow both / and \ as path separators ([#4](https://github.com/blacha/diablo2/issues/4)) ([c315148](https://github.com/blacha/diablo2/commit/c315148e10f4f89dcc0822e84df57be8f4af5212))
* **mpq:** support encrypted mpq files ([#5](https://github.com/blacha/diablo2/issues/5)) ([45560a1](https://github.com/blacha/diablo2/commit/45560a13e26dc189ac58953c08f5e0176d9c8ede))





## [0.2.1](https://github.com/blacha/diablo2/compare/v0.2.0...v0.2.1) (2020-09-19)

**Note:** Version bump only for package @diablo2/core





# [0.2.0](https://github.com/blacha/diablo2/compare/v0.1.0...v0.2.0) (2020-09-19)


### Bug Fixes

* **packets:** correct typings for binary parser for npc/item packets ([9665ee6](https://github.com/blacha/diablo2/commit/9665ee6945e9b5cf590af3ae8d6e74b58aabe800))
* **packets:** dont error if we do not know the attribute name ([14a3bbd](https://github.com/blacha/diablo2/commit/14a3bbd2871c5187a362681e78b11cceac847361))


### Features

* **mpq:** mpq reader that can extract files from patch_d2.mpq ([#2](https://github.com/blacha/diablo2/issues/2)) ([e4ee39b](https://github.com/blacha/diablo2/commit/e4ee39bd63bd3f6f29c8df4de01aaa9970df234d))
* **sniffer:** allow the sniffer to be init without capturing packets ([20507e8](https://github.com/blacha/diablo2/commit/20507e82d7f0cecb3fc4ee12ad36d2a66af5e0f0))





# 0.1.0 (2020-09-14)


### Bug Fixes

* **map:** allow both Normal.json and 0.json for difficulty ([9835262](https://github.com/blacha/diablo2/commit/98352622ed81b180b63ed150791d73762d98854a))
* **sniffer:** dont automatically dump alll packets ([5a24c61](https://github.com/blacha/diablo2/commit/5a24c6127abaf3be00473604f494e16f4c881a5a))


### Features

* **map:** docker container to render collision maps for most d2 maps ([#1](https://github.com/blacha/diablo2/issues/1)) ([93b09b1](https://github.com/blacha/diablo2/commit/93b09b13df18bd6211a09a9af62ce6c051f9c9e2))
* adding client packets ([2cdf7e3](https://github.com/blacha/diablo2/commit/2cdf7e3e4c13471fcad75f2c31cd008c2ec9c286))
* correctly load lang and parse npcs ([9a82945](https://github.com/blacha/diablo2/commit/9a8294541b0b778449cbf811bed82bae1078379f))
* initial commit ([4e1a573](https://github.com/blacha/diablo2/commit/4e1a573675ebb619b8e3a469b2ae398928cbc25f))
* initial work on binary file parser ([4f16516](https://github.com/blacha/diablo2/commit/4f165169f7294f51a2930690428b18aa1d42fae8))
* load lang files from tbl to parse items ([29eca9a](https://github.com/blacha/diablo2/commit/29eca9a8226b7f3f8155df628bd7772d5e98e48a))
* more packet parsing ([dcc75b8](https://github.com/blacha/diablo2/commit/dcc75b8b9b0d2eaa18f6763a512f39984e12b327))
* parse npcs from packets using mpq data ([2fa03e2](https://github.com/blacha/diablo2/commit/2fa03e23ddc449e4a19ac687d13dc51cd31abbea))
* somewhat working packet parser ([be51126](https://github.com/blacha/diablo2/commit/be511266d7920f234c22bfb1a933a14d1c66b7bc))
* start loading mpq data in to be read by the packet parser ([5745736](https://github.com/blacha/diablo2/commit/5745736b03fa0978a0b0eb420527925fbb3ef1de))
* start parsing monster information ([8a66db3](https://github.com/blacha/diablo2/commit/8a66db3c91f0686d41c73827ca31c493a5fc4c77))
* **binparse:** typesafe binary parser ([5503ce3](https://github.com/blacha/diablo2/commit/5503ce302a597e860ddda608386f17e3e9624579))
