export class Huffman {
  static IndexTable = [
    0x0247, 0x0236, 0x0225, 0x0214, 0x0203, 0x01f2, 0x01e1, 0x01d0, 0x01bf, 0x01ae, 0x019d, 0x018c, 0x017b, 0x016a,
    0x0161, 0x0158, 0x014f, 0x0146, 0x013d, 0x0134, 0x012b, 0x0122, 0x0119, 0x0110, 0x0107, 0x00fe, 0x00f5, 0x00ec,
    0x00e3, 0x00da, 0x00d1, 0x00c8, 0x00bf, 0x00b6, 0x00ad, 0x00a8, 0x00a3, 0x009e, 0x0099, 0x0094, 0x008f, 0x008a,
    0x0085, 0x0080, 0x007b, 0x0076, 0x0071, 0x006c, 0x0069, 0x0066, 0x0063, 0x0060, 0x005d, 0x005a, 0x0057, 0x0054,
    0x0051, 0x004e, 0x004b, 0x0048, 0x0045, 0x0042, 0x003f, 0x003f, 0x003c, 0x003c, 0x0039, 0x0039, 0x0036, 0x0036,
    0x0033, 0x0033, 0x0030, 0x0030, 0x002d, 0x002d, 0x002a, 0x002a, 0x0027, 0x0027, 0x0024, 0x0024, 0x0021, 0x0021,
    0x001e, 0x001e, 0x001b, 0x001b, 0x0018, 0x0018, 0x0015, 0x0015, 0x0012, 0x0012, 0x0012, 0x0012, 0x000f, 0x000f,
    0x000f, 0x000f, 0x000c, 0x000c, 0x000c, 0x000c, 0x0009, 0x0009, 0x0009, 0x0009, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  ];

  static CharacterTable = [
    0x00, 0x00, 0x01, 0x00, 0x01, 0x04, 0x00, 0xff, 0x06, 0x00, 0x14, 0x06, 0x00, 0x13, 0x06, 0x00, 0x05, 0x06, 0x00,
    0x02, 0x06, 0x00, 0x80, 0x07, 0x00, 0x6d, 0x07, 0x00, 0x69, 0x07, 0x00, 0x68, 0x07, 0x00, 0x67, 0x07, 0x00, 0x1e,
    0x07, 0x00, 0x15, 0x07, 0x00, 0x12, 0x07, 0x00, 0x0d, 0x07, 0x00, 0x0a, 0x07, 0x00, 0x08, 0x07, 0x00, 0x07, 0x07,
    0x00, 0x06, 0x07, 0x00, 0x04, 0x07, 0x00, 0x03, 0x07, 0x00, 0x6c, 0x08, 0x00, 0x51, 0x08, 0x00, 0x20, 0x08, 0x00,
    0x1f, 0x08, 0x00, 0x1d, 0x08, 0x00, 0x18, 0x08, 0x00, 0x17, 0x08, 0x00, 0x16, 0x08, 0x00, 0x11, 0x08, 0x00, 0x10,
    0x08, 0x00, 0x0f, 0x08, 0x00, 0x0c, 0x08, 0x00, 0x0b, 0x08, 0x00, 0x09, 0x08, 0x01, 0x96, 0x09, 0x97, 0x09, 0x01,
    0x90, 0x09, 0x95, 0x09, 0x01, 0x64, 0x09, 0x6b, 0x09, 0x01, 0x62, 0x09, 0x63, 0x09, 0x01, 0x56, 0x09, 0x58, 0x09,
    0x01, 0x52, 0x09, 0x55, 0x09, 0x01, 0x4d, 0x09, 0x50, 0x09, 0x01, 0x45, 0x09, 0x4c, 0x09, 0x01, 0x40, 0x09, 0x43,
    0x09, 0x01, 0x31, 0x09, 0x3b, 0x09, 0x01, 0x28, 0x09, 0x30, 0x09, 0x01, 0x1a, 0x09, 0x25, 0x09, 0x01, 0x0e, 0x09,
    0x19, 0x09, 0x02, 0xe2, 0x0a, 0xe8, 0x0a, 0xf0, 0x0a, 0xf8, 0x0a, 0x02, 0xc0, 0x0a, 0xc2, 0x0a, 0xce, 0x0a, 0xe0,
    0x0a, 0x02, 0xa0, 0x0a, 0xa2, 0x0a, 0xb0, 0x0a, 0xb8, 0x0a, 0x02, 0x8a, 0x0a, 0x8f, 0x0a, 0x93, 0x0a, 0x98, 0x0a,
    0x02, 0x81, 0x0a, 0x82, 0x0a, 0x83, 0x0a, 0x89, 0x0a, 0x02, 0x7c, 0x0a, 0x7d, 0x0a, 0x7e, 0x0a, 0x7f, 0x0a, 0x02,
    0x77, 0x0a, 0x78, 0x0a, 0x79, 0x0a, 0x7a, 0x0a, 0x02, 0x73, 0x0a, 0x74, 0x0a, 0x75, 0x0a, 0x76, 0x0a, 0x02, 0x6e,
    0x0a, 0x6f, 0x0a, 0x70, 0x0a, 0x72, 0x0a, 0x02, 0x61, 0x0a, 0x65, 0x0a, 0x66, 0x0a, 0x6a, 0x0a, 0x02, 0x5d, 0x0a,
    0x5e, 0x0a, 0x5f, 0x0a, 0x60, 0x0a, 0x02, 0x57, 0x0a, 0x59, 0x0a, 0x5a, 0x0a, 0x5b, 0x0a, 0x02, 0x4a, 0x0a, 0x4b,
    0x0a, 0x4e, 0x0a, 0x53, 0x0a, 0x02, 0x46, 0x0a, 0x47, 0x0a, 0x48, 0x0a, 0x49, 0x0a, 0x02, 0x3f, 0x0a, 0x41, 0x0a,
    0x42, 0x0a, 0x44, 0x0a, 0x02, 0x3a, 0x0a, 0x3c, 0x0a, 0x3d, 0x0a, 0x3e, 0x0a, 0x02, 0x36, 0x0a, 0x37, 0x0a, 0x38,
    0x0a, 0x39, 0x0a, 0x02, 0x32, 0x0a, 0x33, 0x0a, 0x34, 0x0a, 0x35, 0x0a, 0x02, 0x2b, 0x0a, 0x2c, 0x0a, 0x2d, 0x0a,
    0x2e, 0x0a, 0x02, 0x26, 0x0a, 0x27, 0x0a, 0x29, 0x0a, 0x2a, 0x0a, 0x02, 0x21, 0x0a, 0x22, 0x0a, 0x23, 0x0a, 0x24,
    0x0a, 0x03, 0xfb, 0x0b, 0xfc, 0x0b, 0xfd, 0x0b, 0xfe, 0x0b, 0x1b, 0x0a, 0x1b, 0x0a, 0x1c, 0x0a, 0x1c, 0x0a, 0x03,
    0xf2, 0x0b, 0xf3, 0x0b, 0xf4, 0x0b, 0xf5, 0x0b, 0xf6, 0x0b, 0xf7, 0x0b, 0xf9, 0x0b, 0xfa, 0x0b, 0x03, 0xe9, 0x0b,
    0xea, 0x0b, 0xeb, 0x0b, 0xec, 0x0b, 0xed, 0x0b, 0xee, 0x0b, 0xef, 0x0b, 0xf1, 0x0b, 0x03, 0xde, 0x0b, 0xdf, 0x0b,
    0xe1, 0x0b, 0xe3, 0x0b, 0xe4, 0x0b, 0xe5, 0x0b, 0xe6, 0x0b, 0xe7, 0x0b, 0x03, 0xd6, 0x0b, 0xd7, 0x0b, 0xd8, 0x0b,
    0xd9, 0x0b, 0xda, 0x0b, 0xdb, 0x0b, 0xdc, 0x0b, 0xdd, 0x0b, 0x03, 0xcd, 0x0b, 0xcf, 0x0b, 0xd0, 0x0b, 0xd1, 0x0b,
    0xd2, 0x0b, 0xd3, 0x0b, 0xd4, 0x0b, 0xd5, 0x0b, 0x03, 0xc5, 0x0b, 0xc6, 0x0b, 0xc7, 0x0b, 0xc8, 0x0b, 0xc9, 0x0b,
    0xca, 0x0b, 0xcb, 0x0b, 0xcc, 0x0b, 0x03, 0xbb, 0x0b, 0xbc, 0x0b, 0xbd, 0x0b, 0xbe, 0x0b, 0xbf, 0x0b, 0xc1, 0x0b,
    0xc3, 0x0b, 0xc4, 0x0b, 0x03, 0xb2, 0x0b, 0xb3, 0x0b, 0xb4, 0x0b, 0xb5, 0x0b, 0xb6, 0x0b, 0xb7, 0x0b, 0xb9, 0x0b,
    0xba, 0x0b, 0x03, 0xa9, 0x0b, 0xaa, 0x0b, 0xab, 0x0b, 0xac, 0x0b, 0xad, 0x0b, 0xae, 0x0b, 0xaf, 0x0b, 0xb1, 0x0b,
    0x03, 0x9f, 0x0b, 0xa1, 0x0b, 0xa3, 0x0b, 0xa4, 0x0b, 0xa5, 0x0b, 0xa6, 0x0b, 0xa7, 0x0b, 0xa8, 0x0b, 0x03, 0x92,
    0x0b, 0x94, 0x0b, 0x99, 0x0b, 0x9a, 0x0b, 0x9b, 0x0b, 0x9c, 0x0b, 0x9d, 0x0b, 0x9e, 0x0b, 0x03, 0x86, 0x0b, 0x87,
    0x0b, 0x88, 0x0b, 0x8b, 0x0b, 0x8c, 0x0b, 0x8d, 0x0b, 0x8e, 0x0b, 0x91, 0x0b, 0x03, 0x2f, 0x0b, 0x4f, 0x0b, 0x54,
    0x0b, 0x5c, 0x0b, 0x71, 0x0b, 0x7b, 0x0b, 0x84, 0x0b, 0x85, 0x0b,
  ];

  static BitMasks = [
    0x0000, 0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff, 0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff,
    0x3fff, 0x7fff,
  ];

  static CompressionTable = [
    0x80010000, 0x70040000, 0x5c060000, 0x3e070000, 0x40070000, 0x60060000, 0x42070000, 0x44070000, 0x46070000,
    0x30080000, 0x48070000, 0x31080000, 0x32080000, 0x4a070000, 0x23080100, 0x33080000, 0x34080000, 0x35080000,
    0x4c070000, 0x64060000, 0x68060000, 0x4e070000, 0x36080000, 0x37080000, 0x38080000, 0x23080101, 0x24080100,
    0x0d070306, 0x0d070307, 0x39080000, 0x50070000, 0x3a080000, 0x3b080000, 0x0e080200, 0x0e080201, 0x0e080202,
    0x0e080203, 0x24080101, 0x0f080200, 0x0f080201, 0x25080100, 0x0f080202, 0x0f080203, 0x10080200, 0x10080201,
    0x10080202, 0x10080203, 0x00080300, 0x25080101, 0x26080100, 0x11080200, 0x11080201, 0x11080202, 0x11080203,
    0x12080200, 0x12080201, 0x12080202, 0x12080203, 0x13080200, 0x26080101, 0x13080201, 0x13080202, 0x13080203,
    0x14080200, 0x27080100, 0x14080201, 0x14080202, 0x27080101, 0x14080203, 0x28080100, 0x15080200, 0x15080201,
    0x15080202, 0x15080203, 0x16080200, 0x16080201, 0x28080101, 0x29080100, 0x16080202, 0x00080301, 0x29080101,
    0x3c080000, 0x2a080100, 0x16080203, 0x00080302, 0x2a080101, 0x2b080100, 0x17080200, 0x2b080101, 0x17080201,
    0x17080202, 0x17080203, 0x00080303, 0x18080200, 0x18080201, 0x18080202, 0x18080203, 0x19080200, 0x2c080100,
    0x2c080101, 0x2d080100, 0x19080201, 0x19080202, 0x52070000, 0x54070000, 0x56070000, 0x19080203, 0x2d080101,
    0x3d080000, 0x58070000, 0x1a080200, 0x1a080201, 0x1a080202, 0x00080304, 0x1a080203, 0x1b080200, 0x1b080201,
    0x1b080202, 0x1b080203, 0x1c080200, 0x1c080201, 0x1c080202, 0x1c080203, 0x00080305, 0x1d080200, 0x1d080201,
    0x1d080202, 0x1d080203, 0x5a070000, 0x1e080200, 0x1e080201, 0x1e080202, 0x00080306, 0x00080307, 0x01080300,
    0x01080301, 0x01080302, 0x1e080203, 0x1f080200, 0x01080303, 0x01080304, 0x01080305, 0x01080306, 0x1f080201,
    0x2e080100, 0x01080307, 0x02080300, 0x1f080202, 0x02080301, 0x2e080101, 0x2f080100, 0x2f080101, 0x1f080203,
    0x02080302, 0x02080303, 0x02080304, 0x02080305, 0x02080306, 0x02080307, 0x03080300, 0x20080200, 0x03080301,
    0x20080201, 0x03080302, 0x03080303, 0x03080304, 0x03080305, 0x03080306, 0x03080307, 0x04080300, 0x04080301,
    0x04080302, 0x04080303, 0x04080304, 0x04080305, 0x04080306, 0x20080202, 0x04080307, 0x05080300, 0x05080301,
    0x05080302, 0x05080303, 0x05080304, 0x05080305, 0x20080203, 0x05080306, 0x05080307, 0x06080300, 0x06080301,
    0x06080302, 0x06080303, 0x06080304, 0x21080200, 0x06080305, 0x21080201, 0x06080306, 0x06080307, 0x07080300,
    0x07080301, 0x07080302, 0x07080303, 0x07080304, 0x07080305, 0x07080306, 0x07080307, 0x08080300, 0x21080202,
    0x08080301, 0x08080302, 0x08080303, 0x08080304, 0x08080305, 0x08080306, 0x08080307, 0x09080300, 0x09080301,
    0x09080302, 0x09080303, 0x09080304, 0x09080305, 0x09080306, 0x09080307, 0x0a080300, 0x0a080301, 0x21080203,
    0x0a080302, 0x22080200, 0x0a080303, 0x0a080304, 0x0a080305, 0x0a080306, 0x0a080307, 0x22080201, 0x0b080300,
    0x0b080301, 0x0b080302, 0x0b080303, 0x0b080304, 0x0b080305, 0x0b080306, 0x22080202, 0x0b080307, 0x0c080300,
    0x0c080301, 0x0c080302, 0x0c080303, 0x0c080304, 0x0c080305, 0x22080203, 0x0c080306, 0x0c080307, 0x0d080300,
    0x0d080301, 0x0d080302, 0x0d080303, 0x6c060000,
  ];

  static decompress(input: number[] | Buffer | Uint8Array): number[] {
    // Offset to first data byte
    let i = Huffman.getHeaderSize(input);
    // Total number of bytes to parse
    let size = Huffman.getPacketSize(input) - i;
    const output: number[] = [];

    let a: number;
    let b = 0;
    let c: number;
    let d: number;

    let count = 0x20;

    while (true) {
      if (count >= 8) {
        while (size > 0 && count >= 8) {
          count -= 8;
          size--;
          a = input[i++] << count;
          b |= a;
        }
      }

      const index = Huffman.IndexTable[b >> 0x18] || 0;
      a = Huffman.CharacterTable[index];
      d = (b >> (0x18 - a)) & Huffman.BitMasks[a];
      c = Huffman.CharacterTable[index + 2 * d + 2];

      count += c;
      if (count > 0x20) return output;

      a = Huffman.CharacterTable[index + 2 * d + 1];
      output.push(a);
      b <<= c & 0xff;
    }
  }

  /**
   * Get the number of bytes used for the packet header
   * @param buffer buffer to parse
   */
  static getHeaderSize(buffer: number[] | Buffer | Uint8Array): number {
    if (buffer[0] < 0xf0) return 1;
    return 2;
  }

  /**
   * Get the size of the huffman encoded data
   * This includes the size of the header
   * @param buffer buffer to parse
   */
  static getPacketSize(buffer: number[] | Buffer | Uint8Array): number {
    if (buffer[0] < 0xf0) return buffer[0];
    return 0 + ((buffer[0] & 0x0f) << 8) + buffer[0 + 1];
  }
}
