# Certd

中文 | [English](./README_en.md)

Certd® 是一个免费的全自动证书管理系统，让你的网站证书永不过期。   
后缀d取自linux守护进程的命名风格，意为证书守护进程
   

>首创流水线申请部署证书模式，已被多个项目“借鉴”，被抄也是一种成功。

> 关于证书续期：
>* 实际上没有办法不改变证书文件本身情况下直接续期或者续签。
>* 我们所说的续期，其实就是按照全套流程重新申请一份新证书，然后重新部署上去。
>* 免费证书过期时间90天，以后可能还会缩短，所以自动化部署必不可少


> 流水线数量现已调整为无限制，欢迎大家使用


## 一、特性
本项目不仅支持证书申请过程自动化，还可以自动化部署更新证书，让你的证书永不过期。     

* 全自动申请证书（支持所有注册商注册的域名，支持DNS-01、HTTP-01、CNAME代理等多种域名验证方式）
* 全自动部署更新证书（目前支持部署到主机、阿里云、腾讯云等70+部署插件）
* 支持通配符域名/泛域名，支持多个域名打到一个证书上，支持pem、pfx、der、jks等多种证书格式
* 邮件通知、webhook通知、企微、钉钉、飞书、anpush等多种通知方式
* 私有化部署，数据保存本地，安装简单快捷，镜像由Github Actions构建，过程公开透明
* 授权加密，站点隐藏，2FA，密码防爆破等多重安全保障
* 支持SQLite，PostgreSQL、MySQL多种数据库
* 开放接口支持
* 站点证书监控
* 多用户管理
* 多语言支持（中英双语切换）
* 各版本向下兼容，一键无忧升级


  ![](./docs/images/intro/intro.svg)


## 二、在线体验

官方Demo地址，自助注册后体验    

https://certd.handfree.work/

> 注意数据将不定期清理，不定期停止定时任务，生产使用请自行部署    
> 包含敏感信息，务必自己本地部署进行生产使用

![首页](./docs/images/start/home.png)

## 三、使用教程

仅需3步，让你的证书永不过期

### 1. 创建证书流水线
![演示](packages/ui/certd-client/public/static/doc/images/1-add.png)

> 添加成功后，就可以直接运行流水线申请证书了

### 2. 添加部署任务
当然我们一般需要把证书部署到应用上，certd支持海量的部署插件，您可以根据自身实际情况进行选择，比如部署到Nginx、阿里云、腾讯云、K8S、CDN、宝塔、1Panel等等

此处演示部署证书到主机的nginx上    
![演示](packages/ui/certd-client/public/static/doc/images/5-1-add-host.png)

如果目前的部署插件都无法满足，您也可以手动下载，然后自行部署   
![演示](packages/ui/certd-client/public/static/doc/images/13-3-download.png)

### 3. 定时运行
![演示](packages/ui/certd-client/public/static/doc/images/12-1-log-success.png)


↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓      
-------> [点我查看详细使用步骤演示](./step.md)   <--------      
↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑     

更多教程请访问官方文档 [certd.docmirror.cn](https://certd.docmirror.cn/guide/)



## 四、私有化部署

由于证书、授权信息等属于高度敏感数据，请务必私有化部署，保障数据安全    

您可以根据实际情况从如下方式中选择一种方式进行私有化部署：

1. 【推荐】[Docker方式部署 ](https://certd.docmirror.cn/guide/install/docker/)
2. 【推荐】[宝塔面板方式部署 ](https://certd.docmirror.cn/guide/install/docker/)
3. 【推荐】[1Panel面板方式部署](https://certd.docmirror.cn/guide/install/1panel/)
4. 【推荐】[雨云一键部署](https://app.rainyun.com/apps/rca/store/6646/?ref=NzExMDQ2) ： 首充翻倍，每月仅需2.2元    
[<img src="https://rainyun-apps.cn-nb1.rains3.com/materials/deploy-on-rainyun-cn.svg">](https://app.rainyun.com/apps/rca/store/6646/?ref=NzExMDQ2)
5. 【不推荐】[源码方式部署 ](https://certd.docmirror.cn/guide/install/source/)

#### Docker镜像说明：
* 国内镜像地址:
  * `registry.cn-shenzhen.aliyuncs.com/handsfree/certd:latest`
  * `registry.cn-shenzhen.aliyuncs.com/handsfree/certd:armv7`、`[version]-armv7`
* DockerHub地址：
  * `https://hub.docker.com/r/greper/certd`
  * `greper/certd:latest`
  * `greper/certd:armv7`、`greper/certd:[version]-armv7`
* GitHub Packages地址:
  * `ghcr.io/certd/certd:latest`
  * `ghcr.io/certd/certd:armv7`、`ghcr.io/certd/certd:[version]-armv7`

* 镜像构建通过`Actions`自动执行，过程公开透明，请放心使用
  * [点我查看镜像构建日志](https://github.com/certd/certd/actions/workflows/build-image.yml) 

![](./docs/images/action/action-build.jpg)

> 注意：
> * 本应用存储的证书、授权信息等属于高度敏感数据，请做好安全防护
> * 请务必使用HTTPS协议访问本应用，避免被中间人攻击
> * 请务必使用web应用防火墙防护本应用，防止XSS、SQL注入等攻击
> * 请务必做好服务器本身的安全防护，防止数据库泄露
> * 请务必做好数据备份，避免数据丢失
> * [更多安全生产建议点我](https://certd.docmirror.cn/guide/feature/safe/)


## 五、生态
 
###  1.  客户端工具 SSL-Assistant
`SSL Assistant` 是一个运行于主机上的证书部署管理助手客户端。    
支持自动扫描主机`Nginx`配置，然后从`Certd`拉取证书并部署。     
在不想暴露ssh主机密码情况下，该工具非常好用。

开源地址： https://github.com/Youngxj/SSL-Assistant


## 六、更多帮助
请访问官方文档：[https://certd.docmirror.cn/](https://certd.docmirror.cn/guide/)

* 升级方法：[升级方法](https://certd.docmirror.cn/guide/install/upgrade/)
* 常见问题：[忘记密码](https://certd.docmirror.cn/guide/use/forgotpasswd/)
* 多数据库：[多数据库配置](https://certd.docmirror.cn/guide/install/database/)
* 站点安全：[站点安全特性](https://certd.docmirror.cn/guide/feature/safe/)
* 更新日志：[CHANGELOG](./CHANGELOG.md)


## 七、联系作者
如有疑问，欢迎加入群聊（请备注certd）

| 加群 | 微信群 | QQ群 |
|---------|-------|-------|
| 二维码 | <img height="230" src="./docs/guide/contact/images/wx.png"> | <img height="230" src="./docs/guide/contact/images/qq.png"> |

也可以加作者好友

| 加作者好友 | 微信 QQ                                                       |
|---------|-------------------------------------------------------------|
| 二维码 | <img height="230" src="./docs/guide/contact/images/me.png"> |


## 八、捐赠

开源为什么要做专业版收费？
1. 纯靠为爱发电不可持续（比如：我的dev-sidecar项目即便是拥有20K+star，也差点凉凉，幸亏有另外大佬接手用爱发电）    
2. 没有赞助的项目，作者会比较任性，不会用心倾听用户的心声，不顾用户体验（比如：下意识拒绝需求、频繁破坏性变更升级、全盘推倒重来之类的） 
3. 没有赞助的项目，交流群的戾气有时候比较重，容易起冲突     

发电权益：
1. 可加入发电专属VIP群，可以获得作者一对一技术支持，必要时可以远程协助
2. 您的需求我们将优先实现，并且可能将作为专业版功能提供
3. 获得专业版功能

专业版特权对比

| 功能      | 免费版                                   | 专业版                     |
|---------|---------------------------------------|--------------------------------|
| 免费证书申请  | 免费无限制                        | 免费无限制                      |
| 域名数量      | 无限制                           | 无限制                          |
| 证书流水线条数 | 无限制                           | 无限制                          |
| 站点证书监控  | 限制1条                           | 无限制                          |
| 自动部署插件  | 阿里云CDN、腾讯云、七牛CDN、主机部署、宝塔、1Panel等大部分插件     |     群晖、威联通、proxmox等  |
| 通知         | 邮件通知、自定义webhook            | 邮件免配置、企微、钉钉、飞书、anpush、server酱等 |
| 批量操作      | 无                               | 流水线模版，流水线复制，批量运行，批量设置通知、定时等 |
| VIP群        | 无                               | 可加，一对一技术支持，必要时可申请远程协助  |


## 九、贡献代码

1. 本地开发请参考 [贡献插件向导](https://certd.docmirror.cn/guide/development/)
2. 作为贡献者，代表您同意您贡献的代码如下许可：
   1. 可以调整开源协议以使其更严格或更宽松。
   2. 可以用于商业用途。

感谢以下贡献者做出的贡献。

<a href="https://github.com/certd/certd/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=certd/certd" />
</a>

## 十、 开源许可
* 本项目遵循 GNU Affero General Public License（AGPL）开源协议。   
* 允许个人和公司内部自由使用、复制、修改和分发本项目，未获得商业授权情况下禁止任何形式的商业用途 
* 未获得商业授权情况下，禁止任何对logo、版权信息及授权许可相关代码的修改。
* 如需商业授权，请联系作者。


## 十一、我的其他项目（求Star）

| 项目名称 | stars  | 项目描述  | 
| --------- |--------- |----------- |
| [fast-crud](https://gitee.com/fast-crud/fast-crud/)     | <img alt="GitHub stars" src="https://img.shields.io/github/stars/fast-crud/fast-crud?logo=github"/>   | 基于vue3的crud快速开发框架                 |  
| [dev-sidecar](https://github.com/docmirror/dev-sidecar/) | <img alt="GitHub stars" src="https://img.shields.io/github/stars/docmirror/dev-sidecar?logo=github"/> | 直连访问github工具，无需FQ，解决github无法访问的问题 |
