import crypto from 'crypto';
function hmacsha256(keyByte, message) {
    return crypto
        .createHmac('SHA256', keyByte)
        .update(message)
        .digest()
        .toString('hex');
}
function HexEncodeSHA256Hash(body) {
    return crypto.createHash('SHA256').update(body).digest().toString('hex');
}
const Algorithm = 'SDK-HMAC-SHA256';
const HeaderXDate = 'X-Sdk-Date';
const HeaderAuthorization = 'Authorization';
const HeaderContentSha256 = 'x-sdk-content-sha256';
const hexTable = new Array(256);
for (let i = 0; i < 256; ++i)
    hexTable[i] = '%' + ((i < 16 ? '0' : '') + i.toString(16)).toUpperCase();
const noEscape = [
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0, // 112 - 127
];
// function urlEncode is based on https://github.com/nodejs/node/blob/master/lib/querystring.js
// Copyright Joyent, Inc. and other Node contributors.
function urlEncode(str) {
    if (typeof str !== 'string') {
        if (typeof str === 'object')
            str = String(str);
        else
            str += '';
    }
    let out = '';
    let lastPos = 0;
    for (let i = 0; i < str.length; ++i) {
        let c = str.charCodeAt(i);
        // ASCII
        if (c < 0x80) {
            if (noEscape[c] === 1)
                continue;
            if (lastPos < i)
                out += str.slice(lastPos, i);
            lastPos = i + 1;
            out += hexTable[c];
            continue;
        }
        if (lastPos < i)
            out += str.slice(lastPos, i);
        // Multi-byte characters ...
        if (c < 0x800) {
            lastPos = i + 1;
            out += hexTable[0xc0 | (c >> 6)] + hexTable[0x80 | (c & 0x3f)];
            continue;
        }
        if (c < 0xd800 || c >= 0xe000) {
            lastPos = i + 1;
            out +=
                hexTable[0xe0 | (c >> 12)] +
                    hexTable[0x80 | ((c >> 6) & 0x3f)] +
                    hexTable[0x80 | (c & 0x3f)];
            continue;
        }
        // Surrogate pair
        ++i;
        if (i >= str.length)
            throw new Error('ERR_INVALID_URI');
        const c2 = str.charCodeAt(i) & 0x3ff;
        lastPos = i + 1;
        c = 0x10000 + (((c & 0x3ff) << 10) | c2);
        out +=
            hexTable[0xf0 | (c >> 18)] +
                hexTable[0x80 | ((c >> 12) & 0x3f)] +
                hexTable[0x80 | ((c >> 6) & 0x3f)] +
                hexTable[0x80 | (c & 0x3f)];
    }
    if (lastPos === 0)
        return str;
    if (lastPos < str.length)
        return out + str.slice(lastPos);
    return out;
}
function findHeader(r, header) {
    for (const k in r.headers) {
        if (k.toLowerCase() === header.toLowerCase()) {
            return r.headers[k];
        }
    }
    return null;
}
// Build a CanonicalRequest from a regular request string
//
// CanonicalRequest =
//  HTTPRequestMethod + '\n' +
//  CanonicalURI + '\n' +
//  CanonicalQueryString + '\n' +
//  CanonicalHeaders + '\n' +
//  SignedHeaders + '\n' +
//  HexEncode(Hash(RequestPayload))
function CanonicalRequest(r, signedHeaders) {
    let hexencode = findHeader(r, HeaderContentSha256);
    if (hexencode === null) {
        const data = RequestPayload(r);
        hexencode = HexEncodeSHA256Hash(data);
    }
    return (r.method +
        '\n' +
        CanonicalURI(r) +
        '\n' +
        CanonicalQueryString(r) +
        '\n' +
        CanonicalHeaders(r, signedHeaders) +
        '\n' +
        signedHeaders.join(';') +
        '\n' +
        hexencode);
}
function CanonicalURI(r) {
    const pattens = r.uri.split('/');
    const uri = [];
    for (const k in pattens) {
        const v = pattens[k];
        uri.push(urlEncode(v));
    }
    let urlpath = uri.join('/');
    if (urlpath[urlpath.length - 1] !== '/') {
        urlpath = urlpath + '/';
    }
    //r.uri = urlpath
    return urlpath;
}
function CanonicalQueryString(r) {
    const keys = [];
    for (const key in r.query) {
        keys.push(key);
    }
    keys.sort();
    const a = [];
    for (const i in keys) {
        const key = urlEncode(keys[i]);
        const value = r.query[keys[i]];
        if (Array.isArray(value)) {
            value.sort();
            for (const iv in value) {
                a.push(key + '=' + urlEncode(value[iv]));
            }
        }
        else {
            a.push(key + '=' + urlEncode(value));
        }
    }
    return a.join('&');
}
function CanonicalHeaders(r, signedHeaders) {
    const headers = {};
    for (const key in r.headers) {
        headers[key.toLowerCase()] = r.headers[key];
    }
    const a = [];
    for (const i in signedHeaders) {
        const value = headers[signedHeaders[i]];
        a.push(signedHeaders[i] + ':' + value.trim());
    }
    return a.join('\n') + '\n';
}
function SignedHeaders(r) {
    const a = [];
    for (const key in r.headers) {
        a.push(key.toLowerCase());
    }
    a.sort();
    return a;
}
function RequestPayload(r) {
    return r.body;
}
// Create a "String to Sign".
function StringToSign(canonicalRequest, t) {
    const bytes = HexEncodeSHA256Hash(canonicalRequest);
    return Algorithm + '\n' + t + '\n' + bytes;
}
// Create the HWS Signature.
function SignStringToSign(stringToSign, signingKey) {
    return hmacsha256(signingKey, stringToSign);
}
// Get the finalized value for the "Authorization" header.  The signature
// parameter is the output from SignStringToSign
function AuthHeaderValue(signature, Key, signedHeaders) {
    return (Algorithm +
        ' Access=' +
        Key +
        ', SignedHeaders=' +
        signedHeaders.join(';') +
        ', Signature=' +
        signature);
}
function twoChar(s) {
    if (s >= 10) {
        return '' + s;
    }
    else {
        return '0' + s;
    }
}
function getTime() {
    const date = new Date();
    return ('' +
        date.getUTCFullYear() +
        twoChar(date.getUTCMonth() + 1) +
        twoChar(date.getUTCDate()) +
        'T' +
        twoChar(date.getUTCHours()) +
        twoChar(date.getUTCMinutes()) +
        twoChar(date.getUTCSeconds()) +
        'Z');
}
export class SigHttpRequest {
    method = '';
    host = '';
    uri = '';
    query = {};
    headers = {};
    body = '';
    constructor(method, url, headers, body) {
        if (method === undefined) {
            this.method = '';
        }
        else {
            this.method = method;
        }
        if (url === undefined) {
            this.host = '';
            this.uri = '';
            this.query = {};
        }
        else {
            this.query = {};
            let host, path;
            let i = url.indexOf('://');
            if (i !== -1) {
                url = url.substr(i + 3);
            }
            i = url.indexOf('?');
            if (i !== -1) {
                const query_str = url.substr(i + 1);
                url = url.substr(0, i);
                const spl = query_str.split('&');
                for (const i in spl) {
                    const kv = spl[i];
                    const index = kv.indexOf('=');
                    let key, value;
                    if (index >= 0) {
                        key = kv.substr(0, index);
                        value = kv.substr(index + 1);
                    }
                    else {
                        key = kv;
                        value = '';
                    }
                    if (key !== '') {
                        key = decodeURI(key);
                        value = decodeURI(value);
                        if (this.query[key] === undefined) {
                            this.query[key] = [value];
                        }
                        else {
                            this.query[key].push(value);
                        }
                    }
                }
            }
            i = url.indexOf('/');
            if (i === -1) {
                host = url;
                path = '/';
            }
            else {
                host = url.substr(0, i);
                path = url.substr(i);
            }
            this.host = host;
            this.uri = decodeURI(path);
        }
        if (headers === undefined) {
            this.headers = {};
        }
        else {
            this.headers = headers;
        }
        if (body === undefined) {
            this.body = '';
        }
        else {
            this.body = body;
        }
    }
}
export class Signer {
    Key = '';
    Secret = '';
    constructor(Key, Secret) {
        this.Key = Key;
        this.Secret = Secret;
    }
    Sign(r) {
        let headerTime = findHeader(r, HeaderXDate);
        if (headerTime === null) {
            headerTime = getTime();
            r.headers[HeaderXDate] = headerTime;
        }
        if (r.method !== 'PUT' && r.method !== 'PATCH' && r.method !== 'POST') {
            r.body = '';
        }
        let queryString = CanonicalQueryString(r);
        if (queryString !== '') {
            queryString = '?' + queryString;
        }
        const options = {
            hostname: r.host,
            path: encodeURI(r.uri) + queryString,
            method: r.method,
            headers: r.headers,
        };
        if (findHeader(r, 'host') === null) {
            r.headers.host = r.host;
        }
        const signedHeaders = SignedHeaders(r);
        const canonicalRequest = CanonicalRequest(r, signedHeaders);
        const stringToSign = StringToSign(canonicalRequest, headerTime);
        const signature = SignStringToSign(stringToSign, this.Secret);
        options.headers[HeaderAuthorization] = AuthHeaderValue(signature, this.Key, signedHeaders);
        return options;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lnbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3BsdWdpbnMvcGx1Z2luLWh1YXdlaS9saWIvc2lnbmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sTUFBTSxNQUFNLFFBQVEsQ0FBQztBQUM1QixTQUFTLFVBQVUsQ0FBQyxPQUFZLEVBQUUsT0FBWTtJQUM1QyxPQUFPLE1BQU07U0FDVixVQUFVLENBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQztTQUM3QixNQUFNLENBQUMsT0FBTyxDQUFDO1NBQ2YsTUFBTSxFQUFFO1NBQ1IsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3JCLENBQUM7QUFDRCxTQUFTLG1CQUFtQixDQUFDLElBQVM7SUFDcEMsT0FBTyxNQUFNLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDM0UsQ0FBQztBQUNELE1BQU0sU0FBUyxHQUFHLGlCQUFpQixDQUFDO0FBQ3BDLE1BQU0sV0FBVyxHQUFHLFlBQVksQ0FBQztBQUNqQyxNQUFNLG1CQUFtQixHQUFHLGVBQWUsQ0FBQztBQUM1QyxNQUFNLG1CQUFtQixHQUFHLHNCQUFzQixDQUFDO0FBRW5ELE1BQU0sUUFBUSxHQUFHLElBQUksS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0FBQ2hDLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxHQUFHLEVBQUUsRUFBRSxDQUFDO0lBQzFCLFFBQVEsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFDO0FBRTNFLE1BQU0sUUFBUSxHQUFHO0lBQ2YsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUM7SUFDRCxDQUFDO0lBQ0QsQ0FBQztJQUNELENBQUMsRUFBRSxZQUFZO0NBQ2hCLENBQUM7QUFFRiwrRkFBK0Y7QUFDL0Ysc0RBQXNEO0FBQ3RELFNBQVMsU0FBUyxDQUFDLEdBQVE7SUFDekIsSUFBSSxPQUFPLEdBQUcsS0FBSyxRQUFRLEVBQUU7UUFDM0IsSUFBSSxPQUFPLEdBQUcsS0FBSyxRQUFRO1lBQUUsR0FBRyxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQzs7WUFDMUMsR0FBRyxJQUFJLEVBQUUsQ0FBQztLQUNoQjtJQUNELElBQUksR0FBRyxHQUFHLEVBQUUsQ0FBQztJQUNiLElBQUksT0FBTyxHQUFHLENBQUMsQ0FBQztJQUVoQixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsR0FBRyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsRUFBRTtRQUNuQyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRTFCLFFBQVE7UUFDUixJQUFJLENBQUMsR0FBRyxJQUFJLEVBQUU7WUFDWixJQUFJLFFBQVEsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDO2dCQUFFLFNBQVM7WUFDaEMsSUFBSSxPQUFPLEdBQUcsQ0FBQztnQkFBRSxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDOUMsT0FBTyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDaEIsR0FBRyxJQUFJLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNuQixTQUFTO1NBQ1Y7UUFFRCxJQUFJLE9BQU8sR0FBRyxDQUFDO1lBQUUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBRTlDLDRCQUE0QjtRQUM1QixJQUFJLENBQUMsR0FBRyxLQUFLLEVBQUU7WUFDYixPQUFPLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNoQixHQUFHLElBQUksUUFBUSxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQztZQUMvRCxTQUFTO1NBQ1Y7UUFDRCxJQUFJLENBQUMsR0FBRyxNQUFNLElBQUksQ0FBQyxJQUFJLE1BQU0sRUFBRTtZQUM3QixPQUFPLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNoQixHQUFHO2dCQUNELFFBQVEsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7b0JBQzFCLFFBQVEsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQztvQkFDbEMsUUFBUSxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBQzlCLFNBQVM7U0FDVjtRQUNELGlCQUFpQjtRQUNqQixFQUFFLENBQUMsQ0FBQztRQUVKLElBQUksQ0FBQyxJQUFJLEdBQUcsQ0FBQyxNQUFNO1lBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBRXhELE1BQU0sRUFBRSxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDO1FBRXJDLE9BQU8sR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2hCLENBQUMsR0FBRyxPQUFPLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1FBQ3pDLEdBQUc7WUFDRCxRQUFRLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO2dCQUMxQixRQUFRLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLENBQUM7Z0JBQ25DLFFBQVEsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQztnQkFDbEMsUUFBUSxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDO0tBQy9CO0lBQ0QsSUFBSSxPQUFPLEtBQUssQ0FBQztRQUFFLE9BQU8sR0FBRyxDQUFDO0lBQzlCLElBQUksT0FBTyxHQUFHLEdBQUcsQ0FBQyxNQUFNO1FBQUUsT0FBTyxHQUFHLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxRCxPQUFPLEdBQUcsQ0FBQztBQUNiLENBQUM7QUFFRCxTQUFTLFVBQVUsQ0FBQyxDQUFNLEVBQUUsTUFBVztJQUNyQyxLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLEVBQUU7UUFDekIsSUFBSSxDQUFDLENBQUMsV0FBVyxFQUFFLEtBQUssTUFBTSxDQUFDLFdBQVcsRUFBRSxFQUFFO1lBQzVDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUNyQjtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBRUQseURBQXlEO0FBQ3pELEVBQUU7QUFDRixxQkFBcUI7QUFDckIsOEJBQThCO0FBQzlCLHlCQUF5QjtBQUN6QixpQ0FBaUM7QUFDakMsNkJBQTZCO0FBQzdCLDBCQUEwQjtBQUMxQixtQ0FBbUM7QUFDbkMsU0FBUyxnQkFBZ0IsQ0FBQyxDQUFNLEVBQUUsYUFBa0I7SUFDbEQsSUFBSSxTQUFTLEdBQUcsVUFBVSxDQUFDLENBQUMsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO0lBQ25ELElBQUksU0FBUyxLQUFLLElBQUksRUFBRTtRQUN0QixNQUFNLElBQUksR0FBRyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDL0IsU0FBUyxHQUFHLG1CQUFtQixDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3ZDO0lBQ0QsT0FBTyxDQUNMLENBQUMsQ0FBQyxNQUFNO1FBQ1IsSUFBSTtRQUNKLFlBQVksQ0FBQyxDQUFDLENBQUM7UUFDZixJQUFJO1FBQ0osb0JBQW9CLENBQUMsQ0FBQyxDQUFDO1FBQ3ZCLElBQUk7UUFDSixnQkFBZ0IsQ0FBQyxDQUFDLEVBQUUsYUFBYSxDQUFDO1FBQ2xDLElBQUk7UUFDSixhQUFhLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztRQUN2QixJQUFJO1FBQ0osU0FBUyxDQUNWLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBUyxZQUFZLENBQUMsQ0FBTTtJQUMxQixNQUFNLE9BQU8sR0FBRyxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNqQyxNQUFNLEdBQUcsR0FBRyxFQUFFLENBQUM7SUFDZixLQUFLLE1BQU0sQ0FBQyxJQUFJLE9BQU8sRUFBRTtRQUN2QixNQUFNLENBQUMsR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDckIsR0FBRyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN4QjtJQUNELElBQUksT0FBTyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDNUIsSUFBSSxPQUFPLENBQUMsT0FBTyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsS0FBSyxHQUFHLEVBQUU7UUFDdkMsT0FBTyxHQUFHLE9BQU8sR0FBRyxHQUFHLENBQUM7S0FDekI7SUFDRCxpQkFBaUI7SUFDakIsT0FBTyxPQUFPLENBQUM7QUFDakIsQ0FBQztBQUVELFNBQVMsb0JBQW9CLENBQUMsQ0FBTTtJQUNsQyxNQUFNLElBQUksR0FBRyxFQUFFLENBQUM7SUFDaEIsS0FBSyxNQUFNLEdBQUcsSUFBSSxDQUFDLENBQUMsS0FBSyxFQUFFO1FBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7S0FDaEI7SUFDRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDWixNQUFNLENBQUMsR0FBRyxFQUFFLENBQUM7SUFDYixLQUFLLE1BQU0sQ0FBQyxJQUFJLElBQUksRUFBRTtRQUNwQixNQUFNLEdBQUcsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDL0IsTUFBTSxLQUFLLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMvQixJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDeEIsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2IsS0FBSyxNQUFNLEVBQUUsSUFBSSxLQUFLLEVBQUU7Z0JBQ3RCLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsR0FBRyxTQUFTLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUMxQztTQUNGO2FBQU07WUFDTCxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLEdBQUcsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7U0FDdEM7S0FDRjtJQUNELE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUNyQixDQUFDO0FBRUQsU0FBUyxnQkFBZ0IsQ0FBQyxDQUFNLEVBQUUsYUFBa0I7SUFDbEQsTUFBTSxPQUFPLEdBQVEsRUFBRSxDQUFDO0lBQ3hCLEtBQUssTUFBTSxHQUFHLElBQUksQ0FBQyxDQUFDLE9BQU8sRUFBRTtRQUMzQixPQUFPLENBQUMsR0FBRyxDQUFDLFdBQVcsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUM3QztJQUNELE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQztJQUNiLEtBQUssTUFBTSxDQUFDLElBQUksYUFBYSxFQUFFO1FBQzdCLE1BQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN4QyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLEdBQUcsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7S0FDL0M7SUFDRCxPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDO0FBQzdCLENBQUM7QUFFRCxTQUFTLGFBQWEsQ0FBQyxDQUFNO0lBQzNCLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQztJQUNiLEtBQUssTUFBTSxHQUFHLElBQUksQ0FBQyxDQUFDLE9BQU8sRUFBRTtRQUMzQixDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO0tBQzNCO0lBQ0QsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ1QsT0FBTyxDQUFDLENBQUM7QUFDWCxDQUFDO0FBRUQsU0FBUyxjQUFjLENBQUMsQ0FBTTtJQUM1QixPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUM7QUFDaEIsQ0FBQztBQUVELDZCQUE2QjtBQUM3QixTQUFTLFlBQVksQ0FBQyxnQkFBcUIsRUFBRSxDQUFNO0lBQ2pELE1BQU0sS0FBSyxHQUFHLG1CQUFtQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDcEQsT0FBTyxTQUFTLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxJQUFJLEdBQUcsS0FBSyxDQUFDO0FBQzdDLENBQUM7QUFFRCw0QkFBNEI7QUFDNUIsU0FBUyxnQkFBZ0IsQ0FBQyxZQUFpQixFQUFFLFVBQWU7SUFDMUQsT0FBTyxVQUFVLENBQUMsVUFBVSxFQUFFLFlBQVksQ0FBQyxDQUFDO0FBQzlDLENBQUM7QUFFRCx5RUFBeUU7QUFDekUsZ0RBQWdEO0FBQ2hELFNBQVMsZUFBZSxDQUFDLFNBQWMsRUFBRSxHQUFRLEVBQUUsYUFBa0I7SUFDbkUsT0FBTyxDQUNMLFNBQVM7UUFDVCxVQUFVO1FBQ1YsR0FBRztRQUNILGtCQUFrQjtRQUNsQixhQUFhLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztRQUN2QixjQUFjO1FBQ2QsU0FBUyxDQUNWLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBUyxPQUFPLENBQUMsQ0FBTTtJQUNyQixJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUU7UUFDWCxPQUFPLEVBQUUsR0FBRyxDQUFDLENBQUM7S0FDZjtTQUFNO1FBQ0wsT0FBTyxHQUFHLEdBQUcsQ0FBQyxDQUFDO0tBQ2hCO0FBQ0gsQ0FBQztBQUVELFNBQVMsT0FBTztJQUNkLE1BQU0sSUFBSSxHQUFHLElBQUksSUFBSSxFQUFFLENBQUM7SUFDeEIsT0FBTyxDQUNMLEVBQUU7UUFDRixJQUFJLENBQUMsY0FBYyxFQUFFO1FBQ3JCLE9BQU8sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDMUIsR0FBRztRQUNILE9BQU8sQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDM0IsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUM3QixPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQzdCLEdBQUcsQ0FDSixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sT0FBTyxjQUFjO0lBQ3pCLE1BQU0sR0FBRyxFQUFFLENBQUM7SUFDWixJQUFJLEdBQUcsRUFBRSxDQUFDO0lBQ1YsR0FBRyxHQUFHLEVBQUUsQ0FBQztJQUNULEtBQUssR0FBUSxFQUFFLENBQUM7SUFDaEIsT0FBTyxHQUFRLEVBQUUsQ0FBQztJQUNsQixJQUFJLEdBQUcsRUFBRSxDQUFDO0lBRVYsWUFBWSxNQUFXLEVBQUUsR0FBUSxFQUFFLE9BQVksRUFBRSxJQUFTO1FBQ3hELElBQUksTUFBTSxLQUFLLFNBQVMsRUFBRTtZQUN4QixJQUFJLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQztTQUNsQjthQUFNO1lBQ0wsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7U0FDdEI7UUFDRCxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7WUFDckIsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7WUFDZixJQUFJLENBQUMsR0FBRyxHQUFHLEVBQUUsQ0FBQztZQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO1NBQ2pCO2FBQU07WUFDTCxJQUFJLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQztZQUNoQixJQUFJLElBQUksRUFBRSxJQUFJLENBQUM7WUFDZixJQUFJLENBQUMsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFO2dCQUNaLEdBQUcsR0FBRyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQzthQUN6QjtZQUNELENBQUMsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3JCLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFO2dCQUNaLE1BQU0sU0FBUyxHQUFHLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO2dCQUNwQyxHQUFHLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3ZCLE1BQU0sR0FBRyxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ2pDLEtBQUssTUFBTSxDQUFDLElBQUksR0FBRyxFQUFFO29CQUNuQixNQUFNLEVBQUUsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ2xCLE1BQU0sS0FBSyxHQUFHLEVBQUUsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQzlCLElBQUksR0FBRyxFQUFFLEtBQUssQ0FBQztvQkFDZixJQUFJLEtBQUssSUFBSSxDQUFDLEVBQUU7d0JBQ2QsR0FBRyxHQUFHLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO3dCQUMxQixLQUFLLEdBQUcsRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUM7cUJBQzlCO3lCQUFNO3dCQUNMLEdBQUcsR0FBRyxFQUFFLENBQUM7d0JBQ1QsS0FBSyxHQUFHLEVBQUUsQ0FBQztxQkFDWjtvQkFDRCxJQUFJLEdBQUcsS0FBSyxFQUFFLEVBQUU7d0JBQ2QsR0FBRyxHQUFHLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQzt3QkFDckIsS0FBSyxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQzt3QkFDekIsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxLQUFLLFNBQVMsRUFBRTs0QkFDakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDO3lCQUMzQjs2QkFBTTs0QkFDTCxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQzt5QkFDN0I7cUJBQ0Y7aUJBQ0Y7YUFDRjtZQUNELENBQUMsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3JCLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFO2dCQUNaLElBQUksR0FBRyxHQUFHLENBQUM7Z0JBQ1gsSUFBSSxHQUFHLEdBQUcsQ0FBQzthQUNaO2lCQUFNO2dCQUNMLElBQUksR0FBRyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxHQUFHLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7YUFDdEI7WUFDRCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztZQUNqQixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUM1QjtRQUNELElBQUksT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztTQUNuQjthQUFNO1lBQ0wsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7U0FDeEI7UUFDRCxJQUFJLElBQUksS0FBSyxTQUFTLEVBQUU7WUFDdEIsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7U0FDaEI7YUFBTTtZQUNMLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1NBQ2xCO0lBQ0gsQ0FBQztDQUNGO0FBQ0QsTUFBTSxPQUFPLE1BQU07SUFDakIsR0FBRyxHQUFHLEVBQUUsQ0FBQztJQUNULE1BQU0sR0FBRyxFQUFFLENBQUM7SUFDWixZQUFZLEdBQVEsRUFBRSxNQUFXO1FBQy9CLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxDQUFDO1FBQ2YsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7SUFDdkIsQ0FBQztJQUVELElBQUksQ0FBQyxDQUFNO1FBQ1QsSUFBSSxVQUFVLEdBQUcsVUFBVSxDQUFDLENBQUMsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUM1QyxJQUFJLFVBQVUsS0FBSyxJQUFJLEVBQUU7WUFDdkIsVUFBVSxHQUFHLE9BQU8sRUFBRSxDQUFDO1lBQ3ZCLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLEdBQUcsVUFBVSxDQUFDO1NBQ3JDO1FBQ0QsSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLEtBQUssSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLE9BQU8sSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLE1BQU0sRUFBRTtZQUNyRSxDQUFDLENBQUMsSUFBSSxHQUFHLEVBQUUsQ0FBQztTQUNiO1FBQ0QsSUFBSSxXQUFXLEdBQUcsb0JBQW9CLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDMUMsSUFBSSxXQUFXLEtBQUssRUFBRSxFQUFFO1lBQ3RCLFdBQVcsR0FBRyxHQUFHLEdBQUcsV0FBVyxDQUFDO1NBQ2pDO1FBQ0QsTUFBTSxPQUFPLEdBQUc7WUFDZCxRQUFRLEVBQUUsQ0FBQyxDQUFDLElBQUk7WUFDaEIsSUFBSSxFQUFFLFNBQVMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLEdBQUcsV0FBVztZQUNwQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLE1BQU07WUFDaEIsT0FBTyxFQUFFLENBQUMsQ0FBQyxPQUFPO1NBQ25CLENBQUM7UUFDRixJQUFJLFVBQVUsQ0FBQyxDQUFDLEVBQUUsTUFBTSxDQUFDLEtBQUssSUFBSSxFQUFFO1lBQ2xDLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7U0FDekI7UUFDRCxNQUFNLGFBQWEsR0FBRyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDdkMsTUFBTSxnQkFBZ0IsR0FBRyxnQkFBZ0IsQ0FBQyxDQUFDLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFDNUQsTUFBTSxZQUFZLEdBQUcsWUFBWSxDQUFDLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ2hFLE1BQU0sU0FBUyxHQUFHLGdCQUFnQixDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDOUQsT0FBTyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLGVBQWUsQ0FDcEQsU0FBUyxFQUNULElBQUksQ0FBQyxHQUFHLEVBQ1IsYUFBYSxDQUNkLENBQUM7UUFDRixPQUFPLE9BQU8sQ0FBQztJQUNqQixDQUFDO0NBQ0YifQ==