/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 自定义域名
 * api 自定义域名 service
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'apigateway'
Service._services[serviceId] = true

/**
 * apigateway service.
 * @version 1.0.1
 */

JDCloud.APIGATEWAY = class APIGATEWAY extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'apigateway.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询访问授权列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - auth_user_type - 授权类型，默认为 全部类型
auth_user_id - 用户标识，精确匹配，jd_cloud（京东云用户）, jd_apikms（api网关签名密钥）, jd_subscription_key（订阅密钥）,jd_cloud_pin（激活用户）
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param accessAuth accessAuths
      * @param integer totalCount  查询的访问授权数目
      */

  queryAccessAuths (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAccessAuths"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAccessAuths with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建访问授权
      * @param {Object} opts - parameters
      * @param {accessAuthView} [opts.accessAuthView] - api分组  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessAuthId  已创建访问授权ID
      */

  createAccessAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAccessAuth"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.accessAuthView !== undefined && opts.accessAuthView !== null) {
      postBody['accessAuthView'] = opts.accessAuthView
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAccessAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查accessAuth是否重复
      * @param {Object} opts - parameters
      * @param {string} opts.accessKey
      * @param {string} opts.authUserType
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessAuthId  返回accessAuthId
      */

  checkAuthExist (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkAuthExist"
      )
    }

    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling checkAuthExist"
      )
    }
    if (opts.authUserType === undefined || opts.authUserType === null) {
      throw new Error(
        "Missing the required parameter 'opts.authUserType' when calling checkAuthExist"
      )
    }

    let postBody = {}
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.authUserType !== undefined && opts.authUserType !== null) {
      postBody['authUserType'] = opts.authUserType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkAuthExist with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths:checkAccessKeyExist',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个访问授权
      * @param {Object} opts - parameters
      * @param {string} opts.accessAuthId - 访问授权ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param accessAuth accessAuth
      */

  queryAccessAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAccessAuth"
      )
    }

    opts = opts || {}

    if (opts.accessAuthId === undefined || opts.accessAuthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessAuthId' when calling queryAccessAuth"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessAuthId: opts.accessAuthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAccessAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths/{accessAuthId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新访问授权
      * @param {Object} opts - parameters
      * @param {string} opts.accessAuthId - 访问授权ID
      * @param {accessAuthView} [opts.accessAuthView] - 访问授权详情  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessAuthId  已更新访问授权ID
      */

  updateAccessAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateAccessAuth"
      )
    }

    opts = opts || {}

    if (opts.accessAuthId === undefined || opts.accessAuthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessAuthId' when calling updateAccessAuth"
      )
    }

    let postBody = {}
    if (opts.accessAuthView !== undefined && opts.accessAuthView !== null) {
      postBody['accessAuthView'] = opts.accessAuthView
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessAuthId: opts.accessAuthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAccessAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths/{accessAuthId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除访问授权
      * @param {Object} opts - parameters
      * @param {string} opts.accessAuthId - 访问授权ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessAuthId  已删除授权ID
      */

  deleteAccessAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteAccessAuth"
      )
    }

    opts = opts || {}

    if (opts.accessAuthId === undefined || opts.accessAuthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessAuthId' when calling deleteAccessAuth"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessAuthId: opts.accessAuthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAccessAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths/{accessAuthId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询已绑定详情
      * @param {Object} opts - parameters
      * @param {string} opts.accessAuthId - 访问授权ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryBindGroupAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryBindGroupAuth"
      )
    }

    opts = opts || {}

    if (opts.accessAuthId === undefined || opts.accessAuthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessAuthId' when calling queryBindGroupAuth"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessAuthId: opts.accessAuthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBindGroupAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths/{accessAuthId}:bindGroup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定分组
      * @param {Object} opts - parameters
      * @param {string} opts.accessAuthId - 访问授权ID
      * @param {string} opts.deploymentIds - 待绑定的部署ids逗号隔开
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  bindGroupAuth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  bindGroupAuth"
      )
    }

    opts = opts || {}

    if (opts.accessAuthId === undefined || opts.accessAuthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessAuthId' when calling bindGroupAuth"
      )
    }
    if (opts.deploymentIds === undefined || opts.deploymentIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.deploymentIds' when calling bindGroupAuth"
      )
    }

    let postBody = {}
    if (opts.deploymentIds !== undefined && opts.deploymentIds !== null) {
      postBody['deploymentIds'] = opts.deploymentIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessAuthId: opts.accessAuthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindGroupAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths/{accessAuthId}:bindGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可绑定部署列表
      * @param {Object} opts - parameters
      * @param {string} opts.authUserType - 待绑定的用户类型
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryAuthGroupList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAuthGroupList"
      )
    }

    opts = opts || {}

    if (opts.authUserType === undefined || opts.authUserType === null) {
      throw new Error(
        "Missing the required parameter 'opts.authUserType' when calling queryAuthGroupList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.authUserType !== undefined && opts.authUserType !== null) {
      queryParams['authUserType'] = opts.authUserType
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAuthGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths:groupList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询所有已授权api分组列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - apiGroupName - 名称，模糊匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userBindedGroups apiGroups
      */

  authorizedApiGroupList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  authorizedApiGroupList"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call authorizedApiGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessAuths:authorizedApiGroupList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询密钥列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - description - 名称，模糊匹配
accessKey - accesskey，模糊匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param accessKey accessKeys
      * @param integer totalCount  查询的密钥数目
      */

  queryAccessKeys (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAccessKeys"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAccessKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建密钥
      * @param {Object} opts - parameters
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.accessKeyType] - 密钥类型  optional
      * @param {string} [opts.accessKey] - Access Key  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessKeyId  已创建密钥ID
      */

  createAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAccessKey"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.accessKeyType !== undefined && opts.accessKeyType !== null) {
      postBody['accessKeyType'] = opts.accessKeyType
    }
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查AccessKey是否重复
      * @param {Object} opts - parameters
      * @param {string} opts.accessKey
      * @param {string} opts.accessKeyType
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  checkKeyExist (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkKeyExist"
      )
    }

    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling checkKeyExist"
      )
    }
    if (opts.accessKeyType === undefined || opts.accessKeyType === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyType' when calling checkKeyExist"
      )
    }

    let postBody = {}
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.accessKeyType !== undefined && opts.accessKeyType !== null) {
      postBody['accessKeyType'] = opts.accessKeyType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkKeyExist with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys:checkAccessKeyExist',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个密钥
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param accessKey accessKey
      */

  queryAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling queryAccessKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新密钥
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.accessKeyType] - 密钥类型  optional
      * @param {string} [opts.accessKey] - Access Key  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessKeyId  已更新密钥Id
      */

  updateAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling updateAccessKey"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.accessKeyType !== undefined && opts.accessKeyType !== null) {
      postBody['accessKeyType'] = opts.accessKeyType
    }
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除密钥
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessKeyId  已删除密钥Id
      */

  deleteAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling deleteAccessKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询绑定分组详情
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryBindGroupKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryBindGroupKey"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling queryBindGroupKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBindGroupKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}:bindGroup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定分组
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} opts.deploymentIds - 待绑定的部署ids用逗号隔开
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  bindGroupKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  bindGroupKey"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling bindGroupKey"
      )
    }
    if (opts.deploymentIds === undefined || opts.deploymentIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.deploymentIds' when calling bindGroupKey"
      )
    }

    let postBody = {}
    if (opts.deploymentIds !== undefined && opts.deploymentIds !== null) {
      postBody['deploymentIds'] = opts.deploymentIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindGroupKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}:bindGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可绑定部署列表
      * @param {Object} opts - parameters
      * @param {string} opts.accessKeyId - access key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryKeyGroupList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryKeyGroupList"
      )
    }

    opts = opts || {}

    if (opts.accessKeyId === undefined || opts.accessKeyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKeyId' when calling queryKeyGroupList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKeyId: opts.accessKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryKeyGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/accessKeys/{accessKeyId}:groupList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询api列表
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - apiName - API名称，模糊匹配，支持单个
action - 动作，精确匹配，支持多个
backServiceType- 后端服务类型，精确匹配，支持多个
path - 路径，模糊匹配，支持单个
description - 描述，模糊匹配，支持单个
isApiProduct - 是否API产品，精确匹配，1为是
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param api apis
      * @param integer totalCount  查询的数目
      */

  queryApis (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryApis"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling queryApis"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling queryApis"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryApis with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {createApi} [opts.api] - api  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string apiId  apiId
      */

  createApis (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createApis"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling createApis"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling createApis"
      )
    }

    let postBody = {}
    if (opts.api !== undefined && opts.api !== null) {
      postBody['api'] = opts.api
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createApis with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建API时，检查API名称是否重复,返回重复的apiId,如果没有返回空
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiName - API名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string apiId  API名称
      */

  checkApiNameExist (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkApiNameExist"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling checkApiNameExist"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling checkApiNameExist"
      )
    }
    if (opts.apiName === undefined || opts.apiName === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiName' when calling checkApiNameExist"
      )
    }

    let postBody = {}
    if (opts.apiName !== undefined && opts.apiName !== null) {
      postBody['apiName'] = opts.apiName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkApiNameExist with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis:checkApiNameExist',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiId - 接口ID
      * @param {filter} [opts.filters] - isApiProduct - 是否API产品，精确匹配，1为是
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param api api
      */

  queryApi (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryApi"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling queryApi"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling queryApi"
      )
    }
    if (opts.apiId === undefined || opts.apiId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiId' when calling queryApi"
      )
    }

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision,
      apiId: opts.apiId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryApi with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis/{apiId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiId - 接口ID
      * @param {createApi} [opts.api] - api  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string apiId  apiId
      */

  updateApi (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateApi"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling updateApi"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling updateApi"
      )
    }
    if (opts.apiId === undefined || opts.apiId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiId' when calling updateApi"
      )
    }

    let postBody = {}
    if (opts.api !== undefined && opts.api !== null) {
      postBody['api'] = opts.api
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision,
      apiId: opts.apiId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateApi with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis/{apiId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiId - 接口ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteApi (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteApi"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deleteApi"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling deleteApi"
      )
    }
    if (opts.apiId === undefined || opts.apiId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiId' when calling deleteApi"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision,
      apiId: opts.apiId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteApi with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apis/{apiId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiName
      * @param {createApi} [opts.api] - api  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateApiByName (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateApiByName"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling updateApiByName"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling updateApiByName"
      )
    }
    if (opts.apiName === undefined || opts.apiName === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiName' when calling updateApiByName"
      )
    }

    let postBody = {}
    if (opts.api !== undefined && opts.api !== null) {
      postBody['api'] = opts.api
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision,
      apiName: opts.apiName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateApiByName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apisName/{apiName}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} opts.apiName
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteApiByName (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteApiByName"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deleteApiByName"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling deleteApiByName"
      )
    }
    if (opts.apiName === undefined || opts.apiName === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiName' when calling deleteApiByName"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revision: opts.revision,
      apiName: opts.apiName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteApiByName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revision}/apisName/{apiName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询分组
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - groupName - 分组名称，模糊匹配，支持单个
description - 描述信息，模糊匹配，支持单个
groupId - 分组ID，精确匹配
domain - 域名，模糊匹配
jdsfId - 微服务网关ID，精确匹配
  optional
      * @param {tagFilter} [opts.tagFilters] - 标签查询条件  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param apiGroup apiGroups
      * @param integer totalCount  查询的分组数目
      */

  describeApiGroups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeApiGroups"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))
    Object.assign(
      queryParams,
      this.buildTagFilterParam(opts.tagFilters, 'tagFilters')
    )

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeApiGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建API分组
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 名称
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.prefix] - 分组路径前缀，无需添加/  optional
      * @param {string} [opts.keyCheck] - 密钥验证方式：check_exist（密钥必须在访问授权中已配置）、no_check_exist（无需事先配置）  optional
      * @param {string} opts.authType - 访问授权方式：None（免鉴权）、jd_cloud（开启访问授权，且必须使用京东云的AK、SK验签）、hufu（虎符用户）
      * @param {integer} [opts.prefixStrip] - 是否转发分组路径到后端服务：0（不转发）、1（转发）默认为1  optional
      * @param {string} [opts.groupType] - 分组类型：api_group（api分组）、jdsf_group（微服务分组）默认为 api_group  optional
      * @param {string} [opts.jdsfName] - 微服务网关名称  optional
      * @param {string} [opts.jdsfRegistryName] - 微服务注册中心ID  optional
      * @param {string} [opts.jdsfId] - 微服务网关ID  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string apiGroupId  创建的API分组ID
      * @param string revision  修订版本号
      */

  createApiGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createApiGroup"
      )
    }

    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling createApiGroup"
      )
    }
    if (opts.authType === undefined || opts.authType === null) {
      throw new Error(
        "Missing the required parameter 'opts.authType' when calling createApiGroup"
      )
    }

    let postBody = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      postBody['groupName'] = opts.groupName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.prefix !== undefined && opts.prefix !== null) {
      postBody['prefix'] = opts.prefix
    }
    if (opts.keyCheck !== undefined && opts.keyCheck !== null) {
      postBody['keyCheck'] = opts.keyCheck
    }
    if (opts.authType !== undefined && opts.authType !== null) {
      postBody['authType'] = opts.authType
    }
    if (opts.prefixStrip !== undefined && opts.prefixStrip !== null) {
      postBody['prefixStrip'] = opts.prefixStrip
    }
    if (opts.groupType !== undefined && opts.groupType !== null) {
      postBody['groupType'] = opts.groupType
    }
    if (opts.jdsfName !== undefined && opts.jdsfName !== null) {
      postBody['jdsfName'] = opts.jdsfName
    }
    if (opts.jdsfRegistryName !== undefined && opts.jdsfRegistryName !== null) {
      postBody['jdsfRegistryName'] = opts.jdsfRegistryName
    }
    if (opts.jdsfId !== undefined && opts.jdsfId !== null) {
      postBody['jdsfId'] = opts.jdsfId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createApiGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查分组名称是否重复,返回重复的apiGroupId,如果没有返回空
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 分组名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string apiGroupId  分组id
      */

  checkGroupNameExist (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkGroupNameExist"
      )
    }

    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling checkGroupNameExist"
      )
    }

    let postBody = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      postBody['groupName'] = opts.groupName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkGroupNameExist with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups:checkGroupNameExist',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询API分组详情
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param apiGroup apiGroup
      */

  describeApiGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeApiGroup"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeApiGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeApiGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改API分组信息
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} [opts.groupName] - 名称  optional
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.prefix] - 分组路径前缀  optional
      * @param {string} [opts.keyCheck] - 密钥验证方式：check_exist（密钥必须在访问授权中已配置）、no_check_exist（无需事先配置）  optional
      * @param {string} [opts.authType] - 访问授权方式：None（免鉴权）、jd_cloud（开启访问授权，且必须使用京东云的AK、SK验签）、hufu（虎符用户）  optional
      * @param {integer} [opts.prefixStrip] - 是否转发分组路径到后端服务：0（不转发）、1（转发）默认为1  optional
      * @param {string} [opts.groupType] - 分组类型：api_group（api分组）、jdsf_group（微服务分组）默认为 api_group  optional
      * @param {string} [opts.jdsfName] - 微服务网关名称  optional
      * @param {string} [opts.jdsfRegistryName] - 微服务注册中心ID  optional
      * @param {string} [opts.jdsfId] - 微服务网关ID  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyApiGroupAttribute (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyApiGroupAttribute"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling modifyApiGroupAttribute"
      )
    }

    let postBody = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      postBody['groupName'] = opts.groupName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.prefix !== undefined && opts.prefix !== null) {
      postBody['prefix'] = opts.prefix
    }
    if (opts.keyCheck !== undefined && opts.keyCheck !== null) {
      postBody['keyCheck'] = opts.keyCheck
    }
    if (opts.authType !== undefined && opts.authType !== null) {
      postBody['authType'] = opts.authType
    }
    if (opts.prefixStrip !== undefined && opts.prefixStrip !== null) {
      postBody['prefixStrip'] = opts.prefixStrip
    }
    if (opts.groupType !== undefined && opts.groupType !== null) {
      postBody['groupType'] = opts.groupType
    }
    if (opts.jdsfName !== undefined && opts.jdsfName !== null) {
      postBody['jdsfName'] = opts.jdsfName
    }
    if (opts.jdsfRegistryName !== undefined && opts.jdsfRegistryName !== null) {
      postBody['jdsfRegistryName'] = opts.jdsfRegistryName
    }
    if (opts.jdsfId !== undefined && opts.jdsfId !== null) {
      postBody['jdsfId'] = opts.jdsfId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyApiGroupAttribute with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除单个API分组
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteApiGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteApiGroup"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deleteApiGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteApiGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询分组
      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - deployStatus - 发布状态，已发布：1，未发布：0
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param apiGroup apiGroups
      * @param integer totalCount  查询的分组数目
      */

  describeIsDeployApiGroups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeIsDeployApiGroups"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeIsDeployApiGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups:isDeploy',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开通后端配置
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} [opts.backendConfigId] - 接口ID  optional
      * @param {string} [opts.baseGroupId] - 分组ID  optional
      * @param {string} opts.environment - 环境：test、preview、online
      * @param {string} [opts.backendUrl] - 后端地址  optional
      * @param {string} opts.backendServiceType - 后端服务类型：mock、HTTP/HTTPS
      * @param {array} [opts.headerParams] - header参数列表  optional
      * @param {array} [opts.queryParams] - query参数列表  optional
      * @param {string} [opts.description] - 描述  optional
      * @param {integer} [opts.createTime] - 发布日期，格式为毫秒级时间戳  optional
      * @param {integer} opts.sort - 排序，赋值0时为默认的后端配置
      * @param {integer} [opts.userSort] - 排序，用于展示使用  optional
      * @param {string} [opts.jdsfId] - vpc网关id  optional
      * @param {string} [opts.jdsfParam] - vpc后端地址  optional
      * @param {string} [opts.jdsfRegion] - vpc网关所属region  optional
      * @param {string} [opts.jdsfPin] - vpc网关创建者的pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string backendConfigId  主键Id
      */

  createBackendConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBackendConfig"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling createBackendConfig"
      )
    }
    if (opts.environment === undefined || opts.environment === null) {
      throw new Error(
        "Missing the required parameter 'opts.environment' when calling createBackendConfig"
      )
    }
    if (
      opts.backendServiceType === undefined ||
      opts.backendServiceType === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.backendServiceType' when calling createBackendConfig"
      )
    }
    if (opts.sort === undefined || opts.sort === null) {
      throw new Error(
        "Missing the required parameter 'opts.sort' when calling createBackendConfig"
      )
    }

    let postBody = {}
    if (opts.backendConfigId !== undefined && opts.backendConfigId !== null) {
      postBody['backendConfigId'] = opts.backendConfigId
    }
    if (opts.baseGroupId !== undefined && opts.baseGroupId !== null) {
      postBody['baseGroupId'] = opts.baseGroupId
    }
    if (opts.environment !== undefined && opts.environment !== null) {
      postBody['environment'] = opts.environment
    }
    if (opts.backendUrl !== undefined && opts.backendUrl !== null) {
      postBody['backendUrl'] = opts.backendUrl
    }
    if (
      opts.backendServiceType !== undefined &&
      opts.backendServiceType !== null
    ) {
      postBody['backendServiceType'] = opts.backendServiceType
    }
    if (opts.headerParams !== undefined && opts.headerParams !== null) {
      postBody['headerParams'] = opts.headerParams
    }
    if (opts.queryParams !== undefined && opts.queryParams !== null) {
      postBody['queryParams'] = opts.queryParams
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.createTime !== undefined && opts.createTime !== null) {
      postBody['createTime'] = opts.createTime
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      postBody['sort'] = opts.sort
    }
    if (opts.userSort !== undefined && opts.userSort !== null) {
      postBody['userSort'] = opts.userSort
    }
    if (opts.jdsfId !== undefined && opts.jdsfId !== null) {
      postBody['jdsfId'] = opts.jdsfId
    }
    if (opts.jdsfParam !== undefined && opts.jdsfParam !== null) {
      postBody['jdsfParam'] = opts.jdsfParam
    }
    if (opts.jdsfRegion !== undefined && opts.jdsfRegion !== null) {
      postBody['jdsfRegion'] = opts.jdsfRegion
    }
    if (opts.jdsfPin !== undefined && opts.jdsfPin !== null) {
      postBody['jdsfPin'] = opts.jdsfPin
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBackendConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/backendConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询指定环境下的所有后端配置
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.environment - 环境：test、preview、online
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - sort - 路由排序，赋值0时为默认的后端配置
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backendConfig backendConfigs
      * @param integer totalCount  结果总数
      */

  describeBackendConfigs (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackendConfigs"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeBackendConfigs"
      )
    }
    if (opts.environment === undefined || opts.environment === null) {
      throw new Error(
        "Missing the required parameter 'opts.environment' when calling describeBackendConfigs"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      environment: opts.environment
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackendConfigs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/environment/{environment}/backendConfigs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询backendConfig
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.backendConfigId - backendConfigId
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backendConfig backendConfig
      */

  describeBackendConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackendConfig"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeBackendConfig"
      )
    }
    if (opts.backendConfigId === undefined || opts.backendConfigId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendConfigId' when calling describeBackendConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      backendConfigId: opts.backendConfigId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackendConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/backendConfig/{backendConfigId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改后端配置
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.backendConfigId - backendConfigId
      * @param {string} [opts.baseGroupId] - 分组ID  optional
      * @param {string} opts.environment - 环境：test、preview、online
      * @param {string} [opts.backendUrl] - 后端地址  optional
      * @param {string} opts.backendServiceType - 后端服务类型：mock、HTTP/HTTPS
      * @param {array} [opts.headerParams] - header参数列表  optional
      * @param {array} [opts.queryParams] - query参数列表  optional
      * @param {string} [opts.description] - 描述  optional
      * @param {integer} [opts.createTime] - 发布日期，格式为毫秒级时间戳  optional
      * @param {integer} opts.sort - 排序，赋值0时为默认的后端配置
      * @param {integer} [opts.userSort] - 排序，用于展示使用  optional
      * @param {string} [opts.jdsfId] - vpc网关id  optional
      * @param {string} [opts.jdsfParam] - vpc后端地址  optional
      * @param {string} [opts.jdsfRegion] - vpc网关所属region  optional
      * @param {string} [opts.jdsfPin] - vpc网关创建者的pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateBackendConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateBackendConfig"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling updateBackendConfig"
      )
    }
    if (opts.backendConfigId === undefined || opts.backendConfigId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendConfigId' when calling updateBackendConfig"
      )
    }
    if (opts.environment === undefined || opts.environment === null) {
      throw new Error(
        "Missing the required parameter 'opts.environment' when calling updateBackendConfig"
      )
    }
    if (
      opts.backendServiceType === undefined ||
      opts.backendServiceType === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.backendServiceType' when calling updateBackendConfig"
      )
    }
    if (opts.sort === undefined || opts.sort === null) {
      throw new Error(
        "Missing the required parameter 'opts.sort' when calling updateBackendConfig"
      )
    }

    let postBody = {}
    if (opts.baseGroupId !== undefined && opts.baseGroupId !== null) {
      postBody['baseGroupId'] = opts.baseGroupId
    }
    if (opts.environment !== undefined && opts.environment !== null) {
      postBody['environment'] = opts.environment
    }
    if (opts.backendUrl !== undefined && opts.backendUrl !== null) {
      postBody['backendUrl'] = opts.backendUrl
    }
    if (
      opts.backendServiceType !== undefined &&
      opts.backendServiceType !== null
    ) {
      postBody['backendServiceType'] = opts.backendServiceType
    }
    if (opts.headerParams !== undefined && opts.headerParams !== null) {
      postBody['headerParams'] = opts.headerParams
    }
    if (opts.queryParams !== undefined && opts.queryParams !== null) {
      postBody['queryParams'] = opts.queryParams
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.createTime !== undefined && opts.createTime !== null) {
      postBody['createTime'] = opts.createTime
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      postBody['sort'] = opts.sort
    }
    if (opts.userSort !== undefined && opts.userSort !== null) {
      postBody['userSort'] = opts.userSort
    }
    if (opts.jdsfId !== undefined && opts.jdsfId !== null) {
      postBody['jdsfId'] = opts.jdsfId
    }
    if (opts.jdsfParam !== undefined && opts.jdsfParam !== null) {
      postBody['jdsfParam'] = opts.jdsfParam
    }
    if (opts.jdsfRegion !== undefined && opts.jdsfRegion !== null) {
      postBody['jdsfRegion'] = opts.jdsfRegion
    }
    if (opts.jdsfPin !== undefined && opts.jdsfPin !== null) {
      postBody['jdsfPin'] = opts.jdsfPin
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      backendConfigId: opts.backendConfigId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateBackendConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/backendConfig/{backendConfigId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除后端配置
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.backendConfigId - backendConfigId
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteBackendConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteBackendConfig"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deleteBackendConfig"
      )
    }
    if (opts.backendConfigId === undefined || opts.backendConfigId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendConfigId' when calling deleteBackendConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      backendConfigId: opts.backendConfigId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteBackendConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/backendConfig/{backendConfigId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询部署列表
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {filter} [opts.filters] - isApiProduct - 是否API产品，精确匹配，1为是
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deployment deployments
      */

  describeDeployments (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDeployments"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeDeployments"
      )
    }

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDeployments with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/deployments',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发布版本
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 发布的修订版本号
      * @param {string} opts.environment - 环境：test、preview、online
      * @param {string} [opts.backendServiceType] - 后端服务类型：mock、unique、vpc  optional
      * @param {string} [opts.backendUrl] - 后端地址  optional
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.jdsfName] - 微服务网关名称  optional
      * @param {string} [opts.jdsfRegistryName] - 微服务注册中心ID  optional
      * @param {string} [opts.jdsfId] - 微服务ID  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deploy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deploy"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deploy"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling deploy"
      )
    }
    if (opts.environment === undefined || opts.environment === null) {
      throw new Error(
        "Missing the required parameter 'opts.environment' when calling deploy"
      )
    }

    let postBody = {}
    if (opts.revision !== undefined && opts.revision !== null) {
      postBody['revision'] = opts.revision
    }
    if (opts.environment !== undefined && opts.environment !== null) {
      postBody['environment'] = opts.environment
    }
    if (
      opts.backendServiceType !== undefined &&
      opts.backendServiceType !== null
    ) {
      postBody['backendServiceType'] = opts.backendServiceType
    }
    if (opts.backendUrl !== undefined && opts.backendUrl !== null) {
      postBody['backendUrl'] = opts.backendUrl
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.jdsfName !== undefined && opts.jdsfName !== null) {
      postBody['jdsfName'] = opts.jdsfName
    }
    if (opts.jdsfRegistryName !== undefined && opts.jdsfRegistryName !== null) {
      postBody['jdsfRegistryName'] = opts.jdsfRegistryName
    }
    if (opts.jdsfId !== undefined && opts.jdsfId !== null) {
      postBody['jdsfId'] = opts.jdsfId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deploy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/deployments',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询该版本的部署详情
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.deploymentId - 部署ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deployment apiGroup
      */

  describeDeployment (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDeployment"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeDeployment"
      )
    }
    if (opts.deploymentId === undefined || opts.deploymentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deploymentId' when calling describeDeployment"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      deploymentId: opts.deploymentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDeployment with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/deployments/{deploymentId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  下线
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.deploymentId - 部署ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  offline (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  offline"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling offline"
      )
    }
    if (opts.deploymentId === undefined || opts.deploymentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deploymentId' when calling offline"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      deploymentId: opts.deploymentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call offline with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/deployments/{deploymentId}:offline',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量下线
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} [opts.deploymentIds] - 要删除的部署ID集合，以,分隔  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer successCount  操作成功的资源个数
      * @param errorItem failed
      */

  batchOffline (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  batchOffline"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling batchOffline"
      )
    }

    let postBody = {}
    if (opts.deploymentIds !== undefined && opts.deploymentIds !== null) {
      postBody['deploymentIds'] = opts.deploymentIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchOffline with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/deployments:offline',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询key列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {string} [opts.orderBy] - 排序类型  optional
      * @param {string} [opts.userType] - 用户类型  optional
      * @param {string} [opts.keyId] - 密钥Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  total count
      * @param keyInfo data
      */

  queryKeys (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryKeys"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.orderBy !== undefined && opts.orderBy !== null) {
      queryParams['orderBy'] = opts.orderBy
    }
    if (opts.userType !== undefined && opts.userType !== null) {
      queryParams['userType'] = opts.userType
    }
    if (opts.keyId !== undefined && opts.keyId !== null) {
      queryParams['keyId'] = opts.keyId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/kms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建key
      * @param {Object} opts - parameters
      * @param {string} [opts.keyName] - key 名称  optional
      * @param {string} [opts.keyDesc] - key 描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string accessKey  生成的accessKey
      * @param string secretKey  生成的secretKey
      */

  createKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createKey"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.keyName !== undefined && opts.keyName !== null) {
      postBody['keyName'] = opts.keyName
    }
    if (opts.keyDesc !== undefined && opts.keyDesc !== null) {
      postBody['keyDesc'] = opts.keyDesc
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/kms',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  重置key的acesskey和secretkey
      * @param {Object} opts - parameters
      * @param {string} opts.keyId - keyId
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param keyInfo keyInfo
      */

  resetKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  resetKey"
      )
    }

    opts = opts || {}

    if (opts.keyId === undefined || opts.keyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyId' when calling resetKey"
      )
    }

    let postBody = {}
    if (opts.keyId !== undefined && opts.keyId !== null) {
      postBody['keyId'] = opts.keyId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call resetKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/kms',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改key信息
      * @param {Object} opts - parameters
      * @param {string} opts.keyId - keyid
      * @param {string} [opts.keyName] - key 名称  optional
      * @param {string} [opts.keyDesc]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateKey"
      )
    }

    opts = opts || {}

    if (opts.keyId === undefined || opts.keyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyId' when calling updateKey"
      )
    }

    let postBody = {}
    if (opts.keyId !== undefined && opts.keyId !== null) {
      postBody['keyId'] = opts.keyId
    }
    if (opts.keyName !== undefined && opts.keyName !== null) {
      postBody['keyName'] = opts.keyName
    }
    if (opts.keyDesc !== undefined && opts.keyDesc !== null) {
      postBody['keyDesc'] = opts.keyDesc
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/kms',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询key详情
      * @param {Object} opts - parameters
      * @param {string} opts.keyId - keyId
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param keyInfo keyInfo
      */

  queryKeyInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryKeyInfo"
      )
    }

    opts = opts || {}

    if (opts.keyId === undefined || opts.keyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyId' when calling queryKeyInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      keyId: opts.keyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryKeyInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/kms/{keyId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询流控策略列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - policyName - 策略名称，模糊匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rateLimitPolicy rateLimitPolicys
      * @param integer totalCount  查询的流控策略数目
      */

  queryRateLimitPolicies (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryRateLimitPolicies"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRateLimitPolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建流控策略
      * @param {Object} opts - parameters
      * @param {rateLimitPolicyView} [opts.rateLimitPolicyView] - 流控策略详情  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string policyId  流控策略Id
      */

  createRateLimitPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createRateLimitPolicy"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (
      opts.rateLimitPolicyView !== undefined &&
      opts.rateLimitPolicyView !== null
    ) {
      postBody['rateLimitPolicyView'] = opts.rateLimitPolicyView
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRateLimitPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查策略名是否重复
      * @param {Object} opts - parameters
      * @param {string} opts.policyName
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string policyId  返回policyID
      */

  checkPolicyName (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkPolicyName"
      )
    }

    opts = opts || {}

    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling checkPolicyName"
      )
    }

    let postBody = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      postBody['policyName'] = opts.policyName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkPolicyName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies:checkPolicyNameExist',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个流控策略
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rateLimitPolicy rateLimitPolicy
      */

  queryRateLimitPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryRateLimitPolicy"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling queryRateLimitPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRateLimitPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改流控策略
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {rateLimitPolicyView} [opts.rateLimitPolicyView] - 流控策略详情  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string policyId  流控策略Id
      */

  updateRateLimitPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateRateLimitPolicy"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling updateRateLimitPolicy"
      )
    }

    let postBody = {}
    if (
      opts.rateLimitPolicyView !== undefined &&
      opts.rateLimitPolicyView !== null
    ) {
      postBody['rateLimitPolicyView'] = opts.rateLimitPolicyView
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateRateLimitPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除单个流控策略
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string policyId  已删除流控策略Id
      */

  deleteRateLimitPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteRateLimitPolicy"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling deleteRateLimitPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRateLimitPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询绑定部署详情
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryBindGroupPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryBindGroupPolicy"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling queryBindGroupPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBindGroupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}:bindGroup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {string} opts.deploymentIds - 待绑定的部署ids逗号隔开
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  bindGroupPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  bindGroupPolicy"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling bindGroupPolicy"
      )
    }
    if (opts.deploymentIds === undefined || opts.deploymentIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.deploymentIds' when calling bindGroupPolicy"
      )
    }

    let postBody = {}
    if (opts.deploymentIds !== undefined && opts.deploymentIds !== null) {
      postBody['deploymentIds'] = opts.deploymentIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindGroupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}:bindGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可绑定部署列表
      * @param {Object} opts - parameters
      * @param {string} opts.policyId - 限流策略ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param bindGroups bindGroups
      */

  queryPolicyGroupList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryPolicyGroupList"
      )
    }

    opts = opts || {}

    if (opts.policyId === undefined || opts.policyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyId' when calling queryPolicyGroupList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      policyId: opts.policyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPolicyGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/rateLimitPolicies/{policyId}:groupList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询修订版本列表
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - revision - 修订版本号，精确匹配
environment - 发布环境，模糊匹配
revisionNote - 修订备注，精确匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param revisionList revisions
      * @param integer totalCount  查询的版本数目
      */

  describeRevisions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeRevisions"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling describeRevisions"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRevisions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建修订版本
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} [opts.revision] - 修订版本号，如果创建版本时传回修订版本，此为必填项  optional
      * @param {string} [opts.baseRevision] - 基于此版本，如果创建版本时传回修订版本，此为必填项  optional
      * @param {string} [opts.revisionNote] - 修订备注  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string revision  新建的修订版本号
      */

  createRevision (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createRevision"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling createRevision"
      )
    }

    let postBody = {}
    if (opts.revision !== undefined && opts.revision !== null) {
      postBody['revision'] = opts.revision
    }
    if (opts.baseRevision !== undefined && opts.baseRevision !== null) {
      postBody['baseRevision'] = opts.baseRevision
    }
    if (opts.revisionNote !== undefined && opts.revisionNote !== null) {
      postBody['revisionNote'] = opts.revisionNote
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRevision with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询分组内全部修订版本号
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param revisionList revisions
      */

  getRevisionIds (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getRevisionIds"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling getRevisionIds"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRevisionIds with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revisions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查版本号是否重复,返回重复的版本号,如果没有返回空
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revision - 版本号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean isRepeate  新建修订版本号重复否
      */

  checkRevisionExist (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkRevisionExist"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling checkRevisionExist"
      )
    }
    if (opts.revision === undefined || opts.revision === null) {
      throw new Error(
        "Missing the required parameter 'opts.revision' when calling checkRevisionExist"
      )
    }

    let postBody = {}
    if (opts.revision !== undefined && opts.revision !== null) {
      postBody['revision'] = opts.revision
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkRevisionExist with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision:checkExist',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询某版本对应的api
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revisionId - 版本ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - revision - 修订版本号，模糊匹配
environment - 发布环境，模糊匹配
revisionNote - 修订备注，模糊匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param api apis
      * @param integer totalCount  查询的版本数目
      */

  queryRevision (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryRevision"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling queryRevision"
      )
    }
    if (opts.revisionId === undefined || opts.revisionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.revisionId' when calling queryRevision"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revisionId: opts.revisionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRevision with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revisionId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改单个修订版本
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revisionId - 版本ID
      * @param {string} [opts.revisionNote] - 修订备注  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean updateRevision  修改修订版本成功否
      */

  modifyRevision (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyRevision"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling modifyRevision"
      )
    }
    if (opts.revisionId === undefined || opts.revisionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.revisionId' when calling modifyRevision"
      )
    }

    let postBody = {}
    if (opts.revisionNote !== undefined && opts.revisionNote !== null) {
      postBody['revisionNote'] = opts.revisionNote
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revisionId: opts.revisionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyRevision with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revisionId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除单个修订版本
      * @param {Object} opts - parameters
      * @param {string} opts.apiGroupId - 分组ID
      * @param {string} opts.revisionId - 版本ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean deleteRevision  删除修订版本成功否
      */

  deleteRevision (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteRevision"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling deleteRevision"
      )
    }
    if (opts.revisionId === undefined || opts.revisionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.revisionId' when calling deleteRevision"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      apiGroupId: opts.apiGroupId,
      revisionId: opts.revisionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRevision with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/apiGroups/{apiGroupId}/revision/{revisionId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询密钥列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - description - 名称，模糊匹配
subscriptionKeyId - subscriptionKeyId，精确匹配
orderBy - 排序类型 desc asc
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param subscriptionKey subscriptionKeys
      * @param integer totalCount  查询的密钥数目
      */

  querySubscriptionKeys (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  querySubscriptionKeys"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySubscriptionKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/subscriptionKeys',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建密钥
      * @param {Object} opts - parameters
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.name] - 密钥名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string subscriptionKeyId  已创建密钥ID
      */

  createSubscriptionKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createSubscriptionKey"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSubscriptionKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/subscriptionKeys',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个密钥
      * @param {Object} opts - parameters
      * @param {string} opts.subscriptionKeyId - subscription key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param subscriptionKey subscriptionKey
      */

  querySubscriptionKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  querySubscriptionKey"
      )
    }

    opts = opts || {}

    if (
      opts.subscriptionKeyId === undefined ||
      opts.subscriptionKeyId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.subscriptionKeyId' when calling querySubscriptionKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      subscriptionKeyId: opts.subscriptionKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySubscriptionKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/subscriptionKeys/{subscriptionKeyId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新密钥
      * @param {Object} opts - parameters
      * @param {string} opts.subscriptionKeyId - subscription key id
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.name] - 密钥名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string subscriptionKeyId  已更新密钥Id
      */

  updateSubscriptionKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateSubscriptionKey"
      )
    }

    opts = opts || {}

    if (
      opts.subscriptionKeyId === undefined ||
      opts.subscriptionKeyId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.subscriptionKeyId' when calling updateSubscriptionKey"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      subscriptionKeyId: opts.subscriptionKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateSubscriptionKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/subscriptionKeys/{subscriptionKeyId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除密钥
      * @param {Object} opts - parameters
      * @param {string} opts.subscriptionKeyId - subscription key id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string subscriptionKeyId  已删除密钥Id
      */

  deleteSubscriptionKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteSubscriptionKey"
      )
    }

    opts = opts || {}

    if (
      opts.subscriptionKeyId === undefined ||
      opts.subscriptionKeyId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.subscriptionKeyId' when calling deleteSubscriptionKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      subscriptionKeyId: opts.subscriptionKeyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSubscriptionKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/subscriptionKeys/{subscriptionKeyId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询密钥列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - accessKey - accesskey，精确匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param ucAccessKey accessKeys
      * @param integer totalCount  查询的密钥数目
      */

  queryUcAccessKeys (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryUcAccessKeys"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUcAccessKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/ucAccessKeys',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  校验pin是否存在
      * @param {Object} opts - parameters
      * @param {string} opts.pin - 京东云pin
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  checkPin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkPin"
      )
    }

    opts = opts || {}

    if (opts.pin === undefined || opts.pin === null) {
      throw new Error(
        "Missing the required parameter 'opts.pin' when calling checkPin"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      pin: opts.pin
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkPin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/pins/{pin}:checkPin',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询domian列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {string} [opts.orderBy] - 排序类型  optional
      * @param {string} opts.apiGroupId - api分组id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  total count
      * @param domainInfo data
      */

  queryUserDomains (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryUserDomains"
      )
    }

    opts = opts || {}

    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling queryUserDomains"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.orderBy !== undefined && opts.orderBy !== null) {
      queryParams['orderBy'] = opts.orderBy
    }
    if (opts.apiGroupId !== undefined && opts.apiGroupId !== null) {
      queryParams['apiGroupId'] = opts.apiGroupId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUserDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userdomain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加用户域名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 域名
      * @param {string} [opts.protocol] - 协议  optional
      * @param {string} opts.apiGroupId - api分组id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string domainId  生成的domainId
      */

  createUserDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createUserDomain"
      )
    }

    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createUserDomain"
      )
    }
    if (opts.apiGroupId === undefined || opts.apiGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.apiGroupId' when calling createUserDomain"
      )
    }

    let postBody = {}
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.protocol !== undefined && opts.protocol !== null) {
      postBody['protocol'] = opts.protocol
    }
    if (opts.apiGroupId !== undefined && opts.apiGroupId !== null) {
      postBody['apiGroupId'] = opts.apiGroupId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUserDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userdomain',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户域名接口
      * @param {Object} opts - parameters
      * @param {string} opts.domainIds - 要删除domain的id集合，以,分隔
      * @param {string} [opts.apiGroupId] - api分组id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUserDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteUserDomain"
      )
    }

    opts = opts || {}

    if (opts.domainIds === undefined || opts.domainIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainIds' when calling deleteUserDomain"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainIds !== undefined && opts.domainIds !== null) {
      queryParams['domainIds'] = opts.domainIds
    }
    if (opts.apiGroupId !== undefined && opts.apiGroupId !== null) {
      queryParams['apiGroupId'] = opts.apiGroupId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  apigateway/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUserDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userdomain',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.APIGATEWAY
