/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * LogConfig
 * 用户日志相关配置
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'assistant'
Service._services[serviceId] = true

/**
 * assistant service.
 * @version 1.0.2
 */

class ASSISTANT extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'assistant.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *
保存用户自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于保存用户自定义命令。

      * @param {Object} opts - parameters
      * @param {string} opts.commandName - 命令名称，长度为1\~128个字符，只允许中文、数字、大小写字母、英文下划线（\_）、连字符（-）及点（.）。

      * @param {string} [opts.commandType] - 命令类型，可选值：shell和powershell，默认shell
  optional
      * @param {string} opts.commandContent - 以base64编码的命令内容，编码后长度小于36KB

      * @param {integer} [opts.timeout] - 超时时间，取值范围：[10, 86400], 超过该时间后，尚未执行完的命令会置为失败。默认60s
  optional
      * @param {string} [opts.username] - 用户名，执行该命令时的用户身份。在linux上默认是root，windows上默认是administrator。长度小于256
  optional
      * @param {string} [opts.workdir] - 命令执行路径。在linux上默认是/root，windows上默认是C:\Windows\System32。长度小于256。
  optional
      * @param {string} [opts.commandDescription] - 命令描述，描述该命令详细信息，如功能、使用注意事项等。长度小于256。
  optional
      * @param {boolean} [opts.enableParameter] - 是否使用参数, 默认false，不使用参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string commandId  命令Id。
      */

  createCommand (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createCommand"
      )
    }

    opts = opts || {}

    if (opts.commandName === undefined || opts.commandName === null) {
      throw new Error(
        "Missing the required parameter 'opts.commandName' when calling createCommand"
      )
    }
    if (opts.commandContent === undefined || opts.commandContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.commandContent' when calling createCommand"
      )
    }

    let postBody = {}
    if (opts.commandName !== undefined && opts.commandName !== null) {
      postBody['commandName'] = opts.commandName
    }
    if (opts.commandType !== undefined && opts.commandType !== null) {
      postBody['commandType'] = opts.commandType
    }
    if (opts.commandContent !== undefined && opts.commandContent !== null) {
      postBody['commandContent'] = opts.commandContent
    }
    if (opts.timeout !== undefined && opts.timeout !== null) {
      postBody['timeout'] = opts.timeout
    }
    if (opts.username !== undefined && opts.username !== null) {
      postBody['username'] = opts.username
    }
    if (opts.workdir !== undefined && opts.workdir !== null) {
      postBody['workdir'] = opts.workdir
    }
    if (
      opts.commandDescription !== undefined &&
      opts.commandDescription !== null
    ) {
      postBody['commandDescription'] = opts.commandDescription
    }
    if (opts.enableParameter !== undefined && opts.enableParameter !== null) {
      postBody['enableParameter'] = opts.enableParameter
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCommand with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/createCommand',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *
查询用户自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于查询用户保存的自定义命令。

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页数，默认是第一页，取值为 1
  optional
      * @param {integer} [opts.pageSize] - 每页命令数，默认为20，最大为100
  optional
      * @param {array} [opts.commandIds] - 命令Id，最多可传入100个命令Id
  optional
      * @param {array} [opts.commandNames] - 命令名称，长度为1\~128个字符，只允许中文、数字、大小写字母、英文下划线（\_）、连字符（-）及点（.）。最多可传入100个命令名称。
  optional
      * @param {array} [opts.commandTypes] - 命令类型，可选值：shell和powershell，默认shell
  optional
      * @param {string} [opts.sourceType] - 命令来源，可选值：jdcloud（官方）和self，默认self
  optional
      * @param {array} [opts.usernames] - 用户名，执行该命令时的用户身份。在linux上默认是root，windows上默认是administrator。长度小于256
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount  总的命令数，可以根据该字段来决定是否继续查找
      * @param command commands
      */

  describeCommands (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCommands"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.commandIds !== undefined && opts.commandIds !== null) {
      postBody['commandIds'] = opts.commandIds
    }
    if (opts.commandNames !== undefined && opts.commandNames !== null) {
      postBody['commandNames'] = opts.commandNames
    }
    if (opts.commandTypes !== undefined && opts.commandTypes !== null) {
      postBody['commandTypes'] = opts.commandTypes
    }
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.usernames !== undefined && opts.usernames !== null) {
      postBody['usernames'] = opts.usernames
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCommands with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/describeCommands',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *
删除用户自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于删除用户自定义命令。

      * @param {Object} opts - parameters
      * @param {array} [opts.commandIds] - 用户创建的命令Id
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string commandId  命令Id。
      */

  deleteCommands (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCommands"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.commandIds !== undefined && opts.commandIds !== null) {
      postBody['commandIds'] = opts.commandIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCommands with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/deleteCommands',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *
执行用户保存的自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于执行用户保存的自定义命令。

      * @param {Object} opts - parameters
      * @param {string} opts.commandId - 命令Id

      * @param {array} [opts.instances] - 运行该命令的云主机，与tags查到云主机取并集，一次最多云主机数50
  optional
      * @param {array} [opts.tags] - 根据tags确定运行该命令的云主机，与指定instances云主机取并集，一次最多云主机数50
  optional
      * @param {string} [opts.execTime] - 配置运行该命令的时刻，格式&#x60;yyyy-MM-dd HH:mm:ss&#x60;。不传该参数，立即执行命令。默认为空，可配置的时间范围为&#x60;当前时间+10minute&#x60;~&#x60;当前时间+6month&#x60;。
  optional
      * @param {integer} [opts.timeout] - 超时时间，取值范围：[10, 86400], 超过该时间后，尚未执行完的命令会置为失败。默认60s
  optional
      * @param {string} [opts.username] - 用户名，执行该命令时的用户身份。在linux上默认是root，windows上默认是administrator。长度小于256
  optional
      * @param {string} [opts.workdir] - 命令执行路径，在linux上默认为用户的home目录：/root, 在windows上默认为：C:\Windows\system32
  optional
      * @param {string} [opts.windowsPassword] - 和用户名相匹配的密码，仅适用于windows系统
  optional
      * @param {boolean} [opts.enableParameter] - 脚本中是否启用参数，true：启用，false：不启用。
  optional
      * @param {array} [opts.parameters] - 用户自定义参数和对应的参数值，数量不超过20。
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string invokeId  命令调用Id。
      */

  invokeCommand (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invokeCommand"
      )
    }

    opts = opts || {}

    if (opts.commandId === undefined || opts.commandId === null) {
      throw new Error(
        "Missing the required parameter 'opts.commandId' when calling invokeCommand"
      )
    }

    let postBody = {}
    if (opts.commandId !== undefined && opts.commandId !== null) {
      postBody['commandId'] = opts.commandId
    }
    if (opts.instances !== undefined && opts.instances !== null) {
      postBody['instances'] = opts.instances
    }
    if (opts.tags !== undefined && opts.tags !== null) {
      postBody['tags'] = opts.tags
    }
    if (opts.execTime !== undefined && opts.execTime !== null) {
      postBody['execTime'] = opts.execTime
    }
    if (opts.timeout !== undefined && opts.timeout !== null) {
      postBody['timeout'] = opts.timeout
    }
    if (opts.username !== undefined && opts.username !== null) {
      postBody['username'] = opts.username
    }
    if (opts.workdir !== undefined && opts.workdir !== null) {
      postBody['workdir'] = opts.workdir
    }
    if (opts.windowsPassword !== undefined && opts.windowsPassword !== null) {
      postBody['windowsPassword'] = opts.windowsPassword
    }
    if (opts.enableParameter !== undefined && opts.enableParameter !== null) {
      postBody['enableParameter'] = opts.enableParameter
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invokeCommand with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invokeCommand',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *
查询命令调用。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于查询命令调用。

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页数，默认是第一页，取值1
  optional
      * @param {integer} [opts.pageSize] - 每页大小，默认20, 最大100
  optional
      * @param {array} [opts.invokeIds] - 命令执行Id
  optional
      * @param {array} [opts.commandIds] - 命令Id
  optional
      * @param {array} [opts.status] - 命令执行状态
  optional
      * @param {array} [opts.commandNames] - 命令名字
  optional
      * @param {array} [opts.commandTypes] - 命令类型， shell or powershell
  optional
      * @param {array} [opts.userNames] - 命令执行用户
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount  命令调用的总数
      * @param invocation invocations
      */

  describeInvocations (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvocations"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.invokeIds !== undefined && opts.invokeIds !== null) {
      postBody['invokeIds'] = opts.invokeIds
    }
    if (opts.commandIds !== undefined && opts.commandIds !== null) {
      postBody['commandIds'] = opts.commandIds
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.commandNames !== undefined && opts.commandNames !== null) {
      postBody['commandNames'] = opts.commandNames
    }
    if (opts.commandTypes !== undefined && opts.commandTypes !== null) {
      postBody['commandTypes'] = opts.commandTypes
    }
    if (opts.userNames !== undefined && opts.userNames !== null) {
      postBody['userNames'] = opts.userNames
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvocations with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/describeInvocations',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *
配置用户日志信息。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于配置用户日志信息。

      * @param {Object} opts - parameters
      * @param {string} [opts.logset] - 用户日志集名字
  optional
      * @param {string} opts.logtopic - 用户日志主题名字

      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addLogConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addLogConfig"
      )
    }

    opts = opts || {}

    if (opts.logtopic === undefined || opts.logtopic === null) {
      throw new Error(
        "Missing the required parameter 'opts.logtopic' when calling addLogConfig"
      )
    }

    let postBody = {}
    if (opts.logset !== undefined && opts.logset !== null) {
      postBody['logset'] = opts.logset
    }
    if (opts.logtopic !== undefined && opts.logtopic !== null) {
      postBody['logtopic'] = opts.logtopic
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  assistant/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLogConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/addLogConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = ASSISTANT
