/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 运营后台类接口
 * 京东云验证码-OpenAPI应用管理类接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'captcha'
Service._services[serviceId] = true

/**
 * captcha service.
 * @version 1.0.1
 */

class CAPTCHA extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'captcha.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  获取会话id
      * @param {Object} opts - parameters
      * @param {} [opts.appId] - 应用id  optional
      * @param {} [opts.sceneId] - 场景id  optional
      * @param {} [opts.secret] - 密钥，从界面获取  optional
      * @param {} [opts.uuid] - uuid，ios客户端传openudid, android客户端传androidid, m, pc, wxapp客户端此值为空即可  optional
      * @param {} [opts.ip] - 客户端ip  optional
      * @param {} [opts.userAgent] - 客户端userAgent  optional
      * @param {} [opts.fingerPrint] - 指纹，ios和android客户端(clientType)从sdk获取, m, pc, wxapp客户端此值为空即可  optional
      * @param {} [opts.clientType] - 客户端类型, android, ios, pc, wxmapp, m  optional
      * @param {} [opts.clientVersion] - 客户端版本，用户端app版本，可选  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param sessionDataResp data
      */

  getSessionId (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.sceneId !== undefined && opts.sceneId !== null) {
      postBody['sceneId'] = opts.sceneId
    }
    if (opts.secret !== undefined && opts.secret !== null) {
      postBody['secret'] = opts.secret
    }
    if (opts.uuid !== undefined && opts.uuid !== null) {
      postBody['uuid'] = opts.uuid
    }
    if (opts.ip !== undefined && opts.ip !== null) {
      postBody['ip'] = opts.ip
    }
    if (opts.userAgent !== undefined && opts.userAgent !== null) {
      postBody['userAgent'] = opts.userAgent
    }
    if (opts.fingerPrint !== undefined && opts.fingerPrint !== null) {
      postBody['fingerPrint'] = opts.fingerPrint
    }
    if (opts.clientType !== undefined && opts.clientType !== null) {
      postBody['clientType'] = opts.clientType
    }
    if (opts.clientVersion !== undefined && opts.clientVersion !== null) {
      postBody['clientVersion'] = opts.clientVersion
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  captcha/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSessionId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/captcha:getsessionid',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  验证verifyToken
      * @param {Object} opts - parameters
      * @param {} [opts.verifyToken] - 提交后台校验的token，客户端sdk获取  optional
      * @param {} [opts.sessionId] - 验证码会话id，getsessionid返回  optional
      * @param {} [opts.appId] - 应用id  optional
      * @param {} [opts.sceneId] - 场景id  optional
      * @param {} [opts.secret] - 密钥，从界面获取  optional
      * @param {} [opts.ip] - 客户端ip  optional
      * @param {} [opts.userAgent] - 客户端userAgent  optional
      * @param {} [opts.clientType] - 客户端类型, 可选值: android, ios, pc, wxapp, m  optional
      * @param {} [opts.clientVersion] - 客户端版本，用户端app版本，可选  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param verifyDataResp data
      */

  verifyToken (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.verifyToken !== undefined && opts.verifyToken !== null) {
      postBody['verifyToken'] = opts.verifyToken
    }
    if (opts.sessionId !== undefined && opts.sessionId !== null) {
      postBody['sessionId'] = opts.sessionId
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.sceneId !== undefined && opts.sceneId !== null) {
      postBody['sceneId'] = opts.sceneId
    }
    if (opts.secret !== undefined && opts.secret !== null) {
      postBody['secret'] = opts.secret
    }
    if (opts.ip !== undefined && opts.ip !== null) {
      postBody['ip'] = opts.ip
    }
    if (opts.userAgent !== undefined && opts.userAgent !== null) {
      postBody['userAgent'] = opts.userAgent
    }
    if (opts.clientType !== undefined && opts.clientType !== null) {
      postBody['clientType'] = opts.clientType
    }
    if (opts.clientVersion !== undefined && opts.clientVersion !== null) {
      postBody['clientVersion'] = opts.clientVersion
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  captcha/1.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call verifyToken with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/captcha:verifytoken',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = CAPTCHA
