/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SCDN相关接口
 * Openapi For JCLOUD cdn
 *
 * OpenAPI spec version: v1
 * Contact: pid-cdn@jd.com
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'cdn'
Service._services[serviceId] = true

/**
 * cdn service.
 * @version 0.10.47
 */

class CDN extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'cdn.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  批量域名查询日志
      * @param {Object} opts - parameters
      * @param {} [opts.domains]   optional
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.interval] - 时间间隔，取值(hour，day，fiveMin)，不传默认小时。  optional
      * @param {} [opts.logType] - 日志类型，取值(log，zip,gz)，不传默认gz。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param domainsLog logs
      */

  queryDomainsLog (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domains !== undefined && opts.domains !== null) {
      postBody['domains'] = opts.domains
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      postBody['interval'] = opts.interval
    }
    if (opts.logType !== undefined && opts.logType !== null) {
      postBody['logType'] = opts.logType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainsLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/logs',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量域名查询日志-pin维度
      * @param {Object} opts - parameters
      * @param {} [opts.pin] - pin  optional
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.interval] - 时间间隔，取值(hour，day，fiveMin)，不传默认小时。  optional
      * @param {} [opts.logType] - 日志类型，取值(log，zip,gz)，不传默认gz。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param domainsLog logs
      */

  queryDomainsLogForJd (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      postBody['interval'] = opts.interval
    }
    if (opts.logType !== undefined && opts.logType !== null) {
      postBody['logType'] = opts.logType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainsLogForJd with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/logsJd',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询日志
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.interval] - 时间间隔，取值(hour，day，fiveMin)，不传默认小时。  optional
      * @param {} [opts.logType] - 日志类型，取值(log，zip,gz)，不传默认gz。  optional
      * @param {} [opts.pageSize] - 页面大小，默认值10  optional
      * @param {} [opts.pageNumber] - 分页页数，默认值1  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总的数量
      * @param integer pageSize  页面大小
      * @param integer pageNumber  页面页数
      * @param domainLog urls
      */

  queryDomainLog (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryDomainLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      queryParams['interval'] = opts.interval
    }
    if (opts.logType !== undefined && opts.logType !== null) {
      queryParams['logType'] = opts.logType
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/log',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置线上计费方式
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param integer allType  计费方式,取值[0,1],0:日流量计费,1:日峰值带宽计费.
      * @param integer vip  vip(1:vip客户,0:普通客户)
      */

  queryOnlineBillingType (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryOnlineBillingType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/onlineBillingType',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置线上计费方式
      * @param {Object} opts - parameters
      * @param {} [opts.allType] - 计费方式,取值[0,1],0:日流量计费,1:日峰值带宽计费.  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setOnlineBillingType (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.allType !== undefined && opts.allType !== null) {
      postBody['allType'] = opts.allType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setOnlineBillingType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/onlineBillingType',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  dash鉴权设置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.enableUrlAuth] - 是否开启鉴权[on,off]  optional
      * @param {} [opts.authKey] - 鉴权key  optional
      * @param {} [opts.age] - 鉴权时间戳过期时间，默认为0  optional
      * @param {} [opts.encAlgorithm] - 鉴权参数加密算法，默认为md5且只支持md5  optional
      * @param {} [opts.timeFormat] - 时间戳格式[hex,dec]  optional
      * @param {} [opts.uriType] - 加密算法版本[dash,dashv2,video],默认dashv2  optional
      * @param {} [opts.rule] - 鉴权key生成顺序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务的id
      */

  setAuthConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setAuthConfig"
      )
    }

    let postBody = {}
    if (opts.enableUrlAuth !== undefined && opts.enableUrlAuth !== null) {
      postBody['enableUrlAuth'] = opts.enableUrlAuth
    }
    if (opts.authKey !== undefined && opts.authKey !== null) {
      postBody['authKey'] = opts.authKey
    }
    if (opts.age !== undefined && opts.age !== null) {
      postBody['age'] = opts.age
    }
    if (opts.encAlgorithm !== undefined && opts.encAlgorithm !== null) {
      postBody['encAlgorithm'] = opts.encAlgorithm
    }
    if (opts.timeFormat !== undefined && opts.timeFormat !== null) {
      postBody['timeFormat'] = opts.timeFormat
    }
    if (opts.uriType !== undefined && opts.uriType !== null) {
      postBody['uriType'] = opts.uriType
    }
    if (opts.rule !== undefined && opts.rule !== null) {
      postBody['rule'] = opts.rule
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setAuthConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/setAuthConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  回源鉴权设置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.enable] - 是否开启鉴权[on,off]  optional
      * @param {} [opts.originRole] - 回源为主/备[master,slave]  optional
      * @param {} [opts.authType] - 鉴权类型[oss,aws,tos],aws暂不支持  optional
      * @param {} [opts.tosAuthInfo] - tos类型鉴权参数,authType为tos是不能为空  optional
      * @param {} [opts.ossAuthInfo] - oss类型鉴权参数,authType为oss是不能为空  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务的id
      */

  setSourceAuthConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setSourceAuthConfig"
      )
    }

    let postBody = {}
    if (opts.enable !== undefined && opts.enable !== null) {
      postBody['enable'] = opts.enable
    }
    if (opts.originRole !== undefined && opts.originRole !== null) {
      postBody['originRole'] = opts.originRole
    }
    if (opts.authType !== undefined && opts.authType !== null) {
      postBody['authType'] = opts.authType
    }
    if (opts.tosAuthInfo !== undefined && opts.tosAuthInfo !== null) {
      postBody['tosAuthInfo'] = opts.tosAuthInfo
    }
    if (opts.ossAuthInfo !== undefined && opts.ossAuthInfo !== null) {
      postBody['ossAuthInfo'] = opts.ossAuthInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setSourceAuthConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/setSourceAuthConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  带宽查询接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.area] - 地域  optional
      * @param {} [opts.isp] - 运营商  optional
      * @param {} [opts.period] - 查询周期  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param bandTrafficDataItem resultList
      */

  queryBand (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBand with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/bandQuery',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分地域运营商带宽查询接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.area] - 地域  optional
      * @param {} [opts.isp] - 运营商  optional
      * @param {} [opts.period] - 查询周期  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param bandTrafficWithAreaDataItem resultList
      */

  queryBandWithArea (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBandWithArea with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/bandQuery:areaIsp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名配置状态
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务ID
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskStatus  任务状态,[success:成功,failed:失败,configuring:配置中]
      */

  queryDomainConfigStatus (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling queryDomainConfigStatus"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainConfigStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{taskId}/status',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查找地域运营商列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param areaIspItem mainLand
      * @param areaIspItem overseas
      * @param areaIspItem isp
      * @param areaIspItem gangaotai
      * @param areaIspItem oceanica
      * @param areaIspItem southAmerica
      * @param areaIspItem northAmerica
      * @param areaIspItem asia
      * @param areaIspItem europe
      */

  queryAreaIspList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAreaIspList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/console:areaIspList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查找地域运营商列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param areaIspItem mainLand
      * @param areaIspItem overseas
      * @param areaIspItem isp
      * @param areaIspItem africa
      * @param areaIspItem oceania
      * @param areaIspItem southAmerica
      * @param areaIspItem northAmerica
      * @param areaIspItem asia
      * @param areaIspItem europe
      * @param areaIspItem midEast
      */

  queryAreaIspListV2 (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAreaIspListV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/console:areaIspListV2',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询封禁信息
      * @param {Object} opts - parameters
      * @param {} [opts.queryDomain] - 封禁域名,模糊查询  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,精确查询  optional
      * @param {} [opts.pageNumber] - 页码数  optional
      * @param {} [opts.pageSize] - 每页size  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总的数量
      * @param forbiddenInfo list
      */

  queryForbiddenInfoList (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.queryDomain !== undefined && opts.queryDomain !== null) {
      postBody['queryDomain'] = opts.queryDomain
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryForbiddenInfoList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfo:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置封禁
      * @param {Object} opts - parameters
      * @param {} [opts.forbiddenType] - 封禁类型，domain 域名封禁,url url封禁  optional
      * @param {} [opts.forbiddenDomain] - 封禁域名  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,多个以;隔开  optional
      * @param {} [opts.reason] - 封禁原因  optional
      * @param {} [opts.linkOther] - y,n y表示是，n表示否  optional
      * @param {} [opts.shareCacheDomainFlag] - 是否同步操作共享缓存域名,0:仅操作本域名,1:同步操作共享缓存域名,默认为0  optional
      * @param {} [opts.token] - 用于封禁前缀识别的URL,应为单个特殊字符，如：~  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createForbiddenInfo (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.forbiddenType !== undefined && opts.forbiddenType !== null) {
      postBody['forbiddenType'] = opts.forbiddenType
    }
    if (opts.forbiddenDomain !== undefined && opts.forbiddenDomain !== null) {
      postBody['forbiddenDomain'] = opts.forbiddenDomain
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (opts.reason !== undefined && opts.reason !== null) {
      postBody['reason'] = opts.reason
    }
    if (opts.linkOther !== undefined && opts.linkOther !== null) {
      postBody['linkOther'] = opts.linkOther
    }
    if (
      opts.shareCacheDomainFlag !== undefined &&
      opts.shareCacheDomainFlag !== null
    ) {
      postBody['shareCacheDomainFlag'] = opts.shareCacheDomainFlag
    }
    if (opts.token !== undefined && opts.token !== null) {
      postBody['token'] = opts.token
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createForbiddenInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfo:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除封禁信息
      * @param {Object} opts - parameters
      * @param {} [opts.forbiddenType] - 封禁类型，domain 域名封禁,url url封禁  optional
      * @param {} [opts.forbiddenDomain] - 封禁域名  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,多个以;隔开  optional
      * @param {} [opts.shareCacheDomainFlag] - 是否同步操作共享缓存域名,0:仅操作本域名,1:同步操作共享缓存域名,默认为0  optional
      * @param {} [opts.token] - 用于封禁前缀识别的URL,应为单个特殊字符，如：~  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId
      */

  deleteForbiddenInfo (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.forbiddenType !== undefined && opts.forbiddenType !== null) {
      postBody['forbiddenType'] = opts.forbiddenType
    }
    if (opts.forbiddenDomain !== undefined && opts.forbiddenDomain !== null) {
      postBody['forbiddenDomain'] = opts.forbiddenDomain
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (
      opts.shareCacheDomainFlag !== undefined &&
      opts.shareCacheDomainFlag !== null
    ) {
      postBody['shareCacheDomainFlag'] = opts.shareCacheDomainFlag
    }
    if (opts.token !== undefined && opts.token !== null) {
      postBody['token'] = opts.token
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteForbiddenInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfo:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询解封状态
      * @param {Object} opts - parameters
      * @param {string} [opts.domain] - 根据域名进行匹配  optional
      * @param {string} [opts.url] - 根据url进行匹配  optional
      * @param {string} [opts.taskId] - 解封的任务id  optional
      * @param {integer} [opts.pageNumber] - pageNumber,默认值1  optional
      * @param {integer} [opts.pageSize] - pageSize,最大值50,默认值10  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总的数量
      * @param unForbiddenTaskItem tasks
      */

  queryUnForbiddenStatus (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.domain !== undefined && opts.domain !== null) {
      queryParams['domain'] = opts.domain
    }
    if (opts.url !== undefined && opts.url !== null) {
      queryParams['url'] = opts.url
    }
    if (opts.taskId !== undefined && opts.taskId !== null) {
      queryParams['taskId'] = opts.taskId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUnForbiddenStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/unForbiddenStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询封禁解封信息
      * @param {Object} opts - parameters
      * @param {} [opts.queryDomain] - 封禁域名.queryDomain和taskId至少传入一个  optional
      * @param {} [opts.taskId] - 任务id.queryDomain和taskId至少传入一个  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,精确查询  optional
      * @param {} [opts.pageNumber] - 页码数  optional
      * @param {} [opts.pageSize] - 每页size  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总的数量
      * @param forbiddenInfoCommon list
      */

  queryForbiddenInfoListCommon (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.queryDomain !== undefined && opts.queryDomain !== null) {
      postBody['queryDomain'] = opts.queryDomain
    }
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryForbiddenInfoListCommon with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfoCommon:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置封禁
      * @param {Object} opts - parameters
      * @param {} [opts.forbiddenType] - 封禁类型，domain:域名封禁,url:url封禁  optional
      * @param {} [opts.forbiddenDomain] - 封禁域名  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,多个以;隔开。单url最大字符长度1024,以/开头，内容中不包含逗号.forbiddenType为url时需传入  optional
      * @param {} [opts.reason] - 封禁原因  optional
      * @param {} [opts.linkOther] - y,n y表示是，n表示否,默认n。forbiddenType为domain时可传入，若为y表示封禁该域名后，不允许添加该域名的根域名以及根域名下的所有子域名  optional
      * @param {} [opts.shareCacheDomainFlag] - forbiddenType为url时可传入。即当forbiddenDomain为域名组共享缓存主域名时，是否同步操作共享缓存从域名下的url,0:仅操作本域名,1:同步操作共享缓存域名,默认为0。  optional
      * @param {} [opts.token] - forbiddenType为url时有效。用于封禁前缀识别的URL,应为单个特殊字符，如：~  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId
      */

  createForbiddenInfoCommon (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.forbiddenType !== undefined && opts.forbiddenType !== null) {
      postBody['forbiddenType'] = opts.forbiddenType
    }
    if (opts.forbiddenDomain !== undefined && opts.forbiddenDomain !== null) {
      postBody['forbiddenDomain'] = opts.forbiddenDomain
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (opts.reason !== undefined && opts.reason !== null) {
      postBody['reason'] = opts.reason
    }
    if (opts.linkOther !== undefined && opts.linkOther !== null) {
      postBody['linkOther'] = opts.linkOther
    }
    if (
      opts.shareCacheDomainFlag !== undefined &&
      opts.shareCacheDomainFlag !== null
    ) {
      postBody['shareCacheDomainFlag'] = opts.shareCacheDomainFlag
    }
    if (opts.token !== undefined && opts.token !== null) {
      postBody['token'] = opts.token
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createForbiddenInfoCommon with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfoCommon:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除封禁信息
      * @param {Object} opts - parameters
      * @param {} [opts.forbiddenType] - 封禁类型，domain:域名封禁,url:url封禁  optional
      * @param {} [opts.forbiddenDomain] - 封禁域名  optional
      * @param {} [opts.forbiddenUrl] - 封禁url,多个以;隔开。单url最大字符长度1024,以/开头，内容中不包含逗号.forbiddenType为url时需传入  optional
      * @param {} [opts.shareCacheDomainFlag] - forbiddenType为url时有效。即当forbiddenDomain为域名组共享缓存主域名时，是否同步操作共享缓存从域名下的url,0:仅操作本域名,1:同步操作共享缓存域名,默认为0。  optional
      * @param {} [opts.token] - forbiddenType为url时有效。用于封禁前缀识别的URL,应为单个特殊字符，如：~  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId
      */

  deleteForbiddenInfoCommon (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.forbiddenType !== undefined && opts.forbiddenType !== null) {
      postBody['forbiddenType'] = opts.forbiddenType
    }
    if (opts.forbiddenDomain !== undefined && opts.forbiddenDomain !== null) {
      postBody['forbiddenDomain'] = opts.forbiddenDomain
    }
    if (opts.forbiddenUrl !== undefined && opts.forbiddenUrl !== null) {
      postBody['forbiddenUrl'] = opts.forbiddenUrl
    }
    if (
      opts.shareCacheDomainFlag !== undefined &&
      opts.shareCacheDomainFlag !== null
    ) {
      postBody['shareCacheDomainFlag'] = opts.shareCacheDomainFlag
    }
    if (opts.token !== undefined && opts.token !== null) {
      postBody['token'] = opts.token
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteForbiddenInfoCommon with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/forbiddenInfoCommon:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  预览证书
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.content]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string sigAlgName
      * @param string issuer
      * @param string startDate
      * @param string endDate
      * @param string user
      * @param string sigHashAlgName
      */

  previewCertificate (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling previewCertificate"
      )
    }

    let postBody = {}
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call previewCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/certificate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询默认http header头部参数列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string reqDefaultHttpHeaderKey
      * @param string respDefaultHttpHeaderKey
      */

  queryDefaultHttpHeaderKey (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDefaultHttpHeaderKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/defaultHttpHeaderKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询ip黑白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param string ips
      * @param string status  黑名单状态,on:开启,off:关闭
      * @param string whiteIps
      */

  queryIpBlackList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryIpBlackList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ipBlackList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置ip黑名白单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ips] - ip名单,ips中url不能超过50条，中国境外/全球加速域名暂不支持传IP段  optional
      * @param {} [opts.ipListType] - ip黑白名单类型，black:黑名单,white:白名单  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setIpBlackList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setIpBlackList"
      )
    }

    let postBody = {}
    if (opts.ips !== undefined && opts.ips !== null) {
      postBody['ips'] = opts.ips
    }
    if (opts.ipListType !== undefined && opts.ipListType !== null) {
      postBody['ipListType'] = opts.ipListType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ipBlackList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置ip黑名单状态
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - ip黑名单状态取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  operateIpBlackList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling operateIpBlackList"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operateIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ipBlackList:operate',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询自定义错误页面信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param string enable  自定义错误页面开关(on:开启 off：关闭)
      * @param errorPageConfigs customErrorPageInfos
      */

  queryCustomErrorPage (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryCustomErrorPage"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCustomErrorPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/customErrorPage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置自定义错误页面信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.errorPageConfigs] - 自定义错误页面配置  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setCustomErrorPage (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setCustomErrorPage"
      )
    }

    let postBody = {}
    if (opts.errorPageConfigs !== undefined && opts.errorPageConfigs !== null) {
      postBody['errorPageConfigs'] = opts.errorPageConfigs
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setCustomErrorPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/customErrorPage',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加缓存规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.weight] - 此条配置的权重值, 取值范围为1-10,1最大  optional
      * @param {} [opts.ttl] - 缓存时间,单位秒，中国境内加速域名最长可配置2年，中国境外/全球加速域名最长可配置1年  optional
      * @param {} [opts.contents] - 规则内容。其他类型只能以/或者.开头，如/a/b或.jpg  optional
      * @param {} [opts.cacheType] - 缓存方式：0、不缓存，1自定义  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer configId  缓存规则配置ID
      */

  createCacheRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createCacheRule"
      )
    }

    let postBody = {}
    if (opts.weight !== undefined && opts.weight !== null) {
      postBody['weight'] = opts.weight
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.contents !== undefined && opts.contents !== null) {
      postBody['contents'] = opts.contents
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCacheRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/cacheRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改缓存规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.weight] - 此条配置的权重值, 取值范围为1-10,1最大  optional
      * @param {} [opts.ttl] - 缓存时间,单位秒，中国境内加速域名最长可配置2年，中国境外/全球加速域名最长可配置1年  optional
      * @param {} [opts.contents] - 规则内容。其他类型只能以/或者.开头，如/a/b或.jpg  optional
      * @param {} [opts.cacheType] - 缓存方式：0、不缓存，1自定义  optional
      * @param {} [opts.configId] - 缓存规则配置ID  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateCacheRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling updateCacheRule"
      )
    }

    let postBody = {}
    if (opts.weight !== undefined && opts.weight !== null) {
      postBody['weight'] = opts.weight
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.contents !== undefined && opts.contents !== null) {
      postBody['contents'] = opts.contents
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.configId !== undefined && opts.configId !== null) {
      postBody['configId'] = opts.configId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCacheRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/cacheRule',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除缓存规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.configId] - 缓存规则配置ID  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCacheRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteCacheRule"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.configId !== undefined && opts.configId !== null) {
      queryParams['configId'] = opts.configId
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCacheRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/cacheRule',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量添加缓存规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.cacheRules]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param cacheVo data
      */

  setCacheRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setCacheRules"
      )
    }

    let postBody = {}
    if (opts.cacheRules !== undefined && opts.cacheRules !== null) {
      postBody['cacheRules'] = opts.cacheRules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setCacheRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/cacheRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询http header头
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.edgeType] - header生效节点，0边缘，1回源，2两者都  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param queryHttpHeaderResp headers
      */

  queryHttpHeader (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryHttpHeader"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.edgeType !== undefined && opts.edgeType !== null) {
      queryParams['edgeType'] = opts.edgeType
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryHttpHeader with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/httpHeader',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加httpHeader
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.edgeType] - 0表示header在边缘生效，1表示header回源生效，2表示在边缘和回源都生效，该字段不传时默认header在边缘和回源都生效  optional
      * @param {} [opts.headerType] - header类型[resp,req],resp：配置响应头，req：配置请求头  optional
      * @param {} [opts.headerName] - header名，例如：Content-Disposition，可自定义，长度不能超过256个字符，不能包含中文字符，不能包含$和_，不支持设置如下头名：[&quot;Content-Length&quot;,&quot;Date&quot;,&quot;Host&quot;,&quot;Content-Encoding&quot;,&quot;If-Modified-Since&quot;,&quot;If-Range&quot;,&quot;Content-Type&quot;,&quot;Transfer-Encoding&quot;,&quot;Cache-Control&quot;,&quot;Last-Modified&quot;,&quot;Connection&quot;, &quot;Content-Range&quot;,&quot;ETag&quot;,&quot;Age&quot;,&quot;Authentication-Info&quot;,&quot;Proxy-Authenticate&quot;,&quot;Retry-After&quot;,&quot;Set-Cookie&quot;,&quot;Vary&quot;,&quot;Content-Location&quot;,&quot;Meter&quot;,&quot;Allow&quot;,&quot;Error&quot;,&quot;X-Trace&quot;, &quot;Proxy-Connection&quot;]  optional
      * @param {} [opts.headerValue] - header值，不能包含($,_,#)，不能超过256个字符  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setHttpHeader (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setHttpHeader"
      )
    }

    let postBody = {}
    if (opts.edgeType !== undefined && opts.edgeType !== null) {
      postBody['edgeType'] = opts.edgeType
    }
    if (opts.headerType !== undefined && opts.headerType !== null) {
      postBody['headerType'] = opts.headerType
    }
    if (opts.headerName !== undefined && opts.headerName !== null) {
      postBody['headerName'] = opts.headerName
    }
    if (opts.headerValue !== undefined && opts.headerValue !== null) {
      postBody['headerValue'] = opts.headerValue
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setHttpHeader with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/httpHeader',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除httpHeader
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.edgeType] - 0表示header在边缘生效，1表示header回源生效，2表示在边缘和回源都生效，该字段不传时默认header在边缘和回源都生效  optional
      * @param {} [opts.headerType] - header类型[resp,req]  optional
      * @param {} [opts.headerName] - header名  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteHttpHeader (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteHttpHeader"
      )
    }

    let postBody = {}
    if (opts.edgeType !== undefined && opts.edgeType !== null) {
      postBody['edgeType'] = opts.edgeType
    }
    if (opts.headerType !== undefined && opts.headerType !== null) {
      postBody['headerType'] = opts.headerType
    }
    if (opts.headerName !== undefined && opts.headerName !== null) {
      postBody['headerName'] = opts.headerName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteHttpHeader with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/httpHeader',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置视频拖拽
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setVideoDraft (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setVideoDraft"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setVideoDraft with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/videoDraft',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置range参数
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setRange (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setRange"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setRange with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/range',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置忽略参数
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setIgnoreQueryString (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setIgnoreQueryString"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setIgnoreQueryString with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ignoreQueryString',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置过滤参数
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.retainArgs] - 保留参数，多个用;隔开  optional
      * @param {} [opts.status] - 忽略参数开关，取值：on or off  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setFilterArgs (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setFilterArgs"
      )
    }

    let postBody = {}
    if (opts.retainArgs !== undefined && opts.retainArgs !== null) {
      postBody['retainArgs'] = opts.retainArgs
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setFilterArgs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/filterArgs:set',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询保留参数信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param string retainArgs
      * @param string ignoreQueryString  忽略参数开关
      */

  queryFilterArgs (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryFilterArgs"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryFilterArgs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/filterArgs:query',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置userAgent信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param string userAgentType  userAgent类型,取值：block（黑名单）,allow（白名单）,默认为block
      * @param string userAgentList
      * @param string allowNoUserAgentHeader  是否允许空userAgent访问,默认为“on”
      */

  queryUserAgent (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryUserAgent"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUserAgent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/userAgentConfig',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置userAgent信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.userAgentType] - userAgent类型,取值：block（黑名单）,allow（白名单）,默认为block  optional
      * @param {} [opts.userAgentList] - UA列表,如果userAgentList为空,则为全部删除  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setUserAgentConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setUserAgentConfig"
      )
    }

    let postBody = {}
    if (opts.userAgentType !== undefined && opts.userAgentType !== null) {
      postBody['userAgentType'] = opts.userAgentType
    }
    if (opts.userAgentList !== undefined && opts.userAgentList !== null) {
      postBody['userAgentList'] = opts.userAgentList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setUserAgentConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/userAgentConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询url鉴权
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param integer accesskeyType  鉴权类型，0表示无鉴权，1表示参数鉴权，2表示路径鉴权
      * @param string accesskeyKey  密码，长度为8到32
      * @param integer accesskeyKeep  是否是回源鉴权 0表示是 1表示否
      */

  queryAccesskeyConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryAccesskeyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAccesskeyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/accesskeyConfig',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置url鉴权
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.accesskeyType] - 鉴权类型，0表示无鉴权，1表示参数鉴权，2表示路径鉴权  optional
      * @param {} [opts.accesskeyKey] - 密码，长度为8到32  optional
      * @param {} [opts.accesskeyKeep] - 是否是回源鉴权 0表示是 1表示否  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setAccesskeyConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setAccesskeyConfig"
      )
    }

    let postBody = {}
    if (opts.accesskeyType !== undefined && opts.accesskeyType !== null) {
      postBody['accesskeyType'] = opts.accesskeyType
    }
    if (opts.accesskeyKey !== undefined && opts.accesskeyKey !== null) {
      postBody['accesskeyKey'] = opts.accesskeyKey
    }
    if (opts.accesskeyKeep !== undefined && opts.accesskeyKeep !== null) {
      postBody['accesskeyKeep'] = opts.accesskeyKeep
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setAccesskeyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/accesskeyConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置域名refer
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.referType] - refer类型，取值：block（黑名单），allow（白名单）默认为block  optional
      * @param {} [opts.referList] - 逗号隔开的域名列表，如果referList传空则为删除，中国境内加速域名至多可配置400条，中国境外/全球加速域名至多可配置50条  optional
      * @param {} [opts.allowNoReferHeader] - 是否允许空refer访问，默认为“on”  optional
      * @param {} [opts.allowNullReferHeader] - 是否允许无ua访问，默认为“on”  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setRefer (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setRefer"
      )
    }

    let postBody = {}
    if (opts.referType !== undefined && opts.referType !== null) {
      postBody['referType'] = opts.referType
    }
    if (opts.referList !== undefined && opts.referList !== null) {
      postBody['referList'] = opts.referList
    }
    if (
      opts.allowNoReferHeader !== undefined &&
      opts.allowNoReferHeader !== null
    ) {
      postBody['allowNoReferHeader'] = opts.allowNoReferHeader
    }
    if (
      opts.allowNullReferHeader !== undefined &&
      opts.allowNullReferHeader !== null
    ) {
      postBody['allowNullReferHeader'] = opts.allowNullReferHeader
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setRefer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/refer',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询源站监控信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param integer cycle  探测周期，单位分钟
      * @param string monitorPath  探测路径
      * @param object httpRequestHeader  查询结果,类型为HashMap&lt;String, Object&gt;
      */

  queryMonitor (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryMonitor"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/monitor',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置源站监控信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.cycle] - 探测周期，取值1和5，单位为分钟  optional
      * @param {} [opts.monitorPath] - 探测路径  optional
      * @param {} [opts.httpRequestHeader] - http请求头  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer monitorId
      */

  setMonitor (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setMonitor"
      )
    }

    let postBody = {}
    if (opts.cycle !== undefined && opts.cycle !== null) {
      postBody['cycle'] = opts.cycle
    }
    if (opts.monitorPath !== undefined && opts.monitorPath !== null) {
      postBody['monitorPath'] = opts.monitorPath
    }
    if (
      opts.httpRequestHeader !== undefined &&
      opts.httpRequestHeader !== null
    ) {
      postBody['httpRequestHeader'] = opts.httpRequestHeader
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/monitor',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止源站监控
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      */

  stopMonitor (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling stopMonitor"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/monitor:stop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置源站信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.sourceType] - 回源类型只能是[ips,domain,oss]中的一种  optional
      * @param {} [opts.backSourceType] - 回源方式,只能是[https,http]中的一种,默认http  optional
      * @param {} [opts.accelerateRegion] - 加速区域,必须是[mainland,nonMainland,all]中的一种,分别代表大陆,海外+中国港澳台,全球  optional
      * @param {} [opts.ipSource]   optional
      * @param {} [opts.domainSource]   optional
      * @param {} [opts.ossSource] - oss回源域名  optional
      * @param {} [opts.defaultSourceHost] - 默认回源host  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务id
      */

  setSource (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setSource"
      )
    }

    let postBody = {}
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }
    if (opts.ipSource !== undefined && opts.ipSource !== null) {
      postBody['ipSource'] = opts.ipSource
    }
    if (opts.domainSource !== undefined && opts.domainSource !== null) {
      postBody['domainSource'] = opts.domainSource
    }
    if (opts.ossSource !== undefined && opts.ossSource !== null) {
      postBody['ossSource'] = opts.ossSource
    }
    if (
      opts.defaultSourceHost !== undefined &&
      opts.defaultSourceHost !== null
    ) {
      postBody['defaultSourceHost'] = opts.defaultSourceHost
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setSource with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/source',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  泛域名共享缓存
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 共享缓存只能是off或者on  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  operateShareCache (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling operateShareCache"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operateShareCache with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/shareCache',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置http协议
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.httpType] - http类型,只能为http或者https,默认为http.当设为https时,需要调用“设置通讯协议”接口上传证书和私钥  optional
      * @param {} [opts.certificate] - 用户证书,当Type为https时必须设置  optional
      * @param {} [opts.rsaKey] - 证书私钥  optional
      * @param {} [opts.jumpType] - 有三种类型：default、http、https  optional
      * @param {} [opts.certFrom] - 证书来源有两种类型：default,ssl  optional
      * @param {} [opts.sslCertId] - ssl证书id  optional
      * @param {} [opts.syncToSsl] - 是否同步到ssl,boolean值，取值true或者false  optional
      * @param {} [opts.certName] - syncToSsl是true时，certName是必填项  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务taskId
      */

  setHttpType (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setHttpType"
      )
    }

    let postBody = {}
    if (opts.httpType !== undefined && opts.httpType !== null) {
      postBody['httpType'] = opts.httpType
    }
    if (opts.certificate !== undefined && opts.certificate !== null) {
      postBody['certificate'] = opts.certificate
    }
    if (opts.rsaKey !== undefined && opts.rsaKey !== null) {
      postBody['rsaKey'] = opts.rsaKey
    }
    if (opts.jumpType !== undefined && opts.jumpType !== null) {
      postBody['jumpType'] = opts.jumpType
    }
    if (opts.certFrom !== undefined && opts.certFrom !== null) {
      postBody['certFrom'] = opts.certFrom
    }
    if (opts.sslCertId !== undefined && opts.sslCertId !== null) {
      postBody['sslCertId'] = opts.sslCertId
    }
    if (opts.syncToSsl !== undefined && opts.syncToSsl !== null) {
      postBody['syncToSsl'] = opts.syncToSsl
    }
    if (opts.certName !== undefined && opts.certName !== null) {
      postBody['certName'] = opts.certName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setHttpType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/httpType',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源302跳转信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param string followRedirect
      */

  queryFollowRedirect (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryFollowRedirect"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryFollowRedirect with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/followRedirect',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置回源302跳转
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setFollowRedirect (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setFollowRedirect"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setFollowRedirect with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/followRedirect',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询协议跟随回源
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param string followProtocolStatus
      */

  queryFollowSourceProtocol (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryFollowSourceProtocol"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryFollowSourceProtocol with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/followSourceProtocol',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置协议跟随回源
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务id
      */

  setFollowSourceProtocol (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setFollowSourceProtocol"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setFollowSourceProtocol with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/followSourceProtocol',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新域名配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.httpType] - http类型,只能为http或者https  optional
      * @param {} [opts.backSourceType] - 回源类型  optional
      * @param {} [opts.jumpType] - 有三种类型：default、http、https  optional
      * @param {} [opts.jcdnTimeAnti] - dash鉴权相关配置  optional
      * @param {} [opts.hdrCtrl] - 回源鉴权相关配置  optional
      * @param {} [opts.toutiaoHeader] - 头条header配置  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务taskId
      */

  setDomainConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setDomainConfig"
      )
    }

    let postBody = {}
    if (opts.httpType !== undefined && opts.httpType !== null) {
      postBody['httpType'] = opts.httpType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (opts.jumpType !== undefined && opts.jumpType !== null) {
      postBody['jumpType'] = opts.jumpType
    }
    if (opts.jcdnTimeAnti !== undefined && opts.jcdnTimeAnti !== null) {
      postBody['jcdnTimeAnti'] = opts.jcdnTimeAnti
    }
    if (opts.hdrCtrl !== undefined && opts.hdrCtrl !== null) {
      postBody['hdrCtrl'] = opts.hdrCtrl
    }
    if (opts.toutiaoHeader !== undefined && opts.toutiaoHeader !== null) {
      postBody['toutiaoHeader'] = opts.toutiaoHeader
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setDomainConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名的全部分类配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param configItem configItems
      */

  queryDomainAllConfigClassify (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryDomainAllConfigClassify"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainAllConfigClassify with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryDomainAllConfigClassify',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名一键复制配置
      * @param {Object} opts - parameters
      * @param {} [opts.domain] - 源域名  optional
      * @param {} [opts.copyDomains] - 待复制的域名列表,多个以&quot;,&quot;分隔,且不超过20个  optional
      * @param {} [opts.configKeys] - 待复制的配置项名字,区分大小写.配置项的含义：originConfig：回源配置信息;refererConfig：referer防盗链;urlAuthConfig：URL鉴权;userAgentConfig：UA访问控制;ipBlackListConfig：IP黑名单;cacheConfig：缓存配置;schemeFollowOriConfig：协议跟随回源;oriFollowRedirectConfig：回源跟随302;filterParamsConfig：过滤参数;rangeConfig：range回源;videoDraftConfig：视频拖拽;httpsConfig：Https配置;httpHeaderConfig：HttpHeader设置;otherConfig：其他配置  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param errorEntity errorResult
      */

  executeDomainCopy (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.copyDomains !== undefined && opts.copyDomains !== null) {
      postBody['copyDomains'] = opts.copyDomains
    }
    if (opts.configKeys !== undefined && opts.configKeys !== null) {
      postBody['configKeys'] = opts.configKeys
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call executeDomainCopy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/executeDomainCopy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询异常码缓存时间
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param extraCacheTime extraCacheTimes
      */

  queryExtraCacheTime (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryExtraCacheTime"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryExtraCacheTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/extraCacheTime:query',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置异常码缓存时间
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.httpCode] - 异常状态码 [&quot;4xx&quot;,&quot;400&quot;, &quot;401&quot;,  &quot;402&quot;, &quot;404&quot;, &quot;405&quot;, &quot;406&quot;, &quot;407&quot;, &quot;408&quot;, &quot;409&quot;, &quot;410&quot;, &quot;411&quot;, &quot;412&quot;, &quot;413&quot;, &quot;414&quot;, &quot;415&quot;, &quot;416&quot;, &quot;417&quot;,  &quot;5xx&quot;,&quot;500&quot;, &quot;501&quot;, &quot;502&quot;, &quot;503&quot;, &quot;504&quot;, &quot;505&quot;]中的其中一个  optional
      * @param {} [opts.cacheTime] - 缓存时间(单位:秒)  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setExtraCacheTime (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setExtraCacheTime"
      )
    }

    let postBody = {}
    if (opts.httpCode !== undefined && opts.httpCode !== null) {
      postBody['httpCode'] = opts.httpCode
    }
    if (opts.cacheTime !== undefined && opts.cacheTime !== null) {
      postBody['cacheTime'] = opts.cacheTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setExtraCacheTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/extraCacheTime:set',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除异常码缓存时间
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.httpCode] - 异常状态码 [&quot;4xx&quot;,&quot;400&quot;, &quot;401&quot;,  &quot;402&quot;, &quot;404&quot;, &quot;405&quot;, &quot;406&quot;, &quot;407&quot;, &quot;408&quot;, &quot;409&quot;, &quot;410&quot;, &quot;411&quot;, &quot;412&quot;, &quot;413&quot;, &quot;414&quot;, &quot;415&quot;, &quot;416&quot;, &quot;417&quot;,  &quot;5xx&quot;,&quot;500&quot;, &quot;501&quot;, &quot;502&quot;, &quot;503&quot;, &quot;504&quot;, &quot;505&quot;]中的其中一个  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteExtraCacheTime (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteExtraCacheTime"
      )
    }

    let postBody = {}
    if (opts.httpCode !== undefined && opts.httpCode !== null) {
      postBody['httpCode'] = opts.httpCode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteExtraCacheTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/extraCacheTime:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量设置异常码缓存时间
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.content] - 状态码和过期时间，多个用英文分号分隔,如404:3;500:10;异常状态码 [&quot;4xx&quot;,&quot;400&quot;, &quot;401&quot;,  &quot;402&quot;, &quot;404&quot;, &quot;405&quot;, &quot;406&quot;, &quot;407&quot;, &quot;408&quot;, &quot;409&quot;, &quot;410&quot;, &quot;411&quot;, &quot;412&quot;, &quot;413&quot;, &quot;414&quot;, &quot;415&quot;, &quot;416&quot;, &quot;417&quot;,  &quot;5xx&quot;,&quot;500&quot;, &quot;501&quot;, &quot;502&quot;, &quot;503&quot;, &quot;504&quot;, &quot;505&quot;]中的其中一个,缓存时间(单位:秒)  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batchSetExtraCacheTime (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling batchSetExtraCacheTime"
      )
    }

    let postBody = {}
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSetExtraCacheTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/extraCacheTime:batchSet',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置gzip
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - 开关取值[on,off]  optional
      * @param {} [opts.gzipTypes] - gzip类型,如application/x-javascript,application/xml  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setGzip (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setGzip"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.gzipTypes !== undefined && opts.gzipTypes !== null) {
      postBody['gzipTypes'] = opts.gzipTypes
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setGzip with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/gzip',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  回源改写配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.beforeRegex] - 回源改写之前的正则表达式  optional
      * @param {} [opts.afterRegex] - 回源改写之后的正则表达式  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configBackSourceRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configBackSourceRule"
      )
    }

    let postBody = {}
    if (opts.beforeRegex !== undefined && opts.beforeRegex !== null) {
      postBody['beforeRegex'] = opts.beforeRegex
    }
    if (opts.afterRegex !== undefined && opts.afterRegex !== null) {
      postBody['afterRegex'] = opts.afterRegex
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configBackSourceRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configBackSourceRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源改写配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  加速域名
      * @param string beforeRegex  回源改写之前的正则表达式
      * @param string afterRegex  回源改写之后的正则表达式
      */

  queryBackSourceRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryBackSourceRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBackSourceRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryBackSourceRule',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  URL改写配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.beforeRegex] - url改写之前的正则表达式  optional
      * @param {} [opts.afterRegex] - url改写之后的正则表达式  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configUrlRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configUrlRule"
      )
    }

    let postBody = {}
    if (opts.beforeRegex !== undefined && opts.beforeRegex !== null) {
      postBody['beforeRegex'] = opts.beforeRegex
    }
    if (opts.afterRegex !== undefined && opts.afterRegex !== null) {
      postBody['afterRegex'] = opts.afterRegex
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configUrlRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configUrlRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Url改写配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  加速域名
      * @param string beforeRegex  url改写之前的正则表达式
      * @param string afterRegex  url改写之后的正则表达式
      */

  queryUrlRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryUrlRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUrlRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryUrlRule',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  http2配置，中国境外/全球加速域名暂不支持该配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - HTTP2功能开关，取值on/off  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configHttp2 (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configHttp2"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configHttp2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configHttp2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询http2配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  加速域名
      * @param string status  HTTP2功能开关，取值on/off
      */

  queryHttp2 (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryHttp2"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryHttp2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryHttp2',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多path回源配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.configs]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configBackSourcePath (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configBackSourcePath"
      )
    }

    let postBody = {}
    if (opts.configs !== undefined && opts.configs !== null) {
      postBody['configs'] = opts.configs
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configBackSourcePath with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configBackSourcePath',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源path
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  加速域名
      * @param configBackSourcePathItems configs  配置信息
      */

  queryBackSourcePath (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryBackSourcePath"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBackSourcePath with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryBackSourcePath',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置加速区域
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.accelerateRegion] - 加速区域,取值[mainland,nonMainland,all]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setAccelerateRegion (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setAccelerateRegion"
      )
    }

    let postBody = {}
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setAccelerateRegion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/accelerateRegion',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  回源改写批量配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - on/off，若为off则数组需为空，若为on则数组不可为空  optional
      * @param {} [opts.rules]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configBackSourceRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configBackSourceRules"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.rules !== undefined && opts.rules !== null) {
      postBody['rules'] = opts.rules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configBackSourceRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configBackSourceRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源改写批量配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  加速域名
      * @param string status  on/off
      * @param backSourceRule rules  配置信息
      */

  queryBackSourceRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryBackSourceRules"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBackSourceRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryBackSourceRules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置回源OSS鉴权
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.status] - on/off，若为on则以下必传参数不可为空[accessKey,secretKey,bucket,domain2],若为off则以下参数均不能有值[accessKey,secretKey,bucket,suffix,domain2]  optional
      * @param {} [opts.accessKey] - status 为on时必填  optional
      * @param {} [opts.secretKey] - status 为on时必填  optional
      * @param {} [opts.bucket] - oss桶名,status 为on时必填  optional
      * @param {} [opts.suffix] - oss后缀,status 为on时选填  optional
      * @param {} [opts.domain2] - status 为on时必填  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configBackSourceOss (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configBackSourceOss"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.secretKey !== undefined && opts.secretKey !== null) {
      postBody['secretKey'] = opts.secretKey
    }
    if (opts.bucket !== undefined && opts.bucket !== null) {
      postBody['bucket'] = opts.bucket
    }
    if (opts.suffix !== undefined && opts.suffix !== null) {
      postBody['suffix'] = opts.suffix
    }
    if (opts.domain2 !== undefined && opts.domain2 !== null) {
      postBody['domain2'] = opts.domain2
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configBackSourceOss with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configBackSourceOss',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源OSS鉴权配置
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string status  on/off
      * @param string bucket  oss桶名
      * @param string suffix  oss后缀
      * @param string domain2
      */

  queryBackSourceOss (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryBackSourceOss"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBackSourceOss with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryBackSourceOss',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名限速
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.limitRate] - 限速值,单位为KB/s,取值范围[1,20480]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  speedLimit (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling speedLimit"
      )
    }

    let postBody = {}
    if (opts.limitRate !== undefined && opts.limitRate !== null) {
      postBody['limitRate'] = opts.limitRate
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call speedLimit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/speedLimit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量添加域名ip黑名单
      * @param {Object} opts - parameters
      * @param {} [opts.operateDomainRange] - 可选值。表示域名操作范围，可指定为all代表操作该账号下全量域名,全量域名个数应&lt;&#x3D;单次可批量操作的域名个数(默认50)  optional
      * @param {} [opts.domains] - 可选值。待操作的域名列表,个数默认限制50个。注意operateDomainRange和domains至少指定一个参数。operateDomainRange为all时该参数不生效.  optional
      * @param {} [opts.ipList] - ip列表。最多50个  optional
      * @param {} [opts.forbidTime] - 封禁时长，单位分钟。默认1440  optional
      * @param {} [opts.action] - forbid or resume.代表封禁和解封。  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batchIpBlackList (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (
      opts.operateDomainRange !== undefined &&
      opts.operateDomainRange !== null
    ) {
      postBody['operateDomainRange'] = opts.operateDomainRange
    }
    if (opts.domains !== undefined && opts.domains !== null) {
      postBody['domains'] = opts.domains
    }
    if (opts.ipList !== undefined && opts.ipList !== null) {
      postBody['ipList'] = opts.ipList
    }
    if (opts.forbidTime !== undefined && opts.forbidTime !== null) {
      postBody['forbidTime'] = opts.forbidTime
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/batchIpBlackList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置回源IP类型
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.backSourceIpVersion] - 回源IP类型，取值ipv4/ipv6/ipv46。ipv4：回源IP为ipv4；ipv6：ipv6优先；ipv46：ipv4/ipv6负载均衡  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configBackSourceIpVersion (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling configBackSourceIpVersion"
      )
    }

    let postBody = {}
    if (
      opts.backSourceIpVersion !== undefined &&
      opts.backSourceIpVersion !== null
    ) {
      postBody['backSourceIpVersion'] = opts.backSourceIpVersion
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configBackSourceIpVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/configBackSourceIpVersion',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回源IP类型
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string backSourceIpVersion  回源IP类型，取值ipv4/ipv6/ipv46。ipv4：回源IP为ipv4；ipv6：ipv6优先；ipv46：ipv4/ipv6负载均衡
      */

  queryBackSourceIpVersion (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryBackSourceIpVersion"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryBackSourceIpVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/queryBackSourceIpVersion',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名组接口
      * @param {Object} opts - parameters
      * @param {string} [opts.shareCache] - 根据是否共享内存筛选  optional
      * @param {integer} [opts.pageNumber] - pageNumber  optional
      * @param {integer} [opts.pageSize] - pageSize  optional
      * @param {string} [opts.primaryDomain] - 根据主域名模糊查询  optional
      * @param {string} [opts.domainGroupName] - 根据域名组模糊查询  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param integer pageSize
      * @param integer pageNumber
      * @param domainGroupItem domainGroups
      */

  queryDomainGroupList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.shareCache !== undefined && opts.shareCache !== null) {
      queryParams['shareCache'] = opts.shareCache
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.primaryDomain !== undefined && opts.primaryDomain !== null) {
      queryParams['primaryDomain'] = opts.primaryDomain
    }
    if (opts.domainGroupName !== undefined && opts.domainGroupName !== null) {
      queryParams['domainGroupName'] = opts.domainGroupName
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名组详情
      * @param {Object} opts - parameters
      * @param {integer} opts.id - 域名组id
      * @param {string} callback - callback
      @return {Object} result
      * @param string domains
      * @param string primaryDomain  主域名
      * @param string shareCache  是否共享缓存
      * @param string domainGroupName  域名组名称
      */

  queryDomainGroupDetail (opts, callback) {
    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling queryDomainGroupDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainGroupDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup/{id}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询未分组域名
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string domains
      */

  queryDomainsNotInGroup (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainsNotInGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup:notInGroup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新域名组
      * @param {Object} opts - parameters
      * @param {integer} opts.id - 域名组id
      * @param {} [opts.domains] - 域名组内域名，包含主域名  optional
      * @param {} [opts.primaryDomain] - 主域名,开启共享缓存时必传  optional
      * @param {} [opts.shareCache] - 是否共享内存，共享缓存仅对中国境内加速域名生效  optional
      * @param {} [opts.domainGroupName]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateDomainGroup (opts, callback) {
    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateDomainGroup"
      )
    }

    let postBody = {}
    if (opts.domains !== undefined && opts.domains !== null) {
      postBody['domains'] = opts.domains
    }
    if (opts.primaryDomain !== undefined && opts.primaryDomain !== null) {
      postBody['primaryDomain'] = opts.primaryDomain
    }
    if (opts.shareCache !== undefined && opts.shareCache !== null) {
      postBody['shareCache'] = opts.shareCache
    }
    if (opts.domainGroupName !== undefined && opts.domainGroupName !== null) {
      postBody['domainGroupName'] = opts.domainGroupName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDomainGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup/{id}:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建域名组
      * @param {Object} opts - parameters
      * @param {} [opts.shareCache] - 是否共享内存，共享缓存仅对中国境内加速域名生效  optional
      * @param {} [opts.primaryDomain] - 主域名,开启共享缓存时必传  optional
      * @param {} [opts.domainGroupName] - 域名组名称  optional
      * @param {} [opts.domains] - 域名组内域名包含主域名  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createDomainGroup (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.shareCache !== undefined && opts.shareCache !== null) {
      postBody['shareCache'] = opts.shareCache
    }
    if (opts.primaryDomain !== undefined && opts.primaryDomain !== null) {
      postBody['primaryDomain'] = opts.primaryDomain
    }
    if (opts.domainGroupName !== undefined && opts.domainGroupName !== null) {
      postBody['domainGroupName'] = opts.domainGroupName
    }
    if (opts.domains !== undefined && opts.domains !== null) {
      postBody['domains'] = opts.domains
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDomainGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量删除域名组
      * @param {Object} opts - parameters
      * @param {array} opts.ids
      * @param {string} callback - callback
      @return {Object} result
      */

  batchDeleteDomainGroup (opts, callback) {
    opts = opts || {}

    if (opts.ids === undefined || opts.ids === null) {
      throw new Error(
        "Missing the required parameter 'opts.ids' when calling batchDeleteDomainGroup"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchDeleteDomainGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainGroup:batchDelete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询加速域名接口
      * @param {Object} opts - parameters
      * @param {string} [opts.keyWord] - 根据关键字进行模糊匹配  optional
      * @param {integer} [opts.pageNumber] - pageNumber,默认值1  optional
      * @param {integer} [opts.pageSize] - pageSize,最大值50,默认值20  optional
      * @param {string} [opts.status] - 根据域名状态查询, 可选值[offline, online, configuring, auditing, audit_reject]  optional
      * @param {string} [opts.type] - 域名类型，(web:静态小文件，download:大文件加速，vod:视频加速，live:直播加速),不传查所有  optional
      * @param {string} [opts.accelerateRegion] - 加速区域，(mainLand:中国大陆，nonMainLand:海外加港澳台，all:全球),不传为全球  optional
      * @param {boolean} [opts.withThirdPartyStatus] - 筛选依据（false不需要查询, true 需要查询海外状态)默认false  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param integer pageSize
      * @param integer pageNumber
      * @param listDomainItem domains
      */

  getDomainList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.keyWord !== undefined && opts.keyWord !== null) {
      queryParams['keyWord'] = opts.keyWord
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      queryParams['accelerateRegion'] = opts.accelerateRegion
    }
    if (
      opts.withThirdPartyStatus !== undefined &&
      opts.withThirdPartyStatus !== null
    ) {
      queryParams['withThirdPartyStatus'] = opts.withThirdPartyStatus
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  通过标签查询加速域名接口
      * @param {Object} opts - parameters
      * @param {string} [opts.keyWord] - 根据关键字进行模糊匹配，域名或者回源信息  optional
      * @param {integer} [opts.pageNumber] - pageNumber,默认值为1  optional
      * @param {integer} [opts.pageSize] - pageSize,默认值为20,最大值为50  optional
      * @param {string} [opts.status] - 根据域名状态查询, 可选值[offline, online, configuring, auditing, audit_reject]  optional
      * @param {string} [opts.type] - 域名类型，(web:静态小文件，download:大文件加速，vod:视频加速，live:直播加速),不传查所有  optional
      * @param {string} [opts.accelerateRegion] - 加速区域，(mainLand:中国大陆，nonMainLand:海外加港澳台，all:全球),不传为全球  optional
      * @param {integer} [opts.filterBy] - 筛选依据（0：根据域名筛选，1：根据回源信息筛选），默认按照域名进行筛选  optional
      * @param {array} [opts.tagFilters] - 标签过滤条件  optional
      * @param {boolean} [opts.withThirdPartyStatus] - 筛选依据（false不需要查询, true 需要查询海外状态)默认false  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param integer pageSize
      * @param integer pageNumber
      * @param listDomainItemByFilter domains
      */

  getDomainListByFilter (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.keyWord !== undefined && opts.keyWord !== null) {
      postBody['keyWord'] = opts.keyWord
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.type !== undefined && opts.type !== null) {
      postBody['type'] = opts.type
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }
    if (opts.filterBy !== undefined && opts.filterBy !== null) {
      postBody['filterBy'] = opts.filterBy
    }
    if (opts.tagFilters !== undefined && opts.tagFilters !== null) {
      postBody['tagFilters'] = opts.tagFilters
    }
    if (
      opts.withThirdPartyStatus !== undefined &&
      opts.withThirdPartyStatus !== null
    ) {
      postBody['withThirdPartyStatus'] = opts.withThirdPartyStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainListByFilter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询加速域名详情
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string allStatus  null
      * @param string allowNoReferHeader  是否允许空refer访问
      * @param string allowNullReferHeader  null
      * @param integer dailyBandWidth  日带宽（单位Mbps）
      * @param string forbiddenType  封禁类型，取值：domain,url
      * @param integer maxFileSize  最大单个文件大小（单位MB）
      * @param integer minFileSize  最小单个文件大小（单位MB）
      * @param integer sumFileSize  总文件大小（单位MB）
      * @param integer avgFileSize  平均文件大小（单位MB）
      * @param string referList
      * @param string referType  refer类型，取值：block（黑名单），allow（白名单）
      * @param string domain  域名
      * @param string cname  为加速域名生成的一个CNAME域名，需要在域名解析服务商处将加速域名CNAME解析到该域名
      * @param string archiveNo  域名备案号
      * @param string type  域名加速类型，web表示图片及小文件加速
      * @param string created  创建时间
      * @param string modified  最后修改时间
      * @param string status  加速域名运行状态 ，online 表示启用；offline表示停用；configuring表示配置中；configure_failed表示配置失败
      * @param string auditStatus  域名审核状态，取值：0（未审核），1（审核通过），2（审核不通过）
      * @param backSourceInfo source  null
      * @param string sourceType  回源类型：取值 ips（IP列表），domain（域名）,oss（oss回源）
      * @param string defaultSourceHost  默认的回源host
      * @param string backSourceType  回源类型，只能为http（80端口回源）或者https（443端口回源），默认为http
      * @param string httpType  http类型，只能为http或者https，默认为http。当设为https时，需要调用“设置通讯协议”接口上传证书和私钥
      * @param string certificate  用户证书，当Type为https时必须设置
      * @param string rsaKey  证书私钥
      * @param string jumpType  跳转类型，有三种类型：default、http、https
      * @param string certFrom  证书来源，取值：ssl,defalut
      * @param string sslCertId  证书id
      * @param string certName  证书名称
      * @param string certType  证书类型
      * @param string sslCertStartTime  证书开始时间
      * @param string sslCertEndTime  证书结束时间
      * @param string accelerateRegion  加速区域
      * @param string txt  txt记录
      * @param integer overseaStatus  海外状态(-1:不涉及海外加速,0:未激活,1:已激活,2:域名在cf不存在)
      */

  getDomainDetail (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling getDomainDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建点播加速域名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.sourceType] - 回源类型只能是[ips,domain,oss]中的一种  optional
      * @param {} [opts.cdnType] - 点播域名的类型只能是[vod,download,web]中的一种  optional
      * @param {} [opts.backSourceType] - 回源方式,只能是[https,http]中的一种,默认http  optional
      * @param {} [opts.dailyBandWidth] - 日带宽(Mbps)  optional
      * @param {} [opts.quaility] - 服务质量,只能是[good,general]中的一种,默认为good  optional
      * @param {} [opts.maxFileSize]   optional
      * @param {} [opts.minFileSize]   optional
      * @param {} [opts.sumFileSize]   optional
      * @param {} [opts.avgFileSize]   optional
      * @param {} [opts.defaultSourceHost]   optional
      * @param {} [opts.httpType]   optional
      * @param {} [opts.ipSource]   optional
      * @param {} [opts.domainSource]   optional
      * @param {} [opts.ossSource]   optional
      * @param {} [opts.accelerateRegion] - 加速区域:(mainLand:中国大陆，nonMainLand:海外加港澳台，all:全球)默认为中国大陆  optional
      * @param {} [opts.tempInstId]   optional
      * @param {} [opts.domainCnameTag] - cname标签,使用时通过queryDomainCnameTag接口获取  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createDomain (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createDomain"
      )
    }

    let postBody = {}
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.cdnType !== undefined && opts.cdnType !== null) {
      postBody['cdnType'] = opts.cdnType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (opts.dailyBandWidth !== undefined && opts.dailyBandWidth !== null) {
      postBody['dailyBandWidth'] = opts.dailyBandWidth
    }
    if (opts.quaility !== undefined && opts.quaility !== null) {
      postBody['quaility'] = opts.quaility
    }
    if (opts.maxFileSize !== undefined && opts.maxFileSize !== null) {
      postBody['maxFileSize'] = opts.maxFileSize
    }
    if (opts.minFileSize !== undefined && opts.minFileSize !== null) {
      postBody['minFileSize'] = opts.minFileSize
    }
    if (opts.sumFileSize !== undefined && opts.sumFileSize !== null) {
      postBody['sumFileSize'] = opts.sumFileSize
    }
    if (opts.avgFileSize !== undefined && opts.avgFileSize !== null) {
      postBody['avgFileSize'] = opts.avgFileSize
    }
    if (
      opts.defaultSourceHost !== undefined &&
      opts.defaultSourceHost !== null
    ) {
      postBody['defaultSourceHost'] = opts.defaultSourceHost
    }
    if (opts.httpType !== undefined && opts.httpType !== null) {
      postBody['httpType'] = opts.httpType
    }
    if (opts.ipSource !== undefined && opts.ipSource !== null) {
      postBody['ipSource'] = opts.ipSource
    }
    if (opts.domainSource !== undefined && opts.domainSource !== null) {
      postBody['domainSource'] = opts.domainSource
    }
    if (opts.ossSource !== undefined && opts.ossSource !== null) {
      postBody['ossSource'] = opts.ossSource
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }
    if (opts.tempInstId !== undefined && opts.tempInstId !== null) {
      postBody['tempInstId'] = opts.tempInstId
    }
    if (opts.domainCnameTag !== undefined && opts.domainCnameTag !== null) {
      postBody['domainCnameTag'] = opts.domainCnameTag
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除加速域名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteDomain (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteDomain"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名cname标签
      * @param {Object} opts - parameters
      * @param {string} opts.domainType - 域名类型，取值范围web,download,vod,dynamic,live
      * @param {string} callback - callback
      @return {Object} result
      * @param string cnameTags
      */

  queryDomainCnameTag (opts, callback) {
    opts = opts || {}

    if (opts.domainType === undefined || opts.domainType === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainType' when calling queryDomainCnameTag"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainType !== undefined && opts.domainType !== null) {
      queryParams['domainType'] = opts.domainType
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainCnameTag with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/queryDomainCnameTag',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动加速域名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      */

  startDomain (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling startDomain"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}:start',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止加速域名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      */

  stopDomain (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling stopDomain"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}:stop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询oss存储域名
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total
      * @param object ossBuckets
      */

  queryOssBuckets (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryOssBuckets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/ossBuckets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建点播加速域名
      * @param {Object} opts - parameters
      * @param {} [opts.domains]   optional
      * @param {} [opts.sourceType] - 回源类型只能是[ips,domain,oss]中的一种  optional
      * @param {} [opts.cdnType] - 点播域名的类型只能是[vod,download,web]中的一种  optional
      * @param {} [opts.backSourceType] - 回源方式,只能是[https,http]中的一种,默认http  optional
      * @param {} [opts.dailyBandWidth] - 日带宽(Mbps)  optional
      * @param {} [opts.quaility] - 服务质量,只能是[good,general]中的一种,默认为good  optional
      * @param {} [opts.maxFileSize]   optional
      * @param {} [opts.minFileSize]   optional
      * @param {} [opts.sumFileSize]   optional
      * @param {} [opts.avgFileSize]   optional
      * @param {} [opts.defaultSourceHost]   optional
      * @param {} [opts.httpType]   optional
      * @param {} [opts.ipSource]   optional
      * @param {} [opts.domainSource]   optional
      * @param {} [opts.ossSource]   optional
      * @param {} [opts.accelerateRegion] - 加速区域 (mainLand:中国大陆，nonMainLand:海外加港澳台，all:全球)默认为中国大陆  optional
      * @param {} [opts.tempInstId]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batchCreate (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domains !== undefined && opts.domains !== null) {
      postBody['domains'] = opts.domains
    }
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.cdnType !== undefined && opts.cdnType !== null) {
      postBody['cdnType'] = opts.cdnType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (opts.dailyBandWidth !== undefined && opts.dailyBandWidth !== null) {
      postBody['dailyBandWidth'] = opts.dailyBandWidth
    }
    if (opts.quaility !== undefined && opts.quaility !== null) {
      postBody['quaility'] = opts.quaility
    }
    if (opts.maxFileSize !== undefined && opts.maxFileSize !== null) {
      postBody['maxFileSize'] = opts.maxFileSize
    }
    if (opts.minFileSize !== undefined && opts.minFileSize !== null) {
      postBody['minFileSize'] = opts.minFileSize
    }
    if (opts.sumFileSize !== undefined && opts.sumFileSize !== null) {
      postBody['sumFileSize'] = opts.sumFileSize
    }
    if (opts.avgFileSize !== undefined && opts.avgFileSize !== null) {
      postBody['avgFileSize'] = opts.avgFileSize
    }
    if (
      opts.defaultSourceHost !== undefined &&
      opts.defaultSourceHost !== null
    ) {
      postBody['defaultSourceHost'] = opts.defaultSourceHost
    }
    if (opts.httpType !== undefined && opts.httpType !== null) {
      postBody['httpType'] = opts.httpType
    }
    if (opts.ipSource !== undefined && opts.ipSource !== null) {
      postBody['ipSource'] = opts.ipSource
    }
    if (opts.domainSource !== undefined && opts.domainSource !== null) {
      postBody['domainSource'] = opts.domainSource
    }
    if (opts.ossSource !== undefined && opts.ossSource !== null) {
      postBody['ossSource'] = opts.ossSource
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }
    if (opts.tempInstId !== undefined && opts.tempInstId !== null) {
      postBody['tempInstId'] = opts.tempInstId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchCreate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain:batchCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名配置信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string ignoreQueryString  忽略参数[on,off]
      * @param string range  range参数[on,off]
      * @param string httpType  httpType参数[on,off]
      * @param string httpsCertificate  https证书
      * @param string httpsRsaKey  rsa秘钥
      * @param string httpsJumpType  跳转类型[default,http,https]
      * @param string videoDraft  是否支持视频拖拽[on,off]
      * @param string groupName  group
      * @param integer shareId
      * @param string shareName
      * @param string jcdnTimeAnti
      * @param string shareCache
      * @param string isShareOpen
      * @param string gzip  gzip参数[on,off]
      * @param string gzipTypes
      * @param cacheRule cacheRules
      */

  queryDomainConfig (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryDomainConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成域名txt记录
      * @param {Object} opts - parameters
      * @param {} [opts.domain] - 域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string txt  生成的txt文本
      */

  generateDomainTxt (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generateDomainTxt with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/generateDomainTxt',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名txt校验
      * @param {Object} opts - parameters
      * @param {} [opts.domain] - 域名  optional
      * @param {} [opts.validateType] - 校验类型，dns or file  optional
      * @param {} [opts.hostRecord] - 主机记录,dns验证方式时必传.值为_cdnautover  optional
      * @param {} [opts.txt] - 主机记录值  optional
      * @param {} [opts.url] - file验证方式时必传  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean pass  是否校验通过，true通过，false不通过
      * @param string errMsg  不通过原因，仅校验不通过时有值
      */

  domainTxtValidate (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.validateType !== undefined && opts.validateType !== null) {
      postBody['validateType'] = opts.validateType
    }
    if (opts.hostRecord !== undefined && opts.hostRecord !== null) {
      postBody['hostRecord'] = opts.hostRecord
    }
    if (opts.txt !== undefined && opts.txt !== null) {
      postBody['txt'] = opts.txt
    }
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call domainTxtValidate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTxtValidate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询模板实例列表接口
      * @param {Object} opts - parameters
      * @param {string} [opts.instName] - 根据关键字进行模糊匹配  optional
      * @param {integer} [opts.pageNumber] - pageNumber,默认值1  optional
      * @param {integer} [opts.pageSize] - pageSize,最大值50,默认值20  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param integer pageSize
      * @param integer pageNumber
      * @param listDomainTempItem instList
      */

  queryDomainTempInstList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.instName !== undefined && opts.instName !== null) {
      queryParams['instName'] = opts.instName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainTempInstList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTempInst:list',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询模板详情
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param object proKeyMap  查询结果,类型为HashMap&lt;String, List&lt;String&gt;&gt;
      */

  queryDomainTempProKeys (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainTempProKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTemp',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建修改模板实例
      * @param {Object} opts - parameters
      * @param {} [opts.tempId] - 模板id，预留字段  optional
      * @param {} [opts.instId] - 模板实例id，修改时必传  optional
      * @param {} [opts.instName] - 模板实例名称  optional
      * @param {} [opts.instProInfoMap] - 查询结果,类型为Map&lt;String,Map&lt;String,Object&gt;&gt;  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyDomainTempInst (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.tempId !== undefined && opts.tempId !== null) {
      postBody['tempId'] = opts.tempId
    }
    if (opts.instId !== undefined && opts.instId !== null) {
      postBody['instId'] = opts.instId
    }
    if (opts.instName !== undefined && opts.instName !== null) {
      postBody['instName'] = opts.instName
    }
    if (opts.instProInfoMap !== undefined && opts.instProInfoMap !== null) {
      postBody['instProInfoMap'] = opts.instProInfoMap
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyDomainTempInst with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTempInst',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询模板实例详情
      * @param {Object} opts - parameters
      * @param {integer} opts.instId - 模板实例id
      * @param {string} callback - callback
      @return {Object} result
      * @param string instName  模板实例名称
      * @param string createTime  创建时间utc格式
      * @param string updateTime  创建时间utc格式
      * @param object instProInfoMap  查询结果,类型为Map&lt;String,Map&lt;String,Object&gt;&gt;
      */

  queryDomainTempInst (opts, callback) {
    opts = opts || {}

    if (opts.instId === undefined || opts.instId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instId' when calling queryDomainTempInst"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instId: opts.instId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDomainTempInst with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTempInst/{instId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除修改模板实例
      * @param {Object} opts - parameters
      * @param {integer} opts.instId - 模板实例id
      * @param {string} callback - callback
      @return {Object} result
      */

  delDomainTempInstance (opts, callback) {
    opts = opts || {}

    if (opts.instId === undefined || opts.instId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instId' when calling delDomainTempInstance"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instId: opts.instId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delDomainTempInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domainTempInst/{instId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询IP归属，适用于查询边缘节点，仅支持中国境内IP地址查询
      * @param {Object} opts - parameters
      * @param {} [opts.ips]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param checkWhetherIpBelongToJCloudItem ipList
      */

  checkWhetherIpBelongToJCloud (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.ips !== undefined && opts.ips !== null) {
      postBody['ips'] = opts.ips
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkWhetherIpBelongToJCloud with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/ip:whetherBelongToJCloud',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询一个域名的全部调度ip
      * @param {Object} opts - parameters
      * @param {} [opts.domainList]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param domainSchedResultItem domainSchedResultItemList
      */

  queryServiceIp (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.domainList !== undefined && opts.domainList !== null) {
      postBody['domainList'] = opts.domainList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryServiceIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/ip:queryServiceIp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播域名回源信息
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.sourceType] - 回源类型只能为[ips,domain]中的一种  optional
      * @param {} [opts.backSourceType]   optional
      * @param {} [opts.defaultSourceHost] - 默认回源host  optional
      * @param {} [opts.domainSource]   optional
      * @param {} [opts.ipSource]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainBackSource (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setLiveDomainBackSource"
      )
    }

    let postBody = {}
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (
      opts.defaultSourceHost !== undefined &&
      opts.defaultSourceHost !== null
    ) {
      postBody['defaultSourceHost'] = opts.defaultSourceHost
    }
    if (opts.domainSource !== undefined && opts.domainSource !== null) {
      postBody['domainSource'] = opts.domainSource
    }
    if (opts.ipSource !== undefined && opts.ipSource !== null) {
      postBody['ipSource'] = opts.ipSource
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainBackSource with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/backSource',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播域名ip黑白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ips] - ip名单,ips中url不能超过50条  optional
      * @param {} [opts.ipListType] - ip黑白名单类型，black:黑名单,white:白名单  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainIpBlackList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setLiveDomainIpBlackList"
      )
    }

    let postBody = {}
    if (opts.ips !== undefined && opts.ips !== null) {
      postBody['ips'] = opts.ips
    }
    if (opts.ipListType !== undefined && opts.ipListType !== null) {
      postBody['ipListType'] = opts.ipListType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/ipBlackList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置域名refer防盗链
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.referType] - refer类型，取值：block（黑名单），allow（白名单）默认为block  optional
      * @param {} [opts.referList] - 逗号隔开的域名列表，如果referList传空则为删除  optional
      * @param {} [opts.allowNoReferHeader] - 是否允许空refer访问，默认为“on”  optional
      * @param {} [opts.allowNullReferHeader] - 是否允许无ua访问，默认为“on”  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainRefer (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setLiveDomainRefer"
      )
    }

    let postBody = {}
    if (opts.referType !== undefined && opts.referType !== null) {
      postBody['referType'] = opts.referType
    }
    if (opts.referList !== undefined && opts.referList !== null) {
      postBody['referList'] = opts.referList
    }
    if (
      opts.allowNoReferHeader !== undefined &&
      opts.allowNoReferHeader !== null
    ) {
      postBody['allowNoReferHeader'] = opts.allowNoReferHeader
    }
    if (
      opts.allowNullReferHeader !== undefined &&
      opts.allowNullReferHeader !== null
    ) {
      postBody['allowNullReferHeader'] = opts.allowNullReferHeader
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainRefer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/refer',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启或关闭ip黑名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.blackIpsEnable]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  operateLiveDomainIpBlackList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling operateLiveDomainIpBlackList"
      )
    }

    let postBody = {}
    if (opts.blackIpsEnable !== undefined && opts.blackIpsEnable !== null) {
      postBody['blackIpsEnable'] = opts.blackIpsEnable
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operateLiveDomainIpBlackList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/ipBlackList:operate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播域名回源host
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.sourceHost] - 默认回源host  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainBackSourceHost (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setLiveDomainBackSourceHost"
      )
    }

    let postBody = {}
    if (opts.sourceHost !== undefined && opts.sourceHost !== null) {
      postBody['sourceHost'] = opts.sourceHost
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainBackSourceHost with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/backSourceHost',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置URL鉴权
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.accesskeyType] - url鉴权开启1关闭0  optional
      * @param {} [opts.accesskeyKey] - url鉴权开启时必传  optional
      * @param {} [opts.authLifeTime] - 开启时默认值为300s,关闭时为0  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainAccessKey (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setLiveDomainAccessKey"
      )
    }

    let postBody = {}
    if (opts.accesskeyType !== undefined && opts.accesskeyType !== null) {
      postBody['accesskeyType'] = opts.accesskeyType
    }
    if (opts.accesskeyKey !== undefined && opts.accesskeyKey !== null) {
      postBody['accesskeyKey'] = opts.accesskeyKey
    }
    if (opts.authLifeTime !== undefined && opts.authLifeTime !== null) {
      postBody['authLifeTime'] = opts.authLifeTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/accesskeyConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置转协议
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.certificate] - https证书,转https格式时必传  optional
      * @param {} [opts.rsaKey] - https私钥，转https格式时必传  optional
      * @param {} [opts.certFrom] - 证书来源有两种类型：default,ssl  optional
      * @param {} [opts.sslCertId] - ssl证书id  optional
      * @param {} [opts.syncToSsl] - 是否同步到ssl,boolean值，取值true或者false  optional
      * @param {} [opts.certName] - syncToSsl是true时，certName是必填项  optional
      * @param {} [opts.protocolConverts]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setProtocolConvert (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setProtocolConvert"
      )
    }

    let postBody = {}
    if (opts.certificate !== undefined && opts.certificate !== null) {
      postBody['certificate'] = opts.certificate
    }
    if (opts.rsaKey !== undefined && opts.rsaKey !== null) {
      postBody['rsaKey'] = opts.rsaKey
    }
    if (opts.certFrom !== undefined && opts.certFrom !== null) {
      postBody['certFrom'] = opts.certFrom
    }
    if (opts.sslCertId !== undefined && opts.sslCertId !== null) {
      postBody['sslCertId'] = opts.sslCertId
    }
    if (opts.syncToSsl !== undefined && opts.syncToSsl !== null) {
      postBody['syncToSsl'] = opts.syncToSsl
    }
    if (opts.certName !== undefined && opts.certName !== null) {
      postBody['certName'] = opts.certName
    }
    if (opts.protocolConverts !== undefined && opts.protocolConverts !== null) {
      postBody['protocolConverts'] = opts.protocolConverts
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setProtocolConvert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/protocolConvert',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除禁播流
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.deleteStreams] - 要删除的禁播流  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteForbiddenStream (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteForbiddenStream"
      )
    }

    let postBody = {}
    if (opts.deleteStreams !== undefined && opts.deleteStreams !== null) {
      postBody['deleteStreams'] = opts.deleteStreams
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteForbiddenStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/stream:unForbidden',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户推流域名app名/流名
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} [opts.app] - app名，传appName查询流名列表  optional
      * @param {string} [opts.stream] - 流名模糊查询  optional
      * @param {integer} [opts.limit] - 指定app/流名列表大小，默认50  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string streams
      */

  queryPushDomainORAppOrStream (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryPushDomainORAppOrStream"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.app !== undefined && opts.app !== null) {
      queryParams['app'] = opts.app
    }
    if (opts.stream !== undefined && opts.stream !== null) {
      queryParams['stream'] = opts.stream
    }
    if (opts.limit !== undefined && opts.limit !== null) {
      queryParams['limit'] = opts.limit
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPushDomainORAppOrStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/stream:fuzzyQuery',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询ip黑白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param string blackIps
      * @param string whiteIps
      */

  queryLiveDomainIpBlackWhiteList (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryLiveDomainIpBlackWhiteList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveDomainIpBlackWhiteList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/ipList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建直播域名
      * @param {Object} opts - parameters
      * @param {} [opts.playDomain] - 播放域名  optional
      * @param {} [opts.publishDomain] - 创建推流域名时，必传推流域名  optional
      * @param {} [opts.sourceType] - 回源类型只能是[ips,domain]中的一种  optional
      * @param {} [opts.backHttpType]   optional
      * @param {} [opts.defaultSourceHost] - 默认回源host  optional
      * @param {} [opts.siteType] - 站点类型pull(拉流)push(推流)  optional
      * @param {} [opts.backSourceType] - 回源类型，目前只能为rtmp  optional
      * @param {} [opts.ipSource]   optional
      * @param {} [opts.domainSource]   optional
      * @param {} [opts.accelerateRegion] - 加速区域(mainLand:中国大陆，nonMainLand:海外加港澳台，all:全球)默认为中国大陆  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batchCreateLiveDomain (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.sourceType !== undefined && opts.sourceType !== null) {
      postBody['sourceType'] = opts.sourceType
    }
    if (opts.backHttpType !== undefined && opts.backHttpType !== null) {
      postBody['backHttpType'] = opts.backHttpType
    }
    if (
      opts.defaultSourceHost !== undefined &&
      opts.defaultSourceHost !== null
    ) {
      postBody['defaultSourceHost'] = opts.defaultSourceHost
    }
    if (opts.siteType !== undefined && opts.siteType !== null) {
      postBody['siteType'] = opts.siteType
    }
    if (opts.backSourceType !== undefined && opts.backSourceType !== null) {
      postBody['backSourceType'] = opts.backSourceType
    }
    if (opts.ipSource !== undefined && opts.ipSource !== null) {
      postBody['ipSource'] = opts.ipSource
    }
    if (opts.domainSource !== undefined && opts.domainSource !== null) {
      postBody['domainSource'] = opts.domainSource
    }
    if (opts.accelerateRegion !== undefined && opts.accelerateRegion !== null) {
      postBody['accelerateRegion'] = opts.accelerateRegion
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchCreateLiveDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain:batchCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播域名详情v1
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string domainType  域名类型
      * @param string playDomain  播放域名
      * @param string publishDomain  推流域名
      * @param string originDomain  回源域名
      * @param string createdTime  创建时间
      * @param string cname  cname
      * @param string siteType  站点类型推流push，拉流pull
      * @param string status  域名状态
      * @param backSourceInfo source  回源信息
      * @param string sourceType  域名回源类型
      * @param string backSourceType  回源类型目前只能未rtmp
      * @param string videoType  视频格式 H.264
      * @param string audioType  音频格式AAC
      * @param string type  域名类型
      * @param string defaultSourceHost  默认回源host
      * @param string archiveNo  备案号
      * @param string rtmpDomain  rtmpDomain
      * @param string rtmpCname  rtmpCname
      * @param string hdlDomain  hdlDomain
      * @param string hdlCname  hdlCname
      * @param string hlsDomain  hlsDomain
      * @param string hlsCname  hlsCname
      * @param string forwardCustomVhost  forwardCustomVhost
      * @param string flvUrls
      * @param string hlsUrls
      * @param string rtmpUrls
      * @param protocolConvert protocolConverts
      * @param string certificate  https证书
      * @param string rsaKey  https私钥
      * @param integer accesskeyType  url鉴权开关
      * @param string accesskeyKey  url鉴权key
      * @param integer playAuthLifeTime  playAuthLifeTime
      * @param integer authLifeTime  authLifeTime
      * @param integer forwardAccessKeyType  转推鉴权开关
      * @param string forwardPrivateKey  转推鉴权key
      * @param integer originAccessKeyType  回源鉴权开关
      * @param string originPrivateKey  回源鉴权key
      * @param string allowApps
      * @param string ips
      * @param string blackIpsEnable  是否开启ip黑名单
      * @param string externId  外部关联id
      * @param string ignoreQueryString  ignoreQueryString
      * @param string referType  referType
      * @param string referList
      * @param string allowNoReferHeader  允许无refer
      * @param string allowNullReferHeader  允许空refer
      * @param string publishNormalTimeout  推流中断超时时间(单位秒)
      * @param string notifyCustomUrl  推断流通知Url
      * @param string notifyCustomAuthKey  推断流通知key
      * @param string certFrom  证书来源有两种类型：default,ssl
      * @param string sslCertId  ssl证书id
      * @param string certName  证书名称
      * @param string certType  证书类型
      * @param string sslCertStartTime
      * @param string sslCertEndTime
      * @param string accelerateRegion
      */

  queryLiveDomainDetail (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryLiveDomainDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveDomainDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播域名app列表
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string apps
      * @param string domain  域名
      */

  queryLiveDomainApps (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryLiveDomainApps"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveDomainApps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomain/{domain}/app',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建直播预热任务
      * @param {Object} opts - parameters
      * @param {} [opts.urlList] - 预热的URL  optional
      * @param {} [opts.prefetchTime] - 预热时长  optional
      * @param {} [opts.action] - 操作类型只能是[start,stop]中的一种  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createLiveDomainPrefecthTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.urlList !== undefined && opts.urlList !== null) {
      postBody['urlList'] = opts.urlList
    }
    if (opts.prefetchTime !== undefined && opts.prefetchTime !== null) {
      postBody['prefetchTime'] = opts.prefetchTime
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLiveDomainPrefecthTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:createLivePrefetchTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播预热任务
      * @param {Object} opts - parameters
      * @param {} [opts.urlList] - 预热的URL  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param queryLivePrefetchItem result
      */

  queryLivePrefetchTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.urlList !== undefined && opts.urlList !== null) {
      postBody['urlList'] = opts.urlList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLivePrefetchTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:queryLivePrefetchTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  null
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean canIPType  true可以
      */

  queryPinCanIPType (opts, callback) {
    opts = opts || {}

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPinCanIPType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/mix:queryPinCanIPType',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建预热任务接口
      * @param {Object} opts - parameters
      * @param {} [opts.tasks]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batCreatePrefetchTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batCreatePrefetchTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/prefetchTask:batCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新预热任务接口
      * @param {Object} opts - parameters
      * @param {} [opts.url] - url  optional
      * @param {} [opts.region] - 地区[huabei huadong dongbei huazhong huanan xinan xibei gangaotai]中的一个  optional
      * @param {} [opts.isp] - 运营商[ct uni cm]中的一个,分别代表电信 联通 移动  optional
      * @param {} [opts.copyNum] - 副本数,介于1-1000之间  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updatePrefetchTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.region !== undefined && opts.region !== null) {
      postBody['region'] = opts.region
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.copyNum !== undefined && opts.copyNum !== null) {
      postBody['copyNum'] = opts.copyNum
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePrefetchTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/prefetchTask:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询预热任务接口
      * @param {Object} opts - parameters
      * @param {} [opts.url] - url  optional
      * @param {} [opts.region] - 地区[huabei huadong dongbei huazhong huanan xinan xibei gangaotai]中的一个  optional
      * @param {} [opts.isp] - 运营商[ct uni cm]中的一个,分别代表电信 联通 移动  optional
      * @param {} [opts.status] - 查询状态 1:active维护预热中，2:表示purge中暂时停止预热  optional
      * @param {} [opts.fileId] - 同url，系统内部url对应id（url和file_id同时存在时以url为准）  optional
      * @param {} [opts.pageNumber] - 页码数,最小为1  optional
      * @param {} [opts.pageSize] - 每页大小,默认10  optional
      * @param {} [opts.taskType] - 1:代表控制台下发的预热任务2:代表热度计算下发的预热任务3:代表控制台、热度计算共同下发的任务  optional
      * @param {} [opts.domain] - 域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalNumber
      * @param integer totalPage
      * @param integer pageNumber
      * @param integer pageSize
      * @param prefetchTaskInfo taskList
      */

  queryPrefetchTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.region !== undefined && opts.region !== null) {
      postBody['region'] = opts.region
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.fileId !== undefined && opts.fileId !== null) {
      postBody['fileId'] = opts.fileId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPrefetchTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/prefetchTask:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止预热任务接口
      * @param {Object} opts - parameters
      * @param {} [opts.urls] - 待停止预热的url  optional
      * @param {} [opts.region] - 地区[huabei huadong dongbei huazhong huanan xinan xibei gangaotai]中的一个  optional
      * @param {} [opts.isp] - 运营商[ct uni cm]中的一个,分别代表电信 联通 移动  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  stopPrefetchTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.urls !== undefined && opts.urls !== null) {
      postBody['urls'] = opts.urls
    }
    if (opts.region !== undefined && opts.region !== null) {
      postBody['region'] = opts.region
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopPrefetchTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/prefetchTask:stop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  操作刷新任务接口(包含创建、停止刷新任务)
      * @param {Object} opts - parameters
      * @param {} [opts.urls] - 待刷新的url  optional
      * @param {} [opts.optType] - 操作类型:add代表创建刷新任务,stop代表停止刷新任务  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  operatePurgeTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.urls !== undefined && opts.urls !== null) {
      postBody['urls'] = opts.urls
    }
    if (opts.optType !== undefined && opts.optType !== null) {
      postBody['optType'] = opts.optType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operatePurgeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/purgeTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询刷新任务接口
      * @param {Object} opts - parameters
      * @param {} [opts.url] - url  optional
      * @param {} [opts.status] - 查询状态 1:进行中 2:已完成  optional
      * @param {} [opts.fileId] - 同url,系统内部url对应id（url和file_id同时存在时以url为准）  optional
      * @param {} [opts.pageNumber] - 页码数,最小为1  optional
      * @param {} [opts.pageSize] - 每页大小,默认10  optional
      * @param {} [opts.domain] - 域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalNumber
      * @param integer totalPage
      * @param integer pageNumber
      * @param integer pageSize
      * @param purgeTaskInfo taskList
      */

  queryPurgeTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.fileId !== undefined && opts.fileId !== null) {
      postBody['fileId'] = opts.fileId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPurgeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/purgeTask:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户刷新预热封禁限额
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param integer dirAllCount  总的目录刷新上限
      * @param integer dirUsedCount  已使用的目录刷新个数
      * @param integer dirRemainedCount  剩余可用的目录刷新个数
      * @param integer forbiddenUrlRemainedCount  剩余可封禁的URL个数
      * @param integer forbiddenUrlUsedCount  已封禁的URL个数
      * @param integer forbiddenUrlAllCount  总的封禁URL上限
      * @param integer hasForbiddenDomainCount  已封禁的域名个数，即用户账号下对违法内容封禁的域名
      * @param integer prefetchRemainedCount  剩余可用的预热URL个数
      * @param integer prefetchAllCount  总的预热URL上限
      * @param integer prefetchUsedCount  已使用的预热URL个数
      * @param integer refreshAllCount  总的刷新URL上限
      * @param integer refreshRemainedCount  剩余可用的刷新URL个数
      * @param integer refreshUsedCount  已使用的刷新URL个数
      * @param integer totalUserDomainQuota  总的用户域名数上限; 即针对账号下可添加域名的总个数
      * @param integer usedUserDomainQuota  已使用的用户域名个数；即账号下已经添加的域名个数，包括停用域名、封禁域名等
      * @param integer remainUserDomainQuota  剩余可配置的用户域名个数
      */

  queryCdnUserQuota (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCdnUserQuota with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/user:quota',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据taskIds查询刷新预热任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskIds] - 查询的任务taskIds列表,最多能查10条  optional
      * @param {} [opts.keyword] - url的模糊查询关键字  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param refreshTask tasks
      */

  queryRefreshTaskByIds (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      postBody['keyword'] = opts.keyword
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRefreshTaskByIds with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:queryByIds',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置用户刷新预热限额
      * @param {Object} opts - parameters
      * @param {} [opts.subUsers] - 子账号，只有传值才会设置子账号，其余不传或传空是设置主账号  optional
      * @param {} [opts.refreshCount] - 刷新个数，如果是首次设置，不传默认是2000；已经设置，再次设置是更新，不传表示不进行更新  optional
      * @param {} [opts.prefetchCount] - 刷新个数，如果是首次设置，不传默认是2000；已经设置，再次设置是更新，不传表示不进行更新  optional
      * @param {} [opts.dirCount] - 刷新个数，如果是首次设置，不传默认是50；已经设置，再次设置是更新，不传表示不进行更新  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setRefreshLimit (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.subUsers !== undefined && opts.subUsers !== null) {
      postBody['subUsers'] = opts.subUsers
    }
    if (opts.refreshCount !== undefined && opts.refreshCount !== null) {
      postBody['refreshCount'] = opts.refreshCount
    }
    if (opts.prefetchCount !== undefined && opts.prefetchCount !== null) {
      postBody['prefetchCount'] = opts.prefetchCount
    }
    if (opts.dirCount !== undefined && opts.dirCount !== null) {
      postBody['dirCount'] = opts.dirCount
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setRefreshLimit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:configLimit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户刷新预热限额
      * @param {Object} opts - parameters
      * @param {} [opts.subUsers] - 子账号，传哪些子账号就查哪些的，不传或传空默认返回所有子账号的额度  optional
      * @param {} [opts.pageNumber] - 默认为1  optional
      * @param {} [opts.pageSize] - 默认为10，最大100  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string user  主账号
      * @param integer refreshCount  主账号刷新个数
      * @param integer dirCount  主账号目录个数
      * @param integer prefetchCount  主账号预热个数
      * @param integer pageNumber  默认为1
      * @param integer pageSize  默认为10，最大100
      * @param integer total  默认为10，最大100
      * @param subUserRefreshLimit subUserQuota
      */

  queryRefreshLimit (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.subUsers !== undefined && opts.subUsers !== null) {
      postBody['subUsers'] = opts.subUsers
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRefreshLimit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:queryLimit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据taskId查询刷新预热任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 域名组id
      * @param {string} callback - callback
      @return {Object} result
      * @param refreshTask task
      */

  queryRefreshTaskById (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling queryRefreshTaskById"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRefreshTaskById with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建刷新预热回调任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskType] - 刷新预热类型,(url:url刷新,dir:目录刷新,prefetch:预热)  optional
      * @param {} [opts.urlItems]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer errorCount  失败任务的个数
      * @param string taskId  任务的id
      */

  createRefreshTaskForCallback (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.urlItems !== undefined && opts.urlItems !== null) {
      postBody['urlItems'] = opts.urlItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRefreshTaskForCallback with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:createForCallback',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建刷新预热回调任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskType] - 刷新预热类型,(url:url刷新,dir:目录刷新,prefetch:预热)  optional
      * @param {} [opts.urlItems]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer errorCount  失败任务的个数
      * @param string taskId  任务的id
      */

  createRefreshTaskForCallbackV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.urlItems !== undefined && opts.urlItems !== null) {
      postBody['urlItems'] = opts.urlItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRefreshTaskForCallbackV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task:createForCallbackV2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询刷新预热任务
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.keyword] - url或者目录的模糊查询关键字  optional
      * @param {} [opts.taskId] - 任务id  optional
      * @param {} [opts.taskStatus] - null  optional
      * @param {} [opts.taskType] - null  optional
      * @param {} [opts.pageNumber] - 分页页数,默认值1  optional
      * @param {} [opts.pageSize] - 分页页面大小,默认值50  optional
      * @param {} [opts.accountType] - 查询的账号范围  optional
      * @param {} [opts.subUsers] - 查询的子账号，多个用逗号隔开  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总的刷新预热条数.
      * @param refreshTask tasks
      */

  queryRefreshTask (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.taskId !== undefined && opts.taskId !== null) {
      queryParams['taskId'] = opts.taskId
    }
    if (opts.taskStatus !== undefined && opts.taskStatus !== null) {
      queryParams['taskStatus'] = opts.taskStatus
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      queryParams['taskType'] = opts.taskType
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.accountType !== undefined && opts.accountType !== null) {
      queryParams['accountType'] = opts.accountType
    }
    if (opts.subUsers !== undefined && opts.subUsers !== null) {
      queryParams['subUsers'] = opts.subUsers
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRefreshTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建刷新预热任务，
      * @param {Object} opts - parameters
      * @param {} [opts.taskType] - 刷新预热类型,(url:url刷新,dir:目录刷新,prefetch:预热)，中国境外/全球加速域名暂不支持预热功能  optional
      * @param {} [opts.urls]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer errorCount  失败任务的个数
      * @param string taskId  任务的id
      */

  createRefreshTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.urls !== undefined && opts.urls !== null) {
      postBody['urls'] = opts.urls
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRefreshTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/task',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询网络防护层规则接口
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  网络防护层总开关，取值on,off，其中on开启，off关闭
      * @param string srcNewConnLimitEnable  源新建连接限速，取值on,off，其中on开启，off关闭
      * @param string dstNewConnLimitEnable  目的新建连接，取值on,off，其中on开启，off关闭
      * @param integer datagramRangeMin  报文最小长度（包最小长度）,取值：1-1500
      * @param integer datagramRangeMax  报文最大长度（包最大长度）,取值：1-1500
      * @param integer srcNewConnLimitValue  源新建连接限速值，取值：0-4294967295
      * @param integer dstNewConnLimitValue  目的新建连接限速值，取值：0-4294967295
      * @param geoArea geoBlack
      * @param string ipBlack
      * @param string ipWhite
      */

  queryNetProtectionRules (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryNetProtectionRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionRules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置网络防护层规则
      * @param {Object} opts - parameters
      * @param {} [opts.srcNewConnLimitEnable] - 源新建连接限速，取值on,off，其中on开启，off关闭  optional
      * @param {} [opts.dstNewConnLimitEnable] - 目的新建连接，取值on,off，其中on开启，off关闭  optional
      * @param {} [opts.datagramRangeMin] - 报文最小长度（包最小长度）,取值：1-1500  optional
      * @param {} [opts.datagramRangeMax] - 报文最大长度（包最大长度）,取值：1-1500  optional
      * @param {} [opts.dstNewConnLimitValue] - 目的新建连接限速值，取值：0-4294967295  optional
      * @param {} [opts.srcNewConnLimitValue] - 源新建连接限速值，取值：0-4294967295  optional
      * @param {} [opts.geoBlack] - 地域黑名单（GEO IP拦截）  optional
      * @param {} [opts.ipBlack] - ip 黑名单  optional
      * @param {} [opts.ipWhite] - ip 白名单  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setNetProtectionRules (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (
      opts.srcNewConnLimitEnable !== undefined &&
      opts.srcNewConnLimitEnable !== null
    ) {
      postBody['srcNewConnLimitEnable'] = opts.srcNewConnLimitEnable
    }
    if (
      opts.dstNewConnLimitEnable !== undefined &&
      opts.dstNewConnLimitEnable !== null
    ) {
      postBody['dstNewConnLimitEnable'] = opts.dstNewConnLimitEnable
    }
    if (opts.datagramRangeMin !== undefined && opts.datagramRangeMin !== null) {
      postBody['datagramRangeMin'] = opts.datagramRangeMin
    }
    if (opts.datagramRangeMax !== undefined && opts.datagramRangeMax !== null) {
      postBody['datagramRangeMax'] = opts.datagramRangeMax
    }
    if (
      opts.dstNewConnLimitValue !== undefined &&
      opts.dstNewConnLimitValue !== null
    ) {
      postBody['dstNewConnLimitValue'] = opts.dstNewConnLimitValue
    }
    if (
      opts.srcNewConnLimitValue !== undefined &&
      opts.srcNewConnLimitValue !== null
    ) {
      postBody['srcNewConnLimitValue'] = opts.srcNewConnLimitValue
    }
    if (opts.geoBlack !== undefined && opts.geoBlack !== null) {
      postBody['geoBlack'] = opts.geoBlack
    }
    if (opts.ipBlack !== undefined && opts.ipBlack !== null) {
      postBody['ipBlack'] = opts.ipBlack
    }
    if (opts.ipWhite !== undefined && opts.ipWhite !== null) {
      postBody['ipWhite'] = opts.ipWhite
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setNetProtectionRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询网络防护层规则
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  on:开启,off:关闭
      */

  queryNetProtectionRulesSwitch (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryNetProtectionRulesSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置网络防护层规则总开关
      * @param {Object} opts - parameters
      * @param {} [opts.switchStatus] - on,off  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setNetProtectionRulesSwitch (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setNetProtectionRulesSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询geo地域
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param geoArea geoBlack
      */

  queryGeoAreas (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryGeoAreas with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionGeoAreas',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  攻击类型统计接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T06:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T07:00:00Z  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param attackTypeCount attackTypeCounts
      */

  queryAttackTypeCount (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAttackTypeCount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionData:attackTypeCount',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  DDOS攻击报表接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T06:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T07:00:00Z  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param protectData dataList
      * @param string unit
      */

  queryDdosGraph (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDdosGraph with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionData:ddosGraph',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  攻击记录查询
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T06:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2019-08-16T07:00:00Z  optional
      * @param {} [opts.pageNumber] - 页码  optional
      * @param {} [opts.pageSize] - 分页条数  optional
      * @param {} [opts.sortField] - 排序字段，默认传avgbandwidth  optional
      * @param {} [opts.sortRule] - 排序规则，默认是降序排序，传值asc或者desc  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer currentCount  记录数
      * @param attackLogRecord dataList
      * @param integer totalCount  总记录数
      * @param integer totalPage  总页数
      */

  searchAttackLog (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.sortField !== undefined && opts.sortField !== null) {
      postBody['sortField'] = opts.sortField
    }
    if (opts.sortRule !== undefined && opts.sortRule !== null) {
      postBody['sortRule'] = opts.sortRule
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call searchAttackLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/netProtectionData:attackLog',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取所有上层节点的ip
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string ipList
      */

  getAllUpperNodeIpList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAllUpperNodeIpList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/serviceNode:getAllUpperNodeIpList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  配置服务通知接口
      * @param {Object} opts - parameters
      * @param {} [opts.id] - id 修改操作必传  optional
      * @param {} [opts.noticeType] - 通知类型,取值[reportForm],reportForm:报表.  optional
      * @param {} [opts.noticeWay] - 通知方式,取值[mail],mail:邮件.  optional
      * @param {} [opts.noticeTo] - 通知接收人,多个用逗号隔开.  optional
      * @param {} [opts.noticeCC] - 通知抄送人,多个用逗号隔开.  optional
      * @param {} [opts.noticeContent] - 通知正文.  optional
      * @param {} [opts.noticePeriod] - 通知周期,取值[daily,weekly,monthly].  optional
      * @param {} [opts.noticeStatus] - 通知状态，取值[init,start,stop]  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  configServiceNotice (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.noticeType !== undefined && opts.noticeType !== null) {
      postBody['noticeType'] = opts.noticeType
    }
    if (opts.noticeWay !== undefined && opts.noticeWay !== null) {
      postBody['noticeWay'] = opts.noticeWay
    }
    if (opts.noticeTo !== undefined && opts.noticeTo !== null) {
      postBody['noticeTo'] = opts.noticeTo
    }
    if (opts.noticeCC !== undefined && opts.noticeCC !== null) {
      postBody['noticeCC'] = opts.noticeCC
    }
    if (opts.noticeContent !== undefined && opts.noticeContent !== null) {
      postBody['noticeContent'] = opts.noticeContent
    }
    if (opts.noticePeriod !== undefined && opts.noticePeriod !== null) {
      postBody['noticePeriod'] = opts.noticePeriod
    }
    if (opts.noticeStatus !== undefined && opts.noticeStatus !== null) {
      postBody['noticeStatus'] = opts.noticeStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configServiceNotice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/serviceNotice:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户服务通知接口
      * @param {Object} opts - parameters
      * @param {string} [opts.noticeType] - 通知类型,取值[reportForm],reportForm:报表.  optional
      * @param {string} [opts.noticeWay] - 通知方式,取值[mail],mail:邮件.  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param serviceNoticeItem notices
      */

  queryServiceNotice (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.noticeType !== undefined && opts.noticeType !== null) {
      queryParams['noticeType'] = opts.noticeType
    }
    if (opts.noticeWay !== undefined && opts.noticeWay !== null) {
      queryParams['noticeWay'] = opts.noticeWay
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryServiceNotice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/serviceNotice',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看证书列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 第几页，从1开始计数  optional
      * @param {integer} [opts.pageSize] - 每页显示的数目  optional
      * @param {string} [opts.domain] - 域名，支持按照域名检索证书  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param sslCertModel certList
      * @param integer totalCount  总数量
      */

  getSslCertList (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      queryParams['domain'] = opts.domain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSslCertList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sslCert',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看证书详情
      * @param {Object} opts - parameters
      * @param {string} opts.sslCertId - 证书 Id
      * @param {string} callback - callback
      @return {Object} result
      * @param sslCertModelDetail sslCertModelDetail
      */

  getSslCertDetail (opts, callback) {
    opts = opts || {}

    if (opts.sslCertId === undefined || opts.sslCertId === null) {
      throw new Error(
        "Missing the required parameter 'opts.sslCertId' when calling getSslCertDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      sslCertId: opts.sslCertId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSslCertDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sslCert/{sslCertId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上传证书
      * @param {Object} opts - parameters
      * @param {string} opts.certName - 证书名称
      * @param {string} opts.keyFile - 私钥
      * @param {string} opts.certFile - 证书
      * @param {string} [opts.aliasName] - 证书别名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string certId
      * @param string digest  对私钥文件使用sha256算法计算的摘要信息
      */

  uploadCert (opts, callback) {
    opts = opts || {}

    if (opts.certName === undefined || opts.certName === null) {
      throw new Error(
        "Missing the required parameter 'opts.certName' when calling uploadCert"
      )
    }
    if (opts.keyFile === undefined || opts.keyFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyFile' when calling uploadCert"
      )
    }
    if (opts.certFile === undefined || opts.certFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.certFile' when calling uploadCert"
      )
    }

    let postBody = {}
    if (opts.certName !== undefined && opts.certName !== null) {
      postBody['certName'] = opts.certName
    }
    if (opts.keyFile !== undefined && opts.keyFile !== null) {
      postBody['keyFile'] = opts.keyFile
    }
    if (opts.certFile !== undefined && opts.certFile !== null) {
      postBody['certFile'] = opts.certFile
    }
    if (opts.aliasName !== undefined && opts.aliasName !== null) {
      postBody['aliasName'] = opts.aliasName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call uploadCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sslCert:upload',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据，仅可查询中国境内的相关信息
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.scheme] - 查询协议，可选值:[http,https,all],传空默认返回全部协议汇总后的数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsDataItem statistics
      */

  queryMixStatisticsData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.scheme !== undefined && opts.scheme !== null) {
      postBody['scheme'] = opts.scheme
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryMixStatisticsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分地区及运营商查询统计数据，仅可查询中国境内的相关信息
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsWithAreaGroupDetail statistics
      */

  queryMixStatisticsWithAreaData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryMixStatisticsWithAreaData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:groupByArea',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据并进行汇总加和，仅可查询中国境内的相关信息
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.groupBy] - 分组依据,只能按域名[domain]分组  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsGroupSumDataItem statistics
      */

  queryMixTrafficGroupSum (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryMixTrafficGroupSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:groupSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.origin] - 是否查询回源统计信息。取值为true和false，默认为false。注意，如果查询回源信息，Fields的取值当前只支持oribandwidth，oripv，oricodestat三个，其余Fields忽略。  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.abroad] - true 代表查询境外数据，默认false查询境内数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsDataItem statistics
      */

  queryStatisticsData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.origin !== undefined && opts.origin !== null) {
      postBody['origin'] = opts.origin
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.abroad !== undefined && opts.abroad !== null) {
      postBody['abroad'] = opts.abroad
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStatisticsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/vodStatistics',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分地区及运营商查询统计数据
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.origin] - 是否查询回源统计信息。取值为true和false，默认为false。注意，如果查询回源信息，Fields的取值当前只支持oribandwidth，oripv，oricodestat三个，其余Fields忽略  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.groupBy] - 分组依据,可选值：[terminal,sdtfrom],如果为空，则只按area/isp进行group  optional
      * @param {} [opts.scheme] - 查询协议，可选值:[http,https,all],传空默认返回全部协议汇总后的数据  optional
      * @param {} [opts.abroad] - true 代表查询境外数据，默认false查询境内数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsWithAreaGroupDetail statistics
      */

  queryStatisticsDataGroupByArea (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.origin !== undefined && opts.origin !== null) {
      postBody['origin'] = opts.origin
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.scheme !== undefined && opts.scheme !== null) {
      postBody['scheme'] = opts.scheme
    }
    if (opts.abroad !== undefined && opts.abroad !== null) {
      postBody['abroad'] = opts.abroad
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStatisticsDataGroupByArea with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/vodStatistics:groupByArea',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据并进行汇总加和
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.origin] - 是否查询回源统计信息。取值为true和false，默认为false。注意，如果查询回源信息，Fields的取值当前只支持oribandwidth，oripv，oricodestat三个，其余Fields忽略。  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.groupBy] - 分组依据，可选值：[area,isp,domain,scheme]  optional
      * @param {} [opts.abroad] - true 代表查询境外数据，默认false查询境内数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {} [opts.ipType] - 查询IP类型，可选值:[,ipv4,ipv6],默认查询all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsGroupSumDataItem statistics
      */

  queryStatisticsDataGroupSum (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.origin !== undefined && opts.origin !== null) {
      postBody['origin'] = opts.origin
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.abroad !== undefined && opts.abroad !== null) {
      postBody['abroad'] = opts.abroad
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }
    if (opts.ipType !== undefined && opts.ipType !== null) {
      postBody['ipType'] = opts.ipType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStatisticsDataGroupSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/vodStatistics:groupSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.appName] - app名,查询的App名称，多个用逗号分隔。注意，传如多个AppName时，表示查询这些AppName的和值，即“或”的关系。默认为空，表示查询所有App  optional
      * @param {} [opts.streamName] - 流名,查询的流名称，多个用逗号分隔。注意，传如多个StreamName时，表示查询这些StreamName的和值，即“或”的关系。默认为空，表示查询所有Stream  optional
      * @param {} [opts.subDomain] - 子域名,查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.reqMethod] - 当前取值范围(&quot;GET,HEAD,forward,forward-hls,ingest,play,publish,detour-ingest,Forward-Origin&quot;)  optional
      * @param {} [opts.scheme] - 查询的流协议类型,取值范围：&quot;rtmp,hdl,hls&quot;，多个用逗号分隔，默认为空，表示查询所有协议。  optional
      * @param {} [opts.cacheLevel] - cacheLevel,可选值：[L1,L2,L3]  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsDataItem statistics
      */

  queryLiveStatisticsData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.reqMethod !== undefined && opts.reqMethod !== null) {
      postBody['reqMethod'] = opts.reqMethod
    }
    if (opts.scheme !== undefined && opts.scheme !== null) {
      postBody['scheme'] = opts.scheme
    }
    if (opts.cacheLevel !== undefined && opts.cacheLevel !== null) {
      postBody['cacheLevel'] = opts.cacheLevel
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveStatisticsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveStatistics',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分地区及运营商查询统计数据
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.appName] - 查询的App名称，多个用逗号分隔。  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.streamName] - 查询的流名称，多个用逗号分隔。  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.groupBy] - 分组依据,可选值：[appname,streamname]，如果为空，则只按area/isp进行group。  optional
      * @param {} [opts.subDomain] - 查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.scheme] - 查询的流协议，取值范围：&quot;rtmp,hdl,hls&quot;，多个用逗号分隔，默认为空，表示查询所有协议。  optional
      * @param {} [opts.reqMethod] - 当前取值范围(&quot;GET,HEAD,forward,forward-hls,ingest,play,publish,detour-ingest,Forward-Origin&quot;)  optional
      * @param {} [opts.cacheLevel] - cacheLevel，可选值：[L1,L2,L3]  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsWithAreaGroupDetail statistics
      */

  queryLiveStatisticsAreaDataGroupBy (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.scheme !== undefined && opts.scheme !== null) {
      postBody['scheme'] = opts.scheme
    }
    if (opts.reqMethod !== undefined && opts.reqMethod !== null) {
      postBody['reqMethod'] = opts.reqMethod
    }
    if (opts.cacheLevel !== undefined && opts.cacheLevel !== null) {
      postBody['cacheLevel'] = opts.cacheLevel
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveStatisticsAreaDataGroupBy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveStatistics:groupByArea',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询统计数据并进行汇总加和
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.appName] - 查询的App名称，多个用逗号分隔。  optional
      * @param {} [opts.streamName] - 查询的流名称，多个用逗号分隔。  optional
      * @param {} [opts.fields] - 需要查询的字段  optional
      * @param {} [opts.area] - 查询的区域，如beijing,shanghai。多个用逗号分隔  optional
      * @param {} [opts.isp] - 查询的运营商，cmcc,cnc,ct，表示移动、联通、电信。多个用逗号分隔  optional
      * @param {} [opts.scheme] - 查询的流协议，取值范围：&quot;rtmp,hdl,hls&quot;，多个用逗号分隔，默认为空，表示查询所有协议。  optional
      * @param {} [opts.period] - 时间粒度，可选值:[oneMin,fiveMin,followTime],followTime只会返回一个汇总后的数据  optional
      * @param {} [opts.groupBy] - 分组依据，可选值：[appname,streamname,domain,area,isp,scheme]  optional
      * @param {} [opts.reqMethod] - 当前取值范围(&quot;GET,HEAD,forward,forward-hls,ingest,play,publish,detour-ingest,Forward-Origin&quot;)  optional
      * @param {} [opts.cacheLevel] - cacheLevel，可选值：[L1,L2,L3]  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsGroupSumDataItem statistics
      */

  queryLiveTrafficGroupSum (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.scheme !== undefined && opts.scheme !== null) {
      postBody['scheme'] = opts.scheme
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.reqMethod !== undefined && opts.reqMethod !== null) {
      postBody['reqMethod'] = opts.reqMethod
    }
    if (opts.cacheLevel !== undefined && opts.cacheLevel !== null) {
      postBody['cacheLevel'] = opts.cacheLevel
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveTrafficGroupSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveStatistics:groupSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询TOP IP，仅可查询中国境内的相关信息
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 待查询的子域名,查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.size] - 查询的topN的条数，取值范围：1-100，默认为20  optional
      * @param {} [opts.topBy] - 排序依据,当前可选：pv,flow, 分别表示按pv、按流量topN ip，默认为&quot;pv&quot;  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsTopIpData ipData
      */

  queryStatisticsTopIp (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.size !== undefined && opts.size !== null) {
      postBody['size'] = opts.size
    }
    if (opts.topBy !== undefined && opts.topBy !== null) {
      postBody['topBy'] = opts.topBy
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStatisticsTopIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:topIp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询TOP Url，仅可查询中国境内的相关信息
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.subDomain] - 待查询的子域名,查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可  optional
      * @param {} [opts.size] - 查询的topN的条数，取值范围：1-100，默认为20  optional
      * @param {} [opts.topBy] - 排序依据,当前可选：pv,flow，bandwidth, 分别表示按pv、按流量、按带宽topN url，默认为&quot;pv&quot;  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime
      * @param string endTime
      * @param string domain
      * @param statisticsTopUrlData urlData
      */

  queryStatisticsTopUrl (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.subDomain !== undefined && opts.subDomain !== null) {
      postBody['subDomain'] = opts.subDomain
    }
    if (opts.size !== undefined && opts.size !== null) {
      postBody['size'] = opts.size
    }
    if (opts.topBy !== undefined && opts.topBy !== null) {
      postBody['topBy'] = opts.topBy
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStatisticsTopUrl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:topUrl',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询目录带宽，仅有部分用户支持该功能
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名，该接口仅支持单域名查询  optional
      * @param {} [opts.dirs] - 需要过滤的目录  optional
      * @param {} [opts.regions] - 需要过滤的地区  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param dirBandwidthItem datas
      */

  queryDirBandwidth (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.dirs !== undefined && opts.dirs !== null) {
      postBody['dirs'] = opts.dirs
    }
    if (opts.regions !== undefined && opts.regions !== null) {
      postBody['regions'] = opts.regions
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDirBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:queryDirBandwidth',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询目录基础统计数据，仅有部分用户支持该功能
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名，该接口仅支持单域名查询  optional
      * @param {} [opts.dirs] - 需要过滤的目录  optional
      * @param {} [opts.cacheType] - 查询节点层级，可选值:[all,edge,mid],默认查询all,edge边缘 mid中间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param dirStatsItem datas
      */

  queryDirStatsData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.dirs !== undefined && opts.dirs !== null) {
      postBody['dirs'] = opts.dirs
    }
    if (opts.cacheType !== undefined && opts.cacheType !== null) {
      postBody['cacheType'] = opts.cacheType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDirStatsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:queryDirStatsData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询定制的目录带宽，仅有部分用户支持该功能
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2020-12-07T16:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2020-12-07T16:20:00Z，开始时间和结束时间跨度 不能超过4个小时  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名，该接口仅支持单域名查询  optional
      * @param {} [opts.dir] - 需要过滤的目录，以正斜线(/)开头，不填表示查询所有目录。查询目录同时需要以正斜线(/)结尾。 如:/path1/path2/path3/  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain
      * @param flowItem data
      */

  queryCustomizedDirBandWidth (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.dir !== undefined && opts.dir !== null) {
      postBody['dir'] = opts.dir
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCustomizedDirBandWidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/statistics:queryCustomizedDirBandWidth',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分页查询直播流数据接口
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.appName] - app名  optional
      * @param {} [opts.streamName] - 流名  optional
      * @param {} [opts.pageNum] - 页码，不传默认1  optional
      * @param {} [opts.pageSize] - 页size,不传默认100,最大值1000  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total
      * @param integer pageNum
      * @param integer pageSize
      * @param statisticsLiveStreamInfo streamInfoList
      */

  queryStreamInfo (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryStreamInfo"
      )
    }

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      postBody['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryStreamInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/liveStatistics:streamInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询平均带宽
      * @param {Object} opts - parameters
      * @param {string} opts.starttime - 指定查询开始时间(格式:201906011000)，返回数据包含该时间点。
      * @param {string} opts.stoptime - 指定查询结束时间(格式:201906011100)，返回数据不包含该时间点
      * @param {string} [opts.clientid] - 按照设备ID查询设备带宽。  optional
      * @param {integer} [opts.page] - 用于支持分页查询，默认为1，表示第几页。  optional
      * @param {integer} [opts.size] - 用于支持分页查询，表示每页返回多少条数据，默认每页返回10条数据，size必须是10的整数倍，并且最大值是100。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param page page  分页信息
      * @param queryAvgBandwidthGroup data
      */

  queryAvgBandwidthForPCdn (opts, callback) {
    opts = opts || {}

    if (opts.starttime === undefined || opts.starttime === null) {
      throw new Error(
        "Missing the required parameter 'opts.starttime' when calling queryAvgBandwidthForPCdn"
      )
    }
    if (opts.stoptime === undefined || opts.stoptime === null) {
      throw new Error(
        "Missing the required parameter 'opts.stoptime' when calling queryAvgBandwidthForPCdn"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.starttime !== undefined && opts.starttime !== null) {
      queryParams['starttime'] = opts.starttime
    }
    if (opts.stoptime !== undefined && opts.stoptime !== null) {
      queryParams['stoptime'] = opts.stoptime
    }
    if (opts.clientid !== undefined && opts.clientid !== null) {
      queryParams['clientid'] = opts.clientid
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.size !== undefined && opts.size !== null) {
      queryParams['size'] = opts.size
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAvgBandwidthForPCdn with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/pcdn:queryAvgBandwidth',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询设备状态
      * @param {Object} opts - parameters
      * @param {string} opts.macAddr - 查询dev的mac地址（如DCD87C047117）
      * @param {string} callback - callback
      @return {Object} result
      * @param string macAddress  mac地址
      * @param integer activeConnNum  活跃链接数量
      * @param string startupTime  启动时间
      * @param string cacheFree  指定缓存剩余空间，单位GB，float64，保留小数点后两位
      * @param string diskFree  设备磁盘剩余空间，单位GB，float64，保留小数点后两位
      * @param number cpuIdle  cpu idle百分比，float64，保留小数点后两位
      * @param integer port  nginx对外访问端口
      * @param number memFreePercent  内存剩余百分比， float64，保留小数点后两位
      * @param string devId  内容管理中为设备分配的设备id
      * @param string remoteIp  设备外网地址
      * @param string region  设备所属区域，如huadong、huanan
      * @param string isp  设备所属运营商，如ct、uni、cm
      * @param string report  设备最近心跳上报
      */

  queryDeviceStatusForPCdn (opts, callback) {
    opts = opts || {}

    if (opts.macAddr === undefined || opts.macAddr === null) {
      throw new Error(
        "Missing the required parameter 'opts.macAddr' when calling queryDeviceStatusForPCdn"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.macAddr !== undefined && opts.macAddr !== null) {
      queryParams['macAddr'] = opts.macAddr
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDeviceStatusForPCdn with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/pcdn:queryDeviceStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  无线宝按条件查询的统计接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,时间戳  optional
      * @param {} [opts.endTime] - 查询截止时间,时间戳  optional
      * @param {} [opts.fields] - 查询的字段，取值范围(avgbandwidth,pv,flow)。多个用逗号分隔。默认为空，表示查询带宽流量  optional
      * @param {} [opts.area]   optional
      * @param {} [opts.isp]   optional
      * @param {} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin”，分别表示1min，5min。默认为空，表示fiveMin  optional
      * @param {} [opts.category] - 业务类型  optional
      * @param {} [opts.macAddr] - 设备id  optional
      * @param {} [opts.pluginPin] - 插件pin  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime  2020/07/30 10:30，查询起始时间
      * @param string endTime  2020/07/30 11:00，查询截止时间
      * @param statisticsDataItem statistics
      */

  queryJDBoxStatisticsData (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.category !== undefined && opts.category !== null) {
      postBody['category'] = opts.category
    }
    if (opts.macAddr !== undefined && opts.macAddr !== null) {
      postBody['macAddr'] = opts.macAddr
    }
    if (opts.pluginPin !== undefined && opts.pluginPin !== null) {
      postBody['pluginPin'] = opts.pluginPin
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryJDBoxStatisticsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/jdBoxStatistics',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  无线宝按group查询的统计接口
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,时间戳  optional
      * @param {} [opts.endTime] - 查询截止时间,时间戳  optional
      * @param {} [opts.groupBy] - 取值范围：area，isp，pin ,mac_addr，category，多个用,隔开,多个维度的查询，必须要限制较短的时间间隔  optional
      * @param {} [opts.fields] - 查询的字段，取值范围(avgbandwidth,pv,flow)。多个用逗号分隔。默认为空，表示查询带宽流量  optional
      * @param {} [opts.area] - 区域  optional
      * @param {} [opts.isp] - 运营商  optional
      * @param {} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin”，分别表示1min，5min。默认为空，表示fiveMin  optional
      * @param {} [opts.category] - 业务类型  optional
      * @param {} [opts.macAddr] - 设备id  optional
      * @param {} [opts.pluginPin] - 插件pin  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime  2021/01/19 10:30，查询起始时间
      * @param string endTime  2021/01/19 11:00，查询截止时间
      * @param statisticsDataItem statistics
      */

  queryJDBoxStatisticsDataWithGroup (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.groupBy !== undefined && opts.groupBy !== null) {
      postBody['groupBy'] = opts.groupBy
    }
    if (opts.fields !== undefined && opts.fields !== null) {
      postBody['fields'] = opts.fields
    }
    if (opts.area !== undefined && opts.area !== null) {
      postBody['area'] = opts.area
    }
    if (opts.isp !== undefined && opts.isp !== null) {
      postBody['isp'] = opts.isp
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.category !== undefined && opts.category !== null) {
      postBody['category'] = opts.category
    }
    if (opts.macAddr !== undefined && opts.macAddr !== null) {
      postBody['macAddr'] = opts.macAddr
    }
    if (opts.pluginPin !== undefined && opts.pluginPin !== null) {
      postBody['pluginPin'] = opts.pluginPin
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryJDBoxStatisticsDataWithGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/jdBoxStatisticsWithGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询平均带宽
      * @param {Object} opts - parameters
      * @param {string} opts.starttime - 指定查询开始时间(格式:201906011000)，返回数据包含该时间点。
      * @param {string} opts.stoptime - 指定查询结束时间(格式:201906011100)，返回数据不包含该时间点
      * @param {string} opts.pluginPin - 插件pin,多个用,隔开
      * @param {string} [opts.clientid] - 按照设备ID查询设备带宽,即macaddr,多个用,隔开  optional
      * @param {integer} [opts.page] - 用于支持分页查询，默认为1，表示第几页。  optional
      * @param {integer} [opts.size] - 用于支持分页查询，表示每页返回多少条数据，默认每页返回10条数据，size必须是10的整数倍，并且最大值是100。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param page page  分页信息
      * @param queryAvgBandwidthGroup data
      */

  queryJBoxAvgBandwidth (opts, callback) {
    opts = opts || {}

    if (opts.starttime === undefined || opts.starttime === null) {
      throw new Error(
        "Missing the required parameter 'opts.starttime' when calling queryJBoxAvgBandwidth"
      )
    }
    if (opts.stoptime === undefined || opts.stoptime === null) {
      throw new Error(
        "Missing the required parameter 'opts.stoptime' when calling queryJBoxAvgBandwidth"
      )
    }
    if (opts.pluginPin === undefined || opts.pluginPin === null) {
      throw new Error(
        "Missing the required parameter 'opts.pluginPin' when calling queryJBoxAvgBandwidth"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.starttime !== undefined && opts.starttime !== null) {
      queryParams['starttime'] = opts.starttime
    }
    if (opts.stoptime !== undefined && opts.stoptime !== null) {
      queryParams['stoptime'] = opts.stoptime
    }
    if (opts.pluginPin !== undefined && opts.pluginPin !== null) {
      queryParams['pluginPin'] = opts.pluginPin
    }
    if (opts.clientid !== undefined && opts.clientid !== null) {
      queryParams['clientid'] = opts.clientid
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.size !== undefined && opts.size !== null) {
      queryParams['size'] = opts.size
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryJBoxAvgBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/jdbox:queryAvgBandwidth',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询WAF总开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  开关状态, on:开启,off:关闭
      */

  queryWafSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryWafSwitch"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWafSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置WAF总开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.switchStatus] - 开关状态, on:开启,off:关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setWafSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setWafSwitch"
      )
    }

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWafSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询WAF总开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  开关状态, on:开启,off:关闭
      */

  queryWafWhiteRuleSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryWafWhiteRuleSwitch"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWafWhiteRuleSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRuleSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置WAF白名单开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.switchStatus] - 开关状态, on:开启,off:关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setWafWhiteRuleSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setWafWhiteRuleSwitch"
      )
    }

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWafWhiteRuleSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRuleSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询WAF白名单规则列表
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.ruleType - ruleType, valid values [ip, geo, uri]
      * @param {string} [opts.id] - ruleId, defalut empty  optional
      * @param {integer} [opts.pageSize] - page size , default 0 to query all  optional
      * @param {integer} [opts.pageIndex] - page index , default 0 to query all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wafWhiteRuleModel rules
      */

  querywafWhiteRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling querywafWhiteRules"
      )
    }
    if (opts.ruleType === undefined || opts.ruleType === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleType' when calling querywafWhiteRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      queryParams['ruleType'] = opts.ruleType
    }
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querywafWhiteRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新增一条白名单规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ruleType] - 白名单类型， uri ip geo  optional
      * @param {} [opts.matchOp] - 匹配模式,uri类型有效，0&#x3D;完全匹配  1&#x3D;前缀匹配 2&#x3D;包含 3&#x3D;正则 4&#x3D;大于 5&#x3D;后缀  optional
      * @param {} [opts.val] - 匹配值  optional
      * @param {} [opts.actions] - 后续处理 &quot;waf&quot; &quot;cc&quot; &quot;deny&quot;自由组合，空表示跳过后续所有阶段  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createWafWhiteRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createWafWhiteRule"
      )
    }

    let postBody = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }
    if (opts.matchOp !== undefined && opts.matchOp !== null) {
      postBody['matchOp'] = opts.matchOp
    }
    if (opts.val !== undefined && opts.val !== null) {
      postBody['val'] = opts.val
    }
    if (opts.actions !== undefined && opts.actions !== null) {
      postBody['actions'] = opts.actions
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createWafWhiteRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改指定的白名单规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.id - 需要修改的白名单ID
      * @param {} [opts.ruleType] - 白名单类型， uri ip geo  optional
      * @param {} [opts.matchOp] - 匹配模式,uri类型有效，0&#x3D;完全匹配  1&#x3D;前缀匹配 2&#x3D;包含 3&#x3D;正则 4&#x3D;大于 5&#x3D;后缀  optional
      * @param {} [opts.val] - 匹配值  optional
      * @param {} [opts.actions] - 后续处理 &quot;waf&quot; &quot;cc&quot; &quot;deny&quot;自由组合，空表示跳过后续所有阶段  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateWafWhiteRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling updateWafWhiteRule"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateWafWhiteRule"
      )
    }

    let postBody = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }
    if (opts.matchOp !== undefined && opts.matchOp !== null) {
      postBody['matchOp'] = opts.matchOp
    }
    if (opts.val !== undefined && opts.val !== null) {
      postBody['val'] = opts.val
    }
    if (opts.actions !== undefined && opts.actions !== null) {
      postBody['actions'] = opts.actions
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateWafWhiteRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRule/{id}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用WAF白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {} [opts.ruleType]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  enableWafWhiteRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling enableWafWhiteRules"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableWafWhiteRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRule:enable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用WAF白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {} [opts.ruleType]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  disableWafWhiteRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling disableWafWhiteRules"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableWafWhiteRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRule:disable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除WAF白名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.ids
      * @param {string} opts.ruleType
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteWafWhiteRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteWafWhiteRules"
      )
    }
    if (opts.ids === undefined || opts.ids === null) {
      throw new Error(
        "Missing the required parameter 'opts.ids' when calling deleteWafWhiteRules"
      )
    }
    if (opts.ruleType === undefined || opts.ruleType === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleType' when calling deleteWafWhiteRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      queryParams['ruleType'] = opts.ruleType
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      ids: opts.ids
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteWafWhiteRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWhiteRule/{ids}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询WAF黑名单开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  开关状态, on:开启,off:关闭
      */

  queryWafBlackRuleSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryWafBlackRuleSwitch"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWafBlackRuleSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRuleSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置WAF黑名单开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.switchStatus] - 开关状态, on:开启,off:关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setWafBlackRuleSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setWafBlackRuleSwitch"
      )
    }

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWafBlackRuleSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRuleSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询WAF黑名单规则列表
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.ruleType - ruleType, valid values [ip, geo, uri]
      * @param {string} [opts.id] - ruleId, defalut empty  optional
      * @param {integer} [opts.pageSize] - page size , default 0 to query all  optional
      * @param {integer} [opts.pageIndex] - page index , default 0 to query all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wafBlackRuleModel rules
      */

  querywafBlackRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling querywafBlackRules"
      )
    }
    if (opts.ruleType === undefined || opts.ruleType === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleType' when calling querywafBlackRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      queryParams['ruleType'] = opts.ruleType
    }
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querywafBlackRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新增一条黑名单规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ruleType] - 黑名单类型， uri ip geo  optional
      * @param {} [opts.matchOp] - 匹配模式,uri类型有效，0&#x3D;完全匹配  1&#x3D;前缀匹配 2&#x3D;包含 3&#x3D;正则 4&#x3D;大于 5&#x3D;后缀  optional
      * @param {} [opts.val] - 匹配值  optional
      * @param {} [opts.atOp] - 1：forbidden，493封禁并返回自定义页面 2：redirect，302跳转 3： verify@captcha 4： verify@jscookie  optional
      * @param {} [opts.atVal] - action为1时为自定义页面名称,空值或缺省值default为默认页面，2时为跳转url，其他时无效  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createWafBlackRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createWafBlackRule"
      )
    }

    let postBody = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }
    if (opts.matchOp !== undefined && opts.matchOp !== null) {
      postBody['matchOp'] = opts.matchOp
    }
    if (opts.val !== undefined && opts.val !== null) {
      postBody['val'] = opts.val
    }
    if (opts.atOp !== undefined && opts.atOp !== null) {
      postBody['atOp'] = opts.atOp
    }
    if (opts.atVal !== undefined && opts.atVal !== null) {
      postBody['atVal'] = opts.atVal
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createWafBlackRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改指定的黑名单规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.id - 需要修改的黑名单ID
      * @param {} [opts.ruleType] - 黑名单类型， uri ip geo  optional
      * @param {} [opts.matchOp] - 匹配模式,uri类型有效，0&#x3D;完全匹配  1&#x3D;前缀匹配 2&#x3D;包含 3&#x3D;正则 4&#x3D;大于 5&#x3D;后缀  optional
      * @param {} [opts.val] - 匹配值  optional
      * @param {} [opts.atOp] - 1：forbidden，493封禁并返回自定义页面 2：redirect，302跳转 3： verify@captcha 4： verify@jscookie  optional
      * @param {} [opts.atVal] - action为1时为自定义页面名称,空值或缺省值default为默认页面，2时为跳转url，其他时无效  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateWafBlackRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling updateWafBlackRule"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateWafBlackRule"
      )
    }

    let postBody = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }
    if (opts.matchOp !== undefined && opts.matchOp !== null) {
      postBody['matchOp'] = opts.matchOp
    }
    if (opts.val !== undefined && opts.val !== null) {
      postBody['val'] = opts.val
    }
    if (opts.atOp !== undefined && opts.atOp !== null) {
      postBody['atOp'] = opts.atOp
    }
    if (opts.atVal !== undefined && opts.atVal !== null) {
      postBody['atVal'] = opts.atVal
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateWafBlackRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRule/{id}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用WAF黑名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {} [opts.ruleType]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  enableWafBlackRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling enableWafBlackRules"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableWafBlackRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRule:enable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用WAF黑名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {} [opts.ruleType]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  disableWafBlackRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling disableWafBlackRules"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      postBody['ruleType'] = opts.ruleType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableWafBlackRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRule:disable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除WAF黑名单
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.ids
      * @param {string} opts.ruleType
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteWafBlackRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteWafBlackRules"
      )
    }
    if (opts.ids === undefined || opts.ids === null) {
      throw new Error(
        "Missing the required parameter 'opts.ids' when calling deleteWafBlackRules"
      )
    }
    if (opts.ruleType === undefined || opts.ruleType === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleType' when calling deleteWafBlackRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.ruleType !== undefined && opts.ruleType !== null) {
      queryParams['ruleType'] = opts.ruleType
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      ids: opts.ids
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteWafBlackRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafBlackRule/{ids}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CC 防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  开关状态, on:开启,off:关闭
      */

  queryCCProtectSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryCCProtectSwitch"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCCProtectSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置CC 防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.switchStatus] - 开关状态, on:开启,off:关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setCCProtectSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setCCProtectSwitch"
      )
    }

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setCCProtectSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CC防护规则列表
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} [opts.id] - ruleId, defalut empty  optional
      * @param {integer} [opts.pageSize] - page size , default 0 to query all  optional
      * @param {integer} [opts.pageIndex] - page index , default 0 to query all  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wafCCProtectRuleModel rules
      */

  queryCCProtectRules (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryCCProtectRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCCProtectRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新增一条CC防护规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.uri] - null  optional
      * @param {} [opts.detectPeriod] - null  optional
      * @param {} [opts.singleIpLimit] - null  optional
      * @param {} [opts.blockType] - null  optional
      * @param {} [opts.blockTime] - null  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  createCCProtectRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling createCCProtectRule"
      )
    }

    let postBody = {}
    if (opts.uri !== undefined && opts.uri !== null) {
      postBody['uri'] = opts.uri
    }
    if (opts.detectPeriod !== undefined && opts.detectPeriod !== null) {
      postBody['detectPeriod'] = opts.detectPeriod
    }
    if (opts.singleIpLimit !== undefined && opts.singleIpLimit !== null) {
      postBody['singleIpLimit'] = opts.singleIpLimit
    }
    if (opts.blockType !== undefined && opts.blockType !== null) {
      postBody['blockType'] = opts.blockType
    }
    if (opts.blockTime !== undefined && opts.blockTime !== null) {
      postBody['blockTime'] = opts.blockTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCCProtectRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改CC防护规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.id - 需要修改的规则ID
      * @param {} [opts.uri] - null  optional
      * @param {} [opts.detectPeriod] - null  optional
      * @param {} [opts.singleIpLimit] - null  optional
      * @param {} [opts.blockType] - null  optional
      * @param {} [opts.blockTime] - null  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateCCProtectRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling updateCCProtectRule"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateCCProtectRule"
      )
    }

    let postBody = {}
    if (opts.uri !== undefined && opts.uri !== null) {
      postBody['uri'] = opts.uri
    }
    if (opts.detectPeriod !== undefined && opts.detectPeriod !== null) {
      postBody['detectPeriod'] = opts.detectPeriod
    }
    if (opts.singleIpLimit !== undefined && opts.singleIpLimit !== null) {
      postBody['singleIpLimit'] = opts.singleIpLimit
    }
    if (opts.blockType !== undefined && opts.blockType !== null) {
      postBody['blockType'] = opts.blockType
    }
    if (opts.blockTime !== undefined && opts.blockTime !== null) {
      postBody['blockTime'] = opts.blockTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCCProtectRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRule/{id}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用CC防护规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  enableCCProtectRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling enableCCProtectRule"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableCCProtectRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRule:enable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用CC防护规则
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.ids]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  disableCCProtectRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling disableCCProtectRule"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableCCProtectRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRule:disable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除ccProtectRule
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} opts.ids
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCCProtectRule (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling deleteCCProtectRule"
      )
    }
    if (opts.ids === undefined || opts.ids === null) {
      throw new Error(
        "Missing the required parameter 'opts.ids' when calling deleteCCProtectRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain,
      ids: opts.ids
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCCProtectRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/ccProtectRule/{ids}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询web防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string switchStatus  开关状态, on:开启,off:关闭
      */

  queryWebProtectSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryWebProtectSwitch"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWebProtectSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWebProtectSwitch',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置web防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.switchStatus] - 开关状态, on:开启,off:关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setWebProtectSwitch (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling setWebProtectSwitch"
      )
    }

    let postBody = {}
    if (opts.switchStatus !== undefined && opts.switchStatus !== null) {
      postBody['switchStatus'] = opts.switchStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWebProtectSwitch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWebProtectSwitch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询web防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string wafMode  0：拦截模式 (阻断forbidden 493跳到自定义页面) ，1-检测模式(观察notice)
      * @param integer wafLevel  规则策略等级 0为宽松, 1为正常, 2为严格
      * @param string redirection  拦截模式跳转的自定义页面名称, 缺省或default返回默认页面
      */

  queryWebProtectSettings (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryWebProtectSettings"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWebProtectSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWebProtectSettings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置web防护开关
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {} [opts.wafMode] - 0：拦截模式 (阻断forbidden 493跳到自定义页面) ，1-检测模式(观察notice)  optional
      * @param {} [opts.wafLevel] - 规则策略等级 0为宽松, 1为正常, 2为严格  optional
      * @param {} [opts.redirection] - 拦截模式跳转的自定义页面名称, 缺省或default返回默认页面  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateWebProtectSettings (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling updateWebProtectSettings"
      )
    }

    let postBody = {}
    if (opts.wafMode !== undefined && opts.wafMode !== null) {
      postBody['wafMode'] = opts.wafMode
    }
    if (opts.wafLevel !== undefined && opts.wafLevel !== null) {
      postBody['wafLevel'] = opts.wafLevel
    }
    if (opts.redirection !== undefined && opts.redirection !== null) {
      postBody['redirection'] = opts.redirection
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateWebProtectSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafWebProtectSettings',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询waf地域信息
      * @param {Object} opts - parameters
      * @param {string} opts.skipType - skipType, valid values [skip, deny]
      * @param {string} callback - callback
      @return {Object} result
      * @param wafRegionsModel china
      * @param wafRegionsModel foreign
      */

  queryWafRegions (opts, callback) {
    opts = opts || {}

    if (opts.skipType === undefined || opts.skipType === null) {
      throw new Error(
        "Missing the required parameter 'opts.skipType' when calling queryWafRegions"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.skipType !== undefined && opts.skipType !== null) {
      queryParams['skipType'] = opts.skipType
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWafRegions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/wafRegions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询waf ip黑名单配置状态
      * @param {Object} opts - parameters
      * @param {string} opts.domain - 用户域名
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean settingStatus  true or false, true:scdn的黑名单为打开状态，并至少存在一条ruleType&#x3D;ip的黑名单规则且为启用状态
      */

  queryIpBlackSettingStatus (opts, callback) {
    opts = opts || {}

    if (opts.domain === undefined || opts.domain === null) {
      throw new Error(
        "Missing the required parameter 'opts.domain' when calling queryIpBlackSettingStatus"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domain: opts.domain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryIpBlackSettingStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domain/{domain}/wafIpBlackSettingStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询攻击来源
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param areaData areaDatas
      */

  wafQueryPvForAreaAndIp (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call wafQueryPvForAreaAndIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/wafPvForAreaAndIp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询总请求量与攻击请求量
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pvItem pvs
      * @param integer peakAttackPv
      * @param integer peakTotalPv
      */

  wafQueryPv (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call wafQueryPv with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/wafPvStatistic',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询攻击记录详情
      * @param {Object} opts - parameters
      * @param {} [opts.startTime] - 查询起始时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.endTime] - 查询截止时间,UTC时间，格式为:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，示例:2018-10-21T10:00:00Z  optional
      * @param {} [opts.domain] - 需要查询的域名, 必须为用户pin下有权限的域名  optional
      * @param {} [opts.sortField] - 排序字段  optional
      * @param {} [opts.sortRule] - 排序规则：desc，asc  optional
      * @param {} [opts.pageNumber] - 页码，从1开始  optional
      * @param {} [opts.pageSize] - 页大小，默认20  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string total
      * @param attackDetail attackDetails
      */

  wafQueryAttackDetails (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      postBody['domain'] = opts.domain
    }
    if (opts.sortField !== undefined && opts.sortField !== null) {
      postBody['sortField'] = opts.sortField
    }
    if (opts.sortRule !== undefined && opts.sortRule !== null) {
      postBody['sortRule'] = opts.sortRule
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cdn/0.10.47'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call wafQueryAttackDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/wafAttackDetails',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = CDN
