/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 站点检测类接口
 * 京东云内容安全-OpenAPI站点检测类接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'censor'
Service._services[serviceId] = true

/**
 * censor service.
 * @version 1.0.3
 */

class CENSOR extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'censor.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  提交音频异步检测任务
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 机审策略，eg: default  optional
      * @param {} [opts.scenes] - 指定检测场景  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，每个元素的具体结构描述见audioTask。  optional
      * @param {} [opts.callback] - 异步检测结果回调通知您的URL，支持HTTP/HTTPS。该字段为空时，您必须定时检索检测结果。  optional
      * @param {} [opts.seed] - 随机字符串，该值用于回调通知请求中的签名。当使用callback时，该字段必须提供。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param taskData data
      */

  asyncAudioScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }
    if (opts.callback !== undefined && opts.callback !== null) {
      postBody['callback'] = opts.callback
    }
    if (opts.seed !== undefined && opts.seed !== null) {
      postBody['seed'] = opts.seed
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncAudioScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/audio:asyncscan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看音频异步检测结果
      * @param {Object} opts - parameters
      * @param {array} opts.taskIds
      * @param {string} callback - callback
      @return {Object} result
      * @param audioResult data
      */

  audioResults (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling audioResults"
      )
    }

    let postBody = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call audioResults with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/audio:results',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交音频异步检测任务V2
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.url] - 最大长度512, 语音文件url  optional
      * @param {} [opts.version] - 最大长度4，接口版本号，可选值 v3.5  optional
      * @param {} [opts.title] - 最大长度512，文件标题  optional
      * @param {} [opts.ip] - 最大长度32，用户IP地址  optional
      * @param {} [opts.account] - 最大长度128，用户唯一标识，如果无需登录则为空  optional
      * @param {} [opts.deviceId] - 最大长度128，用户设备 id，与设备画像库匹配，明文请转大写传入；MD5加密请明文转大写后MD5计算，再转大写传入，建议抄送  optional
      * @param {} [opts.deviceType] - 用户设备id的类型，0:其他，10:IMEI，11:AndroidID，12:IDFA，13:IDFV，14:MAC ，20:IMEI_MD5，21:AndroidID_MD5，22:IDFA_MD5，23:IDFV_MD5，24:MAC_MD5  optional
      * @param {} [opts.callback] - 最大长度2^16-1，数据回调参数，调用方根据业务情况自行设计，当调用离线结果获取接口时，该接口会原样返回该字段，详细见音频离线检测结果获取。作为数据处理标识，因此该字段应该设计为能唯一定位到该次请求的数据结构，如对用户的昵称进行检测，dataId可设为用户标识（用户ID），用户修改多次，每次请求数据的dataId可能一致，但是callback参数可以设计成定位该次请求的数据结构，比如callback字段设计成json，包含dataId和请求的时间戳等信息，当然如果不想做区分，也可以直接把callback设置成dataId的值。  optional
      * @param {} [opts.callbackUrl] - 最大长度256，离线结果回调通知到客户的URL。主动回调数据接口超时时间设置为2s，为了保证顺利接收数据，需保证接收接口性能稳定并且保证幂等性。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param audioTaskData result
      */

  asyncAudioScanV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.ip !== undefined && opts.ip !== null) {
      postBody['ip'] = opts.ip
    }
    if (opts.account !== undefined && opts.account !== null) {
      postBody['account'] = opts.account
    }
    if (opts.deviceId !== undefined && opts.deviceId !== null) {
      postBody['deviceId'] = opts.deviceId
    }
    if (opts.deviceType !== undefined && opts.deviceType !== null) {
      postBody['deviceType'] = opts.deviceType
    }
    if (opts.callback !== undefined && opts.callback !== null) {
      postBody['callback'] = opts.callback
    }
    if (opts.callbackUrl !== undefined && opts.callbackUrl !== null) {
      postBody['callbackUrl'] = opts.callbackUrl
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncAudioScanV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/audio:asyncscanv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  语音检测结果获取接口，获取离线处理的数据后，下次调用，不会再次返回之前获取过的离线数据。小于10s/20次，请求频率过快服务器会拒绝处理
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本v1  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param audioAntispamResult antispam
      * @param audioASRResult asr
      * @param audioLanguageResult language
      * @param audioVoiceResult voice
      */

  audioCallbackV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call audioCallbackV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/audio:callbackv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据taskid查询语音检测结果，小于10s/20次，请求频率过快服务器会拒绝处理
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本v1  optional
      * @param {} [opts.taskIds] - 要查询的taskId  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param audioAntispamResult result
      */

  audioResultsV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call audioResultsV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/audio:resultsv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除敏感库
      * @param {Object} opts - parameters
      * @param {string} opts.libId - 敏感库id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCensorLib (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCensorLib"
      )
    }

    opts = opts || {}

    if (opts.libId === undefined || opts.libId === null) {
      throw new Error(
        "Missing the required parameter 'opts.libId' when calling deleteCensorLib"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.libId !== undefined && opts.libId !== null) {
      queryParams['libId'] = opts.libId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCensorLib with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customCensorLib:custom',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除敏感库Item
      * @param {Object} opts - parameters
      * @param {string} opts.libId - 敏感库id
      * @param {string} opts.itemId - itemId，支持多个，用&#39;,&#39;分隔，表示批量删除
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCensorLibItems (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCensorLibItems"
      )
    }

    opts = opts || {}

    if (opts.libId === undefined || opts.libId === null) {
      throw new Error(
        "Missing the required parameter 'opts.libId' when calling deleteCensorLibItems"
      )
    }
    if (opts.itemId === undefined || opts.itemId === null) {
      throw new Error(
        "Missing the required parameter 'opts.itemId' when calling deleteCensorLibItems"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.libId !== undefined && opts.libId !== null) {
      queryParams['libId'] = opts.libId
    }
    if (opts.itemId !== undefined && opts.itemId !== null) {
      queryParams['itemId'] = opts.itemId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCensorLibItems with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customCensorLib:customItem',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图片同步检测
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 机审策略，eg: default  optional
      * @param {} [opts.scenes] - 指定检测场景  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，即最多对10段文本进行检测。每个元素的具体结构描述见ImageTask。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param imageResult data
      */

  imageScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call imageScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/image:scan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交图片异步检测任务
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 机审策略，eg: default  optional
      * @param {} [opts.scenes] - 指定检测场景  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，每个元素的具体结构描述见ImageTask。  optional
      * @param {} [opts.callback] - 异步检测结果回调通知您的URL，支持HTTP/HTTPS。该字段为空时，您必须定时检索检测结果。  optional
      * @param {} [opts.seed] - 随机字符串，该值用于回调通知请求中的签名。当使用callback时，该字段必须提供。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param taskData data
      */

  asyncImageScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }
    if (opts.callback !== undefined && opts.callback !== null) {
      postBody['callback'] = opts.callback
    }
    if (opts.seed !== undefined && opts.seed !== null) {
      postBody['seed'] = opts.seed
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncImageScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/image:asyncscan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看图片异步检测结果
      * @param {Object} opts - parameters
      * @param {array} opts.taskIds
      * @param {string} callback - callback
      @return {Object} result
      * @param imageResult data
      */

  imageResults (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling imageResults"
      )
    }

    let postBody = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call imageResults with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/image:results',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图片同步检测v2
      * @param {Object} opts - parameters
      * @param {} [opts.images] - 指定检测场景  optional
      * @param {} [opts.version] - 接口版本v4.1  optional
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.checkLabels] - 接口指定过检分类，可多选，过检分类列表：100：色情，110：性感低俗，200：广告，210：二维码，260：广告法，300：暴恐，400：违禁，500：涉政，800：恶心类，900：其他，1100：涉价值观响应结果  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param imageAntispamResult antispam
      * @param oCRResult ocr
      * @param faceResult face
      * @param qualityResult quality
      * @param logoResult logo
      * @param sceneResult scene
      */

  imageScanV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.images !== undefined && opts.images !== null) {
      postBody['images'] = opts.images
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.checkLabels !== undefined && opts.checkLabels !== null) {
      postBody['checkLabels'] = opts.checkLabels
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call imageScanV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/image:scanv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除限制参数配置
      * @param {Object} opts - parameters
      * @param {string} opts.limitId - 限制参数配置id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLimit (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteLimit"
      )
    }

    opts = opts || {}

    if (opts.limitId === undefined || opts.limitId === null) {
      throw new Error(
        "Missing the required parameter 'opts.limitId' when calling deleteLimit"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.limitId !== undefined && opts.limitId !== null) {
      queryParams['limitId'] = opts.limitId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLimit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/limit:limit',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  文本同步检测-检测文本中是否包含违规信息
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 机审策略，eg: default  optional
      * @param {} [opts.scenes] - 指定检测场景，固定值：antispam  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，即最多对10段文本进行检测。每个元素的具体结构描述见TextTask。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param textResult data
      */

  textScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call textScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/text:scan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  文本同步检测-检测文本中是否包含违规信息
      * @param {Object} opts - parameters
      * @param {} [opts.scenes] - 指定检测场景，固定值：antispam  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，即最多对10段文本进行检测。每个元素的具体结构描述见TextTask。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param textResult data
      */

  innerTextScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call innerTextScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/text:innerscan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  文本同步检测-检测文本中是否包含违规信息
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本号，固定值 v4  optional
      * @param {} [opts.checkLabels] - 可指定多个垃圾类别进行机器检测，多个垃圾类别以逗号分隔（&quot;100,200&quot;）  optional
      * @param {} [opts.texts] - 1-100条文本数据。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param textResultDetailV2 result
      */

  textScanV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.checkLabels !== undefined && opts.checkLabels !== null) {
      postBody['checkLabels'] = opts.checkLabels
    }
    if (opts.texts !== undefined && opts.texts !== null) {
      postBody['texts'] = opts.texts
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call textScanV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/text:scanv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看文本疑似结果，小于10s/20次，请求频率过快服务器会拒绝处理
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本v4  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param textResultDetailV2 result
      */

  textResultsV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call textResultsV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/text:resultsv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交视频异步检测任务
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 机审策略，eg: default  optional
      * @param {} [opts.live] - 是否直播。默认为false，表示为普通视频检测；若是直播检测，该值必须传入true。  optional
      * @param {} [opts.scenes] - 指定检测场景  optional
      * @param {} [opts.audioScenes] - 视频中语音的检测场景  optional
      * @param {} [opts.tasks] - 检测任务列表，包含一个或多个元素。每个元素是个结构体，最多可添加10个元素，每个元素的具体结构描述见videoTask。  optional
      * @param {} [opts.callback] - 异步检测结果回调通知您的URL，支持HTTP/HTTPS。该字段为空时，您必须定时检索检测结果。  optional
      * @param {} [opts.seed] - 随机字符串，该值用于回调通知请求中的签名。当使用callback时，该字段必须提供。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param taskData data
      */

  asyncVideoScan (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.live !== undefined && opts.live !== null) {
      postBody['live'] = opts.live
    }
    if (opts.scenes !== undefined && opts.scenes !== null) {
      postBody['scenes'] = opts.scenes
    }
    if (opts.audioScenes !== undefined && opts.audioScenes !== null) {
      postBody['audioScenes'] = opts.audioScenes
    }
    if (opts.tasks !== undefined && opts.tasks !== null) {
      postBody['tasks'] = opts.tasks
    }
    if (opts.callback !== undefined && opts.callback !== null) {
      postBody['callback'] = opts.callback
    }
    if (opts.seed !== undefined && opts.seed !== null) {
      postBody['seed'] = opts.seed
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncVideoScan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/video:asyncscan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看视频异步检测结果
      * @param {Object} opts - parameters
      * @param {array} opts.taskIds
      * @param {string} callback - callback
      @return {Object} result
      * @param videoResult data
      */

  videoResults (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling videoResults"
      )
    }

    let postBody = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call videoResults with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/video:results',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交视频异步检测任务V2
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.url] - 最大长度512, 点播视频地址  optional
      * @param {} [opts.dataId] - 最大长度128，点播视频唯一标识  optional
      * @param {} [opts.version] - 接口版本号，可选值 v3.2  optional
      * @param {} [opts.title] - 最大长度512，视频名称  optional
      * @param {} [opts.callback] - 最大长度512，数据回调参数，产品根据业务情况自行设计，当获取离线检测结果时，内容安全服务会返回该字段  optional
      * @param {} [opts.callbackUrl] - 最大长度256，离线结果回调通知到客户的URL。主动回调数据接口超时时间设置为2s，为了保证顺利接收数据，需保证接收接口性能稳定并且保证幂等性。  optional
      * @param {} [opts.uniqueKey] - 最大长度64，客户个性化视频唯一性标识，传入后，将以此值作为重复检测依据，若不传，默认以URL作为查重依据,如果重复提交会被拒绝，返回报错信息请求重复，以及原提交taskID值，具体返回请查看响应示例  optional
      * @param {} [opts.scFrequency] - 最大长度64，客户个性化视频唯一性标识，传入后，将以此值作为重复检测依据，若不传，默认以URL作为查重依据,如果重复提交会被拒绝，返回报错信息请求重复，以及原提交taskID值，具体返回请查看响应示例  optional
      * @param {} [opts.advancedFrequency] - 高级截帧设置，此项填写，默认截帧策略失效  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param videoTaskData result
      */

  asyncVideoScanV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.dataId !== undefined && opts.dataId !== null) {
      postBody['dataId'] = opts.dataId
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.callback !== undefined && opts.callback !== null) {
      postBody['callback'] = opts.callback
    }
    if (opts.callbackUrl !== undefined && opts.callbackUrl !== null) {
      postBody['callbackUrl'] = opts.callbackUrl
    }
    if (opts.uniqueKey !== undefined && opts.uniqueKey !== null) {
      postBody['uniqueKey'] = opts.uniqueKey
    }
    if (opts.scFrequency !== undefined && opts.scFrequency !== null) {
      postBody['scFrequency'] = opts.scFrequency
    }
    if (
      opts.advancedFrequency !== undefined &&
      opts.advancedFrequency !== null
    ) {
      postBody['advancedFrequency'] = opts.advancedFrequency
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncVideoScanV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/video:asyncscanv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  视频检测结果获取接口，获取离线处理的数据后，下次调用，不会再次返回之前获取过的离线数据。小于10s/20次，请求频率过快服务器会拒绝处理
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本v1  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param videoResultV2 result
      */

  videoCallbackV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call videoCallbackV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/video:callbackv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据taskid查询视频检测结果，小于10s/20次，请求频率过快服务器会拒绝处理
      * @param {Object} opts - parameters
      * @param {} [opts.bizType] - 业务bizType，请联系客户经理获取  optional
      * @param {} [opts.version] - 接口版本v1  optional
      * @param {} [opts.taskIds] - 要查询的taskId  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param videoResultV2 result
      */

  videoResultsV2 (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bizType !== undefined && opts.bizType !== null) {
      postBody['bizType'] = opts.bizType
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  censor/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call videoResultsV2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/video:resultsv2',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = CENSOR
