/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 实例信息
 * 云解析OpenAPI实例信息接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'clouddnsservice'
Service._services[serviceId] = true

/**
 * clouddnsservice service.
 * @version 1.0.12
 */

JDCloud.CLOUDDNSSERVICE = class CLOUDDNSSERVICE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'clouddnsservice.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查看用户在云解析服务下的操作记录
      * @param {Object} opts - parameters
      * @param {integer} opts.pageNumber - 分页参数，页的序号，默认是1
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目，默认是10
      * @param {string} opts.startTime - 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} opts.endTime - 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} [opts.keyWord] - 日志需要匹配的关键词  optional
      * @param {boolean} [opts.success] - 日志里面的结果是成功还是失败  optional
      * @param {integer} [opts.type] - 日志的类型  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param actionlog dataList
      * @param integer currentCount  当前页的操作记录列表里的个数
      * @param integer totalCount  所有操作记录的个数
      * @param integer totalPage  操作记录列表按照分页参数一共的页数
      */

  getActionLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getActionLog"
      )
    }

    opts = opts || {}

    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling getActionLog"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling getActionLog"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling getActionLog"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling getActionLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.keyWord !== undefined && opts.keyWord !== null) {
      queryParams['keyWord'] = opts.keyWord
    }
    if (opts.success !== undefined && opts.success !== null) {
      queryParams['success'] = opts.success
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getActionLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/log/actionLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户所属的主域名列表。
请在调用域名相关的接口之前，调用此接口获取相关的domainId和domainName。
主域名的相关概念，请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/product-overview&quot;&gt;云解析文档&lt;/a&gt;

      * @param {Object} opts - parameters
      * @param {integer} opts.pageNumber - 分页查询时查询的每页的序号，起始值为1，默认为1
      * @param {integer} opts.pageSize - 分页查询时设置的每页行数，默认为10
      * @param {string} [opts.domainName] - 关键字，按照”%domainName%”模式匹配主域名  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domain dataList
      * @param integer currentCount  当前页的域名列表里域名的个数
      * @param integer totalCount  所有匹配的域名列表的个数
      * @param integer totalPage  所有匹配的域名列表按照分页参数一共的页数
      */

  getDomains (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomains"
      )
    }

    opts = opts || {}

    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling getDomains"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling getDomains"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名
如何添加免费域名，详细情况请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/domainadd&quot;&gt;文档&lt;/a&gt;
添加收费域名，请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/purchase-process&quot;&gt;文档&lt;/a&gt;，
添加收费域名前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情。

      * @param {Object} opts - parameters
      * @param {integer} opts.packId - 主域名的套餐类型, 0-&gt;免费 ,1-&gt;企业版, 2-&gt;高级版
      * @param {string} opts.domainName - 要添加的主域名
      * @param {integer} [opts.domainId] - 主域名的ID，升级套餐必填，请使用getDomains获取  optional
      * @param {integer} [opts.buyType] - 1-&gt;新购买、3-&gt;升级，收费套餐的域名必填  optional
      * @param {integer} [opts.timeSpan] - 取值1，2，3 ，含义：时长，收费套餐的域名必填  optional
      * @param {integer} [opts.timeUnit] - 时间单位，收费套餐的域名必填，1：小时，2：天，3：月，4：年  optional
      * @param {integer} [opts.billingType] - 计费类型，可以不传此参数。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainAdded data  新添加的的域名结构
      * @param string order  添加收费版域名的订单号
      */

  addDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addDomain"
      )
    }

    opts = opts || {}

    if (opts.packId === undefined || opts.packId === null) {
      throw new Error(
        "Missing the required parameter 'opts.packId' when calling addDomain"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling addDomain"
      )
    }

    let postBody = {}
    if (opts.packId !== undefined && opts.packId !== null) {
      postBody['packId'] = opts.packId
    }
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.domainId !== undefined && opts.domainId !== null) {
      postBody['domainId'] = opts.domainId
    }
    if (opts.buyType !== undefined && opts.buyType !== null) {
      postBody['buyType'] = opts.buyType
    }
    if (opts.timeSpan !== undefined && opts.timeSpan !== null) {
      postBody['timeSpan'] = opts.timeSpan
    }
    if (opts.timeUnit !== undefined && opts.timeUnit !== null) {
      postBody['timeUnit'] = opts.timeUnit
    }
    if (opts.billingType !== undefined && opts.billingType !== null) {
      postBody['billingType'] = opts.billingType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domainAdd',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 需要删除的主域名ID，请使用getDomains接口获取
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delDomain"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling delDomain"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainId !== undefined && opts.domainId !== null) {
      queryParams['domainId'] = opts.domainId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domainDel',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改主域名
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 需要修改的主域名，请使用getDomains接口获取
      * @param {integer} opts.id - 需要修改的主域名ID，请使用getDomains接口获取
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateDomain"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling updateDomain"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateDomain"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domainUpdate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看主域名的解析次数
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.domainName - 查询的主域名，，请使用getDomains接口获取
      * @param {string} opts.start - 查询时间段的起始时间, UTC时间，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 查询时间段的终止时间, UTC时间，例如2017-11-10T23:00:00Z
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param integer traffic
      */

  getDomainQueryCount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomainQueryCount"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getDomainQueryCount"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling getDomainQueryCount"
      )
    }
    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling getDomainQueryCount"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling getDomainQueryCount"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainQueryCount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/queryCount',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看域名的查询流量
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.domainName - 主域名，请使用getDomains接口获取
      * @param {string} opts.start - 时间段的起始时间, UTC时间，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 时间段的终止时间, UTC时间，例如2017-11-10T23:00:00Z
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param string unit  数据序列的单位
      * @param number traffic
      */

  getDomainQueryTraffic (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomainQueryTraffic"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getDomainQueryTraffic"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling getDomainQueryTraffic"
      )
    }
    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling getDomainQueryTraffic"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling getDomainQueryTraffic"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainQueryTraffic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/queryTraffic',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的解析记录。
在使用解析记录相关的接口之前，请调用此接口获取解析记录的列表。

      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {integer} [opts.pageNumber] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数, 默认为10  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rR dataList
      * @param integer totalCount  所有解析记录的个数
      * @param integer totalPage  所有解析记录的页数
      * @param integer currentCount  当前页解析记录的个数
      */

  searchRR (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  searchRR"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling searchRR"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call searchRR with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/RR',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询云解析所有的基础解析线路。
在使用解析线路的参数之前，请调用此接口获取解析线路的ID。

      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {integer} [opts.loadMode] - 展示方式，暂时不使用  optional
      * @param {integer} opts.packId - 套餐ID，0-&gt;免费版 1-&gt;企业版 2-&gt;企业高级版
      * @param {integer} opts.viewId - view ID，默认为-1
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param viewTree data
      */

  getViewTree (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getViewTree"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getViewTree"
      )
    }
    if (opts.packId === undefined || opts.packId === null) {
      throw new Error(
        "Missing the required parameter 'opts.packId' when calling getViewTree"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling getViewTree"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.loadMode !== undefined && opts.loadMode !== null) {
      queryParams['loadMode'] = opts.loadMode
    }
    if (opts.packId !== undefined && opts.packId !== null) {
      queryParams['packId'] = opts.packId
    }
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getViewTree with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/viewTree',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {addRR} opts.req - RR参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rR dataList  添加成功后的解析记录结果
      */

  addRR (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addRR"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling addRR"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addRR"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addRR with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/RRAdd',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改主域名的某个解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {updateRR} opts.req - updateRR参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateRR (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateRR"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling updateRR"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling updateRR"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateRR with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/RRUpdate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用、停用、删除主域名下的解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {array} [opts.ids] - 需要操作的解析记录ID，请使用searchRR接口获取。  optional
      * @param {string} opts.action - 操作类型，on-&gt;启用 off-&gt;停用 del-&gt;删除
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  operateRR (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  operateRR"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling operateRR"
      )
    }
    if (opts.action === undefined || opts.action === null) {
      throw new Error(
        "Missing the required parameter 'opts.action' when calling operateRR"
      )
    }

    let postBody = {}
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operateRR with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/RROperate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  同一个主域名下，批量新增或者批量更新导入解析记录。
如果解析记录的ID为0，是新增解析记录，如果不为0，则是更新解析记录。

      * @param {Object} opts - parameters
      * @param {array} [opts.req] - 需要设置的解析记录列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  batchSetDnsResolve (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  batchSetDnsResolve"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSetDnsResolve with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/BatchSetDnsResolve',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {addView} opts.req - 添加自定义线路的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userview data  添加成功后返回的自定义线路的结构
      */

  addUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addUserView"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addUserView"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/addUserView',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {delView} opts.req - 删除自定义线路的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delUserView"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling delUserView"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/delUserView',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 主域名ID
      * @param {integer} opts.viewId - 自定义线路ID
      * @param {string} [opts.viewName] - 自定义线路名称, 最多64个字符  optional
      * @param {integer} opts.pageNumber - 分页参数，页的序号
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userViewInput dataList
      * @param integer currentCount  当前页的自定义线路列表里的个数
      * @param integer totalCount  所有自定义线路列表的个数
      * @param integer totalPage  所有自定义线路列表按照分页参数一共的页数
      */

  getUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getUserView"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getUserView"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling getUserView"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling getUserView"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling getUserView"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainId !== undefined && opts.domainId !== null) {
      queryParams['domainId'] = opts.domainId
    }
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      queryParams['viewName'] = opts.viewName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/getUserView',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {addViewIP} opts.req - 添加域名的自定义解析线路的IP段的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addUserViewIP"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/addUserViewIP',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {delViewIP} opts.req - 删除域名的自定义解析线路的IP段的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling delUserViewIP"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/delUserViewIP',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 主域名ID
      * @param {integer} opts.viewId - 自定义线路ID
      * @param {string} [opts.viewName] - 自定义线路名称, 最多64个字符  optional
      * @param {integer} opts.pageNumber - 分页参数，页的序号, 默认为1
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目，默认为10
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dataList
      * @param integer currentCount  当前页的IP列表里的个数
      * @param integer totalCount  IP列表里的IP段的个数
      * @param integer totalPage  IP列表按照分页参数一共的页数
      */

  getUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getUserViewIP"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling getUserViewIP"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling getUserViewIP"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling getUserViewIP"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainId !== undefined && opts.domainId !== null) {
      queryParams['domainId'] = opts.domainId
    }
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      queryParams['viewName'] = opts.viewName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/userview/getUserViewIP',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看主域名的监控项的配置以及状态
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {integer} [opts.pageIndex] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数  optional
      * @param {string} [opts.searchValue] - 查询的值  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer currentCount  当前页面网站监控项的个数
      * @param integer totalCount  所有网站监控项的个数
      * @param integer totalPage  所有网站监控项的页数
      * @param monitor dataList
      */

  getMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getMonitor"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.searchValue !== undefined && opts.searchValue !== null) {
      queryParams['searchValue'] = opts.searchValue
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子域名的监控项，默认把子域名的所有监控项都添加上监控
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling addMonitor"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling addMonitor"
      )
    }

    let postBody = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      postBody['subDomainName'] = opts.subDomainName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorAdd',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子域名的可用监控对象
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  getTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTargets"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getTargets"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling getTargets"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      queryParams['subDomainName'] = opts.subDomainName
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/getTargets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子域名的某些特定监控对象为监控项
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {array} [opts.targets] - 子域名可用监控对象的数组  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addMonitorTarget (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addMonitorTarget"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling addMonitorTarget"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling addMonitorTarget"
      )
    }

    let postBody = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      postBody['subDomainName'] = opts.subDomainName
    }
    if (opts.targets !== undefined && opts.targets !== null) {
      postBody['targets'] = opts.targets
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addMonitorTarget with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorAddTarget',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  监控项的操作集合，包括：删除，暂停，启动, 手动恢复, 手动切换
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {string} opts.action - 删除del, 暂停stop, 开启start, 手动恢复recover，手动切换switch
      * @param {array} [opts.ids] - 监控项ID  optional
      * @param {string} [opts.switchTarget] - 监控项的主机值, 手动切换时必填  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  operateMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  operateMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling operateMonitor"
      )
    }
    if (opts.action === undefined || opts.action === null) {
      throw new Error(
        "Missing the required parameter 'opts.action' when calling operateMonitor"
      )
    }

    let postBody = {}
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }
    if (opts.switchTarget !== undefined && opts.switchTarget !== null) {
      postBody['switchTarget'] = opts.switchTarget
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operateMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorOperate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名的监控项修改
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {updateMonitor} opts.updateMonitor - 监控项设置信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling updateMonitor"
      )
    }
    if (opts.updateMonitor === undefined || opts.updateMonitor === null) {
      throw new Error(
        "Missing the required parameter 'opts.updateMonitor' when calling updateMonitor"
      )
    }

    let postBody = {}
    if (opts.updateMonitor !== undefined && opts.updateMonitor !== null) {
      postBody['updateMonitor'] = opts.updateMonitor
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorUpdate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  主域名的监控项的报警信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用getDomains接口获取。
      * @param {integer} [opts.pageIndex] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数  optional
      * @param {string} [opts.searchValue] - 关键字  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer currentCount  当前页面报警信息的个数
      * @param integer totalCount  所有报警信息的个数
      * @param integer totalPage  所有报警信息的页数
      * @param monitorAlarmInfo dataList
      */

  getMonitorAlarmInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getMonitorAlarmInfo"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getMonitorAlarmInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.searchValue !== undefined && opts.searchValue !== null) {
      queryParams['searchValue'] = opts.searchValue
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  clouddnsservice/1.0.12'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMonitorAlarmInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor/alarminfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.CLOUDDNSSERVICE
