/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Partner UserAuth Management
 * Partner UserAuth Management API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'cp'
Service._services[serviceId] = true

/**
 * cp service.
 * @version 0.2.5
 */

class CP extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'cp.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  createPartner
      * @param {Object} opts - parameters
      * @param {} [opts.pin] - 用户pin  optional
      * @param {} [opts.authProvider] - 实名认证类型  optional
      * @param {} [opts.roleName] - 角色名称  optional
      * @param {} [opts.policyNames] - 策略名称  optional
      * @param {} [opts.assumeRolePolicyDocument] - assumeRolePolicyDocument  optional
      * @param {} [opts.roleDescription] - 角色描述信息  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string pin  客户京东云账号的唯一标识
      * @param string partnerId  合作伙伴ID
      */

  createPartner (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.authProvider !== undefined && opts.authProvider !== null) {
      postBody['authProvider'] = opts.authProvider
    }
    if (opts.roleName !== undefined && opts.roleName !== null) {
      postBody['roleName'] = opts.roleName
    }
    if (opts.policyNames !== undefined && opts.policyNames !== null) {
      postBody['policyNames'] = opts.policyNames
    }
    if (
      opts.assumeRolePolicyDocument !== undefined &&
      opts.assumeRolePolicyDocument !== null
    ) {
      postBody['assumeRolePolicyDocument'] = opts.assumeRolePolicyDocument
    }
    if (opts.roleDescription !== undefined && opts.roleDescription !== null) {
      postBody['roleDescription'] = opts.roleDescription
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createPartner with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  usercpcheck
      * @param {Object} opts - parameters
      * @param {userCpCheckInfo} opts.userCpCheckInfo
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean check  true-存在关联关系，false-不存在关联关系
      * @param string userId  合作伙伴用户的userId
      */

  usercpcheck (opts, callback) {
    opts = opts || {}

    if (opts.userCpCheckInfo === undefined || opts.userCpCheckInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.userCpCheckInfo' when calling usercpcheck"
      )
    }

    let postBody = {}
    if (opts.userCpCheckInfo !== undefined && opts.userCpCheckInfo !== null) {
      postBody['userCpCheckInfo'] = opts.userCpCheckInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call usercpcheck with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/usercpcheck',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  setUserGrace
      * @param {Object} opts - parameters
      * @param {} [opts.pin] - 用户pin  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  true-设置成功， false-设置失败
      */

  setUserGrace (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setUserGrace with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/provider:graceSetting',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  getUserGrace
      * @param {Object} opts - parameters
      * @param {} [opts.pin] - 用户pin  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer periodResGraceDays  包周期宽限期天数
      * @param integer periodResRetentionDays  包周期资源保留期天数
      * @param integer onDemandResGraceDays  按需资源宽限期天数
      */

  getUserGrace (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getUserGrace with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/provider:graceInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  partnerToken
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {partnerToken} opts.partnerToken
      * @param {string} callback - callback
      @return {Object} result
      * @param string token  token
      * @param string tokenOriginResult  置换aksk所用token的原始数据
      * @param string partnerId  合作伙伴id
      * @param integer tokenType  1- 合作伙伴token 2-合作伙伴用户token
      * @param string expiresAt  token过期时间 示例 2022-06-24T12:09:58.888000Z, 响应参数为UTC时间格式，北京时间为UTC+8小时。如返回： 2020-01-08T02:56:19.587000Z  北京时间：2020-01-08 10:56:19.587
      * @param string issuedAt  token下发时间 示例 2022-06-24T12:09:58.888000Z, 响应参数为UTC时间格式，北京时间为UTC+8小时。如返回： 2020-01-08T02:56:19.587000Z  北京时间：2020-01-08 10:56:19.587
      */

  partnerToken (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling partnerToken"
      )
    }
    if (opts.partnerToken === undefined || opts.partnerToken === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerToken' when calling partnerToken"
      )
    }

    let postBody = {}
    if (opts.partnerToken !== undefined && opts.partnerToken !== null) {
      postBody['partnerToken'] = opts.partnerToken
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call partnerToken with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/token',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  partnerStsToken
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {partnerStsToken} opts.partnerStsToken
      * @param {string} callback - callback
      @return {Object} result
      * @param string access  AK
      * @param string secret  SK
      * @param string securitytoken  securitytoken是将所获的AK、SK等信息进行加密后的字符串。
      * @param string expiresAt  AK/SK和securitytoken的过期时间。响应参数为UTC时间格式，北京时间为UTC+8小时。如返回： 2020-01-08T02:56:19.587000Z  北京时间：2020-01-08 10:56:19.587
      * @param string issuedAt  token下发时间
      */

  partnerStsToken (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling partnerStsToken"
      )
    }
    if (opts.partnerStsToken === undefined || opts.partnerStsToken === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerStsToken' when calling partnerStsToken"
      )
    }

    let postBody = {}
    if (opts.partnerStsToken !== undefined && opts.partnerStsToken !== null) {
      postBody['partnerStsToken'] = opts.partnerStsToken
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call partnerStsToken with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/ststoken',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  checkUser
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {checkUserInfo} opts.checkUserInfo
      * @param {string} callback - callback
      @return {Object} result
      * @param integer status  0-该注册方式不存在，1-该注册方式已存在
      */

  checkUser (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling checkUser"
      )
    }
    if (opts.checkUserInfo === undefined || opts.checkUserInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.checkUserInfo' when calling checkUser"
      )
    }

    let postBody = {}
    if (opts.checkUserInfo !== undefined && opts.checkUserInfo !== null) {
      postBody['checkUserInfo'] = opts.checkUserInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/user:checkUserInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  sendVerificationCode
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {sendVerificationCodeInfo} opts.sendVerificationCodeInfo
      * @param {string} callback - callback
      @return {Object} result
      */

  sendVerificationCode (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling sendVerificationCode"
      )
    }
    if (
      opts.sendVerificationCodeInfo === undefined ||
      opts.sendVerificationCodeInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.sendVerificationCodeInfo' when calling sendVerificationCode"
      )
    }

    let postBody = {}
    if (
      opts.sendVerificationCodeInfo !== undefined &&
      opts.sendVerificationCodeInfo !== null
    ) {
      postBody['sendVerificationCodeInfo'] = opts.sendVerificationCodeInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendVerificationCode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/user:sendVerificationCode',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  createUser
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {createUserInfo} opts.createUserInfo
      * @param {string} callback - callback
      @return {Object} result
      * @param string pin  客户京东云账号的唯一标识
      * @param string userId  第三方系统的用户唯一标识，该标识的具体值由伙伴分配。
      * @param string roleJrn  客户授权给合作伙伴使用的角色标识（Role&#39;s JDCloud Resource Name)，合作伙伴可以代入此角色，执行角色权限范围内的用户资源操作
      * @param string accessKey  用户的accessKey
      * @param string secretkey  用户secretKey
      */

  createUser (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling createUser"
      )
    }
    if (opts.createUserInfo === undefined || opts.createUserInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.createUserInfo' when calling createUser"
      )
    }

    let postBody = {}
    if (opts.createUserInfo !== undefined && opts.createUserInfo !== null) {
      postBody['createUserInfo'] = opts.createUserInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/user:createUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询合作伙伴下的用户列表
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} [opts.mobilePhone] - 用户用手机注册时的手机号，手机号包括国家码，以00开头，格式：00XX-XXXXXXXX。  optional
      * @param {string} [opts.email] - 用户用邮箱注册时的邮箱  optional
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} [opts.cooperationStartTime] - 按关联时间查询时，起始UTC时间。格式为：yyyy-MM-dd&#39;T&#39;HH:mm:ss。  optional
      * @param {string} [opts.cooperationEndTime] - 按关联时间查询时，截止UTC时间。格式为：yyyy-MM-dd&#39;T&#39;HH:mm:ss。  optional
      * @param {integer} [opts.status] - 按用户状态查询，0-全部(默认)，1-正常，-1-禁用  optional
      * @param {integer} [opts.sort] - 排序规则：0-关联时间倒序排序(默认)，1-关联时间顺序排序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总用户数
      * @param partnerUserInfo users
      */

  listPartnerUsers (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling listPartnerUsers"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }
    if (opts.mobilePhone !== undefined && opts.mobilePhone !== null) {
      queryParams['mobilePhone'] = opts.mobilePhone
    }
    if (opts.email !== undefined && opts.email !== null) {
      queryParams['email'] = opts.email
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (
      opts.cooperationStartTime !== undefined &&
      opts.cooperationStartTime !== null
    ) {
      queryParams['cooperationStartTime'] = opts.cooperationStartTime
    }
    if (
      opts.cooperationEndTime !== undefined &&
      opts.cooperationEndTime !== null
    ) {
      queryParams['cooperationEndTime'] = opts.cooperationEndTime
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listPartnerUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/users',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  合作伙伴添加用户实名
      * @param {Object} opts - parameters
      * @param {string} opts.partnerId - 合作伙伴ID
      * @param {string} opts.userId - 合作伙伴用户ID
      * @param {userAuthInfo} opts.userAuthInfo
      * @param {string} callback - callback
      @return {Object} result
      */

  createUserAuth (opts, callback) {
    opts = opts || {}

    if (opts.partnerId === undefined || opts.partnerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.partnerId' when calling createUserAuth"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling createUserAuth"
      )
    }
    if (opts.userAuthInfo === undefined || opts.userAuthInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.userAuthInfo' when calling createUserAuth"
      )
    }

    let postBody = {}
    if (opts.userAuthInfo !== undefined && opts.userAuthInfo !== null) {
      postBody['userAuthInfo'] = opts.userAuthInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      partnerId: opts.partnerId,
      userId: opts.userId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  cp/0.2.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUserAuth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/partner/{partnerId}/user/{userId}:createUserAuth',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = CP
