/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 大屏数据查询接口
 * 陕西苹果大屏数据查询接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'datastar'
Service._services[serviceId] = true

/**
 * datastar service.
 * @version 1.0.6
 */

JDCloud.DATASTAR = class DATASTAR extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'datastar.cn-south-1.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  根据区域、行业、一级指标、二级指标、起始时间等条件查询数据
      * @param {Object} opts - parameters
      * @param {string} opts.region - 查询区域，比如某某省或某某市（可选区域以最终授权为准）
      * @param {string} opts.industry - 查询行业，比如某个水果或者农作物（可选行业以最终授权为准）
      * @param {string} opts.startDate - 查询起始时间，格式如下：yyyy-MM-dd
      * @param {string} opts.endDate - 查询结束时间，格式如下：yyyy-MM-dd
      * @param {string} opts.firstIndex - 数据对应的第一级分析指标（可选一级指标以最终授权为准）
      * @param {string} [opts.secondIndex] - 数据对应的第二级分析指标，如不填写，则默认把一级指标下的所有二级指标都查询出来（可选二级指标以最终授权为准）  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status  true为成功，false为失败
      * @param string message  描述信息
      * @param regionIndustryDataList data  查询数据结果
      */

  getLargeScreenData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getLargeScreenData"
      )
    }

    opts = opts || {}

    if (opts.region === undefined || opts.region === null) {
      throw new Error(
        "Missing the required parameter 'opts.region' when calling getLargeScreenData"
      )
    }
    if (opts.industry === undefined || opts.industry === null) {
      throw new Error(
        "Missing the required parameter 'opts.industry' when calling getLargeScreenData"
      )
    }
    if (opts.startDate === undefined || opts.startDate === null) {
      throw new Error(
        "Missing the required parameter 'opts.startDate' when calling getLargeScreenData"
      )
    }
    if (opts.endDate === undefined || opts.endDate === null) {
      throw new Error(
        "Missing the required parameter 'opts.endDate' when calling getLargeScreenData"
      )
    }
    if (opts.firstIndex === undefined || opts.firstIndex === null) {
      throw new Error(
        "Missing the required parameter 'opts.firstIndex' when calling getLargeScreenData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.region !== undefined && opts.region !== null) {
      queryParams['region'] = opts.region
    }
    if (opts.industry !== undefined && opts.industry !== null) {
      queryParams['industry'] = opts.industry
    }
    if (opts.startDate !== undefined && opts.startDate !== null) {
      queryParams['startDate'] = opts.startDate
    }
    if (opts.endDate !== undefined && opts.endDate !== null) {
      queryParams['endDate'] = opts.endDate
    }
    if (opts.firstIndex !== undefined && opts.firstIndex !== null) {
      queryParams['firstIndex'] = opts.firstIndex
    }
    if (opts.secondIndex !== undefined && opts.secondIndex !== null) {
      queryParams['secondIndex'] = opts.secondIndex
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  datastar/1.0.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getLargeScreenData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/largeScreen/getData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.DATASTAR
