/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 数据库备份服务
 * 数据库备份服务接口
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'dbs'
Service._services[serviceId] = true

/**
 * dbs service.
 * @version 2.0.0
 */

class DBS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'dbs.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  Agent 注册接口
      * @param {Object} opts - parameters
      * @param {string} [opts.ip] - agent的IP  optional
      * @param {string} opts.mac - agent的 MAC
      * @param {string} [opts.hostname] - agent的hostname  optional
      * @param {string} opts.stat - agent的状态
      * @param {string} [opts.ver] - agent的版本号  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string createTime
      * @param string hostname
      * @param string id
      * @param string ip  agent取到的出口ip
      * @param string lastActiveTime  上次心跳汇报时间
      * @param string name  用户自定义别名
      * @param string stat  状态:idle,offline,deleted,executing
      * @param string updateTime
      * @param string version  版本号
      */

  agentRegister (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  agentRegister"
      )
    }

    opts = opts || {}

    if (opts.mac === undefined || opts.mac === null) {
      throw new Error(
        "Missing the required parameter 'opts.mac' when calling agentRegister"
      )
    }
    if (opts.stat === undefined || opts.stat === null) {
      throw new Error(
        "Missing the required parameter 'opts.stat' when calling agentRegister"
      )
    }

    let postBody = {}
    if (opts.ip !== undefined && opts.ip !== null) {
      postBody['ip'] = opts.ip
    }
    if (opts.mac !== undefined && opts.mac !== null) {
      postBody['mac'] = opts.mac
    }
    if (opts.hostname !== undefined && opts.hostname !== null) {
      postBody['hostname'] = opts.hostname
    }
    if (opts.stat !== undefined && opts.stat !== null) {
      postBody['stat'] = opts.stat
    }
    if (opts.ver !== undefined && opts.ver !== null) {
      postBody['ver'] = opts.ver
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call agentRegister with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/agent',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取agent的任务
      * @param {Object} opts - parameters
      * @param {string} opts.agentId - Agent ID
      * @param {string} [opts.stat] - agent的状态  optional
      * @param {string} opts.mac - agent的MAC地址
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param agentTasks tasks
      */

  agentTasks (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  agentTasks"
      )
    }

    opts = opts || {}

    if (opts.agentId === undefined || opts.agentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.agentId' when calling agentTasks"
      )
    }
    if (opts.mac === undefined || opts.mac === null) {
      throw new Error(
        "Missing the required parameter 'opts.mac' when calling agentTasks"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.stat !== undefined && opts.stat !== null) {
      queryParams['stat'] = opts.stat
    }
    if (opts.mac !== undefined && opts.mac !== null) {
      queryParams['mac'] = opts.mac
    }

    let pathParams = {
      regionId: regionId,
      agentId: opts.agentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call agentTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/manage/{agentId}/tasks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取agent的备份计划
      * @param {Object} opts - parameters
      * @param {string} opts.agentId - Agent ID
      * @param {string} opts.mac - agent的MAC地址
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param agentPlan plans
      */

  agentPlans (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  agentPlans"
      )
    }

    opts = opts || {}

    if (opts.agentId === undefined || opts.agentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.agentId' when calling agentPlans"
      )
    }
    if (opts.mac === undefined || opts.mac === null) {
      throw new Error(
        "Missing the required parameter 'opts.mac' when calling agentPlans"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.mac !== undefined && opts.mac !== null) {
      queryParams['mac'] = opts.mac
    }

    let pathParams = {
      regionId: regionId,
      agentId: opts.agentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call agentPlans with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/manage/{agentId}/plans',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上报任务的状态
      * @param {Object} opts - parameters
      * @param {object} opts.agent
      * @param {string} opts.taskType
      * @param {string} [opts.planId]   optional
      * @param {integer} opts.progress
      * @param {string} [opts.startTime]   optional
      * @param {string} [opts.endTime]   optional
      * @param {boolean} [opts.success]   optional
      * @param {string} [opts.errorMessage]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string id
      */

  reportTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  reportTask"
      )
    }

    opts = opts || {}

    if (opts.agent === undefined || opts.agent === null) {
      throw new Error(
        "Missing the required parameter 'opts.agent' when calling reportTask"
      )
    }
    if (opts.taskType === undefined || opts.taskType === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskType' when calling reportTask"
      )
    }
    if (opts.progress === undefined || opts.progress === null) {
      throw new Error(
        "Missing the required parameter 'opts.progress' when calling reportTask"
      )
    }

    let postBody = {}
    if (opts.agent !== undefined && opts.agent !== null) {
      postBody['agent'] = opts.agent
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.planId !== undefined && opts.planId !== null) {
      postBody['planId'] = opts.planId
    }
    if (opts.progress !== undefined && opts.progress !== null) {
      postBody['progress'] = opts.progress
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.success !== undefined && opts.success !== null) {
      postBody['success'] = opts.success
    }
    if (opts.errorMessage !== undefined && opts.errorMessage !== null) {
      postBody['errorMessage'] = opts.errorMessage
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call reportTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/task',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改任务状态
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - Task ID
      * @param {integer} opts.progress
      * @param {string} [opts.startTime]   optional
      * @param {string} [opts.endTime]   optional
      * @param {boolean} opts.success
      * @param {string} [opts.errorMessage]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean ok
      */

  modifyTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling modifyTask"
      )
    }
    if (opts.progress === undefined || opts.progress === null) {
      throw new Error(
        "Missing the required parameter 'opts.progress' when calling modifyTask"
      )
    }
    if (opts.success === undefined || opts.success === null) {
      throw new Error(
        "Missing the required parameter 'opts.success' when calling modifyTask"
      )
    }

    let postBody = {}
    if (opts.progress !== undefined && opts.progress !== null) {
      postBody['progress'] = opts.progress
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.success !== undefined && opts.success !== null) {
      postBody['success'] = opts.success
    }
    if (opts.errorMessage !== undefined && opts.errorMessage !== null) {
      postBody['errorMessage'] = opts.errorMessage
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/task/{taskId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上传备份文件信息
      * @param {Object} opts - parameters
      * @param {string} opts.planId
      * @param {string} opts.backupType
      * @param {string} opts.dataSourceId
      * @param {integer} opts.isManual - 0代表自动备份 1代表的是手动触发备份
      * @param {string} opts.filename
      * @param {string} opts.extInfo
      * @param {string} opts.path
      * @param {integer} opts.size
      * @param {integer} [opts.srcSize]   optional
      * @param {string} opts.storageType
      * @param {string} opts.taskId
      * @param {string} [opts.binlogStartTime]   optional
      * @param {string} [opts.binlogEndTime]   optional
      * @param {integer} [opts.binlogStartPos]   optional
      * @param {integer} [opts.binlogEndPos]   optional
      * @param {string} [opts.version]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string id
      */

  backupFile (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  backupFile"
      )
    }

    opts = opts || {}

    if (opts.planId === undefined || opts.planId === null) {
      throw new Error(
        "Missing the required parameter 'opts.planId' when calling backupFile"
      )
    }
    if (opts.backupType === undefined || opts.backupType === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupType' when calling backupFile"
      )
    }
    if (opts.dataSourceId === undefined || opts.dataSourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.dataSourceId' when calling backupFile"
      )
    }
    if (opts.isManual === undefined || opts.isManual === null) {
      throw new Error(
        "Missing the required parameter 'opts.isManual' when calling backupFile"
      )
    }
    if (opts.filename === undefined || opts.filename === null) {
      throw new Error(
        "Missing the required parameter 'opts.filename' when calling backupFile"
      )
    }
    if (opts.extInfo === undefined || opts.extInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.extInfo' when calling backupFile"
      )
    }
    if (opts.path === undefined || opts.path === null) {
      throw new Error(
        "Missing the required parameter 'opts.path' when calling backupFile"
      )
    }
    if (opts.size === undefined || opts.size === null) {
      throw new Error(
        "Missing the required parameter 'opts.size' when calling backupFile"
      )
    }
    if (opts.storageType === undefined || opts.storageType === null) {
      throw new Error(
        "Missing the required parameter 'opts.storageType' when calling backupFile"
      )
    }
    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling backupFile"
      )
    }

    let postBody = {}
    if (opts.planId !== undefined && opts.planId !== null) {
      postBody['planId'] = opts.planId
    }
    if (opts.backupType !== undefined && opts.backupType !== null) {
      postBody['backupType'] = opts.backupType
    }
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.isManual !== undefined && opts.isManual !== null) {
      postBody['isManual'] = opts.isManual
    }
    if (opts.filename !== undefined && opts.filename !== null) {
      postBody['filename'] = opts.filename
    }
    if (opts.extInfo !== undefined && opts.extInfo !== null) {
      postBody['extInfo'] = opts.extInfo
    }
    if (opts.path !== undefined && opts.path !== null) {
      postBody['path'] = opts.path
    }
    if (opts.size !== undefined && opts.size !== null) {
      postBody['size'] = opts.size
    }
    if (opts.srcSize !== undefined && opts.srcSize !== null) {
      postBody['srcSize'] = opts.srcSize
    }
    if (opts.storageType !== undefined && opts.storageType !== null) {
      postBody['storageType'] = opts.storageType
    }
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.binlogStartTime !== undefined && opts.binlogStartTime !== null) {
      postBody['binlogStartTime'] = opts.binlogStartTime
    }
    if (opts.binlogEndTime !== undefined && opts.binlogEndTime !== null) {
      postBody['binlogEndTime'] = opts.binlogEndTime
    }
    if (opts.binlogStartPos !== undefined && opts.binlogStartPos !== null) {
      postBody['binlogStartPos'] = opts.binlogStartPos
    }
    if (opts.binlogEndPos !== undefined && opts.binlogEndPos !== null) {
      postBody['binlogEndPos'] = opts.binlogEndPos
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call backupFile with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupFile',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上报预检查结果
      * @param {Object} opts - parameters
      * @param {object} opts.plan
      * @param {string} opts.checkItem - 预检查任务项
      * @param {boolean} opts.success - 是否成功
      * @param {string} [opts.errorMessages] - 错误信息，仅sucess为false时返回  optional
      * @param {string} opts.startTime
      * @param {string} opts.endTime
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string jobId
      */

  reportPrecheck (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  reportPrecheck"
      )
    }

    opts = opts || {}

    if (opts.plan === undefined || opts.plan === null) {
      throw new Error(
        "Missing the required parameter 'opts.plan' when calling reportPrecheck"
      )
    }
    if (opts.checkItem === undefined || opts.checkItem === null) {
      throw new Error(
        "Missing the required parameter 'opts.checkItem' when calling reportPrecheck"
      )
    }
    if (opts.success === undefined || opts.success === null) {
      throw new Error(
        "Missing the required parameter 'opts.success' when calling reportPrecheck"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling reportPrecheck"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling reportPrecheck"
      )
    }

    let postBody = {}
    if (opts.plan !== undefined && opts.plan !== null) {
      postBody['plan'] = opts.plan
    }
    if (opts.checkItem !== undefined && opts.checkItem !== null) {
      postBody['checkItem'] = opts.checkItem
    }
    if (opts.success !== undefined && opts.success !== null) {
      postBody['success'] = opts.success
    }
    if (opts.errorMessages !== undefined && opts.errorMessages !== null) {
      postBody['errorMessages'] = opts.errorMessages
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call reportPrecheck with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/precheckPlan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询已经注册的所有的 DBS agent
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {filter} [opts.filters] - 过滤参数，多个过滤参数之间的关系为“与”(and)
支持以下属性的过滤：
hostName, 支持operator选项：eq, like
hostIP, 支持operator选项：eq, like
  optional
      * @param {sort} [opts.sorts] - 排序参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param agent dbsAgents
      */

  describeAgents (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAgents"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAgents with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/agents',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询 agent 详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.agentId - Agent ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param agentAttributes agentAttributes
      */

  describeAgentAttributes (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAgentAttributes"
      )
    }

    opts = opts || {}

    if (opts.agentId === undefined || opts.agentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.agentId' when calling describeAgentAttributes"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      agentId: opts.agentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAgentAttributes with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/agents/{agentId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询备份计划概要
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {filter} [opts.filters] - 过滤参数，多个过滤参数之间的关系为“与”(and)
支持以下属性的过滤：
instanceId, 支持operator选项：eq
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param backupPlan backupPlans
      */

  describeBackupPlans (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackupPlans"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackupPlans with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建备份计划
      * @param {Object} opts - parameters
      * @param {string} opts.name - 备份计划名称，支持中文、数字、大小写字母、英文下划线“_”、减号“-”，且不少于2字符不超过64字符
      * @param {string} opts.servicePackage - DBS服务包类型是枚举值， dbs.common.package 表示基础服务包，不含备份流量
      * @param {chargeSpec} opts.chargeSpec - 购买规格
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId
      * @param string orderNubmer
      * @param string backupPlanId
      */

  createBackupPlan (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBackupPlan"
      )
    }

    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createBackupPlan"
      )
    }
    if (opts.servicePackage === undefined || opts.servicePackage === null) {
      throw new Error(
        "Missing the required parameter 'opts.servicePackage' when calling createBackupPlan"
      )
    }
    if (opts.chargeSpec === undefined || opts.chargeSpec === null) {
      throw new Error(
        "Missing the required parameter 'opts.chargeSpec' when calling createBackupPlan"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.servicePackage !== undefined && opts.servicePackage !== null) {
      postBody['servicePackage'] = opts.servicePackage
    }
    if (opts.chargeSpec !== undefined && opts.chargeSpec !== null) {
      postBody['chargeSpec'] = opts.chargeSpec
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBackupPlan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询备份计划详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backupPlanAttributes backupPlanAttributes
      */

  describeBackupPlanAttributes (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackupPlanAttributes"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describeBackupPlanAttributes"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackupPlanAttributes with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除备份计划
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteBackupPlan (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteBackupPlan"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling deleteBackupPlan"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteBackupPlan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询预检查任务详情
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string status  预检查任务状态
      * @param integer progress  预检查任务进度
      * @param precheckPlan preCheckDetails
      */

  describePreCheck (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePreCheck"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describePreCheck"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePreCheck with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:describePreCheck',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  初始化备份策略
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.sourceEngine - 引擎类型 MySQL5  MySQL8  MariaDB  Percona
      * @param {string} opts.backupType - 备份方式，支持物理备份或逻辑备份
      * @param {boolean} [opts.enableBackupLogs] - 是否开启日志备份；true：开启；false：关闭  optional
      * @param {integer} [opts.logBackupRetentionPeriod] - 日志备份保存天数，支持7-3650 天，默认7天  optional
      * @param {integer} [opts.fullBackupRetentionPeriod] - 全量备份保存天数，支持7-3650 天，默认7天  optional
      * @param {backupSchedule} opts.fullBackupSchedule - 全量备份的备份周期
      * @param {sourceEndpoint} opts.sourceEndpoint - 备份目标的详细信息
      * @param {backupObjects} [opts.backupObjects] - 逻辑备份中要备份的对象的信息，物理备份无须该信息  optional
      * @param {boolean} opts.createNewEndpoint - 是否开启日志备份；true：开启；false：关闭
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  initBackupPlan (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  initBackupPlan"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling initBackupPlan"
      )
    }
    if (opts.sourceEngine === undefined || opts.sourceEngine === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceEngine' when calling initBackupPlan"
      )
    }
    if (opts.backupType === undefined || opts.backupType === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupType' when calling initBackupPlan"
      )
    }
    if (
      opts.fullBackupSchedule === undefined ||
      opts.fullBackupSchedule === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.fullBackupSchedule' when calling initBackupPlan"
      )
    }
    if (opts.sourceEndpoint === undefined || opts.sourceEndpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceEndpoint' when calling initBackupPlan"
      )
    }
    if (
      opts.createNewEndpoint === undefined ||
      opts.createNewEndpoint === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createNewEndpoint' when calling initBackupPlan"
      )
    }

    let postBody = {}
    if (opts.sourceEngine !== undefined && opts.sourceEngine !== null) {
      postBody['sourceEngine'] = opts.sourceEngine
    }
    if (opts.backupType !== undefined && opts.backupType !== null) {
      postBody['backupType'] = opts.backupType
    }
    if (opts.enableBackupLogs !== undefined && opts.enableBackupLogs !== null) {
      postBody['enableBackupLogs'] = opts.enableBackupLogs
    }
    if (
      opts.logBackupRetentionPeriod !== undefined &&
      opts.logBackupRetentionPeriod !== null
    ) {
      postBody['logBackupRetentionPeriod'] = opts.logBackupRetentionPeriod
    }
    if (
      opts.fullBackupRetentionPeriod !== undefined &&
      opts.fullBackupRetentionPeriod !== null
    ) {
      postBody['fullBackupRetentionPeriod'] = opts.fullBackupRetentionPeriod
    }
    if (
      opts.fullBackupSchedule !== undefined &&
      opts.fullBackupSchedule !== null
    ) {
      postBody['fullBackupSchedule'] = opts.fullBackupSchedule
    }
    if (opts.sourceEndpoint !== undefined && opts.sourceEndpoint !== null) {
      postBody['sourceEndpoint'] = opts.sourceEndpoint
    }
    if (opts.backupObjects !== undefined && opts.backupObjects !== null) {
      postBody['backupObjects'] = opts.backupObjects
    }
    if (
      opts.createNewEndpoint !== undefined &&
      opts.createNewEndpoint !== null
    ) {
      postBody['createNewEndpoint'] = opts.createNewEndpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call initBackupPlan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:initBackupPlan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  手动触发逻辑备份
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createLogicalBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createLogicalBackup"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling createLogicalBackup"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLogicalBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:createLogicalBackup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  手动触发物理备份
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createPhysicalBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createPhysicalBackup"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling createPhysicalBackup"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createPhysicalBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:createPhysicalBackup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询所有的binlog备份结果
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param binlogBackup binlogBackups
      */

  describeBinlogBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBinlogBackups"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describeBinlogBackups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBinlogBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:describeBinlogBackups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询所有的逻辑备份结果
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param logicalBackups logicalBackups
      */

  describeLogicalBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeLogicalBackups"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describeLogicalBackups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLogicalBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:describeLogicalBackups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询所有的物理备份结果
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param physicalBackups physicalBackups
      */

  describePhysicalBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePhysicalBackups"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describePhysicalBackups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePhysicalBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:describePhysicalBackups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取超过保留时长即需要删除的备份文件
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.backupType - 备份的类型
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param shouldDelBackups shouldDelBackups
      */

  getShouldDelBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getShouldDelBackups"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling getShouldDelBackups"
      )
    }
    if (opts.backupType === undefined || opts.backupType === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupType' when calling getShouldDelBackups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.backupType !== undefined && opts.backupType !== null) {
      queryParams['backupType'] = opts.backupType
    }

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getShouldDelBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:shouldDelBackups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置超过保留时长的备份文件的状态为已删除
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} [opts.backupType]   optional
      * @param {integer} [opts.totalCount]   optional
      * @param {array} [opts.backupFiles]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean ok
      */

  updateShouldDelBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateShouldDelBackups"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling updateShouldDelBackups"
      )
    }

    let postBody = {}
    if (opts.backupType !== undefined && opts.backupType !== null) {
      postBody['backupType'] = opts.backupType
    }
    if (opts.totalCount !== undefined && opts.totalCount !== null) {
      postBody['totalCount'] = opts.totalCount
    }
    if (opts.backupFiles !== undefined && opts.backupFiles !== null) {
      postBody['backupFiles'] = opts.backupFiles
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateShouldDelBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:shouldDelBackups',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取该备份计划最近备份成功的 binlog 文件
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backupBriefInfo lastBackupBinlog
      */

  getLastBackupBinlog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getLastBackupBinlog"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling getLastBackupBinlog"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getLastBackupBinlog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:getLastBackupBinlog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询当前备份计划下最近1年的恢复任务，按创建任务时间倒序排列
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {integer} [opts.pageNumber] - 显示数据的页码，默认为1，取值范围：[-1,∞)。pageNumber为-1时，返回所有数据页码；超过总页数时，显示最后一页  optional
      * @param {integer} [opts.pageSize] - 每页显示的数据条数，默认为10，取值范围：[10,100]，且为10的整数倍  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount
      * @param restoreTask restoreTasks
      */

  describeRestoreTasks (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeRestoreTasks"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling describeRestoreTasks"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRestoreTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:describeRestoreTasks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据逻辑备份进行全量恢复
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.backupId - 用于恢复的备份Id，仅限于本备份计划生成的备份
      * @param {restoreSourceEndpoint} opts.sourceEndpoint - 备份实例的数据源信息
      * @param {boolean} opts.createNewEndpoint - 是否是新建数据源；true：是；false：不是
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restoreLogicalBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restoreLogicalBackup"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling restoreLogicalBackup"
      )
    }
    if (opts.backupId === undefined || opts.backupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupId' when calling restoreLogicalBackup"
      )
    }
    if (opts.sourceEndpoint === undefined || opts.sourceEndpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceEndpoint' when calling restoreLogicalBackup"
      )
    }
    if (
      opts.createNewEndpoint === undefined ||
      opts.createNewEndpoint === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createNewEndpoint' when calling restoreLogicalBackup"
      )
    }

    let postBody = {}
    if (opts.backupId !== undefined && opts.backupId !== null) {
      postBody['backupId'] = opts.backupId
    }
    if (opts.sourceEndpoint !== undefined && opts.sourceEndpoint !== null) {
      postBody['sourceEndpoint'] = opts.sourceEndpoint
    }
    if (
      opts.createNewEndpoint !== undefined &&
      opts.createNewEndpoint !== null
    ) {
      postBody['createNewEndpoint'] = opts.createNewEndpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restoreLogicalBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:restoreLogicalBackup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据物理备份进行全量恢复
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.backupId - 用于恢复的备份Id，仅限于本备份计划生成的备份
      * @param {restoreSourceEndpoint} opts.sourceEndpoint - 备份实例的数据源信息
      * @param {boolean} opts.createNewEndpoint - 是否是新建数据源；true：是；false：不是
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restorePhysicalBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restorePhysicalBackup"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling restorePhysicalBackup"
      )
    }
    if (opts.backupId === undefined || opts.backupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupId' when calling restorePhysicalBackup"
      )
    }
    if (opts.sourceEndpoint === undefined || opts.sourceEndpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceEndpoint' when calling restorePhysicalBackup"
      )
    }
    if (
      opts.createNewEndpoint === undefined ||
      opts.createNewEndpoint === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createNewEndpoint' when calling restorePhysicalBackup"
      )
    }

    let postBody = {}
    if (opts.backupId !== undefined && opts.backupId !== null) {
      postBody['backupId'] = opts.backupId
    }
    if (opts.sourceEndpoint !== undefined && opts.sourceEndpoint !== null) {
      postBody['sourceEndpoint'] = opts.sourceEndpoint
    }
    if (
      opts.createNewEndpoint !== undefined &&
      opts.createNewEndpoint !== null
    ) {
      postBody['createNewEndpoint'] = opts.createNewEndpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restorePhysicalBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:restorePhysicalBackup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  将数据库实例根据物理备份和binlog备份恢复到指定的时间点。
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.restoreTime - 数据库实例要恢复到的时间点，UTC时间格式：YYYY-MM-DDTHH:mm:ssZ
      * @param {restoreSourceEndpoint} opts.sourceEndpoint - 备份实例的数据源信息
      * @param {boolean} opts.createNewEndpoint - 是否是新建数据源；true：是；false：不是
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restoreToTime (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restoreToTime"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling restoreToTime"
      )
    }
    if (opts.restoreTime === undefined || opts.restoreTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.restoreTime' when calling restoreToTime"
      )
    }
    if (opts.sourceEndpoint === undefined || opts.sourceEndpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceEndpoint' when calling restoreToTime"
      )
    }
    if (
      opts.createNewEndpoint === undefined ||
      opts.createNewEndpoint === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createNewEndpoint' when calling restoreToTime"
      )
    }

    let postBody = {}
    if (opts.restoreTime !== undefined && opts.restoreTime !== null) {
      postBody['restoreTime'] = opts.restoreTime
    }
    if (opts.sourceEndpoint !== undefined && opts.sourceEndpoint !== null) {
      postBody['sourceEndpoint'] = opts.sourceEndpoint
    }
    if (
      opts.createNewEndpoint !== undefined &&
      opts.createNewEndpoint !== null
    ) {
      postBody['createNewEndpoint'] = opts.createNewEndpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restoreToTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:restoreToTime',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除手动触发生成的备份文件
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} opts.backupId - 备份文件ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteBackup"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling deleteBackup"
      )
    }
    if (opts.backupId === undefined || opts.backupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupId' when calling deleteBackup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId,
      backupId: opts.backupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}/backup/{backupId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改备份策略之逻辑备份的库表
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} [opts.database] - 数据库名称  optional
      * @param {array} [opts.objects] - 表名, 如果不填或者为空，表示对整个数据库进行备份  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyBackupObjects (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyBackupObjects"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling modifyBackupObjects"
      )
    }

    let postBody = {}
    if (opts.database !== undefined && opts.database !== null) {
      postBody['database'] = opts.database
    }
    if (opts.objects !== undefined && opts.objects !== null) {
      postBody['objects'] = opts.objects
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyBackupObjects with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:modifyBackupObjects',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改备份策略
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} [opts.fullBackupPeriod] - 周期类型，目前仅支持weekly  optional
      * @param {array} [opts.fullBackupDays] - 进行全量备份的日期, 备份周期为 weekly 时可以取 0-6 分别对应的是周日到周六  optional
      * @param {string} [opts.fullBackupStartTime] - 全量备份的开始时间，精确到分,UTC时间格式，例如：23:30Z  optional
      * @param {integer} [opts.fullBackupRetentionPeriod] - 全量备份保存天数，支持7-3650 天，默认7天  optional
      * @param {integer} [opts.logBackupRetentionPeriod] - 日志备份保存天数，支持7-3650 天，默认7天  optional
      * @param {boolean} [opts.enableBackupLogs] - 是否开启日志备份；true：开启；false：关闭  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyBackupPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyBackupPolicy"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling modifyBackupPolicy"
      )
    }

    let postBody = {}
    if (opts.fullBackupPeriod !== undefined && opts.fullBackupPeriod !== null) {
      postBody['fullBackupPeriod'] = opts.fullBackupPeriod
    }
    if (opts.fullBackupDays !== undefined && opts.fullBackupDays !== null) {
      postBody['fullBackupDays'] = opts.fullBackupDays
    }
    if (
      opts.fullBackupStartTime !== undefined &&
      opts.fullBackupStartTime !== null
    ) {
      postBody['fullBackupStartTime'] = opts.fullBackupStartTime
    }
    if (
      opts.fullBackupRetentionPeriod !== undefined &&
      opts.fullBackupRetentionPeriod !== null
    ) {
      postBody['fullBackupRetentionPeriod'] = opts.fullBackupRetentionPeriod
    }
    if (
      opts.logBackupRetentionPeriod !== undefined &&
      opts.logBackupRetentionPeriod !== null
    ) {
      postBody['logBackupRetentionPeriod'] = opts.logBackupRetentionPeriod
    }
    if (opts.enableBackupLogs !== undefined && opts.enableBackupLogs !== null) {
      postBody['enableBackupLogs'] = opts.enableBackupLogs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyBackupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:modifyBackupPolicy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改备份策略之数据源的账号密码等
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} [opts.accountName] - 源数据库的账号  optional
      * @param {string} [opts.password] - 源数据库的密码  optional
      * @param {engineRelatedConfig} [opts.engineRelatedConfig] - 不同数据库引擎独有的配置参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifySourceEndpoint (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifySourceEndpoint"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling modifySourceEndpoint"
      )
    }

    let postBody = {}
    if (opts.accountName !== undefined && opts.accountName !== null) {
      postBody['accountName'] = opts.accountName
    }
    if (opts.password !== undefined && opts.password !== null) {
      postBody['password'] = opts.password
    }
    if (
      opts.engineRelatedConfig !== undefined &&
      opts.engineRelatedConfig !== null
    ) {
      postBody['engineRelatedConfig'] = opts.engineRelatedConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySourceEndpoint with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:modifySourceEndpoint',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动备份计划
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  startBackupPlan (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  startBackupPlan"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling startBackupPlan"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startBackupPlan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:startBackupPlan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止备份计划
      * @param {Object} opts - parameters
      * @param {string} opts.backupPlanId - 备份计划ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  stopBackupPlan (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  stopBackupPlan"
      )
    }

    opts = opts || {}

    if (opts.backupPlanId === undefined || opts.backupPlanId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPlanId' when calling stopBackupPlan"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backupPlanId: opts.backupPlanId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dbs/2.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopBackupPlan with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backupPlans/{backupPlanId}:stopBackupPlan',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = DBS
