/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SiteMonitor APIs
 * 站点监控相关接口，提供创建、查询、修改、删除站点监控等功能
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'detection'
Service._services[serviceId] = true

/**
 * detection service.
 * @version 2.0.1
 */

JDCloud.DETECTION = class DETECTION extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'detection.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询可用性监控agent状态
      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - agent id列表
uuid - agent id，精确匹配，支持多个  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param agentStatus items
      */

  describeAgentStatus (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAgentStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/amAgentStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看可用性监控任务的监控数据
      * @param {Object} opts - parameters
      * @param {string} opts.resourceId - 资源的uuid
      * @param {string} [opts.startTime] - 查询时间范围的开始时间， UTC时间，格式：2016-12-11T00:00:00+0800（早于30d时，将被重置为30d）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）  optional
      * @param {string} [opts.endTime] - 查询时间范围的结束时间， UTC时间，格式：2016-12-11T00:00:00+0800（为空时，将由startTime与timeInterval计算得出）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）  optional
      * @param {string} [opts.timeInterval] - 时间间隔：1h，6h，12h，1d，3d，7d，14d，固定时间间隔，timeInterval 与 endTime 至少填一项  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param metricData metricDatas
      */

  describeMetricDataAm (opts, callback) {
    opts = opts || {}

    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeMetricDataAm"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.timeInterval !== undefined && opts.timeInterval !== null) {
      queryParams['timeInterval'] = opts.timeInterval
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMetricDataAm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/amMetricData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建可用性监控任务
      * @param {Object} opts - parameters
      * @param {string} opts.clientToken - 幂等性校验参数,最长36位
      * @param {createProbeTaskParam} opts.createProbeTaskSpec
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc  是否创建成功
      * @param string taskId  创建成功的规则id列表
      */

  createProbeTask (opts, callback) {
    opts = opts || {}

    if (opts.clientToken === undefined || opts.clientToken === null) {
      throw new Error(
        "Missing the required parameter 'opts.clientToken' when calling createProbeTask"
      )
    }
    if (
      opts.createProbeTaskSpec === undefined ||
      opts.createProbeTaskSpec === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createProbeTaskSpec' when calling createProbeTask"
      )
    }

    let postBody = {}
    if (opts.clientToken !== undefined && opts.clientToken !== null) {
      postBody['clientToken'] = opts.clientToken
    }
    if (
      opts.createProbeTaskSpec !== undefined &&
      opts.createProbeTaskSpec !== null
    ) {
      postBody['createProbeTaskSpec'] = opts.createProbeTaskSpec
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createProbeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除可用性监控任务
      * @param {Object} opts - parameters
      * @param {string} opts.probeTaskIDs - 探测任务的task_id,多个taskId用|分隔
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc  可用性监控任务是否删除成功
      */

  deleteProbeTask (opts, callback) {
    opts = opts || {}

    if (opts.probeTaskIDs === undefined || opts.probeTaskIDs === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeTaskIDs' when calling deleteProbeTask"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.probeTaskIDs !== undefined && opts.probeTaskIDs !== null) {
      queryParams['probeTaskIDs'] = opts.probeTaskIDs
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteProbeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可用性监控任务信息
      * @param {Object} opts - parameters
      * @param {string} opts.probeTaskID - 探测任务的task_id
      * @param {string} callback - callback
      @return {Object} result
      * @param probe probes
      * @param string address  探测地址
      * @param string createTime  创建时间
      * @param boolean deleted  是否被删除
      * @param boolean enable  是否启用
      * @param integer frequency  探测频率，单位秒
      * @param string httpBody  http探测的body
      * @param keyValue httpCookie
      * @param keyValue httpHeader
      * @param integer httpType  http探测方式
      * @param string name  探测任务 名称
      * @param string pin  pin
      * @param integer port  探测端口
      * @param integer probeType  探测类型1:http、2:telnet
      * @param string targetId  探测对象的uid(http探测方法无uid)
      * @param string targetRegion  探测对象所在region，redis或RDS所在region
      * @param string taskId  探测任务 id
      * @param integer taskType  任务类型、1:url/ip、2:RDS、3:redis
      * @param integer timeout  探测超时时间，单位秒
      * @param string updateTime  更新时间
      */

  describeProbeTask (opts, callback) {
    opts = opts || {}

    if (opts.probeTaskID === undefined || opts.probeTaskID === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeTaskID' when calling describeProbeTask"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      probeTaskID: opts.probeTaskID
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProbeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask/{probeTaskID}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改可用性监控任务
      * @param {Object} opts - parameters
      * @param {string} opts.probeTaskID - 探测任务的task_id
      * @param {string} [opts.httpBody] - http body：选择探测类型为1&#x3D;http时有效，最长不超过1024字节  optional
      * @param {array} [opts.httpCookie] - http cookie：选择探测类型为1&#x3D;http时有效，最大允许20个key、value对，最长不超过1024字节  optional
      * @param {array} [opts.httpHeader] - http header：选择探测类型为1&#x3D;http时有效，最大允许20个key、value对，最长不超过1024字节  optional
      * @param {integer} [opts.httpType] - http探测方法,可选值：1:get、2:post、3:head  optional
      * @param {string} [opts.name] - task名称，不允许重复，长度不超过32字符，只允许中英文、数字、下划线_、中划线-, [0-9][a-z] [A-Z] [- _ ]  optional
      * @param {array} [opts.probes] - 探测源（发起对探测目标探测的云主机，需安装相应的agent才能探测）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc  是否更新成功
      */

  updateProbeTask (opts, callback) {
    opts = opts || {}

    if (opts.probeTaskID === undefined || opts.probeTaskID === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeTaskID' when calling updateProbeTask"
      )
    }

    let postBody = {}
    if (opts.httpBody !== undefined && opts.httpBody !== null) {
      postBody['httpBody'] = opts.httpBody
    }
    if (opts.httpCookie !== undefined && opts.httpCookie !== null) {
      postBody['httpCookie'] = opts.httpCookie
    }
    if (opts.httpHeader !== undefined && opts.httpHeader !== null) {
      postBody['httpHeader'] = opts.httpHeader
    }
    if (opts.httpType !== undefined && opts.httpType !== null) {
      postBody['httpType'] = opts.httpType
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.probes !== undefined && opts.probes !== null) {
      postBody['probes'] = opts.probes
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      probeTaskID: opts.probeTaskID
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateProbeTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask/{probeTaskID}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可用性监控任务的指定探测源的异常探测历史
      * @param {Object} opts - parameters
      * @param {string} opts.probeTaskID - 可用性监控task_id, id长度(0,50]
      * @param {string} opts.probeID - 探测源id，  id长度（0,50]
      * @param {string} [opts.startTime] - 查询时间范围的开始时间， UTC时间，格式：2016-12-11T00:00:00+0800（默认为当前时间往前三天，早于3d时，将被重置为3d）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）  optional
      * @param {string} [opts.endTime] - 查询时间范围的结束时间， UTC时间，格式：2016-12-11T00:00:00+0800（为空时，默认为当前时间）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param event events
      * @param string name  探测源名称
      * @param string uuid  探测源uuid
      */

  describeProbeHistory (opts, callback) {
    opts = opts || {}

    if (opts.probeTaskID === undefined || opts.probeTaskID === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeTaskID' when calling describeProbeHistory"
      )
    }
    if (opts.probeID === undefined || opts.probeID === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeID' when calling describeProbeHistory"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      probeTaskID: opts.probeTaskID,
      probeID: opts.probeID
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProbeHistory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask/{probeTaskID}/probe/{probeID}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可用性监控任务的探测源列表
      * @param {Object} opts - parameters
      * @param {string} opts.probeTaskID - 探测任务的task_id
      * @param {filter} [opts.filters] - 自定义标签  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param probeInfo probeList
      */

  discribeProbes (opts, callback) {
    opts = opts || {}

    if (opts.probeTaskID === undefined || opts.probeTaskID === null) {
      throw new Error(
        "Missing the required parameter 'opts.probeTaskID' when calling discribeProbes"
      )
    }

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      probeTaskID: opts.probeTaskID
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call discribeProbes with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask/{probeTaskID}/probeList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用、禁用可用性监控任务
      * @param {Object} opts - parameters
      * @param {boolean} [opts.enabled] - 默认：禁用； true：启用，false：禁用  optional
      * @param {array} [opts.taskId] - 要启用或禁用的探测任务的task_id列表，列表长度[1，100)  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc  可用性监控任务 【启用｜禁用】 是否成功
      */

  probeTaskEnable (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call probeTaskEnable with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTask:switch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可用性监控任务列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 当前所在页，默认为1  optional
      * @param {integer} [opts.pageSize] - 页面大小，默认为20；取值范围[1, 100]  optional
      * @param {string} [opts.name] - 根据探测任务的名称查询，支持模糊查询  optional
      * @param {integer} [opts.type] - 根据探测任务的类型查询，1、http 2、telnet  optional
      * @param {string} [opts.timeInterval] - 查询的可用率、响应时间的时间间隔，为空时默认查询最新点,最大不超过30天，支持分钟级别,小时级别，天级别，例如：1m、1h、1d  optional
      * @param {boolean} [opts.withStats] - 是否查询可用率、响应时间  optional
      * @param {boolean} [opts.withDeleted] - 是否包含被删除的task  optional
      * @param {integer} [opts.enabled] - 任务状态：1为启用，0为禁用。默认为查所有的  optional
      * @param {filter} [opts.filters] - taskId - taskId，精确匹配，支持多个
name - task名称或探测地址，糊模匹配，支持单个  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer numberPages  总页数
      * @param integer numberRecords  总记录数
      * @param integer pageNumber  当前页码
      * @param integer pageSize  分页大小
      * @param taskInfo taskInfo
      * @param integer totalCount  该用户的总task个数，不受查询的筛选条件影响
      */

  describeProbeTasks (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.timeInterval !== undefined && opts.timeInterval !== null) {
      queryParams['timeInterval'] = opts.timeInterval
    }
    if (opts.withStats !== undefined && opts.withStats !== null) {
      queryParams['withStats'] = opts.withStats
    }
    if (opts.withDeleted !== undefined && opts.withDeleted !== null) {
      queryParams['withDeleted'] = opts.withDeleted
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      queryParams['enabled'] = opts.enabled
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProbeTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/probeTaskList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取站点监控任务信息
      * @param {Object} opts - parameters
      * @param {string} [opts.nameOrAddr]   optional
      * @param {string} [opts.name]   optional
      * @param {string} [opts.taskType]   optional
      * @param {integer} [opts.pageNumber]   optional
      * @param {integer} [opts.pageSize]   optional
      * @param {string} [opts.withStats]   optional
      * @param {string} [opts.withDeleted] - 1:包含删除对象，默认：0  optional
      * @param {string} [opts.timeInterval] - 查询的可用率、响应时间的时间间隔，最大不超过30天，支持分钟级别,小时级别，天级别，例如：1m、1h、1d  optional
      * @param {filter} [opts.filters] - name为&#39;id&#39; - 站点监控id  optional
      * @param {string} [opts.id]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param siteMonitor list
      * @param integer total
      */

  getSiteMonitor (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.nameOrAddr !== undefined && opts.nameOrAddr !== null) {
      queryParams['nameOrAddr'] = opts.nameOrAddr
    }
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      queryParams['taskType'] = opts.taskType
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.withStats !== undefined && opts.withStats !== null) {
      queryParams['withStats'] = opts.withStats
    }
    if (opts.withDeleted !== undefined && opts.withDeleted !== null) {
      queryParams['withDeleted'] = opts.withDeleted
    }
    if (opts.timeInterval !== undefined && opts.timeInterval !== null) {
      queryParams['timeInterval'] = opts.timeInterval
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, this.buildArrayParam(opts.id, 'id'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitor',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建站点监控任务
      * @param {Object} opts - parameters
      * @param {string} opts.address - 地址
      * @param {string} [opts.advanceChecked]   optional
      * @param {integer} [opts.createdTime]   optional
      * @param {integer} opts.cycle - 探测频率
      * @param {string} [opts.defaultSource]   optional
      * @param {siteMonitorDnsOption} [opts.dnsOption]   optional
      * @param {string} [opts.enabled]   optional
      * @param {siteMonitorFtpOption} [opts.ftpOption]   optional
      * @param {integer} [opts.hawkeyeId]   optional
      * @param {siteMonitorHttpOption} [opts.httpOption]   optional
      * @param {string} [opts.id]   optional
      * @param {string} [opts.isDeleted]   optional
      * @param {string} opts.name - 任务名称
      * @param {string} [opts.pin]   optional
      * @param {siteMonitorPingOption} [opts.pingOption]   optional
      * @param {siteMonitorPop3Option} [opts.pop3Option]   optional
      * @param {string} [opts.port] - 端口  optional
      * @param {siteMonitorSmtpOption} [opts.smtpOption]   optional
      * @param {array} [opts.source] - 探测源  optional
      * @param {object} [opts.stats]   optional
      * @param {string} opts.taskType - 任务类型，可选值：HTTP、PING 、TCP 、UDP、DNS、SMTP、POP3和FTP
      * @param {siteMonitorTcpOption} [opts.tcpOption]   optional
      * @param {siteMonitorUdpOption} [opts.udpOption]   optional
      * @param {integer} [opts.updatedTime]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string id
      */

  createSiteMonitor (opts, callback) {
    opts = opts || {}

    if (opts.address === undefined || opts.address === null) {
      throw new Error(
        "Missing the required parameter 'opts.address' when calling createSiteMonitor"
      )
    }
    if (opts.cycle === undefined || opts.cycle === null) {
      throw new Error(
        "Missing the required parameter 'opts.cycle' when calling createSiteMonitor"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createSiteMonitor"
      )
    }
    if (opts.taskType === undefined || opts.taskType === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskType' when calling createSiteMonitor"
      )
    }

    let postBody = {}
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.advanceChecked !== undefined && opts.advanceChecked !== null) {
      postBody['advanceChecked'] = opts.advanceChecked
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }
    if (opts.cycle !== undefined && opts.cycle !== null) {
      postBody['cycle'] = opts.cycle
    }
    if (opts.defaultSource !== undefined && opts.defaultSource !== null) {
      postBody['defaultSource'] = opts.defaultSource
    }
    if (opts.dnsOption !== undefined && opts.dnsOption !== null) {
      postBody['dnsOption'] = opts.dnsOption
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.ftpOption !== undefined && opts.ftpOption !== null) {
      postBody['ftpOption'] = opts.ftpOption
    }
    if (opts.hawkeyeId !== undefined && opts.hawkeyeId !== null) {
      postBody['hawkeyeId'] = opts.hawkeyeId
    }
    if (opts.httpOption !== undefined && opts.httpOption !== null) {
      postBody['httpOption'] = opts.httpOption
    }
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.isDeleted !== undefined && opts.isDeleted !== null) {
      postBody['isDeleted'] = opts.isDeleted
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.pingOption !== undefined && opts.pingOption !== null) {
      postBody['pingOption'] = opts.pingOption
    }
    if (opts.pop3Option !== undefined && opts.pop3Option !== null) {
      postBody['pop3Option'] = opts.pop3Option
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.smtpOption !== undefined && opts.smtpOption !== null) {
      postBody['smtpOption'] = opts.smtpOption
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.stats !== undefined && opts.stats !== null) {
      postBody['stats'] = opts.stats
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.tcpOption !== undefined && opts.tcpOption !== null) {
      postBody['tcpOption'] = opts.tcpOption
    }
    if (opts.udpOption !== undefined && opts.udpOption !== null) {
      postBody['udpOption'] = opts.udpOption
    }
    if (opts.updatedTime !== undefined && opts.updatedTime !== null) {
      postBody['updatedTime'] = opts.updatedTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitor',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改站点监控任务
      * @param {Object} opts - parameters
      * @param {string} opts.address - 地址
      * @param {string} [opts.advanceChecked]   optional
      * @param {integer} [opts.createdTime]   optional
      * @param {integer} opts.cycle - 探测频率
      * @param {string} [opts.defaultSource]   optional
      * @param {siteMonitorDnsOption} [opts.dnsOption]   optional
      * @param {string} [opts.enabled]   optional
      * @param {siteMonitorFtpOption} [opts.ftpOption]   optional
      * @param {integer} [opts.hawkeyeId]   optional
      * @param {siteMonitorHttpOption} [opts.httpOption]   optional
      * @param {string} [opts.id]   optional
      * @param {string} [opts.isDeleted]   optional
      * @param {string} opts.name - 任务名称
      * @param {string} [opts.pin]   optional
      * @param {siteMonitorPingOption} [opts.pingOption]   optional
      * @param {siteMonitorPop3Option} [opts.pop3Option]   optional
      * @param {string} [opts.port] - 端口  optional
      * @param {siteMonitorSmtpOption} [opts.smtpOption]   optional
      * @param {array} [opts.source] - 探测源  optional
      * @param {object} [opts.stats]   optional
      * @param {string} opts.taskType - 任务类型，可选值：HTTP、PING 、TCP 、UDP、DNS、SMTP、POP3和FTP
      * @param {siteMonitorTcpOption} [opts.tcpOption]   optional
      * @param {siteMonitorUdpOption} [opts.udpOption]   optional
      * @param {integer} [opts.updatedTime]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc
      */

  updateSiteMonitor (opts, callback) {
    opts = opts || {}

    if (opts.address === undefined || opts.address === null) {
      throw new Error(
        "Missing the required parameter 'opts.address' when calling updateSiteMonitor"
      )
    }
    if (opts.cycle === undefined || opts.cycle === null) {
      throw new Error(
        "Missing the required parameter 'opts.cycle' when calling updateSiteMonitor"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling updateSiteMonitor"
      )
    }
    if (opts.taskType === undefined || opts.taskType === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskType' when calling updateSiteMonitor"
      )
    }

    let postBody = {}
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.advanceChecked !== undefined && opts.advanceChecked !== null) {
      postBody['advanceChecked'] = opts.advanceChecked
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }
    if (opts.cycle !== undefined && opts.cycle !== null) {
      postBody['cycle'] = opts.cycle
    }
    if (opts.defaultSource !== undefined && opts.defaultSource !== null) {
      postBody['defaultSource'] = opts.defaultSource
    }
    if (opts.dnsOption !== undefined && opts.dnsOption !== null) {
      postBody['dnsOption'] = opts.dnsOption
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.ftpOption !== undefined && opts.ftpOption !== null) {
      postBody['ftpOption'] = opts.ftpOption
    }
    if (opts.hawkeyeId !== undefined && opts.hawkeyeId !== null) {
      postBody['hawkeyeId'] = opts.hawkeyeId
    }
    if (opts.httpOption !== undefined && opts.httpOption !== null) {
      postBody['httpOption'] = opts.httpOption
    }
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.isDeleted !== undefined && opts.isDeleted !== null) {
      postBody['isDeleted'] = opts.isDeleted
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.pingOption !== undefined && opts.pingOption !== null) {
      postBody['pingOption'] = opts.pingOption
    }
    if (opts.pop3Option !== undefined && opts.pop3Option !== null) {
      postBody['pop3Option'] = opts.pop3Option
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.smtpOption !== undefined && opts.smtpOption !== null) {
      postBody['smtpOption'] = opts.smtpOption
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.stats !== undefined && opts.stats !== null) {
      postBody['stats'] = opts.stats
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.tcpOption !== undefined && opts.tcpOption !== null) {
      postBody['tcpOption'] = opts.tcpOption
    }
    if (opts.udpOption !== undefined && opts.udpOption !== null) {
      postBody['udpOption'] = opts.udpOption
    }
    if (opts.updatedTime !== undefined && opts.updatedTime !== null) {
      postBody['updatedTime'] = opts.updatedTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitor',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除站点监控任务
      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - name为&#39;list&#39; - 站点监控id  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc
      */

  deleteSiteMonitor (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitor',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启停站点监控任务
      * @param {Object} opts - parameters
      * @param {array} [opts.list]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc
      */

  enableSiteMonitor (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.list !== undefined && opts.list !== null) {
      postBody['list'] = opts.list
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitor:switch',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检测站点监控地址是否有效
      * @param {Object} opts - parameters
      * @param {string} [opts.address]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean suc
      */

  validateSiteMonitorAddress (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.address !== undefined && opts.address !== null) {
      queryParams['address'] = opts.address
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call validateSiteMonitorAddress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitorAddress:validate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取站点监控数据
      * @param {Object} opts - parameters
      * @param {string} [opts.id]   optional
      * @param {string} [opts.startTime]   optional
      * @param {string} [opts.endTime]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param statsItem metricData
      * @param statsItem resTime
      * @param statsItem successRatio
      */

  getSiteMonitorDataPoints (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSiteMonitorDataPoints with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitorDataPoints',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取站点监控探针列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param ispLocation all
      * @param ispLocation limited
      */

  getSiteMonitorSource (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSiteMonitorSource with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/siteMonitorSource',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  测试站点监控参数
      * @param {Object} opts - parameters
      * @param {string} opts.address - 地址
      * @param {string} [opts.advanceChecked]   optional
      * @param {integer} [opts.createdTime]   optional
      * @param {integer} opts.cycle - 探测频率
      * @param {string} [opts.defaultSource]   optional
      * @param {siteMonitorDnsOption} [opts.dnsOption]   optional
      * @param {string} [opts.enabled]   optional
      * @param {siteMonitorFtpOption} [opts.ftpOption]   optional
      * @param {integer} [opts.hawkeyeId]   optional
      * @param {siteMonitorHttpOption} [opts.httpOption]   optional
      * @param {string} [opts.id]   optional
      * @param {string} [opts.isDeleted]   optional
      * @param {string} opts.name - 任务名称
      * @param {string} [opts.pin]   optional
      * @param {siteMonitorPingOption} [opts.pingOption]   optional
      * @param {siteMonitorPop3Option} [opts.pop3Option]   optional
      * @param {string} [opts.port] - 端口  optional
      * @param {siteMonitorSmtpOption} [opts.smtpOption]   optional
      * @param {array} [opts.source] - 探测源  optional
      * @param {object} [opts.stats]   optional
      * @param {string} opts.taskType - 任务类型，可选值：HTTP、PING 、TCP 、UDP、DNS、SMTP、POP3和FTP
      * @param {siteMonitorTcpOption} [opts.tcpOption]   optional
      * @param {siteMonitorUdpOption} [opts.udpOption]   optional
      * @param {integer} [opts.updatedTime]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string error  错误信息
      * @param string msg  提示信息
      * @param integer status  状态码
      */

  testSiteMonitor (opts, callback) {
    opts = opts || {}

    if (opts.address === undefined || opts.address === null) {
      throw new Error(
        "Missing the required parameter 'opts.address' when calling testSiteMonitor"
      )
    }
    if (opts.cycle === undefined || opts.cycle === null) {
      throw new Error(
        "Missing the required parameter 'opts.cycle' when calling testSiteMonitor"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling testSiteMonitor"
      )
    }
    if (opts.taskType === undefined || opts.taskType === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskType' when calling testSiteMonitor"
      )
    }

    let postBody = {}
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.advanceChecked !== undefined && opts.advanceChecked !== null) {
      postBody['advanceChecked'] = opts.advanceChecked
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }
    if (opts.cycle !== undefined && opts.cycle !== null) {
      postBody['cycle'] = opts.cycle
    }
    if (opts.defaultSource !== undefined && opts.defaultSource !== null) {
      postBody['defaultSource'] = opts.defaultSource
    }
    if (opts.dnsOption !== undefined && opts.dnsOption !== null) {
      postBody['dnsOption'] = opts.dnsOption
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.ftpOption !== undefined && opts.ftpOption !== null) {
      postBody['ftpOption'] = opts.ftpOption
    }
    if (opts.hawkeyeId !== undefined && opts.hawkeyeId !== null) {
      postBody['hawkeyeId'] = opts.hawkeyeId
    }
    if (opts.httpOption !== undefined && opts.httpOption !== null) {
      postBody['httpOption'] = opts.httpOption
    }
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.isDeleted !== undefined && opts.isDeleted !== null) {
      postBody['isDeleted'] = opts.isDeleted
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.pingOption !== undefined && opts.pingOption !== null) {
      postBody['pingOption'] = opts.pingOption
    }
    if (opts.pop3Option !== undefined && opts.pop3Option !== null) {
      postBody['pop3Option'] = opts.pop3Option
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.smtpOption !== undefined && opts.smtpOption !== null) {
      postBody['smtpOption'] = opts.smtpOption
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.stats !== undefined && opts.stats !== null) {
      postBody['stats'] = opts.stats
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }
    if (opts.tcpOption !== undefined && opts.tcpOption !== null) {
      postBody['tcpOption'] = opts.tcpOption
    }
    if (opts.udpOption !== undefined && opts.udpOption !== null) {
      postBody['udpOption'] = opts.udpOption
    }
    if (opts.updatedTime !== undefined && opts.updatedTime !== null) {
      postBody['updatedTime'] = opts.updatedTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  detection/2.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call testSiteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/testSiteMonitor',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.DETECTION
