/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * DmsView
 * 视图相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'dms'
Service._services[serviceId] = true

/**
 * dms service.
 * @version 1.4.0
 */

class DMS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'dms.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  校验当前的用户是否允许访问DMS控制台
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  允许访问
      */

  dmsConsoleCheck (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call dmsConsoleCheck with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/console:check',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生产创建事件SQL语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.eventName] - 事件名称。  optional
      * @param {} [opts.eventComment] - 注释。  optional
      * @param {} [opts.eventStatus] - 状态，ENABLED,DISABLED, SLAVESIDE_DISABLED。  optional
      * @param {} [opts.isPreserve] - 完成后是否保存。  optional
      * @param {} [opts.eventDefinition] - 事件定义。  optional
      * @param {} [opts.eventType] - 调度方式，ONE_TIME,RECURRING。  optional
      * @param {} [opts.executeAt] - 执行一次的时间。  optional
      * @param {} [opts.intervalValue] - 循环执行时间隔时间的值。  optional
      * @param {} [opts.intervalField] - 循环执行时间隔时间的单位，YEAR,QUARTER,MONTH,WEEK,DAY,HOUR,MINUTE,SECOND,YEAR_MONTH,DAY_HOUR,DAY_MINUTE,DAY_SECOND,HOUR_MINUTE,HOUR_SECOND,MINUTE_SECOND。  optional
      * @param {} [opts.starts] - 循环执行开始时间。  optional
      * @param {} [opts.ends] - 循环执行结束时间。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalCreateEvent (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateEvent"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.eventComment !== undefined && opts.eventComment !== null) {
      postBody['eventComment'] = opts.eventComment
    }
    if (opts.eventStatus !== undefined && opts.eventStatus !== null) {
      postBody['eventStatus'] = opts.eventStatus
    }
    if (opts.isPreserve !== undefined && opts.isPreserve !== null) {
      postBody['isPreserve'] = opts.isPreserve
    }
    if (opts.eventDefinition !== undefined && opts.eventDefinition !== null) {
      postBody['eventDefinition'] = opts.eventDefinition
    }
    if (opts.eventType !== undefined && opts.eventType !== null) {
      postBody['eventType'] = opts.eventType
    }
    if (opts.executeAt !== undefined && opts.executeAt !== null) {
      postBody['executeAt'] = opts.executeAt
    }
    if (opts.intervalValue !== undefined && opts.intervalValue !== null) {
      postBody['intervalValue'] = opts.intervalValue
    }
    if (opts.intervalField !== undefined && opts.intervalField !== null) {
      postBody['intervalField'] = opts.intervalField
    }
    if (opts.starts !== undefined && opts.starts !== null) {
      postBody['starts'] = opts.starts
    }
    if (opts.ends !== undefined && opts.ends !== null) {
      postBody['ends'] = opts.ends
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateEvent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/event:generalCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改事件sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.originEventName] - 原始事件名称。  optional
      * @param {} [opts.eventName] - 新事件名称。  optional
      * @param {} [opts.eventComment] - 注释。  optional
      * @param {} [opts.eventStatus] - 状态，ENABLED,DISABLED, SLAVESIDE_DISABLED。  optional
      * @param {} [opts.isPreserve] - 完成后是否保存。  optional
      * @param {} [opts.eventDefinition] - 事件定义。  optional
      * @param {} [opts.eventType] - 调度方式，ONE_TIME,RECURRING。  optional
      * @param {} [opts.executeAt] - 执行一次的时间。  optional
      * @param {} [opts.intervalValue] - 循环执行时间隔时间的值。  optional
      * @param {} [opts.intervalField] - 循环执行时间隔时间的单位，YEAR,QUARTER,MONTH,WEEK,DAY,HOUR,MINUTE,SECOND,YEAR_MONTH,DAY_HOUR,DAY_MINUTE,DAY_SECOND,HOUR_MINUTE,HOUR_SECOND,MINUTE_SECOND。  optional
      * @param {} [opts.starts] - 循环执行开始时间。  optional
      * @param {} [opts.ends] - 循环执行结束时间。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalAlterEvent (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterEvent"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.originEventName !== undefined && opts.originEventName !== null) {
      postBody['originEventName'] = opts.originEventName
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.eventComment !== undefined && opts.eventComment !== null) {
      postBody['eventComment'] = opts.eventComment
    }
    if (opts.eventStatus !== undefined && opts.eventStatus !== null) {
      postBody['eventStatus'] = opts.eventStatus
    }
    if (opts.isPreserve !== undefined && opts.isPreserve !== null) {
      postBody['isPreserve'] = opts.isPreserve
    }
    if (opts.eventDefinition !== undefined && opts.eventDefinition !== null) {
      postBody['eventDefinition'] = opts.eventDefinition
    }
    if (opts.eventType !== undefined && opts.eventType !== null) {
      postBody['eventType'] = opts.eventType
    }
    if (opts.executeAt !== undefined && opts.executeAt !== null) {
      postBody['executeAt'] = opts.executeAt
    }
    if (opts.intervalValue !== undefined && opts.intervalValue !== null) {
      postBody['intervalValue'] = opts.intervalValue
    }
    if (opts.intervalField !== undefined && opts.intervalField !== null) {
      postBody['intervalField'] = opts.intervalField
    }
    if (opts.starts !== undefined && opts.starts !== null) {
      postBody['starts'] = opts.starts
    }
    if (opts.ends !== undefined && opts.ends !== null) {
      postBody['ends'] = opts.ends
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterEvent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/event:generalAlter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成删除事件sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.eventName] - 事件名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalDropEvent (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalDropEvent"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalDropEvent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/event:generalDrop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取事件详情，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.eventName] - 事件名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dbName  数据库名称。
      * @param string eventName  事件名称。
      * @param string eventComment  注释。
      * @param string eventStatus  状态，ENABLED,DISABLED, SLAVESIDE_DISABLED。
      * @param boolean isPreserve  完成后是否保存。
      * @param string eventDefinition  事件定义。
      * @param string eventType  调度方式，ONE_TIME,RECURRING。
      * @param string executeAt  执行一次的时间。
      * @param string intervalValue  循环执行时间隔时间的值。
      * @param string intervalField  循环执行时间隔时间的单位，YEAR,QUARTER,MONTH,WEEK,DAY,HOUR,MINUTE,SECOND,YEAR_MONTH,DAY_HOUR,DAY_MINUTE,DAY_SECOND,HOUR_MINUTE,HOUR_SECOND,MINUTE_SECOND。
      * @param string starts  循环执行开始时间。
      * @param string ends  循环执行结束时间。
      */

  eventInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  eventInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call eventInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/event:info',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建导入文件任务，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.filename] - 文件名称  optional
      * @param {} [opts.totalSize] - 文件总大小  optional
      * @param {} [opts.chunkSize] - 文件分片大小  optional
      * @param {} [opts.totalChunks] - 文件分片数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string uploadId  导入文件任务id
      */

  createImportFileTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createImportFileTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.filename !== undefined && opts.filename !== null) {
      postBody['filename'] = opts.filename
    }
    if (opts.totalSize !== undefined && opts.totalSize !== null) {
      postBody['totalSize'] = opts.totalSize
    }
    if (opts.chunkSize !== undefined && opts.chunkSize !== null) {
      postBody['chunkSize'] = opts.chunkSize
    }
    if (opts.totalChunks !== undefined && opts.totalChunks !== null) {
      postBody['totalChunks'] = opts.totalChunks
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createImportFileTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/importFileTask:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上传文件，支持Stardb，只支持前端页面使用
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 上传文件任务id  optional
      * @param {} [opts.chunkNumber] - 上传文件分片号  optional
      * @param {} [opts.identifier] - 分片文件MD5  optional
      * @param {} [opts.file] - 分片文件  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param uploadImportFileResult uploadImportFileResult
      */

  uploadImportFileTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  uploadImportFileTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.chunkNumber !== undefined && opts.chunkNumber !== null) {
      postBody['chunkNumber'] = opts.chunkNumber
    }
    if (opts.identifier !== undefined && opts.identifier !== null) {
      postBody['identifier'] = opts.identifier
    }
    if (opts.file !== undefined && opts.file !== null) {
      postBody['file'] = opts.file
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call uploadImportFileTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/importFileTask:upload',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建数据变更工单，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据库id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.taskPlanTypeEnum] - 执行方式，AUTO(&quot;AUTO&quot;, 0), BY_CREATOR(&quot;BY_CREATOR&quot;, 1)  optional
      * @param {} [opts.dbaApproveTypeEnum] - DBA审批方式，AUTO(&quot;AUTO&quot;, 0), MANUAL(&quot;MANUAL&quot;, 1)  optional
      * @param {} [opts.memo] - 申请原因  optional
      * @param {} [opts.sqlText] - SQL文本，变更SQL选择文本时，必填  optional
      * @param {} [opts.sqlFileTaskId] - SQL附件导入任务Id  optional
      * @param {} [opts.rollbackSqlText] - 回滚SQL文本，选填  optional
      * @param {} [opts.rollbackFileTaskId] - 回滚SQL附件导入任务Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string flowId  工单id
      */

  createDataFlow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createDataFlow"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.taskPlanTypeEnum !== undefined && opts.taskPlanTypeEnum !== null) {
      postBody['taskPlanTypeEnum'] = opts.taskPlanTypeEnum
    }
    if (
      opts.dbaApproveTypeEnum !== undefined &&
      opts.dbaApproveTypeEnum !== null
    ) {
      postBody['dbaApproveTypeEnum'] = opts.dbaApproveTypeEnum
    }
    if (opts.memo !== undefined && opts.memo !== null) {
      postBody['memo'] = opts.memo
    }
    if (opts.sqlText !== undefined && opts.sqlText !== null) {
      postBody['sqlText'] = opts.sqlText
    }
    if (opts.sqlFileTaskId !== undefined && opts.sqlFileTaskId !== null) {
      postBody['sqlFileTaskId'] = opts.sqlFileTaskId
    }
    if (opts.rollbackSqlText !== undefined && opts.rollbackSqlText !== null) {
      postBody['rollbackSqlText'] = opts.rollbackSqlText
    }
    if (
      opts.rollbackFileTaskId !== undefined &&
      opts.rollbackFileTaskId !== null
    ) {
      postBody['rollbackFileTaskId'] = opts.rollbackFileTaskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDataFlow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dataFlow:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建结构变更工单，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据库id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.taskPlanTypeEnum] - 执行方式，AUTO(&quot;AUTO&quot;, 0), BY_CREATOR(&quot;BY_CREATOR&quot;, 1)  optional
      * @param {} [opts.dbaApproveTypeEnum] - DBA审批方式，AUTO(&quot;AUTO&quot;, 0), MANUAL(&quot;MANUAL&quot;, 1)  optional
      * @param {} [opts.memo] - 申请原因  optional
      * @param {} [opts.sqlText] - SQL文本，变更SQL选择文本时，必填  optional
      * @param {} [opts.sqlFileTaskId] - SQL附件导入任务Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string flowId  工单id
      */

  createStructureFlow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createStructureFlow"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.taskPlanTypeEnum !== undefined && opts.taskPlanTypeEnum !== null) {
      postBody['taskPlanTypeEnum'] = opts.taskPlanTypeEnum
    }
    if (
      opts.dbaApproveTypeEnum !== undefined &&
      opts.dbaApproveTypeEnum !== null
    ) {
      postBody['dbaApproveTypeEnum'] = opts.dbaApproveTypeEnum
    }
    if (opts.memo !== undefined && opts.memo !== null) {
      postBody['memo'] = opts.memo
    }
    if (opts.sqlText !== undefined && opts.sqlText !== null) {
      postBody['sqlText'] = opts.sqlText
    }
    if (opts.sqlFileTaskId !== undefined && opts.sqlFileTaskId !== null) {
      postBody['sqlFileTaskId'] = opts.sqlFileTaskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createStructureFlow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/structureFlow:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建数据导出工单，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据库id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.taskPlanTypeEnum] - 执行方式，AUTO(&quot;AUTO&quot;, 0), BY_CREATOR(&quot;BY_CREATOR&quot;, 1)  optional
      * @param {} [opts.dbaApproveTypeEnum] - DBA审批方式，AUTO(&quot;AUTO&quot;, 0), MANUAL(&quot;MANUAL&quot;, 1)  optional
      * @param {} [opts.memo] - 申请原因  optional
      * @param {} [opts.exportTypeEnum] - 导出类型， RESULT_SET(&quot;RESULT_SET&quot;, 0), DB(&quot;DB&quot;, 1)  optional
      * @param {} [opts.exportFileTypeEnum] - 导出格式，CSV(&quot;CSV&quot;, 0), SQL(&quot;SQL&quot;, 1)  optional
      * @param {} [opts.rowsNum] - 影响行数，导出类型为结果集导出时，必填  optional
      * @param {} [opts.ignoreError] - 是否跳过检验，导出类型为结果集导出时，必填  optional
      * @param {} [opts.ignoreReason] - 跳过检验原因，ignoreError为true时，必填  optional
      * @param {} [opts.exportSqlText] - 导出SQL文本，导出类型为结果集导出时，必填  optional
      * @param {} [opts.tableFilters] - 导出表及过滤条件，为空时导出全部表。导出类型为数据库导出时，必填  optional
      * @param {} [opts.exportContentTypeEnum] - 导出内容，DATA(&quot;DATA&quot;, 0), STRUCT(&quot;STRUCT&quot;, 1), STRUCT_DATA(&quot;STRUCT_DATA&quot;, 2)，导出类型为数据库导出时，必填  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string flowId  工单id
      */

  createExportFlow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createExportFlow"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.taskPlanTypeEnum !== undefined && opts.taskPlanTypeEnum !== null) {
      postBody['taskPlanTypeEnum'] = opts.taskPlanTypeEnum
    }
    if (
      opts.dbaApproveTypeEnum !== undefined &&
      opts.dbaApproveTypeEnum !== null
    ) {
      postBody['dbaApproveTypeEnum'] = opts.dbaApproveTypeEnum
    }
    if (opts.memo !== undefined && opts.memo !== null) {
      postBody['memo'] = opts.memo
    }
    if (opts.exportTypeEnum !== undefined && opts.exportTypeEnum !== null) {
      postBody['exportTypeEnum'] = opts.exportTypeEnum
    }
    if (
      opts.exportFileTypeEnum !== undefined &&
      opts.exportFileTypeEnum !== null
    ) {
      postBody['exportFileTypeEnum'] = opts.exportFileTypeEnum
    }
    if (opts.rowsNum !== undefined && opts.rowsNum !== null) {
      postBody['rowsNum'] = opts.rowsNum
    }
    if (opts.ignoreError !== undefined && opts.ignoreError !== null) {
      postBody['ignoreError'] = opts.ignoreError
    }
    if (opts.ignoreReason !== undefined && opts.ignoreReason !== null) {
      postBody['ignoreReason'] = opts.ignoreReason
    }
    if (opts.exportSqlText !== undefined && opts.exportSqlText !== null) {
      postBody['exportSqlText'] = opts.exportSqlText
    }
    if (opts.tableFilters !== undefined && opts.tableFilters !== null) {
      postBody['tableFilters'] = opts.tableFilters
    }
    if (
      opts.exportContentTypeEnum !== undefined &&
      opts.exportContentTypeEnum !== null
    ) {
      postBody['exportContentTypeEnum'] = opts.exportContentTypeEnum
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createExportFlow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/exportFlow:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  任务执行，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.flowOrderUniqId] - 流程id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  startFlow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  startFlow"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.flowOrderUniqId !== undefined && opts.flowOrderUniqId !== null) {
      postBody['flowOrderUniqId'] = opts.flowOrderUniqId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startFlow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/flow:start',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生产创建函数过程SQL语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.functionName] - 函数名称。  optional
      * @param {} [opts.functionSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.dataAccess] - 数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);  optional
      * @param {} [opts.deterministic] - 确定性。  optional
      * @param {} [opts.definitionSql] - 函数定义SQL。  optional
      * @param {} [opts.parameters] - 参数列表。  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.comment] - 注释。  optional
      * @param {} [opts.returnType] - 返回值类型，TINYINT(&quot;TINYINT&quot;, 0), SMALLINT(&quot;SMALLINT&quot;, 1), MEDIUMINT(&quot;MEDIUMINT&quot;, 2), INT(&quot;INT&quot;, 3), BIGINT(&quot;BIGINT&quot;, 4), INTEGER(&quot;INTEGER&quot;, 5), FLOAT(&quot;FLOAT&quot;, 6), DOUBLE(&quot;DOUBLE&quot;, 7), REAL(&quot;REAL&quot;, 8), DECIMAL(&quot;DECIMAL&quot;, 9), CHAR(&quot;CHAR&quot;, 10), VARCHAR(&quot;VARCHAR&quot;, 11), TINYTEXT(&quot;TINYTEXT&quot;, 12), TEXT(&quot;TEXT&quot;, 13), MEDIUMTEXT(&quot;MEDIUMTEXT&quot;, 14), LONGTEXT(&quot;LONGTEXT&quot;, 15), DATE(&quot;DATE&quot;, 16), DATETIME(&quot;DATETIME&quot;, 17), TIMESTAMP(&quot;TIMESTAMP&quot;, 18), TIME(&quot;TIME&quot;, 19), YEAR(&quot;YEAR&quot;, 19), BINARY(&quot;BINARY&quot;, 20), VARBINARY(&quot;VARBINARY&quot;, 21), TINYBLOB(&quot;TINYBLOB&quot;, 22), BLOB(&quot;BLOB&quot;, 23), MEDIUMBLOB(&quot;MEDIUMBLOB&quot;, 24), LONGBLOB(&quot;LONGBLOB&quot;, 25);  optional
      * @param {} [opts.returnLength] - 返回值长度。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalCreateFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateFunction"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.functionName !== undefined && opts.functionName !== null) {
      postBody['functionName'] = opts.functionName
    }
    if (opts.functionSecurity !== undefined && opts.functionSecurity !== null) {
      postBody['functionSecurity'] = opts.functionSecurity
    }
    if (opts.dataAccess !== undefined && opts.dataAccess !== null) {
      postBody['dataAccess'] = opts.dataAccess
    }
    if (opts.deterministic !== undefined && opts.deterministic !== null) {
      postBody['deterministic'] = opts.deterministic
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (opts.comment !== undefined && opts.comment !== null) {
      postBody['comment'] = opts.comment
    }
    if (opts.returnType !== undefined && opts.returnType !== null) {
      postBody['returnType'] = opts.returnType
    }
    if (opts.returnLength !== undefined && opts.returnLength !== null) {
      postBody['returnLength'] = opts.returnLength
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:generalCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改函数sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.functionName] - 函数名称。  optional
      * @param {} [opts.originFunctionName] - 函数名称。  optional
      * @param {} [opts.functionSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.dataAccess] - 数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);  optional
      * @param {} [opts.deterministic] - 确定性。  optional
      * @param {} [opts.definitionSql] - 函数定义SQL。  optional
      * @param {} [opts.completeSql] - 函数定义SQL。  optional
      * @param {} [opts.parameters] - 参数列表。  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.comment] - 注释。  optional
      * @param {} [opts.returnType] - 返回值类型，TINYINT(&quot;TINYINT&quot;, 0), SMALLINT(&quot;SMALLINT&quot;, 1), MEDIUMINT(&quot;MEDIUMINT&quot;, 2), INT(&quot;INT&quot;, 3), BIGINT(&quot;BIGINT&quot;, 4), INTEGER(&quot;INTEGER&quot;, 5), FLOAT(&quot;FLOAT&quot;, 6), DOUBLE(&quot;DOUBLE&quot;, 7), REAL(&quot;REAL&quot;, 8), DECIMAL(&quot;DECIMAL&quot;, 9), CHAR(&quot;CHAR&quot;, 10), VARCHAR(&quot;VARCHAR&quot;, 11), TINYTEXT(&quot;TINYTEXT&quot;, 12), TEXT(&quot;TEXT&quot;, 13), MEDIUMTEXT(&quot;MEDIUMTEXT&quot;, 14), LONGTEXT(&quot;LONGTEXT&quot;, 15), DATE(&quot;DATE&quot;, 16), DATETIME(&quot;DATETIME&quot;, 17), TIMESTAMP(&quot;TIMESTAMP&quot;, 18), TIME(&quot;TIME&quot;, 19), YEAR(&quot;YEAR&quot;, 19), BINARY(&quot;BINARY&quot;, 20), VARBINARY(&quot;VARBINARY&quot;, 21), TINYBLOB(&quot;TINYBLOB&quot;, 22), BLOB(&quot;BLOB&quot;, 23), MEDIUMBLOB(&quot;MEDIUMBLOB&quot;, 24), LONGBLOB(&quot;LONGBLOB&quot;, 25);  optional
      * @param {} [opts.returnLength] - 返回值长度。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalAlterFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterFunction"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.functionName !== undefined && opts.functionName !== null) {
      postBody['functionName'] = opts.functionName
    }
    if (
      opts.originFunctionName !== undefined &&
      opts.originFunctionName !== null
    ) {
      postBody['originFunctionName'] = opts.originFunctionName
    }
    if (opts.functionSecurity !== undefined && opts.functionSecurity !== null) {
      postBody['functionSecurity'] = opts.functionSecurity
    }
    if (opts.dataAccess !== undefined && opts.dataAccess !== null) {
      postBody['dataAccess'] = opts.dataAccess
    }
    if (opts.deterministic !== undefined && opts.deterministic !== null) {
      postBody['deterministic'] = opts.deterministic
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }
    if (opts.completeSql !== undefined && opts.completeSql !== null) {
      postBody['completeSql'] = opts.completeSql
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (opts.comment !== undefined && opts.comment !== null) {
      postBody['comment'] = opts.comment
    }
    if (opts.returnType !== undefined && opts.returnType !== null) {
      postBody['returnType'] = opts.returnType
    }
    if (opts.returnLength !== undefined && opts.returnLength !== null) {
      postBody['returnLength'] = opts.returnLength
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:generalAlter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成删除函数sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.functionName] - 函数名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalDropFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalDropFunction"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.functionName !== undefined && opts.functionName !== null) {
      postBody['functionName'] = opts.functionName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalDropFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:generalDrop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取函数列表，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.filter] - 过滤条件。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string functionNames  函数名称
      */

  functionList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  functionList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.filter !== undefined && opts.filter !== null) {
      postBody['filter'] = opts.filter
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call functionList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取函数详情，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.functionName] - 函数名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dbName  数据库名称。
      * @param string functionName  函数名称。
      * @param string functionSecurity  安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);
      * @param string dataAccess  数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);
      * @param boolean deterministic  确定性。
      * @param string definitionSql  函数定义SQL。
      * @param string completeSql  创建存储过程定义完整SQL。
      * @param parameter parameters
      * @param string definer  定义者。
      * @param string comment  注释。
      * @param string returnType  返回值类型，TINYINT(&quot;TINYINT&quot;, 0), SMALLINT(&quot;SMALLINT&quot;, 1), MEDIUMINT(&quot;MEDIUMINT&quot;, 2), INT(&quot;INT&quot;, 3), BIGINT(&quot;BIGINT&quot;, 4), INTEGER(&quot;INTEGER&quot;, 5), FLOAT(&quot;FLOAT&quot;, 6), DOUBLE(&quot;DOUBLE&quot;, 7), REAL(&quot;REAL&quot;, 8), DECIMAL(&quot;DECIMAL&quot;, 9), CHAR(&quot;CHAR&quot;, 10), VARCHAR(&quot;VARCHAR&quot;, 11), TINYTEXT(&quot;TINYTEXT&quot;, 12), TEXT(&quot;TEXT&quot;, 13), MEDIUMTEXT(&quot;MEDIUMTEXT&quot;, 14), LONGTEXT(&quot;LONGTEXT&quot;, 15), DATE(&quot;DATE&quot;, 16), DATETIME(&quot;DATETIME&quot;, 17), TIMESTAMP(&quot;TIMESTAMP&quot;, 18), TIME(&quot;TIME&quot;, 19), YEAR(&quot;YEAR&quot;, 19), BINARY(&quot;BINARY&quot;, 20), VARBINARY(&quot;VARBINARY&quot;, 21), TINYBLOB(&quot;TINYBLOB&quot;, 22), BLOB(&quot;BLOB&quot;, 23), MEDIUMBLOB(&quot;MEDIUMBLOB&quot;, 24), LONGBLOB(&quot;LONGBLOB&quot;, 25);
      * @param integer returnLength  返回值长度。
      * @param integer returnDecimal  返回值精度。
      */

  functionInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  functionInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.functionName !== undefined && opts.functionName !== null) {
      postBody['functionName'] = opts.functionName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call functionInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:info',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  调用函数，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.functionName] - 函数名称。  optional
      * @param {} [opts.parameters] - 参数。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string returnValue  返回值
      * @param object outArgs  输出参数返回值
      */

  functionInvoke (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  functionInvoke"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.functionName !== undefined && opts.functionName !== null) {
      postBody['functionName'] = opts.functionName
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call functionInvoke with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/function:invoke',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成建表语句sql，支持Mysql，Stardb，OpenGauss
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名  optional
      * @param {} [opts.tableName] - 表名  optional
      * @param {} [opts.metaTableInfo] - 表元信息。  optional
      * @param {} [opts.columnInfos] - 列信息。  optional
      * @param {} [opts.indexInfos] - 索引信息。  optional
      * @param {} [opts.extraTableInfo] - 分表信息，stardb数据源中使用。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  生成sql
      */

  generalCreateTableSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateTableSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.tableName !== undefined && opts.tableName !== null) {
      postBody['tableName'] = opts.tableName
    }
    if (opts.metaTableInfo !== undefined && opts.metaTableInfo !== null) {
      postBody['metaTableInfo'] = opts.metaTableInfo
    }
    if (opts.columnInfos !== undefined && opts.columnInfos !== null) {
      postBody['columnInfos'] = opts.columnInfos
    }
    if (opts.indexInfos !== undefined && opts.indexInfos !== null) {
      postBody['indexInfos'] = opts.indexInfos
    }
    if (opts.extraTableInfo !== undefined && opts.extraTableInfo !== null) {
      postBody['extraTableInfo'] = opts.extraTableInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateTableSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/createSql:general',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改表结构语句sql，支持Mysql，Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源Id  optional
      * @param {} [opts.dbName] - 数据库名  optional
      * @param {} [opts.tableName] - 表名  optional
      * @param {} [opts.metaTableInfo] - 表元信息。  optional
      * @param {} [opts.columnInfos] - 列信息。  optional
      * @param {} [opts.indexInfos] - 索引信息。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  生成sql
      */

  generalAlterTableSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterTableSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.tableName !== undefined && opts.tableName !== null) {
      postBody['tableName'] = opts.tableName
    }
    if (opts.metaTableInfo !== undefined && opts.metaTableInfo !== null) {
      postBody['metaTableInfo'] = opts.metaTableInfo
    }
    if (opts.columnInfos !== undefined && opts.columnInfos !== null) {
      postBody['columnInfos'] = opts.columnInfos
    }
    if (opts.indexInfos !== undefined && opts.indexInfos !== null) {
      postBody['indexInfos'] = opts.indexInfos
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterTableSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/alterSql:general',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取当前实例用户查询sql历史
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  历史sql总量
      * @param dmsHistorySql historySqls
      */

  historySql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  historySql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call historySql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/historySql',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取当前实例用户查询导入数据sql历史
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  历史sql总量
      * @param historySql historySqls
      */

  historyImportData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  historyImportData"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call historyImportData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/historyImportData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户实例
      * @param {Object} opts - parameters
      * @param {} [opts.instanceQueryTypeEnum] - 查询分类方式：LOGIN_STATUS，DB_TYPE。  optional
      * @param {} [opts.instanceStatus] - 实例状态，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)。  optional
      * @param {} [opts.dbInfoEnum] - 数据库类型：MYSQL_INS，DRDS_INS  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {} [opts.uniqId] - 实例Id。  optional
      * @param {} [opts.dbName] - 打开数据库名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string instanceQueryTypeEnum  查询分类方式：LOGIN_STATUS，DB_TYPE。
      * @param dmsInstance loginedInstance
      * @param dmsInstance unloginedInstance
      * @param dmsInstance noNeedLoginInstance
      * @param dmsInstance rdsIntance
      * @param dmsInstance drdsIntance
      */

  queryInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryInstance"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (
      opts.instanceQueryTypeEnum !== undefined &&
      opts.instanceQueryTypeEnum !== null
    ) {
      postBody['instanceQueryTypeEnum'] = opts.instanceQueryTypeEnum
    }
    if (opts.instanceStatus !== undefined && opts.instanceStatus !== null) {
      postBody['instanceStatus'] = opts.instanceStatus
    }
    if (opts.dbInfoEnum !== undefined && opts.dbInfoEnum !== null) {
      postBody['dbInfoEnum'] = opts.dbInfoEnum
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.uniqId !== undefined && opts.uniqId !== null) {
      postBody['uniqId'] = opts.uniqId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  打开实例
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  open (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  open"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call open with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instance:open',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  rds，drds登录实例
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - rds，drds的实例id。
      * @param {} [opts.dbType] - 数据源类型，CDS(&quot;CDS&quot;, 1), MYSQL(&quot;MYSQL&quot;, 2), ORACLE(&quot;ORACLE&quot;, 3), SQLSERVER(&quot;SQLSERVER&quot;, 4), CDSMYSQL(&quot;CDSMYSQL&quot;, 5), CDSORACLE(&quot;CDSORACLE&quot;, 6), CDSSQLSERVER(&quot;CDSSQLSERVER&quot;, 7), DATACENTER(&quot;DATACENTER&quot;, 8), HBASE(&quot;Hbase&quot;,9),MONGODB(&quot;MongoDb&quot;,10),ES(&quot;ES&quot;,11), MYSQL_INS(&quot;MYSQL_INS&quot;,12), DRDS_INS(&quot;DRDS_INS&quot;,13), STARDB_INS(&quot;STARDB_INS&quot;,14), STARDB_PROXY_INS(&quot;STARDB_PROXY_INS&quot;,15), CLICK_HOUSE_INS(&quot;CLICK_HOUSE_INS&quot;,16), TIDB_INS(&quot;TIDB_INS&quot;,17), OPEN_GAUSS_INS(&quot;OPEN_GAUSS_INS&quot;,18), SS_OPEN_GAUSS_INS(&quot;SS_OPEN_GAUSS_INS&quot;,19);  optional
      * @param {} [opts.addrMode] - CLASSIC(&quot;CLASSIC&quot;, 0), RDS(&quot;RDS&quot;, 1), ECS(&quot;ECS&quot;, 2), VPC(&quot;VPC&quot;, 3), 当前只支持rds模式。  optional
      * @param {} [opts.dbUser] - 数据库用户名。  optional
      * @param {} [opts.dbPassword] - 数据库用户密码。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  login (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  login"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling login"
      )
    }

    let postBody = {}
    if (opts.dbType !== undefined && opts.dbType !== null) {
      postBody['dbType'] = opts.dbType
    }
    if (opts.addrMode !== undefined && opts.addrMode !== null) {
      postBody['addrMode'] = opts.addrMode
    }
    if (opts.dbUser !== undefined && opts.dbUser !== null) {
      postBody['dbUser'] = opts.dbUser
    }
    if (opts.dbPassword !== undefined && opts.dbPassword !== null) {
      postBody['dbPassword'] = opts.dbPassword
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call login with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}:login',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  退出登录
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  logout (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  logout"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call logout with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instance:logout',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户数据类型实例
      * @param {Object} opts - parameters
      * @param {} [opts.dbType] - 数据源类型，CDS(&quot;CDS&quot;, 1), MYSQL(&quot;MYSQL&quot;, 2), ORACLE(&quot;ORACLE&quot;, 3), SQLSERVER(&quot;SQLSERVER&quot;, 4), CDSMYSQL(&quot;CDSMYSQL&quot;, 5), CDSORACLE(&quot;CDSORACLE&quot;, 6), CDSSQLSERVER(&quot;CDSSQLSERVER&quot;, 7), DATACENTER(&quot;DATACENTER&quot;, 8), HBASE(&quot;Hbase&quot;,9),MONGODB(&quot;MongoDb&quot;,10),ES(&quot;ES&quot;,11), MYSQL_INS(&quot;MYSQL_INS&quot;,12), DRDS_INS(&quot;DRDS_INS&quot;,13), STARDB_INS(&quot;STARDB_INS&quot;,14), STARDB_PROXY_INS(&quot;STARDB_PROXY_INS&quot;,15), CLICK_HOUSE_INS(&quot;CLICK_HOUSE_INS&quot;,16), TIDB_INS(&quot;TIDB_INS&quot;,17), OPEN_GAUSS_INS(&quot;OPEN_GAUSS_INS&quot;,18), SS_OPEN_GAUSS_INS(&quot;SS_OPEN_GAUSS_INS&quot;,19);  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string regionId  查询分类方式：LOGIN_STATUS，DB_TYPE。
      * @param integer dbType  数据库类型。
      * @param dmsInstance loginedInstance
      * @param dmsInstance unloginedInstance
      */

  queryTypeInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryTypeInstance"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dbType !== undefined && opts.dbType !== null) {
      postBody['dbType'] = opts.dbType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryTypeInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/typeInstances:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  校验用户是否有实例权限
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  checkInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkInstance"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling checkInstance"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}:check',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取表元数据，支持Mysql，Stardb，Tidb，ClickHouse
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 库名。  optional
      * @param {} [opts.tableName] - 表名。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsTableStruct dmsTableStruct
      */

  tableInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  tableInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.tableName !== undefined && opts.tableName !== null) {
      postBody['tableName'] = opts.tableName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call tableInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/consoleTableInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取数据库实例的库列表，支持Mysql，Stardb，Tidb，ClickHouse
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string databaseNames  数据库名称
      */

  databaseList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  databaseList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call databaseList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/consoleDbList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取数据库中的表列表，支持Mysql，Stardb，Tidb，ClickHouse
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string tableNames  表名称
      */

  tableList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  tableList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call tableList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/consoleTableList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取sql中建表语句，表中列信息，支持Mysql，Stardb，Tidb，ClickHouse
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.sqls] - sql语句  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsTableStruct dmsTableStructs
      */

  sqlTableInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  sqlTableInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.sqls !== undefined && opts.sqls !== null) {
      postBody['sqls'] = opts.sqls
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sqlTableInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqlTableInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Dms域名，仅供前端使用
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object domains  区域到域名映射，例{&quot;cn-north-1&quot;:&quot;http://10.222.49.154:8080&quot;, &quot;cn-east-1&quot;:&quot;http://10.222.49.154:8080&quot;}。
      */

  getDmsDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDmsDomain"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDmsDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getDmsDomain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Dms域名，仅供前端使用
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param object domains  区域到域名映射，例{&quot;cn-north-1&quot;:&quot;http://10.222.49.154:8080&quot;, &quot;cn-east-1&quot;:&quot;http://10.222.49.154:8080&quot;}。
      */

  getDmsDomains (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDmsDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/getDmsDomain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取操作对应控制台功能
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  操作类型总量
      * @param dmsOperationType dmsOperationTypes
      */

  queryOperationType (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryOperationType"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryOperationType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/operationType:query',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取操作日志列表
      * @param {Object} opts - parameters
      * @param {} [opts.supType] - 操作类型  optional
      * @param {} [opts.type] - 对应控制台功能  optional
      * @param {} [opts.pin] - 操作人  optional
      * @param {} [opts.instanceId] - 实例id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.startTime] - 起始时间(UTC)  optional
      * @param {} [opts.endTime] - 结束时间(UTC)  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  操作日志总量
      * @param dmsOperationLog operationLogs
      */

  queryOperationLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryOperationLog"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.supType !== undefined && opts.supType !== null) {
      postBody['supType'] = opts.supType
    }
    if (opts.type !== undefined && opts.type !== null) {
      postBody['type'] = opts.type
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      postBody['instanceId'] = opts.instanceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryOperationLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/operationLog:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取操作详情
      * @param {Object} opts - parameters
      * @param {integer} opts.operationId - 操作id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsOperationLog dmsOperationLog
      */

  operationDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  operationDetail"
      )
    }

    opts = opts || {}

    if (opts.operationId === undefined || opts.operationId === null) {
      throw new Error(
        "Missing the required parameter 'opts.operationId' when calling operationDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      operationId: opts.operationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call operationDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/operationDetail/{operationId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取当前实例用户收藏sql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  收藏sql总量
      * @param personalSql personalSqls
      */

  queryPersonalSqls (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryPersonalSqls"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPersonalSqls with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/personalSql:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  收藏sql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.sqlStr] - 收藏的sql语句。  optional
      * @param {} [opts.hint] - 备注。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  返回消息
      */

  addPersonalSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addPersonalSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.sqlStr !== undefined && opts.sqlStr !== null) {
      postBody['sqlStr'] = opts.sqlStr
    }
    if (opts.hint !== undefined && opts.hint !== null) {
      postBody['hint'] = opts.hint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addPersonalSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/personalSql:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除收藏sql
      * @param {Object} opts - parameters
      * @param {} [opts.id] - 主键id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deletePersonalSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deletePersonalSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deletePersonalSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/personalSql:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新收藏sql
      * @param {Object} opts - parameters
      * @param {} [opts.id] - 主键id  optional
      * @param {} [opts.hint] - sql备注  optional
      * @param {} [opts.sqlStr] - sql内容  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updatePersonalSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updatePersonalSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.hint !== undefined && opts.hint !== null) {
      postBody['hint'] = opts.hint
    }
    if (opts.sqlStr !== undefined && opts.sqlStr !== null) {
      postBody['sqlStr'] = opts.sqlStr
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePersonalSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/personalSql:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生产创建存储过程SQL语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.procedureName] - 存储过程名称。  optional
      * @param {} [opts.procedureSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.dataAccess] - 数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);  optional
      * @param {} [opts.deterministic] - 确定性。  optional
      * @param {} [opts.definitionSql] - 存储过程定义SQL。  optional
      * @param {} [opts.parameters] - 参数列表。  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.comment] - 注释。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalCreateProcedure (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateProcedure"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.procedureName !== undefined && opts.procedureName !== null) {
      postBody['procedureName'] = opts.procedureName
    }
    if (
      opts.procedureSecurity !== undefined &&
      opts.procedureSecurity !== null
    ) {
      postBody['procedureSecurity'] = opts.procedureSecurity
    }
    if (opts.dataAccess !== undefined && opts.dataAccess !== null) {
      postBody['dataAccess'] = opts.dataAccess
    }
    if (opts.deterministic !== undefined && opts.deterministic !== null) {
      postBody['deterministic'] = opts.deterministic
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (opts.comment !== undefined && opts.comment !== null) {
      postBody['comment'] = opts.comment
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateProcedure with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:generalCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改存储过程sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.originProcedureName] - 原存储过程名称。  optional
      * @param {} [opts.procedureName] - 存储过程名称。  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.procedureSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.dataAccess] - 数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);  optional
      * @param {} [opts.deterministic] - 确定性。  optional
      * @param {} [opts.definitionSql] - 存储过程定义SQL。  optional
      * @param {} [opts.completeSql] - 创建存储过程定义完整SQL。  optional
      * @param {} [opts.parameters] - 参数列表。  optional
      * @param {} [opts.comment] - 注释  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalAlterProcedure (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterProcedure"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (
      opts.originProcedureName !== undefined &&
      opts.originProcedureName !== null
    ) {
      postBody['originProcedureName'] = opts.originProcedureName
    }
    if (opts.procedureName !== undefined && opts.procedureName !== null) {
      postBody['procedureName'] = opts.procedureName
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (
      opts.procedureSecurity !== undefined &&
      opts.procedureSecurity !== null
    ) {
      postBody['procedureSecurity'] = opts.procedureSecurity
    }
    if (opts.dataAccess !== undefined && opts.dataAccess !== null) {
      postBody['dataAccess'] = opts.dataAccess
    }
    if (opts.deterministic !== undefined && opts.deterministic !== null) {
      postBody['deterministic'] = opts.deterministic
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }
    if (opts.completeSql !== undefined && opts.completeSql !== null) {
      postBody['completeSql'] = opts.completeSql
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }
    if (opts.comment !== undefined && opts.comment !== null) {
      postBody['comment'] = opts.comment
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterProcedure with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:generalAlter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成删除存储过程sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.procedureName] - 存储过程名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalDropProcedure (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalDropProcedure"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.procedureName !== undefined && opts.procedureName !== null) {
      postBody['procedureName'] = opts.procedureName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalDropProcedure with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:generalDrop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取存储过程列表，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.filter] - 过滤条件。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string procedureNames  存储过程名称
      */

  procedureList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  procedureList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.filter !== undefined && opts.filter !== null) {
      postBody['filter'] = opts.filter
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call procedureList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取存储过程详情，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.procedureName] - 存储过程名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dbName  数据库名称。
      * @param string procedureName  存储过程名称。
      * @param string definer  定义者。
      * @param string procedureSecurity  安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);
      * @param string dataAccess  数据访问，DEFAULT(&quot;DEFAULT&quot;, 1),NO_SQL(&quot;NO_SQL&quot;, 2), CONTAINS_SQL(&quot;CONTAINS_SQL&quot;, 3), READS_SQL_DATA(&quot;READS_SQL_DATA&quot;, 4), MODIFIES_SQL_DATA(&quot;MODIFIES_SQL_DATA&quot;, 5);
      * @param boolean deterministic  确定性。
      * @param string definitionSql  存储过程定义SQL。
      * @param string completeSql  创建存储过程定义完整SQL。
      * @param parameter parameters
      * @param string comment  注释
      */

  procedureInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  procedureInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.procedureName !== undefined && opts.procedureName !== null) {
      postBody['procedureName'] = opts.procedureName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call procedureInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:info',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行存储过程，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.procedureName] - 存储过程名称。  optional
      * @param {} [opts.parameters] - 参数。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object returnValue  格式：{key:value}
      */

  procedureInvoke (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  procedureInvoke"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.procedureName !== undefined && opts.procedureName !== null) {
      postBody['procedureName'] = opts.procedureName
    }
    if (opts.parameters !== undefined && opts.parameters !== null) {
      postBody['parameters'] = opts.parameters
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call procedureInvoke with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/procedure:invoke',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视图列表，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.filter] - 过滤条件。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string viewNames  视图名称
      * @param string procedureNames  存储过程名称
      * @param string functionNames  函数名称
      * @param string triggerNames  触发器名称
      * @param string eventNames  事件名称
      */

  programList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  programList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.filter !== undefined && opts.filter !== null) {
      postBody['filter'] = opts.filter
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call programList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/program:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行编程对象sql，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.dmsSqls] - SQL列表。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  exeProgram (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  exeProgram"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.dmsSqls !== undefined && opts.dmsSqls !== null) {
      postBody['dmsSqls'] = opts.dmsSqls
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call exeProgram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/program:exe',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行计划，支持Mysql，Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.sqls] - sql语句。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSqlResult dmsSqlResults
      */

  consoleExplain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  consoleExplain"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.sqls !== undefined && opts.sqls !== null) {
      postBody['sqls'] = opts.sqls
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call consoleExplain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/console:explain',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行sql语句，支持Mysql，Stardb，Tidb，ClickHouse
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.sqls] - sql语句。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSqlResult dmsSqlResults
      */

  consoleSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  consoleSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.sqls !== undefined && opts.sqls !== null) {
      postBody['sqls'] = opts.sqls
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call consoleSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/console:exeSql',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成数据，支持Mysql，Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.tableName] - 表名。  optional
      * @param {} [opts.count] - 生成数据行数。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSqlsResult dmsSqlsResult
      */

  consoleGeneralData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  consoleGeneralData"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.tableName !== undefined && opts.tableName !== null) {
      postBody['tableName'] = opts.tableName
    }
    if (opts.count !== undefined && opts.count !== null) {
      postBody['count'] = opts.count
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call consoleGeneralData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/console:generalData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  sql格式化，支持Mysql，Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.sqlStr] - 需要格式化的sql  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  格式化后的SQL
      */

  formatSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  formatSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.sqlStr !== undefined && opts.sqlStr !== null) {
      postBody['sqlStr'] = opts.sqlStr
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call formatSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sql:format',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量建表，支持Stardb
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.createTableInfos] - 查询结果。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSqlsResult dmsSqlsResult
      */

  createTableBatch (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createTableBatch"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.createTableInfos !== undefined && opts.createTableInfos !== null) {
      postBody['createTableInfos'] = opts.createTableInfos
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTableBatch with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/console:createTableBatch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取批量建表sql，仅供前端使用，支持Stardb，OpenGauss
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称  optional
      * @param {} [opts.createTableInfos] - 查询结果。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string strResult  格式化后的SQL
      */

  getCreateTableBatchSql (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getCreateTableBatchSql"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.createTableInfos !== undefined && opts.createTableInfos !== null) {
      postBody['createTableInfos'] = opts.createTableInfos
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCreateTableBatchSql with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/console:getCreateTableBatchSql',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建Sql任务
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.planTime] - 计划开始执行时间，stardb数据源固定为空。  optional
      * @param {} [opts.sqls] - 执行SQL。  optional
      * @param {} [opts.taskTypeEnum] - 任务类型:DDL, DML  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer intResult  任务id
      */

  createOnlineSqlTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createOnlineSqlTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.planTime !== undefined && opts.planTime !== null) {
      postBody['planTime'] = opts.planTime
    }
    if (opts.sqls !== undefined && opts.sqls !== null) {
      postBody['sqls'] = opts.sqls
    }
    if (opts.taskTypeEnum !== undefined && opts.taskTypeEnum !== null) {
      postBody['taskTypeEnum'] = opts.taskTypeEnum
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createOnlineSqlTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqltask:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动Sql任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  startOnlineSqlTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  startOnlineSqlTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startOnlineSqlTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqltask:start',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  暂停Sql任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  suspendOnlineSqlTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  suspendOnlineSqlTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call suspendOnlineSqlTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqltask:suspend',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  重启Sql任务
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restartOnlineSqlTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restartOnlineSqlTask"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restartOnlineSqlTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqltask:restart',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询任务状态
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer id  主键id。
      * @param integer dataSourceId  数据源id。
      * @param string dbName  数据库名称。
      * @param string taskType  任务类型，DDL， DML。
      * @param string planTime  计划时间。
      * @param boolean transaction  是否为事务。
      * @param boolean parallel  是否为并行执行。
      * @param boolean ignoreError  是否忽略错误。
      * @param string runStatus  运行状态。CREATE(&quot;CREATE&quot;, 1),RUNNING(&quot;RUNNING&quot;, 2), SUCCESS(&quot;SUCCESS&quot;, 3), FAILED(&quot;FAILED&quot;, 4), SUSPEND(&quot;SUSPEND&quot;, 5);
      * @param string createdDate  创建日期。
      * @param string finishDate  结束日期。
      * @param string createUser  创建用户。
      * @param string status  状态0有效，1无效。
      * @param string message  执行消息。
      * @param string runIp  运行ip。
      */

  onlineSqlTaskQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  onlineSqlTaskQuery"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call onlineSqlTaskQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sqltask:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询sql子任务状态
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - 任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsOnlineSubSqlTask dmsOnlineSubSqlTasks
      */

  onlineSubSqlTaskQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  onlineSubSqlTaskQuery"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call onlineSubSqlTaskQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/subsqltask:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询sql子任务状态
      * @param {Object} opts - parameters
      * @param {} [opts.taskId] - dms任务id  optional
      * @param {} [opts.proxyTaskId] - proxy任务id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsOnlineProxySubTask dmsOnlineProxySubTasks
      */

  onlineProxySubTaskQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  onlineProxySubTaskQuery"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.proxyTaskId !== undefined && opts.proxyTaskId !== null) {
      postBody['proxyTaskId'] = opts.proxyTaskId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call onlineProxySubTaskQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/proxysubtask:query',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成创建触发器SQL语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.triggerName] - 触发器名称。  optional
      * @param {} [opts.triggerTiming] - 触发时机，BEFORE(&quot;BEFORE&quot;, 1),AFTER(&quot;AFTER&quot;, 2)。  optional
      * @param {} [opts.triggerEvent] - 激活触发器的事件，INSERT(&quot;INSERT&quot;, 1),UPDATE(&quot;UPDATE&quot;, 2), DELETE(&quot;DELETE&quot;, 3)。  optional
      * @param {} [opts.triggerTable] - 触发表。  optional
      * @param {} [opts.triggerStatement] - 触发器定义。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalCreateTrigger (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateTrigger"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.triggerName !== undefined && opts.triggerName !== null) {
      postBody['triggerName'] = opts.triggerName
    }
    if (opts.triggerTiming !== undefined && opts.triggerTiming !== null) {
      postBody['triggerTiming'] = opts.triggerTiming
    }
    if (opts.triggerEvent !== undefined && opts.triggerEvent !== null) {
      postBody['triggerEvent'] = opts.triggerEvent
    }
    if (opts.triggerTable !== undefined && opts.triggerTable !== null) {
      postBody['triggerTable'] = opts.triggerTable
    }
    if (opts.triggerStatement !== undefined && opts.triggerStatement !== null) {
      postBody['triggerStatement'] = opts.triggerStatement
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateTrigger with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/trigger:generalCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改触发器sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.originTriggerName] - 原触发器名称。  optional
      * @param {} [opts.triggerName] - 触发器名称。  optional
      * @param {} [opts.triggerTiming] - 触发时机，BEFORE(&quot;BEFORE&quot;, 1),AFTER(&quot;AFTER&quot;, 2)。  optional
      * @param {} [opts.triggerEvent] - 激活触发器的事件，INSERT(&quot;INSERT&quot;, 1),UPDATE(&quot;UPDATE&quot;, 2), DELETE(&quot;DELETE&quot;, 3)。  optional
      * @param {} [opts.triggerTable] - 触发表。  optional
      * @param {} [opts.triggerStatement] - 触发器定义。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalAlterTrigger (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterTrigger"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (
      opts.originTriggerName !== undefined &&
      opts.originTriggerName !== null
    ) {
      postBody['originTriggerName'] = opts.originTriggerName
    }
    if (opts.triggerName !== undefined && opts.triggerName !== null) {
      postBody['triggerName'] = opts.triggerName
    }
    if (opts.triggerTiming !== undefined && opts.triggerTiming !== null) {
      postBody['triggerTiming'] = opts.triggerTiming
    }
    if (opts.triggerEvent !== undefined && opts.triggerEvent !== null) {
      postBody['triggerEvent'] = opts.triggerEvent
    }
    if (opts.triggerTable !== undefined && opts.triggerTable !== null) {
      postBody['triggerTable'] = opts.triggerTable
    }
    if (opts.triggerStatement !== undefined && opts.triggerStatement !== null) {
      postBody['triggerStatement'] = opts.triggerStatement
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterTrigger with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/trigger:generalAlter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成删除触发器sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.triggerName] - 触发器名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalDropTrigger (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalDropTrigger"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.triggerName !== undefined && opts.triggerName !== null) {
      postBody['triggerName'] = opts.triggerName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalDropTrigger with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/trigger:generalDrop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取触发器列表，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.filter] - 过滤条件。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string triggerNames  触发器名称
      */

  triggerList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  triggerList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.filter !== undefined && opts.filter !== null) {
      postBody['filter'] = opts.filter
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call triggerList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/trigger:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取触发器详情，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.triggerName] - 触发器名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dbName  数据库名称。
      * @param string triggerName  存储过程名称。
      * @param string triggerTiming  触发时机，BEFORE(&quot;BEFORE&quot;, 1),AFTER(&quot;AFTER&quot;, 2)。
      * @param string triggerEvent  激活触发器的事件，INSERT(&quot;INSERT&quot;, 1),UPDATE(&quot;UPDATE&quot;, 2), DELETE(&quot;DELETE&quot;, 3)。
      * @param string triggerTable  触发表
      * @param string triggerStatement  触发器定义。
      */

  triggerInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  triggerInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.triggerName !== undefined && opts.triggerName !== null) {
      postBody['triggerName'] = opts.triggerName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call triggerInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/trigger:info',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  用户管理列表
      * @param {Object} opts - parameters
      * @param {} [opts.activeStatus] - 查询的用户状态(启用(true),禁用(false))  optional
      * @param {} [opts.role] - 查询的用户角色,枚举值(Admin(&quot;Admin&quot;,&quot;管理员&quot;),DBA(&quot;DBA&quot;,&quot;DBA&quot;),StructureReadOnly(&quot;StructureReadOnly&quot;,&quot;结构只读&quot;),Normal(&quot;Normal&quot;,&quot;普通用户&quot;))  optional
      * @param {} [opts.loginDateStart] - 查询的用户登录开始时间(yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;)  optional
      * @param {} [opts.loginDateEnd] - 查询的用户登录结束时间(yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;)  optional
      * @param {} [opts.username] - 查询用户的用户名称  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  符合条件的用户的总数
      * @param dmsUserVO dmsUserVOList
      */

  queryUserList (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.activeStatus !== undefined && opts.activeStatus !== null) {
      postBody['activeStatus'] = opts.activeStatus
    }
    if (opts.role !== undefined && opts.role !== null) {
      postBody['role'] = opts.role
    }
    if (opts.loginDateStart !== undefined && opts.loginDateStart !== null) {
      postBody['loginDateStart'] = opts.loginDateStart
    }
    if (opts.loginDateEnd !== undefined && opts.loginDateEnd !== null) {
      postBody['loginDateEnd'] = opts.loginDateEnd
    }
    if (opts.username !== undefined && opts.username !== null) {
      postBody['username'] = opts.username
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUserList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:queryUserList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取主账号下未同步的子账号数据
      * @param {Object} opts - parameters
      * @param {} [opts.pageNumber] - 第几页,不传的话会将当前所有的未同步的账号都同步过来  optional
      * @param {} [opts.pageSize] - 页大小。  optional
      * @param {} [opts.keyword] - 关键字。  optional
      * @param {} [opts.sort] - 排序规则：0-创建时间顺序排序，1-创建时间倒序排序。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  子账号总数量
      * @param dmsSubUserVO subUserList
      */

  queryUserNotSync (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      postBody['keyword'] = opts.keyword
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      postBody['sort'] = opts.sort
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryUserNotSync with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:queryUserNotSync',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  同步子账号
      * @param {Object} opts - parameters
      * @param {} [opts.dmsSyncSubUserVOList] - 同步的子账号的列表信息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  syncSubUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (
      opts.dmsSyncSubUserVOList !== undefined &&
      opts.dmsSyncSubUserVOList !== null
    ) {
      postBody['dmsSyncSubUserVOList'] = opts.dmsSyncSubUserVOList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call syncSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:syncSubUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新用户信息
      * @param {Object} opts - parameters
      * @param {} [opts.pin] - 被更新用户的pin信息  optional
      * @param {} [opts.phone] - 用户手机号码  optional
      * @param {} [opts.email] - 用户邮箱  optional
      * @param {} [opts.roleList] - 用户角色列表信息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateUserInfo (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.roleList !== undefined && opts.roleList !== null) {
      postBody['roleList'] = opts.roleList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateUserInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:updateUserInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用/禁用用户
      * @param {Object} opts - parameters
      * @param {} [opts.dmsUserEnableVOList] - 启用/禁用的用户列表信息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  enableUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (
      opts.dmsUserEnableVOList !== undefined &&
      opts.dmsUserEnableVOList !== null
    ) {
      postBody['dmsUserEnableVOList'] = opts.dmsUserEnableVOList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:enableUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户
      * @param {Object} opts - parameters
      * @param {} [opts.dmsUserDeleteList] - 删除用户的pin信息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (
      opts.dmsUserDeleteList !== undefined &&
      opts.dmsUserDeleteList !== null
    ) {
      postBody['dmsUserDeleteList'] = opts.dmsUserDeleteList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:deleteUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户信息
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean isMaster  是否是主账号
      * @param string username  用户名
      * @param string pin  用户pin
      * @param string masterPin  用户主账号pin
      * @param integer accountId  用户账号Id
      * @param string roleList
      */

  getUserInfo (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getUserInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:getUserInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  用户授权信息列表
      * @param {Object} opts - parameters
      * @param {} [opts.instanceId] - 实例ID  optional
      * @param {} [opts.instanceName] - 实例名称  optional
      * @param {} [opts.pin] - 用户账号  optional
      * @param {} [opts.showNormal] - 是否只显示生效中的授权信息  optional
      * @param {} [opts.releaseStatus] - 是否只显示释放的记录,true展示释放权限的记录  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  符合条件的用户的总数
      * @param boolean isAdmin  如果为真则表示这个账号默认就拥有所有的实例登录权限
      * @param dmsPrivilegeVO dmsPrivilegeVOList
      */

  queryPrivilegeList (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      postBody['instanceId'] = opts.instanceId
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.showNormal !== undefined && opts.showNormal !== null) {
      postBody['showNormal'] = opts.showNormal
    }
    if (opts.releaseStatus !== undefined && opts.releaseStatus !== null) {
      postBody['releaseStatus'] = opts.releaseStatus
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPrivilegeList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:queryPrivilegeList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看当前用户授权信息列表
      * @param {Object} opts - parameters
      * @param {} [opts.instanceId] - 实例ID  optional
      * @param {} [opts.instanceName] - 实例名称  optional
      * @param {} [opts.showNormal] - 是否只显示生效中的授权信息  optional
      * @param {} [opts.releaseStatus] - 是否只显示释放的记录,true展示释放权限的记录  optional
      * @param {} [opts.pageNumber] - 显示数据的页码，取值范围：[1,∞)。pageNumber为Null时，返回所有数据页码；超过总页数时，无数据。  optional
      * @param {} [opts.pageSize] - 每页显示的数据条数，用于查询列表的接口。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer count  符合条件的用户的总数
      * @param boolean isAdmin  如果为真则表示这个账号默认就拥有所有的实例登录权限
      * @param dmsPrivilegeVO dmsPrivilegeVOList
      */

  queryPrivilegeSelfList (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      postBody['instanceId'] = opts.instanceId
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (opts.showNormal !== undefined && opts.showNormal !== null) {
      postBody['showNormal'] = opts.showNormal
    }
    if (opts.releaseStatus !== undefined && opts.releaseStatus !== null) {
      postBody['releaseStatus'] = opts.releaseStatus
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPrivilegeSelfList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:queryPrivilegeSelfList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  释放权限
      * @param {Object} opts - parameters
      * @param {} [opts.idList] - 授权实例记录对应的主键ID  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  releasePrivilege (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.idList !== undefined && opts.idList !== null) {
      postBody['idList'] = opts.idList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call releasePrivilege with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:releasePrivilege',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  实例授权
      * @param {Object} opts - parameters
      * @param {} [opts.pinList] - 用户pin列表信息  optional
      * @param {} [opts.privilegeName] - 权限名称,枚举值：PrivilegeLogin(实例登录权限)  optional
      * @param {} [opts.expireDate] - 授权过期时间(yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;)  optional
      * @param {} [opts.dmsPrivilegeInstanceParamList] - 授权实例的信息，主要包括用户实例ID和实例名称  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  authPrivilege (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.pinList !== undefined && opts.pinList !== null) {
      postBody['pinList'] = opts.pinList
    }
    if (opts.privilegeName !== undefined && opts.privilegeName !== null) {
      postBody['privilegeName'] = opts.privilegeName
    }
    if (opts.expireDate !== undefined && opts.expireDate !== null) {
      postBody['expireDate'] = opts.expireDate
    }
    if (
      opts.dmsPrivilegeInstanceParamList !== undefined &&
      opts.dmsPrivilegeInstanceParamList !== null
    ) {
      postBody['dmsPrivilegeInstanceParamList'] =
        opts.dmsPrivilegeInstanceParamList
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call authPrivilege with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:authPrivilege',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改权限到期时间
      * @param {Object} opts - parameters
      * @param {} [opts.idList] - 授权实例记录对应的主键ID  optional
      * @param {} [opts.expireDate] - 授权过期时间(yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;)  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyPrivilegeExpireDate (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.idList !== undefined && opts.idList !== null) {
      postBody['idList'] = opts.idList
    }
    if (opts.expireDate !== undefined && opts.expireDate !== null) {
      postBody['expireDate'] = opts.expireDate
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyPrivilegeExpireDate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/management:modifyPrivilegeExpireDate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生产创建视图SQL语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id。  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.viewName] - 视图名称。  optional
      * @param {} [opts.viewAlgorithm] - 视图算法，DEFAULT(&quot;DEFAULT&quot;, 1),UNDEFINED(&quot;UNDEFINED&quot;, 2), MERGE(&quot;MERGE&quot;, 3), TEMPTABLE(&quot;TEMPTABLE&quot;, 4);  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.viewSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.viewCheckOption] - 检查选项，DEFAULT(&quot;DEFAULT&quot;, 1),LOCAL(&quot;LOCAL&quot;, 2), CASCADED(&quot;CASCADED&quot;, 3);;  optional
      * @param {} [opts.definitionSql] - 视图定义。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalCreateView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalCreateView"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      postBody['viewName'] = opts.viewName
    }
    if (opts.viewAlgorithm !== undefined && opts.viewAlgorithm !== null) {
      postBody['viewAlgorithm'] = opts.viewAlgorithm
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (opts.viewSecurity !== undefined && opts.viewSecurity !== null) {
      postBody['viewSecurity'] = opts.viewSecurity
    }
    if (opts.viewCheckOption !== undefined && opts.viewCheckOption !== null) {
      postBody['viewCheckOption'] = opts.viewCheckOption
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalCreateView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/view:generalCreate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成修改视图sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.viewName] - 视图名称。  optional
      * @param {} [opts.originViewName] - 原始视图名称。  optional
      * @param {} [opts.viewAlgorithm] - 视图算法，DEFAULT(&quot;DEFAULT&quot;, 1),UNDEFINED(&quot;UNDEFINED&quot;, 2), MERGE(&quot;MERGE&quot;, 3), TEMPTABLE(&quot;TEMPTABLE&quot;, 4);  optional
      * @param {} [opts.definer] - 定义者。  optional
      * @param {} [opts.viewSecurity] - 安全性，DEFAULT(&quot;DEFAULT&quot;, 1),DEFINER(&quot;DEFINER&quot;, 2), INVOKER(&quot;INVOKER&quot;, 3);  optional
      * @param {} [opts.viewCheckOption] - 检查选项，DEFAULT(&quot;DEFAULT&quot;, 1),LOCAL(&quot;LOCAL&quot;, 2), CASCADED(&quot;CASCADED&quot;, 3);;  optional
      * @param {} [opts.definitionSql] - 视图定义。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalAlterView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalAlterView"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      postBody['viewName'] = opts.viewName
    }
    if (opts.originViewName !== undefined && opts.originViewName !== null) {
      postBody['originViewName'] = opts.originViewName
    }
    if (opts.viewAlgorithm !== undefined && opts.viewAlgorithm !== null) {
      postBody['viewAlgorithm'] = opts.viewAlgorithm
    }
    if (opts.definer !== undefined && opts.definer !== null) {
      postBody['definer'] = opts.definer
    }
    if (opts.viewSecurity !== undefined && opts.viewSecurity !== null) {
      postBody['viewSecurity'] = opts.viewSecurity
    }
    if (opts.viewCheckOption !== undefined && opts.viewCheckOption !== null) {
      postBody['viewCheckOption'] = opts.viewCheckOption
    }
    if (opts.definitionSql !== undefined && opts.definitionSql !== null) {
      postBody['definitionSql'] = opts.definitionSql
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalAlterView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/view:generalAlter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成删除视图sql语句，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.viewName] - 视图名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param dmsSql dmsSqls
      */

  generalDropView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  generalDropView"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      postBody['viewName'] = opts.viewName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call generalDropView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/view:generalDrop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视图详情，支持Mysql
      * @param {Object} opts - parameters
      * @param {} [opts.dataSourceId] - 数据源id  optional
      * @param {} [opts.dbName] - 数据库名称。  optional
      * @param {} [opts.viewName] - 视图名称。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dbName  数据库名称。
      * @param string viewName  视图名称。
      * @param string definer  定义者。
      * @param string viewAlgorithm  算法。
      * @param string viewCheckOption  检查选项。
      * @param string viewSecurity  安全性。
      * @param string definitionSql  视图定义。
      */

  viewInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  viewInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.dataSourceId !== undefined && opts.dataSourceId !== null) {
      postBody['dataSourceId'] = opts.dataSourceId
    }
    if (opts.dbName !== undefined && opts.dbName !== null) {
      postBody['dbName'] = opts.dbName
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      postBody['viewName'] = opts.viewName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call viewInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/view:info',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = DMS
