/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Domain-Template
 * 域名模板相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'domain'
Service._services[serviceId] = true

/**
 * domain service.
 * @version 1.0.0
 */

class DOMAIN extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'domain.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  检查域名是否可以注册
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要检查的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param checkDomain data  检查域名的返回结果
      */

  checkDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkDomain"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling checkDomain"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:check',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名的whois信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要检查的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainWhoisInfo data  域名Whois返回结果
      */

  queryWhoisInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryWhoisInfo"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling queryWhoisInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryWhoisInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:whoisInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户的域名信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要注册的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainInfo data  域名信息返回结果
      */

  domainInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  domainInfo"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling domainInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call domainInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名注册
域名注册前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情

      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 域名
      * @param {integer} opts.term - 注册年限，最多10年
      * @param {integer} opts.templateId - 模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainOrder data  域名购买返回结果，后续需要调用订单支付接口
      */

  createDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createDomain"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling createDomain"
      )
    }
    if (opts.term === undefined || opts.term === null) {
      throw new Error(
        "Missing the required parameter 'opts.term' when calling createDomain"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling createDomain"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.term !== undefined && opts.term !== null) {
      postBody['term'] = opts.term
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  针对用户的域名进行续费
域名续费前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情

      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 域名
      * @param {integer} opts.term - 续费年限，最多10年
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainOrder data  域名续费返回结果，后续需要调用订单支付接口
      */

  renewDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  renewDomain"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling renewDomain"
      )
    }
    if (opts.term === undefined || opts.term === null) {
      throw new Error(
        "Missing the required parameter 'opts.term' when calling renewDomain"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.term !== undefined && opts.term !== null) {
      postBody['term'] = opts.term
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call renewDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/renew',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名转入状态查询
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要转入的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer transferInState  转入状态：0转入失败 1验证邮箱 2转入处理中 3转入成功
      */

  transferinDomainState (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  transferinDomainState"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling transferinDomainState"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call transferinDomainState with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/transferin',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  用于提交域名转入操作
要转入域名前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情

      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 域名
      * @param {string} opts.passWord - 域名转移密码
      * @param {integer} opts.templateId - 模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainOrder data  域名转入返回结果，后续需要调用订单支付接口，待支付完成后，查询域名转入进度
      */

  transferinDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  transferinDomain"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling transferinDomain"
      )
    }
    if (opts.passWord === undefined || opts.passWord === null) {
      throw new Error(
        "Missing the required parameter 'opts.passWord' when calling transferinDomain"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling transferinDomain"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.passWord !== undefined && opts.passWord !== null) {
      postBody['passWord'] = opts.passWord
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call transferinDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/transferin',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据域名修改域名对应的 DNS 信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要修改的域名
      * @param {array} [opts.dns] - 要修改的DNS,个数要求再2个-6个之间  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyDns (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyDns"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling modifyDns"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.dns !== undefined && opts.dns !== null) {
      postBody['dns'] = opts.dns
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyDns with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:dns',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  通过已实名的信息模板，完成域名的快速过户
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要修改的域名
      * @param {integer} opts.templateId - 要过户的模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  domainTemplateAssigned (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  domainTemplateAssigned"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling domainTemplateAssigned"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling domainTemplateAssigned"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call domainTemplateAssigned with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:assigned',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名锁定，设置域名状态为禁止转移
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要修改的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  domainLock (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  domainLock"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling domainLock"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call domainLock with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:lock',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名解锁，，取消域名禁止转移的状态
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要修改的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  domainUnLock (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  domainUnLock"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling domainUnLock"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call domainUnLock with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:unlock',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取转移密码，用于域名转移注册商转出获取域名转移密码
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 要修改的域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string passWord  获取的转移密码，如果转移密码为空，则表示邮件已发送至域名对应的模板中的邮箱中
      */

  getDomainTransferOutPassWord (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomainTransferOutPassWord"
      )
    }

    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling getDomainTransferOutPassWord"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainTransferOutPassWord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/domain:transferOut',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建域名信息模板
      * @param {Object} opts - parameters
      * @param {string} [opts.userNameCh] - 联系人姓名(中文),必填,必须含有中文,只允许输入特殊字符(.,、·()()-&quot;&quot;“”/\&#39;),最多可输入64 字符  optional
      * @param {string} [opts.userNameEn1] - 联系人姓(英文),必填,必须含有英文,只允许输入特殊字符(.,、·()()-&quot;&quot;“”/\&#39;),最多可输入64 字符  optional
      * @param {string} [opts.userNameEn2] - 联系人名(英文),必填,必须含有英文,只允许输入特殊字符(.,、·()()-&quot;&quot;“”/\&#39;),最多可输入64 字符  optional
      * @param {string} [opts.ownerNameCh] - 域名所有者或所有者单位名称(中文),必填,必须含有中文,只允许输入特殊字符(.,、·()()-&quot;&quot;“”/\&#39;),最多可输入64 字符  optional
      * @param {string} [opts.ownerNameEn] - 域名所有者或所有者单位名称(英文),必填,必须含有中文,只允许输入特殊字符(.,、·()()-&quot;&quot;“”/\&#39;),最多可输入64 字符  optional
      * @param {string} [opts.nationCodeCh] - 国家及地区（中文）  optional
      * @param {string} [opts.nationCodeEn] - 国家及地区（英文）  optional
      * @param {string} [opts.provinceCodeCh] - 省份（中文）  optional
      * @param {string} [opts.provinceCodeEn] - 省份（英文）  optional
      * @param {string} [opts.cityCodeCh] - 城市（中文）  optional
      * @param {string} [opts.cityCodeEn] - 城市（英文）  optional
      * @param {string} [opts.addressCh] - 通信地址（中文）  optional
      * @param {string} [opts.addressEn] - 通信地址（英文）  optional
      * @param {string} [opts.zipCode] - 邮编 6位数字  optional
      * @param {string} [opts.phone] - 联系电话，国家区号-地区区号(或手机号码前3位)-电话号码（或手机号码后8位) 例:86-138-12345678  optional
      * @param {string} [opts.fax] - 传真，国家区号-地区区号(或手机号码前3位)-电话号码（或手机号码后8位) 例:86-138-12345678  optional
      * @param {string} [opts.email] - 邮件  optional
      * @param {integer} [opts.ownerType] - 所有者类型  1个人 2企业  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer templateId  模板Id
      */

  createTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.userNameCh !== undefined && opts.userNameCh !== null) {
      postBody['userNameCh'] = opts.userNameCh
    }
    if (opts.userNameEn1 !== undefined && opts.userNameEn1 !== null) {
      postBody['userNameEn1'] = opts.userNameEn1
    }
    if (opts.userNameEn2 !== undefined && opts.userNameEn2 !== null) {
      postBody['userNameEn2'] = opts.userNameEn2
    }
    if (opts.ownerNameCh !== undefined && opts.ownerNameCh !== null) {
      postBody['ownerNameCh'] = opts.ownerNameCh
    }
    if (opts.ownerNameEn !== undefined && opts.ownerNameEn !== null) {
      postBody['ownerNameEn'] = opts.ownerNameEn
    }
    if (opts.nationCodeCh !== undefined && opts.nationCodeCh !== null) {
      postBody['nationCodeCh'] = opts.nationCodeCh
    }
    if (opts.nationCodeEn !== undefined && opts.nationCodeEn !== null) {
      postBody['nationCodeEn'] = opts.nationCodeEn
    }
    if (opts.provinceCodeCh !== undefined && opts.provinceCodeCh !== null) {
      postBody['provinceCodeCh'] = opts.provinceCodeCh
    }
    if (opts.provinceCodeEn !== undefined && opts.provinceCodeEn !== null) {
      postBody['provinceCodeEn'] = opts.provinceCodeEn
    }
    if (opts.cityCodeCh !== undefined && opts.cityCodeCh !== null) {
      postBody['cityCodeCh'] = opts.cityCodeCh
    }
    if (opts.cityCodeEn !== undefined && opts.cityCodeEn !== null) {
      postBody['cityCodeEn'] = opts.cityCodeEn
    }
    if (opts.addressCh !== undefined && opts.addressCh !== null) {
      postBody['addressCh'] = opts.addressCh
    }
    if (opts.addressEn !== undefined && opts.addressEn !== null) {
      postBody['addressEn'] = opts.addressEn
    }
    if (opts.zipCode !== undefined && opts.zipCode !== null) {
      postBody['zipCode'] = opts.zipCode
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.fax !== undefined && opts.fax !== null) {
      postBody['fax'] = opts.fax
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.ownerType !== undefined && opts.ownerType !== null) {
      postBody['ownerType'] = opts.ownerType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名信息模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param templateInfo data  模板信息返回结果
      */

  queryTemplateInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryTemplateInfo"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling queryTemplateInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryTemplateInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改域名信息模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} [opts.nationCodeCh] - 国家及地区（中文）  optional
      * @param {string} [opts.nationCodeEn] - 国家及地区（英文）中国：china  optional
      * @param {string} [opts.provinceCodeCh] - 省份（中文）  optional
      * @param {string} [opts.provinceCodeEn] - 省份（英文）  optional
      * @param {string} [opts.cityCodeCh] - 城市（中文）  optional
      * @param {string} [opts.cityCodeEn] - 城市（英文）  optional
      * @param {string} [opts.addressCh] - 通信地址（中文）  optional
      * @param {string} [opts.addressEn] - 通信地址（英文）  optional
      * @param {string} [opts.zipCode] - 邮编 6位数字  optional
      * @param {string} [opts.phone] - 联系电话，国家区号-地区区号(或手机号码前3位)-电话号码（或手机号码后8位) 例:86-138-12345678  optional
      * @param {string} [opts.fax] - 传真，国家区号-地区区号(或手机号码前3位)-电话号码（或手机号码后8位) 例:86-138-12345678  optional
      * @param {string} [opts.email] - 邮件  optional
      * @param {integer} [opts.ownerType] - 所有者类型  1个人 2企业  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer templateId  模板Id
      */

  modifyTemplateInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyTemplateInfo"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling modifyTemplateInfo"
      )
    }

    let postBody = {}
    if (opts.nationCodeCh !== undefined && opts.nationCodeCh !== null) {
      postBody['nationCodeCh'] = opts.nationCodeCh
    }
    if (opts.nationCodeEn !== undefined && opts.nationCodeEn !== null) {
      postBody['nationCodeEn'] = opts.nationCodeEn
    }
    if (opts.provinceCodeCh !== undefined && opts.provinceCodeCh !== null) {
      postBody['provinceCodeCh'] = opts.provinceCodeCh
    }
    if (opts.provinceCodeEn !== undefined && opts.provinceCodeEn !== null) {
      postBody['provinceCodeEn'] = opts.provinceCodeEn
    }
    if (opts.cityCodeCh !== undefined && opts.cityCodeCh !== null) {
      postBody['cityCodeCh'] = opts.cityCodeCh
    }
    if (opts.cityCodeEn !== undefined && opts.cityCodeEn !== null) {
      postBody['cityCodeEn'] = opts.cityCodeEn
    }
    if (opts.addressCh !== undefined && opts.addressCh !== null) {
      postBody['addressCh'] = opts.addressCh
    }
    if (opts.addressEn !== undefined && opts.addressEn !== null) {
      postBody['addressEn'] = opts.addressEn
    }
    if (opts.zipCode !== undefined && opts.zipCode !== null) {
      postBody['zipCode'] = opts.zipCode
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.fax !== undefined && opts.fax !== null) {
      postBody['fax'] = opts.fax
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.ownerType !== undefined && opts.ownerType !== null) {
      postBody['ownerType'] = opts.ownerType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyTemplateInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名信息模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer templateId  模板Id
      */

  deleteTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteTemplate"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名信息模板实名认证状态
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer certificateState  实名认证状态 0未实名认证 1已实名认证 2审核中 3审核失败 4实名资料上传注册局失败
      * @param string certificateUnpassReason  实名认证失败原因
      */

  certificateTemplateState (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  certificateTemplateState"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling certificateTemplateState"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call certificateTemplateState with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template/{templateId}/certificate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名信息模板实名认证
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} opts.identityNo - 所有人证件号码
      * @param {string} opts.identityType - 注册人证件类型
1.个人
  (1)身份证 SFZ
2.企业
  (1)组织机构代码证 ORG
  (2)工商营业执照 YYZZ
  (3)统一社会信用代码证书 TYDMZ
  (4)部队代号 BDDH
  (5)军队单位对外有偿服务许可证 JDXKZ
  (6)事业单位法人证书 SYZS
  (7)社会团体法人登记证书 STDJZ
  (8)宗教活动场所登记证 ZJDJZ
  (9)民办非企业单位登记证书 MBDJZ
  (10)基金会法人登记证书 JJDJZ
  (11)律师事务所执业许可证 LSXKZ
  (12)登记证 GWLYDJZ
  (13)司法鉴定许可证 SFXKZ
  (14)社会服务机构登记证书 SHFWJGZ
  (15)民办学校办学许可证 MBXXXKZ
  (16)医疗机构执业许可证 YLJGXKZ

      * @param {string} opts.file - 所有人证件，jpg 图片的 base64 编码，必填（大小 55KB~1MB）
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer templateId  模板Id
      */

  certificateTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  certificateTemplate"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling certificateTemplate"
      )
    }
    if (opts.identityNo === undefined || opts.identityNo === null) {
      throw new Error(
        "Missing the required parameter 'opts.identityNo' when calling certificateTemplate"
      )
    }
    if (opts.identityType === undefined || opts.identityType === null) {
      throw new Error(
        "Missing the required parameter 'opts.identityType' when calling certificateTemplate"
      )
    }
    if (opts.file === undefined || opts.file === null) {
      throw new Error(
        "Missing the required parameter 'opts.file' when calling certificateTemplate"
      )
    }

    let postBody = {}
    if (opts.identityNo !== undefined && opts.identityNo !== null) {
      postBody['identityNo'] = opts.identityNo
    }
    if (opts.identityType !== undefined && opts.identityType !== null) {
      postBody['identityType'] = opts.identityType
    }
    if (opts.file !== undefined && opts.file !== null) {
      postBody['file'] = opts.file
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domain/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call certificateTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/template/{templateId}/certificate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = DOMAIN
