/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 实例信息
 * 云解析OpenAPI实例信息接口
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'domainservice'
Service._services[serviceId] = true

/**
 * domainservice service.
 * @version 2.0.3
 */

JDCloud.DOMAINSERVICE = class DOMAINSERVICE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'domainservice.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查看用户在云解析服务下的操作记录
      * @param {Object} opts - parameters
      * @param {integer} opts.pageNumber - 分页参数，页的序号，默认是1
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目，默认是10
      * @param {string} opts.startTime - 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} opts.endTime - 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} [opts.keyWord] - 日志需要匹配的关键词  optional
      * @param {boolean} [opts.success] - 日志里面的结果是成功还是失败  optional
      * @param {integer} [opts.type] - 日志的类型  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param actionlog dataList
      * @param integer currentCount  当前页的操作记录列表里的个数
      * @param integer totalCount  所有操作记录的个数
      * @param integer totalPage  操作记录列表按照分页参数一共的页数
      */

  describeActionLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeActionLog"
      )
    }

    opts = opts || {}

    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describeActionLog"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeActionLog"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeActionLog"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling describeActionLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.keyWord !== undefined && opts.keyWord !== null) {
      queryParams['keyWord'] = opts.keyWord
    }
    if (opts.success !== undefined && opts.success !== null) {
      queryParams['success'] = opts.success
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeActionLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/actionLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户所属的主域名列表。
请在调用域名相关的接口之前，调用此接口获取相关的domainId和domainName。
主域名的相关概念，请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/product-overview&quot;&gt;云解析文档&lt;/a&gt;

      * @param {Object} opts - parameters
      * @param {integer} opts.pageNumber - 分页查询时查询的每页的序号，起始值为1，默认为1
      * @param {integer} opts.pageSize - 分页查询时设置的每页行数，默认为10
      * @param {string} [opts.domainName] - 关键字，按照”%domainName%”模式匹配主域名  optional
      * @param {integer} [opts.domainId] - 域名ID。不为0时，只查此domainId的域名  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainInfo dataList
      * @param integer currentCount  当前页的域名列表里域名的个数
      * @param integer totalCount  所有匹配的域名列表的个数
      * @param integer totalPage  所有匹配的域名列表按照分页参数一共的页数
      */

  describeDomains (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDomains"
      )
    }

    opts = opts || {}

    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describeDomains"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeDomains"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.domainId !== undefined && opts.domainId !== null) {
      queryParams['domainId'] = opts.domainId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名
如何添加免费域名，详细情况请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/domainadd&quot;&gt;文档&lt;/a&gt;
添加收费域名，请查阅&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/jd-cloud-dns/purchase-process&quot;&gt;文档&lt;/a&gt;，
添加收费域名前，请确保用户的京东云账户有足够的资金支付，Openapi接口回返回订单号，可以用此订单号向计费系统查阅详情。

      * @param {Object} opts - parameters
      * @param {integer} opts.packId - 主域名的套餐类型, 免费:0 企业版:1 企业高级版:2
      * @param {string} opts.domainName - 要添加的主域名
      * @param {integer} [opts.domainId] - 主域名的ID，升级套餐必填，请使用describeDomains获取  optional
      * @param {integer} [opts.buyType] - 新购买:1、升级:3，收费套餐的域名必填  optional
      * @param {integer} [opts.timeSpan] - 取值1，2，3 ，含义：时长，收费套餐的域名必填  optional
      * @param {integer} [opts.timeUnit] - 时间单位，收费套餐的域名必填，1：小时，2：天，3：月，4：年  optional
      * @param {integer} [opts.billingType] - 计费类型，可以不传此参数。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param domainAdded data  新添加的的域名结构
      * @param string order  添加收费版域名的订单号
      */

  createDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createDomain"
      )
    }

    opts = opts || {}

    if (opts.packId === undefined || opts.packId === null) {
      throw new Error(
        "Missing the required parameter 'opts.packId' when calling createDomain"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling createDomain"
      )
    }

    let postBody = {}
    if (opts.packId !== undefined && opts.packId !== null) {
      postBody['packId'] = opts.packId
    }
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }
    if (opts.domainId !== undefined && opts.domainId !== null) {
      postBody['domainId'] = opts.domainId
    }
    if (opts.buyType !== undefined && opts.buyType !== null) {
      postBody['buyType'] = opts.buyType
    }
    if (opts.timeSpan !== undefined && opts.timeSpan !== null) {
      postBody['timeSpan'] = opts.timeSpan
    }
    if (opts.timeUnit !== undefined && opts.timeUnit !== null) {
      postBody['timeUnit'] = opts.timeUnit
    }
    if (opts.billingType !== undefined && opts.billingType !== null) {
      postBody['billingType'] = opts.billingType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改主域名
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.domainName - 需要修改的主域名，请使用describeDomains接口获取
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyDomain"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling modifyDomain"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling modifyDomain"
      )
    }

    let postBody = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      postBody['domainName'] = opts.domainName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteDomain"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteDomain"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看主域名的解析次数
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.domainName - 查询的主域名，请使用describeDomains接口获取
      * @param {string} opts.start - 查询时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 查询时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param integer traffic
      */

  describeDomainQueryCount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDomainQueryCount"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeDomainQueryCount"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeDomainQueryCount"
      )
    }
    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling describeDomainQueryCount"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling describeDomainQueryCount"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDomainQueryCount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/queryCount',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看域名的查询流量
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.domainName - 主域名，请使用describeDomains接口获取
      * @param {string} opts.start - 时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param string unit  数据序列的单位
      * @param number traffic
      */

  describeDomainQueryTraffic (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDomainQueryTraffic"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeDomainQueryTraffic"
      )
    }
    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeDomainQueryTraffic"
      )
    }
    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling describeDomainQueryTraffic"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling describeDomainQueryTraffic"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDomainQueryTraffic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/queryTraffic',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的解析记录。
在使用解析记录相关的接口之前，请调用此接口获取解析记录的列表。

      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} [opts.pageNumber] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数, 默认为10  optional
      * @param {string} [opts.search] - 关键字，按照”%search%”模式匹配解析记录的主机记录  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rRInfo dataList
      * @param integer totalCount  所有解析记录的个数
      * @param integer totalPage  所有解析记录的页数
      * @param integer currentCount  当前页解析记录的个数
      */

  describeResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeResourceRecord"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.search !== undefined && opts.search !== null) {
      queryParams['search'] = opts.search
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/ResourceRecord',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {addRR} opts.req - RR参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param rR dataList  添加成功后的解析记录结果
      */

  createResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling createResourceRecord"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling createResourceRecord"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/ResourceRecord',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改主域名的某个解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.resourceRecordId - 解析记录ID，请使用describeResourceRecord接口获取。
      * @param {updateRR} opts.req - updateRR参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling modifyResourceRecord"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling modifyResourceRecord"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling modifyResourceRecord"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/ResourceRecord/{resourceRecordId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名下的解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.resourceRecordId - 解析记录ID，请使用describeResourceRecord接口获取。
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteResourceRecord"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling deleteResourceRecord"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/ResourceRecord/{resourceRecordId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用、停用主域名下的解析记录
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.resourceRecordId - 解析记录ID，请使用describeResourceRecord接口获取。
      * @param {string} opts.action - 要修改的状态，enable:启用 disable:停用
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyResourceRecordStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyResourceRecordStatus"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling modifyResourceRecordStatus"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling modifyResourceRecordStatus"
      )
    }
    if (opts.action === undefined || opts.action === null) {
      throw new Error(
        "Missing the required parameter 'opts.action' when calling modifyResourceRecordStatus"
      )
    }

    let postBody = {}
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyResourceRecordStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/ResourceRecord/{resourceRecordId}/status',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询云解析所有的基础解析线路。
在使用解析线路的参数之前，请调用此接口获取解析线路的ID。

      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} [opts.loadMode] - 展示方式，暂时不使用  optional
      * @param {integer} opts.packId - 套餐ID，0-&gt;免费版 1-&gt;企业版 2-&gt;企业高级版
      * @param {integer} opts.viewId - view ID，默认为-1
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param viewTree data
      */

  describeViewTree (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeViewTree"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeViewTree"
      )
    }
    if (opts.packId === undefined || opts.packId === null) {
      throw new Error(
        "Missing the required parameter 'opts.packId' when calling describeViewTree"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling describeViewTree"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.loadMode !== undefined && opts.loadMode !== null) {
      queryParams['loadMode'] = opts.loadMode
    }
    if (opts.packId !== undefined && opts.packId !== null) {
      queryParams['packId'] = opts.packId
    }
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeViewTree with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/viewTree',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  同一个主域名下，批量新增或者批量更新导入解析记录。
如果解析记录的ID为0，是新增解析记录，如果不为0，则是更新解析记录。

      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {array} [opts.req] - 需要设置的解析记录列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  batchSetResourceRecords (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  batchSetResourceRecords"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling batchSetResourceRecords"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSetResourceRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/BatchSetResourceRecords',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} opts.viewId - 自定义线路ID
      * @param {string} [opts.viewName] - 自定义线路名称, 最多64个字节，允许：数字、字母、下划线，-，中文  optional
      * @param {integer} opts.pageNumber - 分页参数，页的序号
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userViewInput dataList
      * @param integer currentCount  当前页的自定义线路列表里的个数
      * @param integer totalCount  所有自定义线路列表的个数
      * @param integer totalPage  所有自定义线路列表按照分页参数一共的页数
      */

  describeUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUserView"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeUserView"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling describeUserView"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describeUserView"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeUserView"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      queryParams['viewName'] = opts.viewName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/UserView',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {addView} opts.req - 添加自定义线路的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userview data  添加成功后返回的自定义线路的结构
      */

  createUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createUserView"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling createUserView"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling createUserView"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/UserView',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名的自定义解析线路
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {delView} opts.req - 删除自定义线路的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUserView (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteUserView"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteUserView"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling deleteUserView"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUserView with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/DeleteUserView',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} opts.viewId - 自定义线路ID
      * @param {string} [opts.viewName] - 自定义线路名称, 最多64个字节，允许：数字、字母、下划线，-，中文  optional
      * @param {integer} opts.pageNumber - 分页参数，页的序号, 默认为1
      * @param {integer} opts.pageSize - 分页参数，每页含有的结果的数目，默认为10
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string dataList
      * @param integer currentCount  当前页的IP列表里的个数
      * @param integer totalCount  IP列表里的IP段的个数
      * @param integer totalPage  IP列表按照分页参数一共的页数
      */

  describeUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeUserViewIP"
      )
    }
    if (opts.viewId === undefined || opts.viewId === null) {
      throw new Error(
        "Missing the required parameter 'opts.viewId' when calling describeUserViewIP"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describeUserViewIP"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeUserViewIP"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.viewId !== undefined && opts.viewId !== null) {
      queryParams['viewId'] = opts.viewId
    }
    if (opts.viewName !== undefined && opts.viewName !== null) {
      queryParams['viewName'] = opts.viewName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/UserViewIP',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {addViewIP} opts.req - 添加域名的自定义解析线路的IP段的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling createUserViewIP"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling createUserViewIP"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/UserViewIP',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主域名的自定义解析线路的IP段
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {delViewIP} opts.req - 删除域名的自定义解析线路的IP段的参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUserViewIP (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteUserViewIP"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteUserViewIP"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling deleteUserViewIP"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUserViewIP with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/DeleteUserViewIP',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看主域名的监控项的配置以及状态
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} [opts.pageIndex] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数  optional
      * @param {string} [opts.searchValue] - 查询的值  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer currentCount  当前页面网站监控项的个数
      * @param integer totalCount  所有网站监控项的个数
      * @param integer totalPage  所有网站监控项的页数
      * @param monitor dataList
      */

  describeMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeMonitor"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.searchValue !== undefined && opts.searchValue !== null) {
      queryParams['searchValue'] = opts.searchValue
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子域名的监控项，默认把子域名的所有监控项都添加上监控
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling createMonitor"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling createMonitor"
      )
    }

    let postBody = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      postBody['subDomainName'] = opts.subDomainName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名的监控项修改
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {updateMonitor} opts.updateMonitor - 监控项设置信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling modifyMonitor"
      )
    }
    if (opts.updateMonitor === undefined || opts.updateMonitor === null) {
      throw new Error(
        "Missing the required parameter 'opts.updateMonitor' when calling modifyMonitor"
      )
    }

    let postBody = {}
    if (opts.updateMonitor !== undefined && opts.updateMonitor !== null) {
      postBody['updateMonitor'] = opts.updateMonitor
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子域名的可用监控对象
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  describeMonitorTarget (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeMonitorTarget"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeMonitorTarget"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling describeMonitorTarget"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      queryParams['subDomainName'] = opts.subDomainName
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMonitorTarget with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorTarget',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子域名的某些特定监控对象为监控项
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.subDomainName - 子域名
      * @param {array} [opts.targets] - 子域名可用监控对象的数组  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createMonitorTarget (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createMonitorTarget"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling createMonitorTarget"
      )
    }
    if (opts.subDomainName === undefined || opts.subDomainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.subDomainName' when calling createMonitorTarget"
      )
    }

    let postBody = {}
    if (opts.subDomainName !== undefined && opts.subDomainName !== null) {
      postBody['subDomainName'] = opts.subDomainName
    }
    if (opts.targets !== undefined && opts.targets !== null) {
      postBody['targets'] = opts.targets
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createMonitorTarget with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorTarget',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  监控项的操作集合，包括：暂停，启动, 手动恢复, 手动切换
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.monitorId - 监控项ID，请使用describeMonitor接口获取。
      * @param {string} opts.action - 暂停stop, 开启start, 手动恢复recover，手动切换switch，手动恢复和手动切换时候不支持批量操作
      * @param {string} [opts.switchTarget] - 监控项的主机值, 手动切换时必填  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyMonitorStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyMonitorStatus"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling modifyMonitorStatus"
      )
    }
    if (opts.monitorId === undefined || opts.monitorId === null) {
      throw new Error(
        "Missing the required parameter 'opts.monitorId' when calling modifyMonitorStatus"
      )
    }
    if (opts.action === undefined || opts.action === null) {
      throw new Error(
        "Missing the required parameter 'opts.action' when calling modifyMonitorStatus"
      )
    }

    let postBody = {}
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (opts.switchTarget !== undefined && opts.switchTarget !== null) {
      postBody['switchTarget'] = opts.switchTarget
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId,
      monitorId: opts.monitorId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyMonitorStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor/{monitorId}/status',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  监控项的删除
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {string} opts.monitorId - 监控项ID，请使用describeMonitor接口获取。
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteMonitor (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteMonitor"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteMonitor"
      )
    }
    if (opts.monitorId === undefined || opts.monitorId === null) {
      throw new Error(
        "Missing the required parameter 'opts.monitorId' when calling deleteMonitor"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId,
      monitorId: opts.monitorId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteMonitor with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitor/{monitorId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  主域名的监控项的报警信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainId - 域名ID，请使用describeDomains接口获取。
      * @param {integer} [opts.pageIndex] - 当前页数，起始值为1，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页查询时设置的每页行数  optional
      * @param {string} [opts.searchValue] - 关键字  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer currentCount  当前页面报警信息的个数
      * @param integer totalCount  所有报警信息的个数
      * @param integer totalPage  所有报警信息的页数
      * @param monitorAlarmInfo dataList
      */

  describeMonitorAlarm (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeMonitorAlarm"
      )
    }

    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling describeMonitorAlarm"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.searchValue !== undefined && opts.searchValue !== null) {
      queryParams['searchValue'] = opts.searchValue
    }

    let pathParams = {
      regionId: regionId,
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  domainservice/2.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMonitorAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/domain/{domainId}/monitorAlarm',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.DOMAINSERVICE
