/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 数据传输服务
 * 数据传输服务相关接口
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'dts'
Service._services[serviceId] = true

/**
 * dts service.
 * @version 2.2.0
 */

class DTS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'dts.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  批量操作数据传输任务
      * @param {Object} opts - parameters
      * @param {} [opts.operateType] - 操作类型：start - 启动任务，stop - 停止任务，delete - 删除任务，resume - 恢复任务，suspend - 暂停任务  optional
      * @param {} [opts.ids] - 任务ID列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object details
      * @param string orderId  订单ID
      */

  batchOperateTasks (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  batchOperateTasks"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.operateType !== undefined && opts.operateType !== null) {
      postBody['operateType'] = opts.operateType
    }
    if (opts.ids !== undefined && opts.ids !== null) {
      postBody['ids'] = opts.ids
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchOperateTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dtsbatch',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询数据传输任务信息
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认为1，取值范围：-1，[1,∞)；-1时返回全部页码。  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[1, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {tagFilter} [opts.tagFilters] - Tag筛选条件  optional
      * @param {sort} [opts.sorts] - createTime - 创建时间,asc（正序），desc（倒序）
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param transmissionTask dts
      * @param integer totalCount  总记录数
      */

  describeTransmissionTasks (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTransmissionTasks"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(
      queryParams,
      super.buildTagFilterParam(opts.tagFilters, 'tagFilters')
    )
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTransmissionTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建数据传输任务
      * @param {Object} opts - parameters
      * @param {} [opts.transmissionMethod] - 实例类型，取值为：Sync：同步、Subscribe：订阅、Migration：迁移、DisasterRecovery 灾备，默认取值为：Sync  optional
      * @param {} [opts.topology] - 数据传输拓扑，支持：oneway - 单向数据传输、bidirectional - 双向数据传输，默认取值为：oneway  optional
      * @param {} opts.vpc - 数据传输实例所属VPC。
      * @param {} opts.subnet - 数据传输实例所属子网。
      * @param {} [opts.availableZone] - 数据传输实例所属可用区，可选  optional
      * @param {} opts.instanceClass - 数据传输实例规格，支持：dts.m1.medium、dts.m1.large、dts.m1.xlarge
      * @param {} opts.chargeSpec - 计费方式，数据传输支持包年包月、按配置计费。
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string id  任务ID
      * @param string orderId  订单ID
      */

  createTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.vpc === undefined || opts.vpc === null) {
      throw new Error(
        "Missing the required parameter 'opts.vpc' when calling createTransmissionTask"
      )
    }
    if (opts.subnet === undefined || opts.subnet === null) {
      throw new Error(
        "Missing the required parameter 'opts.subnet' when calling createTransmissionTask"
      )
    }
    if (opts.instanceClass === undefined || opts.instanceClass === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceClass' when calling createTransmissionTask"
      )
    }
    if (opts.chargeSpec === undefined || opts.chargeSpec === null) {
      throw new Error(
        "Missing the required parameter 'opts.chargeSpec' when calling createTransmissionTask"
      )
    }

    let postBody = {}
    if (
      opts.transmissionMethod !== undefined &&
      opts.transmissionMethod !== null
    ) {
      postBody['transmissionMethod'] = opts.transmissionMethod
    }
    if (opts.topology !== undefined && opts.topology !== null) {
      postBody['topology'] = opts.topology
    }
    if (opts.vpc !== undefined && opts.vpc !== null) {
      postBody['vpc'] = opts.vpc
    }
    if (opts.subnet !== undefined && opts.subnet !== null) {
      postBody['subnet'] = opts.subnet
    }
    if (opts.availableZone !== undefined && opts.availableZone !== null) {
      postBody['availableZone'] = opts.availableZone
    }
    if (opts.instanceClass !== undefined && opts.instanceClass !== null) {
      postBody['instanceClass'] = opts.instanceClass
    }
    if (opts.chargeSpec !== undefined && opts.chargeSpec !== null) {
      postBody['chargeSpec'] = opts.chargeSpec
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询数据传输任务信息
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param transmissionTaskAttribute dts
      */

  describeTransmissionTaskAttributes (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTransmissionTaskAttributes"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeTransmissionTaskAttributes"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTransmissionTaskAttributes with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling deleteTransmissionTask"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取预检查结果
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string status  任务状态
      * @param object items
      */

  describePreCheckResult (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePreCheckResult"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describePreCheckResult"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePreCheckResult with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/precheck',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  预检查传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  preCheckTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  preCheckTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling preCheckTransmissionTask"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call preCheckTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/precheck',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  跳过预检查项目
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} opts.itemName - 跳过的项目名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string status  数据传输任务状态
      * @param preCheckItem items
      */

  skipPreCheckItem (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  skipPreCheckItem"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling skipPreCheckItem"
      )
    }
    if (opts.itemName === undefined || opts.itemName === null) {
      throw new Error(
        "Missing the required parameter 'opts.itemName' when calling skipPreCheckItem"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId,
      itemName: opts.itemName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call skipPreCheckItem with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/precheck/{itemName}/skip',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  配置数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {} [opts.transmissionMode] - 传输任务模式：可选值：structureInitialization、dataInitialization、dataSynchronization，分别对应结构初始化，全量数据初始化，增量数据传输  optional
      * @param {} [opts.destExecutionStrategy] - 目标端执行策略，对于目标MySQL，支持：覆盖写入 mysql-replace-engine，冲突检测 conflict-detect-engine  optional
      * @param {} [opts.options] - 任务设置  optional
      * @param {} opts.transmissionObject - 待传输的对象
      * @param {} opts.taskName - 任务名称，名称只支持中文、数字、大小写字母及英文下划线“_”及中划线“-”，不超过32字符
      * @param {} opts.source - 源端连接信息
      * @param {} opts.destination - 目标端连接信息
      * @param {} [opts.checkPoint] - 增量数据传输的启动位点  optional
      * @param {} [opts.customOptions] - 任务自定义设置  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string id  任务ID
      */

  configureTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  configureTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling configureTransmissionTask"
      )
    }
    if (
      opts.transmissionObject === undefined ||
      opts.transmissionObject === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.transmissionObject' when calling configureTransmissionTask"
      )
    }
    if (opts.taskName === undefined || opts.taskName === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskName' when calling configureTransmissionTask"
      )
    }
    if (opts.source === undefined || opts.source === null) {
      throw new Error(
        "Missing the required parameter 'opts.source' when calling configureTransmissionTask"
      )
    }
    if (opts.destination === undefined || opts.destination === null) {
      throw new Error(
        "Missing the required parameter 'opts.destination' when calling configureTransmissionTask"
      )
    }

    let postBody = {}
    if (opts.transmissionMode !== undefined && opts.transmissionMode !== null) {
      postBody['transmissionMode'] = opts.transmissionMode
    }
    if (
      opts.destExecutionStrategy !== undefined &&
      opts.destExecutionStrategy !== null
    ) {
      postBody['destExecutionStrategy'] = opts.destExecutionStrategy
    }
    if (opts.options !== undefined && opts.options !== null) {
      postBody['options'] = opts.options
    }
    if (
      opts.transmissionObject !== undefined &&
      opts.transmissionObject !== null
    ) {
      postBody['transmissionObject'] = opts.transmissionObject
    }
    if (opts.taskName !== undefined && opts.taskName !== null) {
      postBody['taskName'] = opts.taskName
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.destination !== undefined && opts.destination !== null) {
      postBody['destination'] = opts.destination
    }
    if (opts.checkPoint !== undefined && opts.checkPoint !== null) {
      postBody['checkPoint'] = opts.checkPoint
    }
    if (opts.customOptions !== undefined && opts.customOptions !== null) {
      postBody['customOptions'] = opts.customOptions
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call configureTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/configure',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  startTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  startTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling startTransmissionTask"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/start',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  stopTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  stopTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling stopTransmissionTask"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/stop',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  暂停数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  suspendTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  suspendTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling suspendTransmissionTask"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call suspendTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/suspend',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  继续数据传输任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  resumeTransmissionTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  resumeTransmissionTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling resumeTransmissionTask"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call resumeTransmissionTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/resume',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改数据传输任务名称
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {} [opts.name] - 任务名称，名称只支持中文、数字、大小写字母及英文下划线“_”及中划线“-”，不超过32字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyTransmissionTaskName (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyTransmissionTaskName"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling modifyTransmissionTaskName"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyTransmissionTaskName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/rename',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询数据传输对象信息
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object transmissionObject
      */

  describeTransmissionObject (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTransmissionObject"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeTransmissionObject"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTransmissionObject with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/transmissionobject',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询数据传输日志信息
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param logDetail details
      * @param integer totalCount  总数
      */

  describeTransmissionLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTransmissionLog"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeTransmissionLog"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTransmissionLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/log',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  测试连接
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {} opts.endpoint - 实例信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param connectivityTestResult items
      */

  connectivityTest (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  connectivityTest"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling connectivityTest"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling connectivityTest"
      )
    }

    let postBody = {}
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call connectivityTest with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/dts/{taskId}/connectivitytest',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取云实例列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceType - 实例类型
      * @param {string} [opts.instanceRegion] - 实例地域  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cloudInstanceSpec instances  实例信息
      */

  listCloudInstances (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listCloudInstances"
      )
    }

    opts = opts || {}

    if (opts.instanceType === undefined || opts.instanceType === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceType' when calling listCloudInstances"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceRegion !== undefined && opts.instanceRegion !== null) {
      queryParams['instanceRegion'] = opts.instanceRegion
    }

    let pathParams = {
      regionId: regionId,
      instanceType: opts.instanceType
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listCloudInstances with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cloudinstance/{instanceType}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取云实例详情
      * @param {Object} opts - parameters
      * @param {string} opts.instanceType - 实例类型
      * @param {string} opts.instanceId - 实例ID
      * @param {string} [opts.instanceRegion] - 实例地域  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cloudInstanceSpec instance  实例信息
      */

  getCloudInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getCloudInstance"
      )
    }

    opts = opts || {}

    if (opts.instanceType === undefined || opts.instanceType === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceType' when calling getCloudInstance"
      )
    }
    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling getCloudInstance"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceRegion !== undefined && opts.instanceRegion !== null) {
      queryParams['instanceRegion'] = opts.instanceRegion
    }

    let pathParams = {
      regionId: regionId,
      instanceType: opts.instanceType,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCloudInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cloudinstance/{instanceType}/id/{instanceId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Schema列表
      * @param {Object} opts - parameters
      * @param {string} opts.endpointId - DTS连接模板ID
      * @param {} [opts.taskId] - 订阅任务ID，配置订阅任务时，此项必填。  optional
      * @param {} [opts.databaseName] - 数据库名称，此项选填。  optional
      * @param {} opts.endpoint - 实例信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param schema schemas
      */

  listSchemas (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listSchemas"
      )
    }

    opts = opts || {}

    if (opts.endpointId === undefined || opts.endpointId === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpointId' when calling listSchemas"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling listSchemas"
      )
    }

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      postBody['databaseName'] = opts.databaseName
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      endpointId: opts.endpointId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSchemas with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/endpoint/{endpointId}/schema',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Table列表
      * @param {Object} opts - parameters
      * @param {string} opts.endpointId - DTS连接模板ID
      * @param {} [opts.taskId] - 数据传输任务ID  optional
      * @param {} [opts.databaseName] - 数据库名称，此项选填。  optional
      * @param {} [opts.schemaName] - 模式名称，此项选填。  optional
      * @param {} opts.endpoint - 连接模板信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param table tables
      */

  listTables (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listTables"
      )
    }

    opts = opts || {}

    if (opts.endpointId === undefined || opts.endpointId === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpointId' when calling listTables"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling listTables"
      )
    }

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      postBody['databaseName'] = opts.databaseName
    }
    if (opts.schemaName !== undefined && opts.schemaName !== null) {
      postBody['schemaName'] = opts.schemaName
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      endpointId: opts.endpointId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTables with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/endpoint/{endpointId}/table',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Topic列表
      * @param {Object} opts - parameters
      * @param {string} opts.endpointId - DTS连接模板ID
      * @param {} [opts.taskId] - 数据传输任务ID  optional
      * @param {} opts.endpoint - 连接模板信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param topic tables
      */

  listTopics (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listTopics"
      )
    }

    opts = opts || {}

    if (opts.endpointId === undefined || opts.endpointId === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpointId' when calling listTopics"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling listTopics"
      )
    }

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      endpointId: opts.endpointId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTopics with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/endpoint/{endpointId}/topic',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Table详情
      * @param {Object} opts - parameters
      * @param {string} opts.endpointId - DTS连接模板ID
      * @param {string} opts.tableName - table名称
      * @param {} [opts.taskId] - 数据传输任务ID  optional
      * @param {} [opts.databaseName] - 数据库名称，此项选填。  optional
      * @param {} [opts.schemaName] - 模式名称，此项选填。  optional
      * @param {} [opts.tableName] - 表名称，此项必填。  optional
      * @param {} opts.endpoint - 连接模板信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param table table
      */

  getTable (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTable"
      )
    }

    opts = opts || {}

    if (opts.endpointId === undefined || opts.endpointId === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpointId' when calling getTable"
      )
    }
    if (opts.tableName === undefined || opts.tableName === null) {
      throw new Error(
        "Missing the required parameter 'opts.tableName' when calling getTable"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling getTable"
      )
    }

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      postBody['databaseName'] = opts.databaseName
    }
    if (opts.schemaName !== undefined && opts.schemaName !== null) {
      postBody['schemaName'] = opts.schemaName
    }
    if (opts.tableName !== undefined && opts.tableName !== null) {
      postBody['tableName'] = opts.tableName
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      endpointId: opts.endpointId,
      tableName: opts.tableName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTable with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/endpoint/{endpointId}/table/{tableName}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  实例规格列表。
      * @param {Object} opts - parameters
      * @param {string} [opts.transmissionMethod] - 传输任务类型：Migration（迁移）、Sync（同步）、Subscribe（订阅）、DisasterRecovery（灾备）  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param instanceClass instanceClass
      */

  listInstanceClasses (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listInstanceClasses"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (
      opts.transmissionMethod !== undefined &&
      opts.transmissionMethod !== null
    ) {
      queryParams['transmissionMethod'] = opts.transmissionMethod
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listInstanceClasses with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instanceclass',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  任务传输进度列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认为1，取值范围：-1，[1,∞)；-1时返回全部页码。  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[1, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {sort} [opts.sorts] - createTime - 创建时间,asc（正序），desc（倒序）
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param taskProgress progress
      * @param integer totalCount  总记录数
      */

  listTaskProgress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listTaskProgress"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTaskProgress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/taskprogress',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  任务传输进度详情
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - DTS数据传输任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param taskProgress progress
      */

  getTaskProgress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTaskProgress"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling getTaskProgress"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTaskProgress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/taskprogress/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Process
      * @param {Object} opts - parameters
      * @param {string} opts.id - 获取Process列表的资源ID
      * @param {string} [opts.resourceType] - 获取Process列表的资源类型  optional
      * @param {integer} [opts.pageNumber] - 页码；默认为1，取值范围：-1，[1,∞)；-1时返回全部页码。  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[1, 100]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param process process
      * @param integer totalCount  总记录数
      */

  listProcesses (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listProcesses"
      )
    }

    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling listProcesses"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.resourceType !== undefined && opts.resourceType !== null) {
      queryParams['resourceType'] = opts.resourceType
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  dts/2.2.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listProcesses with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/process',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = DTS
