/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Function OpenAPI
 *
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'function'
Service._services[serviceId] = true

/**
 * function service.
 * @version 1.0.3
 */

JDCloud.FUNCTION = class FUNCTION extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'function.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询别名列表
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 别名所属函数名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param alias data
      */

  listAlias (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listAlias"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling listAlias"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listAlias with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/aliases',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建别名
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 别名所属函数名称
      * @param {string} opts.aliasName - 别名名称
      * @param {string} [opts.description] - 别名描述信息  optional
      * @param {string} [opts.version] - 别名对应的版本名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param alias data
      */

  createAlias (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAlias"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling createAlias"
      )
    }
    if (opts.aliasName === undefined || opts.aliasName === null) {
      throw new Error(
        "Missing the required parameter 'opts.aliasName' when calling createAlias"
      )
    }

    let postBody = {}
    if (opts.aliasName !== undefined && opts.aliasName !== null) {
      postBody['aliasName'] = opts.aliasName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAlias with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/aliases',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询别名详情
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 别名所属函数名称
      * @param {string} opts.aliasName - 别名名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param alias data
      */

  getAlias (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getAlias"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling getAlias"
      )
    }
    if (opts.aliasName === undefined || opts.aliasName === null) {
      throw new Error(
        "Missing the required parameter 'opts.aliasName' when calling getAlias"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      aliasName: opts.aliasName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAlias with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/aliases/{aliasName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新别名
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 别名所属函数名称
      * @param {string} opts.aliasName - 别名名称
      * @param {string} opts.description - 别名描述信息
      * @param {string} opts.version - 别名对应版本
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param alias data
      */

  updateAlias (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateAlias"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling updateAlias"
      )
    }
    if (opts.aliasName === undefined || opts.aliasName === null) {
      throw new Error(
        "Missing the required parameter 'opts.aliasName' when calling updateAlias"
      )
    }
    if (opts.description === undefined || opts.description === null) {
      throw new Error(
        "Missing the required parameter 'opts.description' when calling updateAlias"
      )
    }
    if (opts.version === undefined || opts.version === null) {
      throw new Error(
        "Missing the required parameter 'opts.version' when calling updateAlias"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      aliasName: opts.aliasName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAlias with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/aliases/{aliasName}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除别名
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 别名所属函数名称
      * @param {string} opts.aliasName - 别名名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteAlias (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteAlias"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling deleteAlias"
      )
    }
    if (opts.aliasName === undefined || opts.aliasName === null) {
      throw new Error(
        "Missing the required parameter 'opts.aliasName' when calling deleteAlias"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      aliasName: opts.aliasName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAlias with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/aliases/{aliasName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询函数列表
      * @param {Object} opts - parameters
      * @param {boolean} opts.listAll - 是否返回所有函数
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {filter} [opts.filters] - functionId -函数ID，精确匹配，支持多个
functionName  - 函数名称，模糊匹配，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param listFunctionResult data
      */

  listFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listFunction"
      )
    }

    opts = opts || {}

    if (opts.listAll === undefined || opts.listAll === null) {
      throw new Error(
        "Missing the required parameter 'opts.listAll' when calling listFunction"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.listAll !== undefined && opts.listAll !== null) {
      queryParams['listAll'] = opts.listAll
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, this.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建函数
      * @param {Object} opts - parameters
      * @param {string} [opts.name] - 函数名称  optional
      * @param {string} [opts.description] - 函数描述信息  optional
      * @param {string} [opts.entrance] - 函数入口，格式为入口文件.入口函数名  optional
      * @param {integer} [opts.memory] - 函数运行最大内存  optional
      * @param {string} [opts.runTime] - 函数运行环境  optional
      * @param {integer} [opts.overTime] - 函数运行超时时间  optional
      * @param {string} [opts.version] - 函数版本，默认为LATEST  optional
      * @param {code} [opts.code] - 函数代码包  optional
      * @param {env} [opts.environment] - 函数运行时环境变量  optional
      * @param {string} [opts.logSetId] - 函数指定的日志集Id  optional
      * @param {string} [opts.logTopicId] - 函数指定的日志主题Id  optional
      * @param {string} [opts.vpcId] - 函数配置的VPCId  optional
      * @param {string} [opts.subnetId] - 函数配置的子网Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param function data
      */

  createFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createFunction"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.entrance !== undefined && opts.entrance !== null) {
      postBody['entrance'] = opts.entrance
    }
    if (opts.memory !== undefined && opts.memory !== null) {
      postBody['memory'] = opts.memory
    }
    if (opts.runTime !== undefined && opts.runTime !== null) {
      postBody['runTime'] = opts.runTime
    }
    if (opts.overTime !== undefined && opts.overTime !== null) {
      postBody['overTime'] = opts.overTime
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.code !== undefined && opts.code !== null) {
      postBody['code'] = opts.code
    }
    if (opts.environment !== undefined && opts.environment !== null) {
      postBody['environment'] = opts.environment
    }
    if (opts.logSetId !== undefined && opts.logSetId !== null) {
      postBody['logSetId'] = opts.logSetId
    }
    if (opts.logTopicId !== undefined && opts.logTopicId !== null) {
      postBody['logTopicId'] = opts.logTopicId
    }
    if (opts.vpcId !== undefined && opts.vpcId !== null) {
      postBody['vpcId'] = opts.vpcId
    }
    if (opts.subnetId !== undefined && opts.subnetId !== null) {
      postBody['subnetId'] = opts.subnetId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询函数详情
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param function data
      */

  getFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getFunction"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling getFunction"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新函数
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} [opts.description] - 函数描述信息  optional
      * @param {string} [opts.entrance] - 函数入口，格式为入口文件.入口函数名  optional
      * @param {integer} [opts.memory] - 函数运行最大内存  optional
      * @param {string} [opts.runTime] - 函数运行环境  optional
      * @param {integer} [opts.overTime] - 函数运行超时时间  optional
      * @param {string} [opts.version] - 函数版本  optional
      * @param {code} [opts.code] - 函数代码包  optional
      * @param {env} [opts.environment] - 函数运行时环境变量  optional
      * @param {string} [opts.logSetId] - 函数指定的日志集Id  optional
      * @param {string} [opts.logTopicId] - 函数指定的日志主题Id  optional
      * @param {string} [opts.vpcId] - 函数配置的VPCId  optional
      * @param {string} [opts.subnetId] - 函数配置的子网Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param function data
      */

  updateFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateFunction"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling updateFunction"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.entrance !== undefined && opts.entrance !== null) {
      postBody['entrance'] = opts.entrance
    }
    if (opts.memory !== undefined && opts.memory !== null) {
      postBody['memory'] = opts.memory
    }
    if (opts.runTime !== undefined && opts.runTime !== null) {
      postBody['runTime'] = opts.runTime
    }
    if (opts.overTime !== undefined && opts.overTime !== null) {
      postBody['overTime'] = opts.overTime
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.code !== undefined && opts.code !== null) {
      postBody['code'] = opts.code
    }
    if (opts.environment !== undefined && opts.environment !== null) {
      postBody['environment'] = opts.environment
    }
    if (opts.logSetId !== undefined && opts.logSetId !== null) {
      postBody['logSetId'] = opts.logSetId
    }
    if (opts.logTopicId !== undefined && opts.logTopicId !== null) {
      postBody['logTopicId'] = opts.logTopicId
    }
    if (opts.vpcId !== undefined && opts.vpcId !== null) {
      postBody['vpcId'] = opts.vpcId
    }
    if (opts.subnetId !== undefined && opts.subnetId !== null) {
      postBody['subnetId'] = opts.subnetId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除函数
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteFunction"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling deleteFunction"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  控制台测试执行函数
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} opts.versionName - 版本名称
      * @param {string} opts.event - 执行函数的输入事件
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param functionInvokeResult data
      */

  invoke (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invoke"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling invoke"
      )
    }
    if (opts.versionName === undefined || opts.versionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.versionName' when calling invoke"
      )
    }
    if (opts.event === undefined || opts.event === null) {
      throw new Error(
        "Missing the required parameter 'opts.event' when calling invoke"
      )
    }

    let postBody = {}
    if (opts.event !== undefined && opts.event !== null) {
      postBody['event'] = opts.event
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      versionName: opts.versionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invoke with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions/{versionName}:invoke',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  异步测试执行函数
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} opts.versionName - 版本名称
      * @param {string} opts.event - 异步执行函数的输入事件
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  asyncInvoke (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  asyncInvoke"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling asyncInvoke"
      )
    }
    if (opts.versionName === undefined || opts.versionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.versionName' when calling asyncInvoke"
      )
    }
    if (opts.event === undefined || opts.event === null) {
      throw new Error(
        "Missing the required parameter 'opts.event' when calling asyncInvoke"
      )
    }

    let postBody = {}
    if (opts.event !== undefined && opts.event !== null) {
      postBody['event'] = opts.event
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      versionName: opts.versionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call asyncInvoke with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions/{versionName}:asyncinvoke',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取触发器详情
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} opts.versionName - 版本名称
      * @param {string} opts.triggerId - 触发器Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param trigger data
      */

  getTrigger (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTrigger"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling getTrigger"
      )
    }
    if (opts.versionName === undefined || opts.versionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.versionName' when calling getTrigger"
      )
    }
    if (opts.triggerId === undefined || opts.triggerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.triggerId' when calling getTrigger"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.triggerId !== undefined && opts.triggerId !== null) {
      queryParams['triggerId'] = opts.triggerId
    }

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      versionName: opts.versionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTrigger with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions/{versionName}:gettrigger',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询版本列表
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param functionSpec data
      */

  listVersion (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listVersion"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling listVersion"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建版本
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} [opts.description] - 版本描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param function data
      */

  createVersion (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createVersion"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling createVersion"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取版本详情
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} opts.versionName - 版本名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param function data
      */

  getVersion (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getVersion"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling getVersion"
      )
    }
    if (opts.versionName === undefined || opts.versionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.versionName' when calling getVersion"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      versionName: opts.versionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions/{versionName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除版本
      * @param {Object} opts - parameters
      * @param {string} opts.functionName - 函数名称
      * @param {string} opts.versionName - 版本名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteVersion (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteVersion"
      )
    }

    opts = opts || {}

    if (opts.functionName === undefined || opts.functionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.functionName' when calling deleteVersion"
      )
    }
    if (opts.versionName === undefined || opts.versionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.versionName' when calling deleteVersion"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      functionName: opts.functionName,
      versionName: opts.versionName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  function/1.0.3'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteVersion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/functions/{functionName}/versions/{versionName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.FUNCTION
