/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * User Management
 * User Management API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'iam'
Service._services[serviceId] = true

/**
 * iam service.
 * @version 0.3.6
 */

class IAM extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'iam.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  启用子用户AccessKey &lt;br&gt;, 启用后accessKey 的状态变成 1 &lt;b&gt;启用&lt;/b&gt;

      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名称
      * @param {string} opts.accessKey - accessKey
      * @param {string} callback - callback
      @return {Object} result
      */

  enableSubUserAccessKey (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling enableSubUserAccessKey"
      )
    }
    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling enableSubUserAccessKey"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableSubUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/accessKey/{accessKey}:enable',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用子用户的AccessKey &lt;br&gt;, 禁用后accessKey 的状态变成 0 &lt;b&gt;禁用&lt;/b&gt;

      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名称
      * @param {string} opts.accessKey - accessKey
      * @param {string} callback - callback
      @return {Object} result
      */

  disableSubUserAccessKey (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling disableSubUserAccessKey"
      )
    }
    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling disableSubUserAccessKey"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableSubUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/accessKey/{accessKey}:disable',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除子用户的AccessKey

      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名称
      * @param {string} opts.accessKey - accessKey
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSubUserAccessKey (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling deleteSubUserAccessKey"
      )
    }
    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling deleteSubUserAccessKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSubUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/accessKey/{accessKey}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建用户组, &lt;br&gt;
可访问&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/group-management&quot;&gt;用户组管理&lt;/a&gt;了解更多&lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createGroupInfo} opts.createGroupInfo
      * @param {string} callback - callback
      @return {Object} result
      * @param createGroupRes group  用户组信息
      */

  createGroup (opts, callback) {
    opts = opts || {}

    if (opts.createGroupInfo === undefined || opts.createGroupInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.createGroupInfo' when calling createGroup"
      )
    }

    let postBody = {}
    if (opts.createGroupInfo !== undefined && opts.createGroupInfo !== null) {
      postBody['createGroupInfo'] = opts.createGroupInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户组详情
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} callback - callback
      @return {Object} result
      * @param groupDetail group  用户组信息
      */

  describeGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling describeGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改用户组
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {updateGroupInfo} opts.updateGroupInfo
      * @param {string} callback - callback
      @return {Object} result
      */

  updateGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling updateGroup"
      )
    }
    if (opts.updateGroupInfo === undefined || opts.updateGroupInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.updateGroupInfo' when calling updateGroup"
      )
    }

    let postBody = {}
    if (opts.updateGroupInfo !== undefined && opts.updateGroupInfo !== null) {
      postBody['updateGroupInfo'] = opts.updateGroupInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户组
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling deleteGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户组内的子用户列表
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  用户总数
      * @param subUserInfo subUsers
      */

  describeGroupSubUsers (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling describeGroupSubUsers"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeGroupSubUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}/subUsers',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户组列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} [opts.keyword] - 关键字  optional
      * @param {integer} [opts.sort] - 排序规则：0-创建时间顺序排序，1-创建时间倒序排序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param group groups
      */

  describeGroups (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/groups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列举用户组的策略
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param policy policies
      */

  describeAttachedGroupPolicies (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling describeAttachedGroupPolicies"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAttachedGroupPolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}/policies',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列举用户组的策略的资源组列表
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} opts.policyID - 策略ID
      * @param {string} [opts.filterBindResGroup] - 滤绑定策略资源组：&quot;Deny&quot; 不允许，Allow 允许，空情况默认不允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param resourceGroup policies
      */

  describeAttachedGroupPoliciesScope (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling describeAttachedGroupPoliciesScope"
      )
    }
    if (opts.policyID === undefined || opts.policyID === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyID' when calling describeAttachedGroupPoliciesScope"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyID !== undefined && opts.policyID !== null) {
      queryParams['policyID'] = opts.policyID
    }
    if (
      opts.filterBindResGroup !== undefined &&
      opts.filterBindResGroup !== null
    ) {
      queryParams['filterBindResGroup'] = opts.filterBindResGroup
    }

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAttachedGroupPoliciesScope with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}/policiesScope',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为用户组解绑策略
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowDetachAddPolicy] - 允许解除策略：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  detachGroupPolicy (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling detachGroupPolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling detachGroupPolicy"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      queryParams['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      queryParams['scopeId'] = opts.scopeId
    }
    if (
      opts.allowDetachAddPolicy !== undefined &&
      opts.allowDetachAddPolicy !== null
    ) {
      queryParams['allowDetachAddPolicy'] = opts.allowDetachAddPolicy
    }

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call detachGroupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}:detachGroupPolicy',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为用户组绑定策略
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowAddPolicy] - 允许添加策略绑定：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  attachGroupPolicy (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling attachGroupPolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling attachGroupPolicy"
      )
    }

    let postBody = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      postBody['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      postBody['scopeId'] = opts.scopeId
    }
    if (opts.allowAddPolicy !== undefined && opts.allowAddPolicy !== null) {
      postBody['allowAddPolicy'] = opts.allowAddPolicy
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call attachGroupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}:attachGroupPolicy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  将子用户从组中删除
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      */

  removeSubUserFromGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling removeSubUserFromGroup"
      )
    }
    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling removeSubUserFromGroup"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.subUser !== undefined && opts.subUser !== null) {
      queryParams['subUser'] = opts.subUser
    }

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeSubUserFromGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}:removeSubUserFromGroup',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子用户到用户组中
      * @param {Object} opts - parameters
      * @param {string} opts.groupName - 用户组名称
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      */

  addSubUserToGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupName === undefined || opts.groupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupName' when calling addSubUserToGroup"
      )
    }
    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling addSubUserToGroup"
      )
    }

    let postBody = {}
    if (opts.subUser !== undefined && opts.subUser !== null) {
      postBody['subUser'] = opts.subUser
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupName: opts.groupName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addSubUserToGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/group/{groupName}:addSubUserToGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  初始化虚拟MFA设备
      * @param {Object} opts - parameters
      * @param {string} [opts.boundAccount] - 初始化的账号（目前支持：默认不填的情况表示为自己初始化，填写子用户名表示为子用户化初始)  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param virtualMFADevice virtualMFADevice
      */

  createVirtualMFADevice (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.boundAccount !== undefined && opts.boundAccount !== null) {
      postBody['boundAccount'] = opts.boundAccount
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createVirtualMFADevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/virtualMFADevice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询虚拟MFA设备状态
      * @param {Object} opts - parameters
      * @param {string} [opts.queriedAccount] - 被查询的账号（目前支持：默认不填的情况表示查询自己，填写子用户名表示查询子用户)  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer status  0-关闭，1-启用
      */

  describeVirtualMFA (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.queriedAccount !== undefined && opts.queriedAccount !== null) {
      queryParams['queriedAccount'] = opts.queriedAccount
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeVirtualMFA with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/virtualMFA',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定虚拟MFA设备
      * @param {Object} opts - parameters
      * @param {string} [opts.boundAccount] - 被绑定的账号（目前支持：默认不填的情况表示给自己绑定，填写子用户名表示主账号给子用户绑定)  optional
      * @param {string} opts.authenticationCode1 - 第一组动态密码（连续的两组）
      * @param {string} opts.authenticationCode2 - 第二组动态密码（连续的两组）
      * @param {string} callback - callback
      @return {Object} result
      */

  bindMFADevice (opts, callback) {
    opts = opts || {}

    if (
      opts.authenticationCode1 === undefined ||
      opts.authenticationCode1 === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.authenticationCode1' when calling bindMFADevice"
      )
    }
    if (
      opts.authenticationCode2 === undefined ||
      opts.authenticationCode2 === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.authenticationCode2' when calling bindMFADevice"
      )
    }

    let postBody = {}
    if (opts.boundAccount !== undefined && opts.boundAccount !== null) {
      postBody['boundAccount'] = opts.boundAccount
    }
    if (
      opts.authenticationCode1 !== undefined &&
      opts.authenticationCode1 !== null
    ) {
      postBody['authenticationCode1'] = opts.authenticationCode1
    }
    if (
      opts.authenticationCode2 !== undefined &&
      opts.authenticationCode2 !== null
    ) {
      postBody['authenticationCode2'] = opts.authenticationCode2
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindMFADevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/virtualMFADevice:bind',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定虚拟MFA设备（一组动态密码）
      * @param {Object} opts - parameters
      * @param {string} [opts.boundAccount] - 被绑定的账号（目前支持：默认不填的情况表示给自己绑定，填写子用户名表示主账号给子用户绑定)  optional
      * @param {string} opts.authenticationCode - 一组动态密码
      * @param {string} callback - callback
      @return {Object} result
      */

  bindMFADeviceByOneCode (opts, callback) {
    opts = opts || {}

    if (
      opts.authenticationCode === undefined ||
      opts.authenticationCode === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.authenticationCode' when calling bindMFADeviceByOneCode"
      )
    }

    let postBody = {}
    if (opts.boundAccount !== undefined && opts.boundAccount !== null) {
      postBody['boundAccount'] = opts.boundAccount
    }
    if (
      opts.authenticationCode !== undefined &&
      opts.authenticationCode !== null
    ) {
      postBody['authenticationCode'] = opts.authenticationCode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindMFADeviceByOneCode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/virtualMFADevice:bindByOneCode',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  解绑虚拟MFA设备
      * @param {Object} opts - parameters
      * @param {string} [opts.unboundAccount] - 被解绑的账号（目前支持：默认不填的情况表示给自己解绑，填写子用户名表示为子用户解绑)  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  unbindMFADevice (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.unboundAccount !== undefined && opts.unboundAccount !== null) {
      queryParams['unboundAccount'] = opts.unboundAccount
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call unbindMFADevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/virtualMFADevice:unbind',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新建组织用户关联关系
      * @param {Object} opts - parameters
      * @param {string} opts.orgId - 组织ID
      * @param {addOrganizationUserRelationInfo} opts.addOrganizationUserRelationInfo - 新建组织用户关联子用户关系参数
      * @param {string} callback - callback
      @return {Object} result
      */

  addOrganizationUserRelation (opts, callback) {
    opts = opts || {}

    if (opts.orgId === undefined || opts.orgId === null) {
      throw new Error(
        "Missing the required parameter 'opts.orgId' when calling addOrganizationUserRelation"
      )
    }
    if (
      opts.addOrganizationUserRelationInfo === undefined ||
      opts.addOrganizationUserRelationInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.addOrganizationUserRelationInfo' when calling addOrganizationUserRelation"
      )
    }

    let postBody = {}
    if (
      opts.addOrganizationUserRelationInfo !== undefined &&
      opts.addOrganizationUserRelationInfo !== null
    ) {
      postBody['addOrganizationUserRelationInfo'] =
        opts.addOrganizationUserRelationInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      orgId: opts.orgId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addOrganizationUserRelation with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/organization/{orgId}/userRelation:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建策略 &lt;br&gt;
关于策略的详细介绍，可以查询&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/policy-overview&quot;&gt;策略概览&lt;/a&gt; &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createPermissionInfo} opts.createPermissionInfo - 权限信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createPermission (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createPermission"
      )
    }

    opts = opts || {}

    if (
      opts.createPermissionInfo === undefined ||
      opts.createPermissionInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createPermissionInfo' when calling createPermission"
      )
    }

    let postBody = {}
    if (
      opts.createPermissionInfo !== undefined &&
      opts.createPermissionInfo !== null
    ) {
      postBody['createPermissionInfo'] = opts.createPermissionInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createPermission with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/permission',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询策略详情
      * @param {Object} opts - parameters
      * @param {integer} opts.permissionId - 权限id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param permission permission  权限信息
      */

  describePermissionDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePermissionDetail"
      )
    }

    opts = opts || {}

    if (opts.permissionId === undefined || opts.permissionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.permissionId' when calling describePermissionDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      permissionId: opts.permissionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePermissionDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/permission/{permissionId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改策略
      * @param {Object} opts - parameters
      * @param {integer} opts.permissionId - 权限id
      * @param {updatePermissionInfo} opts.updatePermissionInfo - 权限信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updatePermission (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updatePermission"
      )
    }

    opts = opts || {}

    if (opts.permissionId === undefined || opts.permissionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.permissionId' when calling updatePermission"
      )
    }
    if (
      opts.updatePermissionInfo === undefined ||
      opts.updatePermissionInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.updatePermissionInfo' when calling updatePermission"
      )
    }

    let postBody = {}
    if (
      opts.updatePermissionInfo !== undefined &&
      opts.updatePermissionInfo !== null
    ) {
      postBody['updatePermissionInfo'] = opts.updatePermissionInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      permissionId: opts.permissionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePermission with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/permission/{permissionId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询策略列表
      * @param {Object} opts - parameters
      * @param {integer} opts.pageNumber - 页码
      * @param {integer} opts.pageSize - 每页显示数目
      * @param {string} [opts.keyword] - 关键字  optional
      * @param {integer} opts.queryType - 权限类型,0-全部，1-系统权限，2-自定义权限
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param permission permissions
      */

  describePermissions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePermissions"
      )
    }

    opts = opts || {}

    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describePermissions"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describePermissions"
      )
    }
    if (opts.queryType === undefined || opts.queryType === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryType' when calling describePermissions"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.queryType !== undefined && opts.queryType !== null) {
      queryParams['queryType'] = opts.queryType
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePermissions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/permissions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户策略列表
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户用户名
      * @param {integer} opts.pageNumber - 页码
      * @param {integer} opts.pageSize - 每页显示数目
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param permission permissions
      */

  describeSubUserPermissions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSubUserPermissions"
      )
    }

    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling describeSubUserPermissions"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling describeSubUserPermissions"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeSubUserPermissions"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSubUserPermissions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/subUser/{subUser}/permisssions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为子用户绑定策略
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户用户名
      * @param {addPermissionsInfo} opts.addPermissionsInfo - 权限信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addPermissionsToSubUser (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addPermissionsToSubUser"
      )
    }

    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling addPermissionsToSubUser"
      )
    }
    if (
      opts.addPermissionsInfo === undefined ||
      opts.addPermissionsInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.addPermissionsInfo' when calling addPermissionsToSubUser"
      )
    }

    let postBody = {}
    if (
      opts.addPermissionsInfo !== undefined &&
      opts.addPermissionsInfo !== null
    ) {
      postBody['addPermissionsInfo'] = opts.addPermissionsInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addPermissionsToSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/subUser/{subUser}/permisssions',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为子用户解绑策略
      * @param {Object} opts - parameters
      * @param {integer} opts.permissionId - 权限id
      * @param {string} opts.subUser - 子用户用户名
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  removePermissionOfSubUser (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  removePermissionOfSubUser"
      )
    }

    opts = opts || {}

    if (opts.permissionId === undefined || opts.permissionId === null) {
      throw new Error(
        "Missing the required parameter 'opts.permissionId' when calling removePermissionOfSubUser"
      )
    }
    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling removePermissionOfSubUser"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      permissionId: opts.permissionId,
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removePermissionOfSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/subUser/{subUser}/permissions/{permissionId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建策略, &lt;br&gt;
访问 &lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/policy-overview&quot;&gt;策略管理&lt;/a&gt; 了解更多内容 &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createPolicyInfo} opts.createPolicyInfo - 策略信息
      * @param {string} callback - callback
      @return {Object} result
      * @param policy policy  策略信息
      */

  createPolicy (opts, callback) {
    opts = opts || {}

    if (opts.createPolicyInfo === undefined || opts.createPolicyInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.createPolicyInfo' when calling createPolicy"
      )
    }

    let postBody = {}
    if (opts.createPolicyInfo !== undefined && opts.createPolicyInfo !== null) {
      postBody['createPolicyInfo'] = opts.createPolicyInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询策略详情
      * @param {Object} opts - parameters
      * @param {string} opts.policyName - 策略名称
      * @param {string} callback - callback
      @return {Object} result
      * @param policyDetail policy  权限策略信息
      * @param policyEdition defaultPolicyEdition  权限策略的默认版本信息
      */

  describePolicy (opts, callback) {
    opts = opts || {}

    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling describePolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      policyName: opts.policyName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policy/{policyName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改权限策略
      * @param {Object} opts - parameters
      * @param {string} opts.policyName - 策略名称
      * @param {updatePolicyInfo} opts.updatePolicyInfo - 策略文档信息
      * @param {string} callback - callback
      @return {Object} result
      */

  updatePolicy (opts, callback) {
    opts = opts || {}

    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling updatePolicy"
      )
    }
    if (opts.updatePolicyInfo === undefined || opts.updatePolicyInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.updatePolicyInfo' when calling updatePolicy"
      )
    }

    let postBody = {}
    if (opts.updatePolicyInfo !== undefined && opts.updatePolicyInfo !== null) {
      postBody['updatePolicyInfo'] = opts.updatePolicyInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      policyName: opts.policyName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policy/{policyName}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除策略
      * @param {Object} opts - parameters
      * @param {string} opts.policyName - 策略名称
      * @param {string} callback - callback
      @return {Object} result
      */

  deletePolicy (opts, callback) {
    opts = opts || {}

    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling deletePolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      policyName: opts.policyName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deletePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policy/{policyName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改策略描述
      * @param {Object} opts - parameters
      * @param {string} opts.policyName - 策略名称
      * @param {updatePolicyDescriptionInfo} opts.updatePolicyDescriptionInfo - 策略描述信息
      * @param {string} callback - callback
      @return {Object} result
      */

  updatePolicyDescription (opts, callback) {
    opts = opts || {}

    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling updatePolicyDescription"
      )
    }
    if (
      opts.updatePolicyDescriptionInfo === undefined ||
      opts.updatePolicyDescriptionInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.updatePolicyDescriptionInfo' when calling updatePolicyDescription"
      )
    }

    let postBody = {}
    if (
      opts.updatePolicyDescriptionInfo !== undefined &&
      opts.updatePolicyDescriptionInfo !== null
    ) {
      postBody['updatePolicyDescriptionInfo'] = opts.updatePolicyDescriptionInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      policyName: opts.policyName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePolicyDescription with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policy/{policyName}/description',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询策略列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} [opts.keyword] - 关键字  optional
      * @param {integer} [opts.queryType] - 策略类型：0-全部（默认），1-系统策略，2-自定义策略  optional
      * @param {integer} [opts.sort] - 排序规则：0-创建时间顺序排序，1-创建时间倒序排序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param policy policies
      */

  describePolicies (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.queryType !== undefined && opts.queryType !== null) {
      queryParams['queryType'] = opts.queryType
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/policies',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建角色 &lt;br&gt;
关于角色的详细介绍，请请参考 &lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/role-overview&quot;&gt;角色概览&lt;/a&gt; &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createRoleInfo} opts.createRoleInfo - 角色信息
      * @param {string} callback - callback
      @return {Object} result
      * @param roleInfo roleInfo  角色信息
      */

  createRole (opts, callback) {
    opts = opts || {}

    if (opts.createRoleInfo === undefined || opts.createRoleInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.createRoleInfo' when calling createRole"
      )
    }

    let postBody = {}
    if (opts.createRoleInfo !== undefined && opts.createRoleInfo !== null) {
      postBody['createRoleInfo'] = opts.createRoleInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRole with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  复制角色
      * @param {Object} opts - parameters
      * @param {copyRoleInfo} opts.copyRoleInfo - 角色信息
      * @param {string} callback - callback
      @return {Object} result
      * @param roleInfo roleInfo  角色信息
      */

  copyRole (opts, callback) {
    opts = opts || {}

    if (opts.copyRoleInfo === undefined || opts.copyRoleInfo === null) {
      throw new Error(
        "Missing the required parameter 'opts.copyRoleInfo' when calling copyRole"
      )
    }

    let postBody = {}
    if (opts.copyRoleInfo !== undefined && opts.copyRoleInfo !== null) {
      postBody['copyRoleInfo'] = opts.copyRoleInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call copyRole with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/copyRole',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询角色详情
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {string} callback - callback
      @return {Object} result
      * @param roleInfo roleInfo  角色信息
      */

  describeRole (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling describeRole"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRole with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除角色
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteRole (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling deleteRole"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRole with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改角色内置policy
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {updateAssumeRolePolicyInfo} opts.updateAssumeRolePolicyInfo - 角色权限信息
      * @param {string} callback - callback
      @return {Object} result
      */

  updateAssumeRolePolicy (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling updateAssumeRolePolicy"
      )
    }
    if (
      opts.updateAssumeRolePolicyInfo === undefined ||
      opts.updateAssumeRolePolicyInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.updateAssumeRolePolicyInfo' when calling updateAssumeRolePolicy"
      )
    }

    let postBody = {}
    if (
      opts.updateAssumeRolePolicyInfo !== undefined &&
      opts.updateAssumeRolePolicyInfo !== null
    ) {
      postBody['updateAssumeRolePolicyInfo'] = opts.updateAssumeRolePolicyInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAssumeRolePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}/assumeRolePolicy',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询角色列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} [opts.roleName] - 角色名称关键词  optional
      * @param {integer} [opts.type] - 角色类型，默认查找所有类型，2-服务相关角色，3-服务角色，4-用户角色  optional
      * @param {integer} [opts.sort] - 排序策略,0-按创建时间顺序排序,1-按创建时间倒序排序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param listRoleInfo roles
      */

  describeRoles (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.roleName !== undefined && opts.roleName !== null) {
      queryParams['roleName'] = opts.roleName
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoles with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/roles',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为角色绑定策略
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowAddPolicy] - 允许添加策略绑定：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  attachRolePolicy (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling attachRolePolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling attachRolePolicy"
      )
    }

    let postBody = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      postBody['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      postBody['scopeId'] = opts.scopeId
    }
    if (opts.allowAddPolicy !== undefined && opts.allowAddPolicy !== null) {
      postBody['allowAddPolicy'] = opts.allowAddPolicy
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call attachRolePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}:attachRolePolicy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为角色绑定策略
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowDetachAddPolicy] - 允许解除策略：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  detachRolePolicy (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling detachRolePolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling detachRolePolicy"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      queryParams['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      queryParams['scopeId'] = opts.scopeId
    }
    if (
      opts.allowDetachAddPolicy !== undefined &&
      opts.allowDetachAddPolicy !== null
    ) {
      queryParams['allowDetachAddPolicy'] = opts.allowDetachAddPolicy
    }

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call detachRolePolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}:detachRolePolicy',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询角色授权策略列表
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 每页显示数目[10~100] 默认50条  optional
      * @param {string} [opts.keyword] - 关键字  optional
      * @param {integer} opts.sort - 排序策略,0-按创建时间顺序排序  1-按创建时间倒序
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param rolePolicy policies
      */

  describeRolePolicies (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling describeRolePolicies"
      )
    }
    if (opts.sort === undefined || opts.sort === null) {
      throw new Error(
        "Missing the required parameter 'opts.sort' when calling describeRolePolicies"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRolePolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}/policies',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询角色授权策略列表
      * @param {Object} opts - parameters
      * @param {string} opts.roleName - 角色名称
      * @param {string} opts.policyID - 策略ID
      * @param {string} [opts.filterBindResGroup] - 滤绑定策略资源组：&quot;Deny&quot; 不允许，Allow 允许，空情况默认不允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param rolePolicy policies
      */

  describeRolePoliciesScope (opts, callback) {
    opts = opts || {}

    if (opts.roleName === undefined || opts.roleName === null) {
      throw new Error(
        "Missing the required parameter 'opts.roleName' when calling describeRolePoliciesScope"
      )
    }
    if (opts.policyID === undefined || opts.policyID === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyID' when calling describeRolePoliciesScope"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyID !== undefined && opts.policyID !== null) {
      queryParams['policyID'] = opts.policyID
    }
    if (
      opts.filterBindResGroup !== undefined &&
      opts.filterBindResGroup !== null
    ) {
      queryParams['filterBindResGroup'] = opts.filterBindResGroup
    }

    let pathParams = {
      regionId: 'jdcloud',
      roleName: opts.roleName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRolePoliciesScope with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/role/{roleName}/policiesScope',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建子用户, &lt;br&gt;
请访问&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/subuser-management&quot;&gt;子用户管理&lt;/a&gt;了解更多 &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createSubUserInfo} opts.createSubUserInfo - 子用户信息
      * @param {string} callback - callback
      @return {Object} result
      * @param createSubUserRes subUser
      */

  createSubUser (opts, callback) {
    opts = opts || {}

    if (
      opts.createSubUserInfo === undefined ||
      opts.createSubUserInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createSubUserInfo' when calling createSubUser"
      )
    }

    let postBody = {}
    if (
      opts.createSubUserInfo !== undefined &&
      opts.createSubUserInfo !== null
    ) {
      postBody['createSubUserInfo'] = opts.createSubUserInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户信息
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      * @param subUser subUser
      */

  describeSubUser (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling describeSubUser"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改子用户信息
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {updateSubUserInfo} opts.updateSubUserInfo - 子用户信息
      * @param {string} callback - callback
      @return {Object} result
      * @param createSubUserRes subUser
      */

  updateSubUser (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling updateSubUser"
      )
    }
    if (
      opts.updateSubUserInfo === undefined ||
      opts.updateSubUserInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.updateSubUserInfo' when calling updateSubUser"
      )
    }

    let postBody = {}
    if (
      opts.updateSubUserInfo !== undefined &&
      opts.updateSubUserInfo !== null
    ) {
      postBody['updateSubUserInfo'] = opts.updateSubUserInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除子用户信息
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSubUser (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling deleteSubUser"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSubUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码，默认1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认50，取值范围[10, 100]  optional
      * @param {string} [opts.keyword] - 关键字  optional
      * @param {integer} [opts.sort] - 排序规则：0-创建时间顺序排序，1-创建时间倒序排序  optional
      * @param {string} [opts.phone] - 手机号，和keyword互斥，不要都传  optional
      * @param {string} [opts.email] - 邮箱，和keyword互斥，不要都传  optional
      * @param {string} [opts.description] - 用户姓名，和keyword互斥，不要都传  optional
      * @param {string} [opts.nickName] - 子用户别名  optional
      * @param {string} [opts.name] - 子用户姓名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param subUser subUsers
      * @param integer total
      */

  describeSubUsers (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.keyword !== undefined && opts.keyword !== null) {
      queryParams['keyword'] = opts.keyword
    }
    if (opts.sort !== undefined && opts.sort !== null) {
      queryParams['sort'] = opts.sort
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      queryParams['phone'] = opts.phone
    }
    if (opts.email !== undefined && opts.email !== null) {
      queryParams['email'] = opts.email
    }
    if (opts.description !== undefined && opts.description !== null) {
      queryParams['description'] = opts.description
    }
    if (opts.nickName !== undefined && opts.nickName !== null) {
      queryParams['nickName'] = opts.nickName
    }
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSubUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUsers',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户所属的所有组
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      * @param groupInfo groups
      * @param integer total
      */

  describeSubUserGroups (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling describeSubUserGroups"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSubUserGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/groups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户绑定的策略列表
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param policy policies
      */

  describeAttachedSubUserPolicies (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling describeAttachedSubUserPolicies"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAttachedSubUserPolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/policies',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询子用户绑定的策略对应资源组列表
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} opts.policyID - 策略ID
      * @param {string} [opts.filterBindResGroup] - 滤绑定策略资源组：&quot;Deny&quot; 不允许，Allow 允许，空情况默认不允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总数
      * @param resourceGroup policies
      */

  describeAttachedSubUserPoliciesScope (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling describeAttachedSubUserPoliciesScope"
      )
    }
    if (opts.policyID === undefined || opts.policyID === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyID' when calling describeAttachedSubUserPoliciesScope"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyID !== undefined && opts.policyID !== null) {
      queryParams['policyID'] = opts.policyID
    }
    if (
      opts.filterBindResGroup !== undefined &&
      opts.filterBindResGroup !== null
    ) {
      queryParams['filterBindResGroup'] = opts.filterBindResGroup
    }

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAttachedSubUserPoliciesScope with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}/policiesScope',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为子用户解绑策略
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowDetachAddPolicy] - 允许解除策略：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  detachSubUserPolicy (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling detachSubUserPolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling detachSubUserPolicy"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      queryParams['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      queryParams['scopeId'] = opts.scopeId
    }
    if (
      opts.allowDetachAddPolicy !== undefined &&
      opts.allowDetachAddPolicy !== null
    ) {
      queryParams['allowDetachAddPolicy'] = opts.allowDetachAddPolicy
    }

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call detachSubUserPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}:detachSubUserPolicy',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为子用户绑定策略
      * @param {Object} opts - parameters
      * @param {string} opts.subUser - 子用户名
      * @param {string} opts.policyName - 策略名称
      * @param {string} [opts.scopeId] - 资源组id  optional
      * @param {string} [opts.allowAddPolicy] - 允许添加策略绑定：&quot;Deny&quot; 不允许，Allow 允许，空情况默认允许，兼容历史数据  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  attachSubUserPolicy (opts, callback) {
    opts = opts || {}

    if (opts.subUser === undefined || opts.subUser === null) {
      throw new Error(
        "Missing the required parameter 'opts.subUser' when calling attachSubUserPolicy"
      )
    }
    if (opts.policyName === undefined || opts.policyName === null) {
      throw new Error(
        "Missing the required parameter 'opts.policyName' when calling attachSubUserPolicy"
      )
    }

    let postBody = {}
    if (opts.policyName !== undefined && opts.policyName !== null) {
      postBody['policyName'] = opts.policyName
    }
    if (opts.scopeId !== undefined && opts.scopeId !== null) {
      postBody['scopeId'] = opts.scopeId
    }
    if (opts.allowAddPolicy !== undefined && opts.allowAddPolicy !== null) {
      postBody['allowAddPolicy'] = opts.allowAddPolicy
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      subUser: opts.subUser
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call attachSubUserPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUser/{subUser}:attachSubUserPolicy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建子用户, &lt;br&gt;
请访问&lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/iam/subuser-management&quot;&gt;子用户管理&lt;/a&gt;了解更多 &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {createSubUserInfoInner} opts.createSubUserInfo - 子用户信息
      * @param {string} callback - callback
      @return {Object} result
      * @param createSubUserRes subUser
      */

  createSubUserInner (opts, callback) {
    opts = opts || {}

    if (
      opts.createSubUserInfo === undefined ||
      opts.createSubUserInfo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.createSubUserInfo' when calling createSubUserInner"
      )
    }

    let postBody = {}
    if (
      opts.createSubUserInfo !== undefined &&
      opts.createSubUserInfo !== null
    ) {
      postBody['createSubUserInfo'] = opts.createSubUserInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSubUserInner with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/subUserInner',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询主账号AccessKey列表 &lt;br&gt;
关于AccessKey的介绍和使用，请参考 &lt;a href&#x3D;&quot;https://docs.jdcloud.com/cn/account-management/accesskey-management&quot;&gt;Accesskey管理&lt;/a&gt; &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param userAccessKey userAccessKeys
      */

  describeUserAccessKeys (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUserAccessKeys"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserAccessKeys with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/userAccessKeys',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建主账号AccessKey, &lt;br&gt; 最多可创建5个

      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createUserAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createUserAccessKey"
      )
    }

    opts = opts || {}

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/userAccessKey',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用主账号AccessKey, &lt;br&gt; 启用后accessKey的状态变成 1 &lt;b&gt;启用&lt;/b&gt;

      * @param {Object} opts - parameters
      * @param {string} opts.accessKey - accessKey
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  enabledUserAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  enabledUserAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling enabledUserAccessKey"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enabledUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/userAccessKey/{accessKey}:enabled',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用主账号AccessKey, &lt;br&gt; 禁用后accessKey的状态变成 0 &lt;b&gt;禁用&lt;/b&gt;

      * @param {Object} opts - parameters
      * @param {string} opts.accessKey - accessKey
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  disabledUserAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  disabledUserAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling disabledUserAccessKey"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disabledUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/userAccessKey/{accessKey}:disabled',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除主账号AccessKey, &lt;br&gt;

      * @param {Object} opts - parameters
      * @param {string} opts.accessKey - accessKey
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUserAccessKey (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteUserAccessKey"
      )
    }

    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling deleteUserAccessKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      accessKey: opts.accessKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUserAccessKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/userAccessKey/{accessKey}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据AccessKey或者AccountId获取用户Pin
      * @param {Object} opts - parameters
      * @param {string} [opts.accessKey] - 用户accessKey  optional
      * @param {string} [opts.accountId] - 用户唯一id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string pin  用户pin，如果是子账号，则格式为主账号pin @ 子账号pin
      */

  describeUserPin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUserPin"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      queryParams['accessKey'] = opts.accessKey
    }
    if (opts.accountId !== undefined && opts.accountId !== null) {
      queryParams['accountId'] = opts.accountId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iam/0.3.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserPin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/user:describeUserPin',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = IAM
