/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * JDCLOUD Invoice API
 * 京东云发票
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'invoice'
Service._services[serviceId] = true

/**
 * invoice service.
 * @version 0.4.11
 */

class INVOICE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'ivoice.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询发票邮寄地址列表
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - 用户pin(运营后台必传)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param postAddress addresses
      */

  describeAddresses (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAddresses"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAddresses with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/addresses',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取集团级联地址列表
      * @param {Object} opts - parameters
      * @param {integer} opts.parentId
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param area addresses
      */

  describeChildrenArea (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeChildrenArea"
      )
    }

    opts = opts || {}

    if (opts.parentId === undefined || opts.parentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.parentId' when calling describeChildrenArea"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId,
      parentId: opts.parentId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeChildrenArea with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/areas/{parentId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询发票邮寄地址详情
      * @param {Object} opts - parameters
      * @param {integer} opts.id
      * @param {string} [opts.pin] - 用户pin(运营后台必传)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer id  id
      * @param string name  收件人姓名
      * @param string phone  收件人电话
      * @param string province  省
      * @param string city  市
      * @param string county  区
      * @param string town  县
      * @param string address  邮编
      * @param integer isDefault  是否默认收货地址
      * @param string updateTime  更新时间
      * @param string pin  用户pin
      * @param string createTime  创建时间
      * @param string zipCode  邮编
      * @param integer provinceId  省id
      * @param integer cityId  市id
      * @param integer countyId  区县id
      * @param integer townId  乡镇id
      */

  describeAddress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAddress"
      )
    }

    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling describeAddress"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAddress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/address/{id}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改发票邮寄地址
      * @param {Object} opts - parameters
      * @param {integer} opts.id
      * @param {integer} [opts.id] - id  optional
      * @param {string} [opts.name] - 收件人姓名  optional
      * @param {string} [opts.phone] - 收件人电话  optional
      * @param {string} [opts.province] - 省  optional
      * @param {string} [opts.city] - 市  optional
      * @param {string} [opts.county] - 区  optional
      * @param {string} [opts.town] - 县  optional
      * @param {string} [opts.address] - 邮编  optional
      * @param {integer} [opts.isDefault] - 是否默认收货地址  optional
      * @param {string} [opts.updateTime] - 更新时间  optional
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} [opts.createTime] - 创建时间  optional
      * @param {string} [opts.zipCode] - 邮编  optional
      * @param {integer} [opts.provinceId] - 省id  optional
      * @param {integer} [opts.cityId] - 市id  optional
      * @param {integer} [opts.countyId] - 区县id  optional
      * @param {integer} [opts.townId] - 乡镇id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  modifyAddress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAddress"
      )
    }

    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling modifyAddress"
      )
    }

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.province !== undefined && opts.province !== null) {
      postBody['province'] = opts.province
    }
    if (opts.city !== undefined && opts.city !== null) {
      postBody['city'] = opts.city
    }
    if (opts.county !== undefined && opts.county !== null) {
      postBody['county'] = opts.county
    }
    if (opts.town !== undefined && opts.town !== null) {
      postBody['town'] = opts.town
    }
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.isDefault !== undefined && opts.isDefault !== null) {
      postBody['isDefault'] = opts.isDefault
    }
    if (opts.updateTime !== undefined && opts.updateTime !== null) {
      postBody['updateTime'] = opts.updateTime
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.createTime !== undefined && opts.createTime !== null) {
      postBody['createTime'] = opts.createTime
    }
    if (opts.zipCode !== undefined && opts.zipCode !== null) {
      postBody['zipCode'] = opts.zipCode
    }
    if (opts.provinceId !== undefined && opts.provinceId !== null) {
      postBody['provinceId'] = opts.provinceId
    }
    if (opts.cityId !== undefined && opts.cityId !== null) {
      postBody['cityId'] = opts.cityId
    }
    if (opts.countyId !== undefined && opts.countyId !== null) {
      postBody['countyId'] = opts.countyId
    }
    if (opts.townId !== undefined && opts.townId !== null) {
      postBody['townId'] = opts.townId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAddress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/address/{id}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除发票邮寄地址
      * @param {Object} opts - parameters
      * @param {integer} opts.id
      * @param {string} [opts.pin] - 用户pin(运营后台必传)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  deleteAddress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteAddress"
      )
    }

    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling deleteAddress"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAddress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/address/{id}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加发票邮寄地址
      * @param {Object} opts - parameters
      * @param {integer} [opts.id] - id  optional
      * @param {string} [opts.name] - 收件人姓名  optional
      * @param {string} [opts.phone] - 收件人电话  optional
      * @param {string} [opts.province] - 省  optional
      * @param {string} [opts.city] - 市  optional
      * @param {string} [opts.county] - 区  optional
      * @param {string} [opts.town] - 县  optional
      * @param {string} [opts.address] - 邮编  optional
      * @param {integer} [opts.isDefault] - 是否默认收货地址  optional
      * @param {string} [opts.updateTime] - 更新时间  optional
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} [opts.createTime] - 创建时间  optional
      * @param {string} [opts.zipCode] - 邮编  optional
      * @param {integer} [opts.provinceId] - 省id  optional
      * @param {integer} [opts.cityId] - 市id  optional
      * @param {integer} [opts.countyId] - 区县id  optional
      * @param {integer} [opts.townId] - 乡镇id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  createAddress (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAddress"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.province !== undefined && opts.province !== null) {
      postBody['province'] = opts.province
    }
    if (opts.city !== undefined && opts.city !== null) {
      postBody['city'] = opts.city
    }
    if (opts.county !== undefined && opts.county !== null) {
      postBody['county'] = opts.county
    }
    if (opts.town !== undefined && opts.town !== null) {
      postBody['town'] = opts.town
    }
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.isDefault !== undefined && opts.isDefault !== null) {
      postBody['isDefault'] = opts.isDefault
    }
    if (opts.updateTime !== undefined && opts.updateTime !== null) {
      postBody['updateTime'] = opts.updateTime
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.createTime !== undefined && opts.createTime !== null) {
      postBody['createTime'] = opts.createTime
    }
    if (opts.zipCode !== undefined && opts.zipCode !== null) {
      postBody['zipCode'] = opts.zipCode
    }
    if (opts.provinceId !== undefined && opts.provinceId !== null) {
      postBody['provinceId'] = opts.provinceId
    }
    if (opts.cityId !== undefined && opts.cityId !== null) {
      postBody['cityId'] = opts.cityId
    }
    if (opts.countyId !== undefined && opts.countyId !== null) {
      postBody['countyId'] = opts.countyId
    }
    if (opts.townId !== undefined && opts.townId !== null) {
      postBody['townId'] = opts.townId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAddress with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/address:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询代客开票订单
      * @param {Object} opts - parameters
      * @param {string} opts.pin - 用户pin
      * @param {string} [opts.orderNumber] - 订单号  optional
      * @param {integer} opts.pageIndex - 页码(默认1)
      * @param {integer} opts.pageSize - 每页展示数据量(默认：10)
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param number enableInvoiceFee  可开票金额
      * @param number oweInvoiceFee  发票金额
      * @param boolean isSetInvoiceMSGTemplate  是否设置过有效的发票信息
      * @param invoiceOrderItem invoiceOrderList
      */

  describeInvoiceOrderList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoiceOrderList"
      )
    }

    opts = opts || {}

    if (opts.pin === undefined || opts.pin === null) {
      throw new Error(
        "Missing the required parameter 'opts.pin' when calling describeInvoiceOrderList"
      )
    }
    if (opts.pageIndex === undefined || opts.pageIndex === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageIndex' when calling describeInvoiceOrderList"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeInvoiceOrderList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }
    if (opts.orderNumber !== undefined && opts.orderNumber !== null) {
      queryParams['orderNumber'] = opts.orderNumber
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoiceOrderList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/describeInvoiceOrderList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  代客开票
      * @param {Object} opts - parameters
      * @param {string} [opts.orderIds] - 需要开票的订单号列表，以逗号分隔  optional
      * @param {string} [opts.deductOrderIds] - 抵扣单据单号列表，以逗号分隔  optional
      * @param {string} [opts.mediumType] - 发票类型[电子-electronic]  optional
      * @param {string} [opts.createInvoiceType] - 开票类型[按明细开票-consume，按月账单开票-month，指定金额开票-money(mediumType&#x3D;paper生效)]  optional
      * @param {integer} [opts.invoiceAll] - 是否全部开票[全部开票-1 不需要传orderIds 需要传 开始、结束时间]  optional
      * @param {string} [opts.orderStartTime] - 开票订单的开始时间(开票标识为 全部开票 时不需要传)  optional
      * @param {string} [opts.orderEndTime] - 开票订单的结束时间(开票标识为 全部开票 时不需要传)  optional
      * @param {string} [opts.monthGroups] - 开票月份 仅按月账单开票生效 例（202407,202406）多个月份用逗号分隔  optional
      * @param {number} [opts.amount] - 指定金额开票时 传入金额 开票类型&#x3D;money时必传  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  createInvoiceAgent (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createInvoiceAgent"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.orderIds !== undefined && opts.orderIds !== null) {
      postBody['orderIds'] = opts.orderIds
    }
    if (opts.deductOrderIds !== undefined && opts.deductOrderIds !== null) {
      postBody['deductOrderIds'] = opts.deductOrderIds
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }
    if (
      opts.createInvoiceType !== undefined &&
      opts.createInvoiceType !== null
    ) {
      postBody['createInvoiceType'] = opts.createInvoiceType
    }
    if (opts.invoiceAll !== undefined && opts.invoiceAll !== null) {
      postBody['invoiceAll'] = opts.invoiceAll
    }
    if (opts.orderStartTime !== undefined && opts.orderStartTime !== null) {
      postBody['orderStartTime'] = opts.orderStartTime
    }
    if (opts.orderEndTime !== undefined && opts.orderEndTime !== null) {
      postBody['orderEndTime'] = opts.orderEndTime
    }
    if (opts.monthGroups !== undefined && opts.monthGroups !== null) {
      postBody['monthGroups'] = opts.monthGroups
    }
    if (opts.amount !== undefined && opts.amount !== null) {
      postBody['amount'] = opts.amount
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createInvoiceAgent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/createInvoiceAgent',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改发票模版
      * @param {Object} opts - parameters
      * @param {string} [opts.invoiceType] - 发票类型:[个人增值税普通发票-Personal_VAT_Ordinary_Invoice,企业增值税专用发票-Enterprise_VAT_Special_Invoice,企业增值税普通发票-Enterprise_VAT_Ordinary_Invoice]  optional
      * @param {string} [opts.invoiceTitle] - 发票抬头  optional
      * @param {string} [opts.invoiceContent] - 开票内容（按类别开票/按明细开票）  optional
      * @param {string} [opts.taxId] - 纳税人识别码（发票类型为企业增值税专用发票和企业增值税普通发票时必填）  optional
      * @param {string} [opts.company] - 单位名称（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.phone] - 注册电话（发票类型为个人增值税普通发票和企业增值税普通发票时作为收票人手机号）  optional
      * @param {string} [opts.bank] - 开户银行（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.account] - 银行账户（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.address] - 注册地址（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.email] - 邮箱  optional
      * @param {string} [opts.mediumType] - [电子-electronic]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string msg
      */

  editInvoiceTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  editInvoiceTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.invoiceType !== undefined && opts.invoiceType !== null) {
      postBody['invoiceType'] = opts.invoiceType
    }
    if (opts.invoiceTitle !== undefined && opts.invoiceTitle !== null) {
      postBody['invoiceTitle'] = opts.invoiceTitle
    }
    if (opts.invoiceContent !== undefined && opts.invoiceContent !== null) {
      postBody['invoiceContent'] = opts.invoiceContent
    }
    if (opts.taxId !== undefined && opts.taxId !== null) {
      postBody['taxId'] = opts.taxId
    }
    if (opts.company !== undefined && opts.company !== null) {
      postBody['company'] = opts.company
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.bank !== undefined && opts.bank !== null) {
      postBody['bank'] = opts.bank
    }
    if (opts.account !== undefined && opts.account !== null) {
      postBody['account'] = opts.account
    }
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editInvoiceTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/editInvoiceTemplate',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询已开票的子单
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {array} [opts.childOrderList] - 子单列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string result
      */

  decribeInvoicedChildOrders (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  decribeInvoicedChildOrders"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.childOrderList !== undefined && opts.childOrderList !== null) {
      postBody['childOrderList'] = opts.childOrderList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call decribeInvoicedChildOrders with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoices:decribeInvoicedChildOrders',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发票列表
      * @param {Object} opts - parameters
      * @param {string} [opts.status] - 发票状态[已申请-applied ，处理中-processing ，已开票-invoiced ，已邮寄-mailed ，已驳回-dismissed ，已作废-obsolete ，已取消-cancelled，退票中-refund，已退票-refunded，退票驳回-refund_rejected]  optional
      * @param {string} [opts.searchStartDate] - 开始时间  optional
      * @param {string} [opts.searchEndDate] - 结束时间  optional
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 页大小  optional
      * @param {integer} [opts.invoiceType] - 按明细开票 1 按月结算单开票 2 按指定金额开票 3  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param number enableInvoiceFee  可开票金额
      * @param number invoicedFee  发票金额
      * @param boolean isSetInvoiceMSGTemplate  是否设置过有效的发票信息
      * @param invoiceList invoiceList
      * @param boolean isApplyInvoice  是否可开票
      * @param invoices invoiceSearch
      */

  describeInvoices (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoices"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.searchStartDate !== undefined && opts.searchStartDate !== null) {
      postBody['searchStartDate'] = opts.searchStartDate
    }
    if (opts.searchEndDate !== undefined && opts.searchEndDate !== null) {
      postBody['searchEndDate'] = opts.searchEndDate
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.invoiceType !== undefined && opts.invoiceType !== null) {
      postBody['invoiceType'] = opts.invoiceType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoices with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoices',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发票详情
      * @param {Object} opts - parameters
      * @param {string} opts.invoiceNumber - 发票申请单号
      * @param {integer} opts.pageIndex - 页码(默认1)
      * @param {integer} opts.pageSize - 每页展示数据量(默认：20)
      * @param {integer} [opts.invoiceType] - 发票类型 1详情 2按月  optional
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer id  id
      * @param string invoiceNumber  发票申请单号
      * @param string pin  用户pin
      * @param string invoiceType  发票类型[个人增值税普通发票-Personal_VAT_Ordinary_Invoice，企业增值税专用发票-Enterprise_VAT_Special_Invoice，企业增值税普通发票-Enterprise_VAT_Ordinary_Invoice]
      * @param string invoiceTitle  发票抬头
      * @param string taxNo  税号
      * @param number totalPrice  总价
      * @param string remark  remark
      * @param string invoiceContent  发票内容
      * @param integer userType  用户类型
      * @param integer addressId  地址ID
      * @param integer transportId  transportId
      * @param string createTime  创建日期
      * @param string updateTime  更新日期
      * @param string status  状态[已申请-applied ，处理中-processing ，已开票-invoiced ，已邮寄-mailed ，已驳回-dismissed ，已作废-obsolete ，已取消-cancelled]
      * @param string billingTime  计费日期
      * @param string reason  原因
      * @param string invoiceOrg  invoiceOrg
      * @param string registerAddress  注册地址
      * @param string registerPhone  注册电话
      * @param string accountBank  账户银行
      * @param string account  账户
      * @param string mediumType  类型[纸质-paper，电子-electronic, digital-数电发票]
      * @param string pdfUrl  发票PDF文件链接地址
      * @param string xmlUrl  发票xml文件链接地址
      * @param string ofdUrl  发票ofd文件链接地址
      * @param logistics logistics  物流信息
      * @param postAddress postAddress  邮寄地址
      * @param invoiceOrder invoiceOrders
      * @param monthGroupOrder monthGroupOrders
      * @param integer isHistoryData  区分是否历史数据(1-是 0-否)
      */

  describeInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoice"
      )
    }

    opts = opts || {}

    if (opts.invoiceNumber === undefined || opts.invoiceNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.invoiceNumber' when calling describeInvoice"
      )
    }
    if (opts.pageIndex === undefined || opts.pageIndex === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageIndex' when calling describeInvoice"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling describeInvoice"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.invoiceType !== undefined && opts.invoiceType !== null) {
      queryParams['invoiceType'] = opts.invoiceType
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId,
      invoiceNumber: opts.invoiceNumber
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoice/{invoiceNumber}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  账单明细
      * @param {Object} opts - parameters
      * @param {string} opts.billId - 计费账单编号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param billDataList billDataList
      */

  billDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  billDetail"
      )
    }

    opts = opts || {}

    if (opts.billId === undefined || opts.billId === null) {
      throw new Error(
        "Missing the required parameter 'opts.billId' when calling billDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      billId: opts.billId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call billDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/billDetail/{billId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询企业资质信息详情
      * @param {Object} opts - parameters
      * @param {string} opts.enterpriseName - 企业名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string creditCode  统一社会信用代码
      * @param string registerAddress  注册地址
      * @param string registerPhone  注册电话
      * @param string entName  企业名称
      * @param string entType  企业类型
      */

  getCompanyCreditInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getCompanyCreditInfo"
      )
    }

    opts = opts || {}

    if (opts.enterpriseName === undefined || opts.enterpriseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.enterpriseName' when calling getCompanyCreditInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.enterpriseName !== undefined && opts.enterpriseName !== null) {
      queryParams['enterpriseName'] = opts.enterpriseName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCompanyCreditInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getCompanyCreditInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询订单关联发票信息
      * @param {Object} opts - parameters
      * @param {string} opts.orderId - 订单号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean existed  是否存在关联发票
      * @param string invoiceNumbers  关联发票号
      */

  getOrderRelateInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getOrderRelateInvoice"
      )
    }

    opts = opts || {}

    if (opts.orderId === undefined || opts.orderId === null) {
      throw new Error(
        "Missing the required parameter 'opts.orderId' when calling getOrderRelateInvoice"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.orderId !== undefined && opts.orderId !== null) {
      queryParams['orderId'] = opts.orderId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getOrderRelateInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getOrderRelateInvoice',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询订单关联信息
      * @param {Object} opts - parameters
      * @param {string} opts.orderId - 订单号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean hasInvoice  是否存在关联发票
      * @param string invoiceNumbers  关联发票号
      * @param boolean hasOweTicket  是否关联欠票
      */

  getOrderRelateInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getOrderRelateInfo"
      )
    }

    opts = opts || {}

    if (opts.orderId === undefined || opts.orderId === null) {
      throw new Error(
        "Missing the required parameter 'opts.orderId' when calling getOrderRelateInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.orderId !== undefined && opts.orderId !== null) {
      queryParams['orderId'] = opts.orderId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getOrderRelateInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getOrderRelateInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建发票
      * @param {Object} opts - parameters
      * @param {string} [opts.orderIds] - 需要开票的订单号列表，以逗号分隔  optional
      * @param {string} [opts.deductOrderIds] - 抵扣单据单号列表，以逗号分隔  optional
      * @param {string} [opts.mediumType] - 发票类型[电子-electronic]  optional
      * @param {string} [opts.createInvoiceType] - 开票类型[按明细开票-consume，按月账单开票-month，指定金额开票-money(mediumType&#x3D;paper生效)]  optional
      * @param {integer} [opts.invoiceAll] - 是否全部开票[全部开票-1 不需要传orderIds 需要传 开始、结束时间]  optional
      * @param {string} [opts.orderStartTime] - 开票订单的开始时间(开票标识为 全部开票 时不需要传)  optional
      * @param {string} [opts.orderEndTime] - 开票订单的结束时间(开票标识为 全部开票 时不需要传)  optional
      * @param {string} [opts.monthGroups] - 开票月份 仅按月账单开票生效 例（202407,202406）多个月份用逗号分隔  optional
      * @param {number} [opts.amount] - 指定金额开票时 传入金额 开票类型&#x3D;money时必传  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  createInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createInvoice"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.orderIds !== undefined && opts.orderIds !== null) {
      postBody['orderIds'] = opts.orderIds
    }
    if (opts.deductOrderIds !== undefined && opts.deductOrderIds !== null) {
      postBody['deductOrderIds'] = opts.deductOrderIds
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }
    if (
      opts.createInvoiceType !== undefined &&
      opts.createInvoiceType !== null
    ) {
      postBody['createInvoiceType'] = opts.createInvoiceType
    }
    if (opts.invoiceAll !== undefined && opts.invoiceAll !== null) {
      postBody['invoiceAll'] = opts.invoiceAll
    }
    if (opts.orderStartTime !== undefined && opts.orderStartTime !== null) {
      postBody['orderStartTime'] = opts.orderStartTime
    }
    if (opts.orderEndTime !== undefined && opts.orderEndTime !== null) {
      postBody['orderEndTime'] = opts.orderEndTime
    }
    if (opts.monthGroups !== undefined && opts.monthGroups !== null) {
      postBody['monthGroups'] = opts.monthGroups
    }
    if (opts.amount !== undefined && opts.amount !== null) {
      postBody['amount'] = opts.amount
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  退票
      * @param {Object} opts - parameters
      * @param {string} opts.invoiceNumber - 发票申请单号
      * @param {string} [opts.refundReason] - 退票原因  optional
      * @param {string} [opts.remark] - 备注信息  optional
      * @param {string} [opts.logisticsCompany] - 物流公司  optional
      * @param {string} [opts.logisticsOrderNumber] - 物流单号  optional
      * @param {string} [opts.mediumType] - [纸质-paper，电子-electronic]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  refundInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  refundInvoice"
      )
    }

    opts = opts || {}

    if (opts.invoiceNumber === undefined || opts.invoiceNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.invoiceNumber' when calling refundInvoice"
      )
    }

    let postBody = {}
    if (opts.refundReason !== undefined && opts.refundReason !== null) {
      postBody['refundReason'] = opts.refundReason
    }
    if (opts.remark !== undefined && opts.remark !== null) {
      postBody['remark'] = opts.remark
    }
    if (opts.logisticsCompany !== undefined && opts.logisticsCompany !== null) {
      postBody['logisticsCompany'] = opts.logisticsCompany
    }
    if (
      opts.logisticsOrderNumber !== undefined &&
      opts.logisticsOrderNumber !== null
    ) {
      postBody['logisticsOrderNumber'] = opts.logisticsOrderNumber
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      invoiceNumber: opts.invoiceNumber
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call refundInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoice/{invoiceNumber}:refund',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  人工退票
      * @param {Object} opts - parameters
      * @param {string} [opts.orderId] - 退款订单号  optional
      * @param {string} [opts.refundAmount] - 退款金额  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  artificialRefund (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  artificialRefund"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.orderId !== undefined && opts.orderId !== null) {
      postBody['orderId'] = opts.orderId
    }
    if (opts.refundAmount !== undefined && opts.refundAmount !== null) {
      postBody['refundAmount'] = opts.refundAmount
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call artificialRefund with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceorder:artificialRefund',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  撤回发票
      * @param {Object} opts - parameters
      * @param {string} opts.invoiceNumber - 发票申请单号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  cancelInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  cancelInvoice"
      )
    }

    opts = opts || {}

    if (opts.invoiceNumber === undefined || opts.invoiceNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.invoiceNumber' when calling cancelInvoice"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      invoiceNumber: opts.invoiceNumber
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cancelInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoice/{invoiceNumber}:cancel',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取电子发票下载地址
      * @param {Object} opts - parameters
      * @param {string} [opts.businessId] - 订单号或者申请单号  optional
      * @param {string} [opts.ivcCode] - 发票代码  optional
      * @param {string} [opts.ivcNo] - 发票号码  optional
      * @param {string} [opts.wid] - 商品编号  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string msg
      * @param string result
      */

  describeInvoiceUrl (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoiceUrl"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.businessId !== undefined && opts.businessId !== null) {
      postBody['businessId'] = opts.businessId
    }
    if (opts.ivcCode !== undefined && opts.ivcCode !== null) {
      postBody['ivcCode'] = opts.ivcCode
    }
    if (opts.ivcNo !== undefined && opts.ivcNo !== null) {
      postBody['ivcNo'] = opts.ivcNo
    }
    if (opts.wid !== undefined && opts.wid !== null) {
      postBody['wid'] = opts.wid
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoiceUrl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoice:downloadurl',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开票单据列表
      * @param {Object} opts - parameters
      * @param {string} [opts.searchStartTime] - 开始时间  optional
      * @param {string} [opts.searchEndTime] - 结束时间  optional
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 页大小  optional
      * @param {string} [opts.receiptType] - 单据类型[订单-order，账单-bill 月结算单-month]  optional
      * @param {integer} [opts.payType] - 交易(支付)类型 1-代付 2-自付  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param number enableInvoiceFee  可开票金额
      * @param number enableAllInvoiceFee  可开票总金额
      * @param number oweInvoiceFee  发票金额
      * @param boolean isSetInvoiceMSGTemplate  是否设置过有效的发票信息
      * @param invoiceOrderItem invoiceOrderList
      */

  describeInvoiceOrders (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoiceOrders"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.searchStartTime !== undefined && opts.searchStartTime !== null) {
      postBody['searchStartTime'] = opts.searchStartTime
    }
    if (opts.searchEndTime !== undefined && opts.searchEndTime !== null) {
      postBody['searchEndTime'] = opts.searchEndTime
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.receiptType !== undefined && opts.receiptType !== null) {
      postBody['receiptType'] = opts.receiptType
    }
    if (opts.payType !== undefined && opts.payType !== null) {
      postBody['payType'] = opts.payType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoiceOrders with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceorder:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  欠票列表
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {integer} [opts.pageIndex] - 页码  optional
      * @param {integer} [opts.pageSize] - 页大小  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param number oweFee  欠票总金额
      * @param invoiceOweList invoiceOweList
      */

  invoiceOweList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invoiceOweList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      postBody['pageIndex'] = opts.pageIndex
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invoiceOweList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceOweList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  抵扣欠票
      * @param {Object} opts - parameters
      * @param {string} [opts.orderIds] - 抵扣订单号  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  [0成功]
      * @param string msg  [msg&#x3D;success成功]
      */

  deductOweFee (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deductOweFee"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.orderIds !== undefined && opts.orderIds !== null) {
      postBody['orderIds'] = opts.orderIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deductOweFee with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/deductOweFee',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据产品线取税率
      * @param {Object} opts - parameters
      * @param {string} opts.serviceCode - 产品线
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param taxInfo result
      */

  getTaxInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTaxInfo"
      )
    }

    opts = opts || {}

    if (opts.serviceCode === undefined || opts.serviceCode === null) {
      throw new Error(
        "Missing the required parameter 'opts.serviceCode' when calling getTaxInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.serviceCode !== undefined && opts.serviceCode !== null) {
      queryParams['serviceCode'] = opts.serviceCode
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTaxInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getTaxInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发票预览信息
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} [opts.orderIds] - 订单号 多个用逗号,分开  optional
      * @param {array} [opts.deductInfoList] - 欠票抵扣的订单信息  optional
      * @param {number} [opts.amount] - 指定开票金额  optional
      * @param {string} [opts.monthGroups] - 开票月份 仅按月开票生效  optional
      * @param {string} [opts.mediumType] - 发票类型[电子-electronic, 数电-digital]  optional
      * @param {integer} [opts.invoiceAll] - 全部开票标识 1-全部开票 全部开票, 不需要传orderIds 需要传 开始、结束时间  optional
      * @param {string} [opts.orderStartTime] - 开票订单的开始时间(yyyy-MM-dd HH:mm:ss)  optional
      * @param {string} [opts.orderEndTime] - 开票订单的结束时间(yyyy-MM-dd HH:mm:ss)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param invoicePreviewRespVo result
      */

  getInvoicePreview (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getInvoicePreview"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.orderIds !== undefined && opts.orderIds !== null) {
      postBody['orderIds'] = opts.orderIds
    }
    if (opts.deductInfoList !== undefined && opts.deductInfoList !== null) {
      postBody['deductInfoList'] = opts.deductInfoList
    }
    if (opts.amount !== undefined && opts.amount !== null) {
      postBody['amount'] = opts.amount
    }
    if (opts.monthGroups !== undefined && opts.monthGroups !== null) {
      postBody['monthGroups'] = opts.monthGroups
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }
    if (opts.invoiceAll !== undefined && opts.invoiceAll !== null) {
      postBody['invoiceAll'] = opts.invoiceAll
    }
    if (opts.orderStartTime !== undefined && opts.orderStartTime !== null) {
      postBody['orderStartTime'] = opts.orderStartTime
    }
    if (opts.orderEndTime !== undefined && opts.orderEndTime !== null) {
      postBody['orderEndTime'] = opts.orderEndTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getInvoicePreview with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/getInvoicePreview',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据订单信息和总金额计算单个订单金额
      * @param {Object} opts - parameters
      * @param {number} [opts.amount] - 预开票总金额（不传则简单计算金额）  optional
      * @param {array} [opts.orderInfo]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param orderInfoRes result
      */

  calculateInvoicePrice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  calculateInvoicePrice"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.amount !== undefined && opts.amount !== null) {
      postBody['amount'] = opts.amount
    }
    if (opts.orderInfo !== undefined && opts.orderInfo !== null) {
      postBody['orderInfo'] = opts.orderInfo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call calculateInvoicePrice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/calculateInvoicePrice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按月查询发票详情
      * @param {Object} opts - parameters
      * @param {string} opts.month - 发票月份 yyyy-MM
      * @param {string} [opts.pin] - 用户pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param invoiceDetails result
      */

  describeMonthDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeMonthDetail"
      )
    }

    opts = opts || {}

    if (opts.month === undefined || opts.month === null) {
      throw new Error(
        "Missing the required parameter 'opts.month' when calling describeMonthDetail"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId,
      month: opts.month
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMonthDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceorder/{month}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询发票抬头信息
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - 用户pin(运营后台必传)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param vat vat  vat
      * @param invoiceMsgTemplate invoiceMsgTemplate  发票抬头信息
      */

  describeInvoiceTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInvoiceTemplate"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      queryParams['pin'] = opts.pin
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInvoiceTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceTemplate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置发票信息抬头
      * @param {Object} opts - parameters
      * @param {string} [opts.invoiceType] - 发票类型:[个人增值税普通发票-Personal_VAT_Ordinary_Invoice,企业增值税专用发票-Enterprise_VAT_Special_Invoice,企业增值税普通发票-Enterprise_VAT_Ordinary_Invoice]  optional
      * @param {string} [opts.invoiceTitle] - 发票抬头  optional
      * @param {string} [opts.invoiceContent] - 开票内容（按类别开票/按明细开票）  optional
      * @param {string} [opts.taxId] - 纳税人识别码（发票类型为企业增值税专用发票和企业增值税普通发票时必填）  optional
      * @param {string} [opts.company] - 单位名称（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.phone] - 注册电话（发票类型为个人增值税普通发票和企业增值税普通发票时作为收票人手机号）  optional
      * @param {string} [opts.bank] - 开户银行（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.account] - 银行账户（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.address] - 注册地址（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.email] - 邮箱  optional
      * @param {string} [opts.mediumType] - [电子-electronic]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string msg
      */

  createInvoiceTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createInvoiceTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.invoiceType !== undefined && opts.invoiceType !== null) {
      postBody['invoiceType'] = opts.invoiceType
    }
    if (opts.invoiceTitle !== undefined && opts.invoiceTitle !== null) {
      postBody['invoiceTitle'] = opts.invoiceTitle
    }
    if (opts.invoiceContent !== undefined && opts.invoiceContent !== null) {
      postBody['invoiceContent'] = opts.invoiceContent
    }
    if (opts.taxId !== undefined && opts.taxId !== null) {
      postBody['taxId'] = opts.taxId
    }
    if (opts.company !== undefined && opts.company !== null) {
      postBody['company'] = opts.company
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.bank !== undefined && opts.bank !== null) {
      postBody['bank'] = opts.bank
    }
    if (opts.account !== undefined && opts.account !== null) {
      postBody['account'] = opts.account
    }
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createInvoiceTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceTemplate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改发票模版
      * @param {Object} opts - parameters
      * @param {string} [opts.invoiceType] - 发票类型:[个人增值税普通发票-Personal_VAT_Ordinary_Invoice,企业增值税专用发票-Enterprise_VAT_Special_Invoice,企业增值税普通发票-Enterprise_VAT_Ordinary_Invoice]  optional
      * @param {string} [opts.invoiceTitle] - 发票抬头  optional
      * @param {string} [opts.invoiceContent] - 开票内容（按类别开票/按明细开票）  optional
      * @param {string} [opts.taxId] - 纳税人识别码（发票类型为企业增值税专用发票和企业增值税普通发票时必填）  optional
      * @param {string} [opts.company] - 单位名称（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.phone] - 注册电话（发票类型为个人增值税普通发票和企业增值税普通发票时作为收票人手机号）  optional
      * @param {string} [opts.bank] - 开户银行（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.account] - 银行账户（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.address] - 注册地址（发票类型为企业增值税专用发票时必填）  optional
      * @param {string} [opts.email] - 邮箱  optional
      * @param {string} [opts.mediumType] - [电子-electronic]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string msg
      */

  modifyInvoiceTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyInvoiceTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.invoiceType !== undefined && opts.invoiceType !== null) {
      postBody['invoiceType'] = opts.invoiceType
    }
    if (opts.invoiceTitle !== undefined && opts.invoiceTitle !== null) {
      postBody['invoiceTitle'] = opts.invoiceTitle
    }
    if (opts.invoiceContent !== undefined && opts.invoiceContent !== null) {
      postBody['invoiceContent'] = opts.invoiceContent
    }
    if (opts.taxId !== undefined && opts.taxId !== null) {
      postBody['taxId'] = opts.taxId
    }
    if (opts.company !== undefined && opts.company !== null) {
      postBody['company'] = opts.company
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.bank !== undefined && opts.bank !== null) {
      postBody['bank'] = opts.bank
    }
    if (opts.account !== undefined && opts.account !== null) {
      postBody['account'] = opts.account
    }
    if (opts.address !== undefined && opts.address !== null) {
      postBody['address'] = opts.address
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.mediumType !== undefined && opts.mediumType !== null) {
      postBody['mediumType'] = opts.mediumType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyInvoiceTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceTemplate',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除发票模版
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string msg
      */

  deleteInvoiceTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteInvoiceTemplate"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteInvoiceTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/invoiceTemplate',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量查询订单是否有欠票状态
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - pin  optional
      * @param {array} [opts.refundInfoList] - 退款订单信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param checkResult result  true-有欠票, false-无欠票
      */

  checkInvoiceOwedInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkInvoiceOwedInfo"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.refundInfoList !== undefined && opts.refundInfoList !== null) {
      postBody['refundInfoList'] = opts.refundInfoList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkInvoiceOwedInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/checkInvoiceOwedInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量更新发票系统中订单的退款信息
      * @param {Object} opts - parameters
      * @param {string} [opts.pin] - pin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean result  true-更新成功, false-更新失败
      */

  batchUpdateInvoiceRefundOrder (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  batchUpdateInvoiceRefundOrder"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchUpdateInvoiceRefundOrder with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/batchUpdateInvoiceRefundOrder',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  退款欠票信息
      * @param {Object} opts - parameters
      * @param {array} [opts.invoiceOweInfoList] - 退款欠票信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean result  true-更新成功, false-更新失败
      */

  refundOwedInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  refundOwedInvoice"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (
      opts.invoiceOweInfoList !== undefined &&
      opts.invoiceOweInfoList !== null
    ) {
      postBody['invoiceOweInfoList'] = opts.invoiceOweInfoList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call refundOwedInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/refundOwedInvoice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查订单的开票信息
      * @param {Object} opts - parameters
      * @param {string} opts.pin - 用户pin
      * @param {array} [opts.orderNumberList] - 订单列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param orderInvoiceInfo result  订单开票信息
      */

  describeOrderInvoice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeOrderInvoice"
      )
    }

    opts = opts || {}

    if (opts.pin === undefined || opts.pin === null) {
      throw new Error(
        "Missing the required parameter 'opts.pin' when calling describeOrderInvoice"
      )
    }

    let postBody = {}
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.orderNumberList !== undefined && opts.orderNumberList !== null) {
      postBody['orderNumberList'] = opts.orderNumberList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeOrderInvoice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/describeOrderInvoice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  包年包月退款更新发票的退款金额
      * @param {Object} opts - parameters
      * @param {array} [opts.refundInfoList]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean result  true-更新成功 false-更新失败
      * @param string message  结果消息
      */

  updateInvoiceRefundAmount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateInvoiceRefundAmount"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.refundInfoList !== undefined && opts.refundInfoList !== null) {
      postBody['refundInfoList'] = opts.refundInfoList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  invoice/0.4.11'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateInvoiceRefundAmount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/updateInvoiceRefundAmount',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = INVOICE
