/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * IoTHubInstance
 * IoT Hub共享模式和独享模式共用接口
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'iotcore'
Service._services[serviceId] = true

/**
 * iotcore service.
 * @version 1.1.25
 */

class IOTCORE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'iotcore.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  设备注册接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceInfoVO} opts.deviceInfoVO - 物模型ID编号
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string deviceId  注册设备返回的设备ID
      */

  registerDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  registerDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling registerDevice"
      )
    }
    if (opts.deviceInfoVO === undefined || opts.deviceInfoVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceInfoVO' when calling registerDevice"
      )
    }

    let postBody = {}
    if (opts.deviceInfoVO !== undefined && opts.deviceInfoVO !== null) {
      postBody['deviceInfoVO'] = opts.deviceInfoVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call registerDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/device:register',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  下载设备证书接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} opts.deviceId - 设备ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string deviceId  证书对应deviceId
      * @param string deviceCertUrl  证书zip包对应链接，默认有效时长10分钟
      */

  downloadDeviceCertificate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  downloadDeviceCertificate"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling downloadDeviceCertificate"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling downloadDeviceCertificate"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceId !== undefined && opts.deviceId !== null) {
      queryParams['deviceId'] = opts.deviceId
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call downloadDeviceCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/device:downloadCertificate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备删除接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} opts.deviceId - 设备ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  是否删除成功
      */

  deleteDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deleteDevice"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling deleteDevice"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceId !== undefined && opts.deviceId !== null) {
      queryParams['deviceId'] = opts.deviceId
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/device:delete',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个设备详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} opts.deviceId - 设备ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceInfoVO deviceInfoVO
      */

  describeDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeDevice"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling describeDevice"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceId !== undefined && opts.deviceId !== null) {
      queryParams['deviceId'] = opts.deviceId
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/device:describe',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询物类型列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} [opts.deviceMetaId] - 设备型号标识  optional
      * @param {string} [opts.deviceMetaName] - 设备型号名称  optional
      * @param {integer} [opts.nodeType] - 节点类型  optional
      * @param {integer} [opts.pageNo] - 页码  optional
      * @param {integer} [opts.pageSize] - 每页显示条数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer currentPage
      * @param integer totalCount
      * @param thingTypeInfoVO list
      */

  describeThingTypeList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeThingTypeList"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeThingTypeList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceMetaId !== undefined && opts.deviceMetaId !== null) {
      queryParams['deviceMetaId'] = opts.deviceMetaId
    }
    if (opts.deviceMetaName !== undefined && opts.deviceMetaName !== null) {
      queryParams['deviceMetaName'] = opts.deviceMetaName
    }
    if (opts.nodeType !== undefined && opts.nodeType !== null) {
      queryParams['nodeType'] = opts.nodeType
    }
    if (opts.pageNo !== undefined && opts.pageNo !== null) {
      queryParams['pageNo'] = opts.pageNo
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeThingTypeList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/thingType:list',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询物类型详情
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} [opts.deviceMetaId] - 设备型号标识  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param thingTypeInfoVO thingTypeInfoVO
      */

  describeThingType (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeThingType"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeThingType"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceMetaId !== undefined && opts.deviceMetaId !== null) {
      queryParams['deviceMetaId'] = opts.deviceMetaId
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeThingType with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/thingType:describe',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据物类型Code查看物模型完整信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} opts.thingTypeCode - 物类型Code
      * @param {string} [opts.thingModelVersion] - 版本号。如果为空，则返回最新版本  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param thingModelRespTO thingModelRespTO
      */

  describeThingModel (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeThingModel"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeThingModel"
      )
    }
    if (opts.thingTypeCode === undefined || opts.thingTypeCode === null) {
      throw new Error(
        "Missing the required parameter 'opts.thingTypeCode' when calling describeThingModel"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.thingTypeCode !== undefined && opts.thingTypeCode !== null) {
      queryParams['thingTypeCode'] = opts.thingTypeCode
    }
    if (
      opts.thingModelVersion !== undefined &&
      opts.thingModelVersion !== null
    ) {
      queryParams['thingModelVersion'] = opts.thingModelVersion
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeThingModel with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/thingModel:describe',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备控制接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {devicePropertyVO} opts.devicePropertyVO - 设备ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  是否设置成功
      */

  setDeviceProperty (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setDeviceProperty"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling setDeviceProperty"
      )
    }
    if (opts.devicePropertyVO === undefined || opts.devicePropertyVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.devicePropertyVO' when calling setDeviceProperty"
      )
    }

    let postBody = {}
    if (opts.devicePropertyVO !== undefined && opts.devicePropertyVO !== null) {
      postBody['devicePropertyVO'] = opts.devicePropertyVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setDeviceProperty with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/deviceProperty:set',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备方法执行
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceFunctionVO} opts.deviceFunctionVO - 设备方法
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code
      * @param string message
      * @param boolean success
      * @param deviceFunctionVO returnValues
      */

  invokeFunction (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invokeFunction"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling invokeFunction"
      )
    }
    if (opts.deviceFunctionVO === undefined || opts.deviceFunctionVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceFunctionVO' when calling invokeFunction"
      )
    }

    let postBody = {}
    if (opts.deviceFunctionVO !== undefined && opts.deviceFunctionVO !== null) {
      postBody['deviceFunctionVO'] = opts.deviceFunctionVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invokeFunction with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/function:invokeFunction',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备事件查询
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {eventReportPageBo} opts.eventReportPageBo - 事件查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer currentPage
      * @param integer totalCount
      * @param eventReportVo list
      */

  describeEventList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeEventList"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeEventList"
      )
    }
    if (
      opts.eventReportPageBo === undefined ||
      opts.eventReportPageBo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.eventReportPageBo' when calling describeEventList"
      )
    }

    let postBody = {}
    if (
      opts.eventReportPageBo !== undefined &&
      opts.eventReportPageBo !== null
    ) {
      postBody['eventReportPageBo'] = opts.eventReportPageBo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeEventList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/event:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询方法调用列表信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {functionCallPageBo} opts.functionCallPageBo - 方法查询请求对象
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer currentPage
      * @param integer totalCount
      * @param functionCallRecordVo list
      */

  describeFunctionList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeFunctionList"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeFunctionList"
      )
    }
    if (
      opts.functionCallPageBo === undefined ||
      opts.functionCallPageBo === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.functionCallPageBo' when calling describeFunctionList"
      )
    }

    let postBody = {}
    if (
      opts.functionCallPageBo !== undefined &&
      opts.functionCallPageBo !== null
    ) {
      postBody['functionCallPageBo'] = opts.functionCallPageBo
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeFunctionList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/function:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询属性接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {string} opts.deviceId - 设备ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param propertyAcquireVo propertyAcquireVo
      */

  describeProperty (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeProperty"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeProperty"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling describeProperty"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceId !== undefined && opts.deviceId !== null) {
      queryParams['deviceId'] = opts.deviceId
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProperty with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/property:describe',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  属性获取接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceSnapshotRequestVO} opts.deviceSnapshotRequestVO - 方法查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string snapShot  JSON字符串格式属性结果
      */

  describePropertySnapshot (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePropertySnapshot"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describePropertySnapshot"
      )
    }
    if (
      opts.deviceSnapshotRequestVO === undefined ||
      opts.deviceSnapshotRequestVO === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.deviceSnapshotRequestVO' when calling describePropertySnapshot"
      )
    }

    let postBody = {}
    if (
      opts.deviceSnapshotRequestVO !== undefined &&
      opts.deviceSnapshotRequestVO !== null
    ) {
      postBody['deviceSnapshotRequestVO'] = opts.deviceSnapshotRequestVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePropertySnapshot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/property:describeSnapshot',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  边缘代理设备与非直连设备拓扑关系创建接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceTopoInfoVO} opts.deviceTopoInfoVO - 方法查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceTopoResult deviceTopoResult
      */

  createDeviceTopo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createDeviceTopo"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createDeviceTopo"
      )
    }
    if (opts.deviceTopoInfoVO === undefined || opts.deviceTopoInfoVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceTopoInfoVO' when calling createDeviceTopo"
      )
    }

    let postBody = {}
    if (opts.deviceTopoInfoVO !== undefined && opts.deviceTopoInfoVO !== null) {
      postBody['deviceTopoInfoVO'] = opts.deviceTopoInfoVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDeviceTopo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/deviceTopo:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  边缘代理设备与非直连设备拓扑关系查询接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceTopoPageBO} opts.deviceTopoPageBO - 方法查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer currentPage
      * @param integer totalCount
      * @param deviceTopoRecordVO list
      */

  describeDeviceTopo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDeviceTopo"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeDeviceTopo"
      )
    }
    if (opts.deviceTopoPageBO === undefined || opts.deviceTopoPageBO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceTopoPageBO' when calling describeDeviceTopo"
      )
    }

    let postBody = {}
    if (opts.deviceTopoPageBO !== undefined && opts.deviceTopoPageBO !== null) {
      postBody['deviceTopoPageBO'] = opts.deviceTopoPageBO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDeviceTopo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/deviceTopo:describe',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  边缘代理设备与非直连设备拓扑关系更新接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceTopoInfoVO} opts.deviceTopoInfoVO - 方法查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceTopoResult deviceTopoResult
      */

  updateDeviceTopo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateDeviceTopo"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateDeviceTopo"
      )
    }
    if (opts.deviceTopoInfoVO === undefined || opts.deviceTopoInfoVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceTopoInfoVO' when calling updateDeviceTopo"
      )
    }

    let postBody = {}
    if (opts.deviceTopoInfoVO !== undefined && opts.deviceTopoInfoVO !== null) {
      postBody['deviceTopoInfoVO'] = opts.deviceTopoInfoVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDeviceTopo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/deviceTopo:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  边缘代理设备与非直连设备拓扑关系删除接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例Id
      * @param {deviceTopoInfoVO} opts.deviceTopoInfoVO - 方法查询请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceTopoResult deviceTopoResult
      */

  deleteDeviceTopo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteDeviceTopo"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deleteDeviceTopo"
      )
    }
    if (opts.deviceTopoInfoVO === undefined || opts.deviceTopoInfoVO === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceTopoInfoVO' when calling deleteDeviceTopo"
      )
    }

    let postBody = {}
    if (opts.deviceTopoInfoVO !== undefined && opts.deviceTopoInfoVO !== null) {
      postBody['deviceTopoInfoVO'] = opts.deviceTopoInfoVO
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDeviceTopo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/coreinstances/{instanceId}/deviceTopo:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备Topic调用
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.identifier - 设备唯一标识
      * @param {string} opts.productKey - 产品Key
      * @param {string} opts.topicShortName - Topic如/user/{productKey}/{identifier}/topicShortName
不支持系统Topic

      * @param {string} opts.topicMessage - 要发送的消息主体
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string msgId  消息唯一标识
      */

  invokeThingTopic (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invokeThingTopic"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling invokeThingTopic"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling invokeThingTopic"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling invokeThingTopic"
      )
    }
    if (opts.topicShortName === undefined || opts.topicShortName === null) {
      throw new Error(
        "Missing the required parameter 'opts.topicShortName' when calling invokeThingTopic"
      )
    }
    if (opts.topicMessage === undefined || opts.topicMessage === null) {
      throw new Error(
        "Missing the required parameter 'opts.topicMessage' when calling invokeThingTopic"
      )
    }

    let postBody = {}
    if (opts.topicShortName !== undefined && opts.topicShortName !== null) {
      postBody['topicShortName'] = opts.topicShortName
    }
    if (opts.topicMessage !== undefined && opts.topicMessage !== null) {
      postBody['topicMessage'] = opts.topicMessage
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      identifier: opts.identifier,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invokeThingTopic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/devices/{identifier}/topic',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看设备影子
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.identifier - 设备唯一标识
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object state  设备状态
      * @param object metadata  当用户更新设备状态文档后，设备影子服务会自动更新metadata的值。设备状态的元数据的信息包含以 Epoch 时间表示的每个属性的时间戳，用来获取准确的更新时间。
      * @param integer version  设备影子版本
      * @param integer timestamp  设备影子更新时间
      */

  describeThingShadow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeThingShadow"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeThingShadow"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling describeThingShadow"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeThingShadow"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      identifier: opts.identifier,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeThingShadow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/devices/{identifier}/shadow',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新设备影子的期望值
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.identifier - 设备唯一标识
      * @param {string} opts.productKey - 产品Key
      * @param {object} [opts.state] - 运行状态  optional
      * @param {integer} [opts.version] - 设备影子版本,当前版本加1，当前版本默认其实版本为-1
用户主动更新版本号时，设备影子会检查请求中的主动更新版本号是否大于当前版本号。
如果大于当前版本号，则更新设备影子，并将影子版本值更新到请求的版本中，反之则会拒绝更新设备影子。
影子版本参数为Integer型
取值范围：0到2147483647(2的31次方-1)
当取值达到最大值2147483647(2的31次方-1)时，请求中的主动更新版本号应为-1
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateThingShadow (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateThingShadow"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateThingShadow"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling updateThingShadow"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling updateThingShadow"
      )
    }

    let postBody = {}
    if (opts.state !== undefined && opts.state !== null) {
      postBody['state'] = opts.state
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      identifier: opts.identifier,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateThingShadow with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/devices/{identifier}/shadow',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备服务调用
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.identifier - 设备唯一标识
      * @param {string} opts.productKey - 产品Key
      * @param {string} opts.name - 服务名称
      * @param {object} [opts.input] - 输入参数,object的key为参数名称，value为参数值  optional
      * @param {string} [opts.callbackBeanName] - 回调spring的bean的名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string msgId  消息唯一标识
      */

  invokeThingService (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  invokeThingService"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling invokeThingService"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling invokeThingService"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling invokeThingService"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling invokeThingService"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.input !== undefined && opts.input !== null) {
      postBody['input'] = opts.input
    }
    if (opts.callbackBeanName !== undefined && opts.callbackBeanName !== null) {
      postBody['callbackBeanName'] = opts.callbackBeanName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      identifier: opts.identifier,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call invokeThingService with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/devices/{identifier}/services',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  建立设备间的父子关系
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.parentId - 父级设备Id，只允许网关设备作为父级设备
      * @param {string} [opts.productKey] - 将此产品下所有设备都设置为parentId的子设备，只允许普通设备类型的productKey  optional
      * @param {array} [opts.children] - 子设备Id集合，children和productKey二者至少填一个，二者都填写则同时生效，只允许普通设备类型的deviceId  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addDeviceLinks (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addDeviceLinks"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling addDeviceLinks"
      )
    }
    if (opts.parentId === undefined || opts.parentId === null) {
      throw new Error(
        "Missing the required parameter 'opts.parentId' when calling addDeviceLinks"
      )
    }

    let postBody = {}
    if (opts.parentId !== undefined && opts.parentId !== null) {
      postBody['parentId'] = opts.parentId
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      postBody['productKey'] = opts.productKey
    }
    if (opts.children !== undefined && opts.children !== null) {
      postBody['children'] = opts.children
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addDeviceLinks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devices:addLinks',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分页查询设备信息,支持一个或多个条件
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.deviceName] - 设备名称，模糊匹配  optional
      * @param {integer} [opts.status] - 设备状态 0-未激活，1-激活离线，2-激活在线  optional
      * @param {string} [opts.productKey] - 设备所归属的产品Key  optional
      * @param {integer} [opts.deviceType] - 设备类型，同产品类型，0-设备，1-网关  optional
      * @param {integer} [opts.nowPage] - 当前页数  optional
      * @param {integer} [opts.pageSize] - 每页的数据条数  optional
      * @param {string} [opts.order] - 排序关键字--name,type,productKey,status--最多支持一个字段  optional
      * @param {string} [opts.direction] - 顺序，升序降序--asc,desc  optional
      * @param {string} [opts.parentId] - 父设备Id  optional
      * @param {integer} [opts.orderId] - 订单号  optional
      * @param {string} [opts.deviceCollectorType] - 设备采集器类型  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer nowPage
      * @param integer totalSize
      * @param integer totalPage
      * @param deviceVO data
      */

  queryDevicePage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryDevicePage"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling queryDevicePage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      queryParams['deviceName'] = opts.deviceName
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      queryParams['productKey'] = opts.productKey
    }
    if (opts.deviceType !== undefined && opts.deviceType !== null) {
      queryParams['deviceType'] = opts.deviceType
    }
    if (opts.nowPage !== undefined && opts.nowPage !== null) {
      queryParams['nowPage'] = opts.nowPage
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }
    if (opts.parentId !== undefined && opts.parentId !== null) {
      queryParams['parentId'] = opts.parentId
    }
    if (opts.orderId !== undefined && opts.orderId !== null) {
      queryParams['orderId'] = opts.orderId
    }
    if (
      opts.deviceCollectorType !== undefined &&
      opts.deviceCollectorType !== null
    ) {
      queryParams['deviceCollectorType'] = opts.deviceCollectorType
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDevicePage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devices:queryPage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改设备详情
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.deviceId - 设备Id
      * @param {string} [opts.model] - 设备型号  optional
      * @param {string} [opts.manufacturer] - 设备厂商  optional
      * @param {string} [opts.description] - 设备描述  optional
      * @param {integer} [opts.status] - 设备状态  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceVO device  设备详情
      */

  updateDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateDevice"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling updateDevice"
      )
    }

    let postBody = {}
    if (opts.model !== undefined && opts.model !== null) {
      postBody['model'] = opts.model
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      postBody['manufacturer'] = opts.manufacturer
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      deviceId: opts.deviceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/device/{deviceId}:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  注册单个设备并返回秘钥信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.deviceName] - 设备名称  optional
      * @param {string} [opts.productKey] - 设备所归属的产品  optional
      * @param {string} [opts.model] - 设备型号  optional
      * @param {string} [opts.manufacturer] - 厂商  optional
      * @param {string} [opts.description] - 设备描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string deviceName  设备名称
      * @param string identifier  设备标识符
      * @param string secret  设备秘钥
      */

  addDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling addDevice"
      )
    }

    let postBody = {}
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      postBody['deviceName'] = opts.deviceName
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      postBody['productKey'] = opts.productKey
    }
    if (opts.model !== undefined && opts.model !== null) {
      postBody['model'] = opts.model
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      postBody['manufacturer'] = opts.manufacturer
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/device:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询设备详情
      * @param {Object} opts - parameters
      * @param {string} opts.deviceName - 设备名称
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string deviceId  设备ID
      * @param string deviceName  设备名称
      * @param string parentId  父级设备Id
      * @param string deviceType  设备类型，同产品类型，0-普通设备，1-网关，2-Edge
      * @param integer status  设备状态，0-未激活，1-激活离线，2-激活在线
      * @param string productKey  产品Key
      * @param string identifier  设备标识符
      * @param string secret  设备秘钥
      * @param string description  设备描述
      * @param integer activatedTime  激活时间
      * @param integer lastConnectedTime  最后连接时间
      * @param integer createdTime  注册时间
      * @param integer updatedTime  修改时间
      * @param string productName  产品名称
      * @param string model  设备型号
      * @param string manufacturer  设备厂商
      * @param integer dynamicRegister  动态注册,0:关闭，1:开启
      */

  queryDeviceDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryDeviceDetail"
      )
    }

    opts = opts || {}

    if (opts.deviceName === undefined || opts.deviceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceName' when calling queryDeviceDetail"
      )
    }
    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling queryDeviceDetail"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling queryDeviceDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      deviceName: opts.deviceName,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryDeviceDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/device/{deviceName}:detail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除设备
      * @param {Object} opts - parameters
      * @param {string} opts.deviceName - 设备名称
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  removeDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  removeDevice"
      )
    }

    opts = opts || {}

    if (opts.deviceName === undefined || opts.deviceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceName' when calling removeDevice"
      )
    }
    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling removeDevice"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling removeDevice"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      deviceName: opts.deviceName,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/device/{deviceName}:delete',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取分组列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.groupName] - 组名称  optional
      * @param {string} [opts.queryUserPin] - 查询的用户组  optional
      * @param {string} [opts.tag] - 组标签  optional
      * @param {integer} [opts.pageNumber] - 当前页号  optional
      * @param {integer} [opts.pageSize] - 每页大小  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer nowPage
      * @param integer totalSize
      * @param integer totalPage
      * @param deviceGroupResp data
      */

  getDeviceGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDeviceGroup"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling getDeviceGroup"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      queryParams['groupName'] = opts.groupName
    }
    if (opts.queryUserPin !== undefined && opts.queryUserPin !== null) {
      queryParams['queryUserPin'] = opts.queryUserPin
    }
    if (opts.tag !== undefined && opts.tag !== null) {
      queryParams['tag'] = opts.tag
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDeviceGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devicegroup:get',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取组列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.queryUserPin] - 获取用户 NULL为当前用户  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceGroupResp data
      */

  getDeviceGroupList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDeviceGroupList"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling getDeviceGroupList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.queryUserPin !== undefined && opts.queryUserPin !== null) {
      queryParams['queryUserPin'] = opts.queryUserPin
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDeviceGroupList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devicegrouplist',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取分组列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.productKey] - 产品Key  optional
      * @param {string} [opts.deviceName] - 设备名称  optional
      * @param {string} [opts.deviceCollectorType] - 采集器类型  optional
      * @param {string} [opts.groupName] - 组名称  optional
      * @param {string} [opts.userPin] - 查询的用户组  optional
      * @param {string} [opts.tag] - 组标签  optional
      * @param {string} [opts.groupId] - 组ID  optional
      * @param {string} [opts.manufacturer] - 厂商名称  optional
      * @param {string} [opts.model] - 设备型号  optional
      * @param {integer} [opts.orderId] - 订单号  optional
      * @param {integer} [opts.status] - 设备状态  optional
      * @param {integer} [opts.pageNumber] - 当前页码  optional
      * @param {integer} [opts.pageSize] - 每页大小  optional
      * @param {string} [opts.order] - 排序字段  optional
      * @param {string} [opts.direction] - 排序方式（asc desc）  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer nowPage
      * @param integer totalSize
      * @param integer totalPage
      * @param deviceGroupInfo data
      */

  findDeviceGroupLinkPage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  findDeviceGroupLinkPage"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling findDeviceGroupLinkPage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.productKey !== undefined && opts.productKey !== null) {
      queryParams['productKey'] = opts.productKey
    }
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      queryParams['deviceName'] = opts.deviceName
    }
    if (
      opts.deviceCollectorType !== undefined &&
      opts.deviceCollectorType !== null
    ) {
      queryParams['deviceCollectorType'] = opts.deviceCollectorType
    }
    if (opts.groupName !== undefined && opts.groupName !== null) {
      queryParams['groupName'] = opts.groupName
    }
    if (opts.userPin !== undefined && opts.userPin !== null) {
      queryParams['userPin'] = opts.userPin
    }
    if (opts.tag !== undefined && opts.tag !== null) {
      queryParams['tag'] = opts.tag
    }
    if (opts.groupId !== undefined && opts.groupId !== null) {
      queryParams['groupId'] = opts.groupId
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      queryParams['manufacturer'] = opts.manufacturer
    }
    if (opts.model !== undefined && opts.model !== null) {
      queryParams['model'] = opts.model
    }
    if (opts.orderId !== undefined && opts.orderId !== null) {
      queryParams['orderId'] = opts.orderId
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call findDeviceGroupLinkPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devicegrouplink:get',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取电梯运行状态
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - Hub实例Id
      * @param {string} [opts.identifier] - 电梯连接码  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param registerValue data
      * @param integer totalCount  统计数据
      */

  elevatorOperatingStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  elevatorOperatingStatus"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling elevatorOperatingStatus"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.identifier !== undefined && opts.identifier !== null) {
      queryParams['identifier'] = opts.identifier
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call elevatorOperatingStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/registerElevatorOperatingStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取协议信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - Hub实例Id
      * @param {string} opts.identifier - 当前的链接码
      * @param {string} opts.protocol - 当前的协议类型：
语音播报控制器-输入端子,0X00000~X0007：inputTerminal
语音播报控制器-播放信息,0X00024~X0027：playInfo
LR001-516-5B边缘数据采集器-传感器管理：sensor
LR001-516-5B边缘数据采集器-采集器属性：collectorProperty
LR001-516-5B边缘数据采集器-电梯属性：elevatorProperty
LR001-516-5A边缘数据采集器-水质酸碱度(PH)：waterQualityPh
LR001-516-5A水质监测采集器-水质电导率：waterQualityElectroConductivity

      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object readData  读取寄存器值，key：寄存器地址 value:寄存器值
如读取语音播报控制器-输入端子的响应为
{
  &quot;0&quot;:0,
  &quot;1&quot;:0,
  &quot;2&quot;:0,
  &quot;3&quot;:0,
  &quot;4&quot;:0,
  &quot;5&quot;:0,
  &quot;6&quot;:0,
  &quot;7&quot;:0
}
如读取语音播报控制器-播放信息的响应为
{
  &quot;36&quot;:0,
  &quot;37&quot;:0,
  &quot;38&quot;:0,
  &quot;39&quot;:0,
  &quot;40&quot;:0,
  &quot;41&quot;:0,
  &quot;42&quot;:0,
  &quot;43&quot;:0,
  &quot;44&quot;:1,
  &quot;45&quot;:3,
  &quot;46&quot;:0,
  &quot;47&quot;:0
}
如读取LR001-516-5B边缘数据采集器-传感器管理的响应为
{
  &quot;40426&quot;:1,
  &quot;40427&quot;:1,
  &quot;40428&quot;:2,
  &quot;40429&quot;:1,
  &quot;40430&quot;:1,
  &quot;40431&quot;:1,
  &quot;40432&quot;:1,
  &quot;40433&quot;:2,
  &quot;40434&quot;:1,
  &quot;40435&quot;:1,
  &quot;40436&quot;:1,
  &quot;40437&quot;:1,
  &quot;40438&quot;:1,
  &quot;40439&quot;:1,
  &quot;40440&quot;:1
}
如读取LR001-516-5A边缘数据采集器-水质酸碱度(PH)响应为
{
  &quot;40301&quot;: 0,
  &quot;40302&quot;: 225,
  &quot;40304&quot;: 28.071838,
  &quot;40306&quot;: 12.9,
  &quot;40308&quot;: 0,
  &quot;40309&quot;: 37376,
  &quot;40311&quot;: 2000,
  &quot;40313&quot;: -2000,
  &quot;40315&quot;: 60,
  &quot;40317&quot;: 0,
  &quot;40319&quot;: 0,
  &quot;40321&quot;: 0,
  &quot;40323&quot;: 0,
  &quot;40324&quot;: 1,
  &quot;40325&quot;: 4,
  &quot;40326&quot;: 0,
  &quot;40327&quot;: 256,
  &quot;40329&quot;: -0.1984,
  &quot;40331&quot;: 0,
  &quot;40333&quot;: 1,
  &quot;40335&quot;: 25,
  &quot;40337&quot;: 0,
  &quot;40338&quot;: 0,
  &quot;40339&quot;: 2622
}
如读取LR001-516-5A水质监测采集器-水质电导率响应为
{
  &quot;40340&quot;: 0,
  &quot;40342&quot;: 0,
  &quot;40344&quot;: 29.816881,
  &quot;40346&quot;: 0,
  &quot;40348&quot;: 0,
  &quot;40350&quot;: 10,
  &quot;40352&quot;: 0.018,
  &quot;40354&quot;: 25,
  &quot;40356&quot;: 0,
  &quot;40358&quot;: 38400,
  &quot;40360&quot;: 2,
  &quot;40362&quot;: 1663480.8,
  &quot;40364&quot;: 1,
  &quot;40366&quot;: 0,
  &quot;40368&quot;: 50,
  &quot;40370&quot;: 20
}

      */

  collectorReadMessage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  collectorReadMessage"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling collectorReadMessage"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling collectorReadMessage"
      )
    }
    if (opts.protocol === undefined || opts.protocol === null) {
      throw new Error(
        "Missing the required parameter 'opts.protocol' when calling collectorReadMessage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.identifier !== undefined && opts.identifier !== null) {
      queryParams['identifier'] = opts.identifier
    }
    if (opts.protocol !== undefined && opts.protocol !== null) {
      queryParams['protocol'] = opts.protocol
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call collectorReadMessage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/readCollectorProperty',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  (0x03)读保持寄存器
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - Hub实例Id
      * @param {string} opts.identifier - 连接码
      * @param {integer} opts.addressOfFirstRegister - 起始地址，如40301
      * @param {integer} opts.numberOfRegisters - 寄存器数量
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object readData  读取寄存器值，key：寄存器地址 value:寄存器值
      */

  readHoldingRegisters (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  readHoldingRegisters"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling readHoldingRegisters"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling readHoldingRegisters"
      )
    }
    if (
      opts.addressOfFirstRegister === undefined ||
      opts.addressOfFirstRegister === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.addressOfFirstRegister' when calling readHoldingRegisters"
      )
    }
    if (
      opts.numberOfRegisters === undefined ||
      opts.numberOfRegisters === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.numberOfRegisters' when calling readHoldingRegisters"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.identifier !== undefined && opts.identifier !== null) {
      queryParams['identifier'] = opts.identifier
    }
    if (
      opts.addressOfFirstRegister !== undefined &&
      opts.addressOfFirstRegister !== null
    ) {
      queryParams['addressOfFirstRegister'] = opts.addressOfFirstRegister
    }
    if (
      opts.numberOfRegisters !== undefined &&
      opts.numberOfRegisters !== null
    ) {
      queryParams['numberOfRegisters'] = opts.numberOfRegisters
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call readHoldingRegisters with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/readHoldingRegisters',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  写入采集器数据
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - Hub实例Id
      * @param {string} opts.identifier - 当前的链接码
      * @param {string} [opts.protocol] - 当前的协议类型,非必填项
  optional
      * @param {object} opts.data - 当前待写入的数据
如语音播报控制器-指定播放设备，寄存地址：13对应16进制0x0D，寄存器值:2
{
  &quot;13&quot;:2
}
如语音播报控制器-播放控制，寄存地址：14对应16进制0x0E，寄存器值:1
{
  &quot;14&quot;: 1
}
如语音播报控制器-音量设置，寄存地址：15对应16进制0x0F，寄存器值:10，取值范围0~30
{
  &quot;15&quot;: 10
}
如语音播报控制器-指定文件夹和文件播放,寄存地址：16对应16进制0x10，寄存器值:1
寄存器值为两字节，第一个字节为文件夹，第二个字节为文件名
如0x01文件夹,0x03文件名，0x0103换算为10进制为259
{
  &quot;16&quot;: 259
}
如语音播报控制器-组合播放，寄存器地址：17、18和19，寄存器值：257、258和259，寄存器值的算法和指定文件夹和文件播放是一致的，如259可换算为0x01文件夹,0x03文件名
{
  &quot;17&quot;: 257,
  &quot;18&quot;: 258,
  &quot;19&quot;: 259
}
如语音播报控制器-播放广告，寄存地址：32对应16进制0x20，寄存器值:259，寄存器值的算法和指定文件夹和文件播放是一致的，如259可换算为0x01文件夹,0x03文件名
{
  &quot;32&quot;: 259
}
如语音播报控制器-指定文件夹循环播放，寄存地址：33对应16进制0x21，寄存器值:256，寄存器值的算法，如256可换算为0x0100文件夹
{
  &quot;33&quot;: 256
}
如语音播报控制器-指定文件夹随机播放，寄存地址：34对应16进制0x22，寄存器值:256，寄存器值的算法，如256可换算为0x0100文件夹
{
  &quot;34&quot;: 256
}
如语音播报控制器-指定曲目播放，寄存地址：35对应16进制0x23，寄存器值:13,歌曲选择范围为0~3000
{
  &quot;35&quot;: 13
}
如电梯数据采集器-传感器管理数据更新
{
  &quot;40426&quot;: 1,
  &quot;40427&quot;: 1,
  &quot;40428&quot;: 1,
  &quot;40429&quot;: 1,
  &quot;40430&quot;: 1,
  &quot;40431&quot;: 1,
  &quot;40432&quot;: 1,
  &quot;40433&quot;: 1,
  &quot;40434&quot;: 1,
  &quot;40435&quot;: 1,
  &quot;40436&quot;: 1,
  &quot;40437&quot;: 1,
  &quot;40438&quot;: 1,
  &quot;40439&quot;: 1,
  &quot;40440&quot;: 1
}
如电梯数据采集器-采集器属性数据更新
{
  &quot;40441&quot;: 40441,
  &quot;40443&quot;: 40443,
  &quot;40444&quot;: 40444,
  &quot;40445&quot;: 40445,
  &quot;40446&quot;: 40446,
  &quot;40447&quot;: 40447,
  &quot;40448&quot;: 40448,
  &quot;40449&quot;: 40449,
  &quot;40450&quot;: 40450
}
如电梯数据采集器-电梯属性数据更新
{
  &quot;40801&quot;: 1,
  &quot;40802&quot;: 1,
  &quot;40803&quot;: 1,
  &quot;40804&quot;: 1,
  &quot;40805&quot;: 1,
  &quot;40806&quot;: 1,
  &quot;40807&quot;: 1,
  &quot;40808&quot;: 1,
  &quot;40809&quot;: 1,
  &quot;40810&quot;: 1
}
如电梯数据采集器-楼层数据更新
{
  &quot;40797&quot;: 1,
  &quot;40798&quot;: 1,
  &quot;40799&quot;: 1
}

      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string writeStatus
      */

  collectorWriteMessage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  collectorWriteMessage"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling collectorWriteMessage"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling collectorWriteMessage"
      )
    }
    if (opts.data === undefined || opts.data === null) {
      throw new Error(
        "Missing the required parameter 'opts.data' when calling collectorWriteMessage"
      )
    }

    let postBody = {}
    if (opts.identifier !== undefined && opts.identifier !== null) {
      postBody['identifier'] = opts.identifier
    }
    if (opts.protocol !== undefined && opts.protocol !== null) {
      postBody['protocol'] = opts.protocol
    }
    if (opts.data !== undefined && opts.data !== null) {
      postBody['data'] = opts.data
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call collectorWriteMessage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/writeCollectorProperty',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改设备详情
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.deviceId - 设备Id
      * @param {string} [opts.model] - 设备型号  optional
      * @param {string} [opts.manufacturer] - 设备厂商  optional
      * @param {string} [opts.description] - 设备名  optional
      * @param {integer} [opts.status] - 设备状态  optional
      * @param {string} [opts.identifier] - 连接码  optional
      * @param {string} [opts.deviceName] - 心跳  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param deviceVO device  设备详情
      */

  updateLooDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateLooDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateLooDevice"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling updateLooDevice"
      )
    }

    let postBody = {}
    if (opts.model !== undefined && opts.model !== null) {
      postBody['model'] = opts.model
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      postBody['manufacturer'] = opts.manufacturer
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.identifier !== undefined && opts.identifier !== null) {
      postBody['identifier'] = opts.identifier
    }
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      postBody['deviceName'] = opts.deviceName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      deviceId: opts.deviceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateLooDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/device/{deviceId}:looupdate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  注册单个朗讯设备并返回秘钥信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.preOrderId - 申请单编号
      * @param {string} opts.userPinParam - 用户Pin
      * @param {string} [opts.deviceName] - 心跳  optional
      * @param {string} [opts.productKey] - 设备所归属的产品  optional
      * @param {string} [opts.model] - 设备型号  optional
      * @param {string} [opts.manufacturer] - 厂商  optional
      * @param {string} [opts.identifier] - 连接码  optional
      * @param {string} [opts.description] - 设备名  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string deviceName  设备名称
      * @param string identifier  设备标识符
      * @param string secret  设备秘钥
      */

  addLooDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addLooDevice"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling addLooDevice"
      )
    }
    if (opts.preOrderId === undefined || opts.preOrderId === null) {
      throw new Error(
        "Missing the required parameter 'opts.preOrderId' when calling addLooDevice"
      )
    }
    if (opts.userPinParam === undefined || opts.userPinParam === null) {
      throw new Error(
        "Missing the required parameter 'opts.userPinParam' when calling addLooDevice"
      )
    }

    let postBody = {}
    if (opts.userPinParam !== undefined && opts.userPinParam !== null) {
      postBody['userPinParam'] = opts.userPinParam
    }
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      postBody['deviceName'] = opts.deviceName
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      postBody['productKey'] = opts.productKey
    }
    if (opts.model !== undefined && opts.model !== null) {
      postBody['model'] = opts.model
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      postBody['manufacturer'] = opts.manufacturer
    }
    if (opts.identifier !== undefined && opts.identifier !== null) {
      postBody['identifier'] = opts.identifier
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      preOrderId: opts.preOrderId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLooDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/preOrderId/{preOrderId}/device_loongray:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  朗瑞分页查询设备信息,支持一个或多个条件
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.deviceName] - 设备名称，模糊匹配  optional
      * @param {string} [opts.manufacturer] - 设备厂商，模糊匹配  optional
      * @param {string} [opts.model] - 设备型号，模糊匹配  optional
      * @param {integer} [opts.status] - 设备状态 0-未激活，1-激活离线，2-激活在线  optional
      * @param {string} [opts.productKey] - 设备所归属的产品Key  optional
      * @param {integer} [opts.deviceType] - 设备类型，同产品类型，0-设备，1-网关  optional
      * @param {integer} [opts.nowPage] - 当前页数  optional
      * @param {integer} [opts.pageSize] - 每页的数据条数  optional
      * @param {string} [opts.order] - 排序关键字--name,type,productKey,status--最多支持一个字段  optional
      * @param {string} [opts.direction] - 顺序，升序降序--asc,desc  optional
      * @param {string} [opts.parentId] - 父设备Id  optional
      * @param {integer} [opts.orderId] - 订单号  optional
      * @param {string} [opts.deviceCollectorType] - 设备采集器类型  optional
      * @param {string} [opts.queryUserPin] - 查询的userPin  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize
      * @param integer nowPage
      * @param integer totalSize
      * @param integer totalPage
      * @param deviceVO data
      */

  loongrayQueryPage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  loongrayQueryPage"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling loongrayQueryPage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceName !== undefined && opts.deviceName !== null) {
      queryParams['deviceName'] = opts.deviceName
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      queryParams['manufacturer'] = opts.manufacturer
    }
    if (opts.model !== undefined && opts.model !== null) {
      queryParams['model'] = opts.model
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      queryParams['productKey'] = opts.productKey
    }
    if (opts.deviceType !== undefined && opts.deviceType !== null) {
      queryParams['deviceType'] = opts.deviceType
    }
    if (opts.nowPage !== undefined && opts.nowPage !== null) {
      queryParams['nowPage'] = opts.nowPage
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }
    if (opts.parentId !== undefined && opts.parentId !== null) {
      queryParams['parentId'] = opts.parentId
    }
    if (opts.orderId !== undefined && opts.orderId !== null) {
      queryParams['orderId'] = opts.orderId
    }
    if (
      opts.deviceCollectorType !== undefined &&
      opts.deviceCollectorType !== null
    ) {
      queryParams['deviceCollectorType'] = opts.deviceCollectorType
    }
    if (opts.queryUserPin !== undefined && opts.queryUserPin !== null) {
      queryParams['queryUserPin'] = opts.queryUserPin
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call loongrayQueryPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/devices:loongrayQueryPage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设备基本数据统计，包括设备数，激活数，在线数
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} [opts.productKey] - 过滤条件，产品Key  optional
      * @param {string} [opts.parentId] - 针对parentId下的子设备进行统计  optional
      * @param {string} [opts.deviceCollectorType] - 采集器类型  optional
      * @param {string} [opts.queryUserPin] - 查询的用户信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer devices  用户的设备数
      * @param integer activatedDevices  已激活的设备数
      * @param integer onlineDevices  在线的设备数
      * @param integer monthMessages  当月消息数
      * @param integer monthDuration  当月设备在线时长
      * @param integer products  产品数
      */

  queryAdminStatistics (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryAdminStatistics"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling queryAdminStatistics"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.productKey !== undefined && opts.productKey !== null) {
      queryParams['productKey'] = opts.productKey
    }
    if (opts.parentId !== undefined && opts.parentId !== null) {
      queryParams['parentId'] = opts.parentId
    }
    if (
      opts.deviceCollectorType !== undefined &&
      opts.deviceCollectorType !== null
    ) {
      queryParams['deviceCollectorType'] = opts.deviceCollectorType
    }
    if (opts.queryUserPin !== undefined && opts.queryUserPin !== null) {
      queryParams['queryUserPin'] = opts.queryUserPin
    }

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAdminStatistics with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/device:queryAdminStatistics',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除设备
      * @param {Object} opts - parameters
      * @param {string} opts.deviceName - 设备名称
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  removeLoongrayDevice (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  removeLoongrayDevice"
      )
    }

    opts = opts || {}

    if (opts.deviceName === undefined || opts.deviceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceName' when calling removeLoongrayDevice"
      )
    }
    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling removeLoongrayDevice"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling removeLoongrayDevice"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      deviceName: opts.deviceName,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeLoongrayDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/device/{deviceName}:loongraydelete',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string productName  产品名称
      * @param integer productType  节点类型，取值：
0：设备。设备不能挂载子设备。可以直连物联网平台，也可以作为网关的子设备连接物联网平台
1：网关。网关可以挂载子设备，具有子设备管理模块，维持子设备的拓扑关系，和将拓扑关系同步到物联网平台

      * @param string productKey  产品key
      * @param string productSecret  产品秘钥
      * @param integer createdTime  创建时间,时间为东八区（UTC/GMT+08:00）
      * @param integer deviceCount  包含设备数
      * @param integer dynamicRegister  动态注册,0:关闭，1:开启
      * @param string productDescription  产品描述信息
      * @param string templateName  产品类型,如自定义等
      */

  describeProductWithAdmin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeProductWithAdmin"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeProductWithAdmin"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeProductWithAdmin"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProductWithAdmin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/products/{productKey}/admin',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} [opts.productName] - 产品名称，名称不可为空，3-30个字符，只支持汉字、英文字母、数字、下划线“_”及中划线“-”，必须以汉字、英文字母及数字开头结尾  optional
      * @param {string} [opts.productDescription] - 产品描述，80字符以内  optional
      * @param {integer} [opts.dynamicRegister] - 动态注册,0:关闭，1:开启  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateProductWithAdmin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateProductWithAdmin"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateProductWithAdmin"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling updateProductWithAdmin"
      )
    }

    let postBody = {}
    if (opts.productName !== undefined && opts.productName !== null) {
      postBody['productName'] = opts.productName
    }
    if (
      opts.productDescription !== undefined &&
      opts.productDescription !== null
    ) {
      postBody['productDescription'] = opts.productDescription
    }
    if (opts.dynamicRegister !== undefined && opts.dynamicRegister !== null) {
      postBody['dynamicRegister'] = opts.dynamicRegister
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateProductWithAdmin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/products/{productKey}/admin',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteProductWithAdmin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteProductWithAdmin"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deleteProductWithAdmin"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling deleteProductWithAdmin"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteProductWithAdmin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/products/{productKey}/admin',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看所有产品的列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为10，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - productName-产品名称，模糊匹配，支持单个
productKey-产品key，精确匹配，支持单个
productType-产品类型，精确匹配，支持单个
templateName-模板名称，精确匹配，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param pageinfoVO page  分页信息
      * @param product products
      */

  listProductsWithAdmin (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listProductsWithAdmin"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling listProductsWithAdmin"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listProductsWithAdmin with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/products:describeAll',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新建产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productName - 产品名称，名称不可为空，3-30个字符，只支持汉字、英文字母、数字、下划线“_”及中划线“-”，必须以汉字、英文字母及数字开头结尾
      * @param {integer} opts.productType - 节点类型，取值：
0：设备。设备不能挂载子设备。可以直连物联网平台，也可以作为网关的子设备连接物联网平台
1：网关。网关可以挂载子设备，具有子设备管理模块，维持子设备的拓扑关系，和将拓扑关系同步到物联网平台

      * @param {string} [opts.productDescription] - 产品描述，80字符以内  optional
      * @param {string} [opts.templateId] - 物模型模板ID，内部参数，用户不可见，默认为自定义  optional
      * @param {object} [opts.internalTags] - 内部标签，内部参数，用户不可见，隐藏标签：hidden:true  optional
      * @param {string} opts.collDeviceType - 产品名下所有设备的采集器类型
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string productKey
      */

  createAdminProduct (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAdminProduct"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createAdminProduct"
      )
    }
    if (opts.productName === undefined || opts.productName === null) {
      throw new Error(
        "Missing the required parameter 'opts.productName' when calling createAdminProduct"
      )
    }
    if (opts.productType === undefined || opts.productType === null) {
      throw new Error(
        "Missing the required parameter 'opts.productType' when calling createAdminProduct"
      )
    }
    if (opts.collDeviceType === undefined || opts.collDeviceType === null) {
      throw new Error(
        "Missing the required parameter 'opts.collDeviceType' when calling createAdminProduct"
      )
    }

    let postBody = {}
    if (opts.productName !== undefined && opts.productName !== null) {
      postBody['productName'] = opts.productName
    }
    if (opts.productType !== undefined && opts.productType !== null) {
      postBody['productType'] = opts.productType
    }
    if (
      opts.productDescription !== undefined &&
      opts.productDescription !== null
    ) {
      postBody['productDescription'] = opts.productDescription
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.internalTags !== undefined && opts.internalTags !== null) {
      postBody['internalTags'] = opts.internalTags
    }
    if (opts.collDeviceType !== undefined && opts.collDeviceType !== null) {
      postBody['collDeviceType'] = opts.collDeviceType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAdminProduct with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loongrayinstances/{instanceId}/productsAdmin',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品列表接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为10，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - productName-产品名称，模糊匹配，支持单个
productKey-产品key，精确匹配，支持单个
productType-产品类型，精确匹配，支持单个
templateName-模板名称，精确匹配，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param pageinfoVO page  分页信息
      * @param product products
      */

  listProducts (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listProducts"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling listProducts"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listProducts with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新建产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productName - 产品名称，名称不可为空，3-30个字符，只支持汉字、英文字母、数字、下划线“_”及中划线“-”，必须以汉字、英文字母及数字开头结尾
      * @param {integer} opts.productType - 节点类型，取值：
0：设备。设备不能挂载子设备。可以直连物联网平台，也可以作为网关的子设备连接物联网平台
1：网关。网关可以挂载子设备，具有子设备管理模块，维持子设备的拓扑关系，和将拓扑关系同步到物联网平台

      * @param {string} [opts.productDescription] - 产品描述，80字符以内  optional
      * @param {string} [opts.templateId] - 物模型模板ID，内部参数，用户不可见，默认为自定义  optional
      * @param {object} [opts.internalTags] - 内部标签，内部参数，用户不可见，隐藏标签：hidden:true  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string productKey
      */

  createProduct (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createProduct"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createProduct"
      )
    }
    if (opts.productName === undefined || opts.productName === null) {
      throw new Error(
        "Missing the required parameter 'opts.productName' when calling createProduct"
      )
    }
    if (opts.productType === undefined || opts.productType === null) {
      throw new Error(
        "Missing the required parameter 'opts.productType' when calling createProduct"
      )
    }

    let postBody = {}
    if (opts.productName !== undefined && opts.productName !== null) {
      postBody['productName'] = opts.productName
    }
    if (opts.productType !== undefined && opts.productType !== null) {
      postBody['productType'] = opts.productType
    }
    if (
      opts.productDescription !== undefined &&
      opts.productDescription !== null
    ) {
      postBody['productDescription'] = opts.productDescription
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.internalTags !== undefined && opts.internalTags !== null) {
      postBody['internalTags'] = opts.internalTags
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createProduct with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string productName  产品名称
      * @param integer productType  节点类型，取值：
0：设备。设备不能挂载子设备。可以直连物联网平台，也可以作为网关的子设备连接物联网平台
1：网关。网关可以挂载子设备，具有子设备管理模块，维持子设备的拓扑关系，和将拓扑关系同步到物联网平台

      * @param string productKey  产品key
      * @param string productSecret  产品秘钥
      * @param integer createdTime  创建时间,时间为东八区（UTC/GMT+08:00）
      * @param integer deviceCount  包含设备数
      * @param integer dynamicRegister  动态注册,0:关闭，1:开启
      * @param string productDescription  产品描述信息
      * @param string templateName  产品类型,如自定义等
      */

  describeProduct (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeProduct"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeProduct"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeProduct"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProduct with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} [opts.productName] - 产品名称，名称不可为空，3-30个字符，只支持汉字、英文字母、数字、下划线“_”及中划线“-”，必须以汉字、英文字母及数字开头结尾  optional
      * @param {string} [opts.productDescription] - 产品描述，80字符以内  optional
      * @param {integer} [opts.dynamicRegister] - 动态注册,0:关闭，1:开启  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateProduct (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateProduct"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling updateProduct"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling updateProduct"
      )
    }

    let postBody = {}
    if (opts.productName !== undefined && opts.productName !== null) {
      postBody['productName'] = opts.productName
    }
    if (
      opts.productDescription !== undefined &&
      opts.productDescription !== null
    ) {
      postBody['productDescription'] = opts.productDescription
    }
    if (opts.dynamicRegister !== undefined && opts.dynamicRegister !== null) {
      postBody['dynamicRegister'] = opts.dynamicRegister
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateProduct with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除产品
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Engine实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteProduct (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteProduct"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deleteProduct"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling deleteProduct"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteProduct with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品功能列表接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Hub实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为10，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - abilityName-功能名称，精确匹配
abilityType-功能类型，精确匹配
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param pageinfoVO page  分页信息
      * @param productAbility abilities
      */

  listProductAbilities (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listProductAbilities"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling listProductAbilities"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling listProductAbilities"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listProductAbilities with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/abilities',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  导入物模型
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Hub实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {object} opts.thingModel - 物模型JSON
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  importThingModel (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  importThingModel"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling importThingModel"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling importThingModel"
      )
    }
    if (opts.thingModel === undefined || opts.thingModel === null) {
      throw new Error(
        "Missing the required parameter 'opts.thingModel' when calling importThingModel"
      )
    }

    let postBody = {}
    if (opts.thingModel !== undefined && opts.thingModel !== null) {
      postBody['thingModel'] = opts.thingModel
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call importThingModel with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/abilities:importThingModel',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  导出物模型
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoT Hub实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object thingModel
      */

  exportThingModel (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  exportThingModel"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling exportThingModel"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling exportThingModel"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call exportThingModel with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/abilities:exportThingModel',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品自定义Topic列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞)  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为10，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - topicShortName-topic名称，模糊匹配，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param pageinfoVO page  分页信息
      * @param productTopic productTopics
      */

  describeProductTopics (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeProductTopics"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeProductTopics"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeProductTopics"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProductTopics with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/topics',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新建产品自定义Topic
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} opts.topicShortName - Topic名称为必填，同一个产品下的Topic名称不能重复
只能包含字母，数字和下划线，最多64个字符，每个层级都不能为空
不能以/结尾

      * @param {string} opts.topicOperation - 操作权限，设备对该Topic类的操作权限，取值
pub:发布
sub:订阅

      * @param {string} [opts.topicDescription] - 描述, 0-50个字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string topicId
      */

  createProductTopic (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createProductTopic"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createProductTopic"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling createProductTopic"
      )
    }
    if (opts.topicShortName === undefined || opts.topicShortName === null) {
      throw new Error(
        "Missing the required parameter 'opts.topicShortName' when calling createProductTopic"
      )
    }
    if (opts.topicOperation === undefined || opts.topicOperation === null) {
      throw new Error(
        "Missing the required parameter 'opts.topicOperation' when calling createProductTopic"
      )
    }

    let postBody = {}
    if (opts.topicShortName !== undefined && opts.topicShortName !== null) {
      postBody['topicShortName'] = opts.topicShortName
    }
    if (opts.topicOperation !== undefined && opts.topicOperation !== null) {
      postBody['topicOperation'] = opts.topicOperation
    }
    if (opts.topicDescription !== undefined && opts.topicDescription !== null) {
      postBody['topicDescription'] = opts.topicDescription
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createProductTopic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/topics',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看产品自定义Topic
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例ID信息
      * @param {string} opts.productKey - 产品Key
      * @param {string} opts.topicId - 自定义topic唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string topicShortName  Topic名称为必填，同一个产品下的Topic名称不能重复
只能包含字母，数字和下划线，最多64个字符，每个层级都不能为空
不能以/结尾

      * @param string topicOperation  操作权限，设备对该Topic类的操作权限，取值
pub:发布
sub:订阅

      * @param string topicDescription  描述, 0-50个字符
      * @param integer createdTime  创建时间,时间为东八区（UTC/GMT+08:00）
      * @param integer udpatedTime  修改时间,时间为东八区（UTC/GMT+08:00）
      */

  describeProductTopic (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeProductTopic"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeProductTopic"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeProductTopic"
      )
    }
    if (opts.topicId === undefined || opts.topicId === null) {
      throw new Error(
        "Missing the required parameter 'opts.topicId' when calling describeProductTopic"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      productKey: opts.productKey,
      topicId: opts.topicId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotcore/1.1.25'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeProductTopic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/topics/{topicId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = IOTCORE
