/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * EdgeSubDeviceManager
 * iotcore-Edge子设备管理
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'iotedge'
Service._services[serviceId] = true

/**
 * iotedge service.
 * @version 1.0.0
 */

JDCloud.IOTEDGE = class IOTEDGE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'console-be.iotedge.jdcloud.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  部署APP应用
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.appName - App内部名称
      * @param {string} opts.appVersion - App版本
      * @param {string} opts.edgeName - edge名称
      * @param {string} [opts.env] - App安装变量（默认为空字符串）  optional
      * @param {integer} opts.privileged - 是否特权模式运行(0-否 1-是)
      * @param {string} [opts.volume] - 硬盘操作卷  optional
      * @param {integer} opts.appType - App类型(1-设备服务 2-边缘应用)
      * @param {integer} opts.useHost - 是否使用Edge系统的Host配置(0-否 1-是)
      * @param {integer} opts.cpuShares - CPU权重（低-128 中-256 高-512）
      * @param {string} opts.memoryLimit - 内存限制（0-无限 低-128 中-256 高-512）
      * @param {string} opts.restartPolicy - 重启策略(0-never 1-always 2-onFailure)
      * @param {integer} opts.deployAppStatus - 部署APP状态(3-更新 其余都是安装)
      * @param {integer} [opts.appStatus] - App状态  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer deployStatus  部署状态
      */

  deployApp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deployApp"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deployApp"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling deployApp"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling deployApp"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deployApp"
      )
    }
    if (opts.appVersion === undefined || opts.appVersion === null) {
      throw new Error(
        "Missing the required parameter 'opts.appVersion' when calling deployApp"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling deployApp"
      )
    }
    if (opts.privileged === undefined || opts.privileged === null) {
      throw new Error(
        "Missing the required parameter 'opts.privileged' when calling deployApp"
      )
    }
    if (opts.appType === undefined || opts.appType === null) {
      throw new Error(
        "Missing the required parameter 'opts.appType' when calling deployApp"
      )
    }
    if (opts.useHost === undefined || opts.useHost === null) {
      throw new Error(
        "Missing the required parameter 'opts.useHost' when calling deployApp"
      )
    }
    if (opts.cpuShares === undefined || opts.cpuShares === null) {
      throw new Error(
        "Missing the required parameter 'opts.cpuShares' when calling deployApp"
      )
    }
    if (opts.memoryLimit === undefined || opts.memoryLimit === null) {
      throw new Error(
        "Missing the required parameter 'opts.memoryLimit' when calling deployApp"
      )
    }
    if (opts.restartPolicy === undefined || opts.restartPolicy === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartPolicy' when calling deployApp"
      )
    }
    if (opts.deployAppStatus === undefined || opts.deployAppStatus === null) {
      throw new Error(
        "Missing the required parameter 'opts.deployAppStatus' when calling deployApp"
      )
    }

    let postBody = {}
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.appVersion !== undefined && opts.appVersion !== null) {
      postBody['appVersion'] = opts.appVersion
    }
    if (opts.edgeName !== undefined && opts.edgeName !== null) {
      postBody['edgeName'] = opts.edgeName
    }
    if (opts.env !== undefined && opts.env !== null) {
      postBody['env'] = opts.env
    }
    if (opts.privileged !== undefined && opts.privileged !== null) {
      postBody['privileged'] = opts.privileged
    }
    if (opts.volume !== undefined && opts.volume !== null) {
      postBody['volume'] = opts.volume
    }
    if (opts.appType !== undefined && opts.appType !== null) {
      postBody['appType'] = opts.appType
    }
    if (opts.useHost !== undefined && opts.useHost !== null) {
      postBody['useHost'] = opts.useHost
    }
    if (opts.cpuShares !== undefined && opts.cpuShares !== null) {
      postBody['cpuShares'] = opts.cpuShares
    }
    if (opts.memoryLimit !== undefined && opts.memoryLimit !== null) {
      postBody['memoryLimit'] = opts.memoryLimit
    }
    if (opts.restartPolicy !== undefined && opts.restartPolicy !== null) {
      postBody['restartPolicy'] = opts.restartPolicy
    }
    if (opts.deployAppStatus !== undefined && opts.deployAppStatus !== null) {
      postBody['deployAppStatus'] = opts.deployAppStatus
    }
    if (opts.appStatus !== undefined && opts.appStatus !== null) {
      postBody['appStatus'] = opts.appStatus
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deployApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:deployApp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询已经部署的App应用
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.productKey - Edge对应的产品Key
      * @param {integer} opts.appType - App类型(1-设备服务 2-边缘应用)
      * @param {integer} [opts.nowPage] - 当前的规则位置  optional
      * @param {integer} [opts.pageSize] - 显示多少个数据  optional
      * @param {integer} [opts.order] - 排序方式  optional
      * @param {integer} [opts.property] - 排序依据的关键词  optional
      * @param {string} [opts.searchText] - 模糊搜索关键字  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeAppsRespVO appsResp
      * @param object page  分页信息
      */

  describeDeployApp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDeployApp"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeDeployApp"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling describeDeployApp"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling describeDeployApp"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling describeDeployApp"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling describeDeployApp"
      )
    }
    if (opts.appType === undefined || opts.appType === null) {
      throw new Error(
        "Missing the required parameter 'opts.appType' when calling describeDeployApp"
      )
    }

    let postBody = {}
    if (opts.edgeName !== undefined && opts.edgeName !== null) {
      postBody['edgeName'] = opts.edgeName
    }
    if (opts.productKey !== undefined && opts.productKey !== null) {
      postBody['productKey'] = opts.productKey
    }
    if (opts.appType !== undefined && opts.appType !== null) {
      postBody['appType'] = opts.appType
    }
    if (opts.nowPage !== undefined && opts.nowPage !== null) {
      postBody['nowPage'] = opts.nowPage
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.order !== undefined && opts.order !== null) {
      postBody['order'] = opts.order
    }
    if (opts.property !== undefined && opts.property !== null) {
      postBody['property'] = opts.property
    }
    if (opts.searchText !== undefined && opts.searchText !== null) {
      postBody['searchText'] = opts.searchText
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDeployApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:describeDeployApp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询APP部署列表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.appName - Edge名称
      * @param {integer} [opts.nowPage] - 当前的规则位置  optional
      * @param {integer} [opts.pageSize] - 显示多少个数据  optional
      * @param {integer} [opts.order] - 排序方式  optional
      * @param {integer} [opts.property] - 排序依据的关键词  optional
      * @param {string} [opts.searchText] - 模糊搜索关键字  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeDeployDetailsRespVO deployDetails
      * @param object page  分页信息
      */

  describeDeployDetails (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDeployDetails"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeDeployDetails"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling describeDeployDetails"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling describeDeployDetails"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeDeployDetails"
      )
    }

    let postBody = {}
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.nowPage !== undefined && opts.nowPage !== null) {
      postBody['nowPage'] = opts.nowPage
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.order !== undefined && opts.order !== null) {
      postBody['order'] = opts.order
    }
    if (opts.property !== undefined && opts.property !== null) {
      postBody['property'] = opts.property
    }
    if (opts.searchText !== undefined && opts.searchText !== null) {
      postBody['searchText'] = opts.searchText
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDeployDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:describeDeployDetails',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  卸载安装的APP
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.appName - APP名称
      * @param {string} opts.deployAppId - 部署ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer unInstallStatus  删除状态
      */

  unInstallApp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  unInstallApp"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling unInstallApp"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling unInstallApp"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling unInstallApp"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling unInstallApp"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling unInstallApp"
      )
    }
    if (opts.deployAppId === undefined || opts.deployAppId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deployAppId' when calling unInstallApp"
      )
    }

    let postBody = {}
    if (opts.edgeName !== undefined && opts.edgeName !== null) {
      postBody['edgeName'] = opts.edgeName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.deployAppId !== undefined && opts.deployAppId !== null) {
      postBody['deployAppId'] = opts.deployAppId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call unInstallApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:unInstallApp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  APP启动/停止服务
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.appName - App名称
      * @param {integer} opts.status - APP状态(0停止 1启动)
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.appVersion - App版本
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer appStatus  app状态
      */

  setAppStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setAppStatus"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling setAppStatus"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling setAppStatus"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling setAppStatus"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling setAppStatus"
      )
    }
    if (opts.status === undefined || opts.status === null) {
      throw new Error(
        "Missing the required parameter 'opts.status' when calling setAppStatus"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling setAppStatus"
      )
    }
    if (opts.appVersion === undefined || opts.appVersion === null) {
      throw new Error(
        "Missing the required parameter 'opts.appVersion' when calling setAppStatus"
      )
    }

    let postBody = {}
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.edgeName !== undefined && opts.edgeName !== null) {
      postBody['edgeName'] = opts.edgeName
    }
    if (opts.appVersion !== undefined && opts.appVersion !== null) {
      postBody['appVersion'] = opts.appVersion
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setAppStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:setAppStatus',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  部署内容查询
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 设备归属的实例ID
      * @param {string} opts.hardwareId - 硬件版本
      * @param {string} opts.osId - OSID
      * @param {string} opts.appName - App名称
      * @param {string} opts.appVersion - app版本
      * @param {string} opts.edgeName - edge名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeDeployConfigResp describeConfig  App部署信息
      */

  describeConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeConfig"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling describeConfig"
      )
    }
    if (opts.hardwareId === undefined || opts.hardwareId === null) {
      throw new Error(
        "Missing the required parameter 'opts.hardwareId' when calling describeConfig"
      )
    }
    if (opts.osId === undefined || opts.osId === null) {
      throw new Error(
        "Missing the required parameter 'opts.osId' when calling describeConfig"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeConfig"
      )
    }
    if (opts.appVersion === undefined || opts.appVersion === null) {
      throw new Error(
        "Missing the required parameter 'opts.appVersion' when calling describeConfig"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling describeConfig"
      )
    }

    let postBody = {}
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.appVersion !== undefined && opts.appVersion !== null) {
      postBody['appVersion'] = opts.appVersion
    }
    if (opts.edgeName !== undefined && opts.edgeName !== null) {
      postBody['edgeName'] = opts.edgeName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      hardwareId: opts.hardwareId,
      osId: opts.osId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:describeConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除Edge接口
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例编号
      * @param {string} opts.edgeName - Edge名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteEdgeWithCore (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteEdgeWithCore"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling deleteEdgeWithCore"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling deleteEdgeWithCore"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      edgeName: opts.edgeName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteEdgeWithCore with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/edges/{edgeName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加Edge设备
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例编号
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.architecture - 硬件平台编号，具体参数参见硬件平台参数文档
      * @param {string} opts.os - 操作系统编号，具体参数参见操作系统参数文档
      * @param {string} opts.manufacturer - Edge厂家信息
      * @param {string} opts.edgeModel - Edge型号信息
      * @param {string} [opts.edgeDesc] - Edge描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addEdgeWithCore (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addEdgeWithCore"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling addEdgeWithCore"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling addEdgeWithCore"
      )
    }
    if (opts.architecture === undefined || opts.architecture === null) {
      throw new Error(
        "Missing the required parameter 'opts.architecture' when calling addEdgeWithCore"
      )
    }
    if (opts.os === undefined || opts.os === null) {
      throw new Error(
        "Missing the required parameter 'opts.os' when calling addEdgeWithCore"
      )
    }
    if (opts.manufacturer === undefined || opts.manufacturer === null) {
      throw new Error(
        "Missing the required parameter 'opts.manufacturer' when calling addEdgeWithCore"
      )
    }
    if (opts.edgeModel === undefined || opts.edgeModel === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeModel' when calling addEdgeWithCore"
      )
    }

    let postBody = {}
    if (opts.architecture !== undefined && opts.architecture !== null) {
      postBody['architecture'] = opts.architecture
    }
    if (opts.os !== undefined && opts.os !== null) {
      postBody['os'] = opts.os
    }
    if (opts.manufacturer !== undefined && opts.manufacturer !== null) {
      postBody['manufacturer'] = opts.manufacturer
    }
    if (opts.edgeModel !== undefined && opts.edgeModel !== null) {
      postBody['edgeModel'] = opts.edgeModel
    }
    if (opts.edgeDesc !== undefined && opts.edgeDesc !== null) {
      postBody['edgeDesc'] = opts.edgeDesc
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      edgeName: opts.edgeName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addEdgeWithCore with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/edges/{edgeName}:addEdge',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加子设备
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例编号
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.productKey - Edge的ProductKey
      * @param {array} [opts.devices] - 待添加的子设备列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addSubDeviceWithCore (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addSubDeviceWithCore"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling addSubDeviceWithCore"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling addSubDeviceWithCore"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling addSubDeviceWithCore"
      )
    }

    let postBody = {}
    if (opts.devices !== undefined && opts.devices !== null) {
      postBody['devices'] = opts.devices
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      edgeName: opts.edgeName,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addSubDeviceWithCore with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/edges/{edgeName}:addSubDevice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除子设备
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - IoTCore实例编号
      * @param {string} opts.edgeName - Edge名称
      * @param {string} opts.productKey - Edge对应的产品key
      * @param {array} [opts.delDevices] - 设备名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delSubDeviceWithCore (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delSubDeviceWithCore"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling delSubDeviceWithCore"
      )
    }
    if (opts.edgeName === undefined || opts.edgeName === null) {
      throw new Error(
        "Missing the required parameter 'opts.edgeName' when calling delSubDeviceWithCore"
      )
    }
    if (opts.productKey === undefined || opts.productKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.productKey' when calling delSubDeviceWithCore"
      )
    }

    let postBody = {}
    if (opts.delDevices !== undefined && opts.delDevices !== null) {
      postBody['delDevices'] = opts.delDevices
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId,
      edgeName: opts.edgeName,
      productKey: opts.productKey
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iotedge/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delSubDeviceWithCore with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/products/{productKey}/edges/{edgeName}:delSubDevice',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.IOTEDGE
