/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Vi Template
 * 视频审查模板管理相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'iv'
Service._services[serviceId] = true

/**
 * iv service.
 * @version 0.0.1
 */

class IV extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'iv.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  提交视频审查作业
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 视频审查模板ID
      * @param {string} opts.region - 对象存储区域，输入和输入同区域
      * @param {string} [opts.inputBucket] - 输入空间  optional
      * @param {string} [opts.inputFileKey] - 输入文件  optional
      * @param {string} [opts.outputBucket] - 输入空间  optional
      * @param {string} [opts.outputFilePath] - 输入路径  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param viJobSummary resultObject
      */

  submitViJob (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling submitViJob"
      )
    }
    if (opts.region === undefined || opts.region === null) {
      throw new Error(
        "Missing the required parameter 'opts.region' when calling submitViJob"
      )
    }

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.region !== undefined && opts.region !== null) {
      postBody['region'] = opts.region
    }
    if (opts.inputBucket !== undefined && opts.inputBucket !== null) {
      postBody['inputBucket'] = opts.inputBucket
    }
    if (opts.inputFileKey !== undefined && opts.inputFileKey !== null) {
      postBody['inputFileKey'] = opts.inputFileKey
    }
    if (opts.outputBucket !== undefined && opts.outputBucket !== null) {
      postBody['outputBucket'] = opts.outputBucket
    }
    if (opts.outputFilePath !== undefined && opts.outputFilePath !== null) {
      postBody['outputFilePath'] = opts.outputFilePath
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitViJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viJobs:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频审查作业摘要
      * @param {Object} opts - parameters
      * @param {string} opts.jobId - 作业ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      * @param viJobSummary resultObject
      */

  getViJobSummary (opts, callback) {
    opts = opts || {}

    if (opts.jobId === undefined || opts.jobId === null) {
      throw new Error(
        "Missing the required parameter 'opts.jobId' when calling getViJobSummary"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      jobId: opts.jobId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getViJobSummary with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viJobs/{jobId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频审查模板列表。
支持过滤查询：
  - templateId,eq 精确匹配模板ID，非必选

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param viTemplatePageInfo resultObject
      */

  listViTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listViTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建视频审查模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateName - 模板名称。长度不超过128个字符。UTF-8编码。

      * @param {integer} [opts.shotInterval] - 截图间隔  optional
      * @param {string} [opts.shotIntervalType] - 间隔类型：time, percent  optional
      * @param {string} [opts.shotFormat] - 截图格式：png, jpg  optional
      * @param {string} [opts.shotFrameType] - 截图帧类型：any, key  optional
      * @param {integer} [opts.shotWidth] - 截图宽度  optional
      * @param {integer} [opts.shotHeight] - 截图高度  optional
      * @param {string} [opts.shotFillType] - 截图填充类型：stretch, gauss, black, white  optional
      * @param {string} opts.inspectItems - 审查配置，JSON格式
      * @param {string} callback - callback
      @return {Object} result
      * @param viTemplateInfo resultObject
      */

  createViTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateName === undefined || opts.templateName === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateName' when calling createViTemplate"
      )
    }
    if (opts.inspectItems === undefined || opts.inspectItems === null) {
      throw new Error(
        "Missing the required parameter 'opts.inspectItems' when calling createViTemplate"
      )
    }

    let postBody = {}
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.shotInterval !== undefined && opts.shotInterval !== null) {
      postBody['shotInterval'] = opts.shotInterval
    }
    if (opts.shotIntervalType !== undefined && opts.shotIntervalType !== null) {
      postBody['shotIntervalType'] = opts.shotIntervalType
    }
    if (opts.shotFormat !== undefined && opts.shotFormat !== null) {
      postBody['shotFormat'] = opts.shotFormat
    }
    if (opts.shotFrameType !== undefined && opts.shotFrameType !== null) {
      postBody['shotFrameType'] = opts.shotFrameType
    }
    if (opts.shotWidth !== undefined && opts.shotWidth !== null) {
      postBody['shotWidth'] = opts.shotWidth
    }
    if (opts.shotHeight !== undefined && opts.shotHeight !== null) {
      postBody['shotHeight'] = opts.shotHeight
    }
    if (opts.shotFillType !== undefined && opts.shotFillType !== null) {
      postBody['shotFillType'] = opts.shotFillType
    }
    if (opts.inspectItems !== undefined && opts.inspectItems !== null) {
      postBody['inspectItems'] = opts.inspectItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createViTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频审查模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      * @param viTemplateInfo resultObject
      */

  getViTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getViTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getViTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改视频审查模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID，路径参数
      * @param {string} [opts.templateName] - 模板名称。长度不超过128个字符。UTF-8编码。
  optional
      * @param {integer} [opts.shotInterval] - 截图间隔  optional
      * @param {string} [opts.shotIntervalType] - 间隔类型：time, percent  optional
      * @param {string} [opts.shotFormat] - 截图格式：png, jpg  optional
      * @param {string} [opts.shotFrameType] - 截图帧类型：any, key  optional
      * @param {integer} [opts.shotWidth] - 截图宽度  optional
      * @param {integer} [opts.shotHeight] - 截图高度  optional
      * @param {string} [opts.shotFillType] - 截图填充类型：stretch, gauss, black, white  optional
      * @param {string} [opts.inspectItems] - 审查配置，JSON格式  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param viTemplateInfo resultObject
      */

  updateViTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling updateViTemplate"
      )
    }

    let postBody = {}
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.shotInterval !== undefined && opts.shotInterval !== null) {
      postBody['shotInterval'] = opts.shotInterval
    }
    if (opts.shotIntervalType !== undefined && opts.shotIntervalType !== null) {
      postBody['shotIntervalType'] = opts.shotIntervalType
    }
    if (opts.shotFormat !== undefined && opts.shotFormat !== null) {
      postBody['shotFormat'] = opts.shotFormat
    }
    if (opts.shotFrameType !== undefined && opts.shotFrameType !== null) {
      postBody['shotFrameType'] = opts.shotFrameType
    }
    if (opts.shotWidth !== undefined && opts.shotWidth !== null) {
      postBody['shotWidth'] = opts.shotWidth
    }
    if (opts.shotHeight !== undefined && opts.shotHeight !== null) {
      postBody['shotHeight'] = opts.shotHeight
    }
    if (opts.shotFillType !== undefined && opts.shotFillType !== null) {
      postBody['shotFillType'] = opts.shotFillType
    }
    if (opts.inspectItems !== undefined && opts.inspectItems !== null) {
      postBody['inspectItems'] = opts.inspectItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateViTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viTemplates/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除视频审查模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteViTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteViTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  iv/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteViTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/viTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = IV
