/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Ticket API
 * 云托管服务的工单API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'jdccs'
Service._services[serviceId] = true

/**
 * jdccs service.
 * @version 1.1.5
 */

class JDCCS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'jdccs.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询报警规则列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.resourceType] - 资源类型 bandwidth:带宽  optional
      * @param {string} [opts.resourceId] - 资源ID，指定resourceId时须指定resourceType  optional
      * @param {string} [opts.idc] - 机房英文标识  optional
      * @param {string} [opts.status] - 规则状态 disabled:禁用 enabled:启用  optional
      * @param {filter} [opts.filters] - alarmId - 规则实施ID，精确匹配，支持多个
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param describeAlarm alarms
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeAlarms (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.resourceType !== undefined && opts.resourceType !== null) {
      queryParams['resourceType'] = opts.resourceType
    }
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.idc !== undefined && opts.idc !== null) {
      queryParams['idc'] = opts.idc
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAlarms with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建报警
      * @param {Object} opts - parameters
      * @param {string} [opts.idc] - idc机房实例ID  optional
      * @param {string} [opts.resourceType] - 资源类型，bandwidth:带宽  optional
      * @param {string} [opts.resourceId] - 带宽实例ID  optional
      * @param {string} [opts.name] - 规则名称  optional
      * @param {string} [opts.metric] - 监控项，bandwidthTrafficIn:上行实时流量 bandwidthTrafficOut:下行实时流量  optional
      * @param {integer} [opts.period] - 统计周期（单位：分钟）  optional
      * @param {string} [opts.statisticMethod] - 统计方法：平均值&#x3D;avg、最大值&#x3D;max、最小值&#x3D;min  optional
      * @param {string} [opts.operator] - 计算方式 &gt;&#x3D;、&gt;、&lt;、&lt;&#x3D;、&#x3D;、！&#x3D;  optional
      * @param {number} [opts.threshold] - 阈值  optional
      * @param {integer} [opts.times] - 连续多少次后报警  optional
      * @param {integer} [opts.noticePeriod] - 通知周期 单位：小时  optional
      * @param {string} [opts.status] - 规则状态 disabled:禁用 enabled:启用  optional
      * @param {string} [opts.noticeMethod] - 通知方式 all:全部 sms：短信 email:邮件  optional
      * @param {string} [opts.noticeObj] - 通知对象 all:全部 persons：个人 groups:角色组  optional
      * @param {string} [opts.userId] - 通知对象用户ID,若多个用逗号分隔  optional
      * @param {string} [opts.groupId] - 通知对象组ID  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success
      */

  createAlarm (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.idc !== undefined && opts.idc !== null) {
      postBody['idc'] = opts.idc
    }
    if (opts.resourceType !== undefined && opts.resourceType !== null) {
      postBody['resourceType'] = opts.resourceType
    }
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      postBody['resourceId'] = opts.resourceId
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.metric !== undefined && opts.metric !== null) {
      postBody['metric'] = opts.metric
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.statisticMethod !== undefined && opts.statisticMethod !== null) {
      postBody['statisticMethod'] = opts.statisticMethod
    }
    if (opts.operator !== undefined && opts.operator !== null) {
      postBody['operator'] = opts.operator
    }
    if (opts.threshold !== undefined && opts.threshold !== null) {
      postBody['threshold'] = opts.threshold
    }
    if (opts.times !== undefined && opts.times !== null) {
      postBody['times'] = opts.times
    }
    if (opts.noticePeriod !== undefined && opts.noticePeriod !== null) {
      postBody['noticePeriod'] = opts.noticePeriod
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.noticeMethod !== undefined && opts.noticeMethod !== null) {
      postBody['noticeMethod'] = opts.noticeMethod
    }
    if (opts.noticeObj !== undefined && opts.noticeObj !== null) {
      postBody['noticeObj'] = opts.noticeObj
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.groupId !== undefined && opts.groupId !== null) {
      postBody['groupId'] = opts.groupId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询报警规则详情
      * @param {Object} opts - parameters
      * @param {string} opts.alarmId - 报警规则ID
      * @param {string} callback - callback
      @return {Object} result
      * @param alarm alarm
      */

  describeAlarm (opts, callback) {
    opts = opts || {}

    if (opts.alarmId === undefined || opts.alarmId === null) {
      throw new Error(
        "Missing the required parameter 'opts.alarmId' when calling describeAlarm"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      alarmId: opts.alarmId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms/{alarmId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改报警规则
      * @param {Object} opts - parameters
      * @param {string} opts.alarmId - 报警规则ID
      * @param {string} [opts.name] - 规则名称  optional
      * @param {string} [opts.metric] - 监控项，bandwidthTrafficIn:上行实时流量 bandwidthTrafficOut:下行实时流量  optional
      * @param {integer} [opts.period] - 统计周期（单位：分钟）  optional
      * @param {string} [opts.statisticMethod] - 统计方法：平均值&#x3D;avg、最大值&#x3D;max、最小值&#x3D;min  optional
      * @param {string} [opts.operator] - 计算方式 &gt;&#x3D;、&gt;、&lt;、&lt;&#x3D;、&#x3D;、！&#x3D;  optional
      * @param {number} [opts.threshold] - 阈值  optional
      * @param {integer} [opts.times] - 连续多少次后报警  optional
      * @param {integer} [opts.noticePeriod] - 通知周期 单位：小时  optional
      * @param {string} [opts.status] - 规则状态 disabled:禁用 enabled:启用  optional
      * @param {string} [opts.noticeMethod] - 通知方式 all:全部 sms：短信 email:邮件  optional
      * @param {string} [opts.userId] - 通知对象用户ID,若多个用逗号分隔  optional
      * @param {string} [opts.groupId] - 通知对象组ID  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success
      */

  updateAlarm (opts, callback) {
    opts = opts || {}

    if (opts.alarmId === undefined || opts.alarmId === null) {
      throw new Error(
        "Missing the required parameter 'opts.alarmId' when calling updateAlarm"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.metric !== undefined && opts.metric !== null) {
      postBody['metric'] = opts.metric
    }
    if (opts.period !== undefined && opts.period !== null) {
      postBody['period'] = opts.period
    }
    if (opts.statisticMethod !== undefined && opts.statisticMethod !== null) {
      postBody['statisticMethod'] = opts.statisticMethod
    }
    if (opts.operator !== undefined && opts.operator !== null) {
      postBody['operator'] = opts.operator
    }
    if (opts.threshold !== undefined && opts.threshold !== null) {
      postBody['threshold'] = opts.threshold
    }
    if (opts.times !== undefined && opts.times !== null) {
      postBody['times'] = opts.times
    }
    if (opts.noticePeriod !== undefined && opts.noticePeriod !== null) {
      postBody['noticePeriod'] = opts.noticePeriod
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.noticeMethod !== undefined && opts.noticeMethod !== null) {
      postBody['noticeMethod'] = opts.noticeMethod
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.groupId !== undefined && opts.groupId !== null) {
      postBody['groupId'] = opts.groupId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      alarmId: opts.alarmId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms/{alarmId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除报警
      * @param {Object} opts - parameters
      * @param {string} opts.alarmId - 报警规则ID
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success
      */

  deleteAlarm (opts, callback) {
    opts = opts || {}

    if (opts.alarmId === undefined || opts.alarmId === null) {
      throw new Error(
        "Missing the required parameter 'opts.alarmId' when calling deleteAlarm"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      alarmId: opts.alarmId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms/{alarmId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  报警历史列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.alarmId] - 报警规则ID  optional
      * @param {string} [opts.idc] - 机房英文标识  optional
      * @param {integer} [opts.startTime] - 查询时间范围的开始时间， UNIX时间戳  optional
      * @param {integer} [opts.endTime] - 查询时间范围的结束时间， UNIX时间戳  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param alarmHistory alarmHistory
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeAlarmHistory (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.alarmId !== undefined && opts.alarmId !== null) {
      queryParams['alarmId'] = opts.alarmId
    }
    if (opts.idc !== undefined && opts.idc !== null) {
      queryParams['idc'] = opts.idc
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAlarmHistory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarmHistory',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用、禁用报警
      * @param {Object} opts - parameters
      * @param {string} opts.alarmId - 报警规则ID
      * @param {string} [opts.status] - 规则状态 disabled:禁用 enabled:启用  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success
      */

  switchAlarm (opts, callback) {
    opts = opts || {}

    if (opts.alarmId === undefined || opts.alarmId === null) {
      throw new Error(
        "Missing the required parameter 'opts.alarmId' when calling switchAlarm"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      alarmId: opts.alarmId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call switchAlarm with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/alarms/{alarmId}:switch',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询可用监控项列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param metric metrics
      */

  describeMetrics (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMetrics with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/metrics',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看某资源单个监控项数据
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.metric - 监控项英文标识(id)
      * @param {string} opts.resourceId - 资源ID
      * @param {integer} opts.startTime - 查询时间范围的开始时间， UNIX时间戳，（机柜电流最多支持最近90天数据查询、带宽流量最多支持最近30天数据查询）
      * @param {integer} opts.endTime - 查询时间范围的结束时间， UNIX时间戳，（机柜电流最多支持最近90天数据查询、带宽流量最多支持最近30天数据查询）
      * @param {string} [opts.timeInterval] - 时间间隔：分钟m、小时h、天d，如： 10分钟&#x3D;10m、1小时&#x3D;1h，3天&#x3D;3d；默认5m，最小支持5m，最大90d 目前带宽上、下行流量查询，时间间隔：1m、5m，默认5m。1m时间间隔支持的最大时间范围为2小时  optional
      * @param {string} [opts.ip] - 交换机IP，指定ip时须同时指定port  optional
      * @param {string} [opts.port] - 端口，指定port时须同时指定ip  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param metricData metricData
      */

  describeMetricData (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeMetricData"
      )
    }
    if (opts.metric === undefined || opts.metric === null) {
      throw new Error(
        "Missing the required parameter 'opts.metric' when calling describeMetricData"
      )
    }
    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeMetricData"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeMetricData"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling describeMetricData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.timeInterval !== undefined && opts.timeInterval !== null) {
      queryParams['timeInterval'] = opts.timeInterval
    }
    if (opts.ip !== undefined && opts.ip !== null) {
      queryParams['ip'] = opts.ip
    }
    if (opts.port !== undefined && opts.port !== null) {
      queryParams['port'] = opts.port
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      metric: opts.metric
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeMetricData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/metrics/{metric}/metricData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看某资源的最后一个监控数据点（目前只支持机柜电流）
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.metric - 监控项英文标识(id)
      * @param {string} opts.resourceId - 资源ID，支持多个resourceId批量查询，每个id用英文竖线分隔
      * @param {string} callback - callback
      @return {Object} result
      * @param lastDownsampleRespItem items
      */

  lastDownsample (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling lastDownsample"
      )
    }
    if (opts.metric === undefined || opts.metric === null) {
      throw new Error(
        "Missing the required parameter 'opts.metric' when calling lastDownsample"
      )
    }
    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling lastDownsample"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      metric: opts.metric
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call lastDownsample with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/metrics/{metric}/lastDownsample',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询带宽（出口）流量列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.bandwidthName] - 带宽（出口）名称  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param describeBandwidthTraffic bandwidthTraffics
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeBandwidthTraffics (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeBandwidthTraffics"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.bandwidthName !== undefined && opts.bandwidthName !== null) {
      queryParams['bandwidthName'] = opts.bandwidthName
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBandwidthTraffics with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/bandwidthTraffics',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询带宽（出口）流量（资源）详情
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.bandwidthId - 带宽（出口）实例ID
      * @param {string} callback - callback
      @return {Object} result
      * @param bandwidthTraffic bandwidthTraffic  带宽（出口）流量（资源）详情
      */

  describeBandwidthTraffic (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeBandwidthTraffic"
      )
    }
    if (opts.bandwidthId === undefined || opts.bandwidthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.bandwidthId' when calling describeBandwidthTraffic"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      bandwidthId: opts.bandwidthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBandwidthTraffic with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/bandwidthTraffics/{bandwidthId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据IP网段查询流量采样数据
      * @param {Object} opts - parameters
      * @param {string} opts.resourceId - 资源ID，支持多个resourceId批量查询，每个id用英文竖线分隔
      * @param {integer} opts.startTime - 查询时间范围的开始时间， UNIX时间戳，（支持查询最近30分钟数据且时间范围不超过5分钟）
      * @param {integer} opts.endTime - 查询时间范围的结束时间， UNIX时间戳，（支持查询最近30分钟数据且时间范围不超过5分钟）
      * @param {string} callback - callback
      @return {Object} result
      * @param trafficSamplingData data
      */

  describeTrafficSampling (opts, callback) {
    opts = opts || {}

    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeTrafficSampling"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeTrafficSampling"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling describeTrafficSampling"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTrafficSampling with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/trafficSampling',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询开放设备列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param openDevices openDevices
      */

  describeOpenDevices (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeOpenDevices with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/openDevices',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询开放设备数据信息接口
      * @param {Object} opts - parameters
      * @param {string} [opts.deviceCodes] - 设备编码,支持多个deviceCode批量查询，每个id用英文竖线分隔  optional
      * @param {string} opts.deviceType - 设备类型
      * @param {string} callback - callback
      @return {Object} result
      * @param openDevicesData data
      */

  describeOpenDevicesData (opts, callback) {
    opts = opts || {}

    if (opts.deviceType === undefined || opts.deviceType === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceType' when calling describeOpenDevicesData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deviceCodes !== undefined && opts.deviceCodes !== null) {
      queryParams['deviceCodes'] = opts.deviceCodes
    }
    if (opts.deviceType !== undefined && opts.deviceType !== null) {
      queryParams['deviceType'] = opts.deviceType
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeOpenDevicesData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/openDevicesData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按照时间段查询单个机柜AB路电流
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.resourceId - 机柜资源ID
      * @param {integer} opts.startTime - 查询时间范围的开始时间， UNIX时间戳，（最多支持最近90天数据查询）
      * @param {integer} opts.endTime - 查询时间范围的结束时间， UNIX时间戳，（最多支持最近90天数据查询）
      * @param {string} [opts.timeInterval] - 时间间隔：分钟m、小时h、天d，如： 10分钟&#x3D;10m、1小时&#x3D;1h，3天&#x3D;3d；默认5m，最小支持5m，最大90d 目前带宽上、下行流量查询，时间间隔：1m、5m，默认5m。时间间隔支持的最大时间范围为2小时  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param cabinetCurrentRespItem data
      */

  describeRangetimeCabinetCurrent (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeRangetimeCabinetCurrent"
      )
    }
    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeRangetimeCabinetCurrent"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeRangetimeCabinetCurrent"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling describeRangetimeCabinetCurrent"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.timeInterval !== undefined && opts.timeInterval !== null) {
      queryParams['timeInterval'] = opts.timeInterval
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRangetimeCabinetCurrent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/rangetimeCabinetCurrent',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询多个机柜AB路实时电流
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.resourceId - 资源ID，支持多个resourceId批量查询，每个id用英文竖线分隔
      * @param {string} callback - callback
      @return {Object} result
      * @param cabinetCurrentRespItem data
      */

  describeRealtimeCabinetCurrent (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeRealtimeCabinetCurrent"
      )
    }
    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeRealtimeCabinetCurrent"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRealtimeCabinetCurrent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/realtimeCabinetCurrent',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按照时间段查询单个机柜AB路电流-原始数据
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.resourceId - 机柜资源ID
      * @param {integer} opts.startTime - 查询时间范围的开始时间， UNIX时间戳，（最多支持最近90天数据查询）
      * @param {integer} opts.endTime - 查询时间范围的结束时间， UNIX时间戳，（最多支持最近90天数据查询）
      * @param {string} callback - callback
      @return {Object} result
      * @param object data
      */

  describeRangetimeCabinetOriCurrent (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeRangetimeCabinetOriCurrent"
      )
    }
    if (opts.resourceId === undefined || opts.resourceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceId' when calling describeRangetimeCabinetOriCurrent"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeRangetimeCabinetOriCurrent"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling describeRangetimeCabinetOriCurrent"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceId !== undefined && opts.resourceId !== null) {
      queryParams['resourceId'] = opts.resourceId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRangetimeCabinetOriCurrent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/rangetimeCabinetOriCurrent',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询IDC机房列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {integer} [opts.all] - 是否查询全部，默认分页  optional
      * @param {string} [opts.includeExternalIdc] - 是否强制包含外部机房 yes/no  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param idc idcs
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeIdcs (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.all !== undefined && opts.all !== null) {
      queryParams['all'] = opts.all
    }
    if (
      opts.includeExternalIdc !== undefined &&
      opts.includeExternalIdc !== null
    ) {
      queryParams['includeExternalIdc'] = opts.includeExternalIdc
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeIdcs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询机房房间号列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {integer} [opts.all] - 是否查询全部，默认分页  optional
      * @param {filter} [opts.filters] - roomNo - 房间号，精确匹配，支持多个
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param room rooms
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeRooms (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeRooms"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.all !== undefined && opts.all !== null) {
      queryParams['all'] = opts.all
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRooms with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/rooms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询机柜列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.cabinetType] - 机柜类型 formal:正式机柜 reserved:预留机柜  optional
      * @param {string} [opts.cabinetOpenStatus] - 机柜开通状态 disabled:未开通 enabling:开通中 enabled:已开通 disabling:关电中  optional
      * @param {string} [opts.cabinetNo] - 机柜编码  optional
      * @param {filter} [opts.filters] - roomNo - 房间号，精确匹配，支持多个
cabinetId - 机柜ID，精确匹配，支持多个
cabinetNo - 机柜编码，精确匹配，支持多个
cabinetOpenStatus - 机柜开通状态，精确匹配，支持多个
  optional
      * @param {sort} [opts.sorts] - cabinetNo - 机柜编码 roomNo - 房间号  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param describeCabinet cabinets
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeCabinets (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeCabinets"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.cabinetType !== undefined && opts.cabinetType !== null) {
      queryParams['cabinetType'] = opts.cabinetType
    }
    if (
      opts.cabinetOpenStatus !== undefined &&
      opts.cabinetOpenStatus !== null
    ) {
      queryParams['cabinetOpenStatus'] = opts.cabinetOpenStatus
    }
    if (opts.cabinetNo !== undefined && opts.cabinetNo !== null) {
      queryParams['cabinetNo'] = opts.cabinetNo
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCabinets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/cabinets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询机柜详情
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.cabinetId - 机柜实例ID
      * @param {string} callback - callback
      @return {Object} result
      * @param cabinet cabinet
      */

  describeCabinet (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeCabinet"
      )
    }
    if (opts.cabinetId === undefined || opts.cabinetId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cabinetId' when calling describeCabinet"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      cabinetId: opts.cabinetId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCabinet with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/cabinets/{cabinetId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询设备列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.cabinetId] - 机柜ID  optional
      * @param {string} [opts.deviceType] - 设备类型 server:服务器 network:网络设备 storage:存储设备 other:其他设备  optional
      * @param {string} [opts.assetStatus] - 资产状态 launched:已上架 opened:已开通 canceling:退订中 operating:操作中 modifing:变更中  optional
      * @param {string} [opts.assetBelong] - 资产归属 own:自备 lease:租赁  optional
      * @param {string} [opts.deviceNo] - 设备编码  optional
      * @param {string} [opts.snNo] - 设备SN号  optional
      * @param {filter} [opts.filters] - deviceId - 设备实例ID，精确匹配，支持多个
snNo - 设备SN号，精确匹配，支持多个
deviceNo - 设备编码，精确匹配，支持多个
cabinetNo - 机柜编码，精确匹配，支持多个
  optional
      * @param {sort} [opts.sorts] - deviceNo - 设备编码 cabinetNo - 机柜编码  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param describeDevice devices
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeDevices (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeDevices"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.cabinetId !== undefined && opts.cabinetId !== null) {
      queryParams['cabinetId'] = opts.cabinetId
    }
    if (opts.deviceType !== undefined && opts.deviceType !== null) {
      queryParams['deviceType'] = opts.deviceType
    }
    if (opts.assetStatus !== undefined && opts.assetStatus !== null) {
      queryParams['assetStatus'] = opts.assetStatus
    }
    if (opts.assetBelong !== undefined && opts.assetBelong !== null) {
      queryParams['assetBelong'] = opts.assetBelong
    }
    if (opts.deviceNo !== undefined && opts.deviceNo !== null) {
      queryParams['deviceNo'] = opts.deviceNo
    }
    if (opts.snNo !== undefined && opts.snNo !== null) {
      queryParams['snNo'] = opts.snNo
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDevices with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/devices',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询设备详情
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.deviceId - 设备实例ID
      * @param {string} callback - callback
      @return {Object} result
      * @param device device
      */

  describeDevice (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeDevice"
      )
    }
    if (opts.deviceId === undefined || opts.deviceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.deviceId' when calling describeDevice"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      deviceId: opts.deviceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDevice with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/devices/{deviceId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询公网IP列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.lineType] - 线路类型 dynamicBGP:动态BGP thirdLineBGP:三线BGP telecom:电信单线 unicom:联通单线 mobile:移动单线  optional
      * @param {string} [opts.status] - 状态 normal:正常 abnormal:异常  optional
      * @param {string} [opts.cidrAddr] - IP地址段  optional
      * @param {filter} [opts.filters] - ipId - 公网IP实例ID，精确匹配，支持多个
  optional
      * @param {sort} [opts.sorts] - null  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param ip ips
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeIps (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeIps"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.lineType !== undefined && opts.lineType !== null) {
      queryParams['lineType'] = opts.lineType
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.cidrAddr !== undefined && opts.cidrAddr !== null) {
      queryParams['cidrAddr'] = opts.cidrAddr
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeIps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/ips',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询带宽（出口）列表
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.lineType] - 线路类型 dynamicBGP:动态BGP thirdLineBGP:三线BGP telecom:电信单线 unicom:联通单线 mobile:移动单线  optional
      * @param {string} [opts.chargeType] - 计费方式 fixedBandwidth:固定带宽 95thPercentile:95峰值 merge95thPercentile:合并95峰值  optional
      * @param {string} [opts.bandwidthName] - 带宽（出口）名称  optional
      * @param {string} [opts.relatedIp] - 关联的公网IP  optional
      * @param {filter} [opts.filters] - bandwidthId - 带宽实例ID，精确匹配，支持多个
  optional
      * @param {sort} [opts.sorts] - null  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param describeBandwidth bandwidths
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeBandwidths (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeBandwidths"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.lineType !== undefined && opts.lineType !== null) {
      queryParams['lineType'] = opts.lineType
    }
    if (opts.chargeType !== undefined && opts.chargeType !== null) {
      queryParams['chargeType'] = opts.chargeType
    }
    if (opts.bandwidthName !== undefined && opts.bandwidthName !== null) {
      queryParams['bandwidthName'] = opts.bandwidthName
    }
    if (opts.relatedIp !== undefined && opts.relatedIp !== null) {
      queryParams['relatedIp'] = opts.relatedIp
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBandwidths with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/bandwidths',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询带宽（出口）详情
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} opts.bandwidthId - 带宽（出口）实例ID
      * @param {string} callback - callback
      @return {Object} result
      * @param bandwidth bandwidth
      */

  describeBandwidth (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeBandwidth"
      )
    }
    if (opts.bandwidthId === undefined || opts.bandwidthId === null) {
      throw new Error(
        "Missing the required parameter 'opts.bandwidthId' when calling describeBandwidth"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc,
      bandwidthId: opts.bandwidthId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/bandwidths/{bandwidthId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询机房资源概览
      * @param {Object} opts - parameters
      * @param {string} opts.idc - IDC机房ID
      * @param {string} callback - callback
      @return {Object} result
      * @param cabinetOverview cabinet
      * @param deviceOverview device
      * @param ipOverview ip
      * @param bandwidthOverview bandwidth
      */

  describeIdcOverview (opts, callback) {
    opts = opts || {}

    if (opts.idc === undefined || opts.idc === null) {
      throw new Error(
        "Missing the required parameter 'opts.idc' when calling describeIdcOverview"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      idc: opts.idc
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeIdcOverview with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/idcs/{idc}/overview',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询工单列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20  optional
      * @param {string} [opts.type] - 工单TAB类型 pendingProcess:待我处理 pendingReview:待审核 processing:处理中 all:全部(默认)  optional
      * @param {string} [opts.ticketTypeName] - 工单类型  optional
      * @param {string} [opts.status] - 工单状态 pendingReview:待审核 revoked:已撤销 processing:处理中 pendingVerification:待核验 pendingClose:待关单 rejected:已拒绝 completed:已完成 cancelled:已取消 draft:草稿中  optional
      * @param {string} [opts.ticketNo] - 工单编号  optional
      * @param {string} [opts.ticketTemplateName] - 工单名称  optional
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.startTime] - 创建开始时间，遵循ISO8601标准，使用UTC时间，格式为：yyyy-MM-ddTHH:mm:ssZ  optional
      * @param {string} [opts.endTime] - 创建结束时间，遵循ISO8601标准，使用UTC时间，格式为：yyyy-MM-ddTHH:mm:ssZ  optional
      * @param {filter} [opts.filters] - ticketNo - 工单编号，精确匹配，支持多个
  optional
      * @param {sort} [opts.sorts] - createdTime - 创建时间 closedTime - 关闭时间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param ticket tickets
      * @param integer pageNumber  页码
      * @param integer pageSize  分页大小
      * @param integer totalCount  总数量
      */

  describeTickets (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.ticketTypeName !== undefined && opts.ticketTypeName !== null) {
      queryParams['ticketTypeName'] = opts.ticketTypeName
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.ticketNo !== undefined && opts.ticketNo !== null) {
      queryParams['ticketNo'] = opts.ticketNo
    }
    if (
      opts.ticketTemplateName !== undefined &&
      opts.ticketTemplateName !== null
    ) {
      queryParams['ticketTemplateName'] = opts.ticketTemplateName
    }
    if (opts.description !== undefined && opts.description !== null) {
      queryParams['description'] = opts.description
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTickets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/tickets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询工单详情
      * @param {Object} opts - parameters
      * @param {string} opts.ticketNo - 工单编号
      * @param {string} callback - callback
      @return {Object} result
      * @param ticket ticket  工单详情
      */

  describeTicket (opts, callback) {
    opts = opts || {}

    if (opts.ticketNo === undefined || opts.ticketNo === null) {
      throw new Error(
        "Missing the required parameter 'opts.ticketNo' when calling describeTicket"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      ticketNo: opts.ticketNo
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTicket with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/tickets/{ticketNo}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交通用服务工单
      * @param {Object} opts - parameters
      * @param {string} [opts.phone] - 提单人手机号  optional
      * @param {string} [opts.email] - 提单人邮箱  optional
      * @param {string} [opts.idc] - idc机房实例id  optional
      * @param {boolean} [opts.isExternalIdc] - 是否是商业化外部机房  optional
      * @param {integer} [opts.count] - 数量  optional
      * @param {string} [opts.externalIdcAddress] - 外部机房地址  optional
      * @param {string} [opts.externalIdcContactPerson] - 外部机房联系人  optional
      * @param {string} [opts.externalIdcContactPhone] - 外部机房联系电话  optional
      * @param {string} [opts.remarks] - 描述  optional
      * @param {array} [opts.attach] - 附件  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string ticketNo
      */

  createGeneralServicesTicket (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.email !== undefined && opts.email !== null) {
      postBody['email'] = opts.email
    }
    if (opts.idc !== undefined && opts.idc !== null) {
      postBody['idc'] = opts.idc
    }
    if (opts.isExternalIdc !== undefined && opts.isExternalIdc !== null) {
      postBody['isExternalIdc'] = opts.isExternalIdc
    }
    if (opts.count !== undefined && opts.count !== null) {
      postBody['count'] = opts.count
    }
    if (
      opts.externalIdcAddress !== undefined &&
      opts.externalIdcAddress !== null
    ) {
      postBody['externalIdcAddress'] = opts.externalIdcAddress
    }
    if (
      opts.externalIdcContactPerson !== undefined &&
      opts.externalIdcContactPerson !== null
    ) {
      postBody['externalIdcContactPerson'] = opts.externalIdcContactPerson
    }
    if (
      opts.externalIdcContactPhone !== undefined &&
      opts.externalIdcContactPhone !== null
    ) {
      postBody['externalIdcContactPhone'] = opts.externalIdcContactPhone
    }
    if (opts.remarks !== undefined && opts.remarks !== null) {
      postBody['remarks'] = opts.remarks
    }
    if (opts.attach !== undefined && opts.attach !== null) {
      postBody['attach'] = opts.attach
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  jdccs/1.1.5'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createGeneralServicesTicket with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/generalServicesTicket',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCCS
