/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ServerlessCluster
 * Serverless集群相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'kubernetes'
Service._services[serviceId] = true

/**
 * kubernetes service.
 * @version 1.2.2
 */

class KUBERNETES extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'kubernetes.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询集群列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为20；取值范围[10, 100]  optional
      * @param {filter} [opts.filters] - name - 集群名称，模糊匹配，仅支持单个
id - id，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cluster clusters
      * @param number totalCount
      */

  describeClusters (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeClusters"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeClusters with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/clusters',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  - 创建集群
- 证书
  - 关于kubernetes的证书，默认生成，不需要用户传入。
- nodegroup
  - cluster必须与nodeGroup进行绑定
  - cluster支持多nodegroup
  - 状态
    - pending,reconciling,deleting状态不可以操作更新接口
    - running，running_with_error状态可以操作nodegroup所有接口
    - error状态只可以查询，删除
    - delete状态的cluster在十五分钟内可以查询，十五分钟后无法查询到
- 状态限制
  - pending,reconciling,deleting状态不可以操作更新接口
  - running状态可以操作cluster所有接口
  - error状态只可以查询，删除
  - delete状态的cluster在十五分钟内可以查询，十五分钟后无法查询到

      * @param {Object} opts - parameters
      * @param {string} opts.name - 名称（同一用户的 cluster 允许重名）
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.version] - kubernetes的版本  optional
      * @param {boolean} [opts.isEdge] - 是否是边缘计算集群  optional
      * @param {array} [opts.azs] - 集群所在的az  optional
      * @param {nodeGroupSpec} opts.nodeGroup - 集群节点组
      * @param {string} opts.accessKey - 用户的AccessKey，插件调用open-api时的认证凭证
      * @param {string} opts.secretKey - 用户的SecretKey，插件调用open-api时的认证凭证
      * @param {array} [opts.addonsConfig] - 集群组件配置  optional
      * @param {string} [opts.clusterNetworkType] - 集群网络配置类型，取值：auto，customized，创建集群接口合并，原CreateCusomizedCluster接口废弃  optional
      * @param {autoClusterNetworkSpec} [opts.autoClusterNetworkSpec] - clusterNetworkType为【auto】时，此配置必须要配置  optional
      * @param {customizedClusterNetworkSpec} [opts.customizedClusterNetworkSpec] - clusterNetworkType为【customized】时，此配置必须要配置  optional
      * @param {array} [opts.clusterEnvironments] - 用户自定义的集群的环境信息，会影响到创建集群时的组件模版的渲染  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string clusterId
      */

  createCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createCluster"
      )
    }

    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createCluster"
      )
    }
    if (opts.nodeGroup === undefined || opts.nodeGroup === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroup' when calling createCluster"
      )
    }
    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling createCluster"
      )
    }
    if (opts.secretKey === undefined || opts.secretKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.secretKey' when calling createCluster"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.isEdge !== undefined && opts.isEdge !== null) {
      postBody['isEdge'] = opts.isEdge
    }
    if (opts.azs !== undefined && opts.azs !== null) {
      postBody['azs'] = opts.azs
    }
    if (opts.nodeGroup !== undefined && opts.nodeGroup !== null) {
      postBody['nodeGroup'] = opts.nodeGroup
    }
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.secretKey !== undefined && opts.secretKey !== null) {
      postBody['secretKey'] = opts.secretKey
    }
    if (opts.addonsConfig !== undefined && opts.addonsConfig !== null) {
      postBody['addonsConfig'] = opts.addonsConfig
    }
    if (
      opts.clusterNetworkType !== undefined &&
      opts.clusterNetworkType !== null
    ) {
      postBody['clusterNetworkType'] = opts.clusterNetworkType
    }
    if (
      opts.autoClusterNetworkSpec !== undefined &&
      opts.autoClusterNetworkSpec !== null
    ) {
      postBody['autoClusterNetworkSpec'] = opts.autoClusterNetworkSpec
    }
    if (
      opts.customizedClusterNetworkSpec !== undefined &&
      opts.customizedClusterNetworkSpec !== null
    ) {
      postBody['customizedClusterNetworkSpec'] =
        opts.customizedClusterNetworkSpec
    }
    if (
      opts.clusterEnvironments !== undefined &&
      opts.clusterEnvironments !== null
    ) {
      postBody['clusterEnvironments'] = opts.clusterEnvironments
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/clusters',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个集群详情。
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cluster cluster
      */

  describeCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling describeCluster"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/clusters/{clusterId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改集群的 名称 和 描述。&lt;br&gt;集群 name 和 description 必须要指定一个
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} [opts.name] - 集群名称  optional
      * @param {string} [opts.description] - 集群描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling modifyCluster"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/clusters/{clusterId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除集群，以及集群的所有node节点，网络，云盘等所有资源。
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} [opts.routeTableId] - 替换路由表id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling deleteCluster"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.routeTableId !== undefined && opts.routeTableId !== null) {
      queryParams['routeTableId'] = opts.routeTableId
    }

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/clusters/{clusterId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询工作节点组列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为20；取值范围[10, 100]  optional
      * @param {filter} [opts.filters] - name - 节点组名称，模糊匹配，支持单个
id - 节点组 id，支持多个
clusterId - 根据 clusterId 查询
clusterName - 根据 cluster 名称查询
  optional
      * @param {tagFilter} [opts.tags] - Tag筛选条件  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param nodeGroup nodeGroups
      * @param number totalCount
      */

  describeNodeGroups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeNodeGroups"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildTagFilterParam(opts.tags, 'tags'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeNodeGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建工作节点组&lt;br&gt;
- 要求集群状态为running

      * @param {Object} opts - parameters
      * @param {string} opts.name - 名称（同一用户的 cluster 内部唯一）
      * @param {string} [opts.description] - 描述  optional
      * @param {string} opts.clusterId - 工作节点所属的集群
      * @param {nodeConfigSpec} opts.nodeConfig - 工作节点配置信息
      * @param {array} [opts.azs] - 工作节点组的 az，必须为集群az的子集，默认为集群az  optional
      * @param {integer} opts.initialNodeCount - 工作节点组初始化大小
      * @param {cAConfigSpec} [opts.caConfig] - 自动伸缩配置  optional
      * @param {nodeGroupNetworkSpec} [opts.nodeGroupNetwork] - 节点组的网络配置，如果集群的类型customized类型，则必须指定该参数，如果是auto，则不是必须  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string nodeGroupId
      */

  createNodeGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createNodeGroup"
      )
    }

    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createNodeGroup"
      )
    }
    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling createNodeGroup"
      )
    }
    if (opts.nodeConfig === undefined || opts.nodeConfig === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeConfig' when calling createNodeGroup"
      )
    }
    if (opts.initialNodeCount === undefined || opts.initialNodeCount === null) {
      throw new Error(
        "Missing the required parameter 'opts.initialNodeCount' when calling createNodeGroup"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.clusterId !== undefined && opts.clusterId !== null) {
      postBody['clusterId'] = opts.clusterId
    }
    if (opts.nodeConfig !== undefined && opts.nodeConfig !== null) {
      postBody['nodeConfig'] = opts.nodeConfig
    }
    if (opts.azs !== undefined && opts.azs !== null) {
      postBody['azs'] = opts.azs
    }
    if (opts.initialNodeCount !== undefined && opts.initialNodeCount !== null) {
      postBody['initialNodeCount'] = opts.initialNodeCount
    }
    if (opts.caConfig !== undefined && opts.caConfig !== null) {
      postBody['caConfig'] = opts.caConfig
    }
    if (opts.nodeGroupNetwork !== undefined && opts.nodeGroupNetwork !== null) {
      postBody['nodeGroupNetwork'] = opts.nodeGroupNetwork
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createNodeGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个工作节点组详情
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param nodeGroup nodeGroup
      */

  describeNodeGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeNodeGroup"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling describeNodeGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeNodeGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改工作节点组的 名称 和 描述&lt;br&gt;name 和 description 必须要指定一个
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {string} [opts.name] - 工作节点组名称  optional
      * @param {string} [opts.description] - 工作节点组描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyNodeGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyNodeGroup"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling modifyNodeGroup"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyNodeGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  集群摘除工作节点组并删除工作节点组
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteNodeGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteNodeGroup"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling deleteNodeGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteNodeGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  调整工作节点组实例数量
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {integer} opts.expectCount - 预期目标节点数量
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setNodeGroupSize (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setNodeGroupSize"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling setNodeGroupSize"
      )
    }
    if (opts.expectCount === undefined || opts.expectCount === null) {
      throw new Error(
        "Missing the required parameter 'opts.expectCount' when calling setNodeGroupSize"
      )
    }

    let postBody = {}
    if (opts.expectCount !== undefined && opts.expectCount !== null) {
      postBody['expectCount'] = opts.expectCount
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setNodeGroupSize with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}:setNodeGroupSize',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置工作节点组自动扩容缩容
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {cAConfigSpec} opts.caConfig - 自动伸缩配置，其中 enable 必须指定
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setNodeGroupCA (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setNodeGroupCA"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling setNodeGroupCA"
      )
    }
    if (opts.caConfig === undefined || opts.caConfig === null) {
      throw new Error(
        "Missing the required parameter 'opts.caConfig' when calling setNodeGroupCA"
      )
    }

    let postBody = {}
    if (opts.caConfig !== undefined && opts.caConfig !== null) {
      postBody['caConfig'] = opts.caConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setNodeGroupCA with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}:setNodeGroupCA',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  从工作节点组中删除指定实例
      * @param {Object} opts - parameters
      * @param {string} opts.nodeGroupId - 工作节点组 ID
      * @param {array} [opts.instanceIds] - 需要从工作节点组中删除的实例
- 不可将一个集群中的实例全部删除
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteNodeInstances (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteNodeInstances"
      )
    }

    opts = opts || {}

    if (opts.nodeGroupId === undefined || opts.nodeGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeGroupId' when calling deleteNodeInstances"
      )
    }

    let postBody = {}
    if (opts.instanceIds !== undefined && opts.instanceIds !== null) {
      postBody['instanceIds'] = opts.instanceIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      nodeGroupId: opts.nodeGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteNodeInstances with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/nodeGroups/{nodeGroupId}:deleteNodeInstances',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询 kubernetes 集群配额
      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - resourceTypes - 资源类型，暂时只支持[kubernetes、serverless-kubernetes]
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param quota quotas
      */

  describeQuotas (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeQuotas"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeQuotas with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/quotas',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询版本信息
      * @param {Object} opts - parameters
      * @param {string} [opts.masterVersion] - 集群的大版本，如 1.16.4-jcs.3  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param masterVersion masterVersions
      */

  describeVersions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeVersions"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.masterVersion !== undefined && opts.masterVersion !== null) {
      queryParams['masterVersion'] = opts.masterVersion
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeVersions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/versions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Serverless集群列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为20；取值范围[10, 100]  optional
      * @param {filter} [opts.filters] - name - 集群名称，模糊匹配，仅支持单个
id - id，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param serverlessCluster clusters
      * @param number totalCount
      */

  describeServerlessClusters (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeServerlessClusters"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeServerlessClusters with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-clusters',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  - 创建Serverless集群
- 证书
  - 关于kubernetes的证书，默认生成，不需要用户传入。
- 状态限制
  - pending,reconciling,deleting状态不可以操作更新接口
  - running状态可以操作cluster所有接口
  - error状态只可以查询，删除
  - delete状态的cluster在十五分钟内可以查询，十五分钟后无法查询到

      * @param {Object} opts - parameters
      * @param {string} opts.name - 名称（同一用户的 cluster 允许重名）
      * @param {string} [opts.description] - 描述  optional
      * @param {string} [opts.version] - kubernetes的版本  optional
      * @param {array} [opts.azs] - 集群所在的az  optional
      * @param {string} opts.accessKey - 用户的AccessKey，插件调用open-api时的认证凭证
      * @param {string} opts.secretKey - 用户的SecretKey，插件调用open-api时的认证凭证
      * @param {array} [opts.addonsConfig] - 集群组件配置  optional
      * @param {serverlessClusterNetworkSpec} opts.clusterNetworkSpec - 集群网络配置
      * @param {array} [opts.clusterEnvironments] - 用户自定义的集群的环境信息，会影响到创建集群时的组件模版的渲染  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string clusterId
      */

  createServerlessCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createServerlessCluster"
      )
    }

    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createServerlessCluster"
      )
    }
    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling createServerlessCluster"
      )
    }
    if (opts.secretKey === undefined || opts.secretKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.secretKey' when calling createServerlessCluster"
      )
    }
    if (
      opts.clusterNetworkSpec === undefined ||
      opts.clusterNetworkSpec === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.clusterNetworkSpec' when calling createServerlessCluster"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.azs !== undefined && opts.azs !== null) {
      postBody['azs'] = opts.azs
    }
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.secretKey !== undefined && opts.secretKey !== null) {
      postBody['secretKey'] = opts.secretKey
    }
    if (opts.addonsConfig !== undefined && opts.addonsConfig !== null) {
      postBody['addonsConfig'] = opts.addonsConfig
    }
    if (
      opts.clusterNetworkSpec !== undefined &&
      opts.clusterNetworkSpec !== null
    ) {
      postBody['clusterNetworkSpec'] = opts.clusterNetworkSpec
    }
    if (
      opts.clusterEnvironments !== undefined &&
      opts.clusterEnvironments !== null
    ) {
      postBody['clusterEnvironments'] = opts.clusterEnvironments
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createServerlessCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-clusters',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个集群详情。
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param serverlessCluster cluster
      */

  describeServerlessCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeServerlessCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling describeServerlessCluster"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeServerlessCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-clusters/{clusterId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改Serverless集群的 名称 和 描述。&lt;br&gt;集群 name 和 description 必须要指定一个
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} [opts.name] - 集群名称  optional
      * @param {string} [opts.description] - 集群描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyServerlessCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyServerlessCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling modifyServerlessCluster"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyServerlessCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-clusters/{clusterId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除Serverless集群，以及集群的所有网络，云盘等所有资源。
      * @param {Object} opts - parameters
      * @param {string} opts.clusterId - 集群 ID
      * @param {string} [opts.routeTableId] - 替换路由表id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteServerlessCluster (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteServerlessCluster"
      )
    }

    opts = opts || {}

    if (opts.clusterId === undefined || opts.clusterId === null) {
      throw new Error(
        "Missing the required parameter 'opts.clusterId' when calling deleteServerlessCluster"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.routeTableId !== undefined && opts.routeTableId !== null) {
      queryParams['routeTableId'] = opts.routeTableId
    }

    let pathParams = {
      regionId: regionId,
      clusterId: opts.clusterId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteServerlessCluster with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-clusters/{clusterId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Serverless集群版本列表
      * @param {Object} opts - parameters
      * @param {string} [opts.masterVersion]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param serverlessMasterVersion masterVersions
      */

  describeServerlessVersions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeServerlessVersions"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.masterVersion !== undefined && opts.masterVersion !== null) {
      queryParams['masterVersion'] = opts.masterVersion
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  kubernetes/1.2.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeServerlessVersions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/serverless-versions',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = KUBERNETES
