/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Forwarding-Rules-Group
 * 转发规则组相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'lb'
Service._services[serviceId] = true

/**
 * lb service.
 * @version 0.6.6
 */

class LB extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'lb.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询后端服务列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - backendIds - 后端服务Id列表，支持多个
backendNames - 后端服务名字列表，支持多个
loadBalancerId - 负载均衡器Id，支持单个
agId - 可用性组Id，支持单个
loadBalancerType - 负载均衡类型，取值为：alb、nlb、dnlb，默认alb，支持单个
protocol - 后端服务的协议【alb】支持Http、Tcp和Udp，【nlb】支持Tcp、Udp，【dnlb】支持Tcp、Udp，默认查询所有，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backend backends
      * @param integer totalCount  总数量
      */

  describeBackends (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackends"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackends with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个后端服务
      * @param {Object} opts - parameters
      * @param {string} opts.backendName - 后端服务名字,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} opts.loadBalancerId - 后端服务所属负载均衡的Id
      * @param {string} opts.protocol - 后端服务的协议 &lt;br&gt;【alb】取值范围：Http、Tcp、Udp &lt;br&gt;【nlb】取值范围：Tcp、Udp &lt;br&gt;【dnlb】取值范围：Tcp、Udp
      * @param {integer} opts.port - 后端服务的端口，取值范围为[1, 65535]，如指定了TargetSpec中的port，实际按照target指定的port进行转发
      * @param {healthCheckSpec} opts.healthCheckSpec - 健康检查信息
      * @param {string} [opts.algorithm] - 调度算法 &lt;br&gt;【alb,nlb】取值范围为[IpHash, RoundRobin, LeastConn]（取值范围的含义：加权源Ip哈希，加权轮询和加权最小连接），alb和nlb默认为加权轮询 &lt;br&gt;【dnlb】取值范围为[IpHash, QuintupleHash]（取值范围的含义分别为：加权源Ip哈希和加权五元组哈希），dnlb默认为加权源Ip哈希  optional
      * @param {array} [opts.targetGroupIds] - 虚拟服务器组的Id列表，目前只支持一个，且与agIds不能同时存在  optional
      * @param {array} [opts.agIds] - 高可用组的Id列表，目前只支持一个，且与targetGroupIds不能同时存在  optional
      * @param {array} [opts.agInfoSpec] - 高可用组属性设置:1.defatult_weight:默认权重, 优先级 agInfoSpec &gt; agIds  optional
      * @param {boolean} [opts.proxyProtocol] - 【alb Tcp、Udp协议】获取真实ip, 取值为False(不获取)或者True(获取,支持Proxy Protocol v1版本)，默认为False  optional
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {boolean} [opts.sessionStickiness] - 会话保持, 取值为false(不开启)或者true(开启)，默认为false &lt;br&gt;【alb Http协议，RoundRobin算法】支持基于cookie的会话保持 &lt;br&gt;【nlb】支持基于报文源目的IP的会话保持  optional
      * @param {integer} [opts.sessionStickyTimeout] - 【nlb】会话保持超时时间，sessionStickiness开启时生效，默认300s, 取值范围[1-3600]  optional
      * @param {integer} [opts.connectionDrainingSeconds] - 【nlb】连接耗尽超时。移除target前，连接的最大保持时间，默认300s，取值范围[0-3600]  optional
      * @param {integer} [opts.httpCookieExpireSeconds] - 【alb Http协议】cookie的过期时间,sessionStickiness开启时生效，取值范围为[0-86400], 默认为0（表示cookie与浏览器同生命周期）  optional
      * @param {boolean} [opts.httpForwardedProtocol] - 【alb Http协议】获取负载均衡的协议, 取值为False(不获取)或True(获取), 默认为False  optional
      * @param {boolean} [opts.httpForwardedPort] - 【alb Http协议】获取负载均衡的端口, 取值为False(不获取)或True(获取), 默认为False  optional
      * @param {boolean} [opts.httpForwardedHost] - 【alb Http协议】获取负载均衡的host信息, 取值为False(不获取)或True(获取), 默认为False  optional
      * @param {boolean} [opts.httpForwardedVip] - 【alb Http协议】获取负载均衡的vip, 取值为False(不获取)或True(获取), 默认为False  optional
      * @param {boolean} [opts.httpForwardedClientPort] - 【alb Http协议】获取请求端使用的端口, 取值为False(不获取)或True(获取), 默认为False  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string backendId  后端服务id
      */

  createBackend (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBackend"
      )
    }

    opts = opts || {}

    if (opts.backendName === undefined || opts.backendName === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendName' when calling createBackend"
      )
    }
    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling createBackend"
      )
    }
    if (opts.protocol === undefined || opts.protocol === null) {
      throw new Error(
        "Missing the required parameter 'opts.protocol' when calling createBackend"
      )
    }
    if (opts.port === undefined || opts.port === null) {
      throw new Error(
        "Missing the required parameter 'opts.port' when calling createBackend"
      )
    }
    if (opts.healthCheckSpec === undefined || opts.healthCheckSpec === null) {
      throw new Error(
        "Missing the required parameter 'opts.healthCheckSpec' when calling createBackend"
      )
    }

    let postBody = {}
    if (opts.backendName !== undefined && opts.backendName !== null) {
      postBody['backendName'] = opts.backendName
    }
    if (opts.loadBalancerId !== undefined && opts.loadBalancerId !== null) {
      postBody['loadBalancerId'] = opts.loadBalancerId
    }
    if (opts.protocol !== undefined && opts.protocol !== null) {
      postBody['protocol'] = opts.protocol
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.healthCheckSpec !== undefined && opts.healthCheckSpec !== null) {
      postBody['healthCheckSpec'] = opts.healthCheckSpec
    }
    if (opts.algorithm !== undefined && opts.algorithm !== null) {
      postBody['algorithm'] = opts.algorithm
    }
    if (opts.targetGroupIds !== undefined && opts.targetGroupIds !== null) {
      postBody['targetGroupIds'] = opts.targetGroupIds
    }
    if (opts.agIds !== undefined && opts.agIds !== null) {
      postBody['agIds'] = opts.agIds
    }
    if (opts.agInfoSpec !== undefined && opts.agInfoSpec !== null) {
      postBody['agInfoSpec'] = opts.agInfoSpec
    }
    if (opts.proxyProtocol !== undefined && opts.proxyProtocol !== null) {
      postBody['proxyProtocol'] = opts.proxyProtocol
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (
      opts.sessionStickiness !== undefined &&
      opts.sessionStickiness !== null
    ) {
      postBody['sessionStickiness'] = opts.sessionStickiness
    }
    if (
      opts.sessionStickyTimeout !== undefined &&
      opts.sessionStickyTimeout !== null
    ) {
      postBody['sessionStickyTimeout'] = opts.sessionStickyTimeout
    }
    if (
      opts.connectionDrainingSeconds !== undefined &&
      opts.connectionDrainingSeconds !== null
    ) {
      postBody['connectionDrainingSeconds'] = opts.connectionDrainingSeconds
    }
    if (
      opts.httpCookieExpireSeconds !== undefined &&
      opts.httpCookieExpireSeconds !== null
    ) {
      postBody['httpCookieExpireSeconds'] = opts.httpCookieExpireSeconds
    }
    if (
      opts.httpForwardedProtocol !== undefined &&
      opts.httpForwardedProtocol !== null
    ) {
      postBody['httpForwardedProtocol'] = opts.httpForwardedProtocol
    }
    if (
      opts.httpForwardedPort !== undefined &&
      opts.httpForwardedPort !== null
    ) {
      postBody['httpForwardedPort'] = opts.httpForwardedPort
    }
    if (
      opts.httpForwardedHost !== undefined &&
      opts.httpForwardedHost !== null
    ) {
      postBody['httpForwardedHost'] = opts.httpForwardedHost
    }
    if (opts.httpForwardedVip !== undefined && opts.httpForwardedVip !== null) {
      postBody['httpForwardedVip'] = opts.httpForwardedVip
    }
    if (
      opts.httpForwardedClientPort !== undefined &&
      opts.httpForwardedClientPort !== null
    ) {
      postBody['httpForwardedClientPort'] = opts.httpForwardedClientPort
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBackend with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询后端服务详情
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backend backend  后端服务的信息
      */

  describeBackend (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackend"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling describeBackend"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackend with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改一个后端服务的信息
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {string} [opts.backendName] - 后端服务名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {healthCheckSpec} [opts.healthCheckSpec] - 健康检查信息  optional
      * @param {string} [opts.algorithm] - 调度算法 &lt;br&gt;【alb,nlb】取值范围为[IpHash, RoundRobin, LeastConn]（含义分别为：加权源Ip哈希，加权轮询和加权最小连接） &lt;br&gt;【dnlb】取值范围为[IpHash, QuintupleHash]（含义分别为：加权源Ip哈希和加权五元组哈希）  optional
      * @param {array} [opts.targetGroupIds] - 虚拟服务器组的Id列表，目前只支持一个，且与agIds不能同时存在  optional
      * @param {array} [opts.agIds] - 高可用组的Id列表，目前只支持一个，且与targetGroupIds不能同时存在  optional
      * @param {array} [opts.agInfoSpec] - 高可用组属性设置:1.defatult_weight:默认权重, 优先级 agInfoSpec &gt; agIds  optional
      * @param {boolean} [opts.proxyProtocol] - 【alb Tcp、Udp协议】是否启用Proxy ProtocolV1协议获取真实源ip, 取值为false(不开启)或者true(开启), 默认为false  optional
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {boolean} [opts.sessionStickiness] - 会话保持, 取值为false(不开启)或者true(开启)，默认为false &lt;br&gt;【alb Http协议，RoundRobin算法】支持基于cookie的会话保持 &lt;br&gt;【nlb】支持基于报文源目的IP的会话保持  optional
      * @param {integer} [opts.sessionStickyTimeout] - 【nlb】会话保持超时时间，sessionStickiness开启时生效, 取值范围[1-3600]  optional
      * @param {integer} [opts.connectionDrainingSeconds] - 【nlb】连接耗尽超时，移除target前，连接的最大保持时间，默认300s，取值范围[0-3600]  optional
      * @param {integer} [opts.httpCookieExpireSeconds] - 【alb Http协议】cookie的过期时间,sessionStickiness开启时生效，取值范围为[0-86400], 0表示cookie与浏览器同生命周期  optional
      * @param {boolean} [opts.httpForwardedProtocol] - 【alb Http协议】获取负载均衡的协议, 取值为False(不获取)或True(获取)  optional
      * @param {boolean} [opts.httpForwardedPort] - 【alb Http协议】获取负载均衡的端口, 取值为False(不获取)或True(获取)  optional
      * @param {boolean} [opts.httpForwardedHost] - 【alb Http协议】获取负载均衡的host信息, 取值为False(不获取)或True(获取)  optional
      * @param {boolean} [opts.httpForwardedVip] - 【alb Http协议】获取负载均衡的vip, 取值为False(不获取)或True(获取)  optional
      * @param {boolean} [opts.httpForwardedClientPort] - 【alb Http协议】获取请求端使用的端口, 取值为False(不获取)或True(获取)  optional
      * @param {boolean} [opts.closeHealthCheck] - 【alb,dnlb】关闭健康检查，取值为false(不关闭)或true(关闭)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateBackend (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateBackend"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling updateBackend"
      )
    }

    let postBody = {}
    if (opts.backendName !== undefined && opts.backendName !== null) {
      postBody['backendName'] = opts.backendName
    }
    if (opts.healthCheckSpec !== undefined && opts.healthCheckSpec !== null) {
      postBody['healthCheckSpec'] = opts.healthCheckSpec
    }
    if (opts.algorithm !== undefined && opts.algorithm !== null) {
      postBody['algorithm'] = opts.algorithm
    }
    if (opts.targetGroupIds !== undefined && opts.targetGroupIds !== null) {
      postBody['targetGroupIds'] = opts.targetGroupIds
    }
    if (opts.agIds !== undefined && opts.agIds !== null) {
      postBody['agIds'] = opts.agIds
    }
    if (opts.agInfoSpec !== undefined && opts.agInfoSpec !== null) {
      postBody['agInfoSpec'] = opts.agInfoSpec
    }
    if (opts.proxyProtocol !== undefined && opts.proxyProtocol !== null) {
      postBody['proxyProtocol'] = opts.proxyProtocol
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (
      opts.sessionStickiness !== undefined &&
      opts.sessionStickiness !== null
    ) {
      postBody['sessionStickiness'] = opts.sessionStickiness
    }
    if (
      opts.sessionStickyTimeout !== undefined &&
      opts.sessionStickyTimeout !== null
    ) {
      postBody['sessionStickyTimeout'] = opts.sessionStickyTimeout
    }
    if (
      opts.connectionDrainingSeconds !== undefined &&
      opts.connectionDrainingSeconds !== null
    ) {
      postBody['connectionDrainingSeconds'] = opts.connectionDrainingSeconds
    }
    if (
      opts.httpCookieExpireSeconds !== undefined &&
      opts.httpCookieExpireSeconds !== null
    ) {
      postBody['httpCookieExpireSeconds'] = opts.httpCookieExpireSeconds
    }
    if (
      opts.httpForwardedProtocol !== undefined &&
      opts.httpForwardedProtocol !== null
    ) {
      postBody['httpForwardedProtocol'] = opts.httpForwardedProtocol
    }
    if (
      opts.httpForwardedPort !== undefined &&
      opts.httpForwardedPort !== null
    ) {
      postBody['httpForwardedPort'] = opts.httpForwardedPort
    }
    if (
      opts.httpForwardedHost !== undefined &&
      opts.httpForwardedHost !== null
    ) {
      postBody['httpForwardedHost'] = opts.httpForwardedHost
    }
    if (opts.httpForwardedVip !== undefined && opts.httpForwardedVip !== null) {
      postBody['httpForwardedVip'] = opts.httpForwardedVip
    }
    if (
      opts.httpForwardedClientPort !== undefined &&
      opts.httpForwardedClientPort !== null
    ) {
      postBody['httpForwardedClientPort'] = opts.httpForwardedClientPort
    }
    if (opts.closeHealthCheck !== undefined && opts.closeHealthCheck !== null) {
      postBody['closeHealthCheck'] = opts.closeHealthCheck
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateBackend with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除一个后端服务
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteBackend (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteBackend"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling deleteBackend"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteBackend with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询后端服务下的target的健康状态
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {integer} [opts.pageNumber] - 页码, 默认为1,取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认返回全部，取值范围：[10,100]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param targetHealth targetHealths
      * @param integer totalCount  总数量
      */

  describeTargetHealth (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTargetHealth"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling describeTargetHealth"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTargetHealth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}/health',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改后端服务-高可用组(ag)下target信息
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {array} opts.targetUpdateSpecs - 修改ag target信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateAgTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateAgTargets"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling updateAgTargets"
      )
    }
    if (
      opts.targetUpdateSpecs === undefined ||
      opts.targetUpdateSpecs === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.targetUpdateSpecs' when calling updateAgTargets"
      )
    }

    let postBody = {}
    if (
      opts.targetUpdateSpecs !== undefined &&
      opts.targetUpdateSpecs !== null
    ) {
      postBody['targetUpdateSpecs'] = opts.targetUpdateSpecs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateAgTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}:updateAgTargets',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询 后端服务-高可用组 Target列表详情
      * @param {Object} opts - parameters
      * @param {string} opts.backendId - Backend Id
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - weight - 权重, 支持多个
targetIds - Target ID列表，支持多个
instanceId - Instance ID,仅支持单个
ipAddress - ip地址,仅支持单个
  optional
      * @param {sort} [opts.sorts] - createdTime - 默认值,默认按 createdTime 倒序
weight - 权重值
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param agTarget targets
      * @param integer totalCount  总数量
      */

  describeAgTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAgTargets"
      )
    }

    opts = opts || {}

    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling describeAgTargets"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: regionId,
      backendId: opts.backendId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAgTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/backends/{backendId}/agTargets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询个性化配置列表详情
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - customizedConfigurationIds - 个性化配置ID，支持多个
customizedConfigurationNames - 个性化配置名称，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param customizedConfiguration customizedConfigurations
      * @param integer totalCount  总数量
      */

  describeCustomizedConfigurations (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCustomizedConfigurations"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomizedConfigurations with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个个性化配置
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationName - 个性化配置名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {customizedConfigurationContentSpec} [opts.customizedConfigurationContent] - 个性化配置内容  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string customizedConfigurationId  个性化配置Id
      */

  createCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationName === undefined ||
      opts.customizedConfigurationName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationName' when calling createCustomizedConfiguration"
      )
    }

    let postBody = {}
    if (
      opts.customizedConfigurationName !== undefined &&
      opts.customizedConfigurationName !== null
    ) {
      postBody['customizedConfigurationName'] = opts.customizedConfigurationName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (
      opts.customizedConfigurationContent !== undefined &&
      opts.customizedConfigurationContent !== null
    ) {
      postBody['customizedConfigurationContent'] =
        opts.customizedConfigurationContent
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询个性化配置详情
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationId - Customized Configuration Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param customizedConfiguration customizedConfiguration  个性化配置资源信息
      */

  describeCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationId === undefined ||
      opts.customizedConfigurationId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationId' when calling describeCustomizedConfiguration"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      customizedConfigurationId: opts.customizedConfigurationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/{customizedConfigurationId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改一个个性化配置的信息
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationId - Customized Configuration Id
      * @param {string} [opts.customizedConfigurationName] - 个性化配置名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {customizedConfigurationContentSpec} [opts.customizedConfigurationContent] - 个性化配置内容  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationId === undefined ||
      opts.customizedConfigurationId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationId' when calling updateCustomizedConfiguration"
      )
    }

    let postBody = {}
    if (
      opts.customizedConfigurationName !== undefined &&
      opts.customizedConfigurationName !== null
    ) {
      postBody['customizedConfigurationName'] = opts.customizedConfigurationName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (
      opts.customizedConfigurationContent !== undefined &&
      opts.customizedConfigurationContent !== null
    ) {
      postBody['customizedConfigurationContent'] =
        opts.customizedConfigurationContent
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      customizedConfigurationId: opts.customizedConfigurationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/{customizedConfigurationId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除一个个性化配置
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationId - Customized Configuration Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationId === undefined ||
      opts.customizedConfigurationId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationId' when calling deleteCustomizedConfiguration"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      customizedConfigurationId: opts.customizedConfigurationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/{customizedConfigurationId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  给资源绑定个性化配置
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationId - Customized Configuration Id
      * @param {array} opts.resourceIds - 个性化配置要绑定的资源ID列表, 对于已绑定配置的资源需要先解绑
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  associateCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  associateCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationId === undefined ||
      opts.customizedConfigurationId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationId' when calling associateCustomizedConfiguration"
      )
    }
    if (opts.resourceIds === undefined || opts.resourceIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceIds' when calling associateCustomizedConfiguration"
      )
    }

    let postBody = {}
    if (opts.resourceIds !== undefined && opts.resourceIds !== null) {
      postBody['resourceIds'] = opts.resourceIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      customizedConfigurationId: opts.customizedConfigurationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call associateCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/{customizedConfigurationId}:associateCustomizedConfiguration',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  给资源解绑个性化配置
      * @param {Object} opts - parameters
      * @param {string} opts.customizedConfigurationId - Customized Configuration Id
      * @param {array} opts.resourceIds - 个性化配置要解绑的资源ID列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  disassociateCustomizedConfiguration (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  disassociateCustomizedConfiguration"
      )
    }

    opts = opts || {}

    if (
      opts.customizedConfigurationId === undefined ||
      opts.customizedConfigurationId === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.customizedConfigurationId' when calling disassociateCustomizedConfiguration"
      )
    }
    if (opts.resourceIds === undefined || opts.resourceIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceIds' when calling disassociateCustomizedConfiguration"
      )
    }

    let postBody = {}
    if (opts.resourceIds !== undefined && opts.resourceIds !== null) {
      postBody['resourceIds'] = opts.resourceIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      customizedConfigurationId: opts.customizedConfigurationId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disassociateCustomizedConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/customizedConfigurations/{customizedConfigurationId}:disassociateCustomizedConfiguration',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询监听器列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - listenerNames - 监听器名称列表，支持多个
listenerIds - 监听器Id列表，支持多个
loadBalancerId - 负载均衡器Id，支持单个
loadBalancerType - 负载均衡类型，取值为：alb、nlb、dnlb，默认alb，支持单个
urlMapIds - 【仅alb支持】转发规则组Id列表，支持多个
securityPolicyIds - 监听器绑定的安全策略ID，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param listener listeners
      * @param integer totalCount  总数量
      */

  describeListeners (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeListeners"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeListeners with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个监听器
      * @param {Object} opts - parameters
      * @param {string} opts.listenerName - Listener的名字,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} opts.protocol - 监听协议, 取值为Tcp, Tls, Http, Https, Udp &lt;br&gt;【alb】支持Http, Https，Tcp、Tls和Udp &lt;br&gt;【nlb】支持Tcp, Udp  &lt;br&gt;【dnlb】支持Tcp, Udp
      * @param {boolean} [opts.hstsEnable] - 【alb使用https时支持】是否开启HSTS，True(开启)， False(关闭)，缺省为False  optional
      * @param {integer} [opts.hstsMaxAge] - 【alb使用https时支持】HSTS过期时间(秒)，取值范围为[1, 94608000(3年)]，缺省为31536000(1年)  optional
      * @param {integer} opts.port - 监听端口，取值范围为[1, 65535]
      * @param {string} opts.backendId - 默认的后端服务Id
      * @param {string} opts.loadBalancerId - Listener所属loadBalancer的Id
      * @param {string} [opts.urlMapId] - 【alb Https和Http协议】转发规则组Id  optional
      * @param {string} [opts.action] - 默认后端服务的转发策略,取值为Forward或Redirect, 现只支持Forward, 默认为Forward  optional
      * @param {array} [opts.certificateSpecs] - 【alb Https和Tls协议】Listener绑定的默认证书，最多支持两个，两个证书的加密算法需要不同  optional
      * @param {limitationSpec} [opts.limitation] - 【仅ALB支持】限速配置  optional
      * @param {integer} [opts.connectionIdleTimeSeconds] - 【alb、nlb】空闲连接超时时间, 范围为[1,86400]。 &lt;br&gt;（Tcp和Tls协议）默认为：1800s &lt;br&gt;（Udp协议）默认为：300s &lt;br&gt;（Http和Https协议）默认为：60s &lt;br&gt;【dnlb】不支持  optional
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} [opts.securityPolicyId] - 绑定的安全策略id，仅支持应用负载均衡的HTTPS、TLS监听配置，不传默认使用默认安全策略  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string listenerId  监听器id
      */

  createListener (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createListener"
      )
    }

    opts = opts || {}

    if (opts.listenerName === undefined || opts.listenerName === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerName' when calling createListener"
      )
    }
    if (opts.protocol === undefined || opts.protocol === null) {
      throw new Error(
        "Missing the required parameter 'opts.protocol' when calling createListener"
      )
    }
    if (opts.port === undefined || opts.port === null) {
      throw new Error(
        "Missing the required parameter 'opts.port' when calling createListener"
      )
    }
    if (opts.backendId === undefined || opts.backendId === null) {
      throw new Error(
        "Missing the required parameter 'opts.backendId' when calling createListener"
      )
    }
    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling createListener"
      )
    }

    let postBody = {}
    if (opts.listenerName !== undefined && opts.listenerName !== null) {
      postBody['listenerName'] = opts.listenerName
    }
    if (opts.protocol !== undefined && opts.protocol !== null) {
      postBody['protocol'] = opts.protocol
    }
    if (opts.hstsEnable !== undefined && opts.hstsEnable !== null) {
      postBody['hstsEnable'] = opts.hstsEnable
    }
    if (opts.hstsMaxAge !== undefined && opts.hstsMaxAge !== null) {
      postBody['hstsMaxAge'] = opts.hstsMaxAge
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.backendId !== undefined && opts.backendId !== null) {
      postBody['backendId'] = opts.backendId
    }
    if (opts.loadBalancerId !== undefined && opts.loadBalancerId !== null) {
      postBody['loadBalancerId'] = opts.loadBalancerId
    }
    if (opts.urlMapId !== undefined && opts.urlMapId !== null) {
      postBody['urlMapId'] = opts.urlMapId
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (opts.certificateSpecs !== undefined && opts.certificateSpecs !== null) {
      postBody['certificateSpecs'] = opts.certificateSpecs
    }
    if (opts.limitation !== undefined && opts.limitation !== null) {
      postBody['limitation'] = opts.limitation
    }
    if (
      opts.connectionIdleTimeSeconds !== undefined &&
      opts.connectionIdleTimeSeconds !== null
    ) {
      postBody['connectionIdleTimeSeconds'] = opts.connectionIdleTimeSeconds
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.securityPolicyId !== undefined && opts.securityPolicyId !== null) {
      postBody['securityPolicyId'] = opts.securityPolicyId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createListener with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询监听器详情
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param listener listener  监听器的信息
      */

  describeListener (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeListener"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling describeListener"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeListener with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改一个监听器的信息
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {string} [opts.listenerName] - 监听器名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} [opts.status] - Listener状态, 取值为On或者为Off  optional
      * @param {boolean} [opts.hstsEnable] - 【alb使用https时支持】是否开启HSTS，True(开启)， False(关闭)，缺省为不改变原值  optional
      * @param {integer} [opts.hstsMaxAge] - 【alb使用https时支持】HSTS过期时间(秒)，取值范围为[1, 94608000(3年)]，缺省为不改变原值  optional
      * @param {array} [opts.certificateSpecs] - 【alb Https和Tls协议】Listener绑定的默认证书，最多支持两个，两个证书的加密算法需要不同  optional
      * @param {limitationSpec} [opts.limitation] - 【仅ALB支持】限速配置  optional
      * @param {integer} [opts.connectionIdleTimeSeconds] - 【alb、nlb】空闲连接超时时间, 范围为[1,86400]。 &lt;br&gt;（Tcp和Tls协议）默认为：1800s &lt;br&gt;（Http和Https协议）默认为：60s &lt;br&gt;【dnlb】不支持该功能  optional
      * @param {string} [opts.backendId] - 默认后端服务Id  optional
      * @param {string} [opts.urlMapId] - 【alb Https和Http协议】转发规则组Id  optional
      * @param {string} [opts.description] - 监听器描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} [opts.securityPolicyId] - 绑定的安全策略id，仅支持应用负载均衡的HTTPS、TLS监听配置  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateListener (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateListener"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling updateListener"
      )
    }

    let postBody = {}
    if (opts.listenerName !== undefined && opts.listenerName !== null) {
      postBody['listenerName'] = opts.listenerName
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.hstsEnable !== undefined && opts.hstsEnable !== null) {
      postBody['hstsEnable'] = opts.hstsEnable
    }
    if (opts.hstsMaxAge !== undefined && opts.hstsMaxAge !== null) {
      postBody['hstsMaxAge'] = opts.hstsMaxAge
    }
    if (opts.certificateSpecs !== undefined && opts.certificateSpecs !== null) {
      postBody['certificateSpecs'] = opts.certificateSpecs
    }
    if (opts.limitation !== undefined && opts.limitation !== null) {
      postBody['limitation'] = opts.limitation
    }
    if (
      opts.connectionIdleTimeSeconds !== undefined &&
      opts.connectionIdleTimeSeconds !== null
    ) {
      postBody['connectionIdleTimeSeconds'] = opts.connectionIdleTimeSeconds
    }
    if (opts.backendId !== undefined && opts.backendId !== null) {
      postBody['backendId'] = opts.backendId
    }
    if (opts.urlMapId !== undefined && opts.urlMapId !== null) {
      postBody['urlMapId'] = opts.urlMapId
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.securityPolicyId !== undefined && opts.securityPolicyId !== null) {
      postBody['securityPolicyId'] = opts.securityPolicyId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateListener with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除一个监听器
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteListener (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteListener"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling deleteListener"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteListener with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  listener批量添加扩展证书
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {array} [opts.certificates] - 【alb Https和Tls协议】ssl server证书列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addListenerCertificates (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addListenerCertificates"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling addListenerCertificates"
      )
    }

    let postBody = {}
    if (opts.certificates !== undefined && opts.certificates !== null) {
      postBody['certificates'] = opts.certificates
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addListenerCertificates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}:addListenerCertificates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  listener批量修改扩展证书
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {array} [opts.certificates] - 【alb Https和Tls协议】Listener绑定的扩展证书列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateListenerCertificates (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateListenerCertificates"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling updateListenerCertificates"
      )
    }

    let postBody = {}
    if (opts.certificates !== undefined && opts.certificates !== null) {
      postBody['certificates'] = opts.certificates
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateListenerCertificates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}:updateListenerCertificates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  listener批量删除扩展证书
      * @param {Object} opts - parameters
      * @param {string} opts.listenerId - 监听器ID
      * @param {array} [opts.certificateBindIds] - 【alb Https和Tls协议】扩展证书绑定Id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteListenerCertificates (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteListenerCertificates"
      )
    }

    opts = opts || {}

    if (opts.listenerId === undefined || opts.listenerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.listenerId' when calling deleteListenerCertificates"
      )
    }

    let postBody = {}
    if (
      opts.certificateBindIds !== undefined &&
      opts.certificateBindIds !== null
    ) {
      postBody['certificateBindIds'] = opts.certificateBindIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      listenerId: opts.listenerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteListenerCertificates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/listeners/{listenerId}:deleteListenerCertificates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询负载均衡列表详情
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - loadBalancerType - 负载均衡类型，取值为：alb、nlb、dnlb，默认alb，支持单个
loadBalancerIds - 负载均衡ID列表，支持多个
loadBalancerNames - 负载均衡名称列表，支持多个; 支持operator为like的模糊搜索，此时name只能传单个
vpcId - 负载均衡所在Vpc的Id，支持单个
azType - 负载均衡az类型，取值：all(全部类型)，standard(标准负载均衡)，edge(边缘负载均衡)，默认all，支持单个
azs - 可用区，仅支持边缘可用区，支持多个
privateIpAddresses - 负载均衡的vip地址，支持多个
ipv6Addresses - 负载均衡的ipv6地址，支持多个
serviceCodes -  产品唯一掩码，支持多个
serviceIds   - 产品唯一ID，支持多个
elasticIpAddress - 负载均衡的弹性公网ip地址，支持单个
targetPrivateIpAddress - 后端target的内网IP地址，支持单个
customizedConfigurationIds - 负载均衡绑定的个性化配置ID，支持多个
  optional
      * @param {tagFilter} [opts.tags] - Tag筛选条件  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param loadBalancer loadBalancers
      * @param integer totalCount  总数量
      */

  describeLoadBalancers (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeLoadBalancers"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildTagFilterParam(opts.tags, 'tags'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLoadBalancers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建负载均衡
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerName - LoadBalancer的名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} opts.subnetId - LoadBalancer所属子网的Id
      * @param {string} [opts.type] - LoadBalancer的类型，取值：alb、nlb、dnlb，默认为alb  optional
      * @param {array} [opts.azs] - 【alb，nlb】LoadBalancer所属availability Zone列表,对于alb,nlb是必选参数，可用区个数不能超过2个 &lt;br&gt;【dnlb】中心可用区，dnlb不需要传该参数，全可用区可用；边缘可用区，仅支持传入单可用区  optional
      * @param {chargeSpec} [opts.chargeSpec] - 【alb】支持按用量计费，默认为按用量。【nlb】支持按用量计费。【dnlb】支持按配置计费  optional
      * @param {elasticIpSpec} [opts.elasticIp] - 负载均衡关联的弹性IP规格  optional
      * @param {string} [opts.privateIpAddress] - 指定LoadBalancer的VIP(内网IPv4地址)，需要属于指定的子网并且未被占用  optional
      * @param {array} [opts.securityGroupIds] - 【alb】 安全组 ID列表  optional
      * @param {string} [opts.description] - LoadBalancer的描述信息,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {boolean} [opts.deleteProtection] - 删除保护，取值为True(开启)或False(关闭)，默认为False  optional
      * @param {array} [opts.userTags] - 用户tag 信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string loadBalancerId  负载均衡id
      */

  createLoadBalancer (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createLoadBalancer"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerName === undefined || opts.loadBalancerName === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerName' when calling createLoadBalancer"
      )
    }
    if (opts.subnetId === undefined || opts.subnetId === null) {
      throw new Error(
        "Missing the required parameter 'opts.subnetId' when calling createLoadBalancer"
      )
    }

    let postBody = {}
    if (opts.loadBalancerName !== undefined && opts.loadBalancerName !== null) {
      postBody['loadBalancerName'] = opts.loadBalancerName
    }
    if (opts.subnetId !== undefined && opts.subnetId !== null) {
      postBody['subnetId'] = opts.subnetId
    }
    if (opts.type !== undefined && opts.type !== null) {
      postBody['type'] = opts.type
    }
    if (opts.azs !== undefined && opts.azs !== null) {
      postBody['azs'] = opts.azs
    }
    if (opts.chargeSpec !== undefined && opts.chargeSpec !== null) {
      postBody['chargeSpec'] = opts.chargeSpec
    }
    if (opts.elasticIp !== undefined && opts.elasticIp !== null) {
      postBody['elasticIp'] = opts.elasticIp
    }
    if (opts.privateIpAddress !== undefined && opts.privateIpAddress !== null) {
      postBody['privateIpAddress'] = opts.privateIpAddress
    }
    if (opts.securityGroupIds !== undefined && opts.securityGroupIds !== null) {
      postBody['securityGroupIds'] = opts.securityGroupIds
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.deleteProtection !== undefined && opts.deleteProtection !== null) {
      postBody['deleteProtection'] = opts.deleteProtection
    }
    if (opts.userTags !== undefined && opts.userTags !== null) {
      postBody['userTags'] = opts.userTags
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLoadBalancer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询负载均衡详情
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param loadBalancer loadBalancer  负载均衡的信息
      */

  describeLoadBalancer (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeLoadBalancer"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling describeLoadBalancer"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLoadBalancer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新负载均衡信息
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {string} [opts.loadBalancerName] - LoadBalancer的名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} [opts.action] - 启用或停止LoadBalancer，取值为Start(启用)或Stop(停止)  optional
      * @param {string} [opts.description] - LoadBalancer的描述信息,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {boolean} [opts.domainEnable] - 是否绑定域名，包括外网和内网，缺省为不改变原值  optional
      * @param {boolean} [opts.deleteProtection] - 删除保护，取值为True(开启)或False(关闭)，默认为False  optional
      * @param {string} [opts.privateIpAddress] - 变更loadBalancer的vip地址，新地址只允许是loadBalancer本子网中的空闲ip地址，缺省为不改变原值  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateLoadBalancer (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateLoadBalancer"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling updateLoadBalancer"
      )
    }

    let postBody = {}
    if (opts.loadBalancerName !== undefined && opts.loadBalancerName !== null) {
      postBody['loadBalancerName'] = opts.loadBalancerName
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.domainEnable !== undefined && opts.domainEnable !== null) {
      postBody['domainEnable'] = opts.domainEnable
    }
    if (opts.deleteProtection !== undefined && opts.deleteProtection !== null) {
      postBody['deleteProtection'] = opts.deleteProtection
    }
    if (opts.privateIpAddress !== undefined && opts.privateIpAddress !== null) {
      postBody['privateIpAddress'] = opts.privateIpAddress
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateLoadBalancer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除负载均衡，负载均衡下的监听器，转发规则组(仅alb支持)，后端服务，服务器组会一起删除
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {boolean} [opts.deleteElasticIp] - 是否打包删除弹性公网IP，取值范围：true、false，默认false。true表示删除负载均衡时打包删除其绑定的弹性公网IP；false表示删除负载均衡时不删除其绑定的弹性公网IP。包年包月和无计费信息的弹性公网IP不支持打包删除  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLoadBalancer (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteLoadBalancer"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling deleteLoadBalancer"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.deleteElasticIp !== undefined && opts.deleteElasticIp !== null) {
      queryParams['deleteElasticIp'] = opts.deleteElasticIp
    }

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLoadBalancer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询安全组绑定负载均衡列表
      * @param {Object} opts - parameters
      * @param {string} opts.securityGroupId - securityGroup ID
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer totalCount  总数量
      * @param loadBalancer loadBalancers
      */

  describeLoadBalancersBySecurityGroup (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeLoadBalancersBySecurityGroup"
      )
    }

    opts = opts || {}

    if (opts.securityGroupId === undefined || opts.securityGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.securityGroupId' when calling describeLoadBalancersBySecurityGroup"
      )
    }

    let postBody = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      securityGroupId: opts.securityGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLoadBalancersBySecurityGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{securityGroupId}:describeLoadBalancersBySecurityGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  负载均衡绑定弹性公网IP
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {string} opts.elasticIpId - 弹性公网IP ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  associateElasticIp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  associateElasticIp"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling associateElasticIp"
      )
    }
    if (opts.elasticIpId === undefined || opts.elasticIpId === null) {
      throw new Error(
        "Missing the required parameter 'opts.elasticIpId' when calling associateElasticIp"
      )
    }

    let postBody = {}
    if (opts.elasticIpId !== undefined && opts.elasticIpId !== null) {
      postBody['elasticIpId'] = opts.elasticIpId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call associateElasticIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}:associateElasticIp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  负载均衡解绑弹性公网IP
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {string} opts.elasticIpId - 弹性公网IP ID
      * @param {boolean} [opts.deleteElasticIp] - 解绑时是否同时删除弹性公网IP，取值范围：true、false，默认false。true表示解绑弹性公网IP时删除该弹性公网IP；false表示解绑弹性公网IP时不删除该弹性公网IP。包年包月和无计费信息的弹性公网IP不支持解绑时删除  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  disassociateElasticIp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  disassociateElasticIp"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling disassociateElasticIp"
      )
    }
    if (opts.elasticIpId === undefined || opts.elasticIpId === null) {
      throw new Error(
        "Missing the required parameter 'opts.elasticIpId' when calling disassociateElasticIp"
      )
    }

    let postBody = {}
    if (opts.elasticIpId !== undefined && opts.elasticIpId !== null) {
      postBody['elasticIpId'] = opts.elasticIpId
    }
    if (opts.deleteElasticIp !== undefined && opts.deleteElasticIp !== null) {
      postBody['deleteElasticIp'] = opts.deleteElasticIp
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disassociateElasticIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}:disassociateElasticIp',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  负载均衡绑定安全组
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {array} [opts.securityGroupIds] - 安全组 ID列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  associateSecurityGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  associateSecurityGroup"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling associateSecurityGroup"
      )
    }

    let postBody = {}
    if (opts.securityGroupIds !== undefined && opts.securityGroupIds !== null) {
      postBody['securityGroupIds'] = opts.securityGroupIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call associateSecurityGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}:associateSecurityGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  负载均衡解绑安全组
      * @param {Object} opts - parameters
      * @param {string} opts.loadBalancerId - LB ID
      * @param {array} [opts.securityGroupIds] - 安全组 ID列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  disassociateSecurityGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  disassociateSecurityGroup"
      )
    }

    opts = opts || {}

    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling disassociateSecurityGroup"
      )
    }

    let postBody = {}
    if (opts.securityGroupIds !== undefined && opts.securityGroupIds !== null) {
      postBody['securityGroupIds'] = opts.securityGroupIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      loadBalancerId: opts.loadBalancerId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disassociateSecurityGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/loadBalancers/{loadBalancerId}:disassociateSecurityGroup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询安全策略列表详情
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - securityPolicyIds - 安全策略ID，支持多个
securityPolicyNames - 安全策略名称，支持多个; 支持operator为like的模糊搜索，此时name只能传单个
securityPolicyType - 安全策略类型(SYSTEM/CUSTOM/ALL)，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param securityPolicy securityPolicies
      * @param integer totalCount  总数量
      */

  describeSecurityPolicies (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSecurityPolicies"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSecurityPolicies with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/securityPolicies/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个安全策略
      * @param {Object} opts - parameters
      * @param {string} opts.securityPolicyName - 安全策略名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} [opts.description] - 安全策略描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {array} [opts.protocols] - TLS协议版本列表，目前支持TLSv1、TLSv1.1、TLSv1.2和TLSv1.3，传入的每个protocol至少需要传入一个支持的cipher  optional
      * @param {array} [opts.ciphers] - TLS加密套件列表，传入的每个cipher至少需要传入一个能够支持的protocol
TLSv1和TLSv1.1支持的加密套件：
AES128-SHA
AES256-SHA
CAMELLIA128-SHA
CAMELLIA256-SHA
DES-CBC3-SHA
ECDHE-RSA-AES128-SHA
ECDHE-RSA-AES256-SHA
ECDHE-RSA-DES-CBC3-SHA
IDEA-CBC-SHA
SEED-SHA
ECDHE-ECDSA-AES256-SHA
ECDHE-ECDSA-AES128-SHA
ECDHE-ECDSA-DES-CBC3-SHA
TLSv1.2支持的加密套件：
AES128-CCM
AES128-CCM8
AES128-GCM-SHA256
AES128-SHA
AES128-SHA256
AES256-CCM
AES256-CCM8
AES256-GCM-SHA384
AES256-SHA
AES256-SHA256
ARIA128-GCM-SHA256
ARIA256-GCM-SHA384
CAMELLIA128-SHA
CAMELLIA128-SHA256
CAMELLIA256-SHA
CAMELLIA256-SHA256
DES-CBC3-SHA
ECDHE-ARIA128-GCM-SHA256
ECDHE-ARIA256-GCM-SHA384
ECDHE-RSA-AES128-GCM-SHA256
ECDHE-RSA-AES128-SHA
ECDHE-RSA-AES128-SHA256
ECDHE-RSA-AES256-GCM-SHA384
ECDHE-RSA-AES256-SHA
ECDHE-RSA-AES256-SHA384
ECDHE-RSA-CAMELLIA128-SHA256
ECDHE-RSA-CAMELLIA256-SHA384
ECDHE-RSA-CHACHA20-POLY1305
ECDHE-RSA-DES-CBC3-SHA
SEED-SHA
ECDHE-ECDSA-AES256-GCM-SHA384
ECDHE-ECDSA-CHACHA20-POLY1305
ECDHE-ECDSA-AES256-CCM8
ECDHE-ECDSA-AES256-CCM
ECDHE-ECDSA-ARIA256-GCM-SHA384
ECDHE-ECDSA-AES128-GCM-SHA256
ECDHE-ECDSA-AES128-CCM8
ECDHE-ECDSA-AES128-CCM
ECDHE-ECDSA-ARIA128-GCM-SHA256
ECDHE-ECDSA-AES256-SHA384
ECDHE-ECDSA-CAMELLIA256-SHA384
ECDHE-ECDSA-AES128-SHA256
ECDHE-ECDSA-CAMELLIA128-SHA256
ECDHE-ECDSA-AES256-SHA
ECDHE-ECDSA-AES128-SHA
ECDHE-ECDSA-DES-CBC3-SHA
TLSv1.3支持的加密套件：
TLS_AES_256_GCM_SHA384
TLS_CHACHA20_POLY1305_SHA256
TLS_AES_128_GCM_SHA256  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string securityPolicyId  安全策略Id
      */

  createSecurityPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createSecurityPolicy"
      )
    }

    opts = opts || {}

    if (
      opts.securityPolicyName === undefined ||
      opts.securityPolicyName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.securityPolicyName' when calling createSecurityPolicy"
      )
    }

    let postBody = {}
    if (
      opts.securityPolicyName !== undefined &&
      opts.securityPolicyName !== null
    ) {
      postBody['securityPolicyName'] = opts.securityPolicyName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.protocols !== undefined && opts.protocols !== null) {
      postBody['protocols'] = opts.protocols
    }
    if (opts.ciphers !== undefined && opts.ciphers !== null) {
      postBody['ciphers'] = opts.ciphers
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSecurityPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/securityPolicies/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询安全策略详情
      * @param {Object} opts - parameters
      * @param {string} opts.securityPolicyId - Security Policy Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param securityPolicy securityPolicy  安全策略资源信息
      */

  describeSecurityPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSecurityPolicy"
      )
    }

    opts = opts || {}

    if (opts.securityPolicyId === undefined || opts.securityPolicyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.securityPolicyId' when calling describeSecurityPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      securityPolicyId: opts.securityPolicyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSecurityPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/securityPolicies/{securityPolicyId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改一个安全策略的信息
      * @param {Object} opts - parameters
      * @param {string} opts.securityPolicyId - Security Policy Id
      * @param {string} [opts.securityPolicyName] - 安全策略名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} [opts.description] - 安全策略描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {array} [opts.protocols] - TLS协议版本列表，目前支持TLSv1、TLSv1.1、TLSv1.2和TLSv1.3，传入的每个protocol至少需要传入一个支持的cipher  optional
      * @param {array} [opts.ciphers] - TLS加密套件列表，传入的每个cipher至少需要传入一个能够支持的protocol
TLSv1和TLSv1.1支持的加密套件：
AES128-SHA
AES256-SHA
CAMELLIA128-SHA
CAMELLIA256-SHA
DES-CBC3-SHA
ECDHE-RSA-AES128-SHA
ECDHE-RSA-AES256-SHA
ECDHE-RSA-DES-CBC3-SHA
IDEA-CBC-SHA
SEED-SHA
ECDHE-ECDSA-AES256-SHA
ECDHE-ECDSA-AES128-SHA
ECDHE-ECDSA-DES-CBC3-SHA
TLSv1.2支持的加密套件：
AES128-CCM
AES128-CCM8
AES128-GCM-SHA256
AES128-SHA
AES128-SHA256
AES256-CCM
AES256-CCM8
AES256-GCM-SHA384
AES256-SHA
AES256-SHA256
ARIA128-GCM-SHA256
ARIA256-GCM-SHA384
CAMELLIA128-SHA
CAMELLIA128-SHA256
CAMELLIA256-SHA
CAMELLIA256-SHA256
DES-CBC3-SHA
ECDHE-ARIA128-GCM-SHA256
ECDHE-ARIA256-GCM-SHA384
ECDHE-RSA-AES128-GCM-SHA256
ECDHE-RSA-AES128-SHA
ECDHE-RSA-AES128-SHA256
ECDHE-RSA-AES256-GCM-SHA384
ECDHE-RSA-AES256-SHA
ECDHE-RSA-AES256-SHA384
ECDHE-RSA-CAMELLIA128-SHA256
ECDHE-RSA-CAMELLIA256-SHA384
ECDHE-RSA-CHACHA20-POLY1305
ECDHE-RSA-DES-CBC3-SHA
SEED-SHA
ECDHE-ECDSA-AES256-GCM-SHA384
ECDHE-ECDSA-CHACHA20-POLY1305
ECDHE-ECDSA-AES256-CCM8
ECDHE-ECDSA-AES256-CCM
ECDHE-ECDSA-ARIA256-GCM-SHA384
ECDHE-ECDSA-AES128-GCM-SHA256
ECDHE-ECDSA-AES128-CCM8
ECDHE-ECDSA-AES128-CCM
ECDHE-ECDSA-ARIA128-GCM-SHA256
ECDHE-ECDSA-AES256-SHA384
ECDHE-ECDSA-CAMELLIA256-SHA384
ECDHE-ECDSA-AES128-SHA256
ECDHE-ECDSA-CAMELLIA128-SHA256
ECDHE-ECDSA-AES256-SHA
ECDHE-ECDSA-AES128-SHA
ECDHE-ECDSA-DES-CBC3-SHA
TLSv1.3支持的加密套件：
TLS_AES_256_GCM_SHA384
TLS_CHACHA20_POLY1305_SHA256
TLS_AES_128_GCM_SHA256  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateSecurityPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateSecurityPolicy"
      )
    }

    opts = opts || {}

    if (opts.securityPolicyId === undefined || opts.securityPolicyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.securityPolicyId' when calling updateSecurityPolicy"
      )
    }

    let postBody = {}
    if (
      opts.securityPolicyName !== undefined &&
      opts.securityPolicyName !== null
    ) {
      postBody['securityPolicyName'] = opts.securityPolicyName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.protocols !== undefined && opts.protocols !== null) {
      postBody['protocols'] = opts.protocols
    }
    if (opts.ciphers !== undefined && opts.ciphers !== null) {
      postBody['ciphers'] = opts.ciphers
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      securityPolicyId: opts.securityPolicyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateSecurityPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/securityPolicies/{securityPolicyId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除一个安全策略
      * @param {Object} opts - parameters
      * @param {string} opts.securityPolicyId - Security Policy Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSecurityPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteSecurityPolicy"
      )
    }

    opts = opts || {}

    if (opts.securityPolicyId === undefined || opts.securityPolicyId === null) {
      throw new Error(
        "Missing the required parameter 'opts.securityPolicyId' when calling deleteSecurityPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      securityPolicyId: opts.securityPolicyId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSecurityPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/securityPolicies/{securityPolicyId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询安全策略支持Cipher列表详情
      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - protocols - 安全策略支持的协议，支持多个
ciphers - 安全策略支持的加密套件，支持多个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param supportedCipher supportedCiphers
      * @param integer totalCount  总数量
      */

  describeSupportedCiphers (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSupportedCiphers"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSupportedCiphers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/supportedCiphers/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询虚拟服务器组列表详情，返回target详情功能3个月后将会下线，建议用户直接使用describeTargets接口查询target详情
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - targetGroupIds - TargetGroup ID列表，支持多个
targetGroupNames - TargetGroup名称列表，支持多个
loadBalancerId － TargetGroup所属负载均衡的Id，支持单个
loadBalancerType - 负载均衡类型，取值为：alb、nlb、dnlb，默认alb，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param targetGroup targetGroups
      * @param integer totalCount  总数量
      */

  describeTargetGroups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTargetGroups"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTargetGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个虚拟服务器组
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupName - 虚拟服务器组名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} opts.loadBalancerId - 负载均衡的Id
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} [opts.type] - 类型，取值为instance或ip  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string targetGroupId  虚拟服务器组Id
      */

  createTargetGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createTargetGroup"
      )
    }

    opts = opts || {}

    if (opts.targetGroupName === undefined || opts.targetGroupName === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupName' when calling createTargetGroup"
      )
    }
    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling createTargetGroup"
      )
    }

    let postBody = {}
    if (opts.targetGroupName !== undefined && opts.targetGroupName !== null) {
      postBody['targetGroupName'] = opts.targetGroupName
    }
    if (opts.loadBalancerId !== undefined && opts.loadBalancerId !== null) {
      postBody['loadBalancerId'] = opts.loadBalancerId
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.type !== undefined && opts.type !== null) {
      postBody['type'] = opts.type
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTargetGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询TargetGroup详情，返回target详情功能3个月后将会下线，建议用户直接使用describeTargets接口查询target详情
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param targetGroup targetGroup  TargetGroup资源信息
      */

  describeTargetGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTargetGroup"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling describeTargetGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTargetGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改一个虚拟服务器组的信息
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {string} [opts.description] - 虚拟服务器组描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} [opts.targetGroupName] - 虚拟服务器组名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateTargetGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateTargetGroup"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling updateTargetGroup"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.targetGroupName !== undefined && opts.targetGroupName !== null) {
      postBody['targetGroupName'] = opts.targetGroupName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateTargetGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除一个虚拟服务器组
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteTargetGroup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteTargetGroup"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling deleteTargetGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTargetGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  往TargetGroup中加入Target
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {array} opts.targetSpecs - 注册Target列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  registerTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  registerTargets"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling registerTargets"
      )
    }
    if (opts.targetSpecs === undefined || opts.targetSpecs === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetSpecs' when calling registerTargets"
      )
    }

    let postBody = {}
    if (opts.targetSpecs !== undefined && opts.targetSpecs !== null) {
      postBody['targetSpecs'] = opts.targetSpecs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call registerTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}:registerTargets',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  从TargetGroup中移除一个或多个Target，失败则全部回滚。 成功移除的target将不会再接收来自loadbalancer新建连接的流量
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {array} opts.targetIds - Target Id列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deRegisterTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deRegisterTargets"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling deRegisterTargets"
      )
    }
    if (opts.targetIds === undefined || opts.targetIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetIds' when calling deRegisterTargets"
      )
    }

    let postBody = {}
    if (opts.targetIds !== undefined && opts.targetIds !== null) {
      postBody['targetIds'] = opts.targetIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deRegisterTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}:deregisterTargets',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改target信息
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {array} opts.targetUpdateSpecs - 修改target信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateTargets"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling updateTargets"
      )
    }
    if (
      opts.targetUpdateSpecs === undefined ||
      opts.targetUpdateSpecs === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.targetUpdateSpecs' when calling updateTargets"
      )
    }

    let postBody = {}
    if (
      opts.targetUpdateSpecs !== undefined &&
      opts.targetUpdateSpecs !== null
    ) {
      postBody['targetUpdateSpecs'] = opts.targetUpdateSpecs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}:updateTargets',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Target列表详情
      * @param {Object} opts - parameters
      * @param {string} opts.targetGroupId - TargetGroup Id
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - targetIds - Target ID列表，支持多个
instanceId - Instance ID,仅支持单个
type － vm, container, ip,仅支持单个
port - 端口,仅支持单个
ipAddress - ip地址,仅支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param target targets
      * @param integer totalCount  总数量
      */

  describeTargets (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTargets"
      )
    }

    opts = opts || {}

    if (opts.targetGroupId === undefined || opts.targetGroupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.targetGroupId' when calling describeTargets"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId,
      targetGroupId: opts.targetGroupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTargets with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/targetGroups/{targetGroupId}:describeTargets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转发规则组列表详情
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页  optional
      * @param {integer} [opts.pageSize] - 分页大小，默认为20，取值范围：[10,100]  optional
      * @param {filter} [opts.filters] - urlMapIds - 转发规则组Id列表，支持多个
urlMapNames -转发规则组名称列表，支持多个
loadBalancerId - 负载均衡器Id，支持单个
  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param urlMap urlMaps
      * @param integer totalCount  总数量
      */

  describeUrlMaps (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUrlMaps"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUrlMaps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建转发规则组,仅alb支持
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapName - 转发规则组名称，同一个负载均衡下，名称不能重复,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
      * @param {string} opts.loadBalancerId - 转发规则组所属负载均衡的Id
      * @param {string} [opts.description] - 描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string urlMapId  转发规则组id
      */

  createUrlMap (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createUrlMap"
      )
    }

    opts = opts || {}

    if (opts.urlMapName === undefined || opts.urlMapName === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapName' when calling createUrlMap"
      )
    }
    if (opts.loadBalancerId === undefined || opts.loadBalancerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.loadBalancerId' when calling createUrlMap"
      )
    }

    let postBody = {}
    if (opts.urlMapName !== undefined && opts.urlMapName !== null) {
      postBody['urlMapName'] = opts.urlMapName
    }
    if (opts.loadBalancerId !== undefined && opts.loadBalancerId !== null) {
      postBody['loadBalancerId'] = opts.loadBalancerId
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUrlMap with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转发规则组详情
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param urlMap urlMap  转发规则组的信息
      */

  describeUrlMap (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUrlMap"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling describeUrlMap"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUrlMap with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改转发规则组
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {string} [opts.description] - 转发规则组描述,允许输入UTF-8编码下的全部字符，不超过256字符  optional
      * @param {string} [opts.urlMapName] - 转发规则组名称，同一个负载均衡下，名称不能重复,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateUrlMap (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateUrlMap"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling updateUrlMap"
      )
    }

    let postBody = {}
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.urlMapName !== undefined && opts.urlMapName !== null) {
      postBody['urlMapName'] = opts.urlMapName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateUrlMap with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转发规则组
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteUrlMap (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteUrlMap"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling deleteUrlMap"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteUrlMap with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  往转发规则组加入转发规则
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {array} [opts.ruleSpecs] - 转发规则的信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addRules"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling addRules"
      )
    }

    let postBody = {}
    if (opts.ruleSpecs !== undefined && opts.ruleSpecs !== null) {
      postBody['ruleSpecs'] = opts.ruleSpecs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}:addRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改转发规则
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {array} [opts.ruleUpdateSpecs] - 更新转发规则rules信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateRules"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling updateRules"
      )
    }

    let postBody = {}
    if (opts.ruleUpdateSpecs !== undefined && opts.ruleUpdateSpecs !== null) {
      postBody['ruleUpdateSpecs'] = opts.ruleUpdateSpecs
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}:updateRules',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转发规则
      * @param {Object} opts - parameters
      * @param {string} opts.urlMapId - 转发规则组Id
      * @param {array} [opts.ruleIds] - rule Id列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteRules"
      )
    }

    opts = opts || {}

    if (opts.urlMapId === undefined || opts.urlMapId === null) {
      throw new Error(
        "Missing the required parameter 'opts.urlMapId' when calling deleteRules"
      )
    }

    let postBody = {}
    if (opts.ruleIds !== undefined && opts.ruleIds !== null) {
      postBody['ruleIds'] = opts.ruleIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      urlMapId: opts.urlMapId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  lb/0.6.6'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/urlMaps/{urlMapId}:deleteRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = LB
