/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Live-Video
 * 直播管理API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'live'
Service._services[serviceId] = true

/**
 * live service.
 * @version 1.0.22
 */

class LIVE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'live.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询域名下的APP列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围: [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围: [10, 100]
  optional
      * @param {filter} [opts.filters] - 域名下的app列表过滤条件:
  - name: publishDomain 直播的推流域名
  - values: 如果参数为空,则查询全部
  - 过滤条件为空,则表示查询用户下的所有应用名
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param app apps
      */

  describeLiveApp (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/apps',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加直播应用名
- 需要提前在应用(app)级别绑定功能模板时才需要提前新建应用名
- 新的应用名可以推流时自动创建

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 直播的推流域名
      * @param {string} opts.appName - 应用名称
- 取值: 数字字母中划线(&quot;-&quot;)下划线(&quot;_&quot;) 50个字符以内

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveApp (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveApp"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveApp"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/apps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停用 运行中 状态的应用
- 停用应用之后,不能再用此应用名推流

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 直播的推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} callback - callback
      @return {Object} result
      */

  stopLiveApp (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling stopLiveApp"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling stopLiveApp"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopLiveApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/apps:stop',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询(直播or时移)播放鉴权KEY
      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - (直播or时移)播放域名
- 仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param string playDomain  播放域名
      * @param string authStatus  (直播or时移)播放鉴权状态
  on: 开启
  off: 关闭

      * @param string authKey  (直播or时移)播放鉴权key
      */

  describeLivePlayAuthKey (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling describeLivePlayAuthKey"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      queryParams['playDomain'] = opts.playDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLivePlayAuthKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/livePlayAuthKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置(直播or时移)播放鉴权KEY
      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - (直播or时移)播放域名
      * @param {string} [opts.authStatus] - (直播or时移)播放鉴权状态
  on: 开启
  off: 关闭
- 当播放鉴权状态on(开启)时,authKey不能为空
  optional
      * @param {string} [opts.authKey] - (直播or时移)播放鉴权key
- 取值: 支持大小写字母和数字 长度6-32位
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLivePlayAuthKey (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling setLivePlayAuthKey"
      )
    }

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }
    if (opts.authStatus !== undefined && opts.authStatus !== null) {
      postBody['authStatus'] = opts.authStatus
    }
    if (opts.authKey !== undefined && opts.authKey !== null) {
      postBody['authKey'] = opts.authKey
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLivePlayAuthKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/livePlayAuthKey',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播回看播放鉴权KEY
      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 直播回看播放域名
- 仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param string playDomain  回看播放域名
      * @param string authStatus  回看播放鉴权状态
  on: 开启
  off: 关闭

      * @param string authKey  回看播放鉴权key
      */

  describeLiveRestartAuthKey (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling describeLiveRestartAuthKey"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      queryParams['restartDomain'] = opts.restartDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveRestartAuthKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestartAuthKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播回看播放鉴权KEY
      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 直播回看播放域名
      * @param {string} [opts.authStatus] - 直播回看播放鉴权状态
  on: 开启
  off: 关闭
- 当回看播放鉴权状态on(开启)时,authKey不能为空
  optional
      * @param {string} [opts.authKey] - 直播回看播放鉴权key
- 取值: 支持大小写字母和数字 长度6-32位
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveRestartAuthKey (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling setLiveRestartAuthKey"
      )
    }

    let postBody = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      postBody['restartDomain'] = opts.restartDomain
    }
    if (opts.authStatus !== undefined && opts.authStatus !== null) {
      postBody['authStatus'] = opts.authStatus
    }
    if (opts.authKey !== undefined && opts.authKey !== null) {
      postBody['authKey'] = opts.authKey
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveRestartAuthKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestartAuthKey',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播计费账单用量数据
允许通过条件过滤查询，支持的过滤字段如下：
  - startTime[eq]  账单开始时间
  - endTime[eq]    账单结束时间
  - billType[eq]   账单计费类型
  - userPin[like]  用户PIN

      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - 传参字段描述:
  startTime(必填) : 2019-08-21T16:15:10Z
  endTime(必填)   : 2019-08-21T18:10:10Z
  billType(非必填)  :
    enum:
      - 1   (online)
      - 2   (offline)
  userPin(非必填)   : mt_test
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param billDataResultObject resultObject
      */

  describeLiveBillData (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveBillData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveBillDatas',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播播放证书
      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - (直播or时移)播放域名
- 仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param string playDomain  播放域名
      * @param string certStatus  (直播or时移)播放证书状态
  on: 开启
  off: 关闭

      * @param string cert  (直播or时移)播放证书
      * @param string title  (直播or时移)播放证书别名
      */

  describeLiveDomainCertificate (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling describeLiveDomainCertificate"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      queryParams['playDomain'] = opts.playDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveDomainCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomainCertificate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置(直播or时移)播放证书
-- 设置成功之后30分钟以内生效

      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - (直播or时移)播放域名
      * @param {string} opts.certStatus - (直播or时移)播放证书状态
  on: 开启
  off: 关闭
- 当播放证书状态on(开启)时,cert和key不能为空

      * @param {string} [opts.cert] - (直播or时移)播放证书
- 取值: 最大支持4098
- 当播放证书状态on(开启)时,cert不能为空
  optional
      * @param {string} [opts.key] - (直播or时移)播放证书key
- 取值: 最大支持2048
- 当播放证书状态on(开启)时,key不能为空
  optional
      * @param {string} [opts.title] - (直播or时移)播放证书别名
- 取值: 支持大小写字母和数字 长度最大256
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveDomainCertificate (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling setLiveDomainCertificate"
      )
    }
    if (opts.certStatus === undefined || opts.certStatus === null) {
      throw new Error(
        "Missing the required parameter 'opts.certStatus' when calling setLiveDomainCertificate"
      )
    }

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }
    if (opts.certStatus !== undefined && opts.certStatus !== null) {
      postBody['certStatus'] = opts.certStatus
    }
    if (opts.cert !== undefined && opts.cert !== null) {
      postBody['cert'] = opts.cert
    }
    if (opts.key !== undefined && opts.key !== null) {
      postBody['key'] = opts.key
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveDomainCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveDomainCertificate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播回看播放证书
      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 直播回看域名
- 仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param string restartDomain  直播回看域名
      * @param string certStatus  直播回看播放证书状态
  on: 开启
  off: 关闭

      * @param string cert  直播回看证书
      * @param string title  直播回看证书别名
      */

  describeLiveRestartDomainCertificate (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling describeLiveRestartDomainCertificate"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      queryParams['restartDomain'] = opts.restartDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveRestartDomainCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestartDomainCertificate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播回看证书
-- 设置成功之后30分钟以内生效

      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 直播回看域名
      * @param {string} opts.certStatus - 直播回看证书状态
  on: 开启
  off: 关闭
- 当播放证书状态on(开启)时,cert和key不能为空

      * @param {string} [opts.cert] - 直播回看证书
- 取值: 最大支持4098
- 当播放证书状态on(开启)时,cert不能为空
  optional
      * @param {string} [opts.key] - 直播回看证书key
- 取值: 最大支持2048
- 当播放证书状态on(开启)时,key不能为空
  optional
      * @param {string} [opts.title] - 直播回看证书别名
- 取值: 支持大小写字母和数字 长度最大256
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveRestartDomainCertificate (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling setLiveRestartDomainCertificate"
      )
    }
    if (opts.certStatus === undefined || opts.certStatus === null) {
      throw new Error(
        "Missing the required parameter 'opts.certStatus' when calling setLiveRestartDomainCertificate"
      )
    }

    let postBody = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      postBody['restartDomain'] = opts.restartDomain
    }
    if (opts.certStatus !== undefined && opts.certStatus !== null) {
      postBody['certStatus'] = opts.certStatus
    }
    if (opts.cert !== undefined && opts.cert !== null) {
      postBody['cert'] = opts.cert
    }
    if (opts.key !== undefined && opts.key !== null) {
      postBody['key'] = opts.key
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveRestartDomainCertificate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestartDomainCertificate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {string} [opts.publishDomain] - 推流域名
- 目前仅支持精确查询
- 为空时,查询用户所有直播域名
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param domainDetails domainDetails
      */

  describeLiveDomains (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      queryParams['publishDomain'] = opts.publishDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加直播域名
- 创建直播域名之前,必须先开通直播服务
- 直播域名必须已经备案完成

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 直播的推流域名
- 不支持泛域名

      * @param {string} opts.playDomain - 直播的播放域名
- 不支持泛域名

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveDomain (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveDomain"
      )
    }
    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling addLiveDomain"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动域名
- 启用状态为 停用 的直播域名对(推流域名,播放域名)将DomainStatus变更为online

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
- 需要启动的域名对(推流域名,播放域名)中的推流域名

      * @param {string} callback - callback
      @return {Object} result
      */

  startLiveDomain (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling startLiveDomain"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startLiveDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains:start',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停用域名
- 停用直播域名对(推流域名,播放域名),将DomainStatus变更为offline
- 停用该直播域名对后,直播域名信息仍保留,但用户将不能再用该推流域名推流或播放域名播放

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
- 需要停用的域名对(推流域名,播放域名)中的推流域名

      * @param {string} callback - callback
      @return {Object} result
      */

  stopLiveDomain (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling stopLiveDomain"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopLiveDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains:stop',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询指定域名相关信息
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
- 需要停用的域名对(推流域名,播放域名)中的推流域名

      * @param {string} callback - callback
      @return {Object} result
      * @param integer sourceId  SourceID
      * @param publishDomain publishDomains
      * @param playDomain playDomains
      */

  describeLiveDomainDetail (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveDomainDetail"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveDomainDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{publishDomain}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除直播域名
- 请慎重操作（建议在进行域名删除前到域名解析服务商处恢复域名A记录），以免导致删除操作后此域名不可访问。
  deleteLiveDomain调用成功后将删除本条直播域名的全部相关记录，对于仅需要暂停使用该直播域名，推荐stopLiveDomain接口

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveDomain (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveDomain"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{publishDomain}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加回看域名

      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - 直播的播放域名
- 回看域名所对应的原播放域名,新建的回看域名将绑定到此播放域名下

      * @param {string} opts.restartDomain - 直播回看域名
- 直播域名必须已经备案完成

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveRestartDomain (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling addLiveRestartDomain"
      )
    }
    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling addLiveRestartDomain"
      )
    }

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      postBody['restartDomain'] = opts.restartDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveRestartDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains:restart',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {string} opts.sourceUrl - 拉流地址
- 支持rtmp

      * @param {string} opts.pushUrl - 转推地址
- 支持rtmp

      * @param {string} opts.startMode - 执行方式
- StartNow: 立即执行
- StartAsScheduled: 定时执行，根据参数设定的时间

      * @param {string} [opts.startTime] - 开始时间
- UTC时间， ISO8601示例：2021-07-26T08:08:08Z
- 不填表示立即开始
  optional
      * @param {string} [opts.endTime] - 结束时间
- UTC时间， ISO8601示例：2021-07-26T08:08:08Z
- 最大支持365天，与开始时间间隔不超过7天。
  - 假设当前时间2021年03月30日11:50:01，则：结束时间不可超过2022年03月30日11:50:01。
- 不填拉不到流10分钟自动结束
  optional
      * @param {array} [opts.callbackEvents] - 回调类型
- 不填发送全部回调
- TaskStart 任务开始
- TaskExit 任务结束
- callbackUrl非空的情况下，callbackEvents有效
  optional
      * @param {string} [opts.callbackUrl] - 事件回调地址
  optional
      * @param {string} [opts.name] - 任务名称
- 最大255字符
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务ID
      */

  createLiveForwardTask (opts, callback) {
    opts = opts || {}

    if (opts.sourceUrl === undefined || opts.sourceUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.sourceUrl' when calling createLiveForwardTask"
      )
    }
    if (opts.pushUrl === undefined || opts.pushUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.pushUrl' when calling createLiveForwardTask"
      )
    }
    if (opts.startMode === undefined || opts.startMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.startMode' when calling createLiveForwardTask"
      )
    }

    let postBody = {}
    if (opts.sourceUrl !== undefined && opts.sourceUrl !== null) {
      postBody['sourceUrl'] = opts.sourceUrl
    }
    if (opts.pushUrl !== undefined && opts.pushUrl !== null) {
      postBody['pushUrl'] = opts.pushUrl
    }
    if (opts.startMode !== undefined && opts.startMode !== null) {
      postBody['startMode'] = opts.startMode
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.callbackEvents !== undefined && opts.callbackEvents !== null) {
      postBody['callbackEvents'] = opts.callbackEvents
    }
    if (opts.callbackUrl !== undefined && opts.callbackUrl !== null) {
      postBody['callbackUrl'] = opts.callbackUrl
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:create',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务ID

      * @param {string} [opts.sourceUrl] - 拉流地址
- 支持rtmp
  optional
      * @param {string} [opts.pushUrl] - 转推地址
- 支持rtmp
  optional
      * @param {string} [opts.startTime] - 开始时间
- UTC时间， ISO8601示例：2021-07-26T08:08:08Z
- 不填表示立即开始
  optional
      * @param {string} [opts.endTime] - 结束时间
- UTC时间， ISO8601示例：2021-07-26T08:08:08Z
- 最大支持365天，与开始时间间隔不超过7天。
- 不填拉不到流10分钟自动结束
  optional
      * @param {array} [opts.callbackEvents] - 回调类型
- 不填发送全部回调
- TaskStart 任务开始
- TaskExit 任务结束
- callbackUrl非空的情况下，callbackEvents有效
  optional
      * @param {string} [opts.callbackUrl] - 事件回调地址
  optional
      * @param {string} [opts.name] - 任务名称
- 最大255字符
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  updateLiveForwardTask (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling updateLiveForwardTask"
      )
    }

    let postBody = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      postBody['taskId'] = opts.taskId
    }
    if (opts.sourceUrl !== undefined && opts.sourceUrl !== null) {
      postBody['sourceUrl'] = opts.sourceUrl
    }
    if (opts.pushUrl !== undefined && opts.pushUrl !== null) {
      postBody['pushUrl'] = opts.pushUrl
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }
    if (opts.callbackEvents !== undefined && opts.callbackEvents !== null) {
      postBody['callbackEvents'] = opts.callbackEvents
    }
    if (opts.callbackUrl !== undefined && opts.callbackUrl !== null) {
      postBody['callbackUrl'] = opts.callbackUrl
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 拉流转推任务查询过滤条件:
- name:   taskId 任务ID
- value:  如果参数为空，则查询全部
- name:   taskName 任务名称
- value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveTaskInfo dataList
      */

  queryLiveForwardTask (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:query',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开始直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {string} opts.taskIds - 任务ID,批量用,分隔

      * @param {string} callback - callback
      @return {Object} result
      */

  startLiveForwardTask (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling startLiveForwardTask"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      queryParams['taskIds'] = opts.taskIds
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:start',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {string} opts.taskIds - 任务ID,批量用,分隔

      * @param {string} callback - callback
      @return {Object} result
      */

  stopLiveForwardTask (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling stopLiveForwardTask"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      queryParams['taskIds'] = opts.taskIds
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:stop',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除直播拉流转推任务

      * @param {Object} opts - parameters
      * @param {string} opts.taskIds - 任务ID,批量用,分隔

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveForwardTask (opts, callback) {
    opts = opts || {}

    if (opts.taskIds === undefined || opts.taskIds === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskIds' when calling deleteLiveForwardTask"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      queryParams['taskIds'] = opts.taskIds
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveForwardTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/LiveForwardTask:delete',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加直播质量检测模板
      * @param {Object} opts - parameters
      * @param {string} opts.template - 模板名称。长度不超过128个字符。UTF-8编码

      * @param {array} [opts.modules] - 检测项列表。取值范围：
  BlackScreen - 黑屏
  PureColor - 纯色
  ColorCast - 偏色
  FrozenFrame - 静帧
  Brightness - 亮度
  Contrast - 对比度
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  addCustomLiveStreamQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addCustomLiveStreamQualityDetectionTemplate"
      )
    }

    let postBody = {}
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }
    if (opts.modules !== undefined && opts.modules !== null) {
      postBody['modules'] = opts.modules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCustomLiveStreamQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionCustoms:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播质量检测模板列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 质量检测模板查询过滤条件
- name:   template 质量检测自定义名称
- value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param qualityDetectionTemplate qualityDetectionTemplates
      */

  describeCustomLiveStreamQualityDetectionTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamQualityDetectionTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionCustoms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用质量检测配置
- 添加应用级别的质量检测模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 质量检测模板

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppQualityDetection (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppQualityDetection"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppQualityDetection"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppQualityDetection"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppQualityDetection with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionApps:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名质量检测配置
- 添加域名级别的质量检测模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 质量检测模板

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainQualityDetection (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainQualityDetection"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainQualityDetection"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainQualityDetection with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionDomains:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播质量检测回调通知地址

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.notifyUrl - 质量检测回调通知的URL地址:
- 以 http:// 开头,外网可访问的地址

      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveStreamQualityDetectionNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling setLiveStreamQualityDetectionNotifyConfig"
      )
    }
    if (opts.notifyUrl === undefined || opts.notifyUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.notifyUrl' when calling setLiveStreamQualityDetectionNotifyConfig"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.notifyUrl !== undefined && opts.notifyUrl !== null) {
      postBody['notifyUrl'] = opts.notifyUrl
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveStreamQualityDetectionNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionNotifys:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除直播质量检测模板
- 删除质量检测模板前,请先删除此模板相关的质量检测配置,否则无法删除

      * @param {Object} opts - parameters
      * @param {string} opts.template - 质量检测模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomLiveStreamQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteCustomLiveStreamQualityDetectionTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomLiveStreamQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionCustoms/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除应用级别质量检测模板配置
- 删除应用级别质量检测模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 质量检测模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppQualityDetection (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppQualityDetection"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppQualityDetection"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppQualityDetection"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppQualityDetection with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名质量检测配置
- 删除域名级别的质量检测模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 质量检测模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainQualityDetection (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainQualityDetection"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainQualityDetection"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainQualityDetection with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionDomains/{publishDomain}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询质量检测回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string publishDomain  推流域名
      * @param string notifyUrl  回调地址
      */

  describeLiveStreamQualityDetectionNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamQualityDetectionNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamQualityDetectionNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionNotifys/{publishDomain}:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除质量检测回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamQualityDetectionNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamQualityDetectionNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamQualityDetectionNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionNotifys/{publishDomain}:config',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询质量检测模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 质量检测模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeQualityDetectionBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeQualityDetectionBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeQualityDetectionBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除录制文件

      * @param {Object} opts - parameters
      * @param {string} opts.fileUrl - 需要删除的录制文件在oss的url

      * @param {boolean} [opts.completely] - 是否深度删除所有的ts文件，仅对.m3u8录制文件生效。默认: true
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveRecordings (opts, callback) {
    opts = opts || {}

    if (opts.fileUrl === undefined || opts.fileUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.fileUrl' when calling deleteLiveRecordings"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.fileUrl !== undefined && opts.fileUrl !== null) {
      queryParams['fileUrl'] = opts.fileUrl
    }
    if (opts.completely !== undefined && opts.completely !== null) {
      queryParams['completely'] = opts.completely
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveRecordings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordings:delete',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启P2P

      * @param {Object} opts - parameters
      * @param {string} [opts.playDomain] - 播放域名  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  openLiveP2p (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call openLiveP2p with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveP2p:open',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭P2P
      * @param {Object} opts - parameters
      * @param {string} [opts.playDomain] - 播放域名  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  closeLiveP2p (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call closeLiveP2p with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveP2p:close',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询P2P配置
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {string} opts.playDomain - 直播的播放域名
- 目前仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param p2pResultObject resultObject
      */

  describeLiveP2pConfigs (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling describeLiveP2pConfigs"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      queryParams['playDomain'] = opts.playDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveP2pConfigs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveP2p:configs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户自定义直播录制模板列表

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {filter} [opts.filters] - 录制模板列表查询过滤条件:
  - name:   template 录制模板自定义名称
  - value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param recordTemplate recordTemplates
      */

  describeCustomLiveStreamRecordTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamRecordTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordCustoms:template',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加用户自定义直播录制模板

      * @param {Object} opts - parameters
      * @param {integer} opts.recordPeriod - 自动录制周期
- 取值: [15,360]
- 单位: 分钟

      * @param {string} opts.saveBucket - 存储桶

      * @param {string} [opts.saveEndpoint] - endpoint
  optional
      * @param {string} opts.recordFileType - 录制文件格式:
- 取值: ts,flv,mp4 (多种类型之间用;隔开)
- 不区分大小写

      * @param {string} opts.template - 录制模板自定义名称:
 - 取值要求：数字、大小写字母或短横线(&quot;-&quot;)、下划线(&quot;_&quot;),
   最大长度50个字符
 - &lt;b&gt;注意: 不能与已定义命名重复&lt;/b&gt;

      * @param {string} callback - callback
      @return {Object} result
      */

  addCustomLiveStreamRecordTemplate (opts, callback) {
    opts = opts || {}

    if (opts.recordPeriod === undefined || opts.recordPeriod === null) {
      throw new Error(
        "Missing the required parameter 'opts.recordPeriod' when calling addCustomLiveStreamRecordTemplate"
      )
    }
    if (opts.saveBucket === undefined || opts.saveBucket === null) {
      throw new Error(
        "Missing the required parameter 'opts.saveBucket' when calling addCustomLiveStreamRecordTemplate"
      )
    }
    if (opts.recordFileType === undefined || opts.recordFileType === null) {
      throw new Error(
        "Missing the required parameter 'opts.recordFileType' when calling addCustomLiveStreamRecordTemplate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addCustomLiveStreamRecordTemplate"
      )
    }

    let postBody = {}
    if (opts.recordPeriod !== undefined && opts.recordPeriod !== null) {
      postBody['recordPeriod'] = opts.recordPeriod
    }
    if (opts.saveBucket !== undefined && opts.saveBucket !== null) {
      postBody['saveBucket'] = opts.saveBucket
    }
    if (opts.saveEndpoint !== undefined && opts.saveEndpoint !== null) {
      postBody['saveEndpoint'] = opts.saveEndpoint
    }
    if (opts.recordFileType !== undefined && opts.recordFileType !== null) {
      postBody['recordFileType'] = opts.recordFileType
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCustomLiveStreamRecordTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordCustoms:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用级别直播录制配置
- 添加应用级别的直播录制模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 录制模版
      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppRecord (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppRecord"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppRecord"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppRecord"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordApps:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名级别直播录制配置
- 添加域名级别的直播录制模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 录制模版
      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainRecord (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainRecord"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainRecord"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordDomains:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播直播录制配置
- 录制模板配置按照 域名,应用,流 3级配置添加,以最小的粒度配置生效
- 域名、应用、流 依次粒度递减 即: 域名&gt;应用&gt;流
- 该查询旨在查询域名、应用、流最终生效的录制模板配置,并非各级的模板绑定情况

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 录制配置查询过滤条件:
  - name:   publishDomain，必填(推流域名)
  - value:  参数
  - name:   appName，必填(应用名称)
  - value:  参数
  - name:   streamName，非必填(流名称)
  - value:  参数
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveRecordConfig recordConfigs
      */

  describeCustomLiveStreamRecordConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamRecordConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/records:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播录制回调通知

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.notifyUrl - 录制回调通知的URL地址
- 以 http:// 开头,外网可访问的地址

      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveStreamRecordNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling setLiveStreamRecordNotifyConfig"
      )
    }
    if (opts.notifyUrl === undefined || opts.notifyUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.notifyUrl' when calling setLiveStreamRecordNotifyConfig"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.notifyUrl !== undefined && opts.notifyUrl !== null) {
      postBody['notifyUrl'] = opts.notifyUrl
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveStreamRecordNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordNotifys:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户自定义录制模板
- 删除用户自定义录制模板之前必须先删除此模板在各域名、应用、流级别的录制设置

      * @param {Object} opts - parameters
      * @param {string} opts.template - 录制模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomLiveStreamRecordTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteCustomLiveStreamRecordTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomLiveStreamRecordTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordCustoms/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除应用级别录制模板配置
- 删除应用级别的录制模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 录制模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppRecord (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppRecord"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppRecord"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppRecord"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名级别录制模板配置
- 删除域名级别录制模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 录制模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainRecord (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainRecord"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainRecord"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordDomains/{publishDomain}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询录制回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string publishDomain  推流域名
      * @param string notifyUrl  回调地址
      */

  describeLiveStreamRecordNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamRecordNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamRecordNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordNotifys/{publishDomain}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除录制回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamRecordNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamRecordNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamRecordNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordNotifys/{publishDomain}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加打点录制任务
- 您可以调用此接口精确提取已录制的文件中所需要的部分

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {array} [opts.recordTimes] - 录制时间集合
- 最大支持10段,多段合并成一个文件
- 多段时间跨度最小不能小于10s
- 多段时间跨度最大不能超过8小时
  optional
      * @param {string} opts.saveBucket - 存储桶
      * @param {string} opts.saveEndpoint - 存储地址
      * @param {string} opts.recordFileType - 录制文件类型:
- 取值: ts,flv,mp4 (多种类型之间用;隔开)
- 不区分大小写

      * @param {string} [opts.saveObject] - 录制文件存储Object:
- 默认: /record/{Date}/{ServerId}/{AppName}/{StreamName}/{StartTime}_{EndTime}
  optional
      * @param {string} [opts.taskExternalId] - 打点录制任务外部id(可传入您的id,在回调时会在该字段返回)
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveRecordTask (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveRecordTask"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveRecordTask"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling addLiveRecordTask"
      )
    }
    if (opts.saveBucket === undefined || opts.saveBucket === null) {
      throw new Error(
        "Missing the required parameter 'opts.saveBucket' when calling addLiveRecordTask"
      )
    }
    if (opts.saveEndpoint === undefined || opts.saveEndpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.saveEndpoint' when calling addLiveRecordTask"
      )
    }
    if (opts.recordFileType === undefined || opts.recordFileType === null) {
      throw new Error(
        "Missing the required parameter 'opts.recordFileType' when calling addLiveRecordTask"
      )
    }

    let postBody = {}
    if (opts.recordTimes !== undefined && opts.recordTimes !== null) {
      postBody['recordTimes'] = opts.recordTimes
    }
    if (opts.saveBucket !== undefined && opts.saveBucket !== null) {
      postBody['saveBucket'] = opts.saveBucket
    }
    if (opts.saveEndpoint !== undefined && opts.saveEndpoint !== null) {
      postBody['saveEndpoint'] = opts.saveEndpoint
    }
    if (opts.recordFileType !== undefined && opts.recordFileType !== null) {
      postBody['recordFileType'] = opts.recordFileType
    }
    if (opts.saveObject !== undefined && opts.saveObject !== null) {
      postBody['saveObject'] = opts.saveObject
    }
    if (opts.taskExternalId !== undefined && opts.taskExternalId !== null) {
      postBody['taskExternalId'] = opts.taskExternalId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      streamName: opts.streamName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveRecordTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/records/{publishDomain}/appNames/{appName}/streamNames/{streamName}/task',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询录制模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 录制模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeRecordBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeRecordBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRecordBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/recordTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询流分组统计数据
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过1天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStatisticGroupByStreamResult dataList
      */

  describeLiveStatisticGroupByStream (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStatisticGroupByStream"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStatisticGroupByStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStatisticGroupByStream',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询地域分组统计数据
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 播放域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过1天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStatisticGroupByAreaResult dataList
      */

  describeLiveStatisticGroupByArea (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveStatisticGroupByArea"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveStatisticGroupByArea"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling describeLiveStatisticGroupByArea"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStatisticGroupByArea"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStatisticGroupByArea with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStatisticGroupByArea',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询地域/运营商分组统计数据
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 播放域名
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过1天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStatisticGroupByAreaIspResult dataList
      */

  describeLiveStatisticGroupByAreaIsp (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveStatisticGroupByAreaIsp"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStatisticGroupByAreaIsp"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStatisticGroupByAreaIsp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStatisticGroupByAreaIsp',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询流分组统计数据(上行)
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过1天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStatisticGroupByStreamResult dataList
      */

  describeLivePublishStatisticGroupByStream (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLivePublishStatisticGroupByStream"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLivePublishStatisticGroupByStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLivePublishStatisticGroupByStream',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询推流监控数据
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过1天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param publishStreamInfoResult dataList
      */

  describePublishStreamInfoData (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describePublishStreamInfoData"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describePublishStreamInfoData"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling describePublishStreamInfoData"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describePublishStreamInfoData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePublishStreamInfoData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describePublishStreamInfoData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播流历史在线人数
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStreamUserNumResult dataList
      */

  describeLiveStreamHistoryUserNum (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamHistoryUserNum"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamHistoryUserNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamHistoryUserNum',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播推流数
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStreamUserNumResult dataList
      */

  describeLivePublishStreamNum (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLivePublishStreamNum"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLivePublishStreamNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLivePublishStreamNum',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播流播放人数排行
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.protocolType - 协议，取值范围：&quot;hdl,hls&quot;

      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，时间跨度不不超过⼀一天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStreamPlayerRankingResult dataList
      */

  describeLiveStreamPlayerRankingData (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveStreamPlayerRankingData"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveStreamPlayerRankingData"
      )
    }
    if (opts.protocolType === undefined || opts.protocolType === null) {
      throw new Error(
        "Missing the required parameter 'opts.protocolType' when calling describeLiveStreamPlayerRankingData"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPlayerRankingData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPlayerRankingData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamPlayerRankingData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码流信息
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名

      * @param {string} opts.appName - 应用名称

      * @param {string} opts.streamName - 流名称

      * @param {string} callback - callback
      @return {Object} result
      * @param liveTranscodeStreamResult dataList
      */

  describeLiveTranscodeStreamList (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveTranscodeStreamList"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveTranscodeStreamList"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling describeLiveTranscodeStreamList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTranscodeStreamList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveTranscodeStreamList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码流数量
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 推流域名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string datetime  时间
      * @param integer streamCount  流数量
      */

  describeLiveTranscodeStreamNum (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTranscodeStreamNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveTranscodeStreamNum',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码流观看人数
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param liveStreamUserNumResult dataList
      */

  describeLiveTranscodeStreamPlayerUserNum (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveTranscodeStreamPlayerUserNum"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveTranscodeStreamPlayerUserNum"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveTranscodeStreamPlayerUserNum"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTranscodeStreamPlayerUserNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveTranscodeStreamPlayerUserNum',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码流播放带宽
- 查询1分钟粒度的数据时，时间跨度不超过7天，其他粒度时时间跨度不超过30天

      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param bandwidthStatisticResult dataList
      */

  describeLiveTranscodeStreamBandwidth (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveTranscodeStreamBandwidth"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveTranscodeStreamBandwidth"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveTranscodeStreamBandwidth"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTranscodeStreamBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveTranscodeStreamBandwidth',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询在线流列表
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {integer} [opts.pageNum] - 页码，起始页码1
  optional
      * @param {integer} [opts.pageSize] - 每页最大记录数，取值：[10,100]，默认：10
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间，查询时间跨度不超过30天
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param publishOnlineStreamResultData streamList
      * @param integer total  流数量
      */

  describeDomainOnlineStream (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeDomainOnlineStream"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeDomainOnlineStream"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDomainOnlineStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeDomainOnlineStream',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  日志下载
      * @param {Object} opts - parameters
      * @param {string} opts.domains - 播放域名，多个时以逗号（,）分隔
      * @param {string} [opts.interval] - 时间间隔，取值(hour，day),不传默认小时
- 按小时（hour）下载时是.log文件
- 按天（day）下载时是.zip文件
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param domainsLogResult dataList
      */

  describeDomainsLog (opts, callback) {
    opts = opts || {}

    if (opts.domains === undefined || opts.domains === null) {
      throw new Error(
        "Missing the required parameter 'opts.domains' when calling describeDomainsLog"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeDomainsLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domains !== undefined && opts.domains !== null) {
      queryParams['domains'] = opts.domains
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      queryParams['interval'] = opts.interval
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDomainsLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeDomainsLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询URL播放排行
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 播放域名
      * @param {integer} [opts.size] - 查询Top数量，默认20，即返回Top20的数据  optional
      * @param {string} [opts.rankfield] - 排行依据字段，取值：[&quot;pv&quot;, &quot;flow&quot;, &quot;bandwidth&quot;]，默认pv
- pv 播放次数
- flow 流量
- bandwidth 带宽
  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param rankingUrlResult dataList
      */

  describeUrlRanking (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeUrlRanking"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeUrlRanking"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.size !== undefined && opts.size !== null) {
      queryParams['size'] = opts.size
    }
    if (opts.rankfield !== undefined && opts.rankfield !== null) {
      queryParams['rankfield'] = opts.rankfield
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUrlRanking with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeUrlRanking',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询推流码率、帧率
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {integer} [opts.pageNumber] - 页码，起始页码1
  optional
      * @param {integer} [opts.pageSize] - 每页最大记录数，取值：[10,1000]，默认：100
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveStreamPublishInfo publishInfoList
      */

  describeLiveStreamPublishInfoByPage (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveStreamPublishInfoByPage"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPublishInfoByPage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPublishInfoByPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamPublishInfoByPage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询观看人数
      * @param {Object} opts - parameters
      * @param {string} opts.domainName - 推流域名
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {integer} [opts.pageNumber] - 页码，起始页码1
  optional
      * @param {integer} [opts.pageSize] - 每页最大记录数，取值：[10,1000]，默认：100
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveStreamPlayInfo playInfoList
      */

  describeLiveStreamPlayInfoByPage (opts, callback) {
    opts = opts || {}

    if (opts.domainName === undefined || opts.domainName === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainName' when calling describeLiveStreamPlayInfoByPage"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPlayInfoByPage"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPlayInfoByPage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamPlayInfoByPage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码时长数据
      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名  optional
      * @param {string} [opts.grade] - 码率档次，可以查询指定档次的转码时长，取值：
- video_h264_4k_1
- video_h264_2k_1
- video_h264_shd_1
- video_h264_hd_1
- video_h264_sd_1
- video_h265_4k_1
- video_h265_2k_1
- video_h265_shd_1
- video_h265_hd_1
- video_h265_sd_1
  optional
      * @param {string} [opts.period] - 查询周期，取值范围：“day,month,year,followTime”，分别表示1天，1月，1年，跟随时间。默认为空，表示day。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeDurationStatisticResult dataList
      */

  describeLiveTranscodingDurationData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveTranscodingDurationData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.grade !== undefined && opts.grade !== null) {
      queryParams['grade'] = opts.grade
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTranscodingDurationData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveTranscodingDurationData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询存储空间数据
      * @param {Object} opts - parameters
      * @param {string} [opts.period] - 查询周期，取值范围：“day,month,year,followTime”，分别表示1天，1月，1年，跟随时间。默认为空，表示day。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param fileStorageStatisticResult dataList
      */

  describeLiveFileStorageData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveFileStorageData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveFileStorageData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveFileStorageData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询带宽数据
- 查询某个时间段内的带宽数据（平均带宽）
- 查询1分钟粒度的数据时，时间跨度不超过7天，其他粒度时时间跨度不超过30天

      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名，可以通过指定域名查询该域名下产生的带宽数据。
  optional
      * @param {string} [opts.appName] - 推流AppName，将AppName作为查询条件时须指定域名。
  optional
      * @param {string} [opts.streamName] - 流名称，将流名称作为查询条件时须指定域名和AppName。
  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param bandwidthStatisticResult dataList
      */

  describeLiveStreamBandwidthData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamBandwidthData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamBandwidthData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamBandwidthData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询推流带宽
- 查询某个时间段内的推流上行带宽数据
- 查询1分钟粒度的数据时，时间跨度不超过7天，其他粒度时时间跨度不超过30天

      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 推流域名，可以通过指定域名查询该域名下产生的带宽数据。
  optional
      * @param {string} [opts.appName] - 推流AppName，将AppName作为查询条件时须指定域名。
  optional
      * @param {string} [opts.streamName] - 流名称，将流名称作为查询条件时须指定域名和AppName。
  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param bandwidthStatisticResult dataList
      */

  describeLiveStreamPublishBandwidthData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPublishBandwidthData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPublishBandwidthData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamPublishBandwidthData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询流量数据
- 查询某个时间段内的流量数据。
- 查询1分钟粒度的数据时，时间跨度不超过7天，其他粒度时时间跨度不超过30天

      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 播放域名，可以通过指定域名查询该域名下产生的带宽数据。
  optional
      * @param {string} [opts.appName] - 推流AppName，将AppName作为查询条件时须指定域名。
  optional
      * @param {string} [opts.streamName] - 流名称
  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param trafficStatisticResult dataList
      */

  describeLiveStreamTrafficData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamTrafficData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamTrafficData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamTrafficData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询推流上行流量数据
- 查询某个时间段内的流量数据。
- 查询1分钟粒度的数据时，时间跨度不超过7天，其他粒度时时间跨度不超过30天

      * @param {Object} opts - parameters
      * @param {string} [opts.domainName] - 推流域名，可以通过指定域名查询该域名下产生的带宽数据。
  optional
      * @param {string} [opts.appName] - 推流AppName，将AppName作为查询条件时须指定域名。
  optional
      * @param {string} [opts.streamName] - 流名称
  optional
      * @param {string} [opts.ispName] - 运营商
  optional
      * @param {string} [opts.locationName] - 查询的区域，如beijing,shanghai。多个用逗号分隔
  optional
      * @param {string} [opts.protocolType] - 查询的流协议类型，取值范围：&quot;rtmp,hdl,hls&quot;，多个时以逗号分隔
  optional
      * @param {string} [opts.period] - 查询周期，当前取值范围：“oneMin,fiveMin,halfHour,hour,twoHour,sixHour,day,followTime”，分别表示1min，5min，半小时，1小时，2小时，6小时，1天，跟随时间。默认为空，表示fiveMin。当传入followTime时，表示按Endtime-StartTime的周期，只返回一个点
  optional
      * @param {string} opts.startTime - 查询起始时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;

      * @param {string} [opts.endTime] - 查询截至时间，UTC时间，格式：yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;，为空时默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param trafficStatisticResult dataList
      */

  describeLiveStreamPublishTrafficData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPublishTrafficData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.ispName !== undefined && opts.ispName !== null) {
      queryParams['ispName'] = opts.ispName
    }
    if (opts.locationName !== undefined && opts.locationName !== null) {
      queryParams['locationName'] = opts.locationName
    }
    if (opts.protocolType !== undefined && opts.protocolType !== null) {
      queryParams['protocolType'] = opts.protocolType
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPublishTrafficData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeLiveStreamPublishTrafficData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播截图张数数据
      * @param {Object} opts - parameters
      * @param {string} [opts.publishDomain] - 推流域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {integer} [opts.shotMode] - 截图模式：1表示采样截图；2表示关键帧截图(默认为2)  optional
      * @param {string} opts.startTime - 起始时间:
- UTC时间
  格式: yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例: 2018-10-21T10:00:00Z
- 支持最大查询90天以内的数据

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式: yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例: 2018-10-21T10:00:00Z
- 为空,默认当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotCountStatisticResult snapshotData
      */

  describeLiveSnapshotData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveSnapshotData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      queryParams['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.shotMode !== undefined && opts.shotMode !== null) {
      queryParams['shotMode'] = opts.shotMode
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveSnapshotData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveSnapshotData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播鉴黄张数数据
      * @param {Object} opts - parameters
      * @param {string} [opts.publishDomain] - 推流域名  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} opts.startTime - 起始时间
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 支持最大查询90天以内的数据

      * @param {string} [opts.endTime] - 结束时间:
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 为空,默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pornCountStatisticResult pornData
      */

  describeLivePornData (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLivePornData"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      queryParams['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLivePornData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/livePornData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加直播截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.format - 截图格式
- 取值: jpg, png
- 不区分大小写

      * @param {integer} [opts.width] - 截图宽度
- 取值: [8,8192]
- 如果(width,height)只设置其中之一,则按所设置参数项等比缩放另一项输出截图
- 如果(width,height)都不设置，则按源流大小输出截图
  optional
      * @param {integer} [opts.height] - 截图高度
- 取值: [8,8192]
- 如果(width,height)只设置其中之一,则按所设置参数项等比缩放另一项输出截图
- 如果(width,height)都不设置，则按源流大小输出截图
  optional
      * @param {integer} opts.fillType - 截图与设定的宽高不匹配时的处理规则
  1: 拉伸
  2: 留黑
  3: 留白
  4: 高斯模糊
- 1是按照设定宽高拉伸
- 2,3,4是等比例的缩放多余或不足处按调置处理

      * @param {integer} opts.snapshotInterval - 截图周期
- 取值范围 [5,3600]
- 单位: 秒

      * @param {integer} opts.saveMode - 存储模式
  1: 覆盖存储
  2: 顺序存储

      * @param {string} opts.saveBucket - 存储桶
      * @param {string} [opts.saveEndpoint] - 存储地址  optional
      * @param {string} opts.template - 截图模板自定义名称:
- 取值要求: 数字、大小写字母或短横线(&quot;-&quot;)、下划线(&quot;_&quot;),
  首尾不能有特殊字符(&quot;-&quot;)
  最大长度50个字符
- &lt;b&gt;注意: 不能与已定义命名重复&lt;/b&gt;

      * @param {string} callback - callback
      @return {Object} result
      */

  addCustomLiveStreamSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.format === undefined || opts.format === null) {
      throw new Error(
        "Missing the required parameter 'opts.format' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }
    if (opts.fillType === undefined || opts.fillType === null) {
      throw new Error(
        "Missing the required parameter 'opts.fillType' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }
    if (opts.snapshotInterval === undefined || opts.snapshotInterval === null) {
      throw new Error(
        "Missing the required parameter 'opts.snapshotInterval' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }
    if (opts.saveMode === undefined || opts.saveMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.saveMode' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }
    if (opts.saveBucket === undefined || opts.saveBucket === null) {
      throw new Error(
        "Missing the required parameter 'opts.saveBucket' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addCustomLiveStreamSnapshotTemplate"
      )
    }

    let postBody = {}
    if (opts.format !== undefined && opts.format !== null) {
      postBody['format'] = opts.format
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.fillType !== undefined && opts.fillType !== null) {
      postBody['fillType'] = opts.fillType
    }
    if (opts.snapshotInterval !== undefined && opts.snapshotInterval !== null) {
      postBody['snapshotInterval'] = opts.snapshotInterval
    }
    if (opts.saveMode !== undefined && opts.saveMode !== null) {
      postBody['saveMode'] = opts.saveMode
    }
    if (opts.saveBucket !== undefined && opts.saveBucket !== null) {
      postBody['saveBucket'] = opts.saveBucket
    }
    if (opts.saveEndpoint !== undefined && opts.saveEndpoint !== null) {
      postBody['saveEndpoint'] = opts.saveEndpoint
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCustomLiveStreamSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotCustoms:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播截图配置
- 截图模板配置按照 域名,应用,流 3级配置添加,以最小的粒度配置生效
- 域名、应用、流 依次粒度递减 即: 域名&gt;应用&gt;流
- 该查询旨在查询域名、应用、流最终生效的截图模板配置,并非各级的模板绑定情况

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 直播截图查询过滤条件:
- name:   publishDomain 必填(推流域名)
- value:  参数
- name:   appName 必填(应用名称)
- value:  参数
- name:   streamName 非必填(流名称)
- value:  参数
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param snapshotConfig snapshotConfigs
      */

  describeCustomLiveStreamSnapshotConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamSnapshotConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotCustoms:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播截图模板列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 截图模板查询过滤条件
- name:   template 录制模板自定义名称
- value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param snapshotTemplate snapshotTemplates
      */

  describeCustomLiveStreamSnapshotTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamSnapshotTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotCustoms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用截图配置
- 添加应用级别的截图模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 截图模板

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppSnapshot (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppSnapshot"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppSnapshot"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppSnapshot"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppSnapshot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotApps:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名截图配置
- 添加域名级别的截图模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 截图模板

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainSnapshot (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainSnapshot"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainSnapshot"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainSnapshot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotDomains:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播截图回调通知地址

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.notifyUrl - 截图回调通知的URL地址:
- 以 http:// 开头,外网可访问的地址

      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveStreamSnapshotNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling setLiveStreamSnapshotNotifyConfig"
      )
    }
    if (opts.notifyUrl === undefined || opts.notifyUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.notifyUrl' when calling setLiveStreamSnapshotNotifyConfig"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.notifyUrl !== undefined && opts.notifyUrl !== null) {
      postBody['notifyUrl'] = opts.notifyUrl
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveStreamSnapshotNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotNotifys:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户自定义直播截图模板
- 删除截图模板前,请先删除此模板相关的截图配置,否则将会影响线上业务

      * @param {Object} opts - parameters
      * @param {string} opts.template - 截图模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomLiveStreamSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteCustomLiveStreamSnapshotTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomLiveStreamSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotCustoms/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除APP截图配置
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 截图模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppSnapshot (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppSnapshot"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppSnapshot"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppSnapshot"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppSnapshot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名截图配置
- 删除域名级别的截图模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 截图模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainSnapshot (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainSnapshot"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainSnapshot"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainSnapshot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotDomains/{publishDomain}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string publishDomain  推流域名
      * @param string notifyUrl  回调地址
      */

  describeLiveStreamSnapshotNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamSnapshotNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamSnapshotNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotNotifys/{publishDomain}:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除截图回调配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamSnapshotNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamSnapshotNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamSnapshotNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotNotifys/{publishDomain}:config',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 截图模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeSnapshotBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeSnapshotBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSnapshotBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁止直播流推送
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {integer} [opts.forbidTime] - 禁流时长,单位:s 0表示永久禁流;大于0为限时禁流,超过时长自动解禁  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  forbidLiveStream (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling forbidLiveStream"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling forbidLiveStream"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling forbidLiveStream"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.forbidTime !== undefined && opts.forbidTime !== null) {
      postBody['forbidTime'] = opts.forbidTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call forbidLiveStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams:forbid',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  恢复直播流推送
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} callback - callback
      @return {Object} result
      */

  resumeLiveStream (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling resumeLiveStream"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling resumeLiveStream"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling resumeLiveStream"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call resumeLiveStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams:resume',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  中断直播流推送
- 中断操作1秒后可以继续推流

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} callback - callback
      @return {Object} result
      */

  interruptLiveStream (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling interruptLiveStream"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling interruptLiveStream"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling interruptLiveStream"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call interruptLiveStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams:interrupt',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播实时流信息

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} callback - callback
      @return {Object} result
      * @param string publishDomain  推流域名
      * @param string appName  应用名称
      * @param string streamName  流名称
      * @param string status  流状态
  on: 在线流
  off: 非在线流

      */

  describeLiveStreamInfo (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamInfo"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling describeLiveStreamInfo"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling describeLiveStreamInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      streamName: opts.streamName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams/{publishDomain}/appNames/{appName}/streamNames/{streamName}/streamInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置直播流状态回调地址
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.notifyUrl - 直播流状态回调地址
- 必须以 http:// 开头

      * @param {string} callback - callback
      @return {Object} result
      */

  setLiveStreamNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling setLiveStreamNotifyConfig"
      )
    }
    if (opts.notifyUrl === undefined || opts.notifyUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.notifyUrl' when calling setLiveStreamNotifyConfig"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.notifyUrl !== undefined && opts.notifyUrl !== null) {
      postBody['notifyUrl'] = opts.notifyUrl
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setLiveStreamNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streamNotifys',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播流状态回调地址
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      * @param string publishDomain  推流域名
      * @param string notifyUrl  流状态回调地址
      */

  describeLiveStreamNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streamNotifys/{publishDomain}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除直播流状态回调地址
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamNotifyConfig (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamNotifyConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamNotifyConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streamNotifys/{publishDomain}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播中的流的信息
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {integer} [opts.pageNum] - 页码
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param onlineStreamInfo onlineStreamInfos
      */

  describeLiveStreamOnlineList (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamOnlineList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamOnlineList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams/{publishDomain}/onlineList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看推流历史记录
      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {integer} [opts.pageNum] - 页码&lt;br&gt;
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小&lt;br&gt;
- 取值范围[10, 100]
  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} [opts.streamName] - 流名称  optional
      * @param {string} opts.startTime - 推流起始时间&lt;br&gt;
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 最大支持最近30天内的流历史查询

      * @param {string} [opts.endTime] - 推流结束时间&lt;br&gt;
- UTC时间
  格式:yyyy-MM-dd&#39;T&#39;HH:mm:ss&#39;Z&#39;
  示例:2018-10-21T10:00:00Z
- 最大支持最近30天内的流历史查询
- 结束时间为空默认为当前时间
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveStreamPublishInfo liveStreamPublishInfos
      */

  describeLiveStreamPublishList (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling describeLiveStreamPublishList"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeLiveStreamPublishList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      queryParams['streamName'] = opts.streamName
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamPublishList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/streams/{publishDomain}/publishList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启回看
1、直播回看文件格式仅支持m3u8。
2、回看时长用户可以配置，最大支持7天，即用户请求回看内容，最多可以请求最近7天的直播回看内容。
3、域名格式：http://{restartDomain}/{appName}/{streamName}/index.m3u8?starttime&#x3D;1527756680&amp;endtime&#x3D;1527760280 (unix时间戳)
4、starttime-endtime最长可支持24小时，可跨天

      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 回看的播放域名
      * @param {string} callback - callback
      @return {Object} result
      */

  openLiveRestart (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling openLiveRestart"
      )
    }

    let postBody = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      postBody['restartDomain'] = opts.restartDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call openLiveRestart with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestart:open',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭回看
      * @param {Object} opts - parameters
      * @param {string} opts.restartDomain - 回看的播放域名
      * @param {string} callback - callback
      @return {Object} result
      */

  closeLiveRestart (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling closeLiveRestart"
      )
    }

    let postBody = {}
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      postBody['restartDomain'] = opts.restartDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call closeLiveRestart with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestart:close',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回看配置
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码；默认为1；取值范围[1, 100000]  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} opts.restartDomain - 回看的推流域名
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param restartConfig restartConfigs
      */

  describeLiveRestartConfigs (opts, callback) {
    opts = opts || {}

    if (opts.restartDomain === undefined || opts.restartDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.restartDomain' when calling describeLiveRestartConfigs"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.restartDomain !== undefined && opts.restartDomain !== null) {
      queryParams['restartDomain'] = opts.restartDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveRestartConfigs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveRestart:configs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启时移
直播支持最大4小时的HLS时移，使用方式为在播放域名后增加时移参数来实现，参数类型支持指定开始时间和时间偏移量2种方式进行时移。 开启直播时移后，重新推流生效，使用播放域名带相应参数访问即可播放
- 域名格式：
1、http://{playDomain}/{appName}/{streamName}/index.m3u8?timeshift&#x3D;400（秒，指从当前时间往前时移的偏移量）
2、http://{playDomain}/{appName}/{streamName}/index.m3u8?starttime&#x3D;1529223702 (unix时间戳)

      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - 直播的播放域名
      * @param {string} callback - callback
      @return {Object} result
      */

  openLiveTimeshift (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling openLiveTimeshift"
      )
    }

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call openLiveTimeshift with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveTimeshift:open',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭时移
      * @param {Object} opts - parameters
      * @param {string} opts.playDomain - 直播的播放域名
      * @param {string} callback - callback
      @return {Object} result
      */

  closeLiveTimeshift (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling closeLiveTimeshift"
      )
    }

    let postBody = {}
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      postBody['playDomain'] = opts.playDomain
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call closeLiveTimeshift with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveTimeshift:close',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询时移配置
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码
- 取值范围[1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {string} opts.playDomain - 直播的播放域名
- 目前仅支持精确匹配

      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param timeshiftConfig timeshiftConfigs
      */

  describeLiveTimeshiftConfigs (opts, callback) {
    opts = opts || {}

    if (opts.playDomain === undefined || opts.playDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.playDomain' when calling describeLiveTimeshiftConfigs"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.playDomain !== undefined && opts.playDomain !== null) {
      queryParams['playDomain'] = opts.playDomain
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveTimeshiftConfigs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/liveTimeshift:configs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名级别转码配置
- 添加域名级别的转码模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 直播的推流域名
      * @param {string} opts.template - 转码模版
- 取值范围: 系统标准转码模板, 用户自定义转码模板
- 系统标准转码模板
  ld (h.264/640*360/15f)
  sd (h.264/960*540/25f)
  hd (h.264/1280*720/25f)
  shd (h.264/1920*1080/30f)
  ld-265 (h.265/640*360/15f)
  sd-265 (h.265/960*540/25f)
  hd-265 (h.265/1280*720/25f)
  shd-265 (h.265/1920*1080/30f)

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainTranscode (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainTranscode"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainTranscode"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeDomains:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用转码配置
- 添加应用级别的转码模板配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 转码模版
- 取值范围: 系统标准转码模板, 用户自定义转码模板
- 系统标准转码模板
  ld (h.264/640*360/15f)
  sd (h.264/960*540/25f)
  hd (h.264/1280*720/25f)
  shd (h.264/1920*1080/30f)
  ld-265 (h.265/640*360/15f)
  sd-265 (h.265/960*540/25f)
  hd-265 (h.265/1280*720/25f)
  shd-265 (h.265/1920*1080/30f)

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppTranscode (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppTranscode"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppTranscode"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppTranscode"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeApps:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加自定义转码模板
- 系统为您预设了标准转码模板,如果不能满足您的转码需求,可以通过此接口添加自定义转码模板
- 系统标准转码模板
    ld (h.264/640*360/15f)
    sd (h.264/960*540/25f)
    hd (h.264/1280*720/25f)
    shd (h.264/1920*1080/30f)
    ld-265 (h.265/640*360/15f)
    sd-265 (h.265/960*540/25f)
    hd-265 (h.265/1280*720/25f)
    shd-265 (h.265/1920*1080/30f)

      * @param {Object} opts - parameters
      * @param {string} [opts.templateName] - 转码模板名称
- 长度范围：[1,50]
  optional
      * @param {string} [opts.videoCodec] - 视频编码格式，取值：h264,h265，默认h264
- h264时,分辨率小于等于1080p
- h265时,分辨率小于等于4k
  optional
      * @param {integer} opts.videoCodeRate - 转码输出的码率值
- 取值范围: [128,15000]
- 单位: kpbs

      * @param {string} opts.videoFrameRate - 转码输出的帧率值
- 取值：[1,30]

      * @param {integer} [opts.width] - 转码输出视频宽度
- 取值: [128,4096]
- 如果(width,height)只设置其中之一,则按所设置参数项等比缩放另一项输出转码
- 如果(width,height)都不设置，则按源流大小输出转码
  optional
      * @param {integer} [opts.height] - 转码输出视频高度
- 取值: [128,4096]
- 如果(width,height)只设置其中之一,则按所设置参数项等比缩放另一项输出转码
- 如果(width,height)都不设置，则按源流大小输出转码
  optional
      * @param {string} opts.template - 转码模板(转码流输出后缀)
- 取值要求：数字、大小写字母或短横线(&quot;-&quot;),必须以数字或字母作为开头和结尾,长度不超过50字符
- &lt;b&gt;注意: 不能与系统的标准的转码模板和当前用户已自定义命名重复&lt;/b&gt;
- 系统标准转码模板
  ld (h.264/640*360/15f)
  sd (h.264/960*540/25f)
  hd (h.264/1280*720/25f)
  shd (h.264/1920*1080/30f)
  ld-265 (h.265/640*360/15f)
  sd-265 (h.265/960*540/25f)
  hd-265 (h.265/1280*720/25f)
  shd-265 (h.265/1920*1080/30f)

      * @param {string} opts.audioCodec - 转码输出音频编码格式
- 取值: aac、mp3
- 不区分大小写

      * @param {string} [opts.audioFormat] - 转码输出音频格式
- 取值: aac_lc,aac_low,aac_he,aac_he_v2; 默认:aac_he
- 不区分大小写
  optional
      * @param {integer} opts.audioSampleRate - 转码输出音频采样率
- 取值: [44100,48000]

      * @param {integer} opts.audioChannel - 转码输出音频通道数
  1: 单声道
  2: 双声道

      * @param {integer} opts.audioCodeRate - 转码输出音频码率
- 取值: [16,128]
- 单位: kbps

      * @param {string} [opts.jdchd] - 京享超清开关
- 取值: jdchd-1.0,off
- 京享超清暂时只支持h.264
  optional
      * @param {string} [opts.audioComfort] - 舒适音频
- 取值: on,off
  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  addCustomLiveStreamTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.videoCodeRate === undefined || opts.videoCodeRate === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoCodeRate' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.videoFrameRate === undefined || opts.videoFrameRate === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoFrameRate' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.audioCodec === undefined || opts.audioCodec === null) {
      throw new Error(
        "Missing the required parameter 'opts.audioCodec' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.audioSampleRate === undefined || opts.audioSampleRate === null) {
      throw new Error(
        "Missing the required parameter 'opts.audioSampleRate' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.audioChannel === undefined || opts.audioChannel === null) {
      throw new Error(
        "Missing the required parameter 'opts.audioChannel' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }
    if (opts.audioCodeRate === undefined || opts.audioCodeRate === null) {
      throw new Error(
        "Missing the required parameter 'opts.audioCodeRate' when calling addCustomLiveStreamTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.videoCodec !== undefined && opts.videoCodec !== null) {
      postBody['videoCodec'] = opts.videoCodec
    }
    if (opts.videoCodeRate !== undefined && opts.videoCodeRate !== null) {
      postBody['videoCodeRate'] = opts.videoCodeRate
    }
    if (opts.videoFrameRate !== undefined && opts.videoFrameRate !== null) {
      postBody['videoFrameRate'] = opts.videoFrameRate
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }
    if (opts.audioCodec !== undefined && opts.audioCodec !== null) {
      postBody['audioCodec'] = opts.audioCodec
    }
    if (opts.audioFormat !== undefined && opts.audioFormat !== null) {
      postBody['audioFormat'] = opts.audioFormat
    }
    if (opts.audioSampleRate !== undefined && opts.audioSampleRate !== null) {
      postBody['audioSampleRate'] = opts.audioSampleRate
    }
    if (opts.audioChannel !== undefined && opts.audioChannel !== null) {
      postBody['audioChannel'] = opts.audioChannel
    }
    if (opts.audioCodeRate !== undefined && opts.audioCodeRate !== null) {
      postBody['audioCodeRate'] = opts.audioCodeRate
    }
    if (opts.jdchd !== undefined && opts.jdchd !== null) {
      postBody['jdchd'] = opts.jdchd
    }
    if (opts.audioComfort !== undefined && opts.audioComfort !== null) {
      postBody['audioComfort'] = opts.audioComfort
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCustomLiveStreamTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeCustoms:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户自定义转码模板列表

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 转码模板查询过滤条件:
  - name:   template 转码模板自定义名称
  - value:  如果参数为空，则查询全部
  - 如果为空,则表示查询该用下所有自定义的转码模板
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param transcodeInfo transcodeTemplates
      */

  describeCustomLiveStreamTranscodeTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamTranscodeTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeCustoms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询系统默认转码模板列表

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 转码模板查询过滤条件:
  - name:   template 转码模板自定义名称
  - value:  如果参数为空，则查询全部
  - 如果为空,则表示查询该用下所有自定义的转码模板
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param transcodeInfo transcodeTemplates
      */

  describeSystemLiveStreamTranscodeTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSystemLiveStreamTranscodeTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeSystem',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板配置
- 转码模板配置按照 域名,应用,流 3级配置添加,以最小的粒度配置生效原则
- 域名、应用、流 依次粒度递减 即: 域名&gt;应用&gt;流
- 该查询旨在查询域名、应用、流最终生效的转码模板配置,并非各级的模板绑定情况

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {filter} [opts.filters] - 模板配置查询过滤条件:
  - name:   publishDomain 必填(推流域名)
  - value:  参数
  - name:   appName 必填(应用名称)
  - value:  参数
  - name:   streamName 非必填(流名称)
  - value:  参数
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param templateConfig transcodeConfigs
      */

  describeLiveStreamTranscodeConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamTranscodeConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodes:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名级别转码模板配置
- 删除域名级别转码模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 转码模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainTranscode (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainTranscode"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainTranscode"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeDomains/{publishDomain}/templates/{template}:config',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除应用级别转码模板配置
- 删除应用级别的转码模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 转码模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppTranscode (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppTranscode"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppTranscode"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppTranscode"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户自定义转码模板详情
- 查询用户自定义转码模板详情
- 系统标准转码模板
      ld (h.264/640*360/15f)
      sd (h.264/960*540/24f)
      hd (h.264/1280*720/25f)
      shd (h.264/1920*1080/30f)
      ld-265 (h.265/640*360/15f)
      sd-265 (h.265/960*540/24f)
      hd-265 (h.265/1280*720/25f)
      shd-265 (h.265/1920*1080/30f)

      * @param {Object} opts - parameters
      * @param {string} opts.template - 转码模板
      * @param {string} callback - callback
      @return {Object} result
      * @param string videoCodec  视频编码格式，取值：h264,h265，默认h264

      * @param integer videoCodeRate  转码输出的码率值
- 单位: kpbs

      * @param string videoFrameRate  转码输出的帧率值

      * @param integer width  转码输出视频宽度

      * @param integer height  转码输出视频高度

      * @param string template  转码模板

      * @param string audioCodec  转码输出音频编码格式

      * @param string audioFormat  转码输出音频格式

      * @param integer audioSampleRate  转码输出音频采样率

      * @param integer audioChannel  转码输出音频通道数
  1: 单声道
  2: 双声道

      * @param integer audioCodeRate  转码输出音频码率
- 单位: kbps

      * @param string jdchd  京享超清
- 取值: jdchd-1.0,off

      * @param string audioComfort  舒适音频
- 取值: on,off

      */

  describeCustomLiveStreamTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeCustomLiveStreamTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeCustoms/{template}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户自定义转码模板
- 删除用户自定义转码模板之前必须先删除此模板在各域名、应用、流级别的转码设置

      * @param {Object} opts - parameters
      * @param {string} opts.template - 转码模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomLiveStreamTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteCustomLiveStreamTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomLiveStreamTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeCustoms/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 转码模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeTranscodeBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeTranscodeBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTranscodeBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名翻译配置
- 添加域名级别的翻译模板配置
- 一个域名最多可绑定一个翻译模板
- 重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 直播的推流域名
      * @param {string} opts.template - 翻译模版
- 取值范围: 系统标准翻译模板, 用户自定义翻译模板
- 系统标准翻译模板
  system-zh-en (中译英)
  system-en-zh (英译中)

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainTranslate"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateDomains:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用翻译配置
- 添加应用级别的翻译模板配置
- 一个应用最多可绑定一个翻译模板
- 重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 翻译模版
- 取值范围: 系统标准翻译模板, 用户自定义翻译模板
- 系统标准翻译模板
  system-zh-en (中译英)
  system-en-zh (英译中)

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppTranslate"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateApps:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加流翻译配置
- 添加流级别的翻译模板配置
- 一个流最多可绑定一个翻译模板
- 重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} opts.template - 翻译模版
- 取值范围: 系统标准翻译模板, 用户自定义翻译模板
- 系统标准翻译模板
  system-zh-en (中译英)
  system-en-zh (英译中)

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamTranslate"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling addLiveStreamTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamTranslate"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateStream:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询系统默认翻译模板列表

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 翻译模板查询过滤条件:
  - name:   template 翻译模板名称
  - value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param translateInfo translateTemplates
      */

  describeSystemLiveStreamTranslateTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSystemLiveStreamTranslateTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateSystem',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询翻译模板配置
- 翻译模板配置按照 域名,应用,流 3级配置添加,以最小的粒度配置生效原则
- 域名、应用、流 依次粒度递减 即: 域名&gt;应用&gt;流
- 该查询旨在查询域名、应用、流最终生效的翻译模板配置,并非各级的模板绑定情况

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围[10, 100]
  optional
      * @param {filter} [opts.filters] - 模板配置查询过滤条件:
  - name:   publishDomain 必填(推流域名)
  - value:  参数
  - name:   appName 必填(应用名称)
  - value:  参数
  - name:   streamName 非必填(流名称)
  - value:  参数
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param translateTemplateConfig translateConfigs
      */

  describeLiveStreamTranslateConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveStreamTranslateConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translates:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名下的翻译模板配置

      * @param {Object} opts - parameters
      * @param {filter} [opts.filters] - 模板配置查询过滤条件:
  - name:   publishDomain 必填(推流域名)
  - value:  参数
  - name:   level 非必填(Level)
  - value:  参数，取值：domain,app,stream
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param domainTranslateTemplateConfig templateList
      */

  describeLiveDomainTranslateConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLiveDomainTranslateConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateTemplates:domain',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名的翻译模板配置
- 删除域名级别翻译模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 翻译模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainTranslate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateDomains/{publishDomain}/templates/{template}:config',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除应用的翻译模板配置
- 删除应用级别的翻译模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 翻译模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppTranslate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除流的翻译模板配置
- 删除流级别翻译模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {string} opts.template - 翻译模板
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamTranslate"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling deleteLiveStreamTranslate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamTranslate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      streamName: opts.streamName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateStream/{publishDomain}/appNames/{appName}/streams/{streamName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询翻译模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 翻译模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeTranslateBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeTranslateBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTranslateBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translateTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  暂停指定流的翻译任务
- 暂停添加实时翻译字幕到指定流
- 指定的流需在线且配置了翻译模板

      * @param {Object} opts - parameters
      * @param {} opts.publishDomain - 推流域名
      * @param {} opts.appName - APP名
      * @param {} opts.streamName - 流名
      * @param {string} callback - callback
      @return {Object} result
      */

  pauseLiveStreamTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling pauseLiveStreamTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling pauseLiveStreamTranslate"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling pauseLiveStreamTranslate"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call pauseLiveStreamTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translate:pause',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  恢复指定流的翻译任务
- 恢复添加实时翻译字幕到指定流
- 指定的流需在线且配置了翻译模板，同时处于翻译暂停状态

      * @param {Object} opts - parameters
      * @param {} opts.publishDomain - 推流域名
      * @param {} opts.appName - APP名
      * @param {} opts.streamName - 流名
      * @param {string} callback - callback
      @return {Object} result
      */

  resumeLiveStreamTranslate (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling resumeLiveStreamTranslate"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling resumeLiveStreamTranslate"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling resumeLiveStreamTranslate"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call resumeLiveStreamTranslate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/translate:resume',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加用户自定义水印模板

      * @param {Object} opts - parameters
      * @param {integer} [opts.position] - 水印位置
- 取值范围：左上：1，右上：3， 左下：7，右下：9，默认：1
  optional
      * @param {string} [opts.offsetUnit] - 偏移量单位
- 取值: percent,pixel
- percent:按百分比; pixel:像素 默认:pixel
  optional
      * @param {integer} opts.offsetX - x轴偏移量
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

      * @param {integer} opts.offsetY - y轴偏移量:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

      * @param {string} [opts.sizeUnit] - 水印大小单位
- 取值: percent,pixel
- percent:按百分比; pixel:像素 默认:pixel
  optional
      * @param {integer} opts.width - 水印宽度:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

      * @param {integer} opts.height - 水印高度:
- 取值范围
  percent: (0,100]
  pixel: (0,1920]

      * @param {string} opts.template - 自定义水印模板名称
-&amp;ensp;取值要求: 数字、大小写字母、短横线(&quot;-&quot;)、下划线(&quot;_&quot;),
&amp;ensp;&amp;ensp;首尾不能有特殊字符(&quot;-&quot;),
&amp;ensp;&amp;ensp;不超过50字符,utf-8格式
-&amp;ensp;&lt;b&gt;注意: 不能与已定义命名重复&lt;/b&gt;

      * @param {string} [opts.uploadId] - 创建上传任务时返回的uploadId参数，当通过接口上传水印图片时，uploadId必填
  optional
      * @param {string} opts.url - 水印地址&lt;br&gt;-&amp;ensp;以&amp;ensp;http:// 开头,可公开访问地址&lt;br&gt;
      * @param {string} callback - callback
      @return {Object} result
      */

  addCustomLiveStreamWatermarkTemplate (opts, callback) {
    opts = opts || {}

    if (opts.offsetX === undefined || opts.offsetX === null) {
      throw new Error(
        "Missing the required parameter 'opts.offsetX' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }
    if (opts.offsetY === undefined || opts.offsetY === null) {
      throw new Error(
        "Missing the required parameter 'opts.offsetY' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }
    if (opts.width === undefined || opts.width === null) {
      throw new Error(
        "Missing the required parameter 'opts.width' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }
    if (opts.height === undefined || opts.height === null) {
      throw new Error(
        "Missing the required parameter 'opts.height' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }
    if (opts.url === undefined || opts.url === null) {
      throw new Error(
        "Missing the required parameter 'opts.url' when calling addCustomLiveStreamWatermarkTemplate"
      )
    }

    let postBody = {}
    if (opts.position !== undefined && opts.position !== null) {
      postBody['position'] = opts.position
    }
    if (opts.offsetUnit !== undefined && opts.offsetUnit !== null) {
      postBody['offsetUnit'] = opts.offsetUnit
    }
    if (opts.offsetX !== undefined && opts.offsetX !== null) {
      postBody['offsetX'] = opts.offsetX
    }
    if (opts.offsetY !== undefined && opts.offsetY !== null) {
      postBody['offsetY'] = opts.offsetY
    }
    if (opts.sizeUnit !== undefined && opts.sizeUnit !== null) {
      postBody['sizeUnit'] = opts.sizeUnit
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }
    if (opts.uploadId !== undefined && opts.uploadId !== null) {
      postBody['uploadId'] = opts.uploadId
    }
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCustomLiveStreamWatermarkTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkCustoms:template',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户定义水印模板列表

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 水印模板列表查询过滤条件:
  - name:   template 录制模板自定义名称
  - value:  如果参数为空，则查询全部
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param watermarkTemplate watermarkTemplates
      */

  describeCustomLiveStreamWatermarkTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamWatermarkTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkCustoms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加应用级别水印配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 水印模板名称

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamAppWatermark (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamAppWatermark"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling addLiveStreamAppWatermark"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamAppWatermark"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamAppWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkApps:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名水印配置

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 水印模板

      * @param {string} callback - callback
      @return {Object} result
      */

  addLiveStreamDomainWatermark (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling addLiveStreamDomainWatermark"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling addLiveStreamDomainWatermark"
      )
    }

    let postBody = {}
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.template !== undefined && opts.template !== null) {
      postBody['template'] = opts.template
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addLiveStreamDomainWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkDomains:config',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询直播水印配置
- 水印模板配置按照 域名,应用,流 3级配置添加,以最小的粒度配置生效
- 域名、应用、流 依次粒度递减 即: 域名&gt;应用&gt;流
- 该查询旨在查询域名、应用、流最终生效的水印模板配置,并非各级的模板绑定情况

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNum] - 页码
- 取值范围 [1, 100000]
  optional
      * @param {integer} [opts.pageSize] - 分页大小
- 取值范围 [10, 100]
  optional
      * @param {filter} [opts.filters] - 水印配置查询过滤条件:
  - name:   publishDomain，必填(推流域名)
  - value:  参数
  - name:   appName，必填(应用名称)
  - value:  参数
  - name:   streamName，非必填(流名称)
  - value:  参数
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageNumber  当前页码
      * @param integer pageSize  每页数量
      * @param integer totalCount  查询总数
      * @param liveStreamRecordConfig watermarkConfigs
      */

  describeCustomLiveStreamWatermarkConfig (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      queryParams['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCustomLiveStreamWatermarkConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks:config',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户自定义水印模板
- 删除用户自定义水印模板之前必须先删除此模板在各域名、应用、流级别的水印设置

      * @param {Object} opts - parameters
      * @param {string} opts.template - 水印模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCustomLiveStreamWatermarkTemplate (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteCustomLiveStreamWatermarkTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCustomLiveStreamWatermarkTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkCustoms/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除应用级别水印模板配置
- 删除应用级别的水印模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.template - 水印模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamAppWatermark (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamAppWatermark"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling deleteLiveStreamAppWatermark"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamAppWatermark"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      appName: opts.appName,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamAppWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkApps/{publishDomain}/appNames/{appName}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名级别水印模板配置
- 删除域名级别水印模板配置,重新推流后生效

      * @param {Object} opts - parameters
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.template - 水印模板

      * @param {string} callback - callback
      @return {Object} result
      */

  deleteLiveStreamDomainWatermark (opts, callback) {
    opts = opts || {}

    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling deleteLiveStreamDomainWatermark"
      )
    }
    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling deleteLiveStreamDomainWatermark"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      publishDomain: opts.publishDomain,
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLiveStreamDomainWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkDomains/{publishDomain}/templates/{template}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询水印模板绑定

      * @param {Object} opts - parameters
      * @param {string} opts.template - 水印模板
      * @param {string} callback - callback
      @return {Object} result
      * @param templateBinding bindingList
      */

  describeWatermarkBinding (opts, callback) {
    opts = opts || {}

    if (opts.template === undefined || opts.template === null) {
      throw new Error(
        "Missing the required parameter 'opts.template' when calling describeWatermarkBinding"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      template: opts.template
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  live/1.0.22'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeWatermarkBinding with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarkTemplates/{template}:binding',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = LIVE
