/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 媒体处理相关接口
 * 多媒体处理服务API，包括截图、转码、媒体处理消息通知等操作。本文档详细说明了媒体处理API及用法，适合开发人员阅读。
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'mps'
Service._services[serviceId] = true

/**
 * mps service.
 * @version 0.4.10
 */

class MPS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'mps.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  设置回调配置
      * @param {Object} opts - parameters
      * @param {array} [opts.callbackEvents] - 回调事件列表。取值范围：
- snapshot_complete 截图完成，包括成功和失败
  optional
      * @param {string} opts.callbackType - 回调方式，目前只支持 http
      * @param {string} [opts.httpUrl] - 回调方式为 http 时，此为必须参数  optional
      * @param {string} [opts.disabled] - 是否禁用回调，默认值为 false，即开启回调  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setCallbackSettings (opts, callback) {
    opts = opts || {}

    if (opts.callbackType === undefined || opts.callbackType === null) {
      throw new Error(
        "Missing the required parameter 'opts.callbackType' when calling setCallbackSettings"
      )
    }

    let postBody = {}
    if (opts.callbackEvents !== undefined && opts.callbackEvents !== null) {
      postBody['callbackEvents'] = opts.callbackEvents
    }
    if (opts.callbackType !== undefined && opts.callbackType !== null) {
      postBody['callbackType'] = opts.callbackType
    }
    if (opts.httpUrl !== undefined && opts.httpUrl !== null) {
      postBody['httpUrl'] = opts.httpUrl
    }
    if (opts.disabled !== undefined && opts.disabled !== null) {
      postBody['disabled'] = opts.disabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setCallbackSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/settings:setCallbackSettings',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询回调配置
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param callbackSettings resultObject
      */

  queryCallbackSettings (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCallbackSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/settings:queryCallbackSettings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交视频截图任务
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 截图模板ID
      * @param {input} opts.input
      * @param {output} opts.output
      * @param {output} [opts.spriteOutput]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submitSnapshotTaskResultObject resultObject
      */

  submitSnapshotTask (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling submitSnapshotTask"
      )
    }
    if (opts.input === undefined || opts.input === null) {
      throw new Error(
        "Missing the required parameter 'opts.input' when calling submitSnapshotTask"
      )
    }
    if (opts.output === undefined || opts.output === null) {
      throw new Error(
        "Missing the required parameter 'opts.output' when calling submitSnapshotTask"
      )
    }

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.input !== undefined && opts.input !== null) {
      postBody['input'] = opts.input
    }
    if (opts.output !== undefined && opts.output !== null) {
      postBody['output'] = opts.output
    }
    if (opts.spriteOutput !== undefined && opts.spriteOutput !== null) {
      postBody['spriteOutput'] = opts.spriteOutput
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitSnapshotTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频截图任务列表
支持过滤查询：
  - createTime,ge 最早任务创建时间
  - createTime,le 最晚任务创建时间
  - status,in 任务状态IN查询
  - taskId,eq 任务ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listSnapshotTasksResultObject resultObject
      */

  listSnapshotTasks (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSnapshotTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视频截图任务详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTaskObject snapshotTaskObject
      */

  getSnapshotTask (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling getSnapshotTask"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSnapshotTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除视频截图任务。删除任务时，会同时删除任务相关的数据，如任务执行结果等
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSnapshotTask (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling deleteSnapshotTask"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSnapshotTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks/{taskId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频截图任务结果
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务ID，路径参数
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTaskResultObject snapshotTaskResultObject
      */

  querySnapshotTaskResult (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling querySnapshotTaskResult"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySnapshotTaskResult with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks/{taskId}:queryResult',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图模板列表。
允许通过条件过滤查询，支持的过滤字段如下：
  - templateId[eq] 按模板ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listSnapshotTemplatesResultInfo resultObject
      */

  listSnapshotTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSnapshotTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.title - 模板标题。长度不超过 128 个字节。UTF-8 编码。
      * @param {integer} [opts.startTime] - 截图起始时间，取值范围单位为秒，缺省值为 0
  optional
      * @param {string} [opts.frameType] - 截图帧类型。取值范围：
  any - 任意帧
  intra - 关键帧
缺省值为 any
  optional
      * @param {string} [opts.format] - 截图格式。取值范围：
  jpg - 对应的截图或雪碧图输出文件扩展名为 jpg
  png - 对应的截图或雪碧图输出文件扩展名为 png
缺省值为 jpg
  optional
      * @param {integer} [opts.number] - 截图数量。取值范围：[1, 3600]
缺省值为 10
若雪碧图配置不为空，则生成雪碧图，提交的截图任务中，此字段会被雪碧图的行列积所覆盖。
  optional
      * @param {integer} [opts.interval] - 截图时间间隔。取值范围：[1, 100]，单位为秒
若未设置，则对于普通截图，按照截图张数做平均截图；对于雪碧图，则按照行列数乘积做平均截图
  optional
      * @param {integer} [opts.width] - 截图宽度，取值范围：[8, 4096]
若宽度和高度同时设置，则按照设置的宽高截图；
若宽度和高度均未设置，则截图保持与源视频相同的宽高值；
若宽度和高度其中一项未设置，则截图保持与源视频相同的宽高比；
  optional
      * @param {integer} [opts.height] - 截图高度，取值范围：[8, 4096]
若宽度和高度同时设置，则按照设置的宽高截图；
若宽度和高度均未设置，则截图保持与源视频相同的宽高值；
若宽度和高度其中一项未设置，则截图保持与源视频相同的宽高比；
  optional
      * @param {string} [opts.fillType] - 填充方式，当视频宽高与截图宽高指定值不能匹配时的填充处理方式。取值范围：
  stretch - 伸缩
  black - 留黑
  white - 留白
  gauss - 高斯模糊
缺省值为 black
  optional
      * @param {spriteConfig} [opts.spriteConfig] - 雪碧图配置。若此字段有值，则生成雪碧图。
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  createSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling createSnapshotTemplate"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.frameType !== undefined && opts.frameType !== null) {
      postBody['frameType'] = opts.frameType
    }
    if (opts.format !== undefined && opts.format !== null) {
      postBody['format'] = opts.format
    }
    if (opts.number !== undefined && opts.number !== null) {
      postBody['number'] = opts.number
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      postBody['interval'] = opts.interval
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.fillType !== undefined && opts.fillType !== null) {
      postBody['fillType'] = opts.fillType
    }
    if (opts.spriteConfig !== undefined && opts.spriteConfig !== null) {
      postBody['spriteConfig'] = opts.spriteConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  getSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getSnapshotTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} [opts.title] - 模板标题。长度不超过 128 个字节。UTF-8 编码。  optional
      * @param {integer} [opts.startTime] - 截图起始时间，单位为秒，缺省值为 0  optional
      * @param {string} [opts.frameType] - 截图帧类型。取值范围：normal、intra  optional
      * @param {string} [opts.format] - 截图格式。取值范围：jpg、png  optional
      * @param {integer} [opts.number] - 截图数量，缺省值为 10  optional
      * @param {integer} [opts.interval] - 截图间隔  optional
      * @param {integer} [opts.width] - 截图宽度，取值范围：[8, 4096]
  optional
      * @param {integer} [opts.height] - 截图高度，取值范围：[8, 4096]
  optional
      * @param {string} [opts.fillType] - 填充方式，当视频宽高与截图宽高指定值不能匹配时的填充处理方式。取值范围：
  stretch - 伸缩
  black - 留黑
  white - 留白
  gauss - 高斯模糊
缺省值为 black
  optional
      * @param {spriteConfig} [opts.spriteConfig] - 雪碧图配置  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  modifySnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling modifySnapshotTemplate"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.frameType !== undefined && opts.frameType !== null) {
      postBody['frameType'] = opts.frameType
    }
    if (opts.format !== undefined && opts.format !== null) {
      postBody['format'] = opts.format
    }
    if (opts.number !== undefined && opts.number !== null) {
      postBody['number'] = opts.number
    }
    if (opts.interval !== undefined && opts.interval !== null) {
      postBody['interval'] = opts.interval
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.fillType !== undefined && opts.fillType !== null) {
      postBody['fillType'] = opts.fillType
    }
    if (opts.spriteConfig !== undefined && opts.spriteConfig !== null) {
      postBody['spriteConfig'] = opts.spriteConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteSnapshotTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交转码作业
      * @param {Object} opts - parameters
      * @param {string} opts.accessKey - 输入对象存储 accessKey，必须参数
      * @param {string} opts.secretKey - 输入对象存储 accessKey，必须参数
      * @param {string} opts.endpoint - 输入对象存储 endpoint。必须参数，内网域名，如 s3-internal.cn-north-1.jcloudcs.com
      * @param {string} opts.bucket - 输入对象存储 bucket，必须参数
      * @param {string} opts.objectKey - 输入对象存储 objectKey，必须参数
      * @param {string} [opts.title] - 输入视频标题，可选参数，默认会从 objectKey 中截取  optional
      * @param {array} [opts.templateIds] - 转码模板ID集合，必须参数，非空集合  optional
      * @param {transcodeOutputConfig} opts.outputConfig - 输出配置，必须参数
      * @param {string} [opts.additionalProperties] - 附加参数，JSON格式的字符串。除非清楚了解其用途和用法，请勿使用此字段。
若参数在本次作业提交所关联的模板中，存在相同用途的对应字段，则该属性值会覆盖模板中的对应字段；
若参数在本次作业提交所关联的模板中，不存在相同用途的对应字段，则该属性值会作为补充设置，用于生产任务；
有特殊说明的除外。
当前支持的附加参数：
  - hls.encrypt.key - HLS加密公钥，对应于转码模板中 encryption.hlsKey 字段
  - hls.encrypt.keyUrl - HLS加密公钥地址，对应于转码模板中 encryption.hlsKeyUrl 字段
  - hls.encrypt.encodeType - HLS加密公钥编码方式，对应于转码模板中 encryption.hlsKeyEncodeType 字段
特殊说明：
  -  HLS加密相关参数，具有完整性要求，故 hls.encrypt 命名空间下的附加参数，依赖于 hls.encrypt.key 参数的设置情况。若设置 hls.encrypt.key 参数，则命名空间 hls.encrypt 下的其他参数也须同时设置；否则，其他参数会被忽略。
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submitTranscodeJobResultInfo resultObject
      */

  submitTranscodeJob (opts, callback) {
    opts = opts || {}

    if (opts.accessKey === undefined || opts.accessKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.accessKey' when calling submitTranscodeJob"
      )
    }
    if (opts.secretKey === undefined || opts.secretKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.secretKey' when calling submitTranscodeJob"
      )
    }
    if (opts.endpoint === undefined || opts.endpoint === null) {
      throw new Error(
        "Missing the required parameter 'opts.endpoint' when calling submitTranscodeJob"
      )
    }
    if (opts.bucket === undefined || opts.bucket === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucket' when calling submitTranscodeJob"
      )
    }
    if (opts.objectKey === undefined || opts.objectKey === null) {
      throw new Error(
        "Missing the required parameter 'opts.objectKey' when calling submitTranscodeJob"
      )
    }
    if (opts.outputConfig === undefined || opts.outputConfig === null) {
      throw new Error(
        "Missing the required parameter 'opts.outputConfig' when calling submitTranscodeJob"
      )
    }

    let postBody = {}
    if (opts.accessKey !== undefined && opts.accessKey !== null) {
      postBody['accessKey'] = opts.accessKey
    }
    if (opts.secretKey !== undefined && opts.secretKey !== null) {
      postBody['secretKey'] = opts.secretKey
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }
    if (opts.bucket !== undefined && opts.bucket !== null) {
      postBody['bucket'] = opts.bucket
    }
    if (opts.objectKey !== undefined && opts.objectKey !== null) {
      postBody['objectKey'] = opts.objectKey
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }
    if (opts.outputConfig !== undefined && opts.outputConfig !== null) {
      postBody['outputConfig'] = opts.outputConfig
    }
    if (
      opts.additionalProperties !== undefined &&
      opts.additionalProperties !== null
    ) {
      postBody['additionalProperties'] = opts.additionalProperties
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitTranscodeJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeJobs:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码作业列表。
支持如下过滤器：
- title[eq] 按照输入视频标题进行精确匹配

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listTranscodeJobsResultInfo resultObject
      */

  listTranscodeJobs (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTranscodeJobs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeJobs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个转码作业信息。

      * @param {Object} opts - parameters
      * @param {string} opts.jobId - 转码作业ID
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeJobInfo resultObject
      */

  getTranscodeJob (opts, callback) {
    opts = opts || {}

    if (opts.jobId === undefined || opts.jobId === null) {
      throw new Error(
        "Missing the required parameter 'opts.jobId' when calling getTranscodeJob"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      jobId: opts.jobId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeJobs/{jobId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板列表。
允许通过条件过滤查询，支持的过滤字段如下：
  - transcodeType[eq] 按转码方式精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listTranscodeTemplatesResultInfo resultObject
      */

  listTranscodeTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTranscodeTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建转码模板
      * @param {Object} opts - parameters
      * @param {string} opts.title - 模板标题。长度不超过 128 个字符，最少 2 个字符。UTF-8 编码。

      * @param {videoStreamSettings} opts.video - 视频参数配置
      * @param {audioStreamSettings} opts.audio - 音频参数配置
      * @param {containerSettings} opts.container - 容器封装配置
      * @param {encryptionSettings} [opts.encryption] - 加密配置  optional
      * @param {string} opts.definition - 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K

      * @param {string} [opts.transcodeType] - 转码方式。取值范围：
  normal - 普通转码
  jdchd - 京享超清
  jdchs - 极速转码
默认值为 normal
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateInfo resultObject
      */

  createTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling createTranscodeTemplate"
      )
    }
    if (opts.video === undefined || opts.video === null) {
      throw new Error(
        "Missing the required parameter 'opts.video' when calling createTranscodeTemplate"
      )
    }
    if (opts.audio === undefined || opts.audio === null) {
      throw new Error(
        "Missing the required parameter 'opts.audio' when calling createTranscodeTemplate"
      )
    }
    if (opts.container === undefined || opts.container === null) {
      throw new Error(
        "Missing the required parameter 'opts.container' when calling createTranscodeTemplate"
      )
    }
    if (opts.definition === undefined || opts.definition === null) {
      throw new Error(
        "Missing the required parameter 'opts.definition' when calling createTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.video !== undefined && opts.video !== null) {
      postBody['video'] = opts.video
    }
    if (opts.audio !== undefined && opts.audio !== null) {
      postBody['audio'] = opts.audio
    }
    if (opts.container !== undefined && opts.container !== null) {
      postBody['container'] = opts.container
    }
    if (opts.encryption !== undefined && opts.encryption !== null) {
      postBody['encryption'] = opts.encryption
    }
    if (opts.definition !== undefined && opts.definition !== null) {
      postBody['definition'] = opts.definition
    }
    if (opts.transcodeType !== undefined && opts.transcodeType !== null) {
      postBody['transcodeType'] = opts.transcodeType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateInfo resultObject
      */

  getTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  完整更新转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} [opts.title] - 模板标题。长度不超过 128 个字符，最少 2 个字符。UTF-8 编码。
  optional
      * @param {videoStreamSettings} [opts.video] - 视频参数配置  optional
      * @param {audioStreamSettings} [opts.audio] - 音频参数配置  optional
      * @param {containerSettings} [opts.container] - 封装容器配置  optional
      * @param {encryptionSettings} [opts.encryption] - 加密配置  optional
      * @param {string} [opts.definition] - 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K
  optional
      * @param {string} [opts.transcodeType] - 转码方式。取值范围：
  normal - 普通转码
  jdchd - 京享超清
  jdchs - 极速转码
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateInfo resultObject
      */

  updateTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling updateTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.video !== undefined && opts.video !== null) {
      postBody['video'] = opts.video
    }
    if (opts.audio !== undefined && opts.audio !== null) {
      postBody['audio'] = opts.audio
    }
    if (opts.container !== undefined && opts.container !== null) {
      postBody['container'] = opts.container
    }
    if (opts.encryption !== undefined && opts.encryption !== null) {
      postBody['encryption'] = opts.encryption
    }
    if (opts.definition !== undefined && opts.definition !== null) {
      postBody['definition'] = opts.definition
    }
    if (opts.transcodeType !== undefined && opts.transcodeType !== null) {
      postBody['transcodeType'] = opts.transcodeType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  部分修改转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} [opts.title] - 模板标题。长度不超过 128 个字符，最少 2 个字符。UTF-8 编码。
  optional
      * @param {videoStreamSettings} [opts.video] - 视频参数配置  optional
      * @param {audioStreamSettings} [opts.audio] - 音频参数配置  optional
      * @param {containerSettings} [opts.container] - 封装容器配置  optional
      * @param {encryptionSettings} [opts.encryption] - 加密配置  optional
      * @param {string} [opts.definition] - 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K
  optional
      * @param {string} [opts.transcodeType] - 转码方式。取值范围：
  normal - 普通转码
  jdchd - 京享超清
  jdchs - 极速转码
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateInfo resultObject
      */

  modifyTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling modifyTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.video !== undefined && opts.video !== null) {
      postBody['video'] = opts.video
    }
    if (opts.audio !== undefined && opts.audio !== null) {
      postBody['audio'] = opts.audio
    }
    if (opts.container !== undefined && opts.container !== null) {
      postBody['container'] = opts.container
    }
    if (opts.encryption !== undefined && opts.encryption !== null) {
      postBody['encryption'] = opts.encryption
    }
    if (opts.definition !== undefined && opts.definition !== null) {
      postBody['definition'] = opts.definition
    }
    if (opts.transcodeType !== undefined && opts.transcodeType !== null) {
      postBody['transcodeType'] = opts.transcodeType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取bucket的图片样式分隔符配置
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param styleDelimiterConf styleDelimiterConf
      */

  getStyleDelimiter (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getStyleDelimiter"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling getStyleDelimiter"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getStyleDelimiter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/styleDelimiter/',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置图片样式分隔符
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {array} [opts.delimiters] - 图片样式分隔符配置（JSON数组）；支持的分隔符包含：[&quot;-&quot;, &quot;_&quot;, &quot;/&quot;, &quot;!&quot;]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setStyleDelimiter (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setStyleDelimiter"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling setStyleDelimiter"
      )
    }

    let postBody = {}
    if (opts.delimiters !== undefined && opts.delimiters !== null) {
      postBody['delimiters'] = opts.delimiters
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setStyleDelimiter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/styleDelimiter/',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除bucket的图片样式分隔符配置
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteStyleDelimiter (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteStyleDelimiter"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling deleteStyleDelimiter"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteStyleDelimiter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/styleDelimiter/',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图片样式列表
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {string} [opts.styleName] - 按样式名称查询  optional
      * @param {integer} [opts.pageNumber] - 数据页码  optional
      * @param {integer} [opts.pageSize] - 每页数据的条数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param imageStyleQueryResult imageStyleQueryResult
      */

  listImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling listImageStyle"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.styleName !== undefined && opts.styleName !== null) {
      queryParams['styleName'] = opts.styleName
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加图片样式
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {integer} [opts.id] - 图片样式id(readOnly)  optional
      * @param {string} [opts.userId] - 用户id(readOnly)  optional
      * @param {string} [opts.styleName] - 图片样式名称  optional
      * @param {string} [opts.params] - 图片样式参数  optional
      * @param {string} [opts.paramAlias] - 图片样式参数别名  optional
      * @param {string} [opts.regionId] - 所属区域(readOnly)  optional
      * @param {string} [opts.bucketName] - 所属Bucket(readOnly)  optional
      * @param {integer} [opts.status] - 图片样式状态(readOnly)  optional
      * @param {string} [opts.modifyTime] - 修改时间(readOnly)  optional
      * @param {string} [opts.createdTime] - 创建时间(readOnly)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param imageStyleID imageStyleID
      */

  createImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling createImageStyle"
      )
    }

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.styleName !== undefined && opts.styleName !== null) {
      postBody['styleName'] = opts.styleName
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }
    if (opts.paramAlias !== undefined && opts.paramAlias !== null) {
      postBody['paramAlias'] = opts.paramAlias
    }
    if (opts.regionId !== undefined && opts.regionId !== null) {
      postBody['regionId'] = opts.regionId
    }
    if (opts.bucketName !== undefined && opts.bucketName !== null) {
      postBody['bucketName'] = opts.bucketName
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.modifyTime !== undefined && opts.modifyTime !== null) {
      postBody['modifyTime'] = opts.modifyTime
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图片样式详情
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {integer} opts.id - 图片样式id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param imageStyle imageStyle
      */

  getImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling getImageStyle"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling getImageStyle"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles/{id}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改图片样式
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {integer} opts.id - 图片样式id
      * @param {integer} [opts.id] - 图片样式id(readOnly)  optional
      * @param {string} [opts.userId] - 用户id(readOnly)  optional
      * @param {string} [opts.styleName] - 图片样式名称  optional
      * @param {string} [opts.params] - 图片样式参数  optional
      * @param {string} [opts.paramAlias] - 图片样式参数别名  optional
      * @param {string} [opts.regionId] - 所属区域(readOnly)  optional
      * @param {string} [opts.bucketName] - 所属Bucket(readOnly)  optional
      * @param {integer} [opts.status] - 图片样式状态(readOnly)  optional
      * @param {string} [opts.modifyTime] - 修改时间(readOnly)  optional
      * @param {string} [opts.createdTime] - 创建时间(readOnly)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling updateImageStyle"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateImageStyle"
      )
    }

    let postBody = {}
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.styleName !== undefined && opts.styleName !== null) {
      postBody['styleName'] = opts.styleName
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }
    if (opts.paramAlias !== undefined && opts.paramAlias !== null) {
      postBody['paramAlias'] = opts.paramAlias
    }
    if (opts.regionId !== undefined && opts.regionId !== null) {
      postBody['regionId'] = opts.regionId
    }
    if (opts.bucketName !== undefined && opts.bucketName !== null) {
      postBody['bucketName'] = opts.bucketName
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.modifyTime !== undefined && opts.modifyTime !== null) {
      postBody['modifyTime'] = opts.modifyTime
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles/{id}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除图片样式
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {integer} opts.id - 图片样式id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling deleteImageStyle"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling deleteImageStyle"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles/{id}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图片样式总数
      * @param {Object} opts - parameters
      * @param {string} opts.bucketName - Bucket名称
      * @param {string} [opts.styleName] - 按样式名称查询  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param imageStyleCount imageStyleCount
      */

  countImageStyle (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  countImageStyle"
      )
    }

    opts = opts || {}

    if (opts.bucketName === undefined || opts.bucketName === null) {
      throw new Error(
        "Missing the required parameter 'opts.bucketName' when calling countImageStyle"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.styleName !== undefined && opts.styleName !== null) {
      queryParams['styleName'] = opts.styleName
    }

    let pathParams = {
      regionId: regionId,
      bucketName: opts.bucketName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call countImageStyle with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/buckets/{bucketName}/imageStyles/count',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图任务，返回满足查询条件的任务列表。
      * @param {Object} opts - parameters
      * @param {string} [opts.status] - task 状态 (PENDING, RUNNING, SUCCESS, FAILED)  optional
      * @param {string} [opts.begin] - 开始时间 时间格式(GMT): yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;  optional
      * @param {string} [opts.end] - 结束时间 时间格式(GMT): yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39;Z&#39;  optional
      * @param {string} [opts.marker] - 查询标记  optional
      * @param {integer} [opts.limit] - 查询记录数 [1, 1000]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param thumbnailQuery thumbnailQuery
      */

  listThumbnailTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listThumbnailTask"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.begin !== undefined && opts.begin !== null) {
      queryParams['begin'] = opts.begin
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }
    if (opts.marker !== undefined && opts.marker !== null) {
      queryParams['marker'] = opts.marker
    }
    if (opts.limit !== undefined && opts.limit !== null) {
      queryParams['limit'] = opts.limit
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listThumbnailTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/thumbnail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建截图任务，创建成功时返回任务ID。本接口用于截取指定时间点的画面。
      * @param {Object} opts - parameters
      * @param {string} [opts.taskID] - 任务ID (readonly)  optional
      * @param {string} [opts.status] - 状态 (SUCCESS, ERROR, PENDDING, RUNNING) (readonly)  optional
      * @param {integer} [opts.errorCode] - 错误码 (readonly)  optional
      * @param {string} [opts.createdTime] - 任务创建时间 时间格式(GMT): yyyy-MM-dd’T’HH:mm:ss.SSS’Z’  (readonly)  optional
      * @param {string} [opts.lastUpdatedTime] - 任务创建时间 时间格式(GMT): yyyy-MM-dd’T’HH:mm:ss.SSS’Z’  (readonly)  optional
      * @param {thumbnailTaskSource} opts.source
      * @param {thumbnailTaskTarget} opts.target
      * @param {thumbnailTaskRule} [opts.rule]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param thumbnailTaskID thumbnailTaskID
      */

  createThumbnailTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createThumbnailTask"
      )
    }

    opts = opts || {}

    if (opts.source === undefined || opts.source === null) {
      throw new Error(
        "Missing the required parameter 'opts.source' when calling createThumbnailTask"
      )
    }
    if (opts.target === undefined || opts.target === null) {
      throw new Error(
        "Missing the required parameter 'opts.target' when calling createThumbnailTask"
      )
    }

    let postBody = {}
    if (opts.taskID !== undefined && opts.taskID !== null) {
      postBody['taskID'] = opts.taskID
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.errorCode !== undefined && opts.errorCode !== null) {
      postBody['errorCode'] = opts.errorCode
    }
    if (opts.createdTime !== undefined && opts.createdTime !== null) {
      postBody['createdTime'] = opts.createdTime
    }
    if (opts.lastUpdatedTime !== undefined && opts.lastUpdatedTime !== null) {
      postBody['lastUpdatedTime'] = opts.lastUpdatedTime
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.target !== undefined && opts.target !== null) {
      postBody['target'] = opts.target
    }
    if (opts.rule !== undefined && opts.rule !== null) {
      postBody['rule'] = opts.rule
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createThumbnailTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/thumbnail',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据任务ID获取截图任务。
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - task id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param thumbnailTask thumbnailTask
      */

  getThumbnailTask (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getThumbnailTask"
      )
    }

    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling getThumbnailTask"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getThumbnailTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/thumbnail/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取媒体处理通知
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param notification notification
      */

  getNotification (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getNotification"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getNotification with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/notification',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置媒体处理通知, 在设置Notification时会对endpoint进行校验, 设置时会对endpoint发一条SubscriptionConfirmation(x-jdcloud-message-type头)的通知, 要求把Message内容进行base64编码返回给系统(body)进行校验
      * @param {Object} opts - parameters
      * @param {boolean} opts.enabled - 是否启用通知
      * @param {string} [opts.endpoint] - 通知endpoint, 当前支持http://和https://  optional
      * @param {array} [opts.events] - 触发通知的事件集合 (mpsTranscodeComplete, mpsThumbnailComplete)  optional
      * @param {string} [opts.notifyStrategy] - 重试策略, BACKOFF_RETRY: 退避重试策略, 重试 3 次, 每次重试的间隔时间是 10秒 到 20秒 之间的随机值; EXPONENTIAL_DECAY_RETRY: 指数衰减重试, 重试 176 次, 每次重试的间隔时间指数递增至 512秒, 总计重试时间为1天; 每次重试的具体间隔为: 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512 ... 512 秒(共167个512)  optional
      * @param {string} [opts.notifyContentFormat] - 描述了向 Endpoint 推送的消息格式, JSON: 包含消息正文和消息属性, SIMPLIFIED: 消息体即用户发布的消息, 不包含任何属性信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setNotification (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setNotification"
      )
    }

    opts = opts || {}

    if (opts.enabled === undefined || opts.enabled === null) {
      throw new Error(
        "Missing the required parameter 'opts.enabled' when calling setNotification"
      )
    }

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.endpoint !== undefined && opts.endpoint !== null) {
      postBody['endpoint'] = opts.endpoint
    }
    if (opts.events !== undefined && opts.events !== null) {
      postBody['events'] = opts.events
    }
    if (opts.notifyStrategy !== undefined && opts.notifyStrategy !== null) {
      postBody['notifyStrategy'] = opts.notifyStrategy
    }
    if (
      opts.notifyContentFormat !== undefined &&
      opts.notifyContentFormat !== null
    ) {
      postBody['notifyContentFormat'] = opts.notifyContentFormat
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  mps/0.4.10'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setNotification with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/notification',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = MPS
