/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * UserRoom
 * 用户房间号管理
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'openjrtc'
Service._services[serviceId] = true

/**
 * openjrtc service.
 * @version 1.1.8
 */

class OPENJRTC extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'openjrtc.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  开启语音识别功能

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {integer} [opts.asrTaskType] - 语音识别场景 0-全部识别转文字  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  startAsrTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.asrTaskType !== undefined && opts.asrTaskType !== null) {
      postBody['asrTaskType'] = opts.asrTaskType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startAsrTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/startAsrTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭语音识别功能

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {integer} [opts.asrTaskType] - 语音识别场景 0-全部识别转文字  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  stopAsrTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.asrTaskType !== undefined && opts.asrTaskType !== null) {
      postBody['asrTaskType'] = opts.asrTaskType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopAsrTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/stopAsrTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户应用列表信息

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param appConentObject resultObject
      */

  describeApps (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeApps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/applications',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用信息:

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} callback - callback
      @return {Object} result
      * @param appInfoObject resultObject
      */

  describeApp (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeApp"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeApp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/applications/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用appKey

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} callback - callback
      @return {Object} result
      * @param appKeyInfoObject resultObject
      */

  describeAppKey (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeAppKey"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAppKey with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/applications/{appId}:describeAppKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建房间

      * @param {Object} opts - parameters
      * @param {string} [opts.roomName] - 房间名称  optional
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {integer} [opts.roomType] - 房间类型 1-小房间(音频单流订阅) 2-大房间(音频固定订阅)  optional
      * @param {integer} [opts.meetingType] - 会议类型 0-即时会议 1-预约会议  optional
      * @param {integer} [opts.peerId] - 用户ID(创建者ID)  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomInfoObj resultObject
      */

  createRoom (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.roomName !== undefined && opts.roomName !== null) {
      postBody['roomName'] = opts.roomName
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.roomType !== undefined && opts.roomType !== null) {
      postBody['roomType'] = opts.roomType
    }
    if (opts.meetingType !== undefined && opts.meetingType !== null) {
      postBody['meetingType'] = opts.meetingType
    }
    if (opts.peerId !== undefined && opts.peerId !== null) {
      postBody['peerId'] = opts.peerId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/createRoom',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取房间信息

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {string} callback - callback
      @return {Object} result
      * @param roomInfoObj resultObject
      */

  describeRoomInfo (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRoomInfo"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling describeRoomInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.roomId !== undefined && opts.roomId !== null) {
      queryParams['roomId'] = opts.roomId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoomInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/rooms/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改房间

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.roomId] - 房间ID  optional
      * @param {string} [opts.roomName] - 房间名称  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomInfoObj resultObject
      */

  updateRoom (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling updateRoom"
      )
    }

    let postBody = {}
    if (opts.roomId !== undefined && opts.roomId !== null) {
      postBody['roomId'] = opts.roomId
    }
    if (opts.roomName !== undefined && opts.roomName !== null) {
      postBody['roomName'] = opts.roomName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/rooms/{appId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除房间

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteRoom (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling deleteRoom"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling deleteRoom"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.roomId !== undefined && opts.roomId !== null) {
      queryParams['roomId'] = opts.roomId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/rooms/{appId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用下的房间列表
允许通过条件过滤查询，支持的过滤字段如下：
           - appId[eq] 按应用ID查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters] - 传参字段描述:
  appId:   应用ID
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomInfosObj resultObject
      */

  describeRooms (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRooms with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/rooms',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间实时在线人数

      * @param {Object} opts - parameters
      * @param {integer} opts.roomId - 房间ID
      * @param {string} callback - callback
      @return {Object} result
      * @param userOnlineNumInfo resultObject
      */

  describeRoomOnlineUserNum (opts, callback) {
    opts = opts || {}

    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling describeRoomOnlineUserNum"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      roomId: opts.roomId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoomOnlineUserNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRoomOnlineUserNum/{roomId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  移除房间内人员

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {array} [opts.peerIds] - peerId列表,最多支持20个peerId  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  removeRoomUser (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling removeRoomUser"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling removeRoomUser"
      )
    }

    let postBody = {}
    if (opts.peerIds !== undefined && opts.peerIds !== null) {
      postBody['peerIds'] = opts.peerIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId,
      roomId: opts.roomId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeRoomUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/roomUser/{appId}/removeUser/{roomId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  移除房间内所有人员

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {string} callback - callback
      @return {Object} result
      */

  removeAllRoomUsers (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling removeAllRoomUsers"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling removeAllRoomUsers"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId,
      roomId: opts.roomId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeAllRoomUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/roomUser/{appId}/removeAll/{roomId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间人数，通讯时长，最大支持查询7天的数据
允许通过条件过滤查询，支持的过滤字段如下：
           - appId[eq] 按应用ID精确查询(必填)
           - userRoomId[eq] 按房间ID精确查询(必填)
           - startTime[eq] 开始时间 UTC格式(必填)
           - endTime[eq] 截止时间 UTC格式 (必填)

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters] - 传参字段描述:
  appId:   应用ID (必填)
  userRoomId：业务接入方定义的且在JRTC系统内注册过的房间号(必填)
  startTime: 房间使用起始时间 UTC (必填)
  endTime：房间使用截止时间 UTC (必填)
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomUserNumInfos resultObject
      */

  describeOnlineUserNum (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeOnlineUserNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeOnlineUserNum',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间用户记录,最大支持查询7天的数据
允许通过条件过滤查询，支持的过滤字段如下：
           - appId[eq] 按应用ID精确查询 (必填)
           - startTime[eq] 开始时间 UTC格式 (必填)
           - endTime[eq] 截止时间 UTC格式 (必填)
           - userRoomId[eq] 按房间ID精确查询(必填)
           - userId[eq] 按用户ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters] - 传参字段描述:
  appId:   应用ID (必填)
  startTime: 房间使用起始时间 UTC格式 (必填)
  endTime：房间使用截止时间 UTC格式 (必填)
  userRoomId：业务接入方定义的且在JRTC系统内注册过的房间号(必填)
  userId：业务接入方定义的且在JRTC系统内注册过的用户id
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomUserRecordInfo resultObject
      */

  describeUserRecordByRoom (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserRecordByRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeUserRecordByRoom',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户端到端推流码率

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的用户房间号
      * @param {string} opts.userId - 业务接入方定义的且在JRTC系统内注册过的用户id
      * @param {string} opts.kind - audio/video
      * @param {string} opts.type - producer 发布流 consumer 订阅流
      * @param {string} opts.joinTime - 加入时间 UTC格式
      * @param {string} [opts.leaveTime] - 离开时间 UTC格式  optional
      * @param {string} [opts.fromUserId] - 业务接入方定义的且在JRTC系统内注册过的用户id type&#x3D;consumer时选择发送端用户id切换码率  optional
      * @param {string} [opts.period] - 粒度 支持 1m 1h 1d  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param streamBitRate content
      */

  describeP2pStreamBitRate (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeP2pStreamBitRate"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeP2pStreamBitRate"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling describeP2pStreamBitRate"
      )
    }
    if (opts.kind === undefined || opts.kind === null) {
      throw new Error(
        "Missing the required parameter 'opts.kind' when calling describeP2pStreamBitRate"
      )
    }
    if (opts.type === undefined || opts.type === null) {
      throw new Error(
        "Missing the required parameter 'opts.type' when calling describeP2pStreamBitRate"
      )
    }
    if (opts.joinTime === undefined || opts.joinTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.joinTime' when calling describeP2pStreamBitRate"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      queryParams['userId'] = opts.userId
    }
    if (opts.kind !== undefined && opts.kind !== null) {
      queryParams['kind'] = opts.kind
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.joinTime !== undefined && opts.joinTime !== null) {
      queryParams['joinTime'] = opts.joinTime
    }
    if (opts.leaveTime !== undefined && opts.leaveTime !== null) {
      queryParams['leaveTime'] = opts.leaveTime
    }
    if (opts.fromUserId !== undefined && opts.fromUserId !== null) {
      queryParams['fromUserId'] = opts.fromUserId
    }
    if (opts.period !== undefined && opts.period !== null) {
      queryParams['period'] = opts.period
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeP2pStreamBitRate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeP2pStreamBitRate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取历史音频、区分视频码率通讯时长

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} opts.startTime - 开始时间 UTC格式
      * @param {string} [opts.endTime] - 结束时间 UTC格式  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param callDurationByCodeRate content
      */

  describeCallDurationByCodeRate (opts, callback) {
    opts = opts || {}

    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling describeCallDurationByCodeRate"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCallDurationByCodeRate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeCallDurationByCodeRate',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取近7天通讯时长

      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param callDuration content
      */

  describeDailyCallDuration (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDailyCallDuration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeDailyCallDuration',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建用户

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userName] - 用户名称  optional
      * @param {string} [opts.userId] - 业务接入方的用户ID  optional
      * @param {boolean} [opts.temporary] - 是否临时用户  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param createUserResultObj resultObject
      */

  createUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.temporary !== undefined && opts.temporary !== null) {
      postBody['temporary'] = opts.temporary
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/createUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询peer对应的用户信息

      * @param {Object} opts - parameters
      * @param {integer} opts.peerId - peerId
      * @param {string} callback - callback
      @return {Object} result
      * @param userInfoObj resultObject
      */

  describeUserByPeer (opts, callback) {
    opts = opts || {}

    if (opts.peerId === undefined || opts.peerId === null) {
      throw new Error(
        "Missing the required parameter 'opts.peerId' when calling describeUserByPeer"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.peerId !== undefined && opts.peerId !== null) {
      queryParams['peerId'] = opts.peerId
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserByPeer with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeUserByPeer',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  下发混流任务

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {integer} [opts.layoutTemplate] - 布局模板-支持参数1  optional
      * @param {string} [opts.mainUserId] - 主人员userId  optional
      * @param {integer} [opts.outputType] - 输出类型 1：录制 2：旁路转推  optional
      * @param {string} [opts.outputName] - 输出名称  optional
      * @param {array} [opts.mcuUserInfos] - 参与混流人员参数  optional
      * @param {outputEncode} [opts.outputEncode] - 输出格式  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  startMcuTranscode (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.layoutTemplate !== undefined && opts.layoutTemplate !== null) {
      postBody['layoutTemplate'] = opts.layoutTemplate
    }
    if (opts.mainUserId !== undefined && opts.mainUserId !== null) {
      postBody['mainUserId'] = opts.mainUserId
    }
    if (opts.outputType !== undefined && opts.outputType !== null) {
      postBody['outputType'] = opts.outputType
    }
    if (opts.outputName !== undefined && opts.outputName !== null) {
      postBody['outputName'] = opts.outputName
    }
    if (opts.mcuUserInfos !== undefined && opts.mcuUserInfos !== null) {
      postBody['mcuUserInfos'] = opts.mcuUserInfos
    }
    if (opts.outputEncode !== undefined && opts.outputEncode !== null) {
      postBody['outputEncode'] = opts.outputEncode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startMcuTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/startMcuTranscode',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  中止混流任务

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  stopMcuTranscode (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopMcuTranscode with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/stopMcuTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发送自定义信令给房间内的人员
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {string} [opts.eventName] - 事件名称  optional
      * @param {string} [opts.message] - 自定义信令消息  optional
      * @param {integer} [opts.peerId] - peerId  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  sendMessageToUser (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessageToUser"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling sendMessageToUser"
      )
    }

    let postBody = {}
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.message !== undefined && opts.message !== null) {
      postBody['message'] = opts.message
    }
    if (opts.peerId !== undefined && opts.peerId !== null) {
      postBody['peerId'] = opts.peerId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId,
      roomId: opts.roomId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessageToUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/message/{appId}/toUser/{roomId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发送自定义信令给房间
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.roomId - 房间ID
      * @param {string} [opts.eventName] - 事件名称  optional
      * @param {string} [opts.message] - 自定义信令消息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  sendMessageToRoom (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessageToRoom"
      )
    }
    if (opts.roomId === undefined || opts.roomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.roomId' when calling sendMessageToRoom"
      )
    }

    let postBody = {}
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.message !== undefined && opts.message !== null) {
      postBody['message'] = opts.message
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId,
      roomId: opts.roomId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessageToRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/message/{appId}/toRoom/{roomId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加推流规则

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {array} [opts.rules] - 推流规则  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  addPushStreamRule (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.rules !== undefined && opts.rules !== null) {
      postBody['rules'] = opts.rules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addPushStreamRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/addPushStreamRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加录制规则

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {array} [opts.rules] - 录制规则  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  addRecordRule (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.rules !== undefined && opts.rules !== null) {
      postBody['rules'] = opts.rules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addRecordRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/addRecordRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  注册用户-将业务接入方用户体系的userId注册为jrtc系统内可识别和流转的用户id

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userName] - 用户名称  optional
      * @param {string} [opts.userId] - 业务接入方用户体系定义的userId  optional
      * @param {boolean} [opts.temporary] - 是否临时用户  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param registerUserResultObj resultObject
      */

  registerUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.temporary !== undefined && opts.temporary !== null) {
      postBody['temporary'] = opts.temporary
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call registerUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/registerUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询注册用户

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userId - 业务接入方用户体系定义的且在JRTC系统内注册过的userId
      * @param {string} callback - callback
      @return {Object} result
      * @param registerUserInfoObj resultObject
      */

  describeRegisterUser (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRegisterUser"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling describeRegisterUser"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userId !== undefined && opts.userId !== null) {
      queryParams['userId'] = opts.userId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRegisterUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRegisterUser/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询注册用户列表
允许通过条件过滤查询，支持的过滤字段如下：
           - startTime[eq] 用户注册时间段开始时间-UTC时间 startTime,endTime同时有值时生效
           - endTime[eq] 用户注册时间段结束时间-UTC时间 startTime,endTime同时有值时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters] - 传参字段描述:
  startTime[eq]:   用户注册时间段开始时间-UTC时间 startTime,endTime同时有值时生效
  endTime[eq]:     用户注册时间段结束时间-UTC时间 startTime,endTime同时有值时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param registerUserInfosObj resultObject
      */

  describeRegisterUsers (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRegisterUsers"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRegisterUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRegisterUsers/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间内推流信息列表
允许通过条件过滤查询，支持的过滤字段如下：
           - status[eq] 在线状态 1-在线 2-离线
           - kind[eq] 在线状态 1-音频流 2-视频流 100-数据流
           - startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
           - endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {filter} [opts.filters] - 传参字段描述:
- status[eq] 在线状态 1-在线 2-离线
- kind[eq] 在线状态 1-音频流 2-视频流 100-数据流
- startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
- endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomStreamContent resultObject
      */

  describeStreamInfosByUserRoomId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeStreamInfosByUserRoomId"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeStreamInfosByUserRoomId"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeStreamInfosByUserRoomId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeStreamInfosByUserRoomId/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询指定用户在房间内的推流信息

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {string} opts.userId - 业务接入方用户体系定义的且在JRTC系统内注册过的userId
      * @param {string} callback - callback
      @return {Object} result
      * @param streamInfo content
      */

  describeStreamInfosByUserId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeStreamInfosByUserId"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeStreamInfosByUserId"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling describeStreamInfosByUserId"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      queryParams['userId'] = opts.userId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeStreamInfosByUserId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeStreamInfosByUserId/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据流ID查询推流信息

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.streamId - 流ID
      * @param {string} callback - callback
      @return {Object} result
      * @param streamInfo resultObject
      */

  describeStreamInfoByStreamId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeStreamInfoByStreamId"
      )
    }
    if (opts.streamId === undefined || opts.streamId === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamId' when calling describeStreamInfoByStreamId"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.streamId !== undefined && opts.streamId !== null) {
      queryParams['streamId'] = opts.streamId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeStreamInfoByStreamId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeStreamInfoByStreamId/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询指定用户在房间内的推流历史记录
允许通过条件过滤查询，支持的过滤字段如下：
           - kind[eq] 在线状态 1-音频流 2-视频流 100-数据流
           - startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
           - endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {string} opts.userId - 业务接入方用户体系定义的且在JRTC系统内注册过的userId
      * @param {filter} [opts.filters] - 传参字段描述:
- kind[eq] 在线状态 1-音频流 2-视频流 100-数据流
- startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
- endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param streamRecordContent resultObject
      */

  describeStreamRecordsByUserId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeStreamRecordsByUserId"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeStreamRecordsByUserId"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling describeStreamRecordsByUserId"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      queryParams['userId'] = opts.userId
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeStreamRecordsByUserId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeStreamRecordsByUserId/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据流ID查询推流历史记录
允许通过条件过滤查询，支持的过滤字段如下：
           - startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
           - endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} opts.streamId - 流ID
      * @param {filter} [opts.filters] - 传参字段描述:
- startTime[eq] 用户推流开始时间-UTC时间  startTime,endTime同时指定时生效
- endTime[eq]   用户推流结束时间-UTC时间  startTime,endTime同时指定时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param streamRecordContent resultObject
      */

  describeStreamRecordsByStreamId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeStreamRecordsByStreamId"
      )
    }
    if (opts.streamId === undefined || opts.streamId === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamId' when calling describeStreamRecordsByStreamId"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.streamId !== undefined && opts.streamId !== null) {
      queryParams['streamId'] = opts.streamId
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeStreamRecordsByStreamId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeStreamRecordsByStreamId/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  移除房间内人员

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {array} [opts.userIds] - 接入方定义的userId列表,最多支持20个userId  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  removeUserByUserRoomId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling removeUserByUserRoomId"
      )
    }

    let postBody = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.userIds !== undefined && opts.userIds !== null) {
      postBody['userIds'] = opts.userIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeUserByUserRoomId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/removeUserByUserRoomId/{appId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  移除房间内所有人员

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  removeAllUsersByUserRoomId (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling removeAllUsersByUserRoomId"
      )
    }

    let postBody = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call removeAllUsersByUserRoomId with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/removeAllUsersByUserRoomId/{appId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间内人员列表
允许通过条件过滤查询，支持的过滤字段如下：
           - status[eq] 在线状态 1-在线 2-离线
           - startTime[eq] 用户加入时间段开始时间-UTC时间  startTime,endTime同时有值时生效
           - endTime[eq] 用户加入时间段结束时间-UTC时间    startTime,endTime同时有值时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {filter} [opts.filters] - 传参字段描述:
- status[eq] 在线状态 1-在线 2-离线
- startTime[eq] 用户加入时间段开始时间-UTC时间 startTime,endTime同时有值时生效
- endTime[eq] 用户加入时间段结束时间-UTC时间   startTime,endTime同时有值时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param roomUserInfosObj resultObject
      */

  describeRoomUsers (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRoomUsers"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeRoomUsers"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoomUsers with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRoomUsers/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询房间内的人员信息

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {string} opts.userId - 业务接入方用户体系定义的且在JRTC系统内注册过的userId
      * @param {string} callback - callback
      @return {Object} result
      * @param roomUserInfoObj resultObject
      */

  describeRoomUser (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRoomUser"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeRoomUser"
      )
    }
    if (opts.userId === undefined || opts.userId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userId' when calling describeRoomUser"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      queryParams['userId'] = opts.userId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoomUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRoomUser/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  统计房间内人数

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {string} callback - callback
      @return {Object} result
      * @param roomUsersNumInfoObj resultObject
      */

  describeRoomUsersNum (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeRoomUsersNum"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeRoomUsersNum"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeRoomUsersNum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeRoomUsersNum/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭房间内的指定流

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {string} [opts.userId] - 业务接入方用户体系定义的且在JRTC系统内注册过的userId  optional
      * @param {string} [opts.streamId] - 要关闭的流ID  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  closeRoomUserStream (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling closeRoomUserStream"
      )
    }

    let postBody = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.streamId !== undefined && opts.streamId !== null) {
      postBody['streamId'] = opts.streamId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call closeRoomUserStream with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/closeRoomUserStream/{appId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  生成token-用户加入房间时携带token校验通过后方能加入

      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - appId  optional
      * @param {string} [opts.appKey] - appKey  optional
      * @param {string} [opts.userId] - 用户id  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {integer} [opts.timestamp] - 时间戳-毫秒  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param tokenInfo resultObject
      */

  createToken (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.appKey !== undefined && opts.appKey !== null) {
      postBody['appKey'] = opts.appKey
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.timestamp !== undefined && opts.timestamp !== null) {
      postBody['timestamp'] = opts.timestamp
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createToken with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/createToken',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发送自定义信令给房间
      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {string} [opts.eventName] - 事件名称  optional
      * @param {string} [opts.message] - 自定义信令消息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  postMessageToUserRoom (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.message !== undefined && opts.message !== null) {
      postBody['message'] = opts.message
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call postMessageToUserRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/postMessageToUserRoom',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  发送自定义信令给房间内的人员
      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {string} [opts.userRoomId] - 业务接入方定义的且在JRTC系统内注册过的房间号  optional
      * @param {string} [opts.userId] - 业务接入方用户体系定义的且在JRTC系统内注册过的userId  optional
      * @param {string} [opts.eventName] - 事件名称  optional
      * @param {string} [opts.message] - 自定义信令消息  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  postMessageToUser (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.userId !== undefined && opts.userId !== null) {
      postBody['userId'] = opts.userId
    }
    if (opts.eventName !== undefined && opts.eventName !== null) {
      postBody['eventName'] = opts.eventName
    }
    if (opts.message !== undefined && opts.message !== null) {
      postBody['message'] = opts.message
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call postMessageToUser with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/postMessageToUser',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  注册用户房间号-将业务接入方定义的userRoomId注册为jrtc系统内可识别和流转的房间号

      * @param {Object} opts - parameters
      * @param {string} [opts.userRoomId] - 业务接入方定义的房间号  optional
      * @param {string} [opts.roomName] - 房间名称  optional
      * @param {string} [opts.appId] - 应用ID  optional
      * @param {integer} [opts.roomType] - 房间类型 1-小房间(音频单流订阅) 2-大房间(音频固定订阅),默认取控制台APP对应的房间类型  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param userRoomInfoObj resultObject
      */

  registerUserRoom (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.roomName !== undefined && opts.roomName !== null) {
      postBody['roomName'] = opts.roomName
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.roomType !== undefined && opts.roomType !== null) {
      postBody['roomType'] = opts.roomType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call registerUserRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/registerUserRoom',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改房间

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} [opts.userRoomId] - 用户房间号  optional
      * @param {string} [opts.roomName] - 房间名称  optional
      * @param {integer} [opts.roomType] - 房间类型 1-小房间；2-大房间  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param userRoomInfoObj resultObject
      */

  updateUserRoom (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling updateUserRoom"
      )
    }

    let postBody = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      postBody['userRoomId'] = opts.userRoomId
    }
    if (opts.roomName !== undefined && opts.roomName !== null) {
      postBody['roomName'] = opts.roomName
    }
    if (opts.roomType !== undefined && opts.roomType !== null) {
      postBody['roomType'] = opts.roomType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateUserRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/updateUserRoom/{appId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询注册房间号

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.userRoomId - 业务接入方定义的且在JRTC系统内注册过的房间号
      * @param {string} callback - callback
      @return {Object} result
      * @param userRoomInfoObj resultObject
      */

  describeUserRoom (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeUserRoom"
      )
    }
    if (opts.userRoomId === undefined || opts.userRoomId === null) {
      throw new Error(
        "Missing the required parameter 'opts.userRoomId' when calling describeUserRoom"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userRoomId !== undefined && opts.userRoomId !== null) {
      queryParams['userRoomId'] = opts.userRoomId
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserRoom with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeUserRoom/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询注册房间号列表
允许通过条件过滤查询，支持的过滤字段如下：
           - startTime[eq] 房间注册时间段开始时间-UTC时间 startTime,endTime同时有值时生效
           - endTime[eq] 房间注册时间段结束时间-UTC时间   startTime,endTime同时有值时生效

      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters] - 传参字段描述:
  - startTime[eq] 按房间注册时间段查询-UTC时间 startTime,endTime同时有值时生效
  - endTime[eq] 按房间注册时间段查询-UTC时间   startTime,endTime同时有值时生效
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param userRoomInfosObj resultObject
      */

  describeUserRooms (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling describeUserRooms"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  openjrtc/1.1.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserRooms with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/describeUserRooms/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = OPENJRTC
