/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 私有域名zone
 * 私有域名zone API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'privatezone'
Service._services[serviceId] = true

/**
 * privatezone service.
 * @version 0.0.1
 */

class PRIVATEZONE extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'privatezone.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询操作日志

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageSize] - 页容量，默认10，取值范围(1 - 100)  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认值1，不能小于1  optional
      * @param {string} opts.start - 起始时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 结束时间，格式：UTC时间例如2017-11-10T23:00:00Z
      * @param {string} [opts.keyWord] - 日志模糊匹配的关键词  optional
      * @param {boolean} [opts.success] - 操作结果 false-&gt;失败 true-&gt;成功  optional
      * @param {string} [opts.actionType] - 日志类型，支持的类型有：CREATE_ZONE、DELETE_ZONE、LOCK_ZONE、CREATE_RR、MODIFY_RR、DELETE_RR、SET_RR_STATUS、RETRY_RECURSE_ZONE  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeActionLogsRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describeActionLogs (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeActionLogs"
      )
    }

    opts = opts || {}

    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling describeActionLogs"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling describeActionLogs"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }
    if (opts.keyWord !== undefined && opts.keyWord !== null) {
      queryParams['keyWord'] = opts.keyWord
    }
    if (opts.success !== undefined && opts.success !== null) {
      queryParams['success'] = opts.success
    }
    if (opts.actionType !== undefined && opts.actionType !== null) {
      queryParams['actionType'] = opts.actionType
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeActionLogs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/actionLogs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询实例信息

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageSize] - 页容量，默认10，取值范围(1 - 100)  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认1，不能小于1  optional
      * @param {string} [opts.instanceId] - 实例ID  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeInstancesRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describeInstances (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInstances"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      queryParams['instanceId'] = opts.instanceId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInstances with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询解析记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} [opts.hostRecord] - 主机记录左右模糊查询  optional
      * @param {integer} [opts.pageSize] - 页容量，默认10，取值范围(1 - 100)  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认1，不能小于1  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeResourceRecordsRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describeResourceRecords (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeResourceRecords"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling describeResourceRecords"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.hostRecord !== undefined && opts.hostRecord !== null) {
      queryParams['hostRecord'] = opts.hostRecord
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeResourceRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建解析记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {} [opts.hostRecord] - 主机记录  optional
      * @param {} [opts.hostValue] - 主机记录值  optional
      * @param {} [opts.recordType] - 解析类型，目前支持类型 A AAAA CNAME TXT CAA SRV MX PTR  optional
      * @param {} [opts.ttl] - TTL值  optional
      * @param {} [opts.priority] - 优先级，只存在于MX, SRV解析记录类型  optional
      * @param {} [opts.port] - 端口，只存在于SRV解析记录类型  optional
      * @param {} [opts.weight] - 解析记录的权重，目前支持权重的有：A/AAAA/CNAME，A/AAAA权重范围0-100，CNAME权重范围1-100。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling createResourceRecord"
      )
    }

    let postBody = {}
    if (opts.hostRecord !== undefined && opts.hostRecord !== null) {
      postBody['hostRecord'] = opts.hostRecord
    }
    if (opts.hostValue !== undefined && opts.hostValue !== null) {
      postBody['hostValue'] = opts.hostValue
    }
    if (opts.recordType !== undefined && opts.recordType !== null) {
      postBody['recordType'] = opts.recordType
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.weight !== undefined && opts.weight !== null) {
      postBody['weight'] = opts.weight
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改解析记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} opts.resourceRecordId - 解析记录ID
      * @param {} [opts.hostRecord] - 主机记录  optional
      * @param {} [opts.hostValue] - 主机记录值  optional
      * @param {} [opts.recordType] - 解析类型，目前支持类型 A AAAA CNAME TXT CAA SRV MX PTR  optional
      * @param {} [opts.ttl] - TTL值  optional
      * @param {} [opts.priority] - 优先级，只存在于MX, SRV解析记录类型  optional
      * @param {} [opts.port] - 端口，只存在于SRV解析记录类型  optional
      * @param {} [opts.weight] - 解析记录的权重，目前支持权重的有：A/AAAA/CNAME，A/AAAA权重范围0-100，CNAME权重范围1-100。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyResourceRecord (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyResourceRecord"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling modifyResourceRecord"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling modifyResourceRecord"
      )
    }

    let postBody = {}
    if (opts.hostRecord !== undefined && opts.hostRecord !== null) {
      postBody['hostRecord'] = opts.hostRecord
    }
    if (opts.hostValue !== undefined && opts.hostValue !== null) {
      postBody['hostValue'] = opts.hostValue
    }
    if (opts.recordType !== undefined && opts.recordType !== null) {
      postBody['recordType'] = opts.recordType
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.port !== undefined && opts.port !== null) {
      postBody['port'] = opts.port
    }
    if (opts.weight !== undefined && opts.weight !== null) {
      postBody['weight'] = opts.weight
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyResourceRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecord/{resourceRecordId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除解析记录。批量删除时多个resourceRecordId用&quot;,&quot;分隔。批量删除每次最多不超过100个记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} opts.resourceRecordId - 解析记录ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteResourceRecords (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteResourceRecords"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling deleteResourceRecords"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling deleteResourceRecords"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteResourceRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords/{resourceRecordId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置解析记录状态，STOP操作会将停止该记录的解析，直到再次START。批量设置时多个resourceRecordId用&quot;,&quot;分隔。批量设置时每次最多不超过100个记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} opts.resourceRecordId - 解析记录ID
      * @param {string} opts.status - 解析记录状态 START-&gt;正常解析 STOP-&gt;停止解析
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setResourceRecordsStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setResourceRecordsStatus"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling setResourceRecordsStatus"
      )
    }
    if (opts.resourceRecordId === undefined || opts.resourceRecordId === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceRecordId' when calling setResourceRecordsStatus"
      )
    }
    if (opts.status === undefined || opts.status === null) {
      throw new Error(
        "Missing the required parameter 'opts.status' when calling setResourceRecordsStatus"
      )
    }

    let postBody = {}
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId,
      resourceRecordId: opts.resourceRecordId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setResourceRecordsStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords/{resourceRecordId}/status',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  导出当前zone下所有解析记录，返回的数据是可以转换为csv文件格式的字符串

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string data  导出数据结果，此结果是可以存储为csv文件格式的字符串
      */

  exportResourceRecords (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  exportResourceRecords"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling exportResourceRecords"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call exportResourceRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords:export',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量导入解析记录，批量导入每次不可超过100条记录

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {array} opts.importResourceRecordsReq - 导入的解析记录数据
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  importResourceRecords (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  importResourceRecords"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling importResourceRecords"
      )
    }
    if (
      opts.importResourceRecordsReq === undefined ||
      opts.importResourceRecordsReq === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.importResourceRecordsReq' when calling importResourceRecords"
      )
    }

    let postBody = {}
    if (
      opts.importResourceRecordsReq !== undefined &&
      opts.importResourceRecordsReq !== null
    ) {
      postBody['importResourceRecordsReq'] = opts.importResourceRecordsReq
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call importResourceRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/resourceRecords:import',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  统计zone的解析量

      * @param {Object} opts - parameters
      * @param {string} opts.start - 查询时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 查询时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {array} [opts.zoneIds] - 查询的zone id，默认查询所有zone  optional
      * @param {array} [opts.vpcIds] - 查询的vpc id，默认查询所有vpc  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param integer traffic
      */

  zoneResolveCount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  zoneResolveCount"
      )
    }

    opts = opts || {}

    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling zoneResolveCount"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling zoneResolveCount"
      )
    }

    let postBody = {}
    if (opts.start !== undefined && opts.start !== null) {
      postBody['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      postBody['end'] = opts.end
    }
    if (opts.zoneIds !== undefined && opts.zoneIds !== null) {
      postBody['zoneIds'] = opts.zoneIds
    }
    if (opts.vpcIds !== undefined && opts.vpcIds !== null) {
      postBody['vpcIds'] = opts.vpcIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneResolveCount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/stat:zoneResolveCount',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  统计zone的流量

      * @param {Object} opts - parameters
      * @param {string} opts.start - 查询时间段的起始时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {string} opts.end - 查询时间段的终止时间, UTC时间格式，例如2017-11-10T23:00:00Z
      * @param {array} [opts.zoneIds] - 查询的zone id，默认查询所有zone  optional
      * @param {array} [opts.vpcIds] - 查询的vpc id，默认查询所有vpc  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer time
      * @param string unit  数据序列的单位
      * @param number traffic
      */

  zoneFlowCount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  zoneFlowCount"
      )
    }

    opts = opts || {}

    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling zoneFlowCount"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling zoneFlowCount"
      )
    }

    let postBody = {}
    if (opts.start !== undefined && opts.start !== null) {
      postBody['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      postBody['end'] = opts.end
    }
    if (opts.zoneIds !== undefined && opts.zoneIds !== null) {
      postBody['zoneIds'] = opts.zoneIds
    }
    if (opts.vpcIds !== undefined && opts.vpcIds !== null) {
      postBody['vpcIds'] = opts.vpcIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneFlowCount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/stat:zoneFlowCount',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询私有解析zone列表

      * @param {Object} opts - parameters
      * @param {string} [opts.zone] - zone模块匹配查询  optional
      * @param {string} [opts.instanceId] - 购买的套餐实例ID  optional
      * @param {string} [opts.zoneId] - 根据zoneId精准查询(zone模糊查询失效)  optional
      * @param {integer} [opts.pageSize] - 页容量，默认10，取值范围(1 - 100)  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认1，不能小于1  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeZonesRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describeZones (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeZones"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.zone !== undefined && opts.zone !== null) {
      queryParams['zone'] = opts.zone
    }
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      queryParams['instanceId'] = opts.instanceId
    }
    if (opts.zoneId !== undefined && opts.zoneId !== null) {
      queryParams['zoneId'] = opts.zoneId
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeZones with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zones',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  - 添加一个私有解析的zone，可添加以下三种类型的zone
- 云内全局zone：zone的后缀是指定的后缀，如：local。该域名在云内自动全局生效，不用关联vpc即可在vpc内解析，该类型全局唯一，不能重复添加
- 反向解析zone：zone的后缀是in-addr.arpa时，我们认为他是一个反向解析的zone，反向解析域名前缀目前支持10/172.16-31/192.168网段，如：10.in-addr.arpa、16.172.in-addr.arpa。反向解析的zone只能添加反向解析的记录
- 私有解析zone：该类型的zone可以时任意符合格式的域名，私有解析zone需要关联vpc后，在vpc内生效解析

      * @param {Object} opts - parameters
      * @param {string} opts.zone - zone
      * @param {string} opts.instanceId - 购买的套餐实例ID
      * @param {string} opts.zoneType - 域名类型 LOCAL-&gt;云内全局 PTR-&gt;反向解析zone PV-&gt;私有zone
      * @param {boolean} [opts.retryRecurse] - 解析失败后是否进行递归解析  optional
      * @param {array} [opts.bindVpc] - 绑定的vpc信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createZone (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createZone"
      )
    }

    opts = opts || {}

    if (opts.zone === undefined || opts.zone === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone' when calling createZone"
      )
    }
    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createZone"
      )
    }
    if (opts.zoneType === undefined || opts.zoneType === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneType' when calling createZone"
      )
    }

    let postBody = {}
    if (opts.zone !== undefined && opts.zone !== null) {
      postBody['zone'] = opts.zone
    }
    if (opts.instanceId !== undefined && opts.instanceId !== null) {
      postBody['instanceId'] = opts.instanceId
    }
    if (opts.zoneType !== undefined && opts.zoneType !== null) {
      postBody['zoneType'] = opts.zoneType
    }
    if (opts.retryRecurse !== undefined && opts.retryRecurse !== null) {
      postBody['retryRecurse'] = opts.retryRecurse
    }
    if (opts.bindVpc !== undefined && opts.bindVpc !== null) {
      postBody['bindVpc'] = opts.bindVpc
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zones',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除zone，该zone下的解析记录和绑定的vpc关联关系将会被删除

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteZone (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteZone"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling deleteZone"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  解析失败后，尝试递归解析开关

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {boolean} opts.retryRecurse - true-&gt;解析失败后尝试递归解析 false-&gt;解析失败后不进行递归解析
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  retryRecurse (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  retryRecurse"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling retryRecurse"
      )
    }
    if (opts.retryRecurse === undefined || opts.retryRecurse === null) {
      throw new Error(
        "Missing the required parameter 'opts.retryRecurse' when calling retryRecurse"
      )
    }

    let postBody = {}
    if (opts.retryRecurse !== undefined && opts.retryRecurse !== null) {
      postBody['retryRecurse'] = opts.retryRecurse
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call retryRecurse with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}:retryRecurse',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定vpc
- vpc信息为空时，会将之前的绑定关系全部解除
- 该接口为覆盖类的接口，请将需要的vpc全部进行绑定

      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - zone id
      * @param {array} [opts.bindVpc] - 绑定的vpc信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  bindVpc (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  bindVpc"
      )
    }

    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling bindVpc"
      )
    }

    let postBody = {}
    if (opts.bindVpc !== undefined && opts.bindVpc !== null) {
      postBody['bindVpc'] = opts.bindVpc
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  privatezone/0.0.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindVpc with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/zone/{zoneId}/vpc:bind',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = PRIVATEZONE
