/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Redis SpecConfig API
 * 缓存Redis实例规格配置接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'redis'
Service._services[serviceId] = true

/**
 * redis service.
 * @version 2.6.32
 */

class REDIS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'redis.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询支持的地域列表
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param availableRegion availableRegions
      */

  describeAvailableRegion (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAvailableRegion"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAvailableRegion with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/availableRegion',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询支持的规格列表
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param availableResource availableResources
      */

  describeAvailableResource (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAvailableResource"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAvailableResource with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/availableResource',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询支持的规格列表
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param availableResource availableResources
      */

  describeAvailableResource2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAvailableResource2"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAvailableResource2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/availableResource2',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例列表，可分页、可排序、可搜索、可过滤
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码：取值范围[1,∞)，默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小：取值范围[10, 100]，默认为10  optional
      * @param {filter} [opts.filters] - 过滤属性：
cacheInstanceId - 实例Id，精确匹配，可选择多个
cacheInstanceName - 实例名称，模糊匹配
cacheInstanceStatus - 实例状态，精确匹配，可选择多个(running：运行中，error：错误，creating：创建中，changing：变配中，configuring：参数修改中，restoring：备份恢复中，deleting：删除中)
redisVersion - redis引擎版本，精确匹配，可选择2.8和4.0
instanceType - 实例类型，精确匹配（redis表示主从版，redis_cluster表示集群版）
chargeMode - 计费类型，精确匹配（prepaid_by_duration表示包年包月预付费，postpaid_by_duration表示按配置后付费）
  optional
      * @param {tagFilter} [opts.tagFilters] - 标签的过滤条件  optional
      * @param {sort} [opts.sorts] - 排序属性：
createTime - 按创建时间排序(asc表示按时间正序，desc表示按时间倒序)
  optional
      * @param {string} [opts.resourceGroupIds]   optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cacheInstance cacheInstances
      * @param integer totalCount  实例总数
      */

  describeCacheInstances (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCacheInstances"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(
      queryParams,
      super.buildTagFilterParam(opts.tagFilters, 'tagFilters')
    )
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))
    Object.assign(
      queryParams,
      super.buildArrayParam(opts.resourceGroupIds, 'resourceGroupIds')
    )

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCacheInstances with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建一个指定配置的缓存Redis实例：可选择版本、类型、规格（按CPU核数、内存容量、磁盘容量、带宽等划分），自定义分片规格可通过describeSpecConfig接口获取，老规格代码请参考，https://docs.jdcloud.com/cn/jcs-for-redis/specifications

      * @param {Object} opts - parameters
      * @param {cacheInstanceSpec} opts.cacheInstance - 实例的创建参数
      * @param {chargeSpec} [opts.charge] - 实例的计费类型  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string cacheInstanceId  实例ID
      * @param string orderNum  订单编号
      * @param string buyId  购买ID
      */

  createCacheInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createCacheInstance"
      )
    }

    opts = opts || {}

    if (opts.cacheInstance === undefined || opts.cacheInstance === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstance' when calling createCacheInstance"
      )
    }

    let postBody = {}
    if (opts.cacheInstance !== undefined && opts.cacheInstance !== null) {
      postBody['cacheInstance'] = opts.cacheInstance
    }
    if (opts.charge !== undefined && opts.charge !== null) {
      postBody['charge'] = opts.charge
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCacheInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例的详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cacheInstance cacheInstance  实例的详细信息
      */

  describeCacheInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCacheInstance"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeCacheInstance"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCacheInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改缓存Redis实例的资源名称或描述，二者至少选一
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.cacheInstanceName] - 实例的名称，名称只支持数字、字母、英文下划线、中文，且不少于2字符不超过32字符  optional
      * @param {string} [opts.cacheInstanceDescription] - 实例的描述，不能超过256个字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyCacheInstanceAttribute (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyCacheInstanceAttribute"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyCacheInstanceAttribute"
      )
    }

    let postBody = {}
    if (
      opts.cacheInstanceName !== undefined &&
      opts.cacheInstanceName !== null
    ) {
      postBody['cacheInstanceName'] = opts.cacheInstanceName
    }
    if (
      opts.cacheInstanceDescription !== undefined &&
      opts.cacheInstanceDescription !== null
    ) {
      postBody['cacheInstanceDescription'] = opts.cacheInstanceDescription
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyCacheInstanceAttribute with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除按配置计费、或包年包月已到期的缓存Redis实例，包年包月未到期不可删除。
只有处于运行running或者错误error状态才可以删除，其余状态不可以删除。
白名单用户不能删除包年包月已到期的缓存Redis实例。

      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCacheInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCacheInstance"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling deleteCacheInstance"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCacheInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  变更缓存Redis实例规格（变配），实例运行时可以变配，新规格不能与之前的老规格相同，新规格内存大小不能小于实例的已使用内存

      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.cacheInstanceClass - 新规格
      * @param {integer} [opts.shardNumber] - 自定义分片数，只对自定义分片规格实例有效  optional
      * @param {boolean} [opts.parallel] - 是否开启4.0集群并行变配  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string orderNum  订单编号
      * @param string buyId  购买ID
      */

  modifyCacheInstanceClass (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyCacheInstanceClass"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyCacheInstanceClass"
      )
    }
    if (
      opts.cacheInstanceClass === undefined ||
      opts.cacheInstanceClass === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceClass' when calling modifyCacheInstanceClass"
      )
    }

    let postBody = {}
    if (
      opts.cacheInstanceClass !== undefined &&
      opts.cacheInstanceClass !== null
    ) {
      postBody['cacheInstanceClass'] = opts.cacheInstanceClass
    }
    if (opts.shardNumber !== undefined && opts.shardNumber !== null) {
      postBody['shardNumber'] = opts.shardNumber
    }
    if (opts.parallel !== undefined && opts.parallel !== null) {
      postBody['parallel'] = opts.parallel
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyCacheInstanceClass with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}:modifyCacheInstanceClass',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Red4.0实例是否支持新变配功能，是否支持并行变配, 变配需要的IP数量及变配预估时间

      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.cacheInstanceClass] - 新规格。不传参只返回是否支持新变配功能。  optional
      * @param {integer} [opts.shardNumber] - 自定义分片数。不传参只返回是否支持新变配功能。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean supportPScale  是否支持新变配
      * @param boolean supportParallel  是否支持并行变配
      * @param integer serialIpCount  串行变配需要的IP数量
      * @param integer serialTimeCost  串行变配预估时间
      * @param integer parallelIpCount  并行变配需要的IP数量
      * @param integer parallelTimeCost  并行变配预估时间
      */

  describeResizeModeIpTimeInfo (
    opts,
    regionId = this.config.regionId,
    callback
  ) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeResizeModeIpTimeInfo"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeResizeModeIpTimeInfo"
      )
    }

    let postBody = {}
    if (
      opts.cacheInstanceClass !== undefined &&
      opts.cacheInstanceClass !== null
    ) {
      postBody['cacheInstanceClass'] = opts.cacheInstanceClass
    }
    if (opts.shardNumber !== undefined && opts.shardNumber !== null) {
      postBody['shardNumber'] = opts.shardNumber
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeResizeModeIpTimeInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/describeResizeModeIpTimeInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改缓存Redis实例的密码，可为空
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.password] - 密码，为空即为免密，不少于8字符不超过16字符  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  resetCacheInstancePassword (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  resetCacheInstancePassword"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling resetCacheInstancePassword"
      )
    }

    let postBody = {}
    if (opts.password !== undefined && opts.password !== null) {
      postBody['password'] = opts.password
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call resetCacheInstancePassword with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}:resetCacheInstancePassword',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看缓存Redis实例的当前配置参数
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string unSupportConfigs
      * @param configItem instanceConfig
      */

  describeInstanceConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInstanceConfig"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeInstanceConfig"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInstanceConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/instanceConfig',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改缓存Redis实例的配置参数，支持部分配置参数修改
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {array} opts.instanceConfig - 配置参数名和参数值
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyInstanceConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyInstanceConfig"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyInstanceConfig"
      )
    }
    if (opts.instanceConfig === undefined || opts.instanceConfig === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceConfig' when calling modifyInstanceConfig"
      )
    }

    let postBody = {}
    if (opts.instanceConfig !== undefined && opts.instanceConfig !== null) {
      postBody['instanceConfig'] = opts.instanceConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyInstanceConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/instanceConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string time  -表示为关闭，HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      */

  describeAnalysisTime (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAnalysisTime"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeAnalysisTime"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAnalysisTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/analysisTime',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.analysisTime - 自动缓存分析时间，设置为-表示关闭，否则为：HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyAnalysisTime (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAnalysisTime"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyAnalysisTime"
      )
    }
    if (opts.analysisTime === undefined || opts.analysisTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.analysisTime' when calling modifyAnalysisTime"
      )
    }

    let postBody = {}
    if (opts.analysisTime !== undefined && opts.analysisTime !== null) {
      postBody['analysisTime'] = opts.analysisTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAnalysisTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/analysisTime',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存分析任务列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.date - 格式:yyyy-MM-dd,表示查询某一天的缓存分析列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cacheAnalysis analyses
      */

  describeCacheAnalysisList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCacheAnalysisList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeCacheAnalysisList"
      )
    }
    if (opts.date === undefined || opts.date === null) {
      throw new Error(
        "Missing the required parameter 'opts.date' when calling describeCacheAnalysisList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.date !== undefined && opts.date !== null) {
      queryParams['date'] = opts.date
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCacheAnalysisList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/cacheAnalysis',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建缓存分析任务，一天最多创建12次分析任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.sizeMode] - 计算大key的方式。若为elementCounts，则使用元素个数计算大key；若为memorySize，则使用内存大小计算大key。默认为memorySize。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createCacheAnalysis (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createCacheAnalysis"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling createCacheAnalysis"
      )
    }

    let postBody = {}
    if (opts.sizeMode !== undefined && opts.sizeMode !== null) {
      postBody['sizeMode'] = opts.sizeMode
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCacheAnalysis with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/cacheAnalysis',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存分析任务详情，最多查询到30天前的数据
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.taskId - 任务ID，即request ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime  任务开始时间, rfc3339格式
      * @param string finishTime  任务结束时间, rfc3339格式
      * @param integer analysisType  任务类型，0:手动分析，1自动分析
      * @param redisKey stringBigKeys
      * @param redisKey otherBigKeys
      * @param redisKey hotKeys
      * @param redisCmd cmdCallTimesTop
      * @param redisCmd cmdUseCpuTop
      * @param object keyTypeDistribution  key的类型分布
      * @param object keySizeDistribution  key的大小分布
      */

  describeCacheAnalysisResult (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeCacheAnalysisResult"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeCacheAnalysisResult"
      )
    }
    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeCacheAnalysisResult"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId,
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCacheAnalysisResult with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/cacheAnalysis/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询当前客户端IP列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param ips ips
      */

  describeClientList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeClientList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeClientList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeClientList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/clientList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询指定客户端IP的连接详细信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.ip - 客户端IP
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param details details
      */

  describeClientIpDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeClientIpDetail"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeClientIpDetail"
      )
    }
    if (opts.ip === undefined || opts.ip === null) {
      throw new Error(
        "Missing the required parameter 'opts.ip' when calling describeClientIpDetail"
      )
    }

    let postBody = {}
    if (opts.ip !== undefined && opts.ip !== null) {
      postBody['ip'] = opts.ip
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeClientIpDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/clientIpDetail',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例的备份任务（文件）列表，可分页、可指定起止时间或备份任务ID
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} [opts.startTime] - 开始时间  optional
      * @param {string} [opts.endTime] - 结束时间  optional
      * @param {string} [opts.baseId] - 备份任务ID  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param backup backups
      * @param integer totalCount  备份任务（文件）总数
      */

  describeBackups (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackups"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBackups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.baseId !== undefined && opts.baseId !== null) {
      queryParams['baseId'] = opts.baseId
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/backup',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建并执行缓存Redis实例的备份任务，只能为手动备份，可设置备份文件名称
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.fileName - 备份文件名称，只支持英文数字和下划线的组合，长度不超过32个字符
      * @param {integer} opts.backupType - 备份类型：手动备份为1，只能为手动备份
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string baseId  本次备份任务ID，可用于查询本次备份任务的结果
      */

  createBackup (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBackup"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling createBackup"
      )
    }
    if (opts.fileName === undefined || opts.fileName === null) {
      throw new Error(
        "Missing the required parameter 'opts.fileName' when calling createBackup"
      )
    }
    if (opts.backupType === undefined || opts.backupType === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupType' when calling createBackup"
      )
    }

    let postBody = {}
    if (opts.fileName !== undefined && opts.fileName !== null) {
      postBody['fileName'] = opts.fileName
    }
    if (opts.backupType !== undefined && opts.backupType !== null) {
      postBody['backupType'] = opts.backupType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBackup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/backup',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例的自动备份策略
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean autoBackup  是否开启自动备份，true表示开启，false表示关闭
      * @param string backupPeriod  备份周期，包括：Monday，Tuesday，Wednesday，Thursday，Friday，Saturday，Sunday，多个用逗号分隔
      * @param string backupTime  备份时间，格式为：HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      * @param string nextBackupTime  下次自动备份时间段，ISO 8601标准的UTC时间，格式为：YYYY-MM-DDTHH:mm:ssZ~YYYY-MM-DDTHH:mm:ssZ
      */

  describeBackupPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBackupPolicy"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBackupPolicy"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBackupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/backupPolicy',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启或更新缓存Redis实例的自动备份策略，可修改备份周期和备份时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {boolean} [opts.autoBackup] - 是否开启自动备份，true表示开启，false表示关闭  optional
      * @param {string} opts.backupTime - 设置自动备份时间，格式为：HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      * @param {string} opts.backupPeriod - 备份周期，包括：Monday，Tuesday，Wednesday，Thursday，Friday，Saturday，Sunday，多个用逗号分隔
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyBackupPolicy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyBackupPolicy"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyBackupPolicy"
      )
    }
    if (opts.backupTime === undefined || opts.backupTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupTime' when calling modifyBackupPolicy"
      )
    }
    if (opts.backupPeriod === undefined || opts.backupPeriod === null) {
      throw new Error(
        "Missing the required parameter 'opts.backupPeriod' when calling modifyBackupPolicy"
      )
    }

    let postBody = {}
    if (opts.autoBackup !== undefined && opts.autoBackup !== null) {
      postBody['autoBackup'] = opts.autoBackup
    }
    if (opts.backupTime !== undefined && opts.backupTime !== null) {
      postBody['backupTime'] = opts.backupTime
    }
    if (opts.backupPeriod !== undefined && opts.backupPeriod !== null) {
      postBody['backupPeriod'] = opts.backupPeriod
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyBackupPolicy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/backupPolicy',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  恢复缓存Redis实例的某次备份
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.baseId - 备份任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restoreInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restoreInstance"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling restoreInstance"
      )
    }
    if (opts.baseId === undefined || opts.baseId === null) {
      throw new Error(
        "Missing the required parameter 'opts.baseId' when calling restoreInstance"
      )
    }

    let postBody = {}
    if (opts.baseId !== undefined && opts.baseId !== null) {
      postBody['baseId'] = opts.baseId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restoreInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/restore',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取缓存Redis实例的备份文件临时下载地址（1个小时有效期）
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.baseId - 备份任务ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param downloadUrl downloadUrls
      */

  describeDownloadUrl (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeDownloadUrl"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeDownloadUrl"
      )
    }
    if (opts.baseId === undefined || opts.baseId === null) {
      throw new Error(
        "Missing the required parameter 'opts.baseId' when calling describeDownloadUrl"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.baseId !== undefined && opts.baseId !== null) {
      queryParams['baseId'] = opts.baseId
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeDownloadUrl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/backup:describeDownloadUrl',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Redis实例的集群内部信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param clusterInfo info  集群内部信息
      */

  describeClusterInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeClusterInfo"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeClusterInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeClusterInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/clusterInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Redis实例的IP白名单（只有白名单内的IP、网络才能访问该实例）
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string ipWhiteList
      */

  describeIpWhiteList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeIpWhiteList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeIpWhiteList"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeIpWhiteList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/ipWhiteList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改Redis实例的IP白名单
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {array} [opts.ipWhiteList] - 修改后的IP白名单列表，IP格式为CIDR表示法（x.x.x.x/x），0.0.0.0/0表示任何IP、网络都可以访问  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyIpWhiteList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyIpWhiteList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyIpWhiteList"
      )
    }

    let postBody = {}
    if (opts.ipWhiteList !== undefined && opts.ipWhiteList !== null) {
      postBody['ipWhiteList'] = opts.ipWhiteList
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyIpWhiteList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/ipWhiteList',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取缓存Redis实例的慢查询日志，可分页、可搜索
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} [opts.startTime] - 开始时间  optional
      * @param {string} [opts.endTime] - 结束时间  optional
      * @param {string} [opts.shardId] - 分片id  optional
      * @param {string} [opts.shardAddr] - 分片地址  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param slowLog slowLogs
      * @param integer totalCount  慢查询日志总条数
      */

  describeSlowLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSlowLog"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeSlowLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.shardId !== undefined && opts.shardId !== null) {
      queryParams['shardId'] = opts.shardId
    }
    if (opts.shardAddr !== undefined && opts.shardAddr !== null) {
      queryParams['shardAddr'] = opts.shardAddr
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSlowLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/slowLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询正在执行的任务进度列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.taskType] - 任务类型：resize表示变配，upgrade表示升级  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param taskProgress taskProgresses
      */

  describeTaskProgressList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeTaskProgressList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeTaskProgressList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskType !== undefined && opts.taskType !== null) {
      queryParams['taskType'] = opts.taskType
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeTaskProgressList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/taskProgress',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取禁用命令列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param disableCommandsInfo disableCommandLists
      */

  getDisableCommands (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDisableCommands"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling getDisableCommands"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDisableCommands with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/disableCommands',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  禁用redis命令
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {array} [opts.disableCommands] - 禁用命令列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setDisableCommands (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setDisableCommands"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling setDisableCommands"
      )
    }

    let postBody = {}
    if (opts.disableCommands !== undefined && opts.disableCommands !== null) {
      postBody['disableCommands'] = opts.disableCommands
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setDisableCommands with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/disableCommands',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询账号信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean isSupport  是否支持账号管理功能
      * @param accounts accountLists
      */

  describeAccounts (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAccounts"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeAccounts"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAccounts with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/account',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建账号
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.accountName - 账号名称
      * @param {string} opts.accountPassword - 账号密码
      * @param {string} [opts.accountPrivilege] - 账号权限，默认为读写权限。支持RoleReadOnly（只读权限）、RoleReadWrite（读写权限）  optional
      * @param {string} [opts.accountDescription] - 账号描述  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createAccount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createAccount"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling createAccount"
      )
    }
    if (opts.accountName === undefined || opts.accountName === null) {
      throw new Error(
        "Missing the required parameter 'opts.accountName' when calling createAccount"
      )
    }
    if (opts.accountPassword === undefined || opts.accountPassword === null) {
      throw new Error(
        "Missing the required parameter 'opts.accountPassword' when calling createAccount"
      )
    }

    let postBody = {}
    if (opts.accountName !== undefined && opts.accountName !== null) {
      postBody['accountName'] = opts.accountName
    }
    if (opts.accountPassword !== undefined && opts.accountPassword !== null) {
      postBody['accountPassword'] = opts.accountPassword
    }
    if (opts.accountPrivilege !== undefined && opts.accountPrivilege !== null) {
      postBody['accountPrivilege'] = opts.accountPrivilege
    }
    if (
      opts.accountDescription !== undefined &&
      opts.accountDescription !== null
    ) {
      postBody['accountDescription'] = opts.accountDescription
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createAccount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/account',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改账号信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.accountName - 账号名称
      * @param {string} [opts.accountPassword] - 账号密码  optional
      * @param {string} [opts.accountPrivilege] - 账号权限。支持RoleReadOnly（只读权限）、RoleReadWrite（读写权限）  optional
      * @param {string} [opts.accountDescription] - 账号备注  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyAccount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAccount"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyAccount"
      )
    }
    if (opts.accountName === undefined || opts.accountName === null) {
      throw new Error(
        "Missing the required parameter 'opts.accountName' when calling modifyAccount"
      )
    }

    let postBody = {}
    if (opts.accountName !== undefined && opts.accountName !== null) {
      postBody['accountName'] = opts.accountName
    }
    if (opts.accountPassword !== undefined && opts.accountPassword !== null) {
      postBody['accountPassword'] = opts.accountPassword
    }
    if (opts.accountPrivilege !== undefined && opts.accountPrivilege !== null) {
      postBody['accountPrivilege'] = opts.accountPrivilege
    }
    if (
      opts.accountDescription !== undefined &&
      opts.accountDescription !== null
    ) {
      postBody['accountDescription'] = opts.accountDescription
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAccount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/account',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除账号
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.accountName - 账号名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteAccount (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteAccount"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling deleteAccount"
      )
    }
    if (opts.accountName === undefined || opts.accountName === null) {
      throw new Error(
        "Missing the required parameter 'opts.accountName' when calling deleteAccount"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.accountName !== undefined && opts.accountName !== null) {
      queryParams['accountName'] = opts.accountName
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAccount with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/account',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量修改账号信息
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {array} [opts.accounts] - 要修改的账号列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyAccounts (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAccounts"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyAccounts"
      )
    }

    let postBody = {}
    if (opts.accounts !== undefined && opts.accounts !== null) {
      postBody['accounts'] = opts.accounts
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAccounts with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/accounts',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建数据清理任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.clearType - 数据清理任务类型
      * @param {string} [opts.keyPattern] - 匹配模式, 如: test*、*test、ab*cc*, 当节点为AllData、ExpiredData时可以忽略此参数  optional
      * @param {array} [opts.keyFilter] - key的过滤条件, 当节点为AllData、ExpiredData时可以忽略此参数  optional
      * @param {integer} [opts.qpsLimit] - 数据遍历的速率  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  startClearData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  startClearData"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling startClearData"
      )
    }
    if (opts.clearType === undefined || opts.clearType === null) {
      throw new Error(
        "Missing the required parameter 'opts.clearType' when calling startClearData"
      )
    }

    let postBody = {}
    if (opts.clearType !== undefined && opts.clearType !== null) {
      postBody['clearType'] = opts.clearType
    }
    if (opts.keyPattern !== undefined && opts.keyPattern !== null) {
      postBody['keyPattern'] = opts.keyPattern
    }
    if (opts.keyFilter !== undefined && opts.keyFilter !== null) {
      postBody['keyFilter'] = opts.keyFilter
    }
    if (opts.qpsLimit !== undefined && opts.qpsLimit !== null) {
      postBody['qpsLimit'] = opts.qpsLimit
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call startClearData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/startClearData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止数据清理任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  stopClearData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  stopClearData"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling stopClearData"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopClearData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/stopClearData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询数据清理任务进度
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param clearDataTaskInfo clearDataTaskInfo
      */

  describeClearData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeClearData"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeClearData"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeClearData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/describeClearData',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询大key分析任务列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.date - 格式:yyyy-MM-dd,表示查询某一天的大key分析列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param cacheAnalysis analyses
      */

  describeBigKeyList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyList"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyList"
      )
    }
    if (opts.date === undefined || opts.date === null) {
      throw new Error(
        "Missing the required parameter 'opts.date' when calling describeBigKeyList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.date !== undefined && opts.date !== null) {
      queryParams['date'] = opts.date
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建大key分析任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.stringSize] - String类型阈值  optional
      * @param {integer} [opts.listSize] - List类型阈值  optional
      * @param {integer} [opts.hashSize] - Hash类型阈值  optional
      * @param {integer} [opts.setSize] - Set类型阈值  optional
      * @param {integer} [opts.zsetSize] - Zset类型阈值  optional
      * @param {integer} [opts.top] - top值，范围10~1000  optional
      * @param {string} [opts.sizeMode] - 计算大key的方式。若为“elementCounts”，则使用元素个数计算大key；若为“memorySize”，则使用内存大小计算大key。默认为“elementCounts”。  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createBigKeyAnalysis (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBigKeyAnalysis"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling createBigKeyAnalysis"
      )
    }

    let postBody = {}
    if (opts.stringSize !== undefined && opts.stringSize !== null) {
      postBody['stringSize'] = opts.stringSize
    }
    if (opts.listSize !== undefined && opts.listSize !== null) {
      postBody['listSize'] = opts.listSize
    }
    if (opts.hashSize !== undefined && opts.hashSize !== null) {
      postBody['hashSize'] = opts.hashSize
    }
    if (opts.setSize !== undefined && opts.setSize !== null) {
      postBody['setSize'] = opts.setSize
    }
    if (opts.zsetSize !== undefined && opts.zsetSize !== null) {
      postBody['zsetSize'] = opts.zsetSize
    }
    if (opts.top !== undefined && opts.top !== null) {
      postBody['top'] = opts.top
    }
    if (opts.sizeMode !== undefined && opts.sizeMode !== null) {
      postBody['sizeMode'] = opts.sizeMode
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBigKeyAnalysis with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKey',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询大key分析详情
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.taskId - 任务id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string startTime  任务开始时间, rfc3339格式
      * @param string finishTime  任务结束时间, rfc3339格式
      * @param integer analysisType  任务类型，0:自动分析，1:手动分析
      * @param redisBigKey stringBigKeys
      * @param redisBigKey hashBigKeys
      * @param redisBigKey listBigKeys
      * @param redisBigKey zsetBigKeys
      * @param redisBigKey setBigKeys
      */

  describeBigKeyDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyDetail"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyDetail"
      )
    }
    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeBigKeyDetail"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      queryParams['taskId'] = opts.taskId
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyDetail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取大key自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string time  -表示为关闭，HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      */

  describeBigKeyAnalysisTime (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyAnalysisTime"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyAnalysisTime"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyAnalysisTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAutoAnalysisTime',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置大key自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.analysisTime - -表示关闭，否则为：HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyBigKeyAnalysisTime (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyBigKeyAnalysisTime"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyBigKeyAnalysisTime"
      )
    }
    if (opts.analysisTime === undefined || opts.analysisTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.analysisTime' when calling modifyBigKeyAnalysisTime"
      )
    }

    let postBody = {}
    if (opts.analysisTime !== undefined && opts.analysisTime !== null) {
      postBody['analysisTime'] = opts.analysisTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyBigKeyAnalysisTime with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAutoAnalysisTime',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停止缓存分析任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  stopCacheAnalysis (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  stopCacheAnalysis"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling stopCacheAnalysis"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call stopCacheAnalysis with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/stopCacheAnalysis',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存分析阈值
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer stringSize  String类型的阈值
      * @param integer listSize  List类型的阈值
      * @param integer hashSize  Hash类型的阈值
      * @param integer setSize  Set类型的阈值
      * @param integer zsetSize  Zset类型的阈值
      * @param integer topSize  top值
      */

  describeAnalysisThreshold (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAnalysisThreshold"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeAnalysisThreshold"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAnalysisThreshold with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/cacheAnalysisThreshold',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置缓存分析阈值
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.stringSize] - String类型阈值  optional
      * @param {integer} [opts.listSize] - List类型阈值  optional
      * @param {integer} [opts.hashSize] - Hash类型阈值  optional
      * @param {integer} [opts.setSize] - Set类型阈值  optional
      * @param {integer} [opts.zsetSize] - Zset类型阈值  optional
      * @param {integer} [opts.top] - top值，范围10~1000  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyAnalysisThreshold (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAnalysisThreshold"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyAnalysisThreshold"
      )
    }

    let postBody = {}
    if (opts.stringSize !== undefined && opts.stringSize !== null) {
      postBody['stringSize'] = opts.stringSize
    }
    if (opts.listSize !== undefined && opts.listSize !== null) {
      postBody['listSize'] = opts.listSize
    }
    if (opts.hashSize !== undefined && opts.hashSize !== null) {
      postBody['hashSize'] = opts.hashSize
    }
    if (opts.setSize !== undefined && opts.setSize !== null) {
      postBody['setSize'] = opts.setSize
    }
    if (opts.zsetSize !== undefined && opts.zsetSize !== null) {
      postBody['zsetSize'] = opts.zsetSize
    }
    if (opts.top !== undefined && opts.top !== null) {
      postBody['top'] = opts.top
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAnalysisThreshold with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/cacheAnalysisThreshold',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建大key分析任务
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.stringSize] - String类型阈值，最小10240  optional
      * @param {integer} [opts.listSize] - List类型阈值，最小1000  optional
      * @param {integer} [opts.hashSize] - Hash类型阈值，最小1000  optional
      * @param {integer} [opts.setSize] - Set类型阈值，最小1000  optional
      * @param {integer} [opts.zsetSize] - Zset类型阈值，最小1000  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  createBigKeyAnalysis2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createBigKeyAnalysis2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling createBigKeyAnalysis2"
      )
    }

    let postBody = {}
    if (opts.stringSize !== undefined && opts.stringSize !== null) {
      postBody['stringSize'] = opts.stringSize
    }
    if (opts.listSize !== undefined && opts.listSize !== null) {
      postBody['listSize'] = opts.listSize
    }
    if (opts.hashSize !== undefined && opts.hashSize !== null) {
      postBody['hashSize'] = opts.hashSize
    }
    if (opts.setSize !== undefined && opts.setSize !== null) {
      postBody['setSize'] = opts.setSize
    }
    if (opts.zsetSize !== undefined && opts.zsetSize !== null) {
      postBody['zsetSize'] = opts.zsetSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createBigKeyAnalysis2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysis',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询大key分析任务列表
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param clusterCacheAnalysis cacheAnalysisList
      * @param integer totalCount  大key分析列表总条数
      */

  describeBigKeyList2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyList2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyList2"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyList2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisResultList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询大key分析详情
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.taskId - 任务id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务id
      * @param integer stringSize  String类型的阈值
      * @param integer listSize  List类型的阈值
      * @param integer setSize  Set类型的阈值
      * @param integer hashSize  Hash类型的阈值
      * @param integer zsetSize  Zset类型的阈值
      * @param string status  大key分析任务状态(running, success, fail, manual_stop)
      * @param string analysisTime  大key分析开始时间, rfc3339格式
      * @param string analysisDuration  大key分析时长
      * @param bigKeyAnalysisNode bigKeyAnalysisNodesList
      */

  describeBigKeyDetail2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyDetail2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyDetail2"
      )
    }
    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling describeBigKeyDetail2"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.taskId !== undefined && opts.taskId !== null) {
      queryParams['taskId'] = opts.taskId
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyDetail2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisDetail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取大key自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string time  -表示为关闭，HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      */

  describeBigKeyAnalysisTime2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeBigKeyAnalysisTime2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeBigKeyAnalysisTime2"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBigKeyAnalysisTime2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisTime',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置大key自动缓存分析时间
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.analysisTime - -表示关闭，否则为：HH:mm-HH:mm 时区，例如&quot;01:00-02:00 +0800&quot;，表示东八区的1点到2点
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyBigKeyAnalysisTime2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyBigKeyAnalysisTime2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyBigKeyAnalysisTime2"
      )
    }
    if (opts.analysisTime === undefined || opts.analysisTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.analysisTime' when calling modifyBigKeyAnalysisTime2"
      )
    }

    let postBody = {}
    if (opts.analysisTime !== undefined && opts.analysisTime !== null) {
      postBody['analysisTime'] = opts.analysisTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyBigKeyAnalysisTime2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisTime',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存分析阈值
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer stringSize  String类型的阈值
      * @param integer listSize  List类型的阈值
      * @param integer hashSize  Hash类型的阈值
      * @param integer setSize  Set类型的阈值
      * @param integer zsetSize  Zset类型的阈值
      */

  describeAnalysisThreshold2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeAnalysisThreshold2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeAnalysisThreshold2"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeAnalysisThreshold2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisThreshold',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置缓存分析阈值
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {integer} [opts.stringSize] - String类型阈值，最小10240  optional
      * @param {integer} [opts.listSize] - List类型阈值，最小1000  optional
      * @param {integer} [opts.hashSize] - Hash类型阈值，最小1000  optional
      * @param {integer} [opts.setSize] - Set类型阈值，最小1000  optional
      * @param {integer} [opts.zsetSize] - Zset类型阈值，最小1000  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  modifyAnalysisThreshold2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyAnalysisThreshold2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling modifyAnalysisThreshold2"
      )
    }

    let postBody = {}
    if (opts.stringSize !== undefined && opts.stringSize !== null) {
      postBody['stringSize'] = opts.stringSize
    }
    if (opts.listSize !== undefined && opts.listSize !== null) {
      postBody['listSize'] = opts.listSize
    }
    if (opts.hashSize !== undefined && opts.hashSize !== null) {
      postBody['hashSize'] = opts.hashSize
    }
    if (opts.setSize !== undefined && opts.setSize !== null) {
      postBody['setSize'] = opts.setSize
    }
    if (opts.zsetSize !== undefined && opts.zsetSize !== null) {
      postBody['zsetSize'] = opts.zsetSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAnalysisThreshold2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/bigKeyAnalysisThreshold',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询热key分析结果
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param hotKeyAnalysisNode hotKeyAnalysisNodesList
      */

  describeHotKeyResult2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeHotKeyResult2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeHotKeyResult2"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeHotKeyResult2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/hotKeyAnalysisResult',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询热key分析详情
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.nodeId - 节点id
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param redisHotKey hotHeys
      * @param integer totalCount  热key总数量
      */

  describeHotKeyDetail2 (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeHotKeyDetail2"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeHotKeyDetail2"
      )
    }
    if (opts.nodeId === undefined || opts.nodeId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeId' when calling describeHotKeyDetail2"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.nodeId !== undefined && opts.nodeId !== null) {
      queryParams['nodeId'] = opts.nodeId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeHotKeyDetail2 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/hotKeyDetail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询热key分析结果汇总
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} [opts.startTime] - 开始时间，RFC3339格式，最多可以查询30天内的数据  optional
      * @param {string} [opts.endTime] - 结束时间，RFC3339格式，查询时间范围最多7天  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param hotKeyAnalysisNode hotKeyAnalysisNodesList
      */

  describeHotKeySummary (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeHotKeySummary"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeHotKeySummary"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeHotKeySummary with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/hotKeyAnalysisSummary',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询热key分析详情
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.nodeId - 节点id
      * @param {integer} [opts.pageNumber] - 页码；默认为1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认为10；取值范围[10, 100]  optional
      * @param {string} [opts.startTime] - 开始时间，RFC3339格式，最多可以查询30天内的数据  optional
      * @param {string} [opts.endTime] - 结束时间，RFC3339格式，查询时间范围最多7天  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param redisHotKey hotHeys
      * @param integer totalCount  热key总数量
      */

  describeHotKeyDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeHotKeyDetail"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling describeHotKeyDetail"
      )
    }
    if (opts.nodeId === undefined || opts.nodeId === null) {
      throw new Error(
        "Missing the required parameter 'opts.nodeId' when calling describeHotKeyDetail"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.nodeId !== undefined && opts.nodeId !== null) {
      queryParams['nodeId'] = opts.nodeId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeHotKeyDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/hotKeyAnalysisDetail',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  重启4.0实例代理
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {array} [opts.proxyIds] - proxy节点id列表  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  restartProxy (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  restartProxy"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling restartProxy"
      )
    }

    let postBody = {}
    if (opts.proxyIds !== undefined && opts.proxyIds !== null) {
      postBody['proxyIds'] = opts.proxyIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call restartProxy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/restartProxy',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭4.0实例客户端连接
      * @param {Object} opts - parameters
      * @param {string} opts.cacheInstanceId - 缓存Redis实例ID，是访问实例的唯一标识
      * @param {string} opts.option - 关闭属性, 支持addr/type/db三种属性
addr - 根据客户端地址关闭连接
type - 根据链接类型关闭连接
db - 根据db关闭连接

      * @param {string} opts.value - 筛选条件
属性是addr时 - ip:port, port空表示此ip所有port
属性是type时 - 支持normal/pubsub/all三种条件
属性是db时 - db列表, 0,1,2..

      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  clientKill (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  clientKill"
      )
    }

    opts = opts || {}

    if (opts.cacheInstanceId === undefined || opts.cacheInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.cacheInstanceId' when calling clientKill"
      )
    }
    if (opts.option === undefined || opts.option === null) {
      throw new Error(
        "Missing the required parameter 'opts.option' when calling clientKill"
      )
    }
    if (opts.value === undefined || opts.value === null) {
      throw new Error(
        "Missing the required parameter 'opts.value' when calling clientKill"
      )
    }

    let postBody = {}
    if (opts.option !== undefined && opts.option !== null) {
      postBody['option'] = opts.option
    }
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      cacheInstanceId: opts.cacheInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call clientKill with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/cacheInstance/{cacheInstanceId}/clientKill',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例的规格列表
      * @param {Object} opts - parameters
      * @param {string} [opts.redisVersion] - 缓存Redis的版本号：目前有2.8和4.0，默认为2.8  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param instanceClass instanceClasses
      * @param integer totalCount
      */

  describeInstanceClass (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInstanceClass"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.redisVersion !== undefined && opts.redisVersion !== null) {
      queryParams['redisVersion'] = opts.redisVersion
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInstanceClass with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instanceClass',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询账户的缓存Redis配额信息
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param quota quota
      */

  describeUserQuota (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeUserQuota"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeUserQuota with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/quota',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询缓存Redis实例的规格配置信息
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object shardSpec  单分片规格，自定义分片规格集群实例才需要
      * @param instanceSpec instanceSpec  实例规格
      */

  describeSpecConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeSpecConfig"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  redis/2.6.32'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeSpecConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/specConfig',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = REDIS
