/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 短信内容接口
 * API related to  Template
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'rms'
Service._services[serviceId] = true

/**
 * rms service.
 * @version 1.0.0
 */

JDCloud.RMS = class RMS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'rms.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  指定短信Id群发短信
      * @param {Object} opts - parameters
      * @param {sendBatchMsgSpec} opts.sendBatchMsgSpec - 指定短信Id群发短信请求参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param sendBatchMsg data  指定短信Id群发短信响应参数
      */

  sendBatchMsg (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  sendBatchMsg"
      )
    }

    opts = opts || {}

    if (opts.sendBatchMsgSpec === undefined || opts.sendBatchMsgSpec === null) {
      throw new Error(
        "Missing the required parameter 'opts.sendBatchMsgSpec' when calling sendBatchMsg"
      )
    }

    let postBody = {}
    if (opts.sendBatchMsgSpec !== undefined && opts.sendBatchMsgSpec !== null) {
      postBody['sendBatchMsgSpec'] = opts.sendBatchMsgSpec
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendBatchMsg with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/sendBatchMsg',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取发送状态
      * @param {Object} opts - parameters
      * @param {querySendStatusSpec} opts.querySendStatusSpec - 获取发送状态请求参数
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param querySendStatus data
      */

  querySendStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  querySendStatus"
      )
    }

    opts = opts || {}

    if (
      opts.querySendStatusSpec === undefined ||
      opts.querySendStatusSpec === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.querySendStatusSpec' when calling querySendStatus"
      )
    }

    let postBody = {}
    if (
      opts.querySendStatusSpec !== undefined &&
      opts.querySendStatusSpec !== null
    ) {
      postBody['querySendStatusSpec'] = opts.querySendStatusSpec
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySendStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/querySendStatus',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  增加富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - appId参数  optional
      * @param {string} [opts.signType] - signType参数  optional
      * @param {string} [opts.purpose] - purpose参数  optional
      * @param {string} [opts.signCardType] - signCardType参数  optional
      * @param {string} [opts.aptitudes] - aptitudes参数  optional
      * @param {string} [opts.title] - title参数  optional
      * @param {string} [opts.description] - description参数  optional
      * @param {string} [opts.isTuiding] - isTuiding参数  optional
      * @param {array} [opts.content] - content参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respAddTemplateData data
      * @param string message  message参数
      * @param string status  status参数
      */

  addTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.signType !== undefined && opts.signType !== null) {
      postBody['signType'] = opts.signType
    }
    if (opts.purpose !== undefined && opts.purpose !== null) {
      postBody['purpose'] = opts.purpose
    }
    if (opts.signCardType !== undefined && opts.signCardType !== null) {
      postBody['signCardType'] = opts.signCardType
    }
    if (opts.aptitudes !== undefined && opts.aptitudes !== null) {
      postBody['aptitudes'] = opts.aptitudes
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.isTuiding !== undefined && opts.isTuiding !== null) {
      postBody['isTuiding'] = opts.isTuiding
    }
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/addTemplate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询一个富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} [opts.templateId] - templateId参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respQueryOneTemplateResourceList data
      * @param string description  description参数
      * @param string mediaLength  mediaLength参数
      * @param string type  type参数
      * @param string title  title参数
      * @param string isTuiding  isTuiding参数
      * @param string message  message参数
      * @param string status  status参数
      */

  queryOneTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryOneTemplate"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryOneTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/queryOneTemplate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询富媒体短信内容列表接口
      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - appId参数  optional
      * @param {string} [opts.searchKey] - searchKey参数  optional
      * @param {string} [opts.pageNum] - pageNum参数  optional
      * @param {string} [opts.pageLimit] - pageLimit参数  optional
      * @param {string} [opts.status] - status参数  optional
      * @param {string} [opts.title] - title参数  optional
      * @param {string} [opts.startTime] - startTime参数  optional
      * @param {string} [opts.endTime] - endTime参数  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respQueryTemplateListData data
      * @param string message  message参数
      * @param string totalElements  totalElements参数
      * @param string status  status参数
      */

  queryTemplateList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryTemplateList"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.searchKey !== undefined && opts.searchKey !== null) {
      postBody['searchKey'] = opts.searchKey
    }
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      postBody['pageNum'] = opts.pageNum
    }
    if (opts.pageLimit !== undefined && opts.pageLimit !== null) {
      postBody['pageLimit'] = opts.pageLimit
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.0.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryTemplateList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/queryTemplateList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.RMS
