/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Message-Content-APIs
 * 富媒体模板内容创建、查询相关接口
 *
 * OpenAPI spec version: v2
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'rms'
Service._services[serviceId] = true

/**
 * rms service.
 * @version 1.4.0
 */

class RMS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'rms.jdcloud-api.com'
    options.basePath = '/v2' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  增加富媒体短信资质接口
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.name - 资质名称
      * @param {string} opts.description - 资质描述
      * @param {string} opts.businessLicense - 营业执照图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.businessLicenseName - 营业执照名称
      * @param {string} opts.signedAuthorization - 签名授权书图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.signedAuthorizationName - 签名授权书名称
      * @param {string} opts.informationSecurity - 信息安全保障责任书图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.informationSecurityName - 信息安全保障责任书名称
      * @param {string} opts.membershipCertificate - 会员证明图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.membershipCertificateName - 会员证明名称
      * @param {string} opts.otherCertificate - 其他证明图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.otherCertificateName - 其他证明名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respCreditData data  资质ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  addCredit (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addCredit"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling addCredit"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling addCredit"
      )
    }
    if (opts.description === undefined || opts.description === null) {
      throw new Error(
        "Missing the required parameter 'opts.description' when calling addCredit"
      )
    }
    if (opts.businessLicense === undefined || opts.businessLicense === null) {
      throw new Error(
        "Missing the required parameter 'opts.businessLicense' when calling addCredit"
      )
    }
    if (
      opts.businessLicenseName === undefined ||
      opts.businessLicenseName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.businessLicenseName' when calling addCredit"
      )
    }
    if (
      opts.signedAuthorization === undefined ||
      opts.signedAuthorization === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signedAuthorization' when calling addCredit"
      )
    }
    if (
      opts.signedAuthorizationName === undefined ||
      opts.signedAuthorizationName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signedAuthorizationName' when calling addCredit"
      )
    }
    if (
      opts.informationSecurity === undefined ||
      opts.informationSecurity === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.informationSecurity' when calling addCredit"
      )
    }
    if (
      opts.informationSecurityName === undefined ||
      opts.informationSecurityName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.informationSecurityName' when calling addCredit"
      )
    }
    if (
      opts.membershipCertificate === undefined ||
      opts.membershipCertificate === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.membershipCertificate' when calling addCredit"
      )
    }
    if (
      opts.membershipCertificateName === undefined ||
      opts.membershipCertificateName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.membershipCertificateName' when calling addCredit"
      )
    }
    if (opts.otherCertificate === undefined || opts.otherCertificate === null) {
      throw new Error(
        "Missing the required parameter 'opts.otherCertificate' when calling addCredit"
      )
    }
    if (
      opts.otherCertificateName === undefined ||
      opts.otherCertificateName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.otherCertificateName' when calling addCredit"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.businessLicense !== undefined && opts.businessLicense !== null) {
      postBody['businessLicense'] = opts.businessLicense
    }
    if (
      opts.businessLicenseName !== undefined &&
      opts.businessLicenseName !== null
    ) {
      postBody['businessLicenseName'] = opts.businessLicenseName
    }
    if (
      opts.signedAuthorization !== undefined &&
      opts.signedAuthorization !== null
    ) {
      postBody['signedAuthorization'] = opts.signedAuthorization
    }
    if (
      opts.signedAuthorizationName !== undefined &&
      opts.signedAuthorizationName !== null
    ) {
      postBody['signedAuthorizationName'] = opts.signedAuthorizationName
    }
    if (
      opts.informationSecurity !== undefined &&
      opts.informationSecurity !== null
    ) {
      postBody['informationSecurity'] = opts.informationSecurity
    }
    if (
      opts.informationSecurityName !== undefined &&
      opts.informationSecurityName !== null
    ) {
      postBody['informationSecurityName'] = opts.informationSecurityName
    }
    if (
      opts.membershipCertificate !== undefined &&
      opts.membershipCertificate !== null
    ) {
      postBody['membershipCertificate'] = opts.membershipCertificate
    }
    if (
      opts.membershipCertificateName !== undefined &&
      opts.membershipCertificateName !== null
    ) {
      postBody['membershipCertificateName'] = opts.membershipCertificateName
    }
    if (opts.otherCertificate !== undefined && opts.otherCertificate !== null) {
      postBody['otherCertificate'] = opts.otherCertificate
    }
    if (
      opts.otherCertificateName !== undefined &&
      opts.otherCertificateName !== null
    ) {
      postBody['otherCertificateName'] = opts.otherCertificateName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addCredit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/addCredit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改富媒体短信资质接口
      * @param {Object} opts - parameters
      * @param {string} opts.signId - 资质ID
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.name - 资质名称
      * @param {string} opts.description - 资质描述
      * @param {string} opts.businessLicense - 营业执照图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.businessLicenseName - 营业执照名称
      * @param {string} opts.signedAuthorization - 签名授权书图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.signedAuthorizationName - 签名授权书名称
      * @param {string} opts.informationSecurity - 信息安全保障责任书图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.informationSecurityName - 信息安全保障责任书名称
      * @param {string} opts.membershipCertificate - 会员证明图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.membershipCertificateName - 会员证明名称
      * @param {string} opts.otherCertificate - 其他证明图片,必须是jpg图片的base64编码，只支持jpg图片
      * @param {string} opts.otherCertificateName - 其他证明名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respCreditData data  资质ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  editCredit (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  editCredit"
      )
    }

    opts = opts || {}

    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling editCredit"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling editCredit"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling editCredit"
      )
    }
    if (opts.description === undefined || opts.description === null) {
      throw new Error(
        "Missing the required parameter 'opts.description' when calling editCredit"
      )
    }
    if (opts.businessLicense === undefined || opts.businessLicense === null) {
      throw new Error(
        "Missing the required parameter 'opts.businessLicense' when calling editCredit"
      )
    }
    if (
      opts.businessLicenseName === undefined ||
      opts.businessLicenseName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.businessLicenseName' when calling editCredit"
      )
    }
    if (
      opts.signedAuthorization === undefined ||
      opts.signedAuthorization === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signedAuthorization' when calling editCredit"
      )
    }
    if (
      opts.signedAuthorizationName === undefined ||
      opts.signedAuthorizationName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signedAuthorizationName' when calling editCredit"
      )
    }
    if (
      opts.informationSecurity === undefined ||
      opts.informationSecurity === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.informationSecurity' when calling editCredit"
      )
    }
    if (
      opts.informationSecurityName === undefined ||
      opts.informationSecurityName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.informationSecurityName' when calling editCredit"
      )
    }
    if (
      opts.membershipCertificate === undefined ||
      opts.membershipCertificate === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.membershipCertificate' when calling editCredit"
      )
    }
    if (
      opts.membershipCertificateName === undefined ||
      opts.membershipCertificateName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.membershipCertificateName' when calling editCredit"
      )
    }
    if (opts.otherCertificate === undefined || opts.otherCertificate === null) {
      throw new Error(
        "Missing the required parameter 'opts.otherCertificate' when calling editCredit"
      )
    }
    if (
      opts.otherCertificateName === undefined ||
      opts.otherCertificateName === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.otherCertificateName' when calling editCredit"
      )
    }

    let postBody = {}
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.businessLicense !== undefined && opts.businessLicense !== null) {
      postBody['businessLicense'] = opts.businessLicense
    }
    if (
      opts.businessLicenseName !== undefined &&
      opts.businessLicenseName !== null
    ) {
      postBody['businessLicenseName'] = opts.businessLicenseName
    }
    if (
      opts.signedAuthorization !== undefined &&
      opts.signedAuthorization !== null
    ) {
      postBody['signedAuthorization'] = opts.signedAuthorization
    }
    if (
      opts.signedAuthorizationName !== undefined &&
      opts.signedAuthorizationName !== null
    ) {
      postBody['signedAuthorizationName'] = opts.signedAuthorizationName
    }
    if (
      opts.informationSecurity !== undefined &&
      opts.informationSecurity !== null
    ) {
      postBody['informationSecurity'] = opts.informationSecurity
    }
    if (
      opts.informationSecurityName !== undefined &&
      opts.informationSecurityName !== null
    ) {
      postBody['informationSecurityName'] = opts.informationSecurityName
    }
    if (
      opts.membershipCertificate !== undefined &&
      opts.membershipCertificate !== null
    ) {
      postBody['membershipCertificate'] = opts.membershipCertificate
    }
    if (
      opts.membershipCertificateName !== undefined &&
      opts.membershipCertificateName !== null
    ) {
      postBody['membershipCertificateName'] = opts.membershipCertificateName
    }
    if (opts.otherCertificate !== undefined && opts.otherCertificate !== null) {
      postBody['otherCertificate'] = opts.otherCertificate
    }
    if (
      opts.otherCertificateName !== undefined &&
      opts.otherCertificateName !== null
    ) {
      postBody['otherCertificateName'] = opts.otherCertificateName
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editCredit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/editCredit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除富媒体短信资质接口
      * @param {Object} opts - parameters
      * @param {string} opts.signId - 资质ID
      * @param {string} opts.appId - 应用ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respCreditData data  资质ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  deleteCredit (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteCredit"
      )
    }

    opts = opts || {}

    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling deleteCredit"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling deleteCredit"
      )
    }

    let postBody = {}
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCredit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/deleteCredit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询富媒体短信资质列表接口
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {integer} opts.pageNum - 第几页
      * @param {integer} opts.pageSize - 每页多少条记录
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respCreditPageResult data
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  queryCreditList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryCreditList"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling queryCreditList"
      )
    }
    if (opts.pageNum === undefined || opts.pageNum === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNum' when calling queryCreditList"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling queryCreditList"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      postBody['pageNum'] = opts.pageNum
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryCreditList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/queryCreditList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  套餐包余量，仅预付费用户使用
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respPackageResult data  响应数据
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  queryPackageRemainder (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryPackageRemainder"
      )
    }

    opts = opts || {}

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryPackageRemainder with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/queryPackageRemainder',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  指定短信Id群发短信
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.templateId - 短信ID
      * @param {array} [opts.phone] - 群发的国内电话号码，群发时一次最多不要超过100个手机号  optional
      * @param {array} [opts.params] - 短信模板变量对应的数据值，Array格式  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param sendBatchMsg data  指定短信Id群发短信响应参数
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  sendBatchMsg (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  sendBatchMsg"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendBatchMsg"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling sendBatchMsg"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendBatchMsg with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/sendBatchMsg',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取发送状态
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.sequenceNumber - 序列号
      * @param {string} [opts.phone] - 手机号  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param querySendStatus data
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  querySendStatus (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  querySendStatus"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling querySendStatus"
      )
    }
    if (opts.sequenceNumber === undefined || opts.sequenceNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.sequenceNumber' when calling querySendStatus"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.sequenceNumber !== undefined && opts.sequenceNumber !== null) {
      postBody['sequenceNumber'] = opts.sequenceNumber
    }
    if (opts.phone !== undefined && opts.phone !== null) {
      postBody['phone'] = opts.phone
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySendStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/querySendStatus',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  增加富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.aptitudesId - 资质ID
      * @param {string} opts.title - 短信主题
      * @param {string} opts.description - 短信描述
      * @param {string} opts.signContent - 短信签名
      * @param {array} [opts.content] - 短信内容  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respTemplateData data  短信ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  addTemplateNew (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addTemplateNew"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling addTemplateNew"
      )
    }
    if (opts.aptitudesId === undefined || opts.aptitudesId === null) {
      throw new Error(
        "Missing the required parameter 'opts.aptitudesId' when calling addTemplateNew"
      )
    }
    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling addTemplateNew"
      )
    }
    if (opts.description === undefined || opts.description === null) {
      throw new Error(
        "Missing the required parameter 'opts.description' when calling addTemplateNew"
      )
    }
    if (opts.signContent === undefined || opts.signContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.signContent' when calling addTemplateNew"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.aptitudesId !== undefined && opts.aptitudesId !== null) {
      postBody['aptitudesId'] = opts.aptitudesId
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.signContent !== undefined && opts.signContent !== null) {
      postBody['signContent'] = opts.signContent
    }
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addTemplateNew with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/addTemplateNew',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} opts.appId - 应用ID
      * @param {string} opts.aptitudesId - 资质ID
      * @param {string} opts.title - 短信主题
      * @param {string} opts.description - 短信描述
      * @param {string} opts.signContent - 短信签名
      * @param {array} [opts.content] - 短信内容  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respTemplateData data  短信ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  editTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  editTemplate"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling editTemplate"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling editTemplate"
      )
    }
    if (opts.aptitudesId === undefined || opts.aptitudesId === null) {
      throw new Error(
        "Missing the required parameter 'opts.aptitudesId' when calling editTemplate"
      )
    }
    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling editTemplate"
      )
    }
    if (opts.description === undefined || opts.description === null) {
      throw new Error(
        "Missing the required parameter 'opts.description' when calling editTemplate"
      )
    }
    if (opts.signContent === undefined || opts.signContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.signContent' when calling editTemplate"
      )
    }

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.aptitudesId !== undefined && opts.aptitudesId !== null) {
      postBody['aptitudesId'] = opts.aptitudesId
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.signContent !== undefined && opts.signContent !== null) {
      postBody['signContent'] = opts.signContent
    }
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/editTemplate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} opts.appId - 应用ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respTemplateData data  短信ID
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  deleteTemplate (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteTemplate"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteTemplate"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling deleteTemplate"
      )
    }

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/deleteTemplate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询一个富媒体短信内容接口
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 短信ID
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respQueryTemplateListData data  响应数据
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  queryTemplateById (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryTemplateById"
      )
    }

    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling queryTemplateById"
      )
    }

    let postBody = {}
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryTemplateById with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/queryTemplateById',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询富媒体短信内容列表接口
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用ID
      * @param {string} [opts.title] - 查询标题关键词  optional
      * @param {integer} opts.pageNum - 第几页
      * @param {integer} opts.pageLimit - 每页多少条记录
      * @param {string} [opts.status] - 审核状态：0: 审核中 1: 通过 2: 未通过 4:待提交  optional
      * @param {string} [opts.startTime] - 开始时间,格式YYYY-MM-DD  optional
      * @param {string} [opts.endTime] - 结束时间,格式YYYY-MM-DD  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param respTemplatePageResult data
      * @param boolean status  请求状态
      * @param string code  错误码
      * @param string message  错误消息
      */

  queryTemplateList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  queryTemplateList"
      )
    }

    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling queryTemplateList"
      )
    }
    if (opts.pageNum === undefined || opts.pageNum === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNum' when calling queryTemplateList"
      )
    }
    if (opts.pageLimit === undefined || opts.pageLimit === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageLimit' when calling queryTemplateList"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.pageNum !== undefined && opts.pageNum !== null) {
      postBody['pageNum'] = opts.pageNum
    }
    if (opts.pageLimit !== undefined && opts.pageLimit !== null) {
      postBody['pageLimit'] = opts.pageLimit
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      postBody['startTime'] = opts.startTime
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      postBody['endTime'] = opts.endTime
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  rms/1.4.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryTemplateList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/queryTemplateList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = RMS
