/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SSL Certificate Manager
 * SSL数字证书信息管理接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'ssl'
Service._services[serviceId] = true

/**
 * ssl service.
 * @version 1.0.2
 */

JDCloud.SSL = class SSL extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'ssl.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查看证书列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 第几页，从1开始计数  optional
      * @param {integer} [opts.pageSize] - 每页显示的数目  optional
      * @param {string} [opts.domainName] - 域名，支持按照域名检索证书  optional
      * @param {string} [opts.certIds] - 证书id/别名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param certListDetail certListDetails
      * @param integer totalCount  总数量
      */

  describeCerts (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.domainName !== undefined && opts.domainName !== null) {
      queryParams['domainName'] = opts.domainName
    }
    if (opts.certIds !== undefined && opts.certIds !== null) {
      queryParams['certIds'] = opts.certIds
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCerts with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查看证书详情
      * @param {Object} opts - parameters
      * @param {string} opts.certId - 证书 Id
      * @param {integer} [opts.pageNumber] - 第几页，从1开始计数  optional
      * @param {integer} [opts.pageSize] - 每页显示的数目  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param certDescDetail certDescDetail
      */

  describeCert (opts, callback) {
    opts = opts || {}

    if (opts.certId === undefined || opts.certId === null) {
      throw new Error(
        "Missing the required parameter 'opts.certId' when calling describeCert"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud',
      certId: opts.certId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert/{certId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除证书 [MFA enabled]
      * @param {Object} opts - parameters
      * @param {string} opts.certId - 证书 Id
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  状态码
      * @param string message  消息
      */

  deleteCerts (opts, callback) {
    opts = opts || {}

    if (opts.certId === undefined || opts.certId === null) {
      throw new Error(
        "Missing the required parameter 'opts.certId' when calling deleteCerts"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      certId: opts.certId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCerts with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert/{certId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上传证书
      * @param {Object} opts - parameters
      * @param {string} opts.certName - 证书名称
      * @param {string} opts.keyFile - 私钥
      * @param {string} opts.certFile - 证书
      * @param {string} [opts.aliasName] - 证书别名  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string certId
      * @param string digest  对私钥文件使用sha256算法计算的摘要信息
      */

  uploadCert (opts, callback) {
    opts = opts || {}

    if (opts.certName === undefined || opts.certName === null) {
      throw new Error(
        "Missing the required parameter 'opts.certName' when calling uploadCert"
      )
    }
    if (opts.keyFile === undefined || opts.keyFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyFile' when calling uploadCert"
      )
    }
    if (opts.certFile === undefined || opts.certFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.certFile' when calling uploadCert"
      )
    }

    let postBody = {}
    if (opts.certName !== undefined && opts.certName !== null) {
      postBody['certName'] = opts.certName
    }
    if (opts.keyFile !== undefined && opts.keyFile !== null) {
      postBody['keyFile'] = opts.keyFile
    }
    if (opts.certFile !== undefined && opts.certFile !== null) {
      postBody['certFile'] = opts.certFile
    }
    if (opts.aliasName !== undefined && opts.aliasName !== null) {
      postBody['aliasName'] = opts.aliasName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call uploadCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert:upload',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  下载证书 [MFA enabled]
      * @param {Object} opts - parameters
      * @param {string} opts.certId - 证书 Id
      * @param {string} opts.serverType - 证书应用的服务器类型(Nginx Apache Tomcat IIS Other)
      * @param {string} callback - callback
      @return {Object} result
      * @param downloadCertDesc certDesc
      */

  downloadCert (opts, callback) {
    opts = opts || {}

    if (opts.certId === undefined || opts.certId === null) {
      throw new Error(
        "Missing the required parameter 'opts.certId' when calling downloadCert"
      )
    }
    if (opts.serverType === undefined || opts.serverType === null) {
      throw new Error(
        "Missing the required parameter 'opts.serverType' when calling downloadCert"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.serverType !== undefined && opts.serverType !== null) {
      queryParams['serverType'] = opts.serverType
    }

    let pathParams = {
      regionId: 'jdcloud',
      certId: opts.certId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call downloadCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert/{certId}:download',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改证书名称
      * @param {Object} opts - parameters
      * @param {string} opts.certId - 证书Id
      * @param {string} opts.certName - 证书名称
      * @param {string} callback - callback
      @return {Object} result
      * @param integer code  状态码
      * @param string message  消息
      */

  updateCertName (opts, callback) {
    opts = opts || {}

    if (opts.certId === undefined || opts.certId === null) {
      throw new Error(
        "Missing the required parameter 'opts.certId' when calling updateCertName"
      )
    }
    if (opts.certName === undefined || opts.certName === null) {
      throw new Error(
        "Missing the required parameter 'opts.certName' when calling updateCertName"
      )
    }

    let postBody = {}
    if (opts.certId !== undefined && opts.certId !== null) {
      postBody['certId'] = opts.certId
    }
    if (opts.certName !== undefined && opts.certName !== null) {
      postBody['certName'] = opts.certName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCertName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert:updateName',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新证书 [MFA enabled]
      * @param {Object} opts - parameters
      * @param {string} opts.certId - 证书ID
      * @param {string} opts.keyFile - 私钥
      * @param {string} opts.certFile - 证书
      * @param {string} callback - callback
      @return {Object} result
      * @param string certId  待更新证书ID
      * @param string digest  对私钥文件使用sha256算法计算的摘要信息
      */

  updateCert (opts, callback) {
    opts = opts || {}

    if (opts.certId === undefined || opts.certId === null) {
      throw new Error(
        "Missing the required parameter 'opts.certId' when calling updateCert"
      )
    }
    if (opts.keyFile === undefined || opts.keyFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.keyFile' when calling updateCert"
      )
    }
    if (opts.certFile === undefined || opts.certFile === null) {
      throw new Error(
        "Missing the required parameter 'opts.certFile' when calling updateCert"
      )
    }

    let postBody = {}
    if (opts.certId !== undefined && opts.certId !== null) {
      postBody['certId'] = opts.certId
    }
    if (opts.keyFile !== undefined && opts.keyFile !== null) {
      postBody['keyFile'] = opts.keyFile
    }
    if (opts.certFile !== undefined && opts.certFile !== null) {
      postBody['certFile'] = opts.certFile
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ssl/1.0.2'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/sslCert:updateCert',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.SSL
