/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Zone-Settings
 * A Zone setting changes how the Zone works in relation to caching, security, or other features of JDC StarShield
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'starshield'
Service._services[serviceId] = true

/**
 * starshield service.
 * @version 0.0.14
 */

class STARSHIELD extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'starshield.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  The dashboard view provides both totals and timeseries data for the given zone and time period across the entire scdn network.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.zoneName
      * @param {string} opts.since
      * @param {string} opts.until
      * @param {string} [opts.category]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneAnalytics zoneAnalytics
      */

  dashboard (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling dashboard"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling dashboard"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling dashboard"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling dashboard"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      queryParams['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }
    if (opts.category !== undefined && opts.category !== null) {
      queryParams['category'] = opts.category
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      queryParams['filters'] = opts.filters
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call dashboard with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$dashboard',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按请求次数统计。获取国家/地区的请求分布情况；获取路径、主机、设备类型的TopK.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param topkAnalytics topkAnalytics
      */

  topK (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling topK"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call topK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$topK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按响应带宽统计。获取国家/地区的请求分布情况；获取路径、主机、设备类型的TopK.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param topkAnalytics topkAnalytics
      */

  bandwidthTopK (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling bandwidthTopK"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bandwidthTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$bandwidthTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按请求次数统计，返回日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.criterionName]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  dateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling dateHistogram"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      postBody['criterionName'] = opts.criterionName
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call dateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$dateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按响应带宽统计，返回日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.criterionName]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  dateHistogramBandwidth (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling dateHistogramBandwidth"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      postBody['criterionName'] = opts.criterionName
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call dateHistogramBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$dateHistogramBandwidth',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按请求或响应带宽统计，返回日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.direction]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  bandwidthTrend (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling bandwidthTrend"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      postBody['direction'] = opts.direction
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bandwidthTrend with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$bandwidthTrend',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按请求次数统计。获取内容类型、路径、主机、设备类型、国家/地区、状态代码的TopK.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param topkAnalytics topkAnalytics
      */

  cacheTopK (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling cacheTopK"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cacheTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$cacheTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按响应带宽统计。获取内容类型、路径、主机、设备类型、国家/地区、状态代码的TopK.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param topkAnalytics topkAnalytics
      */

  cacheBandwidthTopK (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling cacheBandwidthTopK"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cacheBandwidthTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$cacheBandwidthTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按请求次数统计，返回日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.criterionName]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  cacheDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling cacheDateHistogram"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      postBody['criterionName'] = opts.criterionName
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cacheDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$cacheDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按响应带宽统计，返回日期直方图。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.criterionName]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  cacheDateHistogramBandwidth (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling cacheDateHistogramBandwidth"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      postBody['criterionName'] = opts.criterionName
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cacheDateHistogramBandwidth with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$cacheDateHistogramBandwidth',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按防火墙事件数量统计。获取IP地址、用户代理、路径、主机、国家/地区、HTTP方法的TopK。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param topkAnalytics topkAnalytics
      */

  firewallTopK (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling firewallTopK"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call firewallTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$firewallTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按防火墙事件数量统计，返回日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.topK]   optional
      * @param {} [opts.criterionName]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  firewallDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling firewallDateHistogram"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.topK !== undefined && opts.topK !== null) {
      postBody['topK'] = opts.topK
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      postBody['criterionName'] = opts.criterionName
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call firewallDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$firewallDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  qps on Zone
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.queryMode]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  qpsZone (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling qpsZone"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call qpsZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/qps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域的每秒指标，request/bandwidth/waf/l7ddos/firewallRules
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.queryMode]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  xps (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling xps"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call xps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/xps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  qps
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId
      * @param {} [opts.queryMode]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  qpsInstance (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling qpsInstance"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call qpsInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/qps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  bps on Zone
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.queryMode]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  bpsZone (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling bpsZone"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bpsZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/bps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  bps
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId
      * @param {} [opts.queryMode]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  bpsInstance (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling bpsInstance"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bpsInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/bps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  活动日志.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.pageNumber]   optional
      * @param {} [opts.pageSize]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param number total
      * @param activityLog activityLogs
      */

  firewallActivityLog (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling firewallActivityLog"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call firewallActivityLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$firewallActivityLog',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  访问日志.
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zoneName]   optional
      * @param {} [opts.since]   optional
      * @param {} [opts.until]   optional
      * @param {} [opts.pageNumber]   optional
      * @param {} [opts.pageSize]   optional
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param number total
      * @param accessLog dataList
      */

  accessLog (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling accessLog"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call accessLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$accessLog',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  分组统计。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.zoneName
      * @param {string} opts.since
      * @param {string} opts.until
      * @param {string} opts.criterionName
      * @param {string} callback - callback
      @return {Object} result
      * @param item items
      */

  groupBy (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling groupBy"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling groupBy"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling groupBy"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling groupBy"
      )
    }
    if (opts.criterionName === undefined || opts.criterionName === null) {
      throw new Error(
        "Missing the required parameter 'opts.criterionName' when calling groupBy"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      queryParams['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }
    if (opts.criterionName !== undefined && opts.criterionName !== null) {
      queryParams['criterionName'] = opts.criterionName
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call groupBy with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/analytics$$groupBy',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  listAvailablePageRuleSetting
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param availablePageRule dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listAvailablePageRuleSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listAvailablePageRuleSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listAvailablePageRuleSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/pagerules$$settings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Bot日期直方图.
      * @param {Object} opts - parameters
      * @param {string} opts.zoneId - 域名标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {botFilter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param botDateHistogram botDateHistogram
      */

  botDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling botDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling botDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling botDateHistogram"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }
    Object.assign(queryParams, super.buildArrayParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud',
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call botDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zoneId}/analyticsBotDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对于给定域，列出所有激活的证书包
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.status] - 包括所有状态的证书包，而不仅仅是激活状态的证书包。  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的域数  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param certificatePack dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listCertificatePacks (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listCertificatePacks"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listCertificatePacks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/ssl$$certificate_packs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对于给定域，删除高级证书包
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  deleteAdvancedCertificateManagerCertificatePack (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deleteAdvancedCertificateManagerCertificatePack"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling deleteAdvancedCertificateManagerCertificatePack"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteAdvancedCertificateManagerCertificatePack with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/ssl$$certificate_packs/{identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对于一个特定域，订购一个高级证书包
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.ty_pe] - 证书包的类型  optional
      * @param {} [opts.hosts] - 以逗号分隔的证书包的有效主机名称列表。必须包含域的顶级域名，不得包含50个以上的主机，也不得为空。  optional
      * @param {} [opts.validation_method] - 为订阅选择的验证方法  optional
      * @param {} [opts.validity_days] - 为订阅选择的有效日期  optional
      * @param {} [opts.certificate_authority] - 为该订阅选择的证书颁发机构。选择Let&#39;s Encrypt将减少对其他字段的定制。
validation_method必须是&#39;txt&#39;，validity_days必须是90，cloudflare_branding必须省略，hosts必须只包含两个条目。
一个是域名，一个是域名的子域通配符（例如 example.com, *.example.com）。
  optional
      * @param {} [opts.cloudflare_branding] - 是否为订阅添加星盾品牌。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param certificatePack data
      */

  orderAdvancedCertificateManagerCertificatePack (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling orderAdvancedCertificateManagerCertificatePack"
      )
    }

    let postBody = {}
    if (opts.ty_pe !== undefined && opts.ty_pe !== null) {
      postBody['ty_pe'] = opts.ty_pe
    }
    if (opts.hosts !== undefined && opts.hosts !== null) {
      postBody['hosts'] = opts.hosts
    }
    if (
      opts.validation_method !== undefined &&
      opts.validation_method !== null
    ) {
      postBody['validation_method'] = opts.validation_method
    }
    if (opts.validity_days !== undefined && opts.validity_days !== null) {
      postBody['validity_days'] = opts.validity_days
    }
    if (
      opts.certificate_authority !== undefined &&
      opts.certificate_authority !== null
    ) {
      postBody['certificate_authority'] = opts.certificate_authority
    }
    if (
      opts.cloudflare_branding !== undefined &&
      opts.cloudflare_branding !== null
    ) {
      postBody['cloudflare_branding'] = opts.cloudflare_branding
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call orderAdvancedCertificateManagerCertificatePack with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/ssl$$certificate_packs$$order',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域可以使用的可用自定义页面列表
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param customPage dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listAvailableCustomPages (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listAvailableCustomPages"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listAvailableCustomPages with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_pages',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新自定义页面URL
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {} [opts.url] - 与自定义页面关联的URL。  optional
      * @param {} [opts.state] - 自定义页面状态  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param customPage data
      */

  updateCustomPageURL (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updateCustomPageURL"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling updateCustomPageURL"
      )
    }

    let postBody = {}
    if (opts.url !== undefined && opts.url !== null) {
      postBody['url'] = opts.url
    }
    if (opts.state !== undefined && opts.state !== null) {
      postBody['state'] = opts.state
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCustomPageURL with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_pages/{identifier}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列出、搜索和筛选所有自定义SSL证书。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.status] - 域的自定义SSL的状态  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的域数  optional
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param customSSL dataList
      */

  listSSLConfigurations (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listSSLConfigurations"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSSLConfigurations with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_certificates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上载域的新SSL证书
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.certificate] - 域的SSL证书或证书以及中间证书  optional
      * @param {} [opts.private_key] - 域的私钥  optional
      * @param {} [opts.bundle_method] - 合法值ubiquitous/optimal/force，默认值ubiquitous。
ubiquitous：SSL泛捆绑在各处有着最高的概率被验证，甚至能被使用过时的或不寻常的信任存储的客户端验证。
optimal：最佳捆绑使用最短的认证链和最新的中间证书。
force：强制捆绑会验证证书链，但不以其他方式修改证书链。
  optional
      * @param {} [opts.geo_restrictions]   optional
      * @param {} [opts.ty_pe] - “legacy_custom”类型支持在TLS握手中不包含SNI的传统客户端。
合法值：
legacy_custom
sni_custom
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param customSSL data
      */

  createSSLConfiguration (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createSSLConfiguration"
      )
    }

    let postBody = {}
    if (opts.certificate !== undefined && opts.certificate !== null) {
      postBody['certificate'] = opts.certificate
    }
    if (opts.private_key !== undefined && opts.private_key !== null) {
      postBody['private_key'] = opts.private_key
    }
    if (opts.bundle_method !== undefined && opts.bundle_method !== null) {
      postBody['bundle_method'] = opts.bundle_method
    }
    if (opts.geo_restrictions !== undefined && opts.geo_restrictions !== null) {
      postBody['geo_restrictions'] = opts.geo_restrictions
    }
    if (opts.ty_pe !== undefined && opts.ty_pe !== null) {
      postBody['ty_pe'] = opts.ty_pe
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSSLConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_certificates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  上传SSL证书的新私钥和/或PEM/CRT。
注意，更新sni_custom证书的配置将导致返回新的资源id，并删除之前的资源id。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {} [opts.private_key] - 域的私钥  optional
      * @param {} [opts.certificate] - 域的SSL证书或证书以及中间证书  optional
      * @param {} [opts.bundle_method] - 合法值ubiquitous/optimal/force，默认值ubiquitous。
ubiquitous：SSL泛捆绑在各处有着最高的概率被验证，甚至能被使用过时的或不寻常的信任存储的客户端验证。
optimal：最佳捆绑使用最短的认证链和最新的中间证书。
force：强制捆绑会验证证书链，但不以其他方式修改证书链。
  optional
      * @param {} [opts.geo_restrictions]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param customSSL data
      */

  editSSLConfiguration (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling editSSLConfiguration"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling editSSLConfiguration"
      )
    }

    let postBody = {}
    if (opts.private_key !== undefined && opts.private_key !== null) {
      postBody['private_key'] = opts.private_key
    }
    if (opts.certificate !== undefined && opts.certificate !== null) {
      postBody['certificate'] = opts.certificate
    }
    if (opts.bundle_method !== undefined && opts.bundle_method !== null) {
      postBody['bundle_method'] = opts.bundle_method
    }
    if (opts.geo_restrictions !== undefined && opts.geo_restrictions !== null) {
      postBody['geo_restrictions'] = opts.geo_restrictions
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editSSLConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_certificates/{identifier}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  从域中删除SSL证书。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  deleteSSLConfiguration (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deleteSSLConfiguration"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling deleteSSLConfiguration"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSSLConfiguration with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/custom_certificates/{identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列出、搜索、排序和筛选域的DNS记录。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} [opts.name] - DNS record name  optional
      * @param {string} [opts.order] - 用于排序的字段  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的DNS记录数  optional
      * @param {string} [opts.content] - DNS记录内容  optional
      * @param {string} [opts.type] - DNS记录类型  optional
      * @param {boolean} [opts.proxied] - DNS记录代理状态  optional
      * @param {string} [opts.direction] - asc - 升序；desc - 降序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dnsRecord dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listDNSRecords (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listDNSRecords"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.content !== undefined && opts.content !== null) {
      queryParams['content'] = opts.content
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }
    if (opts.proxied !== undefined && opts.proxied !== null) {
      queryParams['proxied'] = opts.proxied
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listDNSRecords with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/dns_records',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建DNS记录
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.ty_pe] - DNS记录类型  optional
      * @param {} opts.name - DNS记录名称
      * @param {} opts.content - DNS记录内容
      * @param {} opts.ttl - DNS记录的生存时间。值为1是 &quot;自动&quot;。
      * @param {} [opts.priority] - 与一些记录如MX和SRV一起使用，以确定优先级。如果你没有为MX记录提供一个优先级，默认值为0将被设置。  optional
      * @param {} [opts.proxied] - 是否利用星盾的性能和安全优势  optional
      * @param {} [opts.srvData]   optional
      * @param {} [opts.caaData]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dnsRecord data
      */

  createDNSRecord (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createDNSRecord"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createDNSRecord"
      )
    }
    if (opts.content === undefined || opts.content === null) {
      throw new Error(
        "Missing the required parameter 'opts.content' when calling createDNSRecord"
      )
    }
    if (opts.ttl === undefined || opts.ttl === null) {
      throw new Error(
        "Missing the required parameter 'opts.ttl' when calling createDNSRecord"
      )
    }

    let postBody = {}
    if (opts.ty_pe !== undefined && opts.ty_pe !== null) {
      postBody['ty_pe'] = opts.ty_pe
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.proxied !== undefined && opts.proxied !== null) {
      postBody['proxied'] = opts.proxied
    }
    if (opts.srvData !== undefined && opts.srvData !== null) {
      postBody['srvData'] = opts.srvData
    }
    if (opts.caaData !== undefined && opts.caaData !== null) {
      postBody['caaData'] = opts.caaData
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDNSRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/dns_records',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  updateDNSRecord
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {} [opts.ty_pe] - DNS记录类型  optional
      * @param {} opts.name - DNS记录名称
      * @param {} opts.content - DNS记录内容
      * @param {} opts.ttl - DNS记录的生存时间。值为1是 &quot;自动&quot;。
      * @param {} [opts.proxied] - 是否利用星盾的性能和安全优势  optional
      * @param {} [opts.priority] - 如果是MX记录，该属性是必需的  optional
      * @param {} [opts.srvData]   optional
      * @param {} [opts.caaData]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param dnsRecord data
      */

  updateDNSRecord (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updateDNSRecord"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling updateDNSRecord"
      )
    }
    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling updateDNSRecord"
      )
    }
    if (opts.content === undefined || opts.content === null) {
      throw new Error(
        "Missing the required parameter 'opts.content' when calling updateDNSRecord"
      )
    }
    if (opts.ttl === undefined || opts.ttl === null) {
      throw new Error(
        "Missing the required parameter 'opts.ttl' when calling updateDNSRecord"
      )
    }

    let postBody = {}
    if (opts.ty_pe !== undefined && opts.ty_pe !== null) {
      postBody['ty_pe'] = opts.ty_pe
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.content !== undefined && opts.content !== null) {
      postBody['content'] = opts.content
    }
    if (opts.ttl !== undefined && opts.ttl !== null) {
      postBody['ttl'] = opts.ttl
    }
    if (opts.proxied !== undefined && opts.proxied !== null) {
      postBody['proxied'] = opts.proxied
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.srvData !== undefined && opts.srvData !== null) {
      postBody['srvData'] = opts.srvData
    }
    if (opts.caaData !== undefined && opts.caaData !== null) {
      postBody['caaData'] = opts.caaData
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDNSRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/dns_records/{identifier}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  deleteDNSRecord
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  deleteDNSRecord (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deleteDNSRecord"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling deleteDNSRecord"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDNSRecord with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/dns_records/{identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建新过滤器
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param filter dataList
      */

  createFilters (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createFilters"
      )
    }

    let postBody = {}
    if (opts.filters !== undefined && opts.filters !== null) {
      postBody['filters'] = opts.filters
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createFilters with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/filters',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新一个现有的筛选器。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.id
      * @param {} [opts.expression] - 要使用的筛选器表达式  optional
      * @param {} [opts.paused] - 此筛选器当前是否已暂停  optional
      * @param {} [opts.description] - 可用于描述过滤器用途的注释  optional
      * @param {} [opts.ref] - 短引用标记，用于快速选择相关规则。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param filter data
      */

  updateIndividualFilter (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updateIndividualFilter"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateIndividualFilter"
      )
    }

    let postBody = {}
    if (opts.expression !== undefined && opts.expression !== null) {
      postBody['expression'] = opts.expression
    }
    if (opts.paused !== undefined && opts.paused !== null) {
      postBody['paused'] = opts.paused
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.ref !== undefined && opts.ref !== null) {
      postBody['ref'] = opts.ref
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateIndividualFilter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/filters/{id}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列出当前定义的所有防火墙规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.id] - 防火墙规则标识符  optional
      * @param {string} [opts.description] - 描述中不区分大小写的搜索  optional
      * @param {string} [opts.action] - 规则操作上的精确匹配  optional
      * @param {boolean} [opts.paused] - 此防火墙规则当前是否已暂停。  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的防火墙规则数  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param firewallRule dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listOfFirewallRules (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listOfFirewallRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.id !== undefined && opts.id !== null) {
      queryParams['id'] = opts.id
    }
    if (opts.description !== undefined && opts.description !== null) {
      queryParams['description'] = opts.description
    }
    if (opts.action !== undefined && opts.action !== null) {
      queryParams['action'] = opts.action
    }
    if (opts.paused !== undefined && opts.paused !== null) {
      queryParams['paused'] = opts.paused
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listOfFirewallRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$rules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建新的防火墙规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.firewallRules]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param firewallRule dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  createFirewallRules (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createFirewallRules"
      )
    }

    let postBody = {}
    if (opts.firewallRules !== undefined && opts.firewallRules !== null) {
      postBody['firewallRules'] = opts.firewallRules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createFirewallRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$rules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新一个单独的现有防火墙规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.id
      * @param {} [opts.action] - 应用于匹配请求的行动。注意，行动 &quot;log &quot;只适用于企业客户。  optional
      * @param {} [opts.filter]   optional
      * @param {} [opts.products]   optional
      * @param {} [opts.priority] - 规则的优先级，允许控制处理顺序。一个较小的数字表示高优先级。如果不提供，任何有优先权的规则将在没有优先权的规则之前排序。  optional
      * @param {} [opts.paused] - 此防火墙规则当前是否已暂停。  optional
      * @param {} [opts.ref] - 短引用标记，用于快速选择相关规则。  optional
      * @param {} [opts.action_parameters]   optional
      * @param {} [opts.description] - 对规则的描述，以帮助识别它。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param firewallRule data
      */

  updateIndividualFirewallRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updateIndividualFirewallRule"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling updateIndividualFirewallRule"
      )
    }

    let postBody = {}
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (opts.filter !== undefined && opts.filter !== null) {
      postBody['filter'] = opts.filter
    }
    if (opts.products !== undefined && opts.products !== null) {
      postBody['products'] = opts.products
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.paused !== undefined && opts.paused !== null) {
      postBody['paused'] = opts.paused
    }
    if (opts.ref !== undefined && opts.ref !== null) {
      postBody['ref'] = opts.ref
    }
    if (
      opts.action_parameters !== undefined &&
      opts.action_parameters !== null
    ) {
      postBody['action_parameters'] = opts.action_parameters
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateIndividualFirewallRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$rules/{id}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除现有防火墙规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.id
      * @param {boolean} [opts.delete_filter_if_unused]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param firewallRule data
      */

  deleteIndividualFirewallRules (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deleteIndividualFirewallRules"
      )
    }
    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling deleteIndividualFirewallRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (
      opts.delete_filter_if_unused !== undefined &&
      opts.delete_filter_if_unused !== null
    ) {
      queryParams['delete_filter_if_unused'] = opts.delete_filter_if_unused
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteIndividualFirewallRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$rules/{id}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询Bot开启状态
      * @param {Object} opts - parameters
      * @param {string} opts.zoneId
      * @param {string} callback - callback
      @return {Object} result
      * @param string zoneId  zone id
      * @param string instanceId  套餐实例id
      * @param string subscriptionType  订阅类型
      * @param string subscriptionId  订阅id
      * @param string switchStatus  开关状态
      */

  describeBotStatus (opts, callback) {
    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling describeBotStatus"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeBotStatus with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/bot/{zoneId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启BOT
      * @param {Object} opts - parameters
      * @param {string} opts.zoneId
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  操作是否成功
      */

  openFirewallBot (opts, callback) {
    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling openFirewallBot"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call openFirewallBot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/bot/{zoneId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  关闭BOT
      * @param {Object} opts - parameters
      * @param {string} opts.zoneId
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  操作是否成功
      */

  closeFirewallBot (opts, callback) {
    opts = opts || {}

    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling closeFirewallBot"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call closeFirewallBot with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/bot/{zoneId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  套餐实例列表信息查询
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageSize] - 页容量，默认10, 范围（1-100）  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认1，不能小于1  optional
      * @param {string} [opts.instanceName] - 实例名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeInstancesRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describeInstances (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInstances"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInstances with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建套餐实例，调用成功，将自动扣费（请保证账户充足，否则无法成功创建实例）。

      * @param {Object} opts - parameters
      * @param {} [opts.chargeMode] - 计费模式（CONFIG、FLOW、MONTHLY、ONCE）
CONFIG 按配置
FLOW 按用量
MONTHLY 包年包月
ONCE 一次性
  optional
      * @param {} [opts.packType] - 套餐类型（BASIC、PROFESSIONAL、ENTERPRISE、ULTIMATE、SMB_EXPERIENCE、SMB_BASIC、SMB_BUSINESS）
BASIC 包年包月 基础版
PROFESSIONAL 包年包月 专业版
ENTERPRISE 包年包月 企业版
ULTIMATE 包年包月 旗舰版
--------------------------
SMB_EXPERIENCE 按流量 体验版
SMB_BASIC 按流量 基础版
SMB_BUSINESS 按流量 商业版
  optional
      * @param {} [opts.zonePackNum] - 域名增量包数量  optional
      * @param {} [opts.duration] - 计费时长  optional
      * @param {} [opts.durationUnit] - 计费时长单位（MONTH、YEAR）  optional
      * @param {} [opts.autoRenewStatus] - 自动续费状态(OPEN-&gt;开通自动续费 CLOSE-&gt;关闭自动续费)  optional
      * @param {} [opts.instanceName] - 实例名称  optional
      * @param {} [opts.memo] - 备注  optional
      * @param {} [opts.returnUrl] - 支付成功返回路径  optional
      * @param {} [opts.buyScenario] - 购买上下文JSON字符串  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  购买ID，可通过调用describeInstanceByOrderNo接口获取实例详情
      */

  createInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createInstance"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.chargeMode !== undefined && opts.chargeMode !== null) {
      postBody['chargeMode'] = opts.chargeMode
    }
    if (opts.packType !== undefined && opts.packType !== null) {
      postBody['packType'] = opts.packType
    }
    if (opts.zonePackNum !== undefined && opts.zonePackNum !== null) {
      postBody['zonePackNum'] = opts.zonePackNum
    }
    if (opts.duration !== undefined && opts.duration !== null) {
      postBody['duration'] = opts.duration
    }
    if (opts.durationUnit !== undefined && opts.durationUnit !== null) {
      postBody['durationUnit'] = opts.durationUnit
    }
    if (opts.autoRenewStatus !== undefined && opts.autoRenewStatus !== null) {
      postBody['autoRenewStatus'] = opts.autoRenewStatus
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (opts.memo !== undefined && opts.memo !== null) {
      postBody['memo'] = opts.memo
    }
    if (opts.returnUrl !== undefined && opts.returnUrl !== null) {
      postBody['returnUrl'] = opts.returnUrl
    }
    if (opts.buyScenario !== undefined && opts.buyScenario !== null) {
      postBody['buyScenario'] = opts.buyScenario
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  购买流量包，调用成功，将自动扣费（请保证账户充足，否则无法成功创建流量包）。

      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例ID
      * @param {} [opts.fixedFlowPackType] - 定量流量包类型(1-&gt;10TB 2-&gt;50TB 3-&gt;200TB 4-&gt;1PB 5-&gt;5PB)  optional
      * @param {} [opts.fixedFlowPackNum] - 定量流量包数量  optional
      * @param {} [opts.flowPackNum] - 按需购买流量包数量  optional
      * @param {} [opts.returnUrl] - 支付成功返回路径  optional
      * @param {} [opts.buyScenario] - 购买上下文JSON字符串  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  购买ID，购买ID，可通过调用describeInstanceByOrderNo接口获取流量包实例详情
      */

  createFlowPack (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createFlowPack"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling createFlowPack"
      )
    }

    let postBody = {}
    if (
      opts.fixedFlowPackType !== undefined &&
      opts.fixedFlowPackType !== null
    ) {
      postBody['fixedFlowPackType'] = opts.fixedFlowPackType
    }
    if (opts.fixedFlowPackNum !== undefined && opts.fixedFlowPackNum !== null) {
      postBody['fixedFlowPackNum'] = opts.fixedFlowPackNum
    }
    if (opts.flowPackNum !== undefined && opts.flowPackNum !== null) {
      postBody['flowPackNum'] = opts.flowPackNum
    }
    if (opts.returnUrl !== undefined && opts.returnUrl !== null) {
      postBody['returnUrl'] = opts.returnUrl
    }
    if (opts.buyScenario !== undefined && opts.buyScenario !== null) {
      postBody['buyScenario'] = opts.buyScenario
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createFlowPack with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances/{instanceId}/flowPack',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  升级套餐实例
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例ID
      * @param {} [opts.packType] - 套餐类型  optional
      * @param {} [opts.zonePackNum] - 域名增量包数量  optional
      * @param {} [opts.returnUrl] - 支付成功后返回到该路径  optional
      * @param {} [opts.buyScenario] - 购买上下文JSON字符串  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  购买ID
      */

  modifyInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  modifyInstance"
      )
    }

    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling modifyInstance"
      )
    }

    let postBody = {}
    if (opts.packType !== undefined && opts.packType !== null) {
      postBody['packType'] = opts.packType
    }
    if (opts.zonePackNum !== undefined && opts.zonePackNum !== null) {
      postBody['zonePackNum'] = opts.zonePackNum
    }
    if (opts.returnUrl !== undefined && opts.returnUrl !== null) {
      postBody['returnUrl'] = opts.returnUrl
    }
    if (opts.buyScenario !== undefined && opts.buyScenario !== null) {
      postBody['buyScenario'] = opts.buyScenario
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instance/{instanceId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据订单号查询套餐实例详情
      * @param {Object} opts - parameters
      * @param {string} opts.orderNumber
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describeInstancesRes describeInstancesRes
      */

  describeInstanceByOrderNo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeInstanceByOrderNo"
      )
    }

    opts = opts || {}

    if (opts.orderNumber === undefined || opts.orderNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.orderNumber' when calling describeInstanceByOrderNo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      orderNumber: opts.orderNumber
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeInstanceByOrderNo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instance/{orderNumber}/describeInstance',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  套餐实例续费回调查询
      * @param {Object} opts - parameters
      * @param {string} opts.resourceList - 资源列表
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object data
      */

  selectDetailList (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  selectDetailList"
      )
    }

    opts = opts || {}

    if (opts.resourceList === undefined || opts.resourceList === null) {
      throw new Error(
        "Missing the required parameter 'opts.resourceList' when calling selectDetailList"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.resourceList !== undefined && opts.resourceList !== null) {
      queryParams['resourceList'] = opts.resourceList
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call selectDetailList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances:selectDetailList',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查实例名称
      * @param {Object} opts - parameters
      * @param {string} opts.instanceName - 实例名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  checkInstancesName (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  checkInstancesName"
      )
    }

    opts = opts || {}

    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling checkInstancesName"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkInstancesName with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances:checkName',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾节点信息
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string jdcloudCidrs
      */

  ips (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  ips"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call ips with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/ips',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  请求下单
      * @param {Object} opts - parameters
      * @param {} [opts.buyId] - 购买ID  optional
      * @param {} [opts.autoPay] - 自动支付标识，当为true,才会发生自动支付，后付费的订单直接支付0元，预付费的订单（余额+代金劵）&gt; 订单应付金额，成功，否则支付失败  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string orderNumber  订单号
      * @param boolean autoPay  自动支付标识
      * @param string message  下单结果消息
      */

  submitOrder (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  submitOrder"
      )
    }

    opts = opts || {}

    let postBody = {}
    if (opts.buyId !== undefined && opts.buyId !== null) {
      postBody['buyId'] = opts.buyId
    }
    if (opts.autoPay !== undefined && opts.autoPay !== null) {
      postBody['autoPay'] = opts.autoPay
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitOrder with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/instances:submitOrder',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  平均峰值带宽。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  instanceBandwidthAvg (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthAvg"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceBandwidthAvg"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthAvg"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthAvg"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthAvg with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthAvg',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  带宽峰值。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnBandwidthMax cdnBandwidthMax
      */

  instanceBandwidthMax (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthMax"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceBandwidthMax"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthMax"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthMax"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthMax with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthMax',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  95峰值带宽。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  instanceBandwidthP95 (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthP95"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceBandwidthP95"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthP95"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthP95"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthP95 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthP95',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  带宽图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  instanceBandwidthDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceBandwidthDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的带宽图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  instanceBandwidthMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling instanceBandwidthMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  TopK域名的带宽图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  bandwidthDateHistogramTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling bandwidthDateHistogramTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling bandwidthDateHistogramTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling bandwidthDateHistogramTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling bandwidthDateHistogramTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bandwidthDateHistogramTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/bandwidthDateHistogramTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按域名的TopK峰值带宽。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param topK data
      */

  bandwidthTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling bandwidthTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling bandwidthTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling bandwidthTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling bandwidthTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bandwidthTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/bandwidthTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名带宽列表，按带宽降序排列。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {} opts.pageNumber - 页码。当页码为-1时，返回所有记录
      * @param {} [opts.pageSize] - 每页显示记录数。当pageNumber的值大于0时，该字段必须赋值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param number total
      * @param cdnZoneBandwidth cdnZoneBandwidths
      */

  instanceBandwidthList (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthList"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceBandwidthList"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthList"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthList"
      )
    }
    if (opts.pageNumber === undefined || opts.pageNumber === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageNumber' when calling instanceBandwidthList"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      postBody['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      postBody['pageSize'] = opts.pageSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthList with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceBandwidthList',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  总流量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  instanceTrafficSum (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceTrafficSum"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceTrafficSum"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceTrafficSum"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceTrafficSum"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceTrafficSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceTrafficSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  流量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  instanceTrafficDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceTrafficDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceTrafficDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceTrafficDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceTrafficDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceTrafficDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceTrafficDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的流量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  instanceTrafficMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceTrafficMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling instanceTrafficMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceTrafficMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceTrafficMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceTrafficMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceTrafficMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  TopK域名的流量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  trafficDateHistogramTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling trafficDateHistogramTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling trafficDateHistogramTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling trafficDateHistogramTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling trafficDateHistogramTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call trafficDateHistogramTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/trafficDateHistogramTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按域名的TopK总流量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param topK data
      */

  trafficTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling trafficTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling trafficTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling trafficTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling trafficTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call trafficTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/trafficTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  总请求量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  instanceRequestSum (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceRequestSum"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceRequestSum"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceRequestSum"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceRequestSum"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceRequestSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceRequestSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  请求量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  instanceRequestDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceRequestDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling instanceRequestDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceRequestDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceRequestDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceRequestDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceRequestDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的请求量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  instanceRequestMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceRequestMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling instanceRequestMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceRequestMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceRequestMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceRequestMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/instanceRequestMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  TopK域名的请求量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  requestDateHistogramTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling requestDateHistogramTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling requestDateHistogramTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling requestDateHistogramTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling requestDateHistogramTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call requestDateHistogramTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/requestDateHistogramTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  按域名的TopK总请求量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.since - 查询开始时间
      * @param {} opts.until - 查询结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param topK data
      */

  requestTopK (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling requestTopK"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling requestTopK"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling requestTopK"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling requestTopK"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call requestTopK with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/requestTopK',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列出域的日志推送作业
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param logpushJob dataList
      */

  listLogpushJobs (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listLogpushJobs"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listLogpushJobs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$jobs',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为域创建新的日志推送作业
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.zone_name] - 域名  optional
      * @param {} [opts.destination_conf] - 唯一标识数据推送目的地的字符串。可能包括目的地支持的其他参数。
例如：splunk://splunk.cf-analytics.com:8088/services/collector/raw?channel&#x3D;xxx&amp;header_Authorization&#x3D;Splunk xxx&amp;sourcetype&#x3D;xxx&amp;insecure-skip-verify&#x3D;false
  optional
      * @param {} [opts.name] - 可选的用户可读的作业名称。不是独一无二的。使用户更容易识别工作。建议包含域名称。  optional
      * @param {} [opts.enabled] - 默认值false  optional
      * @param {} [opts.dataset] - 要推送的数据集。合法值为：http/firewall。  optional
      * @param {} [opts.logpull_options] - 它指定了诸如请求的字段和时间戳格式之类的内容。例如：fields&#x3D;fieldName1,fieldName2,fileNamek&amp;timestamps&#x3D;rfc3339&amp;sample&#x3D;0.1  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param logpushJob data
      */

  createLogpushJob (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createLogpushJob"
      )
    }

    let postBody = {}
    if (opts.zone_name !== undefined && opts.zone_name !== null) {
      postBody['zone_name'] = opts.zone_name
    }
    if (opts.destination_conf !== undefined && opts.destination_conf !== null) {
      postBody['destination_conf'] = opts.destination_conf
    }
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.dataset !== undefined && opts.dataset !== null) {
      postBody['dataset'] = opts.dataset
    }
    if (opts.logpull_options !== undefined && opts.logpull_options !== null) {
      postBody['logpull_options'] = opts.logpull_options
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLogpushJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$jobs',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  数据集可用的所有字段的列表。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.dataset
      * @param {string} callback - callback
      @return {Object} result
      * @param logModule dataList
      */

  fields (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling fields"
      )
    }
    if (opts.dataset === undefined || opts.dataset === null) {
      throw new Error(
        "Missing the required parameter 'opts.dataset' when calling fields"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      dataset: opts.dataset
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call fields with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$datasets/{dataset}/fields',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  数据集可用的所有默认字段列表。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.dataset
      * @param {string} callback - callback
      @return {Object} result
      * @param logModule dataList
      */

  fieldsDefault (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling fieldsDefault"
      )
    }
    if (opts.dataset === undefined || opts.dataset === null) {
      throw new Error(
        "Missing the required parameter 'opts.dataset' when calling fieldsDefault"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      dataset: opts.dataset
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call fieldsDefault with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$datasets/{dataset}/fieldsDefault',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新日志推送作业
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.job_identifier
      * @param {} [opts.enabled]   optional
      * @param {} [opts.logpull_options] - 它指定了诸如请求的字段和时间戳格式之类的内容。例如：fields&#x3D;fieldName1,fieldName2,fileNamek&amp;timestamps&#x3D;rfc3339&amp;sample&#x3D;0.1  optional
      * @param {} [opts.destination_conf] - 唯一标识数据推送目的地的字符串。可能包括目的地支持的其他参数。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param logpushJob data
      */

  updateLogpushJob (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updateLogpushJob"
      )
    }
    if (opts.job_identifier === undefined || opts.job_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.job_identifier' when calling updateLogpushJob"
      )
    }

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.logpull_options !== undefined && opts.logpull_options !== null) {
      postBody['logpull_options'] = opts.logpull_options
    }
    if (opts.destination_conf !== undefined && opts.destination_conf !== null) {
      postBody['destination_conf'] = opts.destination_conf
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      job_identifier: opts.job_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateLogpushJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$jobs/{job_identifier}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除日志推送作业
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.job_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param logpushJob data
      */

  deleteLogpushJob (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deleteLogpushJob"
      )
    }
    if (opts.job_identifier === undefined || opts.job_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.job_identifier' when calling deleteLogpushJob"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      job_identifier: opts.job_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteLogpushJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$jobs/{job_identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检查是否存在作业，处理该目标。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.destination_conf] - 唯一标识数据推送目的地的字符串。可能包括目的地支持的其他参数。
例如：splunk://splunk.cf-analytics.com:8088/services/collector/raw?channel&#x3D;xxx&amp;header_Authorization&#x3D;Splunk xxx&amp;sourcetype&#x3D;xxx&amp;insecure-skip-verify&#x3D;false
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean data
      */

  checkDestinationExists (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling checkDestinationExists"
      )
    }

    let postBody = {}
    if (opts.destination_conf !== undefined && opts.destination_conf !== null) {
      postBody['destination_conf'] = opts.destination_conf
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call checkDestinationExists with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/logpush$$validate$$destination$$exists',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  套餐包列表查询
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageSize] - 页容量，默认10, 范围（1-100）  optional
      * @param {integer} [opts.pageNumber] - 页序号，默认1，不能小于1  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describePackRes dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  describePackages (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePackages"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePackages with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/packages',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  套餐包详情查询
      * @param {Object} opts - parameters
      * @param {integer} opts.packType - 套餐类型
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param describePackRes describePackRes
      */

  describePackage (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describePackage"
      )
    }

    opts = opts || {}

    if (opts.packType === undefined || opts.packType === null) {
      throw new Error(
        "Missing the required parameter 'opts.packType' when calling describePackage"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      packType: opts.packType
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describePackage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/packages/{packType}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取页面规则列表
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.status] - 页面规则的状态  optional
      * @param {string} [opts.order] - 用于按顺序排列页面规则的字段  optional
      * @param {string} [opts.direction] - asc - 升序；desc - 降序  optional
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pageRule dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listPageRules (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listPageRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listPageRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/pagerules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建页面规则
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.targets] - 根据请求评估的目标  optional
      * @param {} [opts.actions] - 如果此规则的目标与请求匹配，则要执行的操作集。操作可以将url重定向到另一个url或覆盖设置（但不能同时覆盖两者）  optional
      * @param {} [opts.priority] - 一个数字，表示一个页面规则优先于另一个页面规则。
如果您可能有一个全面的页面规则（例如#1 “/images/”）
但是想要更具体的规则优先（例如#2 &#39;/images/special/&#39;），
您需要在后者（#2）上指定更高的优先级，以便它将覆盖第一个优先级。
  optional
      * @param {} [opts.status] - 页面规则的状态  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pageRule data
      */

  createPageRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling createPageRule"
      )
    }

    let postBody = {}
    if (opts.targets !== undefined && opts.targets !== null) {
      postBody['targets'] = opts.targets
    }
    if (opts.actions !== undefined && opts.actions !== null) {
      postBody['actions'] = opts.actions
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createPageRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/pagerules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  替换页面规则。最终规则将与此请求传递的数据完全匹配。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {} [opts.targets] - 根据请求评估的目标  optional
      * @param {} [opts.actions] - 如果此规则的目标与请求匹配，则要执行的操作集。操作可以将url重定向到另一个url或覆盖设置（但不能同时覆盖两者）  optional
      * @param {} [opts.priority] - 一个数字，表示一个页面规则优先于另一个页面规则。
如果您可能有一个全面的页面规则（例如#1 “/images/”）
但是想要更具体的规则优先（例如#2 &#39;/images/special/&#39;），
您需要在后者（#2）上指定更高的优先级，以便它将覆盖第一个优先级。
  optional
      * @param {} [opts.status] - 页面规则的状态  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pageRule data
      */

  updatePageRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling updatePageRule"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling updatePageRule"
      )
    }

    let postBody = {}
    if (opts.targets !== undefined && opts.targets !== null) {
      postBody['targets'] = opts.targets
    }
    if (opts.actions !== undefined && opts.actions !== null) {
      postBody['actions'] = opts.actions
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }
    if (opts.status !== undefined && opts.status !== null) {
      postBody['status'] = opts.status
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updatePageRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/pagerules/{identifier}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除页面规则
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param string data
      */

  deletePageRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling deletePageRule"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling deletePageRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deletePageRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/pagerules/{identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取规则集。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.phase - 执行规则集的阶段，有效值http_ratelimit（速率限制阶段）/http_request_late_transform（转换阶段）/http_request_firewall_custom（防火墙规则）/http_request_firewall_managed（托管阶段）
      * @param {string} callback - callback
      @return {Object} result
      * @param ruleSet data
      */

  getRuleSet (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling getRuleSet"
      )
    }
    if (opts.phase === undefined || opts.phase === null) {
      throw new Error(
        "Missing the required parameter 'opts.phase' when calling getRuleSet"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      phase: opts.phase
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRuleSet with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/rulesets$$phases/{phase}/entrypoint',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建规则集
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.phase - 执行规则集的阶段，有效值http_ratelimit http_request_late_transform。
      * @param {} [opts.rules]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param ruleSet data
      */

  createRuleSet (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling createRuleSet"
      )
    }
    if (opts.phase === undefined || opts.phase === null) {
      throw new Error(
        "Missing the required parameter 'opts.phase' when calling createRuleSet"
      )
    }

    let postBody = {}
    if (opts.rules !== undefined && opts.rules !== null) {
      postBody['rules'] = opts.rules
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      phase: opts.phase
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRuleSet with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/rulesets$$phases/{phase}/entrypoint',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建规则
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.ruleset_id
      * @param {} [opts.enabled] - 是否开启规则，有效值true/false。  optional
      * @param {} [opts.description] - 规则的描述。  optional
      * @param {} [opts.expression] - 表达式。  optional
      * @param {} [opts.action] - 当表达式匹配时，采取的措施。有效值block（阻止）/challenge（交互式质询）/js_challenge（JS质询）/managed_challenge（托管质询）/log（记录）/rewrite/skip（跳过）/execute。  optional
      * @param {} [opts.action_parameters]   optional
      * @param {} [opts.ratelimit]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param ruleSet data
      */

  createRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling createRule"
      )
    }
    if (opts.ruleset_id === undefined || opts.ruleset_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleset_id' when calling createRule"
      )
    }

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.expression !== undefined && opts.expression !== null) {
      postBody['expression'] = opts.expression
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (
      opts.action_parameters !== undefined &&
      opts.action_parameters !== null
    ) {
      postBody['action_parameters'] = opts.action_parameters
    }
    if (opts.ratelimit !== undefined && opts.ratelimit !== null) {
      postBody['ratelimit'] = opts.ratelimit
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      ruleset_id: opts.ruleset_id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/rulesets/{ruleset_id}/rules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.ruleset_id
      * @param {string} opts.rule_id
      * @param {} [opts.enabled] - 是否开启规则，有效值true/false。  optional
      * @param {} [opts.description] - 规则的描述。  optional
      * @param {} [opts.expression] - 表达式。  optional
      * @param {} [opts.action] - 当表达式匹配时，采取的措施。有效值block（阻止）/challenge（交互式质询）/js_challenge（JS质询）/managed_challenge（托管质询）/log（记录）/rewrite/skip（跳过）。  optional
      * @param {} [opts.action_parameters]   optional
      * @param {} [opts.ratelimit]   optional
      * @param {} [opts.logging]   optional
      * @param {} [opts.position]   optional
      * @param {} [opts.id] - 规则标识。  optional
      * @param {} [opts.version] - 规则版本。  optional
      * @param {} [opts.last_updated] - 最近更新时间。  optional
      * @param {} [opts.ref] - 规则引用（默认是规则标识）。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param ruleSet data
      */

  updateRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling updateRule"
      )
    }
    if (opts.ruleset_id === undefined || opts.ruleset_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleset_id' when calling updateRule"
      )
    }
    if (opts.rule_id === undefined || opts.rule_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.rule_id' when calling updateRule"
      )
    }

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.expression !== undefined && opts.expression !== null) {
      postBody['expression'] = opts.expression
    }
    if (opts.action !== undefined && opts.action !== null) {
      postBody['action'] = opts.action
    }
    if (
      opts.action_parameters !== undefined &&
      opts.action_parameters !== null
    ) {
      postBody['action_parameters'] = opts.action_parameters
    }
    if (opts.ratelimit !== undefined && opts.ratelimit !== null) {
      postBody['ratelimit'] = opts.ratelimit
    }
    if (opts.logging !== undefined && opts.logging !== null) {
      postBody['logging'] = opts.logging
    }
    if (opts.position !== undefined && opts.position !== null) {
      postBody['position'] = opts.position
    }
    if (opts.id !== undefined && opts.id !== null) {
      postBody['id'] = opts.id
    }
    if (opts.version !== undefined && opts.version !== null) {
      postBody['version'] = opts.version
    }
    if (opts.last_updated !== undefined && opts.last_updated !== null) {
      postBody['last_updated'] = opts.last_updated
    }
    if (opts.ref !== undefined && opts.ref !== null) {
      postBody['ref'] = opts.ref
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      ruleset_id: opts.ruleset_id,
      rule_id: opts.rule_id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/rulesets/{ruleset_id}/rules/{rule_id}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除规则。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.ruleset_id
      * @param {string} opts.rule_id
      * @param {string} callback - callback
      @return {Object} result
      * @param ruleSet data
      */

  deleteRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling deleteRule"
      )
    }
    if (opts.ruleset_id === undefined || opts.ruleset_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.ruleset_id' when calling deleteRule"
      )
    }
    if (opts.rule_id === undefined || opts.rule_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.rule_id' when calling deleteRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      ruleset_id: opts.ruleset_id,
      rule_id: opts.rule_id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/rulesets/{ruleset_id}/rules/{rule_id}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  实例Spectrum应用流量统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  instanceTrafficDateHistogram4Pa (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceTrafficDateHistogram4Pa"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceTrafficDateHistogram4Pa"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceTrafficDateHistogram4Pa"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceTrafficDateHistogram4Pa with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/paTrafficDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名Spectrum应用流量统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.zoneId - 域名标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  zoneTrafficDateHistogram4Pa (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling zoneTrafficDateHistogram4Pa"
      )
    }
    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling zoneTrafficDateHistogram4Pa"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneTrafficDateHistogram4Pa"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneTrafficDateHistogram4Pa"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneTrafficDateHistogram4Pa with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/zones/{zoneId}/paTrafficDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Spectrum应用流量统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.zoneId - 域名标识
      * @param {string} opts.spectrumAppId - 应用标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  spectrumAppTrafficDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling spectrumAppTrafficDateHistogram"
      )
    }
    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling spectrumAppTrafficDateHistogram"
      )
    }
    if (opts.spectrumAppId === undefined || opts.spectrumAppId === null) {
      throw new Error(
        "Missing the required parameter 'opts.spectrumAppId' when calling spectrumAppTrafficDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling spectrumAppTrafficDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling spectrumAppTrafficDateHistogram"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId,
      zoneId: opts.zoneId,
      spectrumAppId: opts.spectrumAppId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call spectrumAppTrafficDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/zones/{zoneId}/spectrumApps/{spectrumAppId}/paTrafficDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  实例Spectrum应用带宽统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  instanceBandwidthDateHistogram4Pa (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling instanceBandwidthDateHistogram4Pa"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling instanceBandwidthDateHistogram4Pa"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling instanceBandwidthDateHistogram4Pa"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call instanceBandwidthDateHistogram4Pa with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/paBandwidthDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域名Spectrum应用带宽统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.zoneId - 域名标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  zoneBandwidthDateHistogram4Pa (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling zoneBandwidthDateHistogram4Pa"
      )
    }
    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling zoneBandwidthDateHistogram4Pa"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthDateHistogram4Pa"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthDateHistogram4Pa"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId,
      zoneId: opts.zoneId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthDateHistogram4Pa with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/zones/{zoneId}/paBandwidthDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Spectrum应用带宽统计.
      * @param {Object} opts - parameters
      * @param {string} opts.instanceId - 实例标识
      * @param {string} opts.zoneId - 域名标识
      * @param {string} opts.spectrumAppId - 应用标识
      * @param {string} opts.since - 开始时间
      * @param {string} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param paDateHistogram paDateHistogram
      */

  spectrumAppBandwidthDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.instanceId === undefined || opts.instanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceId' when calling spectrumAppBandwidthDateHistogram"
      )
    }
    if (opts.zoneId === undefined || opts.zoneId === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneId' when calling spectrumAppBandwidthDateHistogram"
      )
    }
    if (opts.spectrumAppId === undefined || opts.spectrumAppId === null) {
      throw new Error(
        "Missing the required parameter 'opts.spectrumAppId' when calling spectrumAppBandwidthDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling spectrumAppBandwidthDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling spectrumAppBandwidthDateHistogram"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.since !== undefined && opts.since !== null) {
      queryParams['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      queryParams['until'] = opts.until
    }

    let pathParams = {
      regionId: 'jdcloud',
      instanceId: opts.instanceId,
      zoneId: opts.zoneId,
      spectrumAppId: opts.spectrumAppId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call spectrumAppBandwidthDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/instances/{instanceId}/zones/{zoneId}/spectrumApps/{spectrumAppId}/paBandwidthDateHistogram',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取域的通用SSL证书设置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param universalSSLSetting data
      */

  universalSSLSettingsDetails (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling universalSSLSettingsDetails"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call universalSSLSettingsDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/ssl$$universal$$settings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修补域的通用SSL设置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.enabled] - 禁用通用SSL将从边缘上删除域的所有当前激活的通用SSL证书并且防止将来订购任何通用SSL证书。如果没有为域上载专用证书或自定义证书，访问者将无法通过HTTPS访问域。
通过禁用通用SSL，您知道以下星盾设置和首选项将导致访问者无法访问您的域，除非您上载了自定义证书或购买了专用证书。
  * HSTS
  * Always Use HTTPS
  * Opportunistic Encryption
  * Onion Routing
  * Any Page Rules redirecting traffic to HTTPS
类似地，在启用星盾代理时，在源站将任何HTTP重定向到HTTPS将导致用户在星盾的边缘没有有效证书的情况下无法访问您的站点。
如果您在星盾的边缘没有有效的自定义或专用证书，并且不确定是否启用了上述任何星盾设置，或者如果您的源站存在任何HTTP重定向，我们建议您的域保持启用通用SSL。
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param universalSSLSetting data
      */

  editUniversalSSLSettings (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling editUniversalSSLSettings"
      )
    }

    let postBody = {}
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editUniversalSSLSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/ssl$$universal$$settings',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  搜索、列出和排序包中包含的规则组
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.package_identifier
      * @param {string} [opts.name] - 防火墙规则组名称  optional
      * @param {string} [opts.mode] - 此组中包含的规则是否可配置/可用  optional
      * @param {number} [opts.rules_count] - 此组中包含多少条规则  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的组数  optional
      * @param {string} [opts.order] - 按字段对组进行排序  optional
      * @param {string} [opts.direction] - asc-升序；desc-降序  optional
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRuleGroup dataList
      */

  listRuleGroups (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listRuleGroups"
      )
    }
    if (
      opts.package_identifier === undefined ||
      opts.package_identifier === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.package_identifier' when calling listRuleGroups"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.mode !== undefined && opts.mode !== null) {
      queryParams['mode'] = opts.mode
    }
    if (opts.rules_count !== undefined && opts.rules_count !== null) {
      queryParams['rules_count'] = opts.rules_count
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      package_identifier: opts.package_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listRuleGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages/{package_identifier}/groups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取单个规则组
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.package_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRuleGroup data
      */

  ruleGroupDetails (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling ruleGroupDetails"
      )
    }
    if (
      opts.package_identifier === undefined ||
      opts.package_identifier === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.package_identifier' when calling ruleGroupDetails"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling ruleGroupDetails"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      package_identifier: opts.package_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call ruleGroupDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages/{package_identifier}/groups/{identifier}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新规则组的状态
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.package_identifier
      * @param {string} opts.identifier
      * @param {} [opts.mode] - 该组中包含的规则是否可配置/可使用  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRuleGroup data
      */

  editRuleGroup (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling editRuleGroup"
      )
    }
    if (
      opts.package_identifier === undefined ||
      opts.package_identifier === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.package_identifier' when calling editRuleGroup"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling editRuleGroup"
      )
    }

    let postBody = {}
    if (opts.mode !== undefined && opts.mode !== null) {
      postBody['mode'] = opts.mode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      package_identifier: opts.package_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editRuleGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages/{package_identifier}/groups/{identifier}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  检索域的防火墙包
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} [opts.name] - Name of the firewall package  optional
      * @param {number} [opts.page] - Page number of paginated results  optional
      * @param {number} [opts.per_page] - 每页的包数  optional
      * @param {string} [opts.order] - 按字段对包排序  optional
      * @param {string} [opts.direction] - asc - 升序；desc - 降序  optional
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRulePackage dataList
      */

  listFirewallPackages (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling listFirewallPackages"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listFirewallPackages with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取有关单个防火墙包的信息
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRulePackage data
      */

  firewallPackageDetails (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling firewallPackageDetails"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling firewallPackageDetails"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call firewallPackageDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages/{identifier}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更改异常检测类型WAF规则包的灵敏度和操作
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} opts.identifier
      * @param {} [opts.sensitivity] - 防火墙包的敏感度。  optional
      * @param {} [opts.action_mode] - 将对防火墙包下的规则执行的默认操作。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRulePackage data
      */

  editFirewallPackage (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling editFirewallPackage"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling editFirewallPackage"
      )
    }

    let postBody = {}
    if (opts.sensitivity !== undefined && opts.sensitivity !== null) {
      postBody['sensitivity'] = opts.sensitivity
    }
    if (opts.action_mode !== undefined && opts.action_mode !== null) {
      postBody['action_mode'] = opts.action_mode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editFirewallPackage with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/firewall$$waf$$packages/{identifier}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  包内的搜索、排序和筛选规则
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.package_id
      * @param {string} [opts.mode] - 已将规则覆盖到的设置  optional
      * @param {string} [opts.priority] - 在相关组中执行单个规则的顺序  optional
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} [opts.order] - 按指定字段排序  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的规则数  optional
      * @param {string} [opts.group_id] - WAF组标识符标签  optional
      * @param {string} [opts.description] - 规则的公开说明  optional
      * @param {string} [opts.direction] - asc-升序；desc-降序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRule dataList
      */

  listRules (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling listRules"
      )
    }
    if (opts.package_id === undefined || opts.package_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.package_id' when calling listRules"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.mode !== undefined && opts.mode !== null) {
      queryParams['mode'] = opts.mode
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      queryParams['priority'] = opts.priority
    }
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.group_id !== undefined && opts.group_id !== null) {
      queryParams['group_id'] = opts.group_id
    }
    if (opts.description !== undefined && opts.description !== null) {
      queryParams['description'] = opts.description
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      package_id: opts.package_id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/firewall$$waf$$packages/{package_id}/rules',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Individual information about a rule
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.package_id
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRule data
      */

  ruleDetails (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling ruleDetails"
      )
    }
    if (opts.package_id === undefined || opts.package_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.package_id' when calling ruleDetails"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling ruleDetails"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      package_id: opts.package_id,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call ruleDetails with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/firewall$$waf$$packages/{package_id}/rules/{identifier}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新规则在域上触发时将执行的操作
      * @param {Object} opts - parameters
      * @param {string} opts.zone_id
      * @param {string} opts.package_id
      * @param {string} opts.identifier
      * @param {} [opts.mode] - 触发规则时使用的模式。值基于规则的allowed_modes进行限制。有效值default/disable/simulate/block/challenge/on/off  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param wAFRule data
      */

  editRule (opts, callback) {
    opts = opts || {}

    if (opts.zone_id === undefined || opts.zone_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_id' when calling editRule"
      )
    }
    if (opts.package_id === undefined || opts.package_id === null) {
      throw new Error(
        "Missing the required parameter 'opts.package_id' when calling editRule"
      )
    }
    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling editRule"
      )
    }

    let postBody = {}
    if (opts.mode !== undefined && opts.mode !== null) {
      postBody['mode'] = opts.mode
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_id: opts.zone_id,
      package_id: opts.package_id,
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_id}/firewall$$waf$$packages/{package_id}/rules/{identifier}',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  平均峰值带宽。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  zoneBandwidthAvg (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneBandwidthAvg"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneBandwidthAvg"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneBandwidthAvg"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthAvg"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthAvg"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthAvg with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneBandwidthAvg',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  带宽峰值。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnBandwidthMax cdnBandwidthMax
      */

  zoneBandwidthMax (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneBandwidthMax"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneBandwidthMax"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneBandwidthMax"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthMax"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthMax"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthMax with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneBandwidthMax',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  95峰值带宽。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  zoneBandwidthP95 (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneBandwidthP95"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneBandwidthP95"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneBandwidthP95"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthP95"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthP95"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthP95 with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneBandwidthP95',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  带宽图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  zoneBandwidthDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneBandwidthDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneBandwidthDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneBandwidthDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneBandwidthDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的带宽图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  zoneBandwidthMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneBandwidthMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling zoneBandwidthMultiDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneBandwidthMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneBandwidthMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneBandwidthMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneBandwidthMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneBandwidthMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  总流量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  zoneTrafficSum (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneTrafficSum"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneTrafficSum"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneTrafficSum"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneTrafficSum"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneTrafficSum"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneTrafficSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneTrafficSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  流量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  zoneTrafficDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneTrafficDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneTrafficDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneTrafficDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneTrafficDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneTrafficDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneTrafficDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneTrafficDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的流量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  zoneTrafficMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneTrafficMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling zoneTrafficMultiDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneTrafficMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneTrafficMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneTrafficMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneTrafficMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneTrafficMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  总请求量。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param cdnSingleMetric cdnSingleMetric
      */

  zoneRequestSum (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneRequestSum"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneRequestSum"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneRequestSum"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneRequestSum"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneRequestSum"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneRequestSum with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneRequestSum',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  请求量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryMode - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param simpleDateHistogram data
      */

  zoneRequestDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneRequestDateHistogram"
      )
    }
    if (opts.queryMode === undefined || opts.queryMode === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryMode' when calling zoneRequestDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneRequestDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneRequestDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneRequestDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryMode !== undefined && opts.queryMode !== null) {
      postBody['queryMode'] = opts.queryMode
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneRequestDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneRequestDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  多指标的请求量图。查询范围最近6个月、查询最大跨度1个月。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.queryModes - all - 所有
normal - 业务
mitigation - 缓解
cache - 缓存
origin - 回源
all/normal/mitigation/cache/origin的任意组合

      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param dateHistogram dateHistograms
      * @param number timeScope
      * @param string since
      * @param string util
      */

  zoneRequestMultiDateHistogram (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneRequestMultiDateHistogram"
      )
    }
    if (opts.queryModes === undefined || opts.queryModes === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryModes' when calling zoneRequestMultiDateHistogram"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneRequestMultiDateHistogram"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneRequestMultiDateHistogram"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneRequestMultiDateHistogram"
      )
    }

    let postBody = {}
    if (opts.queryModes !== undefined && opts.queryModes !== null) {
      postBody['queryModes'] = opts.queryModes
    }
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneRequestMultiDateHistogram with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneRequestMultiDateHistogram',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  安全报告导出
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier - 域名标识
      * @param {} opts.zoneName - 域名
      * @param {} opts.since - 开始时间
      * @param {} opts.until - 结束时间
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSecurityReport zoneSecurityReport
      */

  zoneSecurityReport (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling zoneSecurityReport"
      )
    }
    if (opts.zoneName === undefined || opts.zoneName === null) {
      throw new Error(
        "Missing the required parameter 'opts.zoneName' when calling zoneSecurityReport"
      )
    }
    if (opts.since === undefined || opts.since === null) {
      throw new Error(
        "Missing the required parameter 'opts.since' when calling zoneSecurityReport"
      )
    }
    if (opts.until === undefined || opts.until === null) {
      throw new Error(
        "Missing the required parameter 'opts.until' when calling zoneSecurityReport"
      )
    }

    let postBody = {}
    if (opts.zoneName !== undefined && opts.zoneName !== null) {
      postBody['zoneName'] = opts.zoneName
    }
    if (opts.since !== undefined && opts.since !== null) {
      postBody['since'] = opts.since
    }
    if (opts.until !== undefined && opts.until !== null) {
      postBody['until'] = opts.until
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call zoneSecurityReport with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/zoneSecurityReport',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  列出、搜索、排序和筛选您的域
      * @param {Object} opts - parameters
      * @param {string} [opts.match] - 是否匹配所有搜索要求或至少一个（任何）  optional
      * @param {string} [opts.name] - 域名  optional
      * @param {string} [opts.__account__name] - 帐户名  optional
      * @param {string} [opts.order] - 按字段对域进行排序  optional
      * @param {number} [opts.page] - 分页结果的页码  optional
      * @param {number} [opts.per_page] - 每页的域数  optional
      * @param {string} [opts.status] - 域的状态  optional
      * @param {string} [opts.__account__id] - 帐户标识符标签  optional
      * @param {string} [opts.direction] - asc - 升序；desc - 降序  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zone dataList
      * @param integer currentCount  当前页记录数量
      * @param integer totalCount  总记录数量
      * @param integer totalPage  总页数
      */

  listZones (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.match !== undefined && opts.match !== null) {
      queryParams['match'] = opts.match
    }
    if (opts.name !== undefined && opts.name !== null) {
      queryParams['name'] = opts.name
    }
    if (opts.__account__name !== undefined && opts.__account__name !== null) {
      queryParams['__account__name'] = opts.__account__name
    }
    if (opts.order !== undefined && opts.order !== null) {
      queryParams['order'] = opts.order
    }
    if (opts.page !== undefined && opts.page !== null) {
      queryParams['page'] = opts.page
    }
    if (opts.per_page !== undefined && opts.per_page !== null) {
      queryParams['per_page'] = opts.per_page
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.__account__id !== undefined && opts.__account__id !== null) {
      queryParams['__account__id'] = opts.__account__id
    }
    if (opts.direction !== undefined && opts.direction !== null) {
      queryParams['direction'] = opts.direction
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listZones with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建域
      * @param {Object} opts - parameters
      * @param {} opts.name - 域名
      * @param {} opts.account
      * @param {} [opts.jump_start] - 自动尝试获取现有DNS记录  optional
      * @param {} [opts.ty_pe] - 全接入域意味着DNS由星盾托管。半接入域通常是合作伙伴托管的域或CNAME设置。  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zone data
      */

  createZone (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createZone"
      )
    }
    if (opts.account === undefined || opts.account === null) {
      throw new Error(
        "Missing the required parameter 'opts.account' when calling createZone"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.account !== undefined && opts.account !== null) {
      postBody['account'] = opts.account
    }
    if (opts.jump_start !== undefined && opts.jump_start !== null) {
      postBody['jump_start'] = opts.jump_start
    }
    if (opts.ty_pe !== undefined && opts.ty_pe !== null) {
      postBody['ty_pe'] = opts.ty_pe
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除存在的域名
      * @param {Object} opts - parameters
      * @param {string} opts.identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zone data
      */

  deleteZone (opts, callback) {
    opts = opts || {}

    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling deleteZone"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteZone with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{identifier}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  从星盾的缓存中删除所有文件
      * @param {Object} opts - parameters
      * @param {string} opts.identifier
      * @param {} opts.purge_everything - 指示星盾缓存中的所有资源都应该删除的标志。
注意，执行此操作后，可能会对源服务器负载产生显著影响。

      * @param {string} callback - callback
      @return {Object} result
      * @param zone data
      */

  purgeAllFiles (opts, callback) {
    opts = opts || {}

    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling purgeAllFiles"
      )
    }
    if (opts.purge_everything === undefined || opts.purge_everything === null) {
      throw new Error(
        "Missing the required parameter 'opts.purge_everything' when calling purgeAllFiles"
      )
    }

    let postBody = {}
    if (opts.purge_everything !== undefined && opts.purge_everything !== null) {
      postBody['purge_everything'] = opts.purge_everything
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call purgeAllFiles with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{identifier}/purge_cache__purgeAllFiles',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  通过指定URL，从星盾的缓存中细化删除一个或多个文件。
要清除带有自定义缓存key的文件，请包括用于计算缓存key的报头。
例如要清除缓存key中含有${geo}或${devicetype}的文件，请包括CF-Device-Type或CF-IPCountry报头。
注意：当包含源报头时，请确保包括scheme协议和hostname主机名。如果是默认端口，可以省略端口号（http为80，https为443），否则必须包含端口号。

      * @param {Object} opts - parameters
      * @param {string} opts.identifier
      * @param {} [opts.files] - 应从缓存中删除的URL数组  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zone data
      */

  purgeFilesByURL (opts, callback) {
    opts = opts || {}

    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling purgeFilesByURL"
      )
    }

    let postBody = {}
    if (opts.files !== undefined && opts.files !== null) {
      postBody['files'] = opts.files
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call purgeFilesByURL with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{identifier}/purge_cache__purgeFilesByURL',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  通过指定主机、关联的缓存标记或前缀，从星盾的缓存中精确删除一个或多个文件。
注意，缓存标记、主机和前缀清除每24小时的速率限制为30000次清除API调用。一次API调用最多可以清除30个标记、主机或前缀。
对于需要以更大容量进行清除的客户，可以提高此速率限制。

      * @param {Object} opts - parameters
      * @param {string} opts.identifier
      * @param {} [opts.tags] - 如何资产携带Cache-Tag头，并且它的值与提供的值之一匹配的话，该资产将从星盾缓存中清除  optional
      * @param {} [opts.hosts] - 如果资产的URL中的host与提供的值之一匹配的话，该资产将从星盾缓存中清除  optional
      * @param {} [opts.prefixes] - URL上与前缀匹配的任何资产都将从星盾缓存中清除。
例如, a.com/b 意味着 a.com/b/c/d.png 会被删除，而 a.com/bc.png 不会被删除。前缀a.com/b和a.com/b/c是冗余的。
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zone data
      */

  purgeFilesByCache_TagsAndHostOrPrefix (opts, callback) {
    opts = opts || {}

    if (opts.identifier === undefined || opts.identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.identifier' when calling purgeFilesByCache_TagsAndHostOrPrefix"
      )
    }

    let postBody = {}
    if (opts.tags !== undefined && opts.tags !== null) {
      postBody['tags'] = opts.tags
    }
    if (opts.hosts !== undefined && opts.hosts !== null) {
      postBody['hosts'] = opts.hosts
    }
    if (opts.prefixes !== undefined && opts.prefixes !== null) {
      postBody['prefixes'] = opts.prefixes
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      identifier: opts.identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call purgeFilesByCache_TagsAndHostOrPrefix with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{identifier}/purge_cache__purgeFilesByCache_TagsAndHostOrPrefix',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  域的相关配置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting dataList
      */

  getAllZoneSettings (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getAllZoneSettings"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAllZoneSettings with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量更新域的设置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.items] - 一或多个域配置对象。必须包含ID和值。  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  editZoneSettingsInfo (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling editZoneSettingsInfo"
      )
    }

    let postBody = {}
    if (opts.items !== undefined && opts.items !== null) {
      postBody['items'] = opts.items
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call editZoneSettingsInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对您的网站进行高级保护，防止分布式拒绝服务（DDoS）攻击。这是一个不可编辑的值。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param advancedDDoSProtection data
      */

  getAdvancedDDOSSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getAdvancedDDOSSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAdvancedDDOSSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$advanced_ddos',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取当前Always Online的配置。当Always Online开启时，在你的源站离线期间，星盾会提供已缓存过的页面。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param alwaysOnlineMode data
      */

  getAlwaysOnlineSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getAlwaysOnlineSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAlwaysOnlineSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$always_online',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  当开启时，在你的源站离线期间，星盾会提供已缓存过的页面。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param alwaysOnlineMode data
      */

  changeAlwaysOnlineSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeAlwaysOnlineSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeAlwaysOnlineSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$always_online',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对所有使用&quot;http&quot;的URL的请求，用301重定向到相应的 &quot;https&quot; URL。如果你只想对一个子集的请求进行重定向，可以考虑创建一个&quot;Always use HTTPS&quot;的页面规则。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getAlwaysUseHTTPSSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getAlwaysUseHTTPSSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAlwaysUseHTTPSSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$always_use_https',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  对所有使用&quot;http&quot;的URL的请求，用301重定向到相应的 &quot;https&quot; URL。如果你只想对一个子集的请求进行重定向，可以考虑创建一个&quot;Always use HTTPS&quot;的页面规则。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeAlwaysUseHTTPSSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeAlwaysUseHTTPSSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeAlwaysUseHTTPSSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$always_use_https',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为该域启用自动HTTPS重写功能。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getAutomaticHTTPSRewritesSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getAutomaticHTTPSRewritesSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAutomaticHTTPSRewritesSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$automatic_https_rewrites',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为该域启用自动HTTPS重写功能。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeAutomaticHTTPSRewritesSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeAutomaticHTTPSRewritesSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeAutomaticHTTPSRewritesSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$automatic_https_rewrites',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  浏览器缓存TTL（以秒为单位）指定星盾缓存资源将在访问者的计算机上保留多长时间。星盾将遵守服务器指定的任何更长时间。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param browserCacheTTL data
      */

  getBrowserCacheTTLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getBrowserCacheTTLSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getBrowserCacheTTLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$browser_cache_ttl',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  浏览器缓存TTL（以秒为单位）指定星盾缓存资源将在访问者的计算机上保留多长时间。星盾将遵守服务器指定的任何更长时间。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param browserCacheTTL data
      */

  changeBrowserCacheTTLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeBrowserCacheTTLSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeBrowserCacheTTLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$browser_cache_ttl',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  浏览器完整性检查与不良行为检查类似，寻找最常被垃圾邮件发送者滥用的常见HTTP头，并拒绝他们访问您的页面。它还会对没有用户代理或非标准用户代理（也是滥用机器人、爬虫或访客常用的）的访客提出挑战质询。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param browserCheck data
      */

  getBrowserCheckSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getBrowserCheckSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getBrowserCheckSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$browser_check',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  浏览器完整性检查与不良行为检查类似，寻找最常被垃圾邮件发送者滥用的常见HTTP头，并拒绝他们访问您的页面。它还会对没有用户代理或非标准用户代理（也是滥用机器人、爬虫或访客常用的）的访客提出挑战质询。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param browserCheck data
      */

  changeBrowserCheckSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeBrowserCheckSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeBrowserCheckSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$browser_check',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  缓存级别的功能是基于设置的级别。
basic设置将缓存大多数静态资源（即css、图片和JavaScript）。
simplified设置将在提供缓存的资源时忽略查询字符串。
aggressive设置将缓存所有的静态资源，包括有查询字符串的资源。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param cloudflareCacheLevel data
      */

  changeCacheLevelSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeCacheLevelSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeCacheLevelSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$cache_level',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  指定访问者在成功完成一项挑战（如验证码）后允许访问您的网站多长时间。在TTL过期后，访问者将不得不完成新的挑战。我们建议设置为15-45分钟，并将尝试遵守任何超过45分钟的设置。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param challengePageTTL data
      */

  getChallengeTTLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getChallengeTTLSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getChallengeTTLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$challenge_ttl',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  指定访问者在成功完成一项挑战（如验证码）后允许访问您的网站多长时间。在TTL过期后，访问者将不得不完成新的挑战。我们建议设置为15-45分钟，并将尝试遵守任何超过45分钟的设置。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param challengePageTTL data
      */

  changeChallengeTTLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeChallengeTTLSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeChallengeTTLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$challenge_ttl',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  如果你需要对你的网站进行修改，开发模式可以让你暂时进入网站的开发模式。这将绕过星盾的加速缓存，并降低您的网站速度。
但如果您正在对可缓存的内容（如图片、css 或 JavaScript）进行更改，并希望立即看到这些更改，这时就很有用。一旦进入，开发模式将持续3小时，然后自动切换关闭。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param developmentMode data
      */

  getDevelopmentModeSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getDevelopmentModeSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDevelopmentModeSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$development_mode',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  如果你需要对你的网站进行修改，开发模式可以让你暂时进入网站的开发模式。这将绕过星盾的加速缓存，并降低您的网站速度。
但如果您正在对可缓存的内容（如图片、css 或 JavaScript）进行更改，并希望立即看到这些更改，这时就很有用。一旦进入，开发模式将持续3小时，然后自动切换关闭。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param developmentMode data
      */

  changeDevelopmentModeSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeDevelopmentModeSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeDevelopmentModeSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$development_mode',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  在你的网页上对电子邮件地址进行加密，以防止机器人入侵，同时保持它们对人类可见。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param emailObfuscation data
      */

  getEmailObfuscationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getEmailObfuscationSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getEmailObfuscationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$email_obfuscation',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  在你的网页上对电子邮件地址进行加密，以防止机器人入侵，同时保持它们对人类可见。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param emailObfuscation data
      */

  changeEmailObfuscationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeEmailObfuscationSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeEmailObfuscationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$email_obfuscation',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用后，热链路保护选项可确保其他网站无法通过建立使用您网站上托管的图像的页面来占用您的带宽。只要您的网站上的图像请求被星盾选中，我们就会检查以确保这不是其他网站在请求它们。
人们仍然能够从你的网页上下载和查看图像，但其他网站将无法窃取它们用于自己的网页。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param hotlinkProtection data
      */

  getHotlinkProtectionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getHotlinkProtectionSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getHotlinkProtectionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$hotlink_protection',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用后，热链路保护选项可确保其他网站无法通过建立使用您网站上托管的图像的页面来占用您的带宽。只要您的网站上的图像请求被星盾选中，我们就会检查以确保这不是其他网站在请求它们。
人们仍然能够从你的网页上下载和查看图像，但其他网站将无法窃取它们用于自己的网页。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param hotlinkProtection data
      */

  changeHotlinkProtectionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeHotlinkProtectionSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeHotlinkProtectionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$hotlink_protection',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用IP地理定位，让星盾对您网站的访问者进行地理定位，并将国家代码传递给您。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param iPGeolocation data
      */

  getIPGeolocationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getIPGeolocationSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getIPGeolocationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ip_geolocation',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用IP地理定位，让星盾对您网站的访问者进行地理定位，并将国家代码传递给您。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param iPGeolocation data
      */

  changeIPGeolocationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeIPGeolocationSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeIPGeolocationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ip_geolocation',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  在所有启用星盾的子域上启用 IPv6。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param iPv6 data
      */

  getIPv6Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getIPv6Setting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getIPv6Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ipv6',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  在所有启用星盾的子域上启用 IPv6。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param iPv6 data
      */

  changeIPv6Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeIPv6Setting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeIPv6Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ipv6',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取你的网站自动最小化资产的配置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param auto_MinifyAssets data
      */

  getMinifySetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getMinifySetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMinifySetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$minify',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为你的网站自动最小化某些资产
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param auto_MinifyAssets data
      */

  changeMinifySetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeMinifySetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeMinifySetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$minify',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  自动将移动设备上的访问者重定向到一个移动优化的子域上
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param mobileRedirect data
      */

  getMobileRedirectSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getMobileRedirectSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMobileRedirectSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$mobile_redirect',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  自动将移动设备上的访问者重定向到一个移动优化的子域上
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param mobileRedirect data
      */

  changeMobileRedirectSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeMobileRedirectSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeMobileRedirectSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$mobile_redirect',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  自动优化移动设备上网站访问者的图像加载
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param mirageImageOptimization data
      */

  getMirageSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getMirageSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMirageSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$mirage',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  自动优化移动设备上网站访问者的图像加载
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param mirageImageOptimization data
      */

  changeMirageSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeMirageSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeMirageSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$mirage',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将代源服务器上任何 502、504 错误的客户错误页面，而不是显示默认的星盾错误页面。这不适用于 522 错误，并且仅限于企业级域。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getEnableErrorPagesOnSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getEnableErrorPagesOnSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getEnableErrorPagesOnSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$origin_error_page_pass_thru',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将代理源服务器上任何 502、504 错误的客户错误页面，而不是显示默认的星盾错误页面。这不适用于 522 错误，并且仅限于企业级域。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeEnableErrorPagesOnSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeEnableErrorPagesOnSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeEnableErrorPagesOnSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$origin_error_page_pass_thru',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取当前域随机加密设置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneEnableOpportunisticEncryption data
      */

  getOpportunisticEncryptionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getOpportunisticEncryptionSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getOpportunisticEncryptionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$opportunistic_encryption',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为当前域启用随机加密
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneEnableOpportunisticEncryption data
      */

  changeOpportunisticEncryptionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeOpportunisticEncryptionSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeOpportunisticEncryptionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$opportunistic_encryption',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  剥离元数据并压缩你的图像，以加快页面加载时间。
Basic（无损），减少PNG、JPEG和GIF文件的大小 - 对视觉质量没有影响。
Basic+JPEG（有损），进一步减少JPEG文件的大小，以加快图像加载。
较大的JPEG文件被转换为渐进式图像，首先加载较低分辨率的图像，最后是较高的分辨率版本。
不建议用于高像素的摄影网站。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param polishImageOptimization data
      */

  getPolishSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getPolishSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPolishSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$polish',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  剥离元数据并压缩你的图像，以加快页面加载时间。
Basic（无损），减少PNG、JPEG和GIF文件的大小 - 对视觉质量没有影响。
Basic+JPEG（有损），进一步减少JPEG文件的大小，以加快图像加载。
较大的JPEG文件被转换为渐进式图像，首先加载较低分辨率的图像，最后是较高的分辨率版本。
不建议用于高像素的摄影网站。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param polishImageOptimization data
      */

  changePolishSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changePolishSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changePolishSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$polish',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  当请求图像的客户端支持WebP图像编解码器时。当WebP比原始图像格式具有性能优势时，星盾将提供WebP版本的图像。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param polishWebPConversion data
      */

  getWebPSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getWebPSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getWebPSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$webp',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  当请求图像的客户端支持WebP图像编解码器时。当WebP比原始图像格式具有性能优势时，星盾将提供WebP版本的图像。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param polishWebPConversion data
      */

  changeWebPSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeWebPSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeWebPSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$webp',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  当请求资产的客户端支持brotli压缩算法时，星盾将提供资产的brotli压缩版本。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param brotliCompression data
      */

  changeBrotliSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeBrotliSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeBrotliSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$brotli',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将预取包含在响应标头中的任何 URL。这只限于企业级域。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getPrefetchPreloadSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getPrefetchPreloadSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPrefetchPreloadSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$prefetch_preload',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将预取包含在响应标头中的任何 URL。这只限于企业级域。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param prefetchPreload data
      */

  changePrefetchPreloadSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changePrefetchPreloadSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changePrefetchPreloadSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$prefetch_preload',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Privacy Pass是一个由Privacy Pass团队开发的浏览器扩展，旨在改善您的访客的浏览体验。启用Privacy Pass将减少显示给你的访客的验证码的数量。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param privacyPass data
      */

  getPrivacyPassSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getPrivacyPassSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPrivacyPassSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$privacy_pass',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Privacy Pass是一个由Privacy Pass团队开发的浏览器扩展，旨在改善您的访客的浏览体验。启用Privacy Pass将减少显示给你的访客的验证码的数量。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param privacyPass data
      */

  changePrivacyPassSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changePrivacyPassSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changePrivacyPassSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$privacy_pass',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Rocket Loader是一个通用的异步JavaScript优化，它优先渲染你的内容同时异步加载你的网站的Javascript。
开启Rocket Loader将立即改善网页的渲染时间，有时以首次绘制时间（TTFP）以及window.onload时间（假设页面上有JavaScript）来衡量，这对你的搜索排名会产生积极影响。
当打开时，Rocket Loader将自动推迟加载你的HTML中引用的所有Javascript，而不需要配置。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param rocketLoader data
      */

  getRocketLoaderSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getRocketLoaderSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRocketLoaderSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$rocket_loader',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Rocket Loader是一个通用的异步JavaScript优化，它优先渲染你的内容同时异步加载你的网站的Javascript。
开启Rocket Loader将立即改善网页的渲染时间，有时以首次绘制时间（TTFP）以及window.onload时间（假设页面上有JavaScript）来衡量，这对你的搜索排名会产生积极影响。
当打开时，Rocket Loader将自动推迟加载你的HTML中引用的所有Javascript，而不需要配置。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param rocketLoader data
      */

  changeRocketLoaderSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeRocketLoaderSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeRocketLoaderSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$rocket_loader',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾域的安全标头。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param securityHeader data
      */

  getSecurityHeaderHSTSSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getSecurityHeaderHSTSSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSecurityHeaderHSTSSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$security_header',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为你的网站选择适当的安全配置文件，这将自动调整每个安全设置。如果你选择定制一个单独的安全设置，该配置文件将成为自定义。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param securityLevel data
      */

  getSecurityLevelSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getSecurityLevelSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSecurityLevelSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$security_level',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为你的网站选择适当的安全配置文件，这将自动调整每个安全设置。如果你选择定制一个单独的安全设置，该配置文件将成为自定义。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param securityLevel data
      */

  changeSecurityLevelSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeSecurityLevelSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeSecurityLevelSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$security_level',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  如果你的网站上有敏感的内容，你想让真正的访问者看到，但你想对可疑的访问者进行隐藏，你所要做的就是用星盾SSE标签来包装这些内容。
用下面的SSE标签包住任何你想不让可疑访客看到的内容，&lt;!--sse--&gt;&lt;!--/sse--&gt;。
例如，&lt;!--sse--&gt;不好的访问者不会看到我的电话号码，555-555-5555&lt;!--/sse--&gt;。注意，SSE只对HTML起作用。
如果你启用了HTML最小化功能，当你的HTML源代码通过星盾提供服务时，你不会看到SSE标签。
在这种情况下，SSE 仍将发挥作用，因为星盾的 HTML 缩减和 SSE 功能是在资源通过我们的网络传输给我们时即时发生的。当资源通过我们的网络移动到访问者的计算机上时，SSE 仍会发挥作用。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param serverSideExclude data
      */

  getServerSideExcludeSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getServerSideExcludeSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getServerSideExcludeSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$server_side_exclude',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  如果你的网站上有敏感的内容，你想让真正的访问者看到，但你想对可疑的访问者进行隐藏，你所要做的就是用星盾SSE标签来包装这些内容。
用下面的SSE标签包住任何你想不让可疑访客看到的内容，&lt;!--sse--&gt;&lt;!--/sse--&gt;。
例如，&lt;!--sse--&gt;不好的访问者不会看到我的电话号码，555-555-5555&lt;!--/sse--&gt;。注意，SSE只对HTML起作用。
如果你启用了HTML最小化功能，当你的HTML源代码通过星盾提供服务时，你不会看到SSE标签。
在这种情况下，SSE 仍将发挥作用，因为星盾的 HTML 缩减和 SSE 功能是在资源通过我们的网络传输给我们时即时发生的。当资源通过我们的网络移动到访问者的计算机上时，SSE 仍会发挥作用。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param serverSideExclude data
      */

  changeServerSideExcludeSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeServerSideExcludeSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeServerSideExcludeSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$server_side_exclude',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将把具有相同查询字符串的文件视为缓存中的同一个文件，而不管查询字符串的顺序如何。这只限于企业级域。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getEnableQueryStringSortSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getEnableQueryStringSortSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getEnableQueryStringSortSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$sort_query_string_for_cache',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  星盾将把具有相同查询字符串的文件视为缓存中的同一个文件，而不管查询字符串的顺序如何。这只限于企业级域。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeEnableQueryStringSortSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeEnableQueryStringSortSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeEnableQueryStringSortSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$sort_query_string_for_cache',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  SSL对访问者的连接进行加密，并保护信用卡号码和其他进出网站的个人数据。
SSL最多需要5分钟才能完全激活。需要在星盾激活你的根域或www域。
Off，访客和星盾之间没有SSL，星盾和你的Web服务器之间也没有SSL（所有HTTP流量）。
Flexible, 访客和星盾之间的 SSL -- 访客在你的网站上看到 HTTPS，但星盾和你的 Web 服务器之间没有 SSL。您不需要在您的 Web 服务器上安装 SSL 证书，但您的访客仍会看到启用 HTTPS 的网站。
Full, 访客和星盾之间的 SSL -- 访客在你的网站上看到 HTTPS，以及星盾和你的 Web 服务器之间的 SSL。您至少需要有自己的 SSL 证书或自签名的证书。
Full (Strict), 访客和星盾之间的 SSL -- 访客在您的网站上看到 HTTPS，以及星盾和您的 Web 服务器之间的 SSL。你需要在你的网络服务器上安装一个有效的SSL证书。
这个证书必须由一个证书机构签署，有一个在未来的到期日，并为请求的域名（主机名）作出回应。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param sSL data
      */

  getSSLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getSSLSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSSLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ssl',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  SSL对访问者的连接进行加密，并保护信用卡号码和其他进出网站的个人数据。
SSL最多需要5分钟才能完全激活。需要在星盾激活你的根域或www域。
Off，访客和星盾之间没有SSL，星盾和你的Web服务器之间也没有SSL（所有HTTP流量）。
Flexible, 访客和星盾之间的 SSL -- 访客在你的网站上看到 HTTPS，但星盾和你的 Web 服务器之间没有 SSL。您不需要在您的 Web 服务器上安装 SSL 证书，但您的访客仍会看到启用 HTTPS 的网站。
Full, 访客和星盾之间的 SSL -- 访客在你的网站上看到 HTTPS，以及星盾和你的 Web 服务器之间的 SSL。您至少需要有自己的 SSL 证书或自签名的证书。
Full (Strict), 访客和星盾之间的 SSL -- 访客在您的网站上看到 HTTPS，以及星盾和您的 Web 服务器之间的 SSL。你需要在你的网络服务器上安装一个有效的SSL证书。
这个证书必须由一个证书机构签署，有一个在未来的到期日，并为请求的域名（主机名）作出回应。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值，off/flexible/full/strict  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param sSL data
      */

  changeSSLSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeSSLSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeSSLSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ssl',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取HTTPS请求允许使用的TLS协议的最低版本。例如，如果是TLS 1.1，那么TLS 1.0连接将被拒绝，而1.1、1.2和1.3（如果启用）将被允许。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getMinimumTLSVersionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getMinimumTLSVersionSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMinimumTLSVersionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$min_tls_version',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置HTTPS请求使用的TLS协议的最低版本。例如，如果选择TLS 1.1，那么TLS 1.0连接将被拒绝，而1.1、1.2和1.3（如果启用）将被允许。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - TLS协议版本  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeMinimumTLSVersionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeMinimumTLSVersionSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeMinimumTLSVersionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$min_tls_version',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  一个用于TLS终端的密码允许列表。这些密码必须是BoringSSL的格式。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param string dataList
      */

  getCiphersSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getCiphersSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCiphersSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ciphers',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  一个用于TLS终端的密码允许列表。这些密码必须是BoringSSL的格式。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string dataList
      */

  changeCiphersSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeCiphersSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeCiphersSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$ciphers',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为该域启用加密TLS 1.3功能。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getZoneEnableTLS1_3Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getZoneEnableTLS1_3Setting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getZoneEnableTLS1_3Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$tls_1_3',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  为该域启用加密TLS 1.3功能。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeTLS1_3Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeTLS1_3Setting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeTLS1_3Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$tls_1_3',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  TLS 客户端授权要求星盾使用客户端证书连接到您的源服务器（Enterprise Only）。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param tLSClientAuthentication data
      */

  getTLSClientAuthSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getTLSClientAuthSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTLSClientAuthSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$tls_client_auth',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  TLS 客户端授权要求星盾使用客户端证书连接到您的源服务器（Enterprise Only）。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param tLSClientAuthentication data
      */

  changeTLSClientAuthSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeTLSClientAuthSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeTLSClientAuthSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$tls_client_auth',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  允许客户继续在我们发送给源的头中使用真正的客户IP。这只限于企业级域。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  getTrueClientIPSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getTrueClientIPSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTrueClientIPSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$true_client_ip_header',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  允许客户继续在我们发送给源的头中使用真正的客户IP。这只限于企业级域。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zoneSetting data
      */

  changeTrueClientIPSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeTrueClientIPSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeTrueClientIPSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$true_client_ip_header',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  WAF检查对您网站的HTTP请求。它检查GET和POST请求，并应用规则来帮助从合法的网站访问者中过滤出非法流量。星盾 WAF 检查网站地址或 URL 以检测任何不正常的东西。
如果星盾 WAF确定了可疑的用户行为。那么 WAF 将用一个页面 &quot;挑战 &quot;网络访客，要求他们成功提交验证码以继续其行动。
如果挑战失败，行动将被停止。这意味着 星盾 的 WAF 将在任何被识别为非法的流量到达您的源网络服务器之前将其阻止。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param webApplicationFirewall data
      */

  getWebApplicationFirewallWAFSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getWebApplicationFirewallWAFSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getWebApplicationFirewallWAFSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$waf',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  WAF检查对您网站的HTTP请求。它检查GET和POST请求，并应用规则来帮助从合法的网站访问者中过滤出非法流量。星盾 WAF 检查网站地址或 URL 以检测任何不正常的东西。
如果星盾 WAF确定了可疑的用户行为。那么 WAF 将用一个页面 &quot;挑战 &quot;网络访客，要求他们成功提交验证码以继续其行动。
如果挑战失败，行动将被停止。这意味着 星盾 的 WAF 将在任何被识别为非法的流量到达您的源网络服务器之前将其阻止。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param webApplicationFirewall data
      */

  changeWebApplicationFirewallWAFSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeWebApplicationFirewallWAFSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeWebApplicationFirewallWAFSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$waf',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取HTTP2设置的状态
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP2Value data
      */

  getHTTP2Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getHTTP2Setting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getHTTP2Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$http2',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启/关闭HTTP2
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP2Value data
      */

  changeHTTP2Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeHTTP2Setting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeHTTP2Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$http2',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取HTTP3设置的状态
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP3Value data
      */

  getHTTP3Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getHTTP3Setting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getHTTP3Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$http3',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启/关闭HTTP3
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP3Value data
      */

  changeHTTP3Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeHTTP3Setting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeHTTP3Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$http3',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  Value of the 0-RTT setting
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param zero_RTTValue data
      */

  get0_RTTSessionResumptionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling get0_RTTSessionResumptionSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call get0_RTTSessionResumptionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$0rtt',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开启/关闭 0-RTT
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param zero_RTTValue data
      */

  change0_RTTSessionResumptionSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling change0_RTTSessionResumptionSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call change0_RTTSessionResumptionSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$0rtt',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取Pseudo IPv4(IPv6到IPv4的转换服务)的设置
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param pseudoIPv4Value data
      */

  getPseudoIPv4Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getPseudoIPv4Setting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPseudoIPv4Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$pseudo_ipv4',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置Pseudo IPv4(IPv6到IPv4的转换服务)
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param pseudoIPv4Value data
      */

  changePseudoIPv4Setting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changePseudoIPv4Setting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changePseudoIPv4Setting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$pseudo_ipv4',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  WebSockets是客户端和源服务器之间持续的开放连接。在WebSockets连接中，客户端和源服务器可以来回传递数据，而不需要重新建立会话。
这使得在WebSockets连接中的数据交换非常快。WebSockets经常被用于实时应用，如即时聊天和游戏。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param webSockets data
      */

  getWebSocketsSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getWebSocketsSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getWebSocketsSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$websockets',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  WebSockets是客户端和源服务器之间持续的开放连接。在WebSockets连接中，客户端和源服务器可以来回传递数据，而不需要重新建立会话。
这使得在WebSockets连接中的数据交换非常快。WebSockets经常被用于实时应用，如即时聊天和游戏。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - on - 开启；off - 关闭  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param webSockets data
      */

  changeWebSocketsSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeWebSocketsSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeWebSocketsSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$websockets',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  图像调整为通过星盾的网络提供的图像提供按需调整、转换和优化。
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param imageResizing data
      */

  getImageResizingSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getImageResizingSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getImageResizingSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$image_resizing',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  HTTP/2边缘优化，优化了通过HTTP/2提供的资源交付，提高了页面加载性能。当与Worker结合使用时，它还支持对内容交付的精细控制。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP2EdgePrioritization data
      */

  getHTTP2EdgePrioritizationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling getHTTP2EdgePrioritizationSetting"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getHTTP2EdgePrioritizationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$h2_prioritization',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  HTTP/2边缘优化，优化了通过HTTP/2提供的资源交付，提高了页面加载性能。当与Worker结合使用时，它还支持对内容交付的精细控制。

      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value] - 该设置的有效值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param hTTP2EdgePrioritization data
      */

  changeHTTP2EdgePrioritizationSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeHTTP2EdgePrioritizationSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeHTTP2EdgePrioritizationSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$h2_prioritization',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  变更上传文件的最大值
      * @param {Object} opts - parameters
      * @param {string} opts.zone_identifier
      * @param {} [opts.value]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param maxUpload data
      */

  changeMaxUploadSetting (opts, callback) {
    opts = opts || {}

    if (opts.zone_identifier === undefined || opts.zone_identifier === null) {
      throw new Error(
        "Missing the required parameter 'opts.zone_identifier' when calling changeMaxUploadSetting"
      )
    }

    let postBody = {}
    if (opts.value !== undefined && opts.value !== null) {
      postBody['value'] = opts.value
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      zone_identifier: opts.zone_identifier
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  starshield/0.0.14'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call changeMaxUploadSetting with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/zones/{zone_identifier}/settings$$max_upload',
      'PATCH',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = STARSHIELD
