/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Watermark
 * 水印管理相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'vod'
Service._services[serviceId] = true

/**
 * vod service.
 * @version 1.2.1
 */

class VOD extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'vod.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询分类列表。按照分页方式，返回分类列表信息。
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {sort} [opts.sorts]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listCategoriesResultObject resultObject
      */

  listCategories (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listCategories with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加分类
      * @param {Object} opts - parameters
      * @param {string} opts.name - 分类名称
      * @param {integer} [opts.parentId] - 父分类ID，取值为 0 或 null 时，表示该分类为一级分类
  optional
      * @param {string} [opts.description] - 分类描述信息  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param categoryObject resultObject
      */

  createCategory (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createCategory"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.parentId !== undefined && opts.parentId !== null) {
      postBody['parentId'] = opts.parentId
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createCategory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询所有分类
      * @param {Object} opts - parameters
      * @param {boolean} [opts.flatMode] - 是否返回平坦结构结果,默认为false（flatMode和treeMode不能同时为false）  optional
      * @param {boolean} [opts.treeMode] - 是否返回树结构结果,默认为false（flatMode和treeMode不能同时为false）  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listAllCategoriesResultObject resultObject
      */

  listAllCategories (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.flatMode !== undefined && opts.flatMode !== null) {
      queryParams['flatMode'] = opts.flatMode
    }
    if (opts.treeMode !== undefined && opts.treeMode !== null) {
      queryParams['treeMode'] = opts.treeMode
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listAllCategories with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories:listAll',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询分类及其子分类，若指定的分类ID为0，则返回一个根分类及其子分类（即一级分类）.
      * @param {Object} opts - parameters
      * @param {integer} opts.categoryId - 分类ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getCategoryWithChildrenResultObject resultObject
      */

  getCategoryWithChildren (opts, callback) {
    opts = opts || {}

    if (opts.categoryId === undefined || opts.categoryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.categoryId' when calling getCategoryWithChildren"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      categoryId: opts.categoryId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCategoryWithChildren with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories/{categoryId}:getWithChildren',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询分类
      * @param {Object} opts - parameters
      * @param {integer} opts.categoryId - 分类ID
      * @param {string} callback - callback
      @return {Object} result
      * @param categoryObject resultObject
      */

  getCategory (opts, callback) {
    opts = opts || {}

    if (opts.categoryId === undefined || opts.categoryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.categoryId' when calling getCategory"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      categoryId: opts.categoryId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getCategory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories/{categoryId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改分类
      * @param {Object} opts - parameters
      * @param {integer} opts.categoryId - 分类ID
      * @param {string} [opts.name] - 分类名称  optional
      * @param {integer} [opts.parentId] - 父分类ID，取值为 0 或 null 时，表示该分类为一级分类
  optional
      * @param {string} [opts.description] - 分类描述信息  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param categoryObject resultObject
      */

  updateCategory (opts, callback) {
    opts = opts || {}

    if (opts.categoryId === undefined || opts.categoryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.categoryId' when calling updateCategory"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.parentId !== undefined && opts.parentId !== null) {
      postBody['parentId'] = opts.parentId
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      categoryId: opts.categoryId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateCategory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories/{categoryId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除分类
      * @param {Object} opts - parameters
      * @param {integer} opts.categoryId - 分类ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteCategory (opts, callback) {
    opts = opts || {}

    if (opts.categoryId === undefined || opts.categoryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.categoryId' when calling deleteCategory"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      categoryId: opts.categoryId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteCategory with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/categories/{categoryId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {sort} [opts.sorts]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listDomainsResultObject resultObject
      */

  listDomains (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加域名
      * @param {Object} opts - parameters
      * @param {string} opts.name - 域名名称
      * @param {string} callback - callback
      @return {Object} result
      * @param domainObject resultObject
      */

  createDomain (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createDomain"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param domainObject resultObject
      */

  getDomain (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getDomain"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名。执行该操作，需确保域名已被停用。
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteDomain (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteDomain"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启用域名
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      */

  enableDomain (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling enableDomain"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:enable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  停用域名
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      */

  disableDomain (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling disableDomain"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:disable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设为默认域名
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      */

  setDefaultDomain (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setDefaultDomain"
      )
    }

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setDefaultDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setDefault',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置域名访问头参数
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} opts.headerName - 头参数名。当前支持的访问头参数取值范围：
  Content-Disposition
  Content-Language
  Expires
  Access-Control-Allow-Origin
  Access-Control-Allow-Methods
  Access-Control-Max-Age
  Access-Control-Expose-Headers

      * @param {string} opts.headerValue - 头参数值
      * @param {string} opts.headerType - 头参数类型，取值范围：req、resp
      * @param {string} callback - callback
      @return {Object} result
      */

  setHeader (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setHeader"
      )
    }
    if (opts.headerName === undefined || opts.headerName === null) {
      throw new Error(
        "Missing the required parameter 'opts.headerName' when calling setHeader"
      )
    }
    if (opts.headerValue === undefined || opts.headerValue === null) {
      throw new Error(
        "Missing the required parameter 'opts.headerValue' when calling setHeader"
      )
    }
    if (opts.headerType === undefined || opts.headerType === null) {
      throw new Error(
        "Missing the required parameter 'opts.headerType' when calling setHeader"
      )
    }

    let postBody = {}
    if (opts.headerName !== undefined && opts.headerName !== null) {
      postBody['headerName'] = opts.headerName
    }
    if (opts.headerValue !== undefined && opts.headerValue !== null) {
      postBody['headerValue'] = opts.headerValue
    }
    if (opts.headerType !== undefined && opts.headerType !== null) {
      postBody['headerType'] = opts.headerType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setHeader with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setHeader',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询域名访问头参数列表
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param listHeadersResultObject resultObject
      */

  listHeaders (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling listHeaders"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listHeaders with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:listHeaders',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除域名访问头参数
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} opts.headerName - 头参数名。当前支持的访问头参数取值范围：
  Content-Disposition
  Content-Language
  Expires
  Access-Control-Allow-Origin
  Access-Control-Allow-Methods
  Access-Control-Max-Age
  Access-Control-Expose-Headers

      * @param {string} opts.headerType - 头参数类型，取值范围：req、resp
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteHeader (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling deleteHeader"
      )
    }
    if (opts.headerName === undefined || opts.headerName === null) {
      throw new Error(
        "Missing the required parameter 'opts.headerName' when calling deleteHeader"
      )
    }
    if (opts.headerType === undefined || opts.headerType === null) {
      throw new Error(
        "Missing the required parameter 'opts.headerType' when calling deleteHeader"
      )
    }

    let postBody = {}
    if (opts.headerName !== undefined && opts.headerName !== null) {
      postBody['headerName'] = opts.headerName
    }
    if (opts.headerType !== undefined && opts.headerType !== null) {
      postBody['headerType'] = opts.headerType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteHeader with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:deleteHeader',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置CDN域名Referer防盗链规则
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {refererRuleConfigObject} opts.config - Referer防盗链规则配置对象
      * @param {boolean} opts.enabled - 是否启用该规则
      * @param {string} callback - callback
      @return {Object} result
      */

  setRefererRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setRefererRule"
      )
    }
    if (opts.config === undefined || opts.config === null) {
      throw new Error(
        "Missing the required parameter 'opts.config' when calling setRefererRule"
      )
    }
    if (opts.enabled === undefined || opts.enabled === null) {
      throw new Error(
        "Missing the required parameter 'opts.enabled' when calling setRefererRule"
      )
    }

    let postBody = {}
    if (opts.config !== undefined && opts.config !== null) {
      postBody['config'] = opts.config
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setRefererRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setRefererRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CDN域名Referer防盗链规则配置
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getRefererRuleResultObject resultObject
      */

  getRefererRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getRefererRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRefererRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:getRefererRule',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置CDN域名URL鉴权规则
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {uRLRuleConfigObject} opts.config - URL鉴权规则配置对象
      * @param {boolean} opts.enabled - 是否启用该规则
      * @param {string} callback - callback
      @return {Object} result
      */

  setURLRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setURLRule"
      )
    }
    if (opts.config === undefined || opts.config === null) {
      throw new Error(
        "Missing the required parameter 'opts.config' when calling setURLRule"
      )
    }
    if (opts.enabled === undefined || opts.enabled === null) {
      throw new Error(
        "Missing the required parameter 'opts.enabled' when calling setURLRule"
      )
    }

    let postBody = {}
    if (opts.config !== undefined && opts.config !== null) {
      postBody['config'] = opts.config
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setURLRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setURLRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CDN域名URL鉴权规则配置
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getURLRuleResultObject resultObject
      */

  getURLRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getURLRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getURLRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:getURLRule',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置CDN域名IP黑名单规则
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {iPRuleConfigObject} opts.config - IP黑名单规则配置对象
      * @param {boolean} opts.enabled - 是否启用该规则
      * @param {string} callback - callback
      @return {Object} result
      */

  setIPRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setIPRule"
      )
    }
    if (opts.config === undefined || opts.config === null) {
      throw new Error(
        "Missing the required parameter 'opts.config' when calling setIPRule"
      )
    }
    if (opts.enabled === undefined || opts.enabled === null) {
      throw new Error(
        "Missing the required parameter 'opts.enabled' when calling setIPRule"
      )
    }

    let postBody = {}
    if (opts.config !== undefined && opts.config !== null) {
      postBody['config'] = opts.config
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setIPRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setIPRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CDN域名IP黑名单规则配置
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getIPRuleResultObject resultObject
      */

  getIPRule (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getIPRule"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getIPRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:getIPRule',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置CDN域名SSL配置
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} [opts.source] - 证书来源。取值范围：default  optional
      * @param {string} [opts.title] - 证书标题  optional
      * @param {string} [opts.sslCert] - 证书内容  optional
      * @param {string} [opts.sslKey] - 证书私钥  optional
      * @param {string} [opts.jumpType] - 跳转类型。取值范围：
default - 采用回源域名的默认协议
http - 强制采用http协议回源
https - 强制采用https协议回源
  optional
      * @param {boolean} [opts.enabled] - SSL配置启用状态  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  setHttpSsl (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling setHttpSsl"
      )
    }

    let postBody = {}
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.sslCert !== undefined && opts.sslCert !== null) {
      postBody['sslCert'] = opts.sslCert
    }
    if (opts.sslKey !== undefined && opts.sslKey !== null) {
      postBody['sslKey'] = opts.sslKey
    }
    if (opts.jumpType !== undefined && opts.jumpType !== null) {
      postBody['jumpType'] = opts.jumpType
    }
    if (opts.enabled !== undefined && opts.enabled !== null) {
      postBody['enabled'] = opts.enabled
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setHttpSsl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:setHttpSsl',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询CDN域名SSL配置
      * @param {Object} opts - parameters
      * @param {integer} opts.domainId - 域名ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getHttpSslResultObject resultObject
      */

  getHttpSsl (opts, callback) {
    opts = opts || {}

    if (opts.domainId === undefined || opts.domainId === null) {
      throw new Error(
        "Missing the required parameter 'opts.domainId' when calling getHttpSsl"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      domainId: opts.domainId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getHttpSsl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/domains/{domainId}:getHttpSsl',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建直播转点播任务
      * @param {Object} opts - parameters
      * @param {string} opts.title - 视频标题
      * @param {string} opts.fileName - 文件名称
      * @param {integer} [opts.fileSize] - 文件大小  optional
      * @param {string} [opts.coverUrl] - 封面地址  optional
      * @param {string} [opts.description] - 视频描述  optional
      * @param {integer} [opts.categoryId] - 分类ID  optional
      * @param {array} [opts.tags] - 视频标签集合  optional
      * @param {string} [opts.transcodeTemplateGroupId] - 转码模板组ID。若此字段不为空，则将以模板组方式提交转码作业，transcodeTemplateIds字段将被忽略。  optional
      * @param {array} [opts.transcodeTemplateIds] - 转码模板ID集合  optional
      * @param {array} [opts.watermarkIds] - 水印ID集合  optional
      * @param {string} opts.publishDomain - 推流域名
      * @param {string} opts.appName - 应用名称
      * @param {string} opts.streamName - 流名称
      * @param {array} [opts.recordTimes] - 录制时间段集合
- 支持自定义1-10个时间段,拼接成一个文件
- 每个时间段不小于10s
- 总跨度不超过12小时
- 时间段按升序排列且无重叠
  optional
      * @param {string} opts.recordFileType - 录制文件类型:
- 取值: ts, flv, mp4
- 不区分大小写

      * @param {string} [opts.taskExternalId] - 直播录制任务外键  optional
      * @param {string} [opts.priority] - 任务优先级:
- 取值: low, medium, high
- 不区分大小写
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string flowId  业务流ID
      */

  createLiveToVodTask (opts, callback) {
    opts = opts || {}

    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling createLiveToVodTask"
      )
    }
    if (opts.fileName === undefined || opts.fileName === null) {
      throw new Error(
        "Missing the required parameter 'opts.fileName' when calling createLiveToVodTask"
      )
    }
    if (opts.publishDomain === undefined || opts.publishDomain === null) {
      throw new Error(
        "Missing the required parameter 'opts.publishDomain' when calling createLiveToVodTask"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling createLiveToVodTask"
      )
    }
    if (opts.streamName === undefined || opts.streamName === null) {
      throw new Error(
        "Missing the required parameter 'opts.streamName' when calling createLiveToVodTask"
      )
    }
    if (opts.recordFileType === undefined || opts.recordFileType === null) {
      throw new Error(
        "Missing the required parameter 'opts.recordFileType' when calling createLiveToVodTask"
      )
    }

    let postBody = {}
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.fileName !== undefined && opts.fileName !== null) {
      postBody['fileName'] = opts.fileName
    }
    if (opts.fileSize !== undefined && opts.fileSize !== null) {
      postBody['fileSize'] = opts.fileSize
    }
    if (opts.coverUrl !== undefined && opts.coverUrl !== null) {
      postBody['coverUrl'] = opts.coverUrl
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.categoryId !== undefined && opts.categoryId !== null) {
      postBody['categoryId'] = opts.categoryId
    }
    if (opts.tags !== undefined && opts.tags !== null) {
      postBody['tags'] = opts.tags
    }
    if (
      opts.transcodeTemplateGroupId !== undefined &&
      opts.transcodeTemplateGroupId !== null
    ) {
      postBody['transcodeTemplateGroupId'] = opts.transcodeTemplateGroupId
    }
    if (
      opts.transcodeTemplateIds !== undefined &&
      opts.transcodeTemplateIds !== null
    ) {
      postBody['transcodeTemplateIds'] = opts.transcodeTemplateIds
    }
    if (opts.watermarkIds !== undefined && opts.watermarkIds !== null) {
      postBody['watermarkIds'] = opts.watermarkIds
    }
    if (opts.publishDomain !== undefined && opts.publishDomain !== null) {
      postBody['publishDomain'] = opts.publishDomain
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.streamName !== undefined && opts.streamName !== null) {
      postBody['streamName'] = opts.streamName
    }
    if (opts.recordTimes !== undefined && opts.recordTimes !== null) {
      postBody['recordTimes'] = opts.recordTimes
    }
    if (opts.recordFileType !== undefined && opts.recordFileType !== null) {
      postBody['recordFileType'] = opts.recordFileType
    }
    if (opts.taskExternalId !== undefined && opts.taskExternalId !== null) {
      postBody['taskExternalId'] = opts.taskExternalId
    }
    if (opts.priority !== undefined && opts.priority !== null) {
      postBody['priority'] = opts.priority
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createLiveToVodTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/createLiveToVodTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视频上传地址和凭证
      * @param {Object} opts - parameters
      * @param {string} [opts.httpMethod] - HTTP 请求方法，上传支持 PUT 和 POST 方法，默认值为 PUT 。
通过该接口获取到上传地址和凭证之后，后续的上传动作，必须使用和该值一致的方法进行文件上传。
  optional
      * @param {string} opts.title - 视频标题
      * @param {string} opts.fileName - 文件名称
      * @param {integer} [opts.fileSize] - 文件大小  optional
      * @param {string} [opts.coverUrl] - 封面地址  optional
      * @param {string} [opts.description] - 视频描述  optional
      * @param {integer} [opts.categoryId] - 分类ID  optional
      * @param {array} [opts.tags] - 视频标签集合  optional
      * @param {string} [opts.transcodeTemplateGroupId] - 转码模板组ID  optional
      * @param {array} [opts.transcodeTemplateIds] - 转码模板ID集合  optional
      * @param {array} [opts.watermarkIds] - 水印ID集合  optional
      * @param {string} [opts.userData] - 自定义数据  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param videoUploadTaskObject resultObject
      */

  createVideoUploadTask (opts, callback) {
    opts = opts || {}

    if (opts.title === undefined || opts.title === null) {
      throw new Error(
        "Missing the required parameter 'opts.title' when calling createVideoUploadTask"
      )
    }
    if (opts.fileName === undefined || opts.fileName === null) {
      throw new Error(
        "Missing the required parameter 'opts.fileName' when calling createVideoUploadTask"
      )
    }

    let postBody = {}
    if (opts.httpMethod !== undefined && opts.httpMethod !== null) {
      postBody['httpMethod'] = opts.httpMethod
    }
    if (opts.title !== undefined && opts.title !== null) {
      postBody['title'] = opts.title
    }
    if (opts.fileName !== undefined && opts.fileName !== null) {
      postBody['fileName'] = opts.fileName
    }
    if (opts.fileSize !== undefined && opts.fileSize !== null) {
      postBody['fileSize'] = opts.fileSize
    }
    if (opts.coverUrl !== undefined && opts.coverUrl !== null) {
      postBody['coverUrl'] = opts.coverUrl
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.categoryId !== undefined && opts.categoryId !== null) {
      postBody['categoryId'] = opts.categoryId
    }
    if (opts.tags !== undefined && opts.tags !== null) {
      postBody['tags'] = opts.tags
    }
    if (
      opts.transcodeTemplateGroupId !== undefined &&
      opts.transcodeTemplateGroupId !== null
    ) {
      postBody['transcodeTemplateGroupId'] = opts.transcodeTemplateGroupId
    }
    if (
      opts.transcodeTemplateIds !== undefined &&
      opts.transcodeTemplateIds !== null
    ) {
      postBody['transcodeTemplateIds'] = opts.transcodeTemplateIds
    }
    if (opts.watermarkIds !== undefined && opts.watermarkIds !== null) {
      postBody['watermarkIds'] = opts.watermarkIds
    }
    if (opts.userData !== undefined && opts.userData !== null) {
      postBody['userData'] = opts.userData
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createVideoUploadTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videoUploadTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  刷新视频上传地址和凭证
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频地址
      * @param {string} callback - callback
      @return {Object} result
      * @param videoUploadTaskObject resultObject
      */

  refreshVideoUploadTask (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling refreshVideoUploadTask"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.videoId !== undefined && opts.videoId !== null) {
      queryParams['videoId'] = opts.videoId
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call refreshVideoUploadTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videoUploadTask:refresh',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取图片上传地址和凭证
      * @param {Object} opts - parameters
      * @param {string} [opts.httpMethod] - HTTP 请求方法，上传支持 PUT 和 POST 方法，默认值为 PUT 。  optional
      * @param {string} opts.fileName - 文件名称
      * @param {integer} [opts.fileSize] - 文件大小  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param imageUploadTaskObject resultObject
      */

  createImageUploadTask (opts, callback) {
    opts = opts || {}

    if (opts.fileName === undefined || opts.fileName === null) {
      throw new Error(
        "Missing the required parameter 'opts.fileName' when calling createImageUploadTask"
      )
    }

    let postBody = {}
    if (opts.httpMethod !== undefined && opts.httpMethod !== null) {
      postBody['httpMethod'] = opts.httpMethod
    }
    if (opts.fileName !== undefined && opts.fileName !== null) {
      postBody['fileName'] = opts.fileName
    }
    if (opts.fileSize !== undefined && opts.fileSize !== null) {
      postBody['fileSize'] = opts.fileSize
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createImageUploadTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/imageUploadTask',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交质检作业
      * @param {Object} opts - parameters
      * @param {string} [opts.mediaId] - 媒资ID  optional
      * @param {array} [opts.templateIds] - 质检模板ID列表  optional
      * @param {string} callback - callback
      @return {Object} result
      */

  submitQualityDetectionJob (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.mediaId !== undefined && opts.mediaId !== null) {
      postBody['mediaId'] = opts.mediaId
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitQualityDetectionJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionJobs:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量提交质检作业
      * @param {Object} opts - parameters
      * @param {array} [opts.bulkItems]   optional
      * @param {string} callback - callback
      @return {Object} result
      */

  batchSubmitQualityDetectionJobs (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bulkItems !== undefined && opts.bulkItems !== null) {
      postBody['bulkItems'] = opts.bulkItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSubmitQualityDetectionJobs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionJobs:batchSubmit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询质测模板列表。

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listQualityDetectionTemplatesResultObject resultObject
      */

  listQualityDetectionTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listQualityDetectionTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建质检模板
      * @param {Object} opts - parameters
      * @param {string} opts.name - 模板名称。长度不超过128个字符。UTF-8编码。

      * @param {string} opts.templateType - 模板类型，区分该模板的检测内容。目前只支持 video 。
      * @param {array} [opts.detections] - 检测项列表。取值范围：
  blackScreen - 黑场
  pureColor - 纯色
  colorCast - 偏色
  frozenFrame - 静帧
  brightness - 亮度
  contrast - 对比度
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param qualityDetectionTemplateObject resultObject
      */

  createQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createQualityDetectionTemplate"
      )
    }
    if (opts.templateType === undefined || opts.templateType === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateType' when calling createQualityDetectionTemplate"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.templateType !== undefined && opts.templateType !== null) {
      postBody['templateType'] = opts.templateType
    }
    if (opts.detections !== undefined && opts.detections !== null) {
      postBody['detections'] = opts.detections
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询质检模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      * @param qualityDetectionTemplateObject resultObject
      */

  getQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getQualityDetectionTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改质检模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} [opts.name] - 模板名称。长度不超过128个字符。UTF-8编码。
  optional
      * @param {array} [opts.detections] - 检测项列表。取值范围：
  blackScreen - 黑场
  pureColor - 纯色
  colorCast - 偏色
  frozenFrame - 静帧
  brightness - 亮度
  contrast - 对比度
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param qualityDetectionTemplateObject resultObject
      */

  updateQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling updateQualityDetectionTemplate"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.detections !== undefined && opts.detections !== null) {
      postBody['detections'] = opts.detections
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除质检模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteQualityDetectionTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteQualityDetectionTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteQualityDetectionTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/qualityDetectionTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交截图作业

      * @param {Object} opts - parameters
      * @param {array} [opts.videoIds] - 视频ID列表  optional
      * @param {array} [opts.templateIds] - 转码模板ID列表  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submitSnapshotJobsResult resultObject
      */

  submitSnapshotTask (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.videoIds !== undefined && opts.videoIds !== null) {
      postBody['videoIds'] = opts.videoIds
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitSnapshotTask with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotJobs:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频截图任务列表
支持过滤查询：
  - createTime,ge 最早任务创建时间
  - createTime,le 最晚任务创建时间
  - status,in 任务状态IN查询
  - taskId,eq 任务ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTaskSummaryPageInfo resultObject
      */

  listSnapshotTasks (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSnapshotTasks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTasks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图模板列表。
允许通过条件过滤查询，支持的过滤字段如下：
  - snapshotType[eq] 按模板类型精确查询
  - templateId[eq] 按模板ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplatePageInfo resultObject
      */

  listSnapshotTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSnapshotTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateName - 模板标题。长度不超过 128 个字节。UTF-8 编码。
      * @param {string} [opts.snapshotType] - 模板类型。取值范围：
  sample - 采样截图模板
  sprite - 雪碧图模板
  optional
      * @param {imageSampleConfig} [opts.imageSampleConfig] - 采样截图模板配置  optional
      * @param {imageSpriteConfig} [opts.imageSpriteConfig] - 雪碧图模板配置  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  createSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateName === undefined || opts.templateName === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateName' when calling createSnapshotTemplate"
      )
    }

    let postBody = {}
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.snapshotType !== undefined && opts.snapshotType !== null) {
      postBody['snapshotType'] = opts.snapshotType
    }
    if (
      opts.imageSampleConfig !== undefined &&
      opts.imageSampleConfig !== null
    ) {
      postBody['imageSampleConfig'] = opts.imageSampleConfig
    }
    if (
      opts.imageSpriteConfig !== undefined &&
      opts.imageSpriteConfig !== null
    ) {
      postBody['imageSpriteConfig'] = opts.imageSpriteConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  getSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getSnapshotTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} [opts.templateName] - 模板标题。长度不超过 128 个字节。UTF-8 编码。  optional
      * @param {string} [opts.snapshotType] - 模板类型。取值范围：
  sample - 采样截图模板
  sprite - 雪碧图模板
  optional
      * @param {imageSampleConfig} [opts.imageSampleConfig] - 采样截图模板配置  optional
      * @param {imageSpriteConfig} [opts.imageSpriteConfig] - 雪碧图模板配置  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param snapshotTemplateInfo resultObject
      */

  updateSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling updateSnapshotTemplate"
      )
    }

    let postBody = {}
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.snapshotType !== undefined && opts.snapshotType !== null) {
      postBody['snapshotType'] = opts.snapshotType
    }
    if (
      opts.imageSampleConfig !== undefined &&
      opts.imageSampleConfig !== null
    ) {
      postBody['imageSampleConfig'] = opts.imageSampleConfig
    }
    if (
      opts.imageSpriteConfig !== undefined &&
      opts.imageSpriteConfig !== null
    ) {
      postBody['imageSpriteConfig'] = opts.imageSpriteConfig
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除截图模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteSnapshotTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteSnapshotTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteSnapshotTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/snapshotTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交转码作业
      * @param {Object} opts - parameters
      * @param {string} [opts.videoId] - 视频ID  optional
      * @param {string} [opts.templateGroupId] - 转码模板组ID。若此字段不为空，则以模板组方式提交作业，templateIds字段将被忽略。  optional
      * @param {array} [opts.templateIds] - 转码模板ID列表  optional
      * @param {array} [opts.watermarkIds] - 水印ID列表  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submitTranscodeJobResultObject resultObject
      */

  submitTranscodeJob (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.videoId !== undefined && opts.videoId !== null) {
      postBody['videoId'] = opts.videoId
    }
    if (opts.templateGroupId !== undefined && opts.templateGroupId !== null) {
      postBody['templateGroupId'] = opts.templateGroupId
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }
    if (opts.watermarkIds !== undefined && opts.watermarkIds !== null) {
      postBody['watermarkIds'] = opts.watermarkIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitTranscodeJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTasks:submitJob',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量提交转码作业
      * @param {Object} opts - parameters
      * @param {array} [opts.bulkItems]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param batchSubmitTranscodeJobsResultObject resultObject
      */

  batchSubmitTranscodeJobs (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bulkItems !== undefined && opts.bulkItems !== null) {
      postBody['bulkItems'] = opts.bulkItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSubmitTranscodeJobs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTasks:batchSubmitJobs',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频转码摘要
      * @param {Object} opts - parameters
      * @param {string} [opts.videoIds]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeSummaries resultObject
      */

  getTranscodeSummaries (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildArrayParam(opts.videoIds, 'videoIds'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeSummaries with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcode:summary',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码作业摘要
      * @param {Object} opts - parameters
      * @param {integer} [opts.jobIds]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeJobSummaries resultObject
      */

  getTranscodeJobSummaries (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildArrayParam(opts.jobIds, 'jobIds'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeJobSummaries with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeJobs:summary',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码任务摘要
      * @param {Object} opts - parameters
      * @param {integer} [opts.taskIds]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTaskSummaries resultObject
      */

  getTranscodeTaskSummaries (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    Object.assign(queryParams, super.buildArrayParam(opts.taskIds, 'taskIds'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeTaskSummaries with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTasks:summary',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交转码作业
      * @param {Object} opts - parameters
      * @param {string} [opts.videoId] - 视频ID  optional
      * @param {array} [opts.templateIds] - 转码模板ID列表  optional
      * @param {array} [opts.watermarkIds] - 水印ID列表  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submitTranscodeJobResultObject resultObject
      */

  submitTranscodeJob (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.videoId !== undefined && opts.videoId !== null) {
      postBody['videoId'] = opts.videoId
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }
    if (opts.watermarkIds !== undefined && opts.watermarkIds !== null) {
      postBody['watermarkIds'] = opts.watermarkIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitTranscodeJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTasks:submitJob',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量提交转码作业
      * @param {Object} opts - parameters
      * @param {array} [opts.bulkItems]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param batchSubmitTranscodeJobsResultObject resultObject
      */

  batchSubmitTranscodeJobs (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bulkItems !== undefined && opts.bulkItems !== null) {
      postBody['bulkItems'] = opts.bulkItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchSubmitTranscodeJobs with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTasks:batchSubmitJobs',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板列表。
允许通过条件过滤查询，支持的过滤字段如下：
  - source[eq] 按模板来源精确查询
  - templateType[eq] 按模板类型精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listTranscodeTemplatesResultObject resultObject
      */

  listTranscodeTemplates (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTranscodeTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建转码模板
      * @param {Object} opts - parameters
      * @param {string} opts.name - 模板名称。长度不超过128个字符。UTF-8编码。

      * @param {video} opts.video - 视频参数配置
      * @param {audio} opts.audio - 音频参数配置
      * @param {encapsulation} opts.encapsulation - 封装配置
      * @param {outFile} [opts.outFile] - 输出文件配置  optional
      * @param {string} opts.definition - 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K

      * @param {string} [opts.templateType] - 模板类型。取值范围：
  jdchd - 京享超清
  jdchs - 极速转码
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateObject resultObject
      */

  createTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createTranscodeTemplate"
      )
    }
    if (opts.video === undefined || opts.video === null) {
      throw new Error(
        "Missing the required parameter 'opts.video' when calling createTranscodeTemplate"
      )
    }
    if (opts.audio === undefined || opts.audio === null) {
      throw new Error(
        "Missing the required parameter 'opts.audio' when calling createTranscodeTemplate"
      )
    }
    if (opts.encapsulation === undefined || opts.encapsulation === null) {
      throw new Error(
        "Missing the required parameter 'opts.encapsulation' when calling createTranscodeTemplate"
      )
    }
    if (opts.definition === undefined || opts.definition === null) {
      throw new Error(
        "Missing the required parameter 'opts.definition' when calling createTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.video !== undefined && opts.video !== null) {
      postBody['video'] = opts.video
    }
    if (opts.audio !== undefined && opts.audio !== null) {
      postBody['audio'] = opts.audio
    }
    if (opts.encapsulation !== undefined && opts.encapsulation !== null) {
      postBody['encapsulation'] = opts.encapsulation
    }
    if (opts.outFile !== undefined && opts.outFile !== null) {
      postBody['outFile'] = opts.outFile
    }
    if (opts.definition !== undefined && opts.definition !== null) {
      postBody['definition'] = opts.definition
    }
    if (opts.templateType !== undefined && opts.templateType !== null) {
      postBody['templateType'] = opts.templateType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateObject resultObject
      */

  getTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} [opts.name] - 模板名称。长度不超过128个字符。UTF-8编码。
  optional
      * @param {video} [opts.video] - 视频参数配置  optional
      * @param {audio} [opts.audio] - 音频参数配置  optional
      * @param {encapsulation} [opts.encapsulation] - 封装配置  optional
      * @param {outFile} [opts.outFile] - 输出文件配置  optional
      * @param {string} [opts.definition] - 清晰度规格标记。取值范围：
  SD - 标清
  HD - 高清
  FHD - 超清
  2K
  4K
  optional
      * @param {string} [opts.templateType] - 模板类型。取值范围：
  jdchd - 京享超清
  jdchs - 极速转码
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateObject resultObject
      */

  updateTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling updateTranscodeTemplate"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.video !== undefined && opts.video !== null) {
      postBody['video'] = opts.video
    }
    if (opts.audio !== undefined && opts.audio !== null) {
      postBody['audio'] = opts.audio
    }
    if (opts.encapsulation !== undefined && opts.encapsulation !== null) {
      postBody['encapsulation'] = opts.encapsulation
    }
    if (opts.outFile !== undefined && opts.outFile !== null) {
      postBody['outFile'] = opts.outFile
    }
    if (opts.definition !== undefined && opts.definition !== null) {
      postBody['definition'] = opts.definition
    }
    if (opts.templateType !== undefined && opts.templateType !== null) {
      postBody['templateType'] = opts.templateType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转码模板
      * @param {Object} opts - parameters
      * @param {integer} opts.templateId - 模板ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteTranscodeTemplate (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling deleteTranscodeTemplate"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTranscodeTemplate with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplates/{templateId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板组列表。

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateGroupPageData resultObject
      */

  listTranscodeTemplateGroups (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTranscodeTemplateGroups with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建转码模板组
      * @param {Object} opts - parameters
      * @param {string} [opts.groupName] - 转码模板组名称  optional
      * @param {array} [opts.templates]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateGroupData resultObject
      */

  createTranscodeTemplateGroup (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      postBody['groupName'] = opts.groupName
    }
    if (opts.templates !== undefined && opts.templates !== null) {
      postBody['templates'] = opts.templates
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTranscodeTemplateGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询转码模板组
      * @param {Object} opts - parameters
      * @param {string} opts.groupId - 模板组ID
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateGroupData resultObject
      */

  getTranscodeTemplateGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupId === undefined || opts.groupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupId' when calling getTranscodeTemplateGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupId: opts.groupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTranscodeTemplateGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups/{groupId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改转码模板组
      * @param {Object} opts - parameters
      * @param {string} opts.groupId - 模板组ID
      * @param {string} [opts.groupName] - 转码模板组名称  optional
      * @param {array} [opts.templates]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param transcodeTemplateGroupData resultObject
      */

  updateTranscodeTemplateGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupId === undefined || opts.groupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupId' when calling updateTranscodeTemplateGroup"
      )
    }

    let postBody = {}
    if (opts.groupName !== undefined && opts.groupName !== null) {
      postBody['groupName'] = opts.groupName
    }
    if (opts.templates !== undefined && opts.templates !== null) {
      postBody['templates'] = opts.templates
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupId: opts.groupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateTranscodeTemplateGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups/{groupId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转码模板组
      * @param {Object} opts - parameters
      * @param {string} opts.groupId - 模板组ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteTranscodeTemplateGroup (opts, callback) {
    opts = opts || {}

    if (opts.groupId === undefined || opts.groupId === null) {
      throw new Error(
        "Missing the required parameter 'opts.groupId' when calling deleteTranscodeTemplateGroup"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      groupId: opts.groupId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTranscodeTemplateGroup with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups/{groupId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除转码模板组中的模板。

      * @param {Object} opts - parameters
      * @param {string} [opts.groupId] - 模板组ID  optional
      * @param {integer} [opts.templateIds] - 待删除的模板ID列表  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param deleteGroupedTranscodeTemplatesResData resultObject
      */

  deleteGroupedTranscodeTemplates (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.groupId !== undefined && opts.groupId !== null) {
      postBody['groupId'] = opts.groupId
    }
    if (opts.templateIds !== undefined && opts.templateIds !== null) {
      postBody['templateIds'] = opts.templateIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteGroupedTranscodeTemplates with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/transcodeTemplateGroups:deleteGroupedTranscodeTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建视频剪辑作业

      * @param {Object} opts - parameters
      * @param {string} opts.projectName - 工程名称
      * @param {string} [opts.description] - 工程描述  optional
      * @param {timeline} opts.timeline - 时间线信息
      * @param {mediaMetadata} [opts.mediaMetadata] - 剪辑合成媒资元数据  optional
      * @param {string} [opts.userData] - 用户数据，JSON格式的字符串。
在Timeline中的所有MediaClip中，若有2个或以上的不同MediaId，即素材片段来源于2个或以上不同视频，则在提交剪辑作业时，必须在UserData中指明合并后的视频画面的宽高。
如 {\&quot;extendData\&quot;: {\&quot;width\&quot;: 720, \&quot;height\&quot;: 500}}，其中width和height必须为[16, 4096]之间的偶数
videoMode 支持 normal 普通模式 screen_record 屏幕录制模式 两种模式，默认为 normal。
如 &quot;{\&quot;extendData\&quot;:{\&quot;videoMode\&quot;:\&quot;screen_record\&quot;}}&quot;
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submittedVeditJob resultObject
      */

  createVeditJob (opts, callback) {
    opts = opts || {}

    if (opts.projectName === undefined || opts.projectName === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectName' when calling createVeditJob"
      )
    }
    if (opts.timeline === undefined || opts.timeline === null) {
      throw new Error(
        "Missing the required parameter 'opts.timeline' when calling createVeditJob"
      )
    }

    let postBody = {}
    if (opts.projectName !== undefined && opts.projectName !== null) {
      postBody['projectName'] = opts.projectName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.timeline !== undefined && opts.timeline !== null) {
      postBody['timeline'] = opts.timeline
    }
    if (opts.mediaMetadata !== undefined && opts.mediaMetadata !== null) {
      postBody['mediaMetadata'] = opts.mediaMetadata
    }
    if (opts.userData !== undefined && opts.userData !== null) {
      postBody['userData'] = opts.userData
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createVeditJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditJobs',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  提交视频剪辑作业
      * @param {Object} opts - parameters
      * @param {integer} opts.projectId - 工程ID
      * @param {mediaMetadata} [opts.mediaMetadata] - 合成媒资元数据  optional
      * @param {string} [opts.userData] - 用户数据，JSON格式的字符串。
在Timeline中的所有MediaClip中，若有2个或以上的不同MediaId，即素材片段来源于2个或以上不同视频，则在提交剪辑作业时，必须在UserData中指明合并后的视频画面的宽高。
如 {\&quot;extendData\&quot;: {\&quot;width\&quot;: 720, \&quot;height\&quot;: 500}}，其中width和height必须为[16, 4096]之间的偶数
videoMode 支持 normal 普通模式 screen_record 屏幕录制模式 两种模式，默认为 normal。
如 &quot;{\&quot;extendData\&quot;:{\&quot;videoMode\&quot;:\&quot;screen_record\&quot;}}&quot;
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param submittedVeditJob resultObject
      */

  submitVeditJob (opts, callback) {
    opts = opts || {}

    if (opts.projectId === undefined || opts.projectId === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectId' when calling submitVeditJob"
      )
    }

    let postBody = {}
    if (opts.projectId !== undefined && opts.projectId !== null) {
      postBody['projectId'] = opts.projectId
    }
    if (opts.mediaMetadata !== undefined && opts.mediaMetadata !== null) {
      postBody['mediaMetadata'] = opts.mediaMetadata
    }
    if (opts.userData !== undefined && opts.userData !== null) {
      postBody['userData'] = opts.userData
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call submitVeditJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditJobs:submit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频剪辑工程列表。
允许通过条件过滤查询，支持的过滤字段如下：
  - projectId[eq] 按照工程ID精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param veditProjectPageData resultObject
      */

  listVeditProjects (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listVeditProjects with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditProjects',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建视频剪辑工程
      * @param {Object} opts - parameters
      * @param {string} opts.projectName - 工程名称
      * @param {string} [opts.description] - 工程描述  optional
      * @param {timeline} opts.timeline - 时间线信息
      * @param {string} callback - callback
      @return {Object} result
      * @param veditProjectData resultObject
      */

  createVeditProject (opts, callback) {
    opts = opts || {}

    if (opts.projectName === undefined || opts.projectName === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectName' when calling createVeditProject"
      )
    }
    if (opts.timeline === undefined || opts.timeline === null) {
      throw new Error(
        "Missing the required parameter 'opts.timeline' when calling createVeditProject"
      )
    }

    let postBody = {}
    if (opts.projectName !== undefined && opts.projectName !== null) {
      postBody['projectName'] = opts.projectName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.timeline !== undefined && opts.timeline !== null) {
      postBody['timeline'] = opts.timeline
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createVeditProject with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditProjects',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频剪辑工程详情
      * @param {Object} opts - parameters
      * @param {integer} opts.projectId - 视频剪辑工程ID
      * @param {string} callback - callback
      @return {Object} result
      * @param veditProjectData resultObject
      */

  getVeditProject (opts, callback) {
    opts = opts || {}

    if (opts.projectId === undefined || opts.projectId === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectId' when calling getVeditProject"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      projectId: opts.projectId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getVeditProject with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditProjects/{projectId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改视频剪辑工程信息
      * @param {Object} opts - parameters
      * @param {integer} opts.projectId - 视频剪辑工程ID
      * @param {string} [opts.projectName] - 工程名称  optional
      * @param {string} [opts.description] - 工程描述  optional
      * @param {timeline} [opts.timeline] - 时间线信息  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param veditProjectData resultObject
      */

  updateVeditProject (opts, callback) {
    opts = opts || {}

    if (opts.projectId === undefined || opts.projectId === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectId' when calling updateVeditProject"
      )
    }

    let postBody = {}
    if (opts.projectName !== undefined && opts.projectName !== null) {
      postBody['projectName'] = opts.projectName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }
    if (opts.timeline !== undefined && opts.timeline !== null) {
      postBody['timeline'] = opts.timeline
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      projectId: opts.projectId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateVeditProject with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditProjects/{projectId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除视频剪辑工程
      * @param {Object} opts - parameters
      * @param {integer} opts.projectId - 视频剪辑工程ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteVeditProject (opts, callback) {
    opts = opts || {}

    if (opts.projectId === undefined || opts.projectId === null) {
      throw new Error(
        "Missing the required parameter 'opts.projectId' when calling deleteVeditProject"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      projectId: opts.projectId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteVeditProject with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/veditProjects/{projectId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询视频列表信息。
允许通过条件过滤查询，支持的过滤字段如下：
  - status[eq] 按视频状态精确查询
  - categoryId[eq] 按分类ID精确查询
  - videoId[eq] 按视频ID精确查询
  - name[eq] 按视频名称精确查询

      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {filter} [opts.filters]   optional
      * @param {sort} [opts.sorts]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listVideosResultObject resultObject
      */

  listVideos (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))
    Object.assign(queryParams, super.buildSortParam(opts.sorts, 'sorts'))

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listVideos with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询单个视频信息
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} callback - callback
      @return {Object} result
      * @param videoObject resultObject
      */

  getVideo (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling getVideo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getVideo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改视频信息
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} [opts.name] - 视频名称  optional
      * @param {integer} [opts.categoryId] - 分类ID  optional
      * @param {array} [opts.tags] - 标签  optional
      * @param {string} [opts.coverUrl] - 封面地址  optional
      * @param {string} [opts.description] - 视频描述信息  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param videoObject resultObject
      */

  updateVideo (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling updateVideo"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.categoryId !== undefined && opts.categoryId !== null) {
      postBody['categoryId'] = opts.categoryId
    }
    if (opts.tags !== undefined && opts.tags !== null) {
      postBody['tags'] = opts.tags
    }
    if (opts.coverUrl !== undefined && opts.coverUrl !== null) {
      postBody['coverUrl'] = opts.coverUrl
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateVideo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除视频，调用该接口会同时删除与指定视频相关的所有信息，包括转码任务信息、转码流数据等，同时清除云存储中相关文件资源。
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteVideo (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling deleteVideo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteVideo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量删除视频，调用该接口会同时删除与指定视频相关的所有信息，包括转码任务信息、转码流数据等，同时清除云存储中相关文件资源。
      * @param {Object} opts - parameters
      * @param {array} [opts.videoIds] - 视频ID集合  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param batchDeleteVideosResultObject resultObject
      */

  batchDeleteVideos (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.videoIds !== undefined && opts.videoIds !== null) {
      postBody['videoIds'] = opts.videoIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchDeleteVideos with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos:batchDelete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量修改视频信息
      * @param {Object} opts - parameters
      * @param {array} [opts.bulkItems] - 批量更新视频的条目集合  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param batchUpdateVideosResultObject resultObject
      */

  batchUpdateVideos (opts, callback) {
    opts = opts || {}

    let postBody = {}
    if (opts.bulkItems !== undefined && opts.bulkItems !== null) {
      postBody['bulkItems'] = opts.bulkItems
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call batchUpdateVideos with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos:batchUpdate',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视频播放信息
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getPlayInfoResultObject resultObject
      */

  getVideoPlayInfo (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling getVideoPlayInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getVideoPlayInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}:getPlayInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除视频转码流
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {array} [opts.taskIds]   optional
      * @param {string} callback - callback
      @return {Object} result
      * @param deleteVideoStreamsResultObject resultObject
      */

  deleteVideoStreams (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling deleteVideoStreams"
      )
    }

    let postBody = {}
    if (opts.taskIds !== undefined && opts.taskIds !== null) {
      postBody['taskIds'] = opts.taskIds
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteVideoStreams with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}:deleteStreams',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  视频审核
视频在上传中或者转码中不允许更改视频审核状态，即视频只有在正常或屏蔽状态下才可以调用此接口设置审核状态

      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} opts.auditResult - 审核结果，取值范围:
 block(封禁)
 unblock(解封)

      * @param {string} callback - callback
      @return {Object} result
      */

  videoAudit (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling videoAudit"
      )
    }
    if (opts.auditResult === undefined || opts.auditResult === null) {
      throw new Error(
        "Missing the required parameter 'opts.auditResult' when calling videoAudit"
      )
    }

    let postBody = {}
    if (opts.auditResult !== undefined && opts.auditResult !== null) {
      postBody['auditResult'] = opts.auditResult
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call videoAudit with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}:audit',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取视频源文件信息
      * @param {Object} opts - parameters
      * @param {string} opts.videoId - 视频ID
      * @param {string} callback - callback
      @return {Object} result
      * @param getPlayInfoResultObject resultObject
      */

  getVideoSourceInfo (opts, callback) {
    opts = opts || {}

    if (opts.videoId === undefined || opts.videoId === null) {
      throw new Error(
        "Missing the required parameter 'opts.videoId' when calling getVideoSourceInfo"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      videoId: opts.videoId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getVideoSourceInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/videos/{videoId}:getSourceInfo',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询水印列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码；默认值为 1  optional
      * @param {integer} [opts.pageSize] - 分页大小；默认值为 10；取值范围 [10, 100]  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param listWatermarksResultObject resultObject
      */

  listWatermarks (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listWatermarks with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  添加水印
      * @param {Object} opts - parameters
      * @param {string} opts.name - 水印名称。只支持中英文、数字。长度不超过128个字符。UTF-8编码。

      * @param {string} opts.imgUrl - 图片地址
      * @param {string} opts.width - 水印宽度。
当 sizeUnit &#x3D; pixel 时，取值范围为 [8, 4096] 整数
当 sizeUnit &#x3D; percent 时，取值范围为 [0, 100] 小数

      * @param {string} opts.height - 水印高度。
当 sizeUnit &#x3D; pixel 时，取值范围为 [8, 4096] 整数
当 sizeUnit &#x3D; percent 时，取值范围为 [0, 100] 小数

      * @param {string} [opts.sizeUnit] - 尺寸单位。取值范围：
  pixel - 像素
  percent - 百分比
默认值为 pixel
  optional
      * @param {string} [opts.widthRef]   optional
      * @param {string} [opts.heightRef] - 高度参考，仅当 siteUnit &#x3D; percent 时生效。
取值说明：
  w: 输出水印高度 &#x3D; height * 水印原图高度
  v: 等同于 vh
  vw: 输出水印高度 &#x3D; height * 输出视频宽度
  vh: 输出水印高度 &#x3D; height * 输出视频高度
  vls: 输出水印高度 &#x3D; height * 输出视频长边
  vss: 输出水印高度 &#x3D; height * 输出视频短边
  optional
      * @param {string} opts.position - 水印位置。取值范围：
  LT - 左上
  RT - 右上
  LB - 左下
  RB - 右下

      * @param {string} opts.offsetX - 水平偏移。
当 offsetUnit &#x3D; pixel 时，取值范围为 [8, 4088] 整数
当 offsetUnit &#x3D; percent 时，取值范围为 [0, 100] 小数

      * @param {string} opts.offsetY - 竖直偏移。
当 offsetUnit &#x3D; pixel 时，取值范围为 [8, 4088] 整数
当 offsetUnit &#x3D; percent 时，取值范围为 [0, 100] 小数

      * @param {string} [opts.offsetUnit] - 偏移单位。取值范围：
  pixel - 像素
  percent - 百分比
默认值为 pixel
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param watermarkObject resultObject
      */

  createWatermark (opts, callback) {
    opts = opts || {}

    if (opts.name === undefined || opts.name === null) {
      throw new Error(
        "Missing the required parameter 'opts.name' when calling createWatermark"
      )
    }
    if (opts.imgUrl === undefined || opts.imgUrl === null) {
      throw new Error(
        "Missing the required parameter 'opts.imgUrl' when calling createWatermark"
      )
    }
    if (opts.width === undefined || opts.width === null) {
      throw new Error(
        "Missing the required parameter 'opts.width' when calling createWatermark"
      )
    }
    if (opts.height === undefined || opts.height === null) {
      throw new Error(
        "Missing the required parameter 'opts.height' when calling createWatermark"
      )
    }
    if (opts.position === undefined || opts.position === null) {
      throw new Error(
        "Missing the required parameter 'opts.position' when calling createWatermark"
      )
    }
    if (opts.offsetX === undefined || opts.offsetX === null) {
      throw new Error(
        "Missing the required parameter 'opts.offsetX' when calling createWatermark"
      )
    }
    if (opts.offsetY === undefined || opts.offsetY === null) {
      throw new Error(
        "Missing the required parameter 'opts.offsetY' when calling createWatermark"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.imgUrl !== undefined && opts.imgUrl !== null) {
      postBody['imgUrl'] = opts.imgUrl
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.sizeUnit !== undefined && opts.sizeUnit !== null) {
      postBody['sizeUnit'] = opts.sizeUnit
    }
    if (opts.widthRef !== undefined && opts.widthRef !== null) {
      postBody['widthRef'] = opts.widthRef
    }
    if (opts.heightRef !== undefined && opts.heightRef !== null) {
      postBody['heightRef'] = opts.heightRef
    }
    if (opts.position !== undefined && opts.position !== null) {
      postBody['position'] = opts.position
    }
    if (opts.offsetX !== undefined && opts.offsetX !== null) {
      postBody['offsetX'] = opts.offsetX
    }
    if (opts.offsetY !== undefined && opts.offsetY !== null) {
      postBody['offsetY'] = opts.offsetY
    }
    if (opts.offsetUnit !== undefined && opts.offsetUnit !== null) {
      postBody['offsetUnit'] = opts.offsetUnit
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询水印
      * @param {Object} opts - parameters
      * @param {integer} opts.watermarkId - 水印ID
      * @param {string} callback - callback
      @return {Object} result
      * @param watermarkObject resultObject
      */

  getWatermark (opts, callback) {
    opts = opts || {}

    if (opts.watermarkId === undefined || opts.watermarkId === null) {
      throw new Error(
        "Missing the required parameter 'opts.watermarkId' when calling getWatermark"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      watermarkId: opts.watermarkId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks/{watermarkId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改水印
      * @param {Object} opts - parameters
      * @param {integer} opts.watermarkId - 水印ID
      * @param {string} [opts.name] - 水印名称。只支持中英文、数字。长度不超过128个字符。UTF-8编码。
  optional
      * @param {string} [opts.imgUrl] - 图片地址  optional
      * @param {string} [opts.width] - 水印宽度。
当 sizeUnit &#x3D; pixel 时，取值范围为 [8, 4096] 整数
当 sizeUnit &#x3D; percent 时，取值范围为 [0, 100] 小数
  optional
      * @param {string} [opts.height] - 水印高度。
当 sizeUnit &#x3D; pixel 时，取值范围为 [8, 4096] 整数
当 sizeUnit &#x3D; percent 时，取值范围为 [0, 100] 小数
  optional
      * @param {string} [opts.sizeUnit] - 尺寸单位。取值范围：
  pixel - 像素
  percent - 百分比
默认值为 pixel
  optional
      * @param {string} [opts.widthRef]   optional
      * @param {string} [opts.heightRef] - 高度参考，仅当 siteUnit &#x3D; percent 时生效。
取值说明：
  w: 输出水印高度 &#x3D; height * 水印原图高度
  v: 等同于 vh
  vw: 输出水印高度 &#x3D; height * 输出视频宽度
  vh: 输出水印高度 &#x3D; height * 输出视频高度
  vls: 输出水印高度 &#x3D; height * 输出视频长边
  vss: 输出水印高度 &#x3D; height * 输出视频短边
  optional
      * @param {string} [opts.position] - 水印位置。取值范围：
  LT - 左上
  RT - 右上
  LB - 左下
  RB - 右下
  optional
      * @param {string} [opts.offsetX] - 水平偏移。
当 offsetUnit &#x3D; pixel 时，取值范围为 [8, 4088] 整数
当 offsetUnit &#x3D; percent 时，取值范围为 [0, 100] 小数
  optional
      * @param {string} [opts.offsetY] - 竖直偏移。
当 offsetUnit &#x3D; pixel 时，取值范围为 [8, 4088] 整数
当 offsetUnit &#x3D; percent 时，取值范围为 [0, 100] 小数
  optional
      * @param {string} [opts.offsetUnit] - 偏移单位。取值范围：
  pixel - 像素
  percent - 百分比
默认值为 pixel
  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param watermarkObject resultObject
      */

  updateWatermark (opts, callback) {
    opts = opts || {}

    if (opts.watermarkId === undefined || opts.watermarkId === null) {
      throw new Error(
        "Missing the required parameter 'opts.watermarkId' when calling updateWatermark"
      )
    }

    let postBody = {}
    if (opts.name !== undefined && opts.name !== null) {
      postBody['name'] = opts.name
    }
    if (opts.imgUrl !== undefined && opts.imgUrl !== null) {
      postBody['imgUrl'] = opts.imgUrl
    }
    if (opts.width !== undefined && opts.width !== null) {
      postBody['width'] = opts.width
    }
    if (opts.height !== undefined && opts.height !== null) {
      postBody['height'] = opts.height
    }
    if (opts.sizeUnit !== undefined && opts.sizeUnit !== null) {
      postBody['sizeUnit'] = opts.sizeUnit
    }
    if (opts.widthRef !== undefined && opts.widthRef !== null) {
      postBody['widthRef'] = opts.widthRef
    }
    if (opts.heightRef !== undefined && opts.heightRef !== null) {
      postBody['heightRef'] = opts.heightRef
    }
    if (opts.position !== undefined && opts.position !== null) {
      postBody['position'] = opts.position
    }
    if (opts.offsetX !== undefined && opts.offsetX !== null) {
      postBody['offsetX'] = opts.offsetX
    }
    if (opts.offsetY !== undefined && opts.offsetY !== null) {
      postBody['offsetY'] = opts.offsetY
    }
    if (opts.offsetUnit !== undefined && opts.offsetUnit !== null) {
      postBody['offsetUnit'] = opts.offsetUnit
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      watermarkId: opts.watermarkId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks/{watermarkId}',
      'PUT',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除水印
      * @param {Object} opts - parameters
      * @param {integer} opts.watermarkId - 水印ID
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteWatermark (opts, callback) {
    opts = opts || {}

    if (opts.watermarkId === undefined || opts.watermarkId === null) {
      throw new Error(
        "Missing the required parameter 'opts.watermarkId' when calling deleteWatermark"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      watermarkId: opts.watermarkId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  vod/1.2.1'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteWatermark with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/watermarks/{watermarkId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = VOD
