/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Warning
 * Warning API
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'waf'
Service._services[serviceId] = true

/**
 * waf service.
 * @version 1.0.8
 */

class WAF extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'waf.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  获取回源ip段
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param object list
      */

  describeLbOutIp (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  describeLbOutIp"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call describeLbOutIp with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/admin:lboutIp',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  升配订单
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {orderReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  订单编号
      * @param string wafInstanceId  wafInstancdId
      * @param string orderNumber  orderNumber
      */

  upgradeInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  upgradeInstance"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling upgradeInstance"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling upgradeInstance"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call upgradeInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/billing:upgradeInstance',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建waf实例
      * @param {Object} opts - parameters
      * @param {orderReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  buyId
      * @param string wafInstanceId  wafInstanceId
      * @param string orderNumber  orderNumber
      */

  createInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createInstance"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling createInstance"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/billing:createInstance',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取域名可用证书列表
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {getAvailableCertReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string bindCertId  现绑定证书id
      * @param string bindCertName  现绑定证书名称
      * @param string certIds
      * @param string certNames
      * @param integer count  可用证书个数
      * @param string domain  域名
      */

  getAvailableCertForDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getAvailableCertForDomain"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling getAvailableCertForDomain"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getAvailableCertForDomain"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAvailableCertForDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/cert:availableForDomain',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  绑定证书
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {assignCertReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  bindCert (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  bindCert"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling bindCert"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling bindCert"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call bindCert with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/cert:bindCert',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内的bps信息。
      * @param {Object} opts - parameters
      * @param {getChartReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer timeScope
      * @param bps bps  bps数据
      */

  getBpsData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getBpsData"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getBpsData"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getBpsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getBpsData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内的qps信息。
      * @param {Object} opts - parameters
      * @param {getChartReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer timeScope
      * @param qps qps  qps数据
      */

  getQpsData (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getQpsData"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getQpsData"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getQpsData with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getQpsData',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内的状态码报表信息。
      * @param {Object} opts - parameters
      * @param {getStatusCodeReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param statusCodeData statusCodeData  状态码TopN
      */

  getStatusCodeInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getStatusCodeInfo"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getStatusCodeInfo"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getStatusCodeInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getStatusCodeInfo',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内主要的防护信息,新接口，无url响应时间分布。
      * @param {Object} opts - parameters
      * @param {getChartReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer ip  ip访问量
      * @param integer ipPre  之前ip访问量，当时间跨度大于7天时，该值无意义。
      * @param integer pv  PV访问量
      * @param integer pvPre  之前PV访问量，当时间跨度大于7天时，该值无意义。
      * @param integer maxBps  流量峰值
      * @param integer maxBpsPre  之前流量峰值，当时间跨度大于7天时，该值无意义。
      * @param integer wafAnti  Web防护攻击数
      * @param integer wafAntiPre  之前Web防护攻击数，当时间跨度大于7天时，该值无意义。
      * @param integer domainCount  防护网站数
      * @param integer aclAnti  自定义规则防护攻击数
      * @param integer aclAntiPre  之前自定义规则防护攻击数
      * @param integer ccAnti  cc防护攻击数
      * @param integer ccAntiPre  之前cc防护攻击数
      * @param integer botAnti  bot防护攻击数
      * @param integer botAntiPre  之前bot防护攻击数
      */

  getMainAntiInfoNew (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getMainAntiInfoNew"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getMainAntiInfoNew"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getMainAntiInfoNew with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getMainAntiInfoNew',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内的日志详情。
      * @param {Object} opts - parameters
      * @param {string} [opts.wafInstanceId] - 实例id，代表要查询的WAF实例，为空时表示当前用户下的所有实例  optional
      * @param {string} [opts.domain] - 域名，为空时表示当前实例下的所有域名  optional
      * @param {string} [opts.remote_addr] - 来源ip，检索字段  optional
      * @param {string} [opts.document_uri] - URI，检索字段  optional
      * @param {string} [opts.url] - url，检索字段  optional
      * @param {string} [opts.anti_geo] - 来源地域，检索字段  optional
      * @param {string} [opts.request_method] - 请求方法，检索字段  optional
      * @param {string} [opts.action] - 动作，检索字段，支持类型：&quot;&quot;(为空时，默认查询全部动作类型)，&quot;-&quot;(放行)，&quot;notice&quot;(观察)，&quot;forbidden OR status&quot;(拦截)，&quot;redirect&quot;(浏览器跳转)，&quot;verify&quot;(人机交互)  optional
      * @param {string} [opts.status] - 状态码，检索字段  optional
      * @param {string} [opts.logId] - 日志Id，检索字段  optional
      * @param {string} [opts.request_id] - 请求Id，检索字段  optional
      * @param {integer} opts.start - 开始时间戳，单位秒，时间间隔要求大于5分钟，小于30天。
      * @param {integer} opts.end - 结束时间戳，单位秒，时间间隔要求大于5分钟，小于30天。
      * @param {integer} opts.pageSize - 每页显示的个数，默认是10。
      * @param {integer} opts.pageIndex - 页数，默认是1。
      * @param {string} [opts.logType] - 日志类型，检索字段，支持类型：&quot;&quot;(为空时，默认查询全部日志类型)，&quot;access&quot;(访问日志)，&quot;waf&quot;(wafSDK)，&quot;acl&quot;(自定义规则)，&quot;skip&quot;(白名单)，&quot;deny&quot;(黑名单)，&quot;cc&quot;(CC攻击)，&quot;webcache&quot;(网页防篡改)，&quot;css&quot;(跨站脚本攻击)，&quot;sqli&quot;(SQL注入攻击)，&quot;&quot;fileinc&quot;(文件读取/包含攻击)，&quot;cmding&quot;(命令/代码执行攻击)，&quot;sdd&quot;(敏感文件探测)，&quot;malscan&quot;(恶意扫描攻击)，&quot;bckack&quot;(恶意/后门文件攻击)，&quot;xmli&quot;(XML注入攻击)，&quot;dirt&quot;(目录遍历攻击)  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize  每页显示的个数。
      * @param integer pageIndex  页数。
      * @param integer total  总个数。
      * @param esLogEvent events
      */

  getEsLogDetail (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getEsLogDetail"
      )
    }

    opts = opts || {}

    if (opts.start === undefined || opts.start === null) {
      throw new Error(
        "Missing the required parameter 'opts.start' when calling getEsLogDetail"
      )
    }
    if (opts.end === undefined || opts.end === null) {
      throw new Error(
        "Missing the required parameter 'opts.end' when calling getEsLogDetail"
      )
    }
    if (opts.pageSize === undefined || opts.pageSize === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageSize' when calling getEsLogDetail"
      )
    }
    if (opts.pageIndex === undefined || opts.pageIndex === null) {
      throw new Error(
        "Missing the required parameter 'opts.pageIndex' when calling getEsLogDetail"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.wafInstanceId !== undefined && opts.wafInstanceId !== null) {
      queryParams['wafInstanceId'] = opts.wafInstanceId
    }
    if (opts.domain !== undefined && opts.domain !== null) {
      queryParams['domain'] = opts.domain
    }
    if (opts.remote_addr !== undefined && opts.remote_addr !== null) {
      queryParams['remote_addr'] = opts.remote_addr
    }
    if (opts.document_uri !== undefined && opts.document_uri !== null) {
      queryParams['document_uri'] = opts.document_uri
    }
    if (opts.url !== undefined && opts.url !== null) {
      queryParams['url'] = opts.url
    }
    if (opts.anti_geo !== undefined && opts.anti_geo !== null) {
      queryParams['anti_geo'] = opts.anti_geo
    }
    if (opts.request_method !== undefined && opts.request_method !== null) {
      queryParams['request_method'] = opts.request_method
    }
    if (opts.action !== undefined && opts.action !== null) {
      queryParams['action'] = opts.action
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.logId !== undefined && opts.logId !== null) {
      queryParams['logId'] = opts.logId
    }
    if (opts.request_id !== undefined && opts.request_id !== null) {
      queryParams['request_id'] = opts.request_id
    }
    if (opts.start !== undefined && opts.start !== null) {
      queryParams['start'] = opts.start
    }
    if (opts.end !== undefined && opts.end !== null) {
      queryParams['end'] = opts.end
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.pageIndex !== undefined && opts.pageIndex !== null) {
      queryParams['pageIndex'] = opts.pageIndex
    }
    Object.assign(queryParams, super.buildArrayParam(opts.logType, 'logType'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getEsLogDetail with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getEsLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站在一定时间内的报表详情。
      * @param {Object} opts - parameters
      * @param {getAntiEventReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageSize  每页显示的个数。
      * @param integer pageIndex  页数。
      * @param integer total  总个数。
      * @param antiEvent events
      */

  getAntiEvent (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getAntiEvent"
      )
    }

    opts = opts || {}

    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getAntiEvent"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getAntiEvent with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/chart:getAntiEvent',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站lb配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {commonReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string wafInstanceId  实例id
      * @param lbConfig config  网站lb配置
      */

  getDomainLbConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomainLbConfig"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling getDomainLbConfig"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getDomainLbConfig"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainLbConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:getDomainLbConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新增网站
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {addDomain} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addDomain"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling addDomain"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addDomain"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:add',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新网站
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {addDomain} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateDomain"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling updateDomain"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling updateDomain"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:update',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除网站
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {commonReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  deleteDomain (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteDomain"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling deleteDomain"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling deleteDomain"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDomain with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:delete',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站列表
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listDomains} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string wafInstanceId  实例id
      * @param string list
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer totalCount  该实例下总共的域名数量
      * @param integer maxLimit  最大支持的数目
      */

  listDomains (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listDomains"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listDomains"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listDomains"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listDomains with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:list',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取域名防护配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {commonReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string domain  域名
      * @param integer disableWaf  waf状态 1表示关闭waf
      * @param integer enableJs  js验证全局开关 0表示关闭
      * @param aclConf aclConf  网站waf防护配置
      * @param spiderConf antispiderConf  网站防爬虫防护配置
      * @param ccConf ccConf  网站cc防护配置
      * @param denyConf denyConf  网站黑名单防护配置
      * @param intSemConf intSemConf  网站智能语义引擎防护配置
      * @param ipbanConf ipbanConf  网站恶意ip防护配置
      * @param ipbanUsrConf ipbanUsrConf  网站恶意ip自定义防护配置
      * @param ratelimitConf ratelimitConf  网站限速规则防护配置
      * @param enableConf threatinfoConf  网站威胁情报防护配置
      * @param userDefPageConf userDefPageConf  网站自定义页面配置
      * @param wafConf wafConf  网站waf防护配置
      * @param webUserdefConf webUserdefConf  网站web自定义规则防护配置
      * @param enableConf webcacheConf  网站防篡改防护配置
      * @param skipConf skipConf  网站白名单防护配置
      * @param filterHeaderConf filterHeaderConf  网站请求头管理防护配置
      * @param filterSenseConf filterSenseConf  网站敏感信息防护配置
      * @param statusConf statusConf  状态码修改配置
      * @param uriRewriteConf uriRewriteConf  网站uri重写规则配置
      * @param enableConf proxycacheConf  proxy缓存配置
      * @param riskConf riskConf  risk配置
      * @param botConf botConf  bot配置
      */

  getDomainAntiConfig (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDomainAntiConfig"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling getDomainAntiConfig"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling getDomainAntiConfig"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDomainAntiConfig with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:getAntiConfig',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  cname解析到回源
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {activeFuncReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  enableCname2RsExternal (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  enableCname2RsExternal"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling enableCname2RsExternal"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling enableCname2RsExternal"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableCname2RsExternal with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:enableCname2RsExternal',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listDomains} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string wafInstanceId  实例id
      * @param domainMainConfig list
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer maxLimit  最大支持的数目
      * @param integer totalCount  当前实例域名总数
      * @param integer tldLimit  最大支持一级域名的数目
      * @param integer tldNum  一级域名个数
      * @param integer count  本次查询域名个数
      * @param string invalidRegion
      * @param integer invalidIpv6  Ipv6是否故障,1:故障 0:健康
      */

  listMainCfg (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listMainCfg"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listMainCfg"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listMainCfg"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listMainCfg with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:listMainCfg',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  规则开关
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {disableRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  disableRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  disableRules"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling disableRules"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling disableRules"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call disableRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/domain:disableRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  激活waf
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {enableReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  enableWaf (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  enableWaf"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling enableWaf"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling enableWaf"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableWaf with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:enable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置waf防护模式
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {antiModeWafReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  antiModeWaf (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  antiModeWaf"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling antiModeWaf"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling antiModeWaf"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call antiModeWaf with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:antiMode',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置waf策略等级
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {antiLevelWafReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  antiLevelWaf (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  antiLevelWaf"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling antiLevelWaf"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling antiLevelWaf"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call antiLevelWaf with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:antiLevel',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  激活waf自定义规则
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setWafUserDefineReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  enableWafUserDefine (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  enableWafUserDefine"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling enableWafUserDefine"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling enableWafUserDefine"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call enableWafUserDefine with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:setWafUserDefine',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置waf自定义规则
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setWafRuleReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setWafRule (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setWafRule"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling setWafRule"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling setWafRule"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWafRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:setRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除waf自定义规则
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {delRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delWafRule (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delWafRule"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling delWafRule"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling delWafRule"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delWafRule with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:delRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站的waf自定义规则
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listWafRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer totalCount  配置总数
      * @param listWafRuleCfg list
      */

  listWafRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listWafRules"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listWafRules"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listWafRules"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listWafRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:listRules',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置网站黑白名单ip配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setIpReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addIps (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addIps"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling addIps"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addIps"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addIps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/userdefine:addIps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  更新网站黑白名单ip配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setIpReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  updateIps (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  updateIps"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling updateIps"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling updateIps"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call updateIps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/userdefine:updateIps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站黑白名单ip配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listDenySkipRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param string wafInstanceId  实例id
      * @param string domain  域名
      * @param string iswhite  0表示黑名单 1表示白名单
      * @param integer pageIndex  页码，[1-100]
      * @param integer pageSize  页大小，[1-100]
      * @param integer count  总数
      * @param ipListCfg data
      */

  listIps (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listIps"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listIps"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listIps"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listIps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/userdefine:listIps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除网站黑白名单ip配置
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {delRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delIps (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delIps"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling delIps"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling delIps"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delIps with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/userdefine:delIps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  设置网站waf自定义防护条件
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setWafConditionReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  setWafCondition (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  setWafCondition"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling setWafCondition"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling setWafCondition"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call setWafCondition with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:setCondition',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除网站waf自定义防护条件
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {delRulesReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  delWafCondition (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  delWafCondition"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling delWafCondition"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling delWafCondition"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call delWafCondition with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:delCondition',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站waf自定义防护条件
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listWafConditionsReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer totalCount  配置总数
      * @param listWafConditionCfg list
      */

  listWafConditions (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listWafConditions"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listWafConditions"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listWafConditions"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listWafConditions with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:listConditions',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站waf自定义防护过滤器
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listWafFilterReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer totalCount  配置总数
      * @param listWafFilterCfg list  网站waf自定义防护过滤器设置
      */

  listWafFilter (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listWafFilter"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listWafFilter"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listWafFilter"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listWafFilter with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/waf:listFilter',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  新增防篡改条目
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {setWebcacheUrlReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  addWebcacheUrl (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  addWebcacheUrl"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling addWebcacheUrl"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling addWebcacheUrl"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call addWebcacheUrl with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/webcache:addWebcacheUrl',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  刷新某条防篡改条目
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {commonNameReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      */

  refreshUrlCache (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  refreshUrlCache"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling refreshUrlCache"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling refreshUrlCache"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call refreshUrlCache with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/webcache:refreshUrlCache',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取网站已知类型bot规则
      * @param {Object} opts - parameters
      * @param {string} opts.wafInstanceId - 实例Id
      * @param {listBotStdRuleReq} opts.req - 请求
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer pageIndex  页码
      * @param integer pageSize  页大小
      * @param integer totalCount  配置总数
      * @param stdBotRules list
      */

  listBotStdRules (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listBotStdRules"
      )
    }

    opts = opts || {}

    if (opts.wafInstanceId === undefined || opts.wafInstanceId === null) {
      throw new Error(
        "Missing the required parameter 'opts.wafInstanceId' when calling listBotStdRules"
      )
    }
    if (opts.req === undefined || opts.req === null) {
      throw new Error(
        "Missing the required parameter 'opts.req' when calling listBotStdRules"
      )
    }

    let postBody = {}
    if (opts.req !== undefined && opts.req !== null) {
      postBody['req'] = opts.req
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      wafInstanceId: opts.wafInstanceId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listBotStdRules with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/wafInstanceIds/{wafInstanceId}/bot:listStdRule',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取实例ID及相关信息列表
      * @param {Object} opts - parameters
      * @param {string} [opts.idc] - 所属地区， 模糊匹配  optional
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} [opts.sourceIds] - 资源id 多个时，以逗号,分隔。  optional
      * @param {filter} [opts.filters] - wafInstanceId - 实例id  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param integer total  总个数。
      * @param instanceIdCfg instanceIdCfg
      */

  getWafInstance (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getWafInstance"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.idc !== undefined && opts.idc !== null) {
      queryParams['idc'] = opts.idc
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.sourceIds !== undefined && opts.sourceIds !== null) {
      queryParams['sourceIds'] = opts.sourceIds
    }
    Object.assign(queryParams, super.buildFilterParam(opts.filters, 'filters'))

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  waf/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getWafInstance with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/regions/{regionId}/user:getWafInstance',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = WAF
