/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * table
 * API related to XDATA-DW table
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'xdata'
Service._services[serviceId] = true

/**
 * xdata service.
 * @version 1.1.0
 */

JDCloud.XDATA = class XDATA extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'xdata.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询用户实例的所有数据库信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceName - 实例名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param dwDatabaseInfo data
      */

  listDatabaseInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listDatabaseInfo"
      )
    }

    opts = opts || {}

    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling listDatabaseInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listDatabaseInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwDatabase',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户实例的指定数据库信息
      * @param {Object} opts - parameters
      * @param {string} opts.databaseName - 数据库名
      * @param {string} opts.instanceName - 实例名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param dwDatabase data
      */

  getDatabaseInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getDatabaseInfo"
      )
    }

    opts = opts || {}

    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling getDatabaseInfo"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling getDatabaseInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }

    let pathParams = {
      regionId: regionId,
      databaseName: opts.databaseName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getDatabaseInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwDatabase/{databaseName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建属于用户实例的数据库
      * @param {Object} opts - parameters
      * @param {string} opts.databaseName - 数据库名
      * @param {string} opts.instanceName - 实例名称
      * @param {string} [opts.description] - 数据库描述信息  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  createDatabase (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createDatabase"
      )
    }

    opts = opts || {}

    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling createDatabase"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling createDatabase"
      )
    }

    let postBody = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (opts.description !== undefined && opts.description !== null) {
      postBody['description'] = opts.description
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId,
      databaseName: opts.databaseName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createDatabase with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwDatabase/{databaseName}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户实例的指定数据库
      * @param {Object} opts - parameters
      * @param {string} opts.databaseName - 数据库名
      * @param {string} opts.instanceName - 实例名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  deleteDatabase (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteDatabase"
      )
    }

    opts = opts || {}

    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling deleteDatabase"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling deleteDatabase"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }

    let pathParams = {
      regionId: regionId,
      databaseName: opts.databaseName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteDatabase with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwDatabase/{databaseName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户所属的实例信息
      * @param {Object} opts - parameters
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param dwInstance data
      */

  listInstanceInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listInstanceInfo"
      )
    }

    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listInstanceInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwInstance',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行用户编写的Spark SQL脚本
      * @param {Object} opts - parameters
      * @param {string} [opts.databaseName] - 数据库名称  optional
      * @param {string} opts.sql - sql脚本
      * @param {string} opts.userName - 用户名称
      * @param {string} [opts.queueName] - 队列名称  optional
      * @param {string} [opts.source] - 资源名称  optional
      * @param {string} [opts.callBackURL] - 回调地址名称  optional
      * @param {string} opts.instanceName - 实例名称
      * @param {string} [opts.instanceOwnerName] - 实例拥有者名称  optional
      * @param {string} [opts.isExplain] - 是否需要解释  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param integer data
      */

  executeRasQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  executeRasQuery"
      )
    }

    opts = opts || {}

    if (opts.sql === undefined || opts.sql === null) {
      throw new Error(
        "Missing the required parameter 'opts.sql' when calling executeRasQuery"
      )
    }
    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling executeRasQuery"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling executeRasQuery"
      )
    }

    let postBody = {}
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      postBody['databaseName'] = opts.databaseName
    }
    if (opts.sql !== undefined && opts.sql !== null) {
      postBody['sql'] = opts.sql
    }
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.queueName !== undefined && opts.queueName !== null) {
      postBody['queueName'] = opts.queueName
    }
    if (opts.source !== undefined && opts.source !== null) {
      postBody['source'] = opts.source
    }
    if (opts.callBackURL !== undefined && opts.callBackURL !== null) {
      postBody['callBackURL'] = opts.callBackURL
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (
      opts.instanceOwnerName !== undefined &&
      opts.instanceOwnerName !== null
    ) {
      postBody['instanceOwnerName'] = opts.instanceOwnerName
    }
    if (opts.isExplain !== undefined && opts.isExplain !== null) {
      postBody['isExplain'] = opts.isExplain
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call executeRasQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:executeRasQuery',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  执行用户编写的PySpark脚本
      * @param {Object} opts - parameters
      * @param {string} opts.script - PySpark脚本
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.instanceName - 实例名称
      * @param {string} [opts.instanceOwnerName] - 实例拥有者名称  optional
      * @param {string} [opts.scriptType] - 脚本类型名称  optional
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param integer data
      */

  executePySparkQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  executePySparkQuery"
      )
    }

    opts = opts || {}

    if (opts.script === undefined || opts.script === null) {
      throw new Error(
        "Missing the required parameter 'opts.script' when calling executePySparkQuery"
      )
    }
    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling executePySparkQuery"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling executePySparkQuery"
      )
    }

    let postBody = {}
    if (opts.script !== undefined && opts.script !== null) {
      postBody['script'] = opts.script
    }
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (
      opts.instanceOwnerName !== undefined &&
      opts.instanceOwnerName !== null
    ) {
      postBody['instanceOwnerName'] = opts.instanceOwnerName
    }
    if (opts.scriptType !== undefined && opts.scriptType !== null) {
      postBody['scriptType'] = opts.scriptType
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call executePySparkQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:executePySparkQuery',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户Spark SQL脚本的查询状态
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param string data
      */

  getRasQueryState (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getRasQueryState"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling getRasQueryState"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling getRasQueryState"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      queryParams['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      queryParams['queryId'] = opts.queryId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRasQueryState with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:getRasQueryState',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户PySpark脚本的执行状态
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param string data
      */

  getPySparkExecuteState (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getPySparkExecuteState"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling getPySparkExecuteState"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling getPySparkExecuteState"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      queryParams['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      queryParams['queryId'] = opts.queryId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPySparkExecuteState with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:getPySparkExecuteState',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户Spark SQL脚本的查询日志
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  getRasQueryLog (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getRasQueryLog"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling getRasQueryLog"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling getRasQueryLog"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      queryParams['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      queryParams['queryId'] = opts.queryId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRasQueryLog with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:getRasQueryLog',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户Spark SQL脚本的查询结果
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  getRasQueryResult (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getRasQueryResult"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling getRasQueryResult"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling getRasQueryResult"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      queryParams['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      queryParams['queryId'] = opts.queryId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getRasQueryResult with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:getRasQueryResult',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取用户PySpark脚本的执行结果
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  getPySparkExecuteResult (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getPySparkExecuteResult"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling getPySparkExecuteResult"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling getPySparkExecuteResult"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      queryParams['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      queryParams['queryId'] = opts.queryId
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getPySparkExecuteResult with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:getPySparkExecuteResult',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  终止用户Spark SQL脚本查询
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  cancelRasQuery (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  cancelRasQuery"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling cancelRasQuery"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling cancelRasQuery"
      )
    }

    let postBody = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      postBody['queryId'] = opts.queryId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cancelRasQuery with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:cancelRasQuery',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  终止用户PySpark脚本任务
      * @param {Object} opts - parameters
      * @param {string} opts.userName - 用户名称
      * @param {string} opts.queryId - 查询id
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  cancelPySparkJob (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  cancelPySparkJob"
      )
    }

    opts = opts || {}

    if (opts.userName === undefined || opts.userName === null) {
      throw new Error(
        "Missing the required parameter 'opts.userName' when calling cancelPySparkJob"
      )
    }
    if (opts.queryId === undefined || opts.queryId === null) {
      throw new Error(
        "Missing the required parameter 'opts.queryId' when calling cancelPySparkJob"
      )
    }

    let postBody = {}
    if (opts.userName !== undefined && opts.userName !== null) {
      postBody['userName'] = opts.userName
    }
    if (opts.queryId !== undefined && opts.queryId !== null) {
      postBody['queryId'] = opts.queryId
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call cancelPySparkJob with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwQuery:cancelPySparkQuery',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户实例指定数据库下的所有数据表信息
      * @param {Object} opts - parameters
      * @param {string} opts.instanceName - 实例名称
      * @param {string} opts.databaseName - 数据库名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param dwTable data
      */

  listTableInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  listTableInfo"
      )
    }

    opts = opts || {}

    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling listTableInfo"
      )
    }
    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling listTableInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      queryParams['databaseName'] = opts.databaseName
    }

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listTableInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwTable',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建用户实例的数据表
      * @param {Object} opts - parameters
      * @param {string} opts.instanceName - 实例名称
      * @param {dwTableDesc} opts.dbModelDBTable - 数据表描述信息
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      */

  createTable (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  createTable"
      )
    }

    opts = opts || {}

    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling createTable"
      )
    }
    if (opts.dbModelDBTable === undefined || opts.dbModelDBTable === null) {
      throw new Error(
        "Missing the required parameter 'opts.dbModelDBTable' when calling createTable"
      )
    }

    let postBody = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      postBody['instanceName'] = opts.instanceName
    }
    if (opts.dbModelDBTable !== undefined && opts.dbModelDBTable !== null) {
      postBody['dbModelDBTable'] = opts.dbModelDBTable
    }

    let queryParams = {}

    let pathParams = {
      regionId: regionId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createTable with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwTable',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户实例的指定数据表信息
      * @param {Object} opts - parameters
      * @param {string} opts.tableName - 数据表名
      * @param {string} opts.instanceName - 实例名称
      * @param {string} opts.databaseName - 数据库名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param dwTable data
      */

  getTableInfo (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  getTableInfo"
      )
    }

    opts = opts || {}

    if (opts.tableName === undefined || opts.tableName === null) {
      throw new Error(
        "Missing the required parameter 'opts.tableName' when calling getTableInfo"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling getTableInfo"
      )
    }
    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling getTableInfo"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      queryParams['databaseName'] = opts.databaseName
    }

    let pathParams = {
      regionId: regionId,
      tableName: opts.tableName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getTableInfo with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwTable/{tableName}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除用户实例的指定数据表
      * @param {Object} opts - parameters
      * @param {string} opts.tableName - 数据表名
      * @param {string} opts.instanceName - 实例名称
      * @param {string} opts.databaseName - 数据库名称
      * @param {string} regionId - ID of the region
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean status
      * @param string message
      * @param object data
      */

  deleteTable (opts, regionId = this.config.regionId, callback) {
    if (typeof regionId === 'function') {
      callback = regionId
      regionId = this.config.regionId
    }

    if (regionId === undefined || regionId === null) {
      throw new Error(
        "Missing the required parameter 'regionId' when calling  deleteTable"
      )
    }

    opts = opts || {}

    if (opts.tableName === undefined || opts.tableName === null) {
      throw new Error(
        "Missing the required parameter 'opts.tableName' when calling deleteTable"
      )
    }
    if (opts.instanceName === undefined || opts.instanceName === null) {
      throw new Error(
        "Missing the required parameter 'opts.instanceName' when calling deleteTable"
      )
    }
    if (opts.databaseName === undefined || opts.databaseName === null) {
      throw new Error(
        "Missing the required parameter 'opts.databaseName' when calling deleteTable"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.instanceName !== undefined && opts.instanceName !== null) {
      queryParams['instanceName'] = opts.instanceName
    }
    if (opts.databaseName !== undefined && opts.databaseName !== null) {
      queryParams['databaseName'] = opts.databaseName
    }

    let pathParams = {
      regionId: regionId,
      tableName: opts.tableName
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  xdata/1.1.0'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call deleteTable with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = this.makeRequest(
      '/regions/{regionId}/dwTable/{tableName}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = JDCloud.XDATA
