/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 云鼎短信服务-用户相关接口
 * 云鼎短信服务-用户相关接口
 *
 * OpenAPI spec version: v1
 * Contact:
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

require('../../../lib/node_loader')
var JDCloud = require('../../../lib/core')
var Service = JDCloud.Service
var serviceId = 'ydsms'
Service._services[serviceId] = true

/**
 * ydsms service.
 * @version 1.0.8
 */

class YDSMS extends Service {
  constructor (options = {}) {
    options._defaultEndpoint = {}
    options._defaultEndpoint.protocol =
      options._defaultEndpoint.protocol || 'https'
    options._defaultEndpoint.host =
      options._defaultEndpoint.host || 'ydsms.jdcloud-api.com'
    options.basePath = '/v1' // 默认要设为空""
    super(serviceId, options)
  }

  /**
      *  查询应用列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} [opts.status] - 状态，0 停用 1 启用  optional
      * @param {string} [opts.appName] - 应用名称  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param smsAppVO smsApps
      * @param integer totalCount
      */

  listSmsAppsUsingGET (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      queryParams['appName'] = opts.appName
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsAppsUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建短信应用
      * @param {Object} opts - parameters
      * @param {} opts.appDesc - 应用描述
      * @param {} [opts.appId] - 云鼎应用id  optional
      * @param {} opts.appName - 应用名称
      * @param {} [opts.accessKeyId] - accessKeyId  optional
      * @param {} [opts.accessKeySecret] - accessKeySecret  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string appId  应用id
      */

  createSmsAppUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appDesc === undefined || opts.appDesc === null) {
      throw new Error(
        "Missing the required parameter 'opts.appDesc' when calling createSmsAppUsingPOST"
      )
    }
    if (opts.appName === undefined || opts.appName === null) {
      throw new Error(
        "Missing the required parameter 'opts.appName' when calling createSmsAppUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appDesc !== undefined && opts.appDesc !== null) {
      postBody['appDesc'] = opts.appDesc
    }
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }
    if (opts.accessKeyId !== undefined && opts.accessKeyId !== null) {
      postBody['accessKeyId'] = opts.accessKeyId
    }
    if (opts.accessKeySecret !== undefined && opts.accessKeySecret !== null) {
      postBody['accessKeySecret'] = opts.accessKeySecret
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSmsAppUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用详情
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {string} callback - callback
      @return {Object} result
      * @param smsAppVO smsAppVO
      */

  getSmsAppByIdUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling getSmsAppByIdUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsAppByIdUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  编辑短信应用
      * @param {Object} opts - parameters
      * @param {string} opts.appId - appId
      * @param {} [opts.appDesc] - 应用描述  optional
      * @param {} [opts.appName] - 应用名称  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string appId  应用id
      */

  modifySmsAppUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling modifySmsAppUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appDesc !== undefined && opts.appDesc !== null) {
      postBody['appDesc'] = opts.appDesc
    }
    if (opts.appName !== undefined && opts.appName !== null) {
      postBody['appName'] = opts.appName
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySmsAppUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用secretKey
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {string} callback - callback
      @return {Object} result
      * @param string secretKey  密钥
      */

  querySecretKeyUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling querySecretKeyUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySecretKeyUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:querySecretKey',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改应用启停状态
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {integer} [opts.status] - 应用状态,0 停用 1 启用  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string appId  应用id
      */

  modifyStatusUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling modifyStatusUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyStatusUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:modifyStatus',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用发送短信总体情况
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id，传all查询所有应用的数据总和
      * @param {integer} [opts.packageType] - 套餐包类型，1普通短信 2官方短信，默认为1  optional
      * @param {string} [opts.templateId] - 模板id  optional
      * @param {string} opts.endTime - 结束时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} opts.startTime - 开始时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} callback - callback
      @return {Object} result
      * @param string pin  pin
      * @param string appId  应用id
      * @param sendOverviewVO sendOverviewVOList
      */

  listSmsSendOverviewUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling listSmsSendOverviewUsingGET"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling listSmsSendOverviewUsingGET"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling listSmsSendOverviewUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.packageType !== undefined && opts.packageType !== null) {
      queryParams['packageType'] = opts.packageType
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      queryParams['templateId'] = opts.templateId
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsSendOverviewUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:overview',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信发送记录
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {integer} [opts.sendStatus] - 发送状态，0 全部状态 1 发送成功 2 发送失败 3 已发送未回执， 默认为0  optional
      * @param {string} [opts.sendNumber] - 手机号码  optional
      * @param {string} [opts.templateId] - 模板id  optional
      * @param {string} [opts.sign_id] - 签名id  optional
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} opts.endTime - 结束时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} opts.startTime - 开始时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} callback - callback
      @return {Object} result
      * @param sendRecord sendRecords
      * @param integer totalCount
      */

  querySendRecordUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling querySendRecordUsingGET"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling querySendRecordUsingGET"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling querySendRecordUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.sendStatus !== undefined && opts.sendStatus !== null) {
      queryParams['sendStatus'] = opts.sendStatus
    }
    if (opts.sendNumber !== undefined && opts.sendNumber !== null) {
      queryParams['sendNumber'] = opts.sendNumber
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      queryParams['templateId'] = opts.templateId
    }
    if (opts.sign_id !== undefined && opts.sign_id !== null) {
      queryParams['sign_id'] = opts.sign_id
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call querySendRecordUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:querySendRecord',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信回复记录
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {string} [opts.sendNumber] - 手机号码  optional
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} opts.endTime - 结束时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} opts.startTime - 开始时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} callback - callback
      @return {Object} result
      * @param replyRecord replyRecords
      * @param integer totalCount
      */

  queryReplyRecordUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling queryReplyRecordUsingGET"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling queryReplyRecordUsingGET"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling queryReplyRecordUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.sendNumber !== undefined && opts.sendNumber !== null) {
      queryParams['sendNumber'] = opts.sendNumber
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryReplyRecordUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:queryReplyRecord',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信回执记录
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {string} opts.endTime - 结束时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} opts.startTime - 开始时间,pattern &#x3D;&quot;yyyy-MM-dd HH:mm:ss&quot;,timezone&#x3D;&quot;GMT+8&quot;
      * @param {string} callback - callback
      @return {Object} result
      * @param string pin  pin
      * @param string appId  应用id
      * @param receiptRecord receiptRecords
      */

  queryReceiptRecordUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling queryReceiptRecordUsingGET"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling queryReceiptRecordUsingGET"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling queryReceiptRecordUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryReceiptRecordUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsApps/{appId}:queryReceiptRecord',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用通用设置列表
      * @param {Object} opts - parameters
      * @param {string} [opts.appId] - 应用id  optional
      * @param {integer} [opts.type] - 通用设置类型，0发送频率设置 1发送超量提醒 2短信发送状态回调地址  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param generalSettings appGeneralSettings
      */

  listSmsAppGeneralSettingsUsingGET (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.type !== undefined && opts.type !== null) {
      queryParams['type'] = opts.type
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsAppGeneralSettingsUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsAppGeneralSettings',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  修改应用通用设置
      * @param {Object} opts - parameters
      * @param {integer} [opts.id] - id  optional
      * @param {string} [opts.settingValue] - 设置的值  optional
      * @param {integer} [opts.status] - 是否启用，当前设置是否生效，0未生效 1生效  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  是否修改成功
      */

  modifyAppGeneralSettingById (opts, callback) {
    opts = opts || {}

    if (opts.id === undefined || opts.id === null) {
      throw new Error(
        "Missing the required parameter 'opts.id' when calling modifyAppGeneralSettingById"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.settingValue !== undefined && opts.settingValue !== null) {
      queryParams['settingValue'] = opts.settingValue
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }

    let pathParams = {
      regionId: 'jdcloud',
      id: opts.id
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifyAppGeneralSettingById with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsAppGeneralSettings/{id}:modify',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信签名证明材料类型列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param certificateType certificateTypes
      */

  listSmsCertificateTypesUsingGET (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsCertificateTypesUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsCertificateTypes',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询应用发送短信总体情况
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {string} opts.endTime - 结束时间
      * @param {string} opts.startTime - 开始时间
      * @param {string} callback - callback
      @return {Object} result
      */

  listSmsSendOverviewUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling listSmsSendOverviewUsingGET"
      )
    }
    if (opts.endTime === undefined || opts.endTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.endTime' when calling listSmsSendOverviewUsingGET"
      )
    }
    if (opts.startTime === undefined || opts.startTime === null) {
      throw new Error(
        "Missing the required parameter 'opts.startTime' when calling listSmsSendOverviewUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.endTime !== undefined && opts.endTime !== null) {
      queryParams['endTime'] = opts.endTime
    }
    if (opts.startTime !== undefined && opts.startTime !== null) {
      queryParams['startTime'] = opts.startTime
    }

    let pathParams = {
      regionId: 'jdcloud',
      appId: opts.appId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsSendOverviewUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/apps/{appId}:overview',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询套餐包列表
      * @param {Object} opts - parameters
      * @param {integer} [opts.packageType] - 套餐包类型:1通道短信，2官方短信  optional
      * @param {integer} [opts.pageNumber] - pageNumber  optional
      * @param {integer} [opts.pageSize] - pageSize  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param smsPackageVO smsPackages
      * @param integer totalCount
      */

  listSmsPackagesUsingGET (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}
    if (opts.packageType !== undefined && opts.packageType !== null) {
      queryParams['packageType'] = opts.packageType
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsPackagesUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsPackages',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建套餐包
      * @param {Object} opts - parameters
      * @param {} opts.packageCount - 套餐包数量
      * @param {} opts.packageType - 套餐包类型，1通道短信，2官方短信
      * @param {} opts.specification - 套餐包规格
      * @param {string} callback - callback
      @return {Object} result
      * @param string buyId  购物车id，预付费需登陆控制台https://buy.jdcloud.com/confirm?buyId&#x3D;xxx 确认订单
      */

  createSmsPackageUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.packageCount === undefined || opts.packageCount === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageCount' when calling createSmsPackageUsingPOST"
      )
    }
    if (opts.packageType === undefined || opts.packageType === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageType' when calling createSmsPackageUsingPOST"
      )
    }
    if (opts.specification === undefined || opts.specification === null) {
      throw new Error(
        "Missing the required parameter 'opts.specification' when calling createSmsPackageUsingPOST"
      )
    }

    let postBody = {}
    if (opts.packageCount !== undefined && opts.packageCount !== null) {
      postBody['packageCount'] = opts.packageCount
    }
    if (opts.packageType !== undefined && opts.packageType !== null) {
      postBody['packageType'] = opts.packageType
    }
    if (opts.specification !== undefined && opts.specification !== null) {
      postBody['specification'] = opts.specification
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSmsPackageUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsPackages',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询套餐包详情
      * @param {Object} opts - parameters
      * @param {string} opts.packageId - 套餐包id
      * @param {string} callback - callback
      @return {Object} result
      * @param smsPackageVO smsPackageVO
      */

  getSmsPackageByIdUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.packageId === undefined || opts.packageId === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageId' when calling getSmsPackageByIdUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      packageId: opts.packageId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsPackageByIdUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsPackages/{packageId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询套餐包规格列表
      * @param {Object} opts - parameters
      * @param {integer} opts.packageType - 套餐包类型，1通道短信 2官方短信
      * @param {string} callback - callback
      @return {Object} result
      * @param specificationVO specificationVOS
      */

  getSmsPackageSpecificationsUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.packageType === undefined || opts.packageType === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageType' when calling getSmsPackageSpecificationsUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      packageType: opts.packageType
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsPackageSpecificationsUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsPackages/{packageType}:querySpecifications',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  批量发送短信
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} [opts.params] - 短信模板变量对应的数据值  optional
      * @param {} opts.phoneList - 群发的国内电话号码,群发时一次最多不要超过100个手机号
      * @param {} opts.signId - 签名id
      * @param {} opts.templateId - 模板id
      * @param {string} callback - callback
      @return {Object} result
      * @param mtResVO mtResVO
      */

  sendMessagesUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessagesUsingPOST"
      )
    }
    if (opts.phoneList === undefined || opts.phoneList === null) {
      throw new Error(
        "Missing the required parameter 'opts.phoneList' when calling sendMessagesUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling sendMessagesUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling sendMessagesUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }
    if (opts.phoneList !== undefined && opts.phoneList !== null) {
      postBody['phoneList'] = opts.phoneList
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessagesUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSendMessages',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据订单号发送短信
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} opts.signId - 签名id
      * @param {} opts.templateId - 模板id
      * @param {} opts.venderId - 商家id
      * @param {} opts.orderId - 订单编号
      * @param {} [opts.params] - 短信模板变量对应的数据值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param mtResVO mtResVO
      */

  sendMessagesByOrderIdUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessagesByOrderIdUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling sendMessagesByOrderIdUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling sendMessagesByOrderIdUsingPOST"
      )
    }
    if (opts.venderId === undefined || opts.venderId === null) {
      throw new Error(
        "Missing the required parameter 'opts.venderId' when calling sendMessagesByOrderIdUsingPOST"
      )
    }
    if (opts.orderId === undefined || opts.orderId === null) {
      throw new Error(
        "Missing the required parameter 'opts.orderId' when calling sendMessagesByOrderIdUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.venderId !== undefined && opts.venderId !== null) {
      postBody['venderId'] = opts.venderId
    }
    if (opts.orderId !== undefined && opts.orderId !== null) {
      postBody['orderId'] = opts.orderId
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessagesByOrderIdUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sendMessagesByOrderId',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据pin发送短信
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} opts.signId - 签名id
      * @param {} opts.templateId - 模板id
      * @param {} opts.pin - 用户pin
      * @param {} [opts.params] - 短信模板变量对应的数据值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param mtResVO mtResVO
      */

  sendMessagesByPinUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessagesByPinUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling sendMessagesByPinUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling sendMessagesByPinUsingPOST"
      )
    }
    if (opts.pin === undefined || opts.pin === null) {
      throw new Error(
        "Missing the required parameter 'opts.pin' when calling sendMessagesByPinUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.pin !== undefined && opts.pin !== null) {
      postBody['pin'] = opts.pin
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessagesByPinUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sendMessagesByPin',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  根据加密pin发送短信
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} opts.signId - 签名id
      * @param {} opts.templateId - 模板id
      * @param {} opts.encPins - 加密pin集合，不能超过100个
      * @param {} [opts.params] - 短信模板变量对应的数据值  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param mtResVO mtResVO
      */

  sendMessagesByEncPinUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling sendMessagesByEncPinUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling sendMessagesByEncPinUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling sendMessagesByEncPinUsingPOST"
      )
    }
    if (opts.encPins === undefined || opts.encPins === null) {
      throw new Error(
        "Missing the required parameter 'opts.encPins' when calling sendMessagesByEncPinUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.encPins !== undefined && opts.encPins !== null) {
      postBody['encPins'] = opts.encPins
    }
    if (opts.params !== undefined && opts.params !== null) {
      postBody['params'] = opts.params
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call sendMessagesByEncPinUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/sendMessagesByEncPin',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信签名列表
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} [opts.status] - 状态，1申请中 2拒绝 3通过  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param smsSignVO smsSigns
      * @param integer totalCount
      */

  listSmsSignsUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling listSmsSignsUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsSignsUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSigns',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建短信签名
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} [opts.applyExplanation] - 申请说明  optional
      * @param {} [opts.signAttorneyUrl] - 授权委托下载地址，若短信签名用途为他用，涉及第三方权益需上传，上传至 oss  optional
      * @param {} opts.signCertificateUrl - 证明材料下载地址，上传至 oss
      * @param {} opts.signContent - 若签名内容侵犯到第三方权益必须获得第三方真实授权，长度为 2~12 个字符无须添加【】、()、[] 符号，签名发送会自带【】符号，避免重复
      * @param {} [opts.signOtherCertificateUrl] - 其他证明材料下载地址 上传至 oss  optional
      * @param {} opts.signPurpose - 签名用途，0自用 1他用
      * @param {} opts.signTypeId - 签名类型id，调用listSmsSignTypesUsingGET 接口获取
      * @param {string} callback - callback
      @return {Object} result
      * @param string signId  签名id
      */

  createSmsSignUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling createSmsSignUsingPOST"
      )
    }
    if (
      opts.signCertificateUrl === undefined ||
      opts.signCertificateUrl === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signCertificateUrl' when calling createSmsSignUsingPOST"
      )
    }
    if (opts.signContent === undefined || opts.signContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.signContent' when calling createSmsSignUsingPOST"
      )
    }
    if (opts.signPurpose === undefined || opts.signPurpose === null) {
      throw new Error(
        "Missing the required parameter 'opts.signPurpose' when calling createSmsSignUsingPOST"
      )
    }
    if (opts.signTypeId === undefined || opts.signTypeId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signTypeId' when calling createSmsSignUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.applyExplanation !== undefined && opts.applyExplanation !== null) {
      postBody['applyExplanation'] = opts.applyExplanation
    }
    if (opts.signAttorneyUrl !== undefined && opts.signAttorneyUrl !== null) {
      postBody['signAttorneyUrl'] = opts.signAttorneyUrl
    }
    if (
      opts.signCertificateUrl !== undefined &&
      opts.signCertificateUrl !== null
    ) {
      postBody['signCertificateUrl'] = opts.signCertificateUrl
    }
    if (opts.signContent !== undefined && opts.signContent !== null) {
      postBody['signContent'] = opts.signContent
    }
    if (
      opts.signOtherCertificateUrl !== undefined &&
      opts.signOtherCertificateUrl !== null
    ) {
      postBody['signOtherCertificateUrl'] = opts.signOtherCertificateUrl
    }
    if (opts.signPurpose !== undefined && opts.signPurpose !== null) {
      postBody['signPurpose'] = opts.signPurpose
    }
    if (opts.signTypeId !== undefined && opts.signTypeId !== null) {
      postBody['signTypeId'] = opts.signTypeId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSmsSignUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSigns',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信签名详情
      * @param {Object} opts - parameters
      * @param {string} opts.signId - 签名id
      * @param {string} callback - callback
      @return {Object} result
      * @param smsSignVO smsSignVO
      */

  getSmsSignByIdUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling getSmsSignByIdUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      signId: opts.signId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsSignByIdUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSigns/{signId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  编辑短信签名
      * @param {Object} opts - parameters
      * @param {string} opts.signId - 签名id
      * @param {} opts.appId - 应用id
      * @param {} [opts.applyExplanation] - 申请说明  optional
      * @param {} [opts.signAttorneyUrl] - 授权委托下载地址，若短信签名用途为他用，涉及第三方权益需上传，上传至 oss  optional
      * @param {} opts.signCertificateUrl - 证明材料下载地址，上传至 oss
      * @param {} opts.signContent - 若签名内容侵犯到第三方权益必须获得第三方真实授权，长度为 2~12 个字符无须添加【】、()、[] 符号，签名发送会自带【】符号，避免重复
      * @param {} [opts.signOtherCertificateUrl] - 其他证明材料下载地址 上传至 oss  optional
      * @param {} opts.signPurpose - 签名用途，0自用 1他用
      * @param {} opts.signTypeId - 签名类型id，调用listSmsSignTypesUsingGET 接口获取
      * @param {string} callback - callback
      @return {Object} result
      * @param string signId  签名id
      */

  modifySmsSignUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling modifySmsSignUsingPOST"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling modifySmsSignUsingPOST"
      )
    }
    if (
      opts.signCertificateUrl === undefined ||
      opts.signCertificateUrl === null
    ) {
      throw new Error(
        "Missing the required parameter 'opts.signCertificateUrl' when calling modifySmsSignUsingPOST"
      )
    }
    if (opts.signContent === undefined || opts.signContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.signContent' when calling modifySmsSignUsingPOST"
      )
    }
    if (opts.signPurpose === undefined || opts.signPurpose === null) {
      throw new Error(
        "Missing the required parameter 'opts.signPurpose' when calling modifySmsSignUsingPOST"
      )
    }
    if (opts.signTypeId === undefined || opts.signTypeId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signTypeId' when calling modifySmsSignUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.applyExplanation !== undefined && opts.applyExplanation !== null) {
      postBody['applyExplanation'] = opts.applyExplanation
    }
    if (opts.signAttorneyUrl !== undefined && opts.signAttorneyUrl !== null) {
      postBody['signAttorneyUrl'] = opts.signAttorneyUrl
    }
    if (
      opts.signCertificateUrl !== undefined &&
      opts.signCertificateUrl !== null
    ) {
      postBody['signCertificateUrl'] = opts.signCertificateUrl
    }
    if (opts.signContent !== undefined && opts.signContent !== null) {
      postBody['signContent'] = opts.signContent
    }
    if (
      opts.signOtherCertificateUrl !== undefined &&
      opts.signOtherCertificateUrl !== null
    ) {
      postBody['signOtherCertificateUrl'] = opts.signOtherCertificateUrl
    }
    if (opts.signPurpose !== undefined && opts.signPurpose !== null) {
      postBody['signPurpose'] = opts.signPurpose
    }
    if (opts.signTypeId !== undefined && opts.signTypeId !== null) {
      postBody['signTypeId'] = opts.signTypeId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      signId: opts.signId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySmsSignUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSigns/{signId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信签名类型列表
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param signType signTypes
      */

  listSmsSignTypesUsingGET (opts, callback) {
    opts = opts || {}

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsSignTypesUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsSignTypes',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信发送任务列表
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {integer} [opts.status] - 状态，1申请中 2拒绝 3通过  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param smsTaskVO smsTasks
      * @param integer totalCount
      */

  listSmsTasksUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling listSmsTasksUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsTasksUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建短信发送任务
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} [opts.sendNumberUrl] - 短信发送号码集合文件  optional
      * @param {} [opts.sendTime] - 短信发送时间，不传表示立即发送  optional
      * @param {} opts.signId - 短信签名id
      * @param {} opts.taskName - 任务名称
      * @param {} opts.templateId - 短信模板id
      * @param {} [opts.taskType] - 任务类型，1：通道短信 2：营销短信  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务id
      */

  createSmsTaskUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling createSmsTaskUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling createSmsTaskUsingPOST"
      )
    }
    if (opts.taskName === undefined || opts.taskName === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskName' when calling createSmsTaskUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling createSmsTaskUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.sendNumberUrl !== undefined && opts.sendNumberUrl !== null) {
      postBody['sendNumberUrl'] = opts.sendNumberUrl
    }
    if (opts.sendTime !== undefined && opts.sendTime !== null) {
      postBody['sendTime'] = opts.sendTime
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.taskName !== undefined && opts.taskName !== null) {
      postBody['taskName'] = opts.taskName
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }
    if (opts.taskType !== undefined && opts.taskType !== null) {
      postBody['taskType'] = opts.taskType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSmsTaskUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信发送任务详情
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务id
      * @param {string} callback - callback
      @return {Object} result
      * @param smsTaskVO smsTaskVO
      */

  getSmsTaskIdUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling getSmsTaskIdUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsTaskIdUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks/{taskId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  编辑短信发送任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务id
      * @param {} opts.appId - 应用id
      * @param {} [opts.sendNumberUrl] - 短信发送号码集合文件  optional
      * @param {} [opts.sendTime] - 短信发送时间，不传表示立即发送  optional
      * @param {} opts.signId - 短信签名id
      * @param {} opts.taskName - 任务名称
      * @param {} opts.templateId - 短信模板id
      * @param {string} callback - callback
      @return {Object} result
      * @param string taskId  任务id
      */

  modifySmsTaskUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling modifySmsTaskUsingPOST"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling modifySmsTaskUsingPOST"
      )
    }
    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling modifySmsTaskUsingPOST"
      )
    }
    if (opts.taskName === undefined || opts.taskName === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskName' when calling modifySmsTaskUsingPOST"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling modifySmsTaskUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.sendNumberUrl !== undefined && opts.sendNumberUrl !== null) {
      postBody['sendNumberUrl'] = opts.sendNumberUrl
    }
    if (opts.sendTime !== undefined && opts.sendTime !== null) {
      postBody['sendTime'] = opts.sendTime
    }
    if (opts.signId !== undefined && opts.signId !== null) {
      postBody['signId'] = opts.signId
    }
    if (opts.taskName !== undefined && opts.taskName !== null) {
      postBody['taskName'] = opts.taskName
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      postBody['templateId'] = opts.templateId
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySmsTaskUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks/{taskId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  删除任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务id
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  任务删除是否成功
      */

  taskDeleteUsingDelete (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling taskDeleteUsingDelete"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call taskDeleteUsingDelete with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks/{taskId}',
      'DELETE',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  启动任务
      * @param {Object} opts - parameters
      * @param {string} opts.taskId - 任务id
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  任务启动是否成功
      */

  taskStartUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.taskId === undefined || opts.taskId === null) {
      throw new Error(
        "Missing the required parameter 'opts.taskId' when calling taskStartUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      taskId: opts.taskId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call taskStartUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks/{taskId}:start',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  获取短信任务中的短信内容及计费条数
      * @param {Object} opts - parameters
      * @param {string} opts.signId - 签名id
      * @param {string} opts.templateId - 模板id
      * @param {string} callback - callback
      @return {Object} result
      * @param string content  短信内容预览
      * @param integer chargeCount  计费条数
      */

  getSmsTaskContentUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.signId === undefined || opts.signId === null) {
      throw new Error(
        "Missing the required parameter 'opts.signId' when calling getSmsTaskContentUsingGET"
      )
    }
    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getSmsTaskContentUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.signId !== undefined && opts.signId !== null) {
      queryParams['signId'] = opts.signId
    }
    if (opts.templateId !== undefined && opts.templateId !== null) {
      queryParams['templateId'] = opts.templateId
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsTaskContentUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTasks:getSmsTaskContent',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信模板列表
      * @param {Object} opts - parameters
      * @param {string} opts.appId - 应用id
      * @param {integer} [opts.pageNumber] - 页码  optional
      * @param {integer} [opts.pageSize] - 分页大小  optional
      * @param {string} [opts.status] - 状态，1申请中 2拒绝 3通过  optional
      * @param {string} [opts.templateTypes] - 要查询的模板类型，多个以 , 隔开(0 验证码短信,1 通知短信,2 推广短信)  optional
      * @param {string} callback - callback
      @return {Object} result
      * @param smsTemplateVO smsTemplates
      * @param integer totalCount
      */

  listSmsTemplatesUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling listSmsTemplatesUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      queryParams['appId'] = opts.appId
    }
    if (opts.pageNumber !== undefined && opts.pageNumber !== null) {
      queryParams['pageNumber'] = opts.pageNumber
    }
    if (opts.pageSize !== undefined && opts.pageSize !== null) {
      queryParams['pageSize'] = opts.pageSize
    }
    if (opts.status !== undefined && opts.status !== null) {
      queryParams['status'] = opts.status
    }
    if (opts.templateTypes !== undefined && opts.templateTypes !== null) {
      queryParams['templateTypes'] = opts.templateTypes
    }

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call listSmsTemplatesUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTemplates',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  创建短信模板
      * @param {Object} opts - parameters
      * @param {} opts.appId - 应用id
      * @param {} [opts.applyExplanation] - 申请说明  optional
      * @param {} opts.templateContent - 模板内容
      * @param {} opts.templateName - 模板名称
      * @param {} opts.templateType - 模板类型:0 验证码短信,1 通知短信,2 推广短信
      * @param {string} callback - callback
      @return {Object} result
      * @param string templateId  模板id
      */

  createSmsTemplateUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling createSmsTemplateUsingPOST"
      )
    }
    if (opts.templateContent === undefined || opts.templateContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateContent' when calling createSmsTemplateUsingPOST"
      )
    }
    if (opts.templateName === undefined || opts.templateName === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateName' when calling createSmsTemplateUsingPOST"
      )
    }
    if (opts.templateType === undefined || opts.templateType === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateType' when calling createSmsTemplateUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.applyExplanation !== undefined && opts.applyExplanation !== null) {
      postBody['applyExplanation'] = opts.applyExplanation
    }
    if (opts.templateContent !== undefined && opts.templateContent !== null) {
      postBody['templateContent'] = opts.templateContent
    }
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.templateType !== undefined && opts.templateType !== null) {
      postBody['templateType'] = opts.templateType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call createSmsTemplateUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTemplates',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询短信模板详情
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板id
      * @param {string} callback - callback
      @return {Object} result
      * @param smsTemplateVO smsTemplateVO
      */

  getSmsTemplateByIdUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling getSmsTemplateByIdUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call getSmsTemplateByIdUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTemplates/{templateId}',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  编辑短信模板
      * @param {Object} opts - parameters
      * @param {string} opts.templateId - 模板id
      * @param {} opts.appId - 应用id
      * @param {} [opts.applyExplanation] - 申请说明  optional
      * @param {} opts.templateContent - 模板内容
      * @param {} opts.templateName - 模板名称
      * @param {} opts.templateType - 模板类型:0 验证码短信,1 通知短信,2 推广短信
      * @param {string} callback - callback
      @return {Object} result
      * @param string templateId  模板id
      */

  modifySmsTemplateUsingPOST (opts, callback) {
    opts = opts || {}

    if (opts.templateId === undefined || opts.templateId === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateId' when calling modifySmsTemplateUsingPOST"
      )
    }
    if (opts.appId === undefined || opts.appId === null) {
      throw new Error(
        "Missing the required parameter 'opts.appId' when calling modifySmsTemplateUsingPOST"
      )
    }
    if (opts.templateContent === undefined || opts.templateContent === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateContent' when calling modifySmsTemplateUsingPOST"
      )
    }
    if (opts.templateName === undefined || opts.templateName === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateName' when calling modifySmsTemplateUsingPOST"
      )
    }
    if (opts.templateType === undefined || opts.templateType === null) {
      throw new Error(
        "Missing the required parameter 'opts.templateType' when calling modifySmsTemplateUsingPOST"
      )
    }

    let postBody = {}
    if (opts.appId !== undefined && opts.appId !== null) {
      postBody['appId'] = opts.appId
    }
    if (opts.applyExplanation !== undefined && opts.applyExplanation !== null) {
      postBody['applyExplanation'] = opts.applyExplanation
    }
    if (opts.templateContent !== undefined && opts.templateContent !== null) {
      postBody['templateContent'] = opts.templateContent
    }
    if (opts.templateName !== undefined && opts.templateName !== null) {
      postBody['templateName'] = opts.templateName
    }
    if (opts.templateType !== undefined && opts.templateType !== null) {
      postBody['templateType'] = opts.templateType
    }

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      templateId: opts.templateId
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call modifySmsTemplateUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsTemplates/{templateId}',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  开通云鼎短信服务
      * @param {Object} opts - parameters
      * @param {string} callback - callback
      @return {Object} result
      * @param boolean success  是否开通成功
      */

  openServiceUsingPOST (opts, callback) {
    opts = opts || {}

    let postBody = {}

    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud'
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call openServiceUsingPOST with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsUsers',
      'POST',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询用户短信余量
      * @param {Object} opts - parameters
      * @param {integer} opts.packageType - 通道类型，1通道短信，2官方短信
      * @param {string} callback - callback
      @return {Object} result
      * @param integer packageType  套餐包类型 1通道短信，2官方短信
      * @param integer remaining  剩余可调用次数
      * @param integer totalCount  总量
      * @param string remainingRate  剩余百分比
      */

  queryRemainingUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.packageType === undefined || opts.packageType === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageType' when calling queryRemainingUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      packageType: opts.packageType
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryRemainingUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsUsers/{packageType}:queryRemaining',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }

  /**
      *  查询当前自然月内所有应用发送量总和
      * @param {Object} opts - parameters
      * @param {integer} opts.packageType - 通道类型，1通道短信，2官方短信
      * @param {string} callback - callback
      @return {Object} result
      * @param integer packageType  套餐包类型 1通道短信，2官方短信
      * @param integer amount  发送量
      */

  queryAmountUsingGET (opts, callback) {
    opts = opts || {}

    if (opts.packageType === undefined || opts.packageType === null) {
      throw new Error(
        "Missing the required parameter 'opts.packageType' when calling queryAmountUsingGET"
      )
    }

    let postBody = null
    let queryParams = {}

    let pathParams = {
      regionId: 'jdcloud',
      packageType: opts.packageType
    }

    let headerParams = {
      'User-Agent': 'JdcloudSdkNode/1.0.0  ydsms/1.0.8'
    }

    let contentTypes = ['application/json']
    let accepts = ['application/json']

    // 扩展自定义头
    if (opts['x-extra-header']) {
      for (let extraHeader in opts['x-extra-header']) {
        headerParams[extraHeader] = opts['x-extra-header'][extraHeader]
      }

      if (Array.isArray(opts['x-extra-header']['content-type'])) {
        contentTypes = opts['x-extra-header']['content-type']
      } else if (typeof opts['x-extra-header']['content-type'] === 'string') {
        contentTypes = opts['x-extra-header']['content-type'].split(',')
      }

      if (Array.isArray(opts['x-extra-header']['accept'])) {
        accepts = opts['x-extra-header']['accept']
      } else if (typeof opts['x-extra-header']['accept'] === 'string') {
        accepts = opts['x-extra-header']['accept'].split(',')
      }
    }

    let formParams = {}

    let returnType = null

    this.config.logger(
      `call queryAmountUsingGET with params:\npathParams:${JSON.stringify(
        pathParams
      )},\nqueryParams:${JSON.stringify(
        queryParams
      )}, \nheaderParams:${JSON.stringify(
        headerParams
      )}, \nformParams:${JSON.stringify(
        formParams
      )}, \npostBody:${JSON.stringify(postBody)}`,
      'DEBUG'
    )

    let request = super.makeRequest(
      '/smsUsers/{packageType}:queryAmount',
      'GET',
      pathParams,
      queryParams,
      headerParams,
      formParams,
      postBody,
      contentTypes,
      accepts,
      returnType,
      callback
    )

    return request.then(
      function (result) {
        if (callback && typeof callback === 'function') {
          return callback(null, result)
        }
        return result
      },
      function (error) {
        if (callback && typeof callback === 'function') {
          return callback(error)
        }
        return Promise.reject(error)
      }
    )
  }
}
module.exports = YDSMS
