"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TencentCosClient = void 0;
var basic_1 = require("@certd/basic");
var fs_1 = require("fs");
var TencentCosClient = /** @class */ (function () {
    function TencentCosClient(opts) {
        this.access = opts.access;
        this.logger = opts.logger;
        this.bucket = opts.bucket;
        this.region = opts.region;
    }
    TencentCosClient.prototype.getCosClient = function () {
        return __awaiter(this, void 0, void 0, function () {
            var sdk, clientConfig;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Promise.resolve().then(function () { return require("cos-nodejs-sdk-v5"); })];
                    case 1:
                        sdk = _a.sent();
                        clientConfig = {
                            SecretId: this.access.secretId,
                            SecretKey: this.access.secretKey,
                        };
                        return [2 /*return*/, new sdk.default(clientConfig)];
                }
            });
        });
    };
    TencentCosClient.prototype.uploadFile = function (key, file) {
        return __awaiter(this, void 0, void 0, function () {
            var cos;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getCosClient()];
                    case 1:
                        cos = _a.sent();
                        return [2 /*return*/, (0, basic_1.safePromise)(function (resolve, reject) {
                                var readableStream = file;
                                if (typeof file === "string") {
                                    readableStream = fs_1.default.createReadStream(file);
                                }
                                cos.putObject({
                                    Bucket: _this.bucket /* 必须 */,
                                    Region: _this.region /* 必须 */,
                                    Key: key /* 必须 */,
                                    Body: readableStream, // 上传文件对象
                                    onProgress: function (progressData) {
                                        console.log(JSON.stringify(progressData));
                                    },
                                }, function (err, data) {
                                    if (err) {
                                        reject(err);
                                        return;
                                    }
                                    resolve(data);
                                });
                            })];
                }
            });
        });
    };
    TencentCosClient.prototype.removeFile = function (key) {
        return __awaiter(this, void 0, void 0, function () {
            var cos;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getCosClient()];
                    case 1:
                        cos = _a.sent();
                        return [2 /*return*/, (0, basic_1.safePromise)(function (resolve, reject) {
                                cos.deleteObject({
                                    Bucket: _this.bucket,
                                    Region: _this.region,
                                    Key: key,
                                }, function (err, data) {
                                    if (err) {
                                        reject(err);
                                        return;
                                    }
                                    resolve(data);
                                });
                            })];
                }
            });
        });
    };
    TencentCosClient.prototype.downloadFile = function (key, savePath) {
        return __awaiter(this, void 0, void 0, function () {
            var cos, writeStream;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getCosClient()];
                    case 1:
                        cos = _a.sent();
                        writeStream = fs_1.default.createWriteStream(savePath);
                        return [2 /*return*/, (0, basic_1.safePromise)(function (resolve, reject) {
                                cos.getObject({
                                    Bucket: _this.bucket,
                                    Region: _this.region,
                                    Key: key,
                                    Output: writeStream,
                                }, function (err, data) {
                                    if (err) {
                                        reject(err);
                                        return;
                                    }
                                    resolve(data);
                                });
                            })];
                }
            });
        });
    };
    TencentCosClient.prototype.listDir = function (dirKey) {
        return __awaiter(this, void 0, void 0, function () {
            var cos;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getCosClient()];
                    case 1:
                        cos = _a.sent();
                        return [2 /*return*/, (0, basic_1.safePromise)(function (resolve, reject) {
                                cos.getBucket({
                                    Bucket: _this.bucket,
                                    Region: _this.region,
                                    Prefix: dirKey,
                                    MaxKeys: 1000,
                                }, function (err, data) {
                                    if (err) {
                                        reject(err);
                                        return;
                                    }
                                    resolve(data.Contents);
                                });
                            })];
                }
            });
        });
    };
    return TencentCosClient;
}());
exports.TencentCosClient = TencentCosClient;
