export default {
  app: {
    crud: {
      i18n: {
        name: "name",
        city: "city",
        status: "status",
      },
    },
  },
  fs: {
    rowHandle: {
      title: "Operation",
    },
  },
  order: {
    confirmTitle: "Order Confirmation",
    package: "Package",
    description: "Description",
    specifications: "Specifications",
    pipeline: "Pipeline",
    domain: "Domain",
    deployTimes: "Deployments",
    monitorCount: "DomainMonitors",
    duration: "Duration",
    price: "Price",
    paymentMethod: "Payment Method",
    free: "Free",
    unit: {
      pieces: "pieces",
      count: "count",
      times: "times",
    },
  },
  framework: {
    title: "Framework",
    home: "Home",
  },
  title: "Certificate Automation",
  pipeline: "Pipeline",
  pipelineEdit: "Edit Pipeline",
  history: "Execution History",
  certStore: "Certificate Repository",
  siteMonitor: "Site Certificate Monitor",
  settings: "Settings",
  accessManager: "Access Management",
  cnameRecord: "CNAME Record Management",
  subDomain: "Subdomain Delegation Settings",
  pipelineGroup: "Pipeline Group Management",
  openKey: "Open API Key",
  notification: "Notification Settings",
  siteMonitorSetting: "Site Monitor Settings",
  userSecurity: "Security Settings",
  userProfile: "Account Info",
  suite: "Suite",
  mySuite: "My Suite",
  suiteBuy: "Suite Purchase",
  myTrade: "My Orders",
  paymentReturn: "Payment Return",
  hasExpired: "Expired",
  user: {
    greeting: "Hello",
    profile: "Account Info",
    logout: "Logout",
  },
  dashboard: {
    greeting: "Hello, {name}, welcome to 【{site}】",
    latestVersion: "Latest version: {version}",
    validUntil: "Valid until:",
    tutorialTooltip: "Click to view detailed tutorial",
    tutorialText: "Only 3 steps to automatically apply and deploy certificates",
    alertMessage: "Certificates and credentials are sensitive. Do not use untrusted online Certd services or images. Always self-host and use official release channels:",
    helpDoc: "Help Docs",
    pipelineCount: "Number of Certificate Pipelines",
    noPipeline: "You have no certificate pipelines yet",
    createNow: "Create Now",
    managePipeline: "Manage Pipelines",
    pipelineStatus: "Pipeline Status",
    recentRun: "Recent Run Statistics",
    runCount: "Run Count",
    expiringCerts: "Soon-to-Expire Certificates",
    supportedTasks: "Overview of Supported Deployment Tasks",
    changeLog: "Change Log",
  },
  steps: {
    createPipeline: "Create Certificate Pipeline",
    addTask: "Add Deployment Task",
    scheduledRun: "Scheduled Run",
  },
  customPipeline: "Custom Pipeline",
  createCertdPipeline: "Create Certificate Pipeline",
  commercialCertHosting: "Commercial Certificate Hosting",
  tooltip: {
    manualUploadOwnCert: "Manually upload your own certificate for automatic deployment",
    noAutoApplyCommercialCert: "Does not automatically apply for commercial certificates",
    manualUploadOnUpdate: "Must manually upload once when the certificate is updated",
  },
  table: {
    confirmDeleteTitle: "Are you sure you want to delete?",
    confirmDeleteMessage: "This will delete all data related to the pipeline, including execution history, certificate files, and certificate repository records.",
  },
  play: {
    runPipeline: "Run Pipeline",
    confirm: "Confirm",
    confirmTrigger: "Are you sure you want to trigger the run?",
    pipelineStarted: "Pipeline has started running",
  },
  actions: {
    editPipeline: "Edit Pipeline",
    editConfigGroup: "Modify Configuration/Group",
    viewCertificate: "View Certificate",
    downloadCertificate: "Download Certificate",
  },
  fields: {
    userId: "User ID",
    pipelineName: "Pipeline Name",
    keyword: "Keyword",
    required: "This field is required",
    pipelineContent: "Pipeline Content",
    scheduledTaskCount: "Scheduled Task Count",
    deployTaskCount: "Deployment Task Count",
    remainingValidity: "Remaining Validity",
    effectiveTime: "Effective time",
    expiryTime: "Expiry Time",
    status: "Status",
    lastRun: "Last Run",
    enabled: "Enabled",
    enabledLabel: "Enabled",
    disabledLabel: "Disabled",
    group: "Group",
    type: "Type",
    order: "Order Number",
    keepHistoryCount: "History Record Retention Count",
    keepHistoryHelper: "Number of history records to keep; excess will be deleted",
    createTime: "Creation Time",
    updateTime: "Update Time",
    triggerType: "Trigger Type",
    pipelineId: "Pipeline Id",
  },

  pi: {
    validTime: "Piepline Valid Time",
    validTimeHelper: "Not filled in means permanent validity",
  },
  types: {
    certApply: "Cert Apply",
    certUpload: "Cert Upload",
    custom: "Custom",
    template: "Template",
  },
  myPipelines: "My Pipelines",
  selectedCount: "Selected {count} items",
  batchDelete: "Batch Delete",
  batchForceRerun: "Force Rerun",
  applyCertificate: "Apply for Certificate",
  pipelineExecutionRecords: "Pipeline Execution Records",
  confirm: "Confirm",
  confirmBatchDeleteContent: "Are you sure you want to batch delete these {count} records?",
  deleteSuccess: "Delete successful",
  pleaseSelectRecords: "Please select records first",
  triggerTypes: {
    manual: "Manual Execution",
    timer: "Scheduled Execution",
  },
  sysResources: {
    sysRoot: "System Management",
    sysConsole: "Console",
    sysSettings: "System Settings",
    cnameSetting: "CNAME Service Settings",
    emailSetting: "Email Server Settings",
    siteSetting: "Site Personalization",
    headerMenus: "Top Menu Settings",
    sysAccess: "System-level Authorization",
    sysPlugin: "Plugin Management",
    sysPluginEdit: "Edit Plugin",
    sysPluginConfig: "Certificate Plugin Configuration",
    accountBind: "Account Binding",
    permissionManager: "Permission Management",
    roleManager: "Role Management",
    userManager: "User Management",
    suiteManager: "Suite Management",
    suiteSetting: "Suite Settings",
    orderManager: "Order Management",
    userSuites: "User Suites",
    netTest: "Network Test",
  },
  certificateRepo: {
    title: "Certificate Repository",
    sub: "Certificates generated from pipeline",
  },

  certificateNotGenerated: "Certificate not yet generated, please run the pipeline first",
  viewCertificateTitle: "View Certificate",
  close: "Close",
  viewCert: {
    title: "View Certificate",
  },
  download: {
    title: "Download Certificate",
  },
  source: "Source Code",
  github: "GitHub",
  gitee: "Gitee",
  cron: {
    clearTip: "Clear Selection",
    nextTrigger: "Next Trigger Time",
    tip: "Please set a valid cron expression first",
  },
  cronForm: {
    title: "Scheduled Script",
    helper: "Click the button above to select the time for daily execution.\nIt is recommended to run once a day. Tasks will be skipped if the certificate is not expiring.",
    required: "This field is required",
  },
  email: {
    title: "Recipient Email",
    helper: "Enter your recipient email addresses. Multiple addresses are supported.",
    required: "This field is required",
  },
  plugin: {
    selectTitle: "Certificate Apply Plugin",
    jsAcme: "JS-ACME: Easy to use, powerful features [Recommended]",
    legoAcme: "Lego-ACME: Based on Lego, supports a wide range of DNS providers, suitable for users familiar with Lego",
  },
  pipelineForm: {
    createTitle: "Create Certificate Pipeline",
    moreParams: "More Parameters",
    triggerCronTitle: "Scheduled Trigger",
    triggerCronHelper:
      "Click the button above to choose a daily execution time.\nIt is recommended to trigger once per day. The task will be skipped if the certificate has not expired and will not be executed repeatedly.",
    notificationTitle: "Failure Notification",
    notificationWhen: "Notification Timing",
    notificationHelper: "Get real-time alerts when the task fails",
    groupIdTitle: "Pipeline Group",

    addToMonitorEnabled: "Add to Cert Monitor",
    addToMonitorDomains: "Add to Monitor Domains",
  },
  notificationDefault: "Use Default Notification",
  monitor: {
    remark: "Remark",
    title: "Site Certificate Monitoring",
    description: "Check website certificates' expiration at 0:00 daily; reminders sent 10 days before expiration (using default notification channel);",
    settingLink: "Site Monitoring Settings",
    limitInfo: "Basic edition limited to 1, professional and above unlimited, current",
    checkAll: "Check All",
    confirmTitle: "Confirm",
    confirmContent: "Confirm to trigger check for all site certificates?",
    checkSubmitted: "Check task submitted",
    pleaseRefresh: "Please refresh the page later to see the results",
    siteName: "Site Name",
    enterSiteName: "Please enter the site name",
    domain: "Domain",
    enterDomain: "Please enter the domain",
    enterValidDomain: "Please enter a valid domain",
    httpsPort: "HTTPS Port",
    enterPort: "Please enter the port",
    certInfo: "Certificate Info",
    issuer: "Issuer",
    certDomains: "Certificate Domains",
    certProvider: "Issuer",
    certStatus: "Certificate Status",
    error: "Error",
    status: {
      ok: "Valid",
      expired: "Expired",
    },
    certEffectiveTime: "Certificate Effective",
    certExpiresTime: "Certificate Expiration",
    remainingValidity: "Remaining Validity",
    expired: "expired",
    days: "days",
    lastCheckTime: "Last Check Time",
    disabled: "Enable/Disable",
    ipCheck: "Enable IP Check",
    selectRequired: "Please select",
    ipCheckConfirm: "Are you sure to {status} IP check?",
    ipCount: "IP Count",
    checkStatus: "Check Status",
    pipelineId: "Linked Pipeline ID",
    certInfoId: "Certificate ID",
    checkSubmittedRefresh: "Check task submitted. Please refresh later to view the result.",
    ipManagement: "IP Management",
    bulkImport: "Bulk Import",
    basicLimitError: "Basic version allows only one monitoring site. Please upgrade to the Pro version.",
    limitExceeded: "Sorry, you can only create up to {max} monitoring records. Please purchase or upgrade your plan.",
    setting: {
      siteMonitorSettings: "Site Monitor Settings",
      notificationChannel: "Notification Channel",
      setNotificationChannel: "Set the notification channel",
      retryTimes: "Retry Times",
      monitorRetryTimes: "Number of retry attempts for monitoring requests",
      monitorCronSetting: "Monitoring Schedule",
      cronTrigger: "Scheduled trigger for monitoring",
      dnsServer: "DNS Server",
      dnsServerHelper: "Use a custom domain name resolution server, such as: 1.1.1.1 , support multiple",
      certValidDays: "Certificate Valid Days",
      certValidDaysHelper: "Number of days before expiration to send a notification",
    },
  },
  checkStatus: {
    success: "Success",
    checking: "Checking",
    error: "Error",
  },
  domainList: {
    title: "Domain List",
    helper: "Format: domain:port:name:remark, one per line. Port and name are optional.\nExamples:\nwww.baidu.com:443:Baidu:remarkText\nwww.taobao.com::Taobao\nwww.google.com",
    required: "Please enter domains to import",
    placeholder: "www.baidu.com:443:Baidu\nwww.taobao.com::Taobao\nwww.google.com\n",
  },
  accountInfo: "Account Information",
  securitySettings: "Security & Settings",
  confirmDisable2FA: "Are you sure you want to disable two-factor authentication login?",
  disabledSuccess: "Disabled successfully",
  saveSuccess: "Saved successfully",
  twoFactorAuth: "2FA Two-Factor Authentication Login",
  rebind: "Rebind",
  twoFactorAuthHelper: "Enable or disable two-factor authentication login",
  bindDevice: "Bind Device",
  step1: "1. Install any authenticator app, for example:",
  tooltipGoogleServiceError: "If you get a Google service not found error, you can install KK Google Assistant",
  step2: "2. Scan the QR code to add the account",
  step3: "3. Enter the verification code",
  inputVerifyCode: "Please enter the verification code",
  cancel: "Cancel",
  authorizationManagement: "Authorization Management",
  manageThirdPartyAuth: "Manage third-party system authorization information",
  name: "Name",
  pleaseEnterName: "Please enter the name",
  nameHelper: "Fill in as you like, useful to distinguish when multiple authorizations of the same type exist",
  level: "Level",
  system: "System",
  usera: "User",
  nickName: "Nickname",
  max50Chars: "Maximum 50 characters",
  myInfo: "My Information",
  save: "Save",
  editSchedule: "Edit Schedule",
  timerTrigger: "Timer Trigger",
  schedule: "Schedule",
  selectCron: "Please select a schedule Cron",
  batchEditSchedule: "Batch Edit Schedule",
  editTrigger: "Edit Trigger",
  triggerName: "Trigger Name",
  requiredField: "This field is required",
  type: "Type",
  enterName: "Please enter a name",
  confirmDeleteTrigger: "Are you sure you want to delete this trigger?",
  notificationType: "Notification Type",
  selectNotificationType: "Please select a notification type",
  notificationName: "Notification Name",
  helperNotificationName: "Fill freely, helps to distinguish when multiple notifications of the same type exist",
  isDefault: "Is Default",
  yes: "Yes",
  no: "No",
  selectIsDefault: "Please select if default",
  prompt: "Prompt",
  confirmSetDefaultNotification: "Are you sure to set as default notification?",
  test: "Test",
  scope: "Scope",
  scopeOpenApiOnly: "Open API Only",
  scopeFullAccount: "Full Account Permissions",
  required: "This field is required",
  scopeHelper: "Open API only allows access to open APIs; full account permissions allow access to all APIs",
  add: "Generate New Key",
  gen: {
    text: "API Test",
    title: "x-certd-token",
    okText: "Confirm",
    contentPart1: "Test the x-certd-token below, you can use it within 3 minutes to test ",
    openApi: "Open API",
    contentPart2: " request testing",
  },
  pending_cname_setup: "Pending CNAME setup",
  validating: "Validating",
  validation_successful: "Validation successful",
  validation_failed: "Validation failed",
  validation_timed_out: "Validation timed out",
  proxied_domain: "Proxied Domain",
  host_record: "Host Record",
  please_set_cname: "Please set CNAME",
  cname_service: "CNAME Service",
  default_public_cname: "Default public CNAME service, you can also ",
  customize_cname: "Customize CNAME Service",
  public_cname: "Public CNAME",
  custom_cname: "Custom CNAME",
  validate: "Validate",
  validation_started: "Validation started, please wait patiently",
  click_to_validate: "Click to Validate",
  all: "All",
  cname_feature_guide: "CNAME feature principle and usage guide",
  batch_delete: "Batch Delete",
  confirm_delete_count: "Are you sure to delete these {count} records in batch?",
  delete_successful: "Delete successful",
  please_select_records: "Please select records first",
  edit_notification: "Edit Notification",
  other_notification_method: "Other Notification Method",
  trigger_time: "Trigger Time",
  start_time: "At Start",
  success_time: "On Success",
  fail_to_success_time: "Fail to Success",
  fail_time: "On Failure",
  helper_suggest_fail_only: "It is recommended to select only 'On Failure' and 'Fail to Success'",
  notification_config: "Notification Configuration",
  please_select_notification: "Please select a notification method",
  please_select_type: "Please select type",
  please_select_trigger_time: "Please select notification trigger time",
  please_select_notification_config: "Please select notification configuration",
  confirm_delete_trigger: "Are you sure you want to delete this trigger?",
  gift_package: "Gift Package",
  package_name: "Package Name",
  click_to_select: "Click to select",
  please_select_package: "Please select a package",
  package: "Package",
  addon_package: "Addon Package",
  domain_count: "Domain Count",
  unit_count: "pcs",
  field_required: "This field is required",
  pipeline_count: "Pipeline Count",
  unit_item: "items",
  deploy_count: "Deploy Count",
  unit_times: "times",
  monitor_count: "Certificate Monitor Count",
  duration: "Duration",
  status: "Status",
  active_time: "Activation Time",
  expires_time: "Expiration Time",
  is_present: "Is Present",
  is_present_yes: "Yes",
  is_present_no: "No",
  basicInfo: "Basic Information",
  titlea: "Title",
  disabled: "Disabled",
  ordera: "Order",
  supportBuy: "Support Purchase",
  intro: "Introduction",
  packageContent: "Package Content",
  maxDomainCount: "Max Domain Count",
  maxPipelineCount: "Max Pipeline Count",
  maxDeployCount: "Max Deploy Count",
  maxMonitorCount: "Max Monitor Count",
  price: "Price",
  durationPrices: "Duration Prices",
  packageName: "Package Name",
  addon: "Addon",
  typeHelper: "Suite: Only the most recently purchased one is active at a time\nAddon: Multiple can be purchased, effective immediately without affecting the suite\nThe quantities of suite and addon can be accumulated",
  domainCount: "Domain Count",
  pipelineCount: "Pipeline Count",
  unitPipeline: "pipelines",
  deployCount: "Deployment Count",
  unitDeploy: "times",
  monitorCount: "Certificate Monitor Count",
  unitCount: "pcs",
  durationPriceTitle: "Duration and Price",
  selectDuration: "Select Duration",
  supportPurchase: "Support Purchase",
  cannotPurchase: "Cannot Purchase",
  shelfStatus: "Shelf Status",
  onShelf: "On Shelf",
  offShelf: "Off Shelf",
  orderHelper: "Smaller values appear first",
  description: "Description",
  createTime: "Creation Time",
  updateTime: "Update Time",
  mainDomain: "Main Domain",
  edit: "Edit",
  groupName: "Group Name",
  enterGroupName: "Please enter group name",
  subdomainHosting: "Subdomain Hosting",
  subdomainHostingHint: "When your domain has subdomain hosting set, you need to create records here, otherwise certificate application will fail",
  batchDeleteConfirm: "Are you sure to batch delete these {count} records?",
  selectRecordFirst: "Please select records first",
  subdomainHosted: "Hosted Subdomain",
  subdomainHelpText: "If you don't understand what subdomain hosting is,Do not set it randomly, as it may result in the inability to apply for the certificate. please refer to the documentation ",
  subdomainManagement: "Subdomain Management",
  isDisabled: "Is Disabled",
  enabled: "Enabled",
  uploadCustomCert: "Upload Custom Certificate",
  sourcee: "Source",
  sourcePipeline: "Pipeline",
  sourceManualUpload: "Manual Upload",
  domains: "Domains",
  enterDomain: "Please enter domain",
  validDays: "Valid Days",
  expires: " expires",
  days: " days",
  effectiveTime: "Effective Time",
  expireTime: "Expiration Time",
  certIssuer: "Certificate Issuer",
  applyTime: "Application Time",
  relatedPipeline: "Related Pipeline",
  statusSuccess: "Success",
  statusChecking: "Checking",
  statusError: "Error",
  actionImportBatch: "Batch Import",
  actionSyncIp: "Sync IP",
  modalTitleSyncIp: "Sync IP",
  modalContentSyncIp: "Are you sure to sync IP?",
  notificationSyncComplete: "Sync Complete",
  actionCheckAll: "Check All",
  modalTitleConfirm: "Confirm",
  modalContentCheckAll: "Confirm to trigger checking all IP site's certificates?",
  notificationCheckSubmitted: "Check task submitted",
  notificationCheckDescription: "Please refresh later to see results",
  tooltipCheckNow: "Check Now",
  notificationCheckSubmittedPleaseRefresh: "Check task submitted, please refresh later",
  columnId: "ID",
  columnIp: "IP",
  helperIpCname: "Supports entering CNAME domain name",
  ruleIpRequired: "Please enter IP",
  columnCertDomains: "Certificate Domains",
  columnCertProvider: "Issuer",
  columnCertStatus: "Certificate Status",
  statusNormal: "Normal",
  statusExpired: "Expired",
  columnCertExpiresTime: "Certificate Expiration Time",
  expired: "expired",
  columnCheckStatus: "Check Status",
  columnLastCheckTime: "Last Check Time",
  columnSource: "Source",
  sourceSync: "Sync",
  sourceManual: "Manual",
  sourceImport: "Import",
  columnDisabled: "Enabled/Disabled",
  columnRemark: "Remark",
  pluginFile: "Plugin File",
  selectPluginFile: "Select plugin file",
  overrideSameName: "Override same name",
  override: "Override",
  noOverride: "No override",
  overrideHelper: "If a plugin with the same name exists, override it directly",
  importPlugin: "Import Plugin",
  operationSuccess: "Operation successful",
  customPlugin: "Custom Plugin",
  import: "Import",
  export: "Export",
  pluginType: "Plugin Type",
  auth: "Authorization",
  dns: "DNS",
  deployPlugin: "Deploy Plugin",
  icon: "Icon",
  pluginName: "Plugin Name",
  pluginNameHelper: "Must be English letters or digits, camelCase with type prefix\nExample: AliyunDeployToCDN\nDo not modify name once plugin is used",
  pluginNameRuleMsg: "Must be English letters or digits, camelCase with type prefix",
  author: "Author",
  authorHelper: "Used as prefix when uploading to plugin store, e.g., greper/pluginName",
  authorRuleMsg: "Must be English letters or digits",
  titleHelper: "Plugin name in Chinese",
  descriptionHelper: "Description of the plugin",
  builtIn: "Built-in",
  custom: "Custom",
  store: "Store",
  version: "Version",
  pluginDependencies: "Plugin Dependencies",
  pluginDependenciesHelper: "Dependencies to install first in format: [author/]pluginName[:version]",
  editableRunStrategy: "Editable Run Strategy",
  editable: "Editable",
  notEditable: "Not Editable",
  runStrategy: "Run Strategy",
  normalRun: "Normal Run",
  skipOnSuccess: "Skip on success (Deploy task)",
  defaultRunStrategyHelper: "Default run strategy",
  enableDisable: "Enable/Disable",
  clickToToggle: "Click to toggle enable/disable",
  confirmToggle: "Are you sure to",
  disable: "disable",
  enable: "enable",
  pluginGroup: "Plugin Group",
  icpRegistrationNumber: "ICP Registration Number",
  icpPlaceholder: "Guangdong ICP xxxxxxx Number",
  publicSecurityRegistrationNumber: "Public Security Registration Number",
  publicSecurityPlaceholder: "Beijing Public Security xxxxxxx Number",
  enableAssistant: "Enable Assistant",
  allowCrawlers: "Allow Crawlers",
  httpProxy: "HTTP Proxy",
  httpProxyPlaceholder: "http://192.168.1.2:18010/",
  httpProxyHelper: "Configure when some websites are blocked",
  httpsProxy: "HTTPS Proxy",
  httpsProxyPlaceholder: "http://192.168.1.2:18010/",
  saveThenTestTitle: "Save first, then click test",
  testButton: "Test",
  httpsProxyHelper: "Usually both proxies are the same, save first then test",
  dualStackNetwork: "Dual Stack Network",
  default: "Default",
  ipv4Priority: "IPv4 Priority",
  ipv6Priority: "IPv6 Priority",
  dualStackNetworkHelper: "If IPv6 priority is selected, enable IPv6 in docker-compose.yaml",
  enableCommonCnameService: "Enable Public CNAME Service",
  commonCnameHelper: "Allow use of public CNAME service. If disabled and no <a href='#/sys/cname/provider'>custom CNAME service</a> is set, CNAME proxy certificate application will not work.",
  enableCommonSelfServicePasswordRetrieval: "Enable self-service password recovery",
  saveButton: "Save",
  stopSuccess: "Stopped successfully",
  google: "Google",
  baidu: "Baidu",
  success: "Success",
  testFailed: "Test Failed",
  testCompleted: "Test Completed",
  manageOtherUserPipeline: "Manage other users' pipelines",
  limitUserPipelineCount: "Limit user pipeline count",
  limitUserPipelineCountHelper: "0 means no limit",
  enableSelfRegistration: "Enable self-registration",
  enableUserValidityPeriod: "Enable user validity period",
  userValidityPeriodHelper: "Users can use normally within validity; pipelines disabled after expiry",
  enableUsernameRegistration: "Enable username registration",
  enableEmailRegistration: "Enable email registration",
  proFeature: "Pro feature",
  emailServerSetup: "Set up email server",
  enableSmsLoginRegister: "Enable SMS login and registration",
  commFeature: "Commercial feature",
  smsProvider: "SMS provider",
  aliyunSms: "Aliyun SMS",
  tencentSms: "Tencent SMS",
  yfySms: "YFY SMS",
  smsTest: "SMS test",
  testMobilePlaceholder: "Enter test mobile number",
  saveThenTest: "Save first then test",
  enterTestMobile: "Please enter test mobile number",
  sendSuccess: "Sent successfully",
  atLeastOneLoginRequired: "At least one of password login or SMS login must be enabled",
  fieldRequired: "This field is required",
  siteHide: "Site Hide",
  enableSiteHide: "Enable Site Hide",
  siteHideDescription: "You can disable site accessibility normally and enable it when needed to enhance site security",
  helpDoc: "Help Document",
  randomAddress: "Random Address",
  siteHideUrlHelper: "After the site is hidden, you need to visit this URL to unlock to access normally",
  fullUnlockUrl: "Full Unlock URL",
  saveThisUrl: "Please save this URL carefully",
  unlockPassword: "Unlock Password",
  unlockPasswordHelper: "Password needed to unlock the hide; set on first time or reset when filled",
  autoHideTime: "Auto Hide Time",
  autoHideTimeHelper: "Minutes without requests before auto hiding",
  hideOpenApi: "Hide Open API",
  hideOpenApiHelper: "Whether to hide open APIs; whether to expose /api/v1 prefixed endpoints",
  hideSiteImmediately: "Hide Site Immediately",
  hideImmediately: "Hide Immediately",
  confirmHideSiteTitle: "Are you sure to hide the site immediately?",
  confirmHideSiteContent: "After hiding, the site will be inaccessible. Please operate cautiously.",
  siteHiddenSuccess: "Site has been hidden",
  emailServerSettings: "Email Server Settings",
  setEmailSendingServer: "Set the email sending server",
  useCustomEmailServer: "Use Custom Email Server",
  smtpDomain: "SMTP Domain",
  pleaseEnterSmtpDomain: "Please enter SMTP domain or IP",
  smtpPort: "SMTP Port",
  pleaseEnterSmtpPort: "Please enter SMTP port",
  username: "Username",
  pleaseEnterUsername: "Please enter username",
  password: "Password",
  pleaseEnterPassword: "Please enter password",
  qqEmailAuthCodeHelper: "If using QQ email, get an authorization code in QQ email settings as the password",
  senderEmail: "Sender Email",
  pleaseEnterSenderEmail: "Please enter sender email",
  useSsl: "Use SSL",
  sslPortNote: "SSL and non-SSL SMTP ports are different, please adjust port accordingly",
  ignoreCertValidation: "Ignore Certificate Validation",
  useOfficialEmailServer: "Use Official Email Server",
  useOfficialEmailServerHelper: "Send emails directly using the official server to avoid complicated setup",
  testReceiverEmail: "Test Receiver Email",
  pleaseEnterTestReceiverEmail: "Please enter test receiver email",
  saveBeforeTest: "Save before testing",
  sendFailHelpDoc: "Failed to send??? ",
  emailConfigHelpDoc: "Email configuration help document",
  tryOfficialEmailServer: "You can also try using the official email server ↗↗↗↗↗↗↗↗",
  pluginManagement: "Plugin Management",
  pluginBetaWarning: "Custom plugins are in BETA and may have breaking changes in future",
  pleaseSelectRecord: "Please select records first",
  permissionManagement: "Permission Management",
  adda: "Add",
  rootNode: "Root Node",
  permissionName: "Permission Name",
  enterPermissionName: "Please enter permission name",
  permissionCode: "Permission Code",
  enterPermissionCode: "Please enter permission code",
  max100Chars: "Maximum 100 characters",
  examplePermissionCode: "e.g.: sys:user:view",
  sortOrder: "Sort Order",
  sortRequired: "Sort order is required",
  parentNode: "Parent Node",
  roleManagement: "Role Management",
  assignPermissions: "Assign Permissions",
  roleName: "Role Name",
  enterRoleName: "Please enter role name",
  unlockLogin: "Unlock Login",
  notice: "Notice",
  confirmUnlock: "Are you sure you want to unlock this user's login?",
  unlockSuccess: "Unlock successful",
  enterUsername: "Please enter username",
  modifyPasswordIfFilled: "Fill in to change the password",
  emaila: "Email",
  mobile: "Mobile",
  avatar: "Avatar",
  validTime: "Valid Time",
  remark: "Remark",
  roles: "Roles",
  cnameTitle: "CNAME Service Configuration",
  cnameDescription:
    "The domain name configured here serves as a proxy for verifying other domains. When other domains apply for certificates, they map to this domain via CNAME for ownership verification. The advantage is that any domain can apply for a certificate this way without providing an AccessSecret.",
  cnameLinkText: "CNAME principle and usage instructions",
  confirmTitle: "Confirm",
  confirmDeleteBatch: "Are you sure you want to delete these {count} records?",
  selectRecordsFirst: "Please select records first",
  cnameDomain: "CNAME Domain",
  cnameDomainPlaceholder: "cname.handsfree.work",
  cnameDomainHelper:
    "Requires a domain registered with a DNS provider on the right (or you can transfer other domain DNS servers here).\nOnce the CNAME domain is set, it cannot be changed. It is recommended to use a first-level subdomain.",
  dnsProvider: "DNS Provider",
  dnsProviderAuthorization: "DNS Provider Authorization",
  setDefault: "Set Default",
  confirmSetDefault: "Are you sure to set as default?",
  setAsDefault: "Set as Default",
  disabledLabel: "Disabled",
  confirmToggleStatus: "Are you sure to {action}?",
  template: {
    title: "Pipeline Template",
    edit: "Pipeline Template Edit",
    importCreate: "Pipeline Batch Create",
    // intro: "可根据模版批量创建流水线",
    intro: "Batch create pipeline based on template",
    createTemplate: "Create Template",
    useTemplate: "Use This Template",
    batchCreate: "Batch Create Pipeline",
    singleCreate: "Create Single Pipeline",
    templateName: "Template Name",
    enterTemplateName: "Please enter template name",
    copyPipelineConfig: "Copy this pipeline configuration as template source",
    pipeline: "Pipeline",
  },

  addonType: "Type",
  addonName: "Name",
  addonNameHelper: "Fill freely, helps to distinguish when multiple same type exist",
  addonTypeSelect: "Select type",
  dates: {
    years: "{count} years",
    months: "{count} months",
  },
  sys: {
    setting: {
      baseSetting: "Base Settings",
      registerSetting: "Register Settings",
      safeSetting: "Safe Settings",
      paymentSetting: "Payment Settings",
      captchaSetting: "Captcha Setting",
      pipelineSetting: "Pipeline Settings",
      oauthSetting: "OAuth2 Settings",

      showRunStrategy: "Show RunStrategy",
      showRunStrategyHelper: "Allow modify the run strategy of the task",

      captchaEnabled: "Enable Login Captcha",
      captchaHelper: "Whether to enable captcha verification for login",
      captchaType: "Captcha Setting",
      captchaTest: "Captcha Test",
      // 保存后再点击测试，请务必测试通过了，再开启登录验证码
      captchaTestHelper: "Save and click test, please make sure the test is passed before enabling login captcha",

      pipelineValidTimeEnabled: "Enable Pipeline Valid Time",
      pipelineValidTimeEnabledHelper: "Whether to enable the valid time of the pipeline",
      certDomainAddToMonitorEnabled: "Add Domain to Certificate Monitor",
      certDomainAddToMonitorEnabledHelper: "Whether to add the domain to the certificate monitor",
      fixedCertExpireDays: "Fixed Cert Expire Days",
      fixedCertExpireDaysHelper: "Fixed cert expiration days, helpful for table list progress bar display",
      fixedCertExpireDaysRecommend: "Recommend 90",

      enableOauth: "Enable OAuth2 Login",
      oauthEnabledHelper: "Whether to enable OAuth2 login",
      oauthProviders: "OAuth2 Login Providers",
      oauthType: "OAuth2 Login Type",
      oauthConfig: "OAuth2 Login Config",
      oauthProviderSelectorPlaceholder: "Not Configured",
      oauthCallback: "Callback URL",
      oauthCallbackHelper: "Copy this URL to the callback address of the OAuth2 login provider",
      oauthCallbackCopy: "Copy Callback URL",
      oauthAutoRegister: "Auto Register User",
      oauthAutoRegisterCheckedText: "Auto Register",
      oauthAutoRegisterUnCheckedText: "User Select",
      oauthAutoRegisterHelper: "Whether to auto register user when login",
      oauthAutoRedirect: "Auto Redirect to OAuth2 Login",
      oauthAutoRedirectHelper: "Whether to auto redirect to OAuth2 login when login (using the first enabled OAuth2 login type)",
      oauthOnly: "OAuth2 Login Only",
      oauthOnlyHelper: "Whether to only allow OAuth2 login, disable password login",
    },
  },
  modal: {
    close: "Close",
    viewCertificateTitle: "View Certificate",
  },
  domain: {
    domainManager: "Domain Manager",
    domainDescription: "used to auto apply for certificate", //管理域名的校验方式，用于申请证书时自动选择验证方式
    domain: "Domain",
    challengeType: "Challenge Type",
    dnsProviderType: "DNS Provider Type",
    dnsProviderAccess: "DNS Provider Access",
    httpUploaderType: "HTTP Uploader Type",
    httpUploaderAccess: "HTTP Uploader Access",
    httpUploadRootDir: "HTTP Upload Root Dir",
    disabled: "Disabled",
    challengeSetting: "Challenge Setting",
    gotoCnameTip: "Please go to CNAME Record Page",
  },
  addonSelector: {
    select: "Select",
    placeholder: "select please",
  },
};
