export default {
  createCertPipeline: {
    title: "Create Certificate Application Pipeline",
    description: "Demonstrate how to configure a certificate application task",
    items: {
      tutorialTitle: "Tutorial Demo Content",
      tutorialDesc1: "This tutorial demonstrates how to automatically apply for a certificate and deploy it to Nginx",
      tutorialDesc2: "Only 3 steps, fully automatic application and deployment",
      createTitle: "Create Certificate Pipeline",
      createDesc: "Click to add a certificate pipeline and fill in the certificate application information",
      successTitle: "Pipeline Created Successfully",
      successDesc: "Click manual trigger to apply for the certificate",
      nextTitle: "Next, demonstrate how to automatically deploy the certificate",
      nextDesc: "If you only need to apply for a certificate, you can stop here",
    },
  },
  buttons: {
    prev: "Previous Step",
    next: "Next Step",
  },
  addDeployTask: {
    title: "Add Deployment Certificate Task",
    description: "Demonstrate deployment of certificate to Nginx",
    items: {
      addTaskTitle: "Add Certificate Deployment Task",
      addTaskDesc1: "Demonstrate automatic deployment of certificate to nginx",
      addTaskDesc2: "Our system provides numerous deployment plugins to meet your needs",
      fillParamsTitle: "Fill Task Parameters",
      fillParamsDesc1: "Fill in the certificate file path on the host",
      fillParamsDesc2: "Select SSH login authorization for the host",
      activateCertTitle: "Make New Certificate Effective",
      activateCertDesc1: "Execute restart script",
      activateCertDesc2: "Make the certificate effective",
      taskSuccessTitle: "Deployment Task Added Successfully",
      taskSuccessDesc: "Now you can run it",
      pluginsTitle: "Our System Provides Numerous Deployment Plugins",
      pluginsDesc: "You can deploy certificates to various applications and platforms according to your needs",
    },
  },
  runAndTestTask: {
    runAndTestTitle: "Run and Test",
    runAndTestDescription: "Demonstrate pipeline running, view logs, skip on success, etc.",
    runTestOnce: "Run a Test",
    clickManualTriggerToTest: "Click the manual trigger button to test the run",
    viewLogs: "View Logs",
    clickTaskToViewStatusAndLogs: "Click the task to view status and logs",
    howToTroubleshootFailure: "How to Troubleshoot Failure",
    viewErrorLogs: "View error logs",
    nginxContainerNotExistFix: "Shows nginx container not found error, fix by changing to correct nginx container name",
    executionSuccess: "Execution Success",
    retryAfterFix: "After fixing, click manual trigger again to rerun successfully",
    autoSkipAfterSuccess: "Auto Skip After Success",
    successSkipExplanation: "Successful runs will be skipped automatically, rerun only if parameters or certificates update",
    viewCertDeploymentSuccess: "View Certificate Deployment Success",
    visitNginxToSeeCert: "Visit website on nginx to see certificate deployed successfully",
    downloadCertManualDeploy: "Download Certificate for Manual Deployment",
    downloadIfNoAutoDeployPlugin: "If no deployment plugin available, download certificate for manual deployment",
  },
  scheduleAndEmailTask: {
    title: "Set Scheduled Execution and Email Notifications",
    description: "Automatic running",
    setSchedule: "Set Scheduled Execution",
    pipelineSuccessThenSchedule: "Pipeline tests succeed, then configure scheduled triggers so it runs automatically daily",
    recommendDailyRun: "Recommend configuring to run once daily; new certs requested 35 days before expiry and auto-skipped otherwise",
    setEmailNotification: "Set Email Notifications",
    suggestErrorAndRecoveryEmails: "Suggest listening for 'On Error' and 'Error to Success' to quickly troubleshoot failures (basic version requires mail server setup)",
    basicVersionNeedsMailServer: "(basic version requires configuring mail server)",
    tutorialEndTitle: "Tutorial End",
    thanksForWatching: "Thank you for watching, hope it helps you",
  },
};
