import { createApp, watchEffect } from "vue";

// import { registerAccessDirective } from "./access";
import { initTippy, registerLoadingDirective } from "./common-ui";
// import { MotionPlugin } from "./plugins/motion";
import { preferences } from "./preferences";
import { initStores } from "./stores";
import "./styles";
import "./styles/antd/index.css";

import { useTitle } from "@vueuse/core";
import { setupI18n, useI18n } from "../locales";
import { useSettingStore } from "/@/store/settings";

export async function setupVben(app: any, { loadMessages, router }: any) {
  await setupI18n(app, { loadMessages });
  const store = await initStores(app, { namespace: "fs" });
  const settingStore = useSettingStore();
  const { t } = useI18n();
  watchEffect(() => {
    if (preferences.app.dynamicTitle) {
      let routeTitle = router.currentRoute.value.meta?.title;
      const appName = settingStore.inited ? preferences.app.name : "";
      if (routeTitle && routeTitle.indexOf(".") >= 0) {
        routeTitle = t(routeTitle);
      }
      const pageTitle = (routeTitle ? `${routeTitle} - ` : "") + preferences.app.name;
      useTitle(pageTitle);
    }
  });
  return { store };
}

// import { $t, setupI18n } from "#/locales";

// import { initComponentAdapter } from "./adapter/component";
// import App from "./app.vue";
// import { router } from "./router";
//
// async function bootstrap(namespace: string) {
//   // // 初始化组件适配器
//   // await initComponentAdapter();
//
//   // // 设置弹窗的默认配置
//   // setDefaultModalProps({
//   //   fullscreenButton: false,
//   // });
//   // // 设置抽屉的默认配置
//   // setDefaultDrawerProps({
//   //   zIndex: 1020,
//   // });
//
//   // const app = createApp(App);
//
//   // 注册v-loading指令
//   registerLoadingDirective(app, {
//     loading: "loading", // 在这里可以自定义指令名称，也可以明确提供false表示不注册这个指令
//     spinning: "spinning"
//   });
//
//   // 国际化 i18n 配置
//   await setupI18n(app);
//
//   // 配置 pinia-tore
//   await initStores(app, { namespace });
//
//   // 安装权限指令
//   registerAccessDirective(app);
//
//   // 初始化 tippy
//   initTippy(app);
//
//   // 配置路由及路由守卫
//   app.use(router);
//
//   // 配置Motion插件
//   app.use(MotionPlugin);
//
//   // 动态更新标题
//   watchEffect(() => {
//     if (preferences.app.dynamicTitle) {
//       const routeTitle = router.currentRoute.value.meta?.title;
//       const pageTitle = (routeTitle ? `${$t(routeTitle)} - ` : "") + preferences.app.name;
//       useTitle(pageTitle);
//     }
//   });
//
//   app.mount("#app");
// }
//
// export { bootstrap };
