import type { Preferences } from "./types";

const defaultPreferences: Preferences = {
  app: {
    accessMode: "frontend",
    authPageLayout: "panel-right",
    checkUpdatesInterval: 1,
    colorGrayMode: false,
    colorWeakMode: false,
    compact: false,
    contentCompact: "wide",
    defaultAvatar: "./static/images/logo/logo.svg",
    dynamicTitle: true,
    enableCheckUpdates: false,
    enablePreferences: true,
    enableRefreshToken: false,
    isMobile: false,
    layout: "mixed-nav",
    locale: "zh-CN",
    loginExpiredMode: "page",
    name: "",
    preferencesButtonPosition: "auto",
    watermark: false,
  },
  breadcrumb: {
    enable: true,
    hideOnlyOne: false,
    showHome: false,
    showIcon: true,
    styleType: "normal",
  },
  copyright: {
    companyName: "greper",
    companySiteLink: "https://github.com/fast-crud/fast-crud",
    date: "2024",
    enable: false,
    icp: "",
    icpLink: "",
    settingShow: false,
  },
  footer: {
    enable: true,
    fixed: false,
  },
  header: {
    enable: true,
    hidden: false,
    menuAlign: "start",
    mode: "fixed",
  },
  logo: {
    enable: true,
    source: "./static/images/logo/logo.svg",
  },
  navigation: {
    accordion: true,
    split: true,
    styleType: "rounded",
  },
  shortcutKeys: {
    enable: true,
    globalLockScreen: true,
    globalLogout: true,
    globalPreferences: true,
    globalSearch: true,
  },
  sidebar: {
    autoActivateChild: true,
    collapsed: false,
    collapsedShowTitle: false,
    enable: true,
    expandOnHover: true,
    extraCollapse: false,
    hidden: false,
    width: 224,
  },
  tabbar: {
    draggable: true,
    enable: true,
    height: 38,
    keepAlive: true,
    maxCount: 0,
    middleClickToClose: false,
    persist: true,
    showIcon: true,
    showMaximize: true,
    showMore: true,
    styleType: "chrome",
    wheelable: true,
  },
  theme: {
    builtinType: "default",
    colorDestructive: "hsl(348 100% 61%)",
    colorPrimary: "hsl(212 100% 45%)",
    colorSuccess: "hsl(144 57% 58%)",
    colorWarning: "hsl(42 84% 61%)",
    mode: "light",
    radius: "0.5",
    semiDarkHeader: false,
    semiDarkSidebar: false,
  },
  transition: {
    enable: true,
    loading: false,
    name: "fade-slide",
    progress: true,
  },
  widget: {
    fullscreen: true,
    globalSearch: true,
    languageToggle: true,
    lockScreen: true,
    notification: false,
    refresh: true,
    sidebarToggle: true,
    themeToggle: true,
  },
};

export { defaultPreferences };
