
ALTER TABLE cd_site_info ADD COLUMN `ip_check` boolean;
ALTER TABLE cd_site_info ADD COLUMN `ip_count` bigint;
ALTER TABLE cd_site_info ADD COLUMN `ip_error_count` bigint;
ALTER TABLE cd_site_info MODIFY COLUMN `error` longtext  NULL;


CREATE TABLE `cd_site_ip`
(
  `id`                bigint PRIMARY KEY AUTO_INCREMENT NOT NULL,
  `user_id`           bigint,
  `site_id`           bigint,
  `ip_address`        varchar(100),
  `cert_domains`      varchar(10240),
  `cert_provider`     varchar(100),
  `cert_status`       varchar(100),
  `cert_expires_time` bigint,
  `last_check_time`   bigint,
  `check_status`      varchar(100),
  `error`             longtext,
  `remark`            varchar(4096),
  `from`              varchar(100),
  `disabled`          boolean  NOT NULL DEFAULT false,
  `create_time`       timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time`       timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE INDEX `index_site_ip_user_id` ON `cd_site_ip` (`user_id`);
CREATE INDEX `index_site_ip_site_id` ON `cd_site_ip` (`site_id`);
