import { utils } from '@certd/basic';

export async function request(config: any): Promise<any> {
  try {
    return await utils.http.request(config);
  } catch (e) {
    const data = e.data || e.response?.data;
    if (data) {
      throw new Error(data.message || data.msg || data.error || data);
    }
    if (e.statusText) {
      throw new Error(`请求失败:${e.request?.url}  ${e.status}  ${e.statusText}`);
    }
    throw e;
  }
}
