# 贡献指南

Language: [English](CONTRIBUTING.md) | 简体中文

首先，感谢您考虑为 `dio` 项目做出贡献！像这样的开源项目得以成长和繁荣，多亏了像您这样的贡献者。无论您是在修复错误、添加新功能、改进文档还是报告问题，每一份贡献都是宝贵和值得赞赏的。

本文档提供了一些指南，以帮助确保您的贡献尽可能有效。在提交您的贡献之前，请花一点时间阅读这些指南。

请记住，每个为这个项目做出贡献的人都需要遵循我们的行为准则。这有助于确保所有贡献者的积极和包容环境。

再次感谢您的贡献，我们期待看到您将为 `dio` 项目带来什么！

## 创建好的工单

> [!TIP]
> 在创建新问题之前，搜索已有的工单和拉取请求以避免重复是一个好习惯。

### 错误报告

报告错误时，请包括以下信息：

1. **标题**：简短描述性的错误标题。
2. **包**：指定有问题的包。
3. **版本**：您正在使用的包版本。
4. **操作系统**：出现问题的操作系统。
5. **适配器**：指定使用的适配器。
6. **`flutter doctor -v` 的输出**：使用 Flutter 时需要。
7. **Dart 版本**：您使用的 Dart 版本。
8. **重现步骤**：详细步骤说明如何重现错误。
9. **预期结果**：您期望发生的事情。
10. **实际结果**：实际发生的事情。包括日志、屏幕截图或任何其他相关信息。

### 功能请求

请求新功能时，请包括以下信息：

1. **标题**：功能请求的简短描述性标题。
2. **请求声明**：描述您认为 `dio` 项目能解决但目前没有解决的问题。
3. **解决方案头脑风暴**：分享您的想法，关于如何解决问题。如果您没有特定的解决方案，那也没关系！

> [!TIP]
> 记住，您提供的信息越多，我们就越容易理解和解决问题。感谢您的贡献！
> 请避免评论旧的、已关闭的工单。如果旧问题似乎与您的问题有关但并未完全解决您的问题，最好开一个新工单并引用旧的。

## 开发

此项目使用 [Melos](https://github.com/invertase/melos) 管理单体仓库和大多数任务。Melos 是一个为 Dart 和 Flutter 的多包项目优化工作流的工具。有关如何使用 Melos 的更多信息，请参阅 [Melos 文档](https://melos.invertase.dev)。

### 设置

开始之前，您需要全局安装 Melos：

```bash
dart pub global activate melos
```

在安装 Melos 后，可以克隆仓库并安装依赖项：

```bash
git clone https://github.com/cfug/dio.git
cd dio
melos bootstrap
```

## 提交更改

在以拉取请求提交您的更改之前，请确保格式化和分析您的代码并运行所有测试。以下是您应该了解的主要 melos 脚本：

### 代码质量

要格式化（和修复）所有包，请运行：
```bash
melos run format
# 或者
melos run format:fix
```

要分析所有包，请运行：
```bash
melos run analyze
```

### 测试

要运行所有测试，请使用：
```bash
melos run test
```

可以使用适当的脚本运行单个测试目标：
```bash
melos run test:vm
melos run test:web
melos run test:web:chrome
melos run test:web:firefox
```
